import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.StringTokenizer;
import javax.net.ssl.*;
import org.metastatic.jessie.PrivateCredentials;

class testclient
{
  public static void main(String[] argv) throws Throwable
  {
    if (argv.length < 2)
      {
        System.err.println("usage: testssl host port [protocol]");
        System.exit(1);
      }
    java.security.Security.setProperty("jessie.certificate.handler",
                                       "org.metastatic.callbacks.ConsoleCallbackHandler");
    //java.security.Security.setProperty("jessie.clientSessionContext.codec", "xml");
    java.security.Security.setProperty("jessie.clientSessionContext.xml.file",
                                       "sessions.xml.gz");
    java.security.Security.setProperty("jessie.clientSessionContext.xml.compress",
                                       "true");
    java.security.Security.setProperty("jessie.clientSessionContext.xml.password",
                                       "password");
    java.security.Security.setProperty("jessie.entropy.source", "/dev/urandom");
    java.security.Security.addProvider(new org.metastatic.jessie.provider.Jessie());
    java.security.Security.addProvider(new gnu.crypto.jce.GnuCrypto());
//     java.security.Security.addProvider(new gnu.security.pki.provider.GnuPki());
    SSLContext ctx = SSLContext.getInstance("SSLv3", "Jessie");
    ctx.init(null, null, null);
    SSLSocketFactory factory = ctx.getSocketFactory();
    Socket socket = factory.createSocket(argv[0], Integer.parseInt(argv[1]));
    ((SSLSocket) socket).setEnableSessionCreation(true);
    //if (argv.length > 2)
    //  ((SSLSocket) socket).setEnabledProtocols(new String[] { argv[2] });
    if (argv.length > 2)
      {
        StringTokenizer tok = new StringTokenizer(argv[2], ",");
        String[] suites = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens())
          {
            suites[i++] = tok.nextToken();
          }
        ((SSLSocket) socket).setEnabledCipherSuites(suites);
      }
    InputStream in = socket.getInputStream();
    OutputStream out = socket.getOutputStream();

    out.write("GET / HTTP/1.0\n\n".getBytes());
    out.flush();

    byte[] buf = new byte[16];
    int len = 0;
    while ((len = in.read(buf)) != -1)
      {
        System.out.write(buf, 0, len);
      }
    socket.close();
  }
}
