/* streams.c generated by valac 0.11.6, the Vala compiler
 * generated from streams.vala, do not modify */

/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus.h>
#include "gwibber.h"


#define TYPE_STREAMS_INTERFACE (streams_interface_get_type ())
#define STREAMS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STREAMS_INTERFACE, StreamsInterface))
#define IS_STREAMS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STREAMS_INTERFACE))
#define STREAMS_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_STREAMS_INTERFACE, StreamsInterfaceIface))

typedef struct _StreamsInterface StreamsInterface;
typedef struct _StreamsInterfaceIface StreamsInterfaceIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _StreamsInterfaceDBusProxy StreamsInterfaceDBusProxy;
typedef DBusGProxyClass StreamsInterfaceDBusProxyClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _StreamsInterfaceIface {
	GTypeInterface parent_iface;
	gchar* (*Messages) (StreamsInterface* self, const gchar* stream, const gchar* account, gint time, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _StreamsInterfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _GwibberStreamsPrivate {
	StreamsInterface* streams_service;
	GwibberUtils* utils;
};


static gpointer gwibber_streams_parent_class = NULL;

StreamsInterface* streams_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType streams_interface_get_type (void) G_GNUC_CONST;
gchar* streams_interface_Messages (StreamsInterface* self, const gchar* stream, const gchar* account, gint time, GError** error);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void streams_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _streams_interface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult streams_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_streams_interface_introspect (StreamsInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_streams_interface_property_get_all (StreamsInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_streams_interface_Messages (StreamsInterface* self, DBusConnection* connection, DBusMessage* message);
GType streams_interface_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult streams_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	STREAMS_INTERFACE_DBUS_PROXY_DUMMY_PROPERTY
};
static gchar* streams_interface_dbus_proxy_Messages (StreamsInterface* self, const gchar* stream, const gchar* account, gint time, GError** error);
static void streams_interface_dbus_proxy_streams_interface__interface_init (StreamsInterfaceIface* iface);
static void _vala_streams_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_streams_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GWIBBER_STREAMS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_STREAMS, GwibberStreamsPrivate))
enum  {
	GWIBBER_STREAMS_DUMMY_PROPERTY
};
#define GWIBBER_STREAMS_streams_name "com.Gwibber.Streams"
#define GWIBBER_STREAMS_streams_path "/com/gwibber/Streams"
#define GWIBBER_STREAMS_streams_iface "com.Gwibber.Streams"
static GObject * gwibber_streams_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
GwibberUtils* gwibber_utils_new (void);
GwibberUtils* gwibber_utils_construct (GType object_type);
void gwibber_utils_setup (GwibberUtils* self, const gchar* name, GError** error);
static void _gwibber_streams_streams_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self);
static void gwibber_streams_finalize (GObject* obj);

static const DBusObjectPathVTable _streams_interface_dbus_path_vtable = {_streams_interface_dbus_unregister, streams_interface_dbus_message};
static const _DBusObjectVTable _streams_interface_dbus_vtable = {streams_interface_dbus_register_object};

gchar* streams_interface_Messages (StreamsInterface* self, const gchar* stream, const gchar* account, gint time, GError** error) {
	return STREAMS_INTERFACE_GET_INTERFACE (self)->Messages (self, stream, account, time, error);
}


static void streams_interface_base_init (StreamsInterfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _streams_interface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_streams_interface_introspect (StreamsInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"com.Gwibber.Streams\">\n  <method name=\"Messages\">\n    <arg name=\"stream\" type=\"s\" direction=\"in\"/>\n    <arg name=\"account\" type=\"s\" direction=\"in\"/>\n    <arg name=\"time\" type=\"i\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_streams_interface_property_get_all (StreamsInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "com.Gwibber.Streams") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_streams_interface_Messages (StreamsInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	gchar* stream = NULL;
	const char* _tmp1_;
	gchar* account = NULL;
	const char* _tmp2_;
	gint time = 0;
	dbus_int32_t _tmp3_;
	gchar* result;
	DBusMessage* reply;
	const char* _tmp4_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "ssi")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	stream = g_strdup (_tmp1_);
	dbus_message_iter_get_basic (&iter, &_tmp2_);
	dbus_message_iter_next (&iter);
	account = g_strdup (_tmp2_);
	dbus_message_iter_get_basic (&iter, &_tmp3_);
	dbus_message_iter_next (&iter);
	time = _tmp3_;
	result = streams_interface_Messages (self, stream, account, time, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (stream);
	_g_free0 (account);
	_tmp4_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp4_);
	_g_free0 ( result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult streams_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_streams_interface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_streams_interface_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.Gwibber.Streams", "Messages")) {
		result = _dbus_streams_interface_Messages (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void streams_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_streams_interface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


GType streams_interface_get_type (void) {
	static volatile gsize streams_interface_type_id__volatile = 0;
	if (g_once_init_enter (&streams_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StreamsInterfaceIface), (GBaseInitFunc) streams_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType streams_interface_type_id;
		streams_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "StreamsInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (streams_interface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (streams_interface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &streams_interface_dbus_proxy_get_type);
		g_type_set_qdata (streams_interface_type_id, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_streams_interface_dbus_vtable));
		g_once_init_leave (&streams_interface_type_id__volatile, streams_interface_type_id);
	}
	return streams_interface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (StreamsInterfaceDBusProxy, streams_interface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_STREAMS_INTERFACE, streams_interface_dbus_proxy_streams_interface__interface_init) );
StreamsInterface* streams_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	StreamsInterface* self;
	self = g_object_new (streams_interface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "com.Gwibber.Streams", NULL);
	return self;
}


static GObject* streams_interface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (streams_interface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), streams_interface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s',interface='com.Gwibber.Streams'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult streams_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void streams_interface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((StreamsInterfaceDBusProxy*) self)->disposed) {
		return;
	}
	((StreamsInterfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), streams_interface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (streams_interface_dbus_proxy_parent_class)->dispose (self);
}


static void streams_interface_dbus_proxy_class_init (StreamsInterfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = streams_interface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = streams_interface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_streams_interface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_streams_interface_dbus_proxy_set_property;
}


static void streams_interface_dbus_proxy_init (StreamsInterfaceDBusProxy* self) {
}


static gchar* streams_interface_dbus_proxy_Messages (StreamsInterface* self, const gchar* stream, const gchar* account, gint time, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp24_;
	const char* _tmp25_;
	dbus_int32_t _tmp26_;
	gchar* _result;
	const char* _tmp27_;
	if (((StreamsInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.Gwibber.Streams", "Messages");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp24_ = stream;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp24_);
	_tmp25_ = account;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp25_);
	_tmp26_ = time;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp26_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp28_;
			_edomain = DBUS_GERROR;
			_tmp28_ = _dbus_error.name + 27;
			if (strcmp (_tmp28_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp28_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp28_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp28_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp28_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp28_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp28_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp28_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp28_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp28_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp28_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp28_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp28_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp28_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp28_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp28_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp28_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp28_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp28_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp28_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp28_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp28_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp28_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp28_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp28_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp28_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp28_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp28_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp28_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp28_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp28_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp28_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp28_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "s")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "s", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp27_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp27_);
	dbus_message_unref (_reply);
	return _result;
}


static void streams_interface_dbus_proxy_streams_interface__interface_init (StreamsInterfaceIface* iface) {
	iface->Messages = streams_interface_dbus_proxy_Messages;
}


static void _vala_streams_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void _vala_streams_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


GwibberStreams* gwibber_streams_construct (GType object_type) {
	GwibberStreams * self = NULL;
	self = (GwibberStreams*) g_object_new (object_type, NULL);
	return self;
}


GwibberStreams* gwibber_streams_new (void) {
	return gwibber_streams_construct (GWIBBER_TYPE_STREAMS);
}


/**
         * com.Gwibber.Streams
         **/
void gwibber_streams_streams_available (GwibberStreams* self, gboolean is_up) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "is-available", is_up);
}


static void _gwibber_streams_streams_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self) {
	gwibber_streams_streams_available (self, up);
}


static GObject * gwibber_streams_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberStreams * self;
	DBusGConnection* _tmp0_ = NULL;
	DBusGConnection* dbus_conn;
	StreamsInterface* _tmp1_;
	GwibberUtils* _tmp2_ = NULL;
	GwibberUtils* _tmp3_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (gwibber_streams_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_STREAMS (obj);
	_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	dbus_conn = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch20_g_error;
	}
	_tmp1_ = streams_interface_dbus_proxy_new (dbus_conn, GWIBBER_STREAMS_streams_name, GWIBBER_STREAMS_streams_path);
	_g_object_unref0 (self->priv->streams_service);
	self->priv->streams_service = _tmp1_;
	_tmp2_ = gwibber_utils_new ();
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->utils);
	self->priv->utils = _tmp3_;
	gwibber_utils_setup (self->priv->utils, GWIBBER_STREAMS_streams_name, &_inner_error_);
	if (_inner_error_ != NULL) {
		_dbus_g_connection_unref0 (dbus_conn);
		goto __catch20_g_error;
	}
	g_signal_connect_object (self->priv->utils, "available", (GCallback) _gwibber_streams_streams_available_gwibber_utils_available, self, 0);
	_dbus_g_connection_unref0 (dbus_conn);
	goto __finally20;
	__catch20_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("streams.vala:65: Unable to get Gwibber Streams");
		_g_error_free0 (e);
	}
	__finally20:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void gwibber_streams_class_init (GwibberStreamsClass * klass) {
	gwibber_streams_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberStreamsPrivate));
	G_OBJECT_CLASS (klass)->constructor = gwibber_streams_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_streams_finalize;
	/** 
	            Streams::is_available:
	            @arg0: The current state
	
	            Emitted when com.Gwibber.Streams availability state changes
	*/
	g_signal_new ("is_available", GWIBBER_TYPE_STREAMS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}


static void gwibber_streams_instance_init (GwibberStreams * self) {
	self->priv = GWIBBER_STREAMS_GET_PRIVATE (self);
}


static void gwibber_streams_finalize (GObject* obj) {
	GwibberStreams * self;
	self = GWIBBER_STREAMS (obj);
	_g_object_unref0 (self->priv->streams_service);
	_g_object_unref0 (self->priv->utils);
	G_OBJECT_CLASS (gwibber_streams_parent_class)->finalize (obj);
}


GType gwibber_streams_get_type (void) {
	static volatile gsize gwibber_streams_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_streams_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberStreamsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_streams_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberStreams), 0, (GInstanceInitFunc) gwibber_streams_instance_init, NULL };
		GType gwibber_streams_type_id;
		gwibber_streams_type_id = g_type_register_static (G_TYPE_OBJECT, "GwibberStreams", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_streams_type_id__volatile, gwibber_streams_type_id);
	}
	return gwibber_streams_type_id__volatile;
}



