/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * $Id: CompoundFontStorage.java 3523 2007-10-16 11:03:09Z tmorgner $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */

package org.jfree.fonts.merge;

import java.util.HashMap;

import org.jfree.fonts.registry.FontStorage;
import org.jfree.fonts.registry.FontRegistry;
import org.jfree.fonts.registry.FontMetrics;
import org.jfree.fonts.registry.FontIdentifier;
import org.jfree.fonts.registry.FontContext;
import org.jfree.fonts.registry.FontMetricsFactory;

/**
 * Creation-Date: 20.07.2007, 19:35:31
 *
 * @author Thomas Morgner
 */
public class CompoundFontStorage implements FontStorage
{
  private CompoundFontRegistry fontRegistry;
  private HashMap metricsFactories;

  public CompoundFontStorage()
  {
    this.fontRegistry = new CompoundFontRegistry();
    this.metricsFactories = new HashMap();
  }

  public void addRegistry(final FontRegistry registry)
  {
    fontRegistry.addRegistry(registry);
  }

  public FontRegistry getFontRegistry()
  {
    return fontRegistry;
  }

  public FontMetrics getFontMetrics(final FontIdentifier record, final FontContext context)
  {
    final CompoundFontIdentifier cid = (CompoundFontIdentifier) record;
    final FontRegistry registry = cid.getRegistry();
    FontMetricsFactory metricsFactory = (FontMetricsFactory) metricsFactories.get(registry);
    if (metricsFactory == null)
    {
      metricsFactory = registry.createMetricsFactory();
      metricsFactories.put (registry, metricsFactory);
    }

    return metricsFactory.createMetrics(cid.getIdentifier(), context);
  }
}
