#!/bin/sh

set -e

VERSION=$(dpkg-parsechangelog | sed -ne 's,^Version: \(.*\)-.*,\1,p')
SOURCE=$(dpkg-parsechangelog | sed -ne 's,Source: \(.*\),\1,p')

SVNROOT=http://svn.apache.org/repos/asf/commons/proper/compress/trunk
SVNREVISION=$(echo $VERSION | sed -e 's,.*svn,,')

DIR=$SOURCE
TAR=../${SOURCE}_${VERSION}.orig.tar.gz

svn export -r $SVNREVISION $SVNROOT $DIR
tar -c -z -f $TAR $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi

