#ifndef AIW_OPTIONS_H
#define AIW_OPTIONS_H

#include <tagcoll/Commandline.h>

namespace Tagcoll {
namespace commandline {

struct AIWOptions : public MainParser<CommandParser>
{
	struct HelpGroup : public OptionGroup
	{
		BoolOption* help;
		BoolOption* version;

		HelpGroup()
		{
			add(help = new BoolOption("help", 'h', "help"));
			add(version = new BoolOption("version", 0, "version"));
			help->shortNames.push_back('?');
			help->description = "print an help message and exit";
			version->description = "print the program version and exit";
			description = "Help options";
		}
		~HelpGroup()
		{
			delete help; delete version;
		}
	} helpGroup;
	struct OutputGroup : public OptionGroup
	{
		BoolOption* syslog;

		OutputGroup()
		{
			add(syslog = new BoolOption("syslog", 0, "syslog"));
			syslog->description = "send output to the system log";
			description = "Output options";
		}
	} outputGroup;

	struct Generic : public OptionParser
	{
		Generic(AIWOptions* cp) : OptionParser("")
		{
			add(&cp->helpGroup);
		}
	} generic;
	struct Help : public OptionParser
	{
		Help(AIWOptions*) : OptionParser("help")
		{
			usage = "[command]";
			description = "print help informations";
		}
	} help;
	struct Run : public OptionParser
	{
		Run(AIWOptions* cp) : OptionParser("run")
		{
			add(&cp->outputGroup);
			usage = "";
			description = "run all the actions once";
		}
	} run;
	struct Watch : public OptionParser
	{
		Watch(AIWOptions* cp) : OptionParser("watch")
		{
			add(&cp->outputGroup);
			usage = "";
			description = "watch the APT index for changes";
		}
	} watch;

	AIWOptions() : MainParser<CommandParser>("apt-index-watcher"),
		generic(this), help(this), run(this), watch(this)
	{
		add(generic);
		add(help);
		add(run);
		add(watch);

		usage = "<command> [options and arguments]";
		description = "Watches for changes in the APT index and run actions when it happens.\n";
		longDescription = "Watches for changes in the APT index and run actions when it happens.\n"
					  "The only action it currently runs is to rebuild the apt-front indexes.  "
					  "In the future, apt-index-watcher will support a proper hook system.";
	}
};

}
}

// vim:set ts=4 sw=4:
#endif
