; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV32I
; RUN: llc -mtriple=riscv32 -mattr=+experimental-zbp -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV32ZBP

define i32 @gorc1_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc1_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc1_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc.p a0, a0
; RV32ZBP-NEXT:    ret
  %and = shl i32 %a, 1
  %shl = and i32 %and, -1431655766
  %and1 = lshr i32 %a, 1
  %shr = and i32 %and1, 1431655765
  %or = or i32 %shr, %a
  %or2 = or i32 %or, %shl
  ret i32 %or2
}

define i64 @gorc1_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc1_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 1
; RV32I-NEXT:    srli a5, a0, 1
; RV32I-NEXT:    lui a6, 349525
; RV32I-NEXT:    addi a6, a6, 1365
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a1, a4, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc1_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc.p a0, a0
; RV32ZBP-NEXT:    orc.p a1, a1
; RV32ZBP-NEXT:    ret
  %and = shl i64 %a, 1
  %shl = and i64 %and, -6148914691236517206
  %and1 = lshr i64 %a, 1
  %shr = and i64 %and1, 6148914691236517205
  %or = or i64 %shr, %a
  %or2 = or i64 %or, %shl
  ret i64 %or2
}

define i32 @gorc2_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc2_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc2_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc2.n a0, a0
; RV32ZBP-NEXT:    ret
  %and = shl i32 %a, 2
  %shl = and i32 %and, -858993460
  %and1 = lshr i32 %a, 2
  %shr = and i32 %and1, 858993459
  %or = or i32 %shr, %a
  %or2 = or i32 %or, %shl
  ret i32 %or2
}

define i64 @gorc2_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc2_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    slli a3, a1, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 2
; RV32I-NEXT:    srli a5, a0, 2
; RV32I-NEXT:    lui a6, 209715
; RV32I-NEXT:    addi a6, a6, 819
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a1, a4, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc2_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc2.n a0, a0
; RV32ZBP-NEXT:    orc2.n a1, a1
; RV32ZBP-NEXT:    ret
  %and = shl i64 %a, 2
  %shl = and i64 %and, -3689348814741910324
  %and1 = lshr i64 %a, 2
  %shr = and i64 %and1, 3689348814741910323
  %or = or i64 %shr, %a
  %or2 = or i64 %or, %shl
  ret i64 %or2
}

define i32 @gorc3_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc3_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc3_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc.n a0, a0
; RV32ZBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shr1, %a
  %or1b = or i32 %or1, %shl1
  %and2 = shl i32 %or1b, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1b, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shr2, %or1b
  %or2b = or i32 %or2, %shl2
  ret i32 %or2b
}

define i64 @gorc3_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc3_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 1
; RV32I-NEXT:    slli a3, a0, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a0, 1
; RV32I-NEXT:    srli a5, a1, 1
; RV32I-NEXT:    lui a6, 349525
; RV32I-NEXT:    addi a6, a6, 1365
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a0, a4, a0
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    slli a3, a1, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 2
; RV32I-NEXT:    srli a5, a0, 2
; RV32I-NEXT:    lui a6, 209715
; RV32I-NEXT:    addi a6, a6, 819
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a1, a4, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc3_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc.n a0, a0
; RV32ZBP-NEXT:    orc.n a1, a1
; RV32ZBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shr1, %a
  %or1b = or i64 %or1, %shl1
  %and2 = shl i64 %or1b, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1b, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shr2, %or1b
  %or2b = or i64 %or2, %shl2
  ret i64 %or2b
}

define i32 @gorc4_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc4_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    lui a3, 61681
; RV32I-NEXT:    addi a3, a3, -241
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc4_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc4.b a0, a0
; RV32ZBP-NEXT:    ret
  %and = shl i32 %a, 4
  %shl = and i32 %and, -252645136
  %and1 = lshr i32 %a, 4
  %shr = and i32 %and1, 252645135
  %or = or i32 %shr, %a
  %or2 = or i32 %or, %shl
  ret i32 %or2
}

define i64 @gorc4_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc4_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 4
; RV32I-NEXT:    srli a5, a0, 4
; RV32I-NEXT:    lui a6, 61681
; RV32I-NEXT:    addi a6, a6, -241
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a1, a4, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc4_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc4.b a0, a0
; RV32ZBP-NEXT:    orc4.b a1, a1
; RV32ZBP-NEXT:    ret
  %and = shl i64 %a, 4
  %shl = and i64 %and, -1085102592571150096
  %and1 = lshr i64 %a, 4
  %shr = and i64 %and1, 1085102592571150095
  %or = or i64 %shr, %a
  %or2 = or i64 %or, %shl
  ret i64 %or2
}

define i32 @gorc5_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc5_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    lui a3, 61681
; RV32I-NEXT:    addi a3, a3, -241
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc5_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    gorci a0, a0, 5
; RV32ZBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shr1, %a
  %or1b = or i32 %or1, %shl1
  %and2 = shl i32 %or1b, 4
  %shl2 = and i32 %and2, -252645136
  %and2b = lshr i32 %or1b, 4
  %shr2 = and i32 %and2b, 252645135
  %or2 = or i32 %shr2, %or1b
  %or2b = or i32 %or2, %shl2
  ret i32 %or2b
}

define i64 @gorc5_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc5_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 1
; RV32I-NEXT:    slli a3, a0, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a0, 1
; RV32I-NEXT:    srli a5, a1, 1
; RV32I-NEXT:    lui a6, 349525
; RV32I-NEXT:    addi a6, a6, 1365
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a0, a4, a0
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 4
; RV32I-NEXT:    srli a5, a0, 4
; RV32I-NEXT:    lui a6, 61681
; RV32I-NEXT:    addi a6, a6, -241
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a1, a4, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc5_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    gorci a0, a0, 5
; RV32ZBP-NEXT:    gorci a1, a1, 5
; RV32ZBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shr1, %a
  %or1b = or i64 %or1, %shl1
  %and2 = shl i64 %or1b, 4
  %shl2 = and i64 %and2, -1085102592571150096
  %and2b = lshr i64 %or1b, 4
  %shr2 = and i64 %and2b, 1085102592571150095
  %or2 = or i64 %shr2, %or1b
  %or2b = or i64 %or2, %shl2
  ret i64 %or2b
}

define i32 @gorc6_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc6_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    lui a3, 61681
; RV32I-NEXT:    addi a3, a3, -241
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc6_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc2.b a0, a0
; RV32ZBP-NEXT:    ret
  %and1 = shl i32 %a, 2
  %shl1 = and i32 %and1, -858993460
  %and1b = lshr i32 %a, 2
  %shr1 = and i32 %and1b, 858993459
  %or1 = or i32 %shr1, %a
  %or1b = or i32 %or1, %shl1
  %and2 = shl i32 %or1b, 4
  %shl2 = and i32 %and2, -252645136
  %and2b = lshr i32 %or1b, 4
  %shr2 = and i32 %and2b, 252645135
  %or2 = or i32 %shr2, %or1b
  %or2b = or i32 %or2, %shl2
  ret i32 %or2b
}

define i64 @gorc6_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc6_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 2
; RV32I-NEXT:    slli a3, a0, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a0, 2
; RV32I-NEXT:    srli a5, a1, 2
; RV32I-NEXT:    lui a6, 209715
; RV32I-NEXT:    addi a6, a6, 819
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a0, a4, a0
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 4
; RV32I-NEXT:    srli a5, a0, 4
; RV32I-NEXT:    lui a6, 61681
; RV32I-NEXT:    addi a6, a6, -241
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a1, a4, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc6_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc2.b a0, a0
; RV32ZBP-NEXT:    orc2.b a1, a1
; RV32ZBP-NEXT:    ret
  %and1 = shl i64 %a, 2
  %shl1 = and i64 %and1, -3689348814741910324
  %and1b = lshr i64 %a, 2
  %shr1 = and i64 %and1b, 3689348814741910323
  %or1 = or i64 %shr1, %a
  %or1b = or i64 %or1, %shl1
  %and2 = shl i64 %or1b, 4
  %shl2 = and i64 %and2, -1085102592571150096
  %and2b = lshr i64 %or1b, 4
  %shr2 = and i64 %and2b, 1085102592571150095
  %or2 = or i64 %shr2, %or1b
  %or2b = or i64 %or2, %shl2
  ret i64 %or2b
}

define i32 @gorc7_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc7_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    lui a3, 61681
; RV32I-NEXT:    addi a3, a3, -241
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc7_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc.b a0, a0
; RV32ZBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shr1, %a
  %or1b = or i32 %or1, %shl1
  %and2 = shl i32 %or1b, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1b, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shr2, %or1b
  %or2b = or i32 %or2, %shl2
  %and3 = shl i32 %or2b, 4
  %shl3 = and i32 %and3, -252645136
  %and3b = lshr i32 %or2b, 4
  %shr3 = and i32 %and3b, 252645135
  %or3 = or i32 %shr3, %or2b
  %or3b = or i32 %or3, %shl3
  ret i32 %or3b
}

define i64 @gorc7_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc7_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 1
; RV32I-NEXT:    srli a5, a0, 1
; RV32I-NEXT:    lui a6, 349525
; RV32I-NEXT:    addi a6, a6, 1365
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a1, a4, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    slli a2, a1, 2
; RV32I-NEXT:    slli a3, a0, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a0, 2
; RV32I-NEXT:    srli a5, a1, 2
; RV32I-NEXT:    lui a6, 209715
; RV32I-NEXT:    addi a6, a6, 819
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a0, a4, a0
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 4
; RV32I-NEXT:    srli a5, a0, 4
; RV32I-NEXT:    lui a6, 61681
; RV32I-NEXT:    addi a6, a6, -241
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a1, a4, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc7_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc.b a0, a0
; RV32ZBP-NEXT:    orc.b a1, a1
; RV32ZBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shr1, %a
  %or1b = or i64 %or1, %shl1
  %and2 = shl i64 %or1b, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1b, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shr2, %or1b
  %or2b = or i64 %or2, %shl2
  %and3 = shl i64 %or2b, 4
  %shl3 = and i64 %and3, -1085102592571150096
  %and3b = lshr i64 %or2b, 4
  %shr3 = and i64 %and3b, 1085102592571150095
  %or3 = or i64 %shr3, %or2b
  %or3b = or i64 %or3, %shl3
  ret i64 %or3b
}

define i32 @gorc8_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc8_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    lui a2, 1044496
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    addi a3, a3, 255
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc8_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc8.h a0, a0
; RV32ZBP-NEXT:    ret
  %and = shl i32 %a, 8
  %shl = and i32 %and, -16711936
  %and1 = lshr i32 %a, 8
  %shr = and i32 %and1, 16711935
  %or = or i32 %shr, %a
  %or2 = or i32 %or, %shl
  ret i32 %or2
}

define i64 @gorc8_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc8_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    slli a3, a1, 8
; RV32I-NEXT:    lui a4, 1044496
; RV32I-NEXT:    addi a4, a4, -256
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 8
; RV32I-NEXT:    srli a5, a0, 8
; RV32I-NEXT:    lui a6, 4080
; RV32I-NEXT:    addi a6, a6, 255
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a1, a4, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc8_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc8.h a0, a0
; RV32ZBP-NEXT:    orc8.h a1, a1
; RV32ZBP-NEXT:    ret
  %and = shl i64 %a, 8
  %shl = and i64 %and, -71777214294589696
  %and1 = lshr i64 %a, 8
  %shr = and i64 %and1, 71777214294589695
  %or = or i64 %shr, %a
  %or2 = or i64 %or, %shl
  ret i64 %or2
}

define i32 @gorc12_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc12_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    lui a3, 61681
; RV32I-NEXT:    addi a3, a3, -241
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    lui a2, 1044496
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    addi a3, a3, 255
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc12_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc4.h a0, a0
; RV32ZBP-NEXT:    ret
  %and1 = shl i32 %a, 4
  %shl1 = and i32 %and1, -252645136
  %and1b = lshr i32 %a, 4
  %shr1 = and i32 %and1b, 252645135
  %or1 = or i32 %shr1, %a
  %or1b = or i32 %or1, %shl1
  %and2 = shl i32 %or1b, 8
  %shl2 = and i32 %and2, -16711936
  %and2b = lshr i32 %or1b, 8
  %shr2 = and i32 %and2b, 16711935
  %or2 = or i32 %shr2, %or1b
  %or2b = or i32 %or2, %shl2
  ret i32 %or2b
}

define i64 @gorc12_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc12_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 4
; RV32I-NEXT:    slli a3, a0, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a0, 4
; RV32I-NEXT:    srli a5, a1, 4
; RV32I-NEXT:    lui a6, 61681
; RV32I-NEXT:    addi a6, a6, -241
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a0, a4, a0
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    slli a3, a1, 8
; RV32I-NEXT:    lui a4, 1044496
; RV32I-NEXT:    addi a4, a4, -256
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 8
; RV32I-NEXT:    srli a5, a0, 8
; RV32I-NEXT:    lui a6, 4080
; RV32I-NEXT:    addi a6, a6, 255
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a1, a4, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc12_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc4.h a0, a0
; RV32ZBP-NEXT:    orc4.h a1, a1
; RV32ZBP-NEXT:    ret
  %and1 = shl i64 %a, 4
  %shl1 = and i64 %and1, -1085102592571150096
  %and1b = lshr i64 %a, 4
  %shr1 = and i64 %and1b, 1085102592571150095
  %or1 = or i64 %shr1, %a
  %or1b = or i64 %or1, %shl1
  %and2 = shl i64 %or1b, 8
  %shl2 = and i64 %and2, -71777214294589696
  %and2b = lshr i64 %or1b, 8
  %shr2 = and i64 %and2b, 71777214294589695
  %or2 = or i64 %shr2, %or1b
  %or2b = or i64 %or2, %shl2
  ret i64 %or2b
}

define i32 @gorc14_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc14_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    lui a3, 61681
; RV32I-NEXT:    addi a3, a3, -241
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    lui a2, 1044496
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    addi a3, a3, 255
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc14_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc2.h a0, a0
; RV32ZBP-NEXT:    ret
  %and1 = shl i32 %a, 2
  %shl1 = and i32 %and1, -858993460
  %and1b = lshr i32 %a, 2
  %shr1 = and i32 %and1b, 858993459
  %or1 = or i32 %shr1, %a
  %or1b = or i32 %or1, %shl1
  %and2 = shl i32 %or1b, 4
  %shl2 = and i32 %and2, -252645136
  %and2b = lshr i32 %or1b, 4
  %shr2 = and i32 %and2b, 252645135
  %or2 = or i32 %shr2, %or1b
  %or2b = or i32 %or2, %shl2
  %and3 = shl i32 %or2b, 8
  %shl3 = and i32 %and3, -16711936
  %and3b = lshr i32 %or2b, 8
  %shr3 = and i32 %and3b, 16711935
  %or3 = or i32 %shr3, %or2b
  %or3b = or i32 %or3, %shl3
  ret i32 %or3b
}

define i64 @gorc14_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc14_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    slli a3, a1, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 2
; RV32I-NEXT:    srli a5, a0, 2
; RV32I-NEXT:    lui a6, 209715
; RV32I-NEXT:    addi a6, a6, 819
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a1, a4, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    slli a2, a1, 4
; RV32I-NEXT:    slli a3, a0, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a0, 4
; RV32I-NEXT:    srli a5, a1, 4
; RV32I-NEXT:    lui a6, 61681
; RV32I-NEXT:    addi a6, a6, -241
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a0, a4, a0
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    slli a3, a1, 8
; RV32I-NEXT:    lui a4, 1044496
; RV32I-NEXT:    addi a4, a4, -256
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 8
; RV32I-NEXT:    srli a5, a0, 8
; RV32I-NEXT:    lui a6, 4080
; RV32I-NEXT:    addi a6, a6, 255
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a1, a4, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc14_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc2.h a0, a0
; RV32ZBP-NEXT:    orc2.h a1, a1
; RV32ZBP-NEXT:    ret
  %and1 = shl i64 %a, 2
  %shl1 = and i64 %and1, -3689348814741910324
  %and1b = lshr i64 %a, 2
  %shr1 = and i64 %and1b, 3689348814741910323
  %or1 = or i64 %shr1, %a
  %or1b = or i64 %or1, %shl1
  %and2 = shl i64 %or1b, 4
  %shl2 = and i64 %and2, -1085102592571150096
  %and2b = lshr i64 %or1b, 4
  %shr2 = and i64 %and2b, 1085102592571150095
  %or2 = or i64 %shr2, %or1b
  %or2b = or i64 %or2, %shl2
  %and3 = shl i64 %or2b, 8
  %shl3 = and i64 %and3, -71777214294589696
  %and3b = lshr i64 %or2b, 8
  %shr3 = and i64 %and3b, 71777214294589695
  %or3 = or i64 %shr3, %or2b
  %or3b = or i64 %or3, %shl3
  ret i64 %or3b
}

define i32 @gorc16_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc16_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    srli a2, a0, 16
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc16_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc16 a0, a0
; RV32ZBP-NEXT:    ret
  %shl = shl i32 %a, 16
  %shr = lshr i32 %a, 16
  %or = or i32 %shr, %a
  %or2 = or i32 %or, %shl
  ret i32 %or2
}

define i32 @gorc16_rotl_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc16_rotl_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    slli a2, a0, 16
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc16_rotl_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc16 a0, a0
; RV32ZBP-NEXT:    ret
  %rot = tail call i32 @llvm.fshl.i32(i32 %a, i32 %a, i32 16)
  %or = or i32 %rot, %a
  ret i32 %or
}

define i32 @gorc16_rotr_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc16_rotr_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    srli a2, a0, 16
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc16_rotr_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc16 a0, a0
; RV32ZBP-NEXT:    ret
  %rot = tail call i32 @llvm.fshr.i32(i32 %a, i32 %a, i32 16)
  %or = or i32 %rot, %a
  ret i32 %or
}

define i64 @gorc16_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc16_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 16
; RV32I-NEXT:    slli a3, a0, 16
; RV32I-NEXT:    srli a4, a0, 16
; RV32I-NEXT:    srli a5, a1, 16
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    or a0, a4, a0
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc16_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc16 a0, a0
; RV32ZBP-NEXT:    orc16 a1, a1
; RV32ZBP-NEXT:    ret
  %and = shl i64 %a, 16
  %shl = and i64 %and, -281470681808896
  %and1 = lshr i64 %a, 16
  %shr = and i64 %and1, 281470681808895
  %or = or i64 %shr, %a
  %or2 = or i64 %or, %shl
  ret i64 %or2
}

; gorc2, gorc2 -> gorc2
define i32 @gorc2b_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc2b_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a3, a0, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a1, a0, a1
; RV32I-NEXT:    slli a0, a0, 2
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    srli a2, a1, 2
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc2b_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    srli a1, a0, 2
; RV32ZBP-NEXT:    or a1, a1, a0
; RV32ZBP-NEXT:    orc2.n a0, a0
; RV32ZBP-NEXT:    slli a1, a1, 2
; RV32ZBP-NEXT:    lui a2, 838861
; RV32ZBP-NEXT:    addi a2, a2, -820
; RV32ZBP-NEXT:    and a1, a1, a2
; RV32ZBP-NEXT:    srli a2, a0, 2
; RV32ZBP-NEXT:    lui a3, 209715
; RV32ZBP-NEXT:    addi a3, a3, 819
; RV32ZBP-NEXT:    and a2, a2, a3
; RV32ZBP-NEXT:    or a0, a2, a0
; RV32ZBP-NEXT:    or a0, a0, a1
; RV32ZBP-NEXT:    ret
  %and1 = shl i32 %a, 2
  %shl1 = and i32 %and1, -858993460
  %and1b = lshr i32 %a, 2
  %shr1 = and i32 %and1b, 858993459
  %or1 = or i32 %shr1, %a
  %or1b = or i32 %or1, %shl1
  %and2 = shl i32 %or1b, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1b, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shr2, %or1b
  %or2b = or i32 %or2, %shl2
  ret i32 %or2b
}

; gorc2, gorc2 -> gorc2
define i64 @gorc2b_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc2b_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    slli a3, a1, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a5, a1, 2
; RV32I-NEXT:    srli a6, a0, 2
; RV32I-NEXT:    lui a7, 209715
; RV32I-NEXT:    addi a7, a7, 819
; RV32I-NEXT:    and a6, a6, a7
; RV32I-NEXT:    and a5, a5, a7
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    or a0, a6, a0
; RV32I-NEXT:    or a2, a0, a2
; RV32I-NEXT:    or a3, a1, a3
; RV32I-NEXT:    slli a0, a0, 2
; RV32I-NEXT:    slli a1, a1, 2
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    srli a4, a3, 2
; RV32I-NEXT:    srli a5, a2, 2
; RV32I-NEXT:    and a5, a5, a7
; RV32I-NEXT:    and a4, a4, a7
; RV32I-NEXT:    or a3, a4, a3
; RV32I-NEXT:    or a2, a5, a2
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc2b_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    srli a2, a1, 2
; RV32ZBP-NEXT:    srli a3, a0, 2
; RV32ZBP-NEXT:    lui a4, 209715
; RV32ZBP-NEXT:    addi a4, a4, 819
; RV32ZBP-NEXT:    and a3, a3, a4
; RV32ZBP-NEXT:    or a3, a3, a0
; RV32ZBP-NEXT:    or a2, a2, a1
; RV32ZBP-NEXT:    orc2.n a1, a1
; RV32ZBP-NEXT:    orc2.n a0, a0
; RV32ZBP-NEXT:    slli a2, a2, 2
; RV32ZBP-NEXT:    slli a3, a3, 2
; RV32ZBP-NEXT:    lui a5, 838861
; RV32ZBP-NEXT:    addi a5, a5, -820
; RV32ZBP-NEXT:    and a3, a3, a5
; RV32ZBP-NEXT:    and a2, a2, a5
; RV32ZBP-NEXT:    srli a5, a0, 2
; RV32ZBP-NEXT:    srli a6, a1, 2
; RV32ZBP-NEXT:    and a6, a6, a4
; RV32ZBP-NEXT:    and a4, a5, a4
; RV32ZBP-NEXT:    or a0, a4, a0
; RV32ZBP-NEXT:    or a1, a6, a1
; RV32ZBP-NEXT:    or a1, a1, a2
; RV32ZBP-NEXT:    or a0, a0, a3
; RV32ZBP-NEXT:    ret
  %and1 = shl i64 %a, 2
  %shl1 = and i64 %and1, -3689348814741910324
  %and1b = lshr i64 %a, 2
  %shr1 = and i64 %and1b, 3689348814741910323
  %or1 = or i64 %shr1, %a
  %or1b = or i64 %or1, %shl1
  %and2 = shl i64 %or1b, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1b, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shr2, %or1b
  %or2b = or i64 %or2, %shl2
  ret i64 %or2b
}

; gorc1, gorc2, gorc1 -> gorc2
define i32 @gorc3b_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc3b_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a3, a0, 1
; RV32I-NEXT:    lui a4, 349525
; RV32I-NEXT:    addi a4, a4, 1365
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a3, 838861
; RV32I-NEXT:    addi a3, a3, -820
; RV32I-NEXT:    and a1, a1, a3
; RV32I-NEXT:    srli a3, a0, 2
; RV32I-NEXT:    lui a5, 209715
; RV32I-NEXT:    addi a5, a5, 819
; RV32I-NEXT:    and a3, a3, a5
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc3b_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc.n a0, a0
; RV32ZBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shr1, %a
  %or1b = or i32 %or1, %shl1
  %and2 = shl i32 %or1b, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1b, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shr2, %or1b
  %or2b = or i32 %or2, %shl2
  %and3 = shl i32 %or2b, 1
  %shl3 = and i32 %and3, -1431655766
  %and3b = lshr i32 %or2b, 1
  %shr3 = and i32 %and3b, 1431655765
  %or3 = or i32 %shr3, %or2b
  %or3b = or i32 %or3, %shl3
  ret i32 %or3b
}

; gorc1, gorc2, gorc1 -> gorc2
define i64 @gorc3b_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc3b_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a5, a1, 1
; RV32I-NEXT:    srli a6, a0, 1
; RV32I-NEXT:    lui a7, 349525
; RV32I-NEXT:    addi a7, a7, 1365
; RV32I-NEXT:    and a6, a6, a7
; RV32I-NEXT:    and a5, a5, a7
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    or a0, a6, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    slli a2, a1, 2
; RV32I-NEXT:    slli a3, a0, 2
; RV32I-NEXT:    lui a5, 838861
; RV32I-NEXT:    addi a5, a5, -820
; RV32I-NEXT:    and a3, a3, a5
; RV32I-NEXT:    and a2, a2, a5
; RV32I-NEXT:    srli a5, a0, 2
; RV32I-NEXT:    srli a6, a1, 2
; RV32I-NEXT:    lui t0, 209715
; RV32I-NEXT:    addi t0, t0, 819
; RV32I-NEXT:    and a6, a6, t0
; RV32I-NEXT:    and a5, a5, t0
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a1, a6, a1
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 1
; RV32I-NEXT:    srli a5, a0, 1
; RV32I-NEXT:    and a5, a5, a7
; RV32I-NEXT:    and a4, a4, a7
; RV32I-NEXT:    or a1, a4, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: gorc3b_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    orc.n a0, a0
; RV32ZBP-NEXT:    orc.n a1, a1
; RV32ZBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shr1, %a
  %or1b = or i64 %or1, %shl1
  %and2 = shl i64 %or1b, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1b, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shr2, %or1b
  %or2b = or i64 %or2, %shl2
  %and3 = shl i64 %or2b, 1
  %shl3 = and i64 %and3, -6148914691236517206
  %and3b = lshr i64 %or2b, 1
  %shr3 = and i64 %and3b, 6148914691236517205
  %or3 = or i64 %shr3, %or2b
  %or3b = or i64 %or3, %shl3
  ret i64 %or3b
}

define i32 @grev1_i32(i32 %a) nounwind {
; RV32I-LABEL: grev1_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev1_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev.p a0, a0
; RV32ZBP-NEXT:    ret
  %and = shl i32 %a, 1
  %shl = and i32 %and, -1431655766
  %and1 = lshr i32 %a, 1
  %shr = and i32 %and1, 1431655765
  %or = or i32 %shl, %shr
  ret i32 %or
}

define i64 @grev1_i64(i64 %a) nounwind {
; RV32I-LABEL: grev1_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    lui a4, 349525
; RV32I-NEXT:    addi a4, a4, 1365
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev1_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev.p a0, a0
; RV32ZBP-NEXT:    rev.p a1, a1
; RV32ZBP-NEXT:    ret
  %and = shl i64 %a, 1
  %shl = and i64 %and, -6148914691236517206
  %and1 = lshr i64 %a, 1
  %shr = and i64 %and1, 6148914691236517205
  %or = or i64 %shl, %shr
  ret i64 %or
}

define i32 @grev2_i32(i32 %a) nounwind {
; RV32I-LABEL: grev2_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev2_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev2.n a0, a0
; RV32ZBP-NEXT:    ret
  %and = shl i32 %a, 2
  %shl = and i32 %and, -858993460
  %and1 = lshr i32 %a, 2
  %shr = and i32 %and1, 858993459
  %or = or i32 %shl, %shr
  ret i32 %or
}

define i64 @grev2_i64(i64 %a) nounwind {
; RV32I-LABEL: grev2_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    slli a3, a1, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev2_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev2.n a0, a0
; RV32ZBP-NEXT:    rev2.n a1, a1
; RV32ZBP-NEXT:    ret
  %and = shl i64 %a, 2
  %shl = and i64 %and, -3689348814741910324
  %and1 = lshr i64 %a, 2
  %shr = and i64 %and1, 3689348814741910323
  %or = or i64 %shl, %shr
  ret i64 %or
}

define i32 @grev3_i32(i32 %a) nounwind {
; RV32I-LABEL: grev3_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev3_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev.n a0, a0
; RV32ZBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shl2, %shr2
  ret i32 %or2
}

define i64 @grev3_i64(i64 %a) nounwind {
; RV32I-LABEL: grev3_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 1
; RV32I-NEXT:    slli a3, a0, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a4, 349525
; RV32I-NEXT:    addi a4, a4, 1365
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    slli a3, a1, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev3_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev.n a0, a0
; RV32ZBP-NEXT:    rev.n a1, a1
; RV32ZBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shl1, %shr1
  %and2 = shl i64 %or1, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shl2, %shr2
  ret i64 %or2
}

define i32 @grev4_i32(i32 %a) nounwind {
; RV32I-LABEL: grev4_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev4_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev4.b a0, a0
; RV32ZBP-NEXT:    ret
  %and = shl i32 %a, 4
  %shl = and i32 %and, -252645136
  %and1 = lshr i32 %a, 4
  %shr = and i32 %and1, 252645135
  %or = or i32 %shl, %shr
  ret i32 %or
}

define i64 @grev4_i64(i64 %a) nounwind {
; RV32I-LABEL: grev4_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    lui a4, 61681
; RV32I-NEXT:    addi a4, a4, -241
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev4_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev4.b a0, a0
; RV32ZBP-NEXT:    rev4.b a1, a1
; RV32ZBP-NEXT:    ret
  %and = shl i64 %a, 4
  %shl = and i64 %and, -1085102592571150096
  %and1 = lshr i64 %a, 4
  %shr = and i64 %and1, 1085102592571150095
  %or = or i64 %shl, %shr
  ret i64 %or
}

define i32 @grev5_i32(i32 %a) nounwind {
; RV32I-LABEL: grev5_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev5_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    grevi a0, a0, 5
; RV32ZBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 4
  %shl2 = and i32 %and2, -252645136
  %and2b = lshr i32 %or1, 4
  %shr2 = and i32 %and2b, 252645135
  %or2 = or i32 %shl2, %shr2
  ret i32 %or2
}

define i64 @grev5_i64(i64 %a) nounwind {
; RV32I-LABEL: grev5_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 1
; RV32I-NEXT:    slli a3, a0, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a4, 349525
; RV32I-NEXT:    addi a4, a4, 1365
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    lui a4, 61681
; RV32I-NEXT:    addi a4, a4, -241
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev5_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    grevi a0, a0, 5
; RV32ZBP-NEXT:    grevi a1, a1, 5
; RV32ZBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shl1, %shr1

  %and2 = shl i64 %or1, 4
  %shl2 = and i64 %and2, -1085102592571150096
  %and2b = lshr i64 %or1, 4
  %shr2 = and i64 %and2b, 1085102592571150095
  %or2 = or i64 %shl2, %shr2
  ret i64 %or2
}

define i32 @grev6_i32(i32 %a) nounwind {
; RV32I-LABEL: grev6_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev6_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev2.b a0, a0
; RV32ZBP-NEXT:    ret
  %and1 = shl i32 %a, 2
  %shl1 = and i32 %and1, -858993460
  %and1b = lshr i32 %a, 2
  %shr1 = and i32 %and1b, 858993459
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 4
  %shl2 = and i32 %and2, -252645136
  %and2b = lshr i32 %or1, 4
  %shr2 = and i32 %and2b, 252645135
  %or2 = or i32 %shl2, %shr2
  ret i32 %or2
}

define i64 @grev6_i64(i64 %a) nounwind {
; RV32I-LABEL: grev6_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 2
; RV32I-NEXT:    slli a3, a0, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    lui a4, 61681
; RV32I-NEXT:    addi a4, a4, -241
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev6_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev2.b a0, a0
; RV32ZBP-NEXT:    rev2.b a1, a1
; RV32ZBP-NEXT:    ret
  %and1 = shl i64 %a, 2
  %shl1 = and i64 %and1, -3689348814741910324
  %and1b = lshr i64 %a, 2
  %shr1 = and i64 %and1b, 3689348814741910323
  %or1 = or i64 %shl1, %shr1
  %and2 = shl i64 %or1, 4
  %shl2 = and i64 %and2, -1085102592571150096
  %and2b = lshr i64 %or1, 4
  %shr2 = and i64 %and2b, 1085102592571150095
  %or2 = or i64 %shl2, %shr2
  ret i64 %or2
}

define i32 @grev7_i32(i32 %a) nounwind {
; RV32I-LABEL: grev7_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev7_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev.b a0, a0
; RV32ZBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shl2, %shr2
  %and3 = shl i32 %or2, 4
  %shl3 = and i32 %and3, -252645136
  %and3b = lshr i32 %or2, 4
  %shr3 = and i32 %and3b, 252645135
  %or3 = or i32 %shl3, %shr3
  ret i32 %or3
}

define i64 @grev7_i64(i64 %a) nounwind {
; RV32I-LABEL: grev7_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    lui a4, 349525
; RV32I-NEXT:    addi a4, a4, 1365
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    slli a2, a1, 2
; RV32I-NEXT:    slli a3, a0, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    lui a4, 61681
; RV32I-NEXT:    addi a4, a4, -241
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev7_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev.b a0, a0
; RV32ZBP-NEXT:    rev.b a1, a1
; RV32ZBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shl1, %shr1
  %and2 = shl i64 %or1, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shl2, %shr2
  %and3 = shl i64 %or2, 4
  %shl3 = and i64 %and3, -1085102592571150096
  %and3b = lshr i64 %or2, 4
  %shr3 = and i64 %and3b, 1085102592571150095
  %or3 = or i64 %shl3, %shr3
  ret i64 %or3
}

define i32 @grev8_i32(i32 %a) nounwind {
; RV32I-LABEL: grev8_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    lui a2, 1044496
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    lui a2, 4080
; RV32I-NEXT:    addi a2, a2, 255
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev8_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev8.h a0, a0
; RV32ZBP-NEXT:    ret
  %and = shl i32 %a, 8
  %shl = and i32 %and, -16711936
  %and1 = lshr i32 %a, 8
  %shr = and i32 %and1, 16711935
  %or = or i32 %shl, %shr
  ret i32 %or
}

define i32 @grev12_i32(i32 %a) nounwind {
; RV32I-LABEL: grev12_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    lui a2, 1044496
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    lui a2, 4080
; RV32I-NEXT:    addi a2, a2, 255
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev12_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev4.h a0, a0
; RV32ZBP-NEXT:    ret
  %and1 = shl i32 %a, 4
  %shl1 = and i32 %and1, -252645136
  %and1b = lshr i32 %a, 4
  %shr1 = and i32 %and1b, 252645135
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 8
  %shl2 = and i32 %and2, -16711936
  %and2b = lshr i32 %or1, 8
  %shr2 = and i32 %and2b, 16711935
  %or2 = or i32 %shl2, %shr2
  ret i32 %or2
}

define i32 @grev14_i32(i32 %a) nounwind {
; RV32I-LABEL: grev14_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    lui a2, 1044496
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    lui a2, 4080
; RV32I-NEXT:    addi a2, a2, 255
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev14_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev2.h a0, a0
; RV32ZBP-NEXT:    ret
  %and1 = shl i32 %a, 2
  %shl1 = and i32 %and1, -858993460
  %and1b = lshr i32 %a, 2
  %shr1 = and i32 %and1b, 858993459
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 4
  %shl2 = and i32 %and2, -252645136
  %and2b = lshr i32 %or1, 4
  %shr2 = and i32 %and2b, 252645135
  %or2 = or i32 %shl2, %shr2
  %and3 = shl i32 %or2, 8
  %shl3 = and i32 %and3, -16711936
  %and3b = lshr i32 %or2, 8
  %shr3 = and i32 %and3b, 16711935
  %or3 = or i32 %shl3, %shr3
  ret i32 %or3
}

define i64 @grev8_i64(i64 %a) nounwind {
; RV32I-LABEL: grev8_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    slli a3, a1, 8
; RV32I-NEXT:    lui a4, 1044496
; RV32I-NEXT:    addi a4, a4, -256
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    srli a1, a1, 8
; RV32I-NEXT:    lui a4, 4080
; RV32I-NEXT:    addi a4, a4, 255
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev8_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev8.h a0, a0
; RV32ZBP-NEXT:    rev8.h a1, a1
; RV32ZBP-NEXT:    ret
  %and = shl i64 %a, 8
  %shl = and i64 %and, -71777214294589696
  %and1 = lshr i64 %a, 8
  %shr = and i64 %and1, 71777214294589695
  %or = or i64 %shl, %shr
  ret i64 %or
}

define i32 @grev16_i32(i32 %a) nounwind {
; RV32I-LABEL: grev16_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev16_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rori a0, a0, 16
; RV32ZBP-NEXT:    ret
  %shl = shl i32 %a, 16
  %shr = lshr i32 %a, 16
  %or = or i32 %shl, %shr
  ret i32 %or
}


define i32 @grev3b_i32(i32 %a) nounwind {
; RV32I-LABEL: grev3b_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev3b_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev.n a0, a0
; RV32ZBP-NEXT:    ret
  %and2 = shl i32 %a, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %a, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shl2, %shr2
  %and1 = shl i32 %or2, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %or2, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shl1, %shr1
  ret i32 %or1
}

define i64 @grev3b_i64(i64 %a) nounwind {
; RV32I-LABEL: grev3b_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 2
; RV32I-NEXT:    slli a3, a0, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    lui a4, 349525
; RV32I-NEXT:    addi a4, a4, 1365
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev3b_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev.n a0, a0
; RV32ZBP-NEXT:    rev.n a1, a1
; RV32ZBP-NEXT:    ret
  %and2 = shl i64 %a, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %a, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shl2, %shr2
  %and1 = shl i64 %or2, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %or2, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shl1, %shr1
  ret i64 %or1
}

; grev1, grev2, grev1 -> grev2
define i32 @grev2b_i32(i32 %a) nounwind {
; RV32I-LABEL: grev2b_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev2b_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev2.n a0, a0
; RV32ZBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shl2, %shr2
  %and3 = shl i32 %or2, 1
  %shl3 = and i32 %and3, -1431655766
  %and3b = lshr i32 %or2, 1
  %shr3 = and i32 %and3b, 1431655765
  %or3 = or i32 %shl3, %shr3
  ret i32 %or3
}

; grev1, grev2, grev1 -> grev2
define i64 @grev2b_i64(i64 %a) nounwind {
; RV32I-LABEL: grev2b_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    lui a5, 349525
; RV32I-NEXT:    addi a5, a5, 1365
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    slli a2, a1, 2
; RV32I-NEXT:    slli a3, a0, 2
; RV32I-NEXT:    lui a6, 838861
; RV32I-NEXT:    addi a6, a6, -820
; RV32I-NEXT:    and a3, a3, a6
; RV32I-NEXT:    and a2, a2, a6
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a6, 209715
; RV32I-NEXT:    addi a6, a6, 819
; RV32I-NEXT:    and a0, a0, a6
; RV32I-NEXT:    and a1, a1, a6
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev2b_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev2.n a0, a0
; RV32ZBP-NEXT:    rev2.n a1, a1
; RV32ZBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shl1, %shr1
  %and2 = shl i64 %or1, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shl2, %shr2
  %and3 = shl i64 %or2, 1
  %shl3 = and i64 %and3, -6148914691236517206
  %and3b = lshr i64 %or2, 1
  %shr3 = and i64 %and3b, 6148914691236517205
  %or3 = or i64 %shl3, %shr3
  ret i64 %or3
}

; grev1, grev2, grev1, grev2 -> identity
define i32 @grev0_i32(i32 %a) nounwind {
; RV32I-LABEL: grev0_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a5, 209715
; RV32I-NEXT:    addi a5, a5, 819
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev0_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shl2, %shr2
  %and3 = shl i32 %or2, 1
  %shl3 = and i32 %and3, -1431655766
  %and3b = lshr i32 %or2, 1
  %shr3 = and i32 %and3b, 1431655765
  %or3 = or i32 %shl3, %shr3
  %and4 = shl i32 %or3, 2
  %shl4 = and i32 %and4, -858993460
  %and4b = lshr i32 %or3, 2
  %shr4 = and i32 %and4b, 858993459
  %or4 = or i32 %shl4, %shr4
  ret i32 %or4
}

; grev1, grev2, grev1, grev2 -> identity
define i64 @grev0_i64(i64 %a) nounwind {
; RV32I-LABEL: grev0_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 1
; RV32I-NEXT:    slli a3, a0, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a5, 349525
; RV32I-NEXT:    addi a5, a5, 1365
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    slli a3, a1, 2
; RV32I-NEXT:    lui a6, 838861
; RV32I-NEXT:    addi a6, a6, -820
; RV32I-NEXT:    and a3, a3, a6
; RV32I-NEXT:    and a2, a2, a6
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    lui a7, 209715
; RV32I-NEXT:    addi a7, a7, 819
; RV32I-NEXT:    and a1, a1, a7
; RV32I-NEXT:    and a0, a0, a7
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    slli a2, a1, 1
; RV32I-NEXT:    slli a3, a0, 1
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    slli a3, a1, 2
; RV32I-NEXT:    and a3, a3, a6
; RV32I-NEXT:    and a2, a2, a6
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    and a1, a1, a7
; RV32I-NEXT:    and a0, a0, a7
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev0_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shl1, %shr1
  %and2 = shl i64 %or1, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shl2, %shr2
  %and3 = shl i64 %or2, 1
  %shl3 = and i64 %and3, -6148914691236517206
  %and3b = lshr i64 %or2, 1
  %shr3 = and i64 %and3b, 6148914691236517205
  %or3 = or i64 %shl3, %shr3
  %and4 = shl i64 %or3, 2
  %shl4 = and i64 %and4, -3689348814741910324
  %and4b = lshr i64 %or3, 2
  %shr4 = and i64 %and4b, 3689348814741910323
  %or4 = or i64 %shl4, %shr4
  ret i64 %or4
}

declare i32 @llvm.fshl.i32(i32, i32, i32)
declare i32 @llvm.fshr.i32(i32, i32, i32)

define signext i32 @grev16_i32_fshl(i32 signext %a) nounwind {
; RV32I-LABEL: grev16_i32_fshl:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev16_i32_fshl:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rori a0, a0, 16
; RV32ZBP-NEXT:    ret
  %or = tail call i32 @llvm.fshl.i32(i32 %a, i32 %a, i32 16)
  ret i32 %or
}

define signext i32 @grev16_i32_fshr(i32 signext %a) nounwind {
; RV32I-LABEL: grev16_i32_fshr:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev16_i32_fshr:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rori a0, a0, 16
; RV32ZBP-NEXT:    ret
  %or = tail call i32 @llvm.fshr.i32(i32 %a, i32 %a, i32 16)
  ret i32 %or
}

define i64 @grev16_i64(i64 %a) nounwind {
; RV32I-LABEL: grev16_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a2, a0, 16
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    srli a2, a1, 16
; RV32I-NEXT:    slli a1, a1, 16
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: grev16_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rori a0, a0, 16
; RV32ZBP-NEXT:    rori a1, a1, 16
; RV32ZBP-NEXT:    ret
  %and = shl i64 %a, 16
  %shl = and i64 %and, -281470681808896
  %and1 = lshr i64 %a, 16
  %shr = and i64 %and1, 281470681808895
  %or = or i64 %shl, %shr
  ret i64 %or
}

declare i16 @llvm.bswap.i16(i16)

define zeroext i16 @bswap_i16(i16 zeroext %a) nounwind {
; RV32I-LABEL: bswap_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    slli a0, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: bswap_i16:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev8.h a0, a0
; RV32ZBP-NEXT:    ret
  %1 = tail call i16 @llvm.bswap.i16(i16 %a)
  ret i16 %1
}

declare i32 @llvm.bswap.i32(i32)

define i32 @bswap_i32(i32 %a) nounwind {
; RV32I-LABEL: bswap_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    lui a2, 16
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 24
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: bswap_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev8 a0, a0
; RV32ZBP-NEXT:    ret
  %1 = tail call i32 @llvm.bswap.i32(i32 %a)
  ret i32 %1
}

declare i64 @llvm.bswap.i64(i64)

define i64 @bswap_i64(i64 %a) {
; RV32I-LABEL: bswap_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a2, a1, 8
; RV32I-NEXT:    lui a3, 16
; RV32I-NEXT:    addi a3, a3, -256
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    srli a4, a1, 24
; RV32I-NEXT:    or a2, a2, a4
; RV32I-NEXT:    slli a4, a1, 8
; RV32I-NEXT:    lui a5, 4080
; RV32I-NEXT:    and a4, a4, a5
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a4
; RV32I-NEXT:    or a2, a1, a2
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    and a1, a1, a3
; RV32I-NEXT:    srli a3, a0, 24
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    slli a3, a0, 8
; RV32I-NEXT:    and a3, a3, a5
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    or a1, a0, a1
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: bswap_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev8 a2, a1
; RV32ZBP-NEXT:    rev8 a1, a0
; RV32ZBP-NEXT:    mv a0, a2
; RV32ZBP-NEXT:    ret
  %1 = call i64 @llvm.bswap.i64(i64 %a)
  ret i64 %1
}

declare i8 @llvm.bitreverse.i8(i8)

define zeroext i8 @bitreverse_i8(i8 zeroext %a) nounwind {
; RV32I-LABEL: bitreverse_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    andi a0, a0, 15
; RV32I-NEXT:    slli a0, a0, 4
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    andi a1, a0, 51
; RV32I-NEXT:    slli a1, a1, 2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    andi a0, a0, 51
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    andi a1, a0, 85
; RV32I-NEXT:    slli a1, a1, 1
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    andi a0, a0, 85
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: bitreverse_i8:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev.b a0, a0
; RV32ZBP-NEXT:    ret
  %1 = tail call i8 @llvm.bitreverse.i8(i8 %a)
  ret i8 %1
}

declare i16 @llvm.bitreverse.i16(i16)

define zeroext i16 @bitreverse_i16(i16 zeroext %a) nounwind {
; RV32I-LABEL: bitreverse_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    slli a0, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    lui a2, 1
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    slli a0, a0, 4
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    lui a2, 3
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    slli a0, a0, 2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    lui a2, 5
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    slli a0, a0, 1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: bitreverse_i16:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev.h a0, a0
; RV32ZBP-NEXT:    ret
  %1 = tail call i16 @llvm.bitreverse.i16(i16 %a)
  ret i16 %1
}

declare i32 @llvm.bitreverse.i32(i32)

define i32 @bitreverse_i32(i32 %a) nounwind {
; RV32I-LABEL: bitreverse_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    lui a2, 16
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 24
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    slli a0, a0, 4
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    slli a0, a0, 2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    slli a0, a0, 1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: bitreverse_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev a0, a0
; RV32ZBP-NEXT:    ret
  %1 = tail call i32 @llvm.bitreverse.i32(i32 %a)
  ret i32 %1
}

declare i64 @llvm.bitreverse.i64(i64)

define i64 @bitreverse_i64(i64 %a) nounwind {
; RV32I-LABEL: bitreverse_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a2, a1, 8
; RV32I-NEXT:    lui a3, 16
; RV32I-NEXT:    addi a3, a3, -256
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    srli a4, a1, 24
; RV32I-NEXT:    or a2, a2, a4
; RV32I-NEXT:    slli a4, a1, 8
; RV32I-NEXT:    lui a5, 4080
; RV32I-NEXT:    and a4, a4, a5
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a4
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    srli a2, a1, 4
; RV32I-NEXT:    lui a4, 61681
; RV32I-NEXT:    addi a4, a4, -241
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    slli a1, a1, 4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    srli a2, a1, 2
; RV32I-NEXT:    lui a6, 209715
; RV32I-NEXT:    addi a6, a6, 819
; RV32I-NEXT:    and a2, a2, a6
; RV32I-NEXT:    and a1, a1, a6
; RV32I-NEXT:    slli a1, a1, 2
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    srli a2, a1, 1
; RV32I-NEXT:    lui a7, 349525
; RV32I-NEXT:    addi a7, a7, 1365
; RV32I-NEXT:    and a2, a2, a7
; RV32I-NEXT:    and a1, a1, a7
; RV32I-NEXT:    slli a1, a1, 1
; RV32I-NEXT:    or a2, a2, a1
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    and a1, a1, a3
; RV32I-NEXT:    srli a3, a0, 24
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    slli a3, a0, 8
; RV32I-NEXT:    and a3, a3, a5
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    slli a0, a0, 4
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    and a1, a1, a6
; RV32I-NEXT:    and a0, a0, a6
; RV32I-NEXT:    slli a0, a0, 2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    and a1, a1, a7
; RV32I-NEXT:    and a0, a0, a7
; RV32I-NEXT:    slli a0, a0, 1
; RV32I-NEXT:    or a1, a1, a0
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: bitreverse_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev a2, a1
; RV32ZBP-NEXT:    rev a1, a0
; RV32ZBP-NEXT:    mv a0, a2
; RV32ZBP-NEXT:    ret
  %1 = call i64 @llvm.bitreverse.i64(i64 %a)
  ret i64 %1
}

define i32 @bswap_rotr_i32(i32 %a) {
; RV32I-LABEL: bswap_rotr_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    lui a2, 4080
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    slli a2, a0, 24
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    srli a2, a0, 24
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    slli a0, a0, 8
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a1, a1, 16
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: bswap_rotr_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev8.h a0, a0
; RV32ZBP-NEXT:    ret
  %1 = call i32 @llvm.bswap.i32(i32 %a)
  %2 = call i32 @llvm.fshr.i32(i32 %1, i32 %1, i32 16)
  ret i32 %2
}

define i32 @bswap_rotl_i32(i32 %a) {
; RV32I-LABEL: bswap_rotl_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 24
; RV32I-NEXT:    srli a2, a0, 16
; RV32I-NEXT:    slli a2, a2, 8
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    slli a1, a1, 16
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: bswap_rotl_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev8.h a0, a0
; RV32ZBP-NEXT:    ret
  %1 = call i32 @llvm.bswap.i32(i32 %a)
  %2 = call i32 @llvm.fshl.i32(i32 %1, i32 %1, i32 16)
  ret i32 %2
}

define i32 @bitreverse_bswap_i32(i32 %a) {
; RV32I-LABEL: bitreverse_bswap_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    slli a0, a0, 4
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    slli a0, a0, 2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    slli a0, a0, 1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: bitreverse_bswap_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev.b a0, a0
; RV32ZBP-NEXT:    ret
  %1 = call i32 @llvm.bitreverse.i32(i32 %a)
  %2 = call i32 @llvm.bswap.i32(i32 %1)
  ret i32 %2
}

define i64 @bitreverse_bswap_i64(i64 %a) {
; RV32I-LABEL: bitreverse_bswap_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    lui a3, 61681
; RV32I-NEXT:    addi a3, a3, -241
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    slli a0, a0, 4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    slli a0, a0, 2
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    lui a5, 349525
; RV32I-NEXT:    addi a5, a5, 1365
; RV32I-NEXT:    and a2, a2, a5
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    slli a0, a0, 1
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    srli a2, a1, 4
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    and a1, a1, a3
; RV32I-NEXT:    slli a1, a1, 4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    srli a2, a1, 2
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    slli a1, a1, 2
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    srli a2, a1, 1
; RV32I-NEXT:    and a2, a2, a5
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    slli a1, a1, 1
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: bitreverse_bswap_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    rev.b a0, a0
; RV32ZBP-NEXT:    rev.b a1, a1
; RV32ZBP-NEXT:    ret
  %1 = call i64 @llvm.bitreverse.i64(i64 %a)
  %2 = call i64 @llvm.bswap.i64(i64 %1)
  ret i64 %2
}

define i32 @shfl1_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: shfl1_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 629146
; RV32I-NEXT:    addi a1, a1, -1639
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    lui a3, 279620
; RV32I-NEXT:    addi a3, a3, 1092
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a2, 139810
; RV32I-NEXT:    addi a2, a2, 546
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: shfl1_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    zip.n a0, a0
; RV32ZBP-NEXT:    ret
  %and = and i32 %a, -1717986919
  %shl = shl i32 %a, 1
  %and1 = and i32 %shl, 1145324612
  %or = or i32 %and1, %and
  %shr = lshr i32 %a, 1
  %and2 = and i32 %shr, 572662306
  %or3 = or i32 %or, %and2
  ret i32 %or3
}

define i64 @shfl1_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: shfl1_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 629146
; RV32I-NEXT:    addi a2, a2, -1639
; RV32I-NEXT:    and a3, a0, a2
; RV32I-NEXT:    and a2, a1, a2
; RV32I-NEXT:    slli a4, a1, 1
; RV32I-NEXT:    slli a5, a0, 1
; RV32I-NEXT:    lui a6, 279620
; RV32I-NEXT:    addi a6, a6, 1092
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a2, a2, a4
; RV32I-NEXT:    or a3, a3, a5
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    lui a4, 139810
; RV32I-NEXT:    addi a4, a4, 546
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: shfl1_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    zip.n a0, a0
; RV32ZBP-NEXT:    zip.n a1, a1
; RV32ZBP-NEXT:    ret
  %and = and i64 %a, -7378697629483820647
  %shl = shl i64 %a, 1
  %and1 = and i64 %shl, 4919131752989213764
  %or = or i64 %and, %and1
  %shr = lshr i64 %a, 1
  %and2 = and i64 %shr, 2459565876494606882
  %or3 = or i64 %or, %and2
  ret i64 %or3
}

define i32 @shfl2_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: shfl2_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 801852
; RV32I-NEXT:    addi a1, a1, 963
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    lui a3, 197379
; RV32I-NEXT:    addi a3, a3, 48
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 49345
; RV32I-NEXT:    addi a2, a2, -1012
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: shfl2_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    zip2.b a0, a0
; RV32ZBP-NEXT:    ret
  %and = and i32 %a, -1010580541
  %shl = shl i32 %a, 2
  %and1 = and i32 %shl, 808464432
  %or = or i32 %and1, %and
  %shr = lshr i32 %a, 2
  %and2 = and i32 %shr, 202116108
  %or3 = or i32 %and2, %or
  ret i32 %or3
}

define i64 @shfl2_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: shfl2_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 801852
; RV32I-NEXT:    addi a2, a2, 963
; RV32I-NEXT:    and a3, a0, a2
; RV32I-NEXT:    and a2, a1, a2
; RV32I-NEXT:    slli a4, a1, 2
; RV32I-NEXT:    slli a5, a0, 2
; RV32I-NEXT:    lui a6, 197379
; RV32I-NEXT:    addi a6, a6, 48
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a2, a2, a4
; RV32I-NEXT:    or a3, a3, a5
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    lui a4, 49345
; RV32I-NEXT:    addi a4, a4, -1012
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: shfl2_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    zip2.b a0, a0
; RV32ZBP-NEXT:    zip2.b a1, a1
; RV32ZBP-NEXT:    ret
  %and = and i64 %a, -4340410370284600381
  %shl = shl i64 %a, 2
  %and1 = and i64 %shl, 3472328296227680304
  %or = or i64 %and, %and1
  %shr = lshr i64 %a, 2
  %and2 = and i64 %shr, 868082074056920076
  %or3 = or i64 %and2, %or
  ret i64 %or3
}

define i32 @shfl4_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: shfl4_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 983295
; RV32I-NEXT:    addi a1, a1, 15
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    lui a3, 61441
; RV32I-NEXT:    addi a3, a3, -256
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a3, 3840
; RV32I-NEXT:    addi a3, a3, 240
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: shfl4_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    zip4.h a0, a0
; RV32ZBP-NEXT:    ret
  %and = and i32 %a, -267390961
  %shl = shl i32 %a, 4
  %and1 = and i32 %shl, 251662080
  %shr = lshr i32 %a, 4
  %and2 = and i32 %shr, 15728880
  %or = or i32 %and2, %and
  %or3 = or i32 %or, %and1
  ret i32 %or3
}

define i64 @shfl4_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: shfl4_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 983295
; RV32I-NEXT:    addi a2, a2, 15
; RV32I-NEXT:    and a3, a1, a2
; RV32I-NEXT:    and a2, a0, a2
; RV32I-NEXT:    slli a4, a1, 4
; RV32I-NEXT:    slli a5, a0, 4
; RV32I-NEXT:    lui a6, 61441
; RV32I-NEXT:    addi a6, a6, -256
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a6, 3840
; RV32I-NEXT:    addi a6, a6, 240
; RV32I-NEXT:    and a0, a0, a6
; RV32I-NEXT:    and a1, a1, a6
; RV32I-NEXT:    or a1, a4, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: shfl4_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    zip4.h a0, a0
; RV32ZBP-NEXT:    zip4.h a1, a1
; RV32ZBP-NEXT:    ret
  %and = and i64 %a, -1148435428713435121
  %shl = shl i64 %a, 4
  %and1 = and i64 %shl, 1080880403494997760
  %shr = lshr i64 %a, 4
  %and2 = and i64 %shr, 67555025218437360
  %or = or i64 %and1, %and2
  %or3 = or i64 %or, %and
  ret i64 %or3
}

define i32 @shfl8_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: shfl8_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 1044480
; RV32I-NEXT:    addi a1, a1, 255
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    lui a3, 16
; RV32I-NEXT:    addi a3, a3, -256
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: shfl8_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    zip8 a0, a0
; RV32ZBP-NEXT:    ret
  %and = and i32 %a, -16776961
  %shl = shl i32 %a, 8
  %and1 = and i32 %shl, 16711680
  %shr = lshr i32 %a, 8
  %and2 = and i32 %shr, 65280
  %or = or i32 %and, %and2
  %or3 = or i32 %or, %and1
  ret i32 %or3
}

define i64 @shfl8_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: shfl8_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 1044480
; RV32I-NEXT:    addi a2, a2, 255
; RV32I-NEXT:    and a3, a0, a2
; RV32I-NEXT:    and a2, a1, a2
; RV32I-NEXT:    slli a4, a0, 8
; RV32I-NEXT:    slli a5, a1, 8
; RV32I-NEXT:    lui a6, 4080
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    srli a1, a1, 8
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    lui a6, 16
; RV32I-NEXT:    addi a6, a6, -256
; RV32I-NEXT:    and a0, a0, a6
; RV32I-NEXT:    and a1, a1, a6
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    or a0, a4, a0
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: shfl8_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    zip8 a0, a0
; RV32ZBP-NEXT:    zip8 a1, a1
; RV32ZBP-NEXT:    ret
  %and = and i64 %a, -72056494543077121
  %shl = shl i64 %a, 8
  %and1 = and i64 %shl, 71776119077928960
  %shr = lshr i64 %a, 8
  %and2 = and i64 %shr, 280375465148160
  %or = or i64 %and2, %and
  %or3 = or i64 %and1, %or
  ret i64 %or3
}

define i32 @packu_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: packu_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    lui a2, 1048560
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: packu_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    packu a0, a0, a1
; RV32ZBP-NEXT:    ret
  %shr = lshr i32 %a, 16
  %shr1 = and i32 %b, -65536
  %or = or i32 %shr1, %shr
  ret i32 %or
}

define i32 @zexth_i32(i32 %a) nounwind {
; RV32I-LABEL: zexth_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: zexth_i32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    zext.h a0, a0
; RV32ZBP-NEXT:    ret
  %and = and i32 %a, 65535
  ret i32 %and
}

define i64 @zexth_i64(i64 %a) nounwind {
; RV32I-LABEL: zexth_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: zexth_i64:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    zext.h a0, a0
; RV32ZBP-NEXT:    li a1, 0
; RV32ZBP-NEXT:    ret
  %and = and i64 %a, 65535
  ret i64 %and
}

define i32 @or_shl_fshl(i32 %x, i32 %y, i32 %s) {
; CHECK-LABEL: or_shl_fshl:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sll a3, a1, a2
; CHECK-NEXT:    sll a0, a0, a2
; CHECK-NEXT:    not a2, a2
; CHECK-NEXT:    srli a1, a1, 1
; CHECK-NEXT:    srl a1, a1, a2
; CHECK-NEXT:    or a0, a0, a1
; CHECK-NEXT:    or a0, a0, a3
; CHECK-NEXT:    ret
  %shy = shl i32 %y, %s
  %fun = call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 %s)
  %or = or i32 %fun, %shy
  ret i32 %or
}

define i32 @or_shl_rot(i32 %x, i32 %y, i32 %s) {
; RV32I-LABEL: or_shl_rot:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sll a0, a0, a2
; RV32I-NEXT:    sll a3, a1, a2
; RV32I-NEXT:    neg a2, a2
; RV32I-NEXT:    srl a1, a1, a2
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: or_shl_rot:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    sll a0, a0, a2
; RV32ZBP-NEXT:    rol a1, a1, a2
; RV32ZBP-NEXT:    or a0, a1, a0
; RV32ZBP-NEXT:    ret
  %shx = shl i32 %x, %s
  %rot = call i32 @llvm.fshl.i32(i32 %y, i32 %y, i32 %s)
  %or = or i32 %rot, %shx
  ret i32 %or
}

define i32 @or_shl_fshl_commute(i32 %x, i32 %y, i32 %s) {
; CHECK-LABEL: or_shl_fshl_commute:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sll a3, a1, a2
; CHECK-NEXT:    sll a0, a0, a2
; CHECK-NEXT:    not a2, a2
; CHECK-NEXT:    srli a1, a1, 1
; CHECK-NEXT:    srl a1, a1, a2
; CHECK-NEXT:    or a0, a0, a1
; CHECK-NEXT:    or a0, a3, a0
; CHECK-NEXT:    ret
  %shy = shl i32 %y, %s
  %fun = call i32 @llvm.fshl.i32(i32 %x, i32 %y, i32 %s)
  %or = or i32 %shy, %fun
  ret i32 %or
}

define i32 @or_shl_rot_commute(i32 %x, i32 %y, i32 %s) {
; RV32I-LABEL: or_shl_rot_commute:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sll a0, a0, a2
; RV32I-NEXT:    sll a3, a1, a2
; RV32I-NEXT:    neg a2, a2
; RV32I-NEXT:    srl a1, a1, a2
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: or_shl_rot_commute:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    sll a0, a0, a2
; RV32ZBP-NEXT:    rol a1, a1, a2
; RV32ZBP-NEXT:    or a0, a0, a1
; RV32ZBP-NEXT:    ret
  %shx = shl i32 %x, %s
  %rot = call i32 @llvm.fshl.i32(i32 %y, i32 %y, i32 %s)
  %or = or i32 %shx, %rot
  ret i32 %or
}

define i32 @or_lshr_fshr(i32 %x, i32 %y, i32 %s) {
; CHECK-LABEL: or_lshr_fshr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srl a3, a1, a2
; CHECK-NEXT:    srl a0, a0, a2
; CHECK-NEXT:    not a2, a2
; CHECK-NEXT:    slli a1, a1, 1
; CHECK-NEXT:    sll a1, a1, a2
; CHECK-NEXT:    or a0, a1, a0
; CHECK-NEXT:    or a0, a0, a3
; CHECK-NEXT:    ret
  %shy = lshr i32 %y, %s
  %fun = call i32 @llvm.fshr.i32(i32 %y, i32 %x, i32 %s)
  %or = or i32 %fun, %shy
  ret i32 %or
}

define i32 @or_lshr_rotr(i32 %x, i32 %y, i32 %s) {
; RV32I-LABEL: or_lshr_rotr:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srl a0, a0, a2
; RV32I-NEXT:    srl a3, a1, a2
; RV32I-NEXT:    neg a2, a2
; RV32I-NEXT:    sll a1, a1, a2
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: or_lshr_rotr:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    srl a0, a0, a2
; RV32ZBP-NEXT:    ror a1, a1, a2
; RV32ZBP-NEXT:    or a0, a1, a0
; RV32ZBP-NEXT:    ret
  %shx = lshr i32 %x, %s
  %rot = call i32 @llvm.fshr.i32(i32 %y, i32 %y, i32 %s)
  %or = or i32 %rot, %shx
  ret i32 %or
}

define i32 @or_lshr_fshr_commute(i32 %x, i32 %y, i32 %s) {
; CHECK-LABEL: or_lshr_fshr_commute:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srl a3, a1, a2
; CHECK-NEXT:    srl a0, a0, a2
; CHECK-NEXT:    not a2, a2
; CHECK-NEXT:    slli a1, a1, 1
; CHECK-NEXT:    sll a1, a1, a2
; CHECK-NEXT:    or a0, a1, a0
; CHECK-NEXT:    or a0, a3, a0
; CHECK-NEXT:    ret
  %shy = lshr i32 %y, %s
  %fun = call i32 @llvm.fshr.i32(i32 %y, i32 %x, i32 %s)
  %or = or i32 %shy, %fun
  ret i32 %or
}

define i32 @or_lshr_rotr_commute(i32 %x, i32 %y, i32 %s) {
; RV32I-LABEL: or_lshr_rotr_commute:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srl a0, a0, a2
; RV32I-NEXT:    srl a3, a1, a2
; RV32I-NEXT:    neg a2, a2
; RV32I-NEXT:    sll a1, a1, a2
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBP-LABEL: or_lshr_rotr_commute:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    srl a0, a0, a2
; RV32ZBP-NEXT:    ror a1, a1, a2
; RV32ZBP-NEXT:    or a0, a0, a1
; RV32ZBP-NEXT:    ret
  %shx = lshr i32 %x, %s
  %rot = call i32 @llvm.fshr.i32(i32 %y, i32 %y, i32 %s)
  %or = or i32 %shx, %rot
  ret i32 %or
}

define i32 @or_shl_fshl_simplify(i32 %x, i32 %y, i32 %s) {
; CHECK-LABEL: or_shl_fshl_simplify:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sll a1, a1, a2
; CHECK-NEXT:    not a2, a2
; CHECK-NEXT:    srli a0, a0, 1
; CHECK-NEXT:    srl a0, a0, a2
; CHECK-NEXT:    or a0, a1, a0
; CHECK-NEXT:    ret
  %shy = shl i32 %y, %s
  %fun = call i32 @llvm.fshl.i32(i32 %y, i32 %x, i32 %s)
  %or = or i32 %fun, %shy
  ret i32 %or
}

define i32 @or_lshr_fshr_simplify(i32 %x, i32 %y, i32 %s) {
; CHECK-LABEL: or_lshr_fshr_simplify:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srl a1, a1, a2
; CHECK-NEXT:    not a2, a2
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    sll a0, a0, a2
; CHECK-NEXT:    or a0, a0, a1
; CHECK-NEXT:    ret
  %shy = lshr i32 %y, %s
  %fun = call i32 @llvm.fshr.i32(i32 %x, i32 %y, i32 %s)
  %or = or i32 %shy, %fun
  ret i32 %or
}
