from linda.debug import dprint
from linda.parser.rfc822parser import RFC822Parser

class OverrideParser(RFC822Parser):
    def parse(self):
        self.validate(('Tag:',))
        if not self.data:
            raise OverrideParserException, "Badly-formatted file %s" % \
                self.file
        output_var = {}
        for x in self.data:
            parse_dict = {'tag': '', 'key': '', 'value': ''}
            for k in x:
                if k.find(':') != -1:
                    cur_line = k.split(':')
                    parse_dict['key'] = cur_line[0]
                    value = cur_line[1]
                    if value.endswith('\n'):
                        value = cur_line[1][:-1]
                    parse_dict['value'] = value.strip()
                elif k.startswith('#'):
                    continue
                if k.startswith('Tag:'): 
                    parse_dict['tag'] = parse_dict['value']
                    if not output_var.has_key(parse_dict['tag']):
                        output_var[parse_dict['tag']] = {}
                    dprint(_("Found tag: %s.") % parse_dict['tag'], 4)
                elif k.startswith('Type:') or k.startswith('Data:'):
                    dprint(_("Adding %s: %s to %s") % (parse_dict['key'], \
                        parse_dict['value'], parse_dict['tag']), 4)
                    if output_var[parse_dict['tag']].has_key(parse_dict['key']):
                        output_var[parse_dict['tag']][parse_dict['key']].append(parse_dict['value'])
                    else:
                        output_var[parse_dict['tag']][parse_dict['key']] = \
                            [parse_dict['value']]
                else:
                    raise OverrideParserException, 'Unknown key: %s' % \
                        parse_dict['key']
        for tag in output_var:
            for key in output_var[tag]:
                if len(output_var[tag][key]) == 1:
                    output_var[tag][key] = output_var[tag][key][0]
                elif len(output_var[tag][key]) >= 2:
                    output_var[tag][key] = '(%s)' % \
                        '|'.join(output_var[tag][key])
        self.data = output_var

class OverrideParserException(Exception):
    pass

