from linda.debug import dprint
from linda.parser.rfc822parser import RFC822Parser

class DataFileParser(RFC822Parser):
    def parse(self):
        self.validate(('Tag:', 'Type:'))
        output_var = {}
        for x in self.data:
            parse_dict = {'tag': '', 'key': '', 'value': ''}
            for k in x:
                if k.find(':') != -1:
                    cur_line = k.split(':')
                    parse_dict['key'] = cur_line[0]
                    parse_dict['value'] = cur_line[1][:-1].strip()
                else:
                    dprint(_("Ignoring unknown line: \"%s\".") % k[:-1], 2)
                if k.startswith('Tag:'): 
                    parse_dict['tag'] = parse_dict['value']
                    output_var[parse_dict['tag']] = {}
                    dprint(_("Found tag: %s.") % parse_dict['tag'], 4)
                elif k.startswith('Type:') or k.startswith('Justification:'):
                    dprint(_("Adding %s: %s to %s") % (parse_dict['key'], \
                        parse_dict['value'], parse_dict['tag']), 4)
                    output_var[parse_dict['tag']][parse_dict['key']] = \
                        parse_dict['value']
                elif k.startswith('#'):
                    continue
                else:
                    dprint(_("Unknown key: %s.") % parse_dict['key'], 2)
        dprint(_("Data file (%s): %s") % (self.file, output_var), 3)
        self.data = output_var

