/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "librpc/gen_ndr/cli_samr.h"

NTSTATUS rpccli_samr_Connect(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx,
			     uint16_t *system_name,
			     uint32_t access_mask,
			     struct policy_handle *connect_handle)
{
	struct samr_Connect r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = system_name;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_Connect, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_CONNECT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_Connect, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*connect_handle = *r.out.connect_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_Close(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   struct policy_handle *handle)
{
	struct samr_Close r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_Close, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_CLOSE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_Close, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_SetSecurity(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle,
				 uint32_t sec_info,
				 struct sec_desc_buf *sdbuf)
{
	struct samr_SetSecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sec_info = sec_info;
	r.in.sdbuf = sdbuf;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetSecurity, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_SETSECURITY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetSecurity, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_QuerySecurity(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *handle,
				   uint32_t sec_info,
				   struct sec_desc_buf **sdbuf)
{
	struct samr_QuerySecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sec_info = sec_info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QuerySecurity, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_QUERYSECURITY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QuerySecurity, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sdbuf = *r.out.sdbuf;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_Shutdown(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct policy_handle *connect_handle)
{
	struct samr_Shutdown r;
	NTSTATUS status;

	/* In parameters */
	r.in.connect_handle = connect_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_Shutdown, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_SHUTDOWN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_Shutdown, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_LookupDomain(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *connect_handle,
				  struct lsa_String *domain_name,
				  struct dom_sid2 *sid)
{
	struct samr_LookupDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.connect_handle = connect_handle;
	r.in.domain_name = domain_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_LookupDomain, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_LOOKUPDOMAIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_LookupDomain, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sid = *r.out.sid;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_EnumDomains(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *connect_handle,
				 uint32_t *resume_handle,
				 uint32_t buf_size,
				 struct samr_SamArray *sam,
				 uint32_t *num_entries)
{
	struct samr_EnumDomains r;
	NTSTATUS status;

	/* In parameters */
	r.in.connect_handle = connect_handle;
	r.in.resume_handle = resume_handle;
	r.in.buf_size = buf_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_EnumDomains, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_ENUMDOMAINS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_EnumDomains, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*resume_handle = *r.out.resume_handle;
	*sam = *r.out.sam;
	*num_entries = *r.out.num_entries;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_OpenDomain(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *connect_handle,
				uint32_t access_mask,
				struct dom_sid2 *sid,
				struct policy_handle *domain_handle)
{
	struct samr_OpenDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.connect_handle = connect_handle;
	r.in.access_mask = access_mask;
	r.in.sid = sid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_OpenDomain, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_OPENDOMAIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_OpenDomain, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*domain_handle = *r.out.domain_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_QueryDomainInfo(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *domain_handle,
				     uint16_t level,
				     union samr_DomainInfo *info)
{
	struct samr_QueryDomainInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryDomainInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_QUERYDOMAININFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryDomainInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_SetDomainInfo(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *domain_handle,
				   uint16_t level,
				   union samr_DomainInfo *info)
{
	struct samr_SetDomainInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetDomainInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_SETDOMAININFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetDomainInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_CreateDomainGroup(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *domain_handle,
				       struct lsa_String *name,
				       uint32_t access_mask,
				       struct policy_handle *group_handle,
				       uint32_t *rid)
{
	struct samr_CreateDomainGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.name = name;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_CreateDomainGroup, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_CREATEDOMAINGROUP,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_CreateDomainGroup, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*group_handle = *r.out.group_handle;
	*rid = *r.out.rid;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_EnumDomainGroups(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *domain_handle,
				      uint32_t *resume_handle,
				      uint32_t max_size,
				      struct samr_SamArray *sam,
				      uint32_t *num_entries)
{
	struct samr_EnumDomainGroups r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.resume_handle = resume_handle;
	r.in.max_size = max_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_EnumDomainGroups, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_ENUMDOMAINGROUPS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_EnumDomainGroups, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*resume_handle = *r.out.resume_handle;
	*sam = *r.out.sam;
	*num_entries = *r.out.num_entries;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_CreateUser(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *domain_handle,
				struct lsa_String *account_name,
				uint32_t access_mask,
				struct policy_handle *user_handle,
				uint32_t *rid)
{
	struct samr_CreateUser r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.account_name = account_name;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_CreateUser, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_CREATEUSER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_CreateUser, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*user_handle = *r.out.user_handle;
	*rid = *r.out.rid;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_EnumDomainUsers(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *domain_handle,
				     uint32_t *resume_handle,
				     uint32_t acct_flags,
				     uint32_t max_size,
				     struct samr_SamArray *sam,
				     uint32_t *num_entries)
{
	struct samr_EnumDomainUsers r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.resume_handle = resume_handle;
	r.in.acct_flags = acct_flags;
	r.in.max_size = max_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_EnumDomainUsers, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_ENUMDOMAINUSERS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_EnumDomainUsers, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*resume_handle = *r.out.resume_handle;
	if (sam && r.out.sam) {
		*sam = *r.out.sam;
	}
	*num_entries = *r.out.num_entries;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_CreateDomAlias(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *domain_handle,
				    struct lsa_String *alias_name,
				    uint32_t access_mask,
				    struct policy_handle *alias_handle,
				    uint32_t *rid)
{
	struct samr_CreateDomAlias r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.alias_name = alias_name;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_CreateDomAlias, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_CREATEDOMALIAS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_CreateDomAlias, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*alias_handle = *r.out.alias_handle;
	*rid = *r.out.rid;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_EnumDomainAliases(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *domain_handle,
				       uint32_t *resume_handle,
				       uint32_t acct_flags,
				       struct samr_SamArray *sam,
				       uint32_t *num_entries)
{
	struct samr_EnumDomainAliases r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.resume_handle = resume_handle;
	r.in.acct_flags = acct_flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_EnumDomainAliases, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_ENUMDOMAINALIASES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_EnumDomainAliases, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*resume_handle = *r.out.resume_handle;
	*sam = *r.out.sam;
	*num_entries = *r.out.num_entries;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_GetAliasMembership(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *domain_handle,
					struct lsa_SidArray *sids,
					struct samr_Ids *rids)
{
	struct samr_GetAliasMembership r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.sids = sids;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_GetAliasMembership, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_GETALIASMEMBERSHIP,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_GetAliasMembership, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*rids = *r.out.rids;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_LookupNames(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *domain_handle,
				 uint32_t num_names,
				 struct lsa_String *names,
				 struct samr_Ids *rids,
				 struct samr_Ids *types)
{
	struct samr_LookupNames r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.num_names = num_names;
	r.in.names = names;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_LookupNames, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_LOOKUPNAMES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_LookupNames, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*rids = *r.out.rids;
	*types = *r.out.types;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_LookupRids(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *domain_handle,
				uint32_t num_rids,
				uint32_t *rids,
				struct lsa_Strings *names,
				struct samr_Ids *types)
{
	struct samr_LookupRids r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.num_rids = num_rids;
	r.in.rids = rids;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_LookupRids, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_LOOKUPRIDS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_LookupRids, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*names = *r.out.names;
	*types = *r.out.types;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_OpenGroup(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *domain_handle,
			       uint32_t access_mask,
			       uint32_t rid,
			       struct policy_handle *group_handle)
{
	struct samr_OpenGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.access_mask = access_mask;
	r.in.rid = rid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_OpenGroup, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_OPENGROUP,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_OpenGroup, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*group_handle = *r.out.group_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_QueryGroupInfo(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *group_handle,
				    enum samr_GroupInfoEnum level,
				    union samr_GroupInfo *info)
{
	struct samr_QueryGroupInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.group_handle = group_handle;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryGroupInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_QUERYGROUPINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryGroupInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_SetGroupInfo(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *group_handle,
				  enum samr_GroupInfoEnum level,
				  union samr_GroupInfo *info)
{
	struct samr_SetGroupInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.group_handle = group_handle;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetGroupInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_SETGROUPINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetGroupInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_AddGroupMember(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *group_handle,
				    uint32_t rid,
				    uint32_t flags)
{
	struct samr_AddGroupMember r;
	NTSTATUS status;

	/* In parameters */
	r.in.group_handle = group_handle;
	r.in.rid = rid;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_AddGroupMember, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_ADDGROUPMEMBER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_AddGroupMember, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_DeleteDomainGroup(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *group_handle)
{
	struct samr_DeleteDomainGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.group_handle = group_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_DeleteDomainGroup, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_DELETEDOMAINGROUP,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_DeleteDomainGroup, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*group_handle = *r.out.group_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_DeleteGroupMember(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *group_handle,
				       uint32_t rid)
{
	struct samr_DeleteGroupMember r;
	NTSTATUS status;

	/* In parameters */
	r.in.group_handle = group_handle;
	r.in.rid = rid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_DeleteGroupMember, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_DELETEGROUPMEMBER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_DeleteGroupMember, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_QueryGroupMember(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *group_handle,
				      struct samr_RidTypeArray *rids)
{
	struct samr_QueryGroupMember r;
	NTSTATUS status;

	/* In parameters */
	r.in.group_handle = group_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryGroupMember, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_QUERYGROUPMEMBER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryGroupMember, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*rids = *r.out.rids;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_SetMemberAttributesOfGroup(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *group_handle,
						uint32_t unknown1,
						uint32_t unknown2)
{
	struct samr_SetMemberAttributesOfGroup r;
	NTSTATUS status;

	/* In parameters */
	r.in.group_handle = group_handle;
	r.in.unknown1 = unknown1;
	r.in.unknown2 = unknown2;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetMemberAttributesOfGroup, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_SETMEMBERATTRIBUTESOFGROUP,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetMemberAttributesOfGroup, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_OpenAlias(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *domain_handle,
			       uint32_t access_mask,
			       uint32_t rid,
			       struct policy_handle *alias_handle)
{
	struct samr_OpenAlias r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.access_mask = access_mask;
	r.in.rid = rid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_OpenAlias, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_OPENALIAS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_OpenAlias, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*alias_handle = *r.out.alias_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_QueryAliasInfo(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *alias_handle,
				    enum samr_AliasInfoEnum level,
				    union samr_AliasInfo *info)
{
	struct samr_QueryAliasInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.alias_handle = alias_handle;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryAliasInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_QUERYALIASINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryAliasInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_SetAliasInfo(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *alias_handle,
				  enum samr_AliasInfoEnum level,
				  union samr_AliasInfo *info)
{
	struct samr_SetAliasInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.alias_handle = alias_handle;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetAliasInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_SETALIASINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetAliasInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_DeleteDomAlias(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *alias_handle)
{
	struct samr_DeleteDomAlias r;
	NTSTATUS status;

	/* In parameters */
	r.in.alias_handle = alias_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_DeleteDomAlias, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_DELETEDOMALIAS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_DeleteDomAlias, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*alias_handle = *r.out.alias_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_AddAliasMember(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *alias_handle,
				    struct dom_sid2 *sid)
{
	struct samr_AddAliasMember r;
	NTSTATUS status;

	/* In parameters */
	r.in.alias_handle = alias_handle;
	r.in.sid = sid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_AddAliasMember, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_ADDALIASMEMBER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_AddAliasMember, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_DeleteAliasMember(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *alias_handle,
				       struct dom_sid2 *sid)
{
	struct samr_DeleteAliasMember r;
	NTSTATUS status;

	/* In parameters */
	r.in.alias_handle = alias_handle;
	r.in.sid = sid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_DeleteAliasMember, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_DELETEALIASMEMBER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_DeleteAliasMember, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_GetMembersInAlias(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *alias_handle,
				       struct lsa_SidArray *sids)
{
	struct samr_GetMembersInAlias r;
	NTSTATUS status;

	/* In parameters */
	r.in.alias_handle = alias_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_GetMembersInAlias, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_GETMEMBERSINALIAS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_GetMembersInAlias, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sids = *r.out.sids;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_OpenUser(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct policy_handle *domain_handle,
			      uint32_t access_mask,
			      uint32_t rid,
			      struct policy_handle *user_handle)
{
	struct samr_OpenUser r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.access_mask = access_mask;
	r.in.rid = rid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_OpenUser, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_OPENUSER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_OpenUser, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*user_handle = *r.out.user_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_DeleteUser(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *user_handle)
{
	struct samr_DeleteUser r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = user_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_DeleteUser, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_DELETEUSER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_DeleteUser, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*user_handle = *r.out.user_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_QueryUserInfo(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *user_handle,
				   uint16_t level,
				   union samr_UserInfo *info)
{
	struct samr_QueryUserInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = user_handle;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryUserInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_QUERYUSERINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryUserInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_SetUserInfo(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *user_handle,
				 uint16_t level,
				 union samr_UserInfo *info)
{
	struct samr_SetUserInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = user_handle;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetUserInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_SETUSERINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetUserInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_ChangePasswordUser(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *user_handle,
					uint8_t lm_present,
					struct samr_Password *old_lm_crypted,
					struct samr_Password *new_lm_crypted,
					uint8_t nt_present,
					struct samr_Password *old_nt_crypted,
					struct samr_Password *new_nt_crypted,
					uint8_t cross1_present,
					struct samr_Password *nt_cross,
					uint8_t cross2_present,
					struct samr_Password *lm_cross)
{
	struct samr_ChangePasswordUser r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = user_handle;
	r.in.lm_present = lm_present;
	r.in.old_lm_crypted = old_lm_crypted;
	r.in.new_lm_crypted = new_lm_crypted;
	r.in.nt_present = nt_present;
	r.in.old_nt_crypted = old_nt_crypted;
	r.in.new_nt_crypted = new_nt_crypted;
	r.in.cross1_present = cross1_present;
	r.in.nt_cross = nt_cross;
	r.in.cross2_present = cross2_present;
	r.in.lm_cross = lm_cross;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_ChangePasswordUser, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_CHANGEPASSWORDUSER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_ChangePasswordUser, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_GetGroupsForUser(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *user_handle,
				      struct samr_RidWithAttributeArray *rids)
{
	struct samr_GetGroupsForUser r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = user_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_GetGroupsForUser, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_GETGROUPSFORUSER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_GetGroupsForUser, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*rids = *r.out.rids;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_QueryDisplayInfo(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *domain_handle,
				      uint16_t level,
				      uint32_t start_idx,
				      uint32_t max_entries,
				      uint32_t buf_size,
				      uint32_t *total_size,
				      uint32_t *returned_size,
				      union samr_DispInfo *info)
{
	struct samr_QueryDisplayInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.level = level;
	r.in.start_idx = start_idx;
	r.in.max_entries = max_entries;
	r.in.buf_size = buf_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryDisplayInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_QUERYDISPLAYINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryDisplayInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*total_size = *r.out.total_size;
	*returned_size = *r.out.returned_size;
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_GetDisplayEnumerationIndex(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *domain_handle,
						uint16_t level,
						struct lsa_String name,
						uint32_t *idx)
{
	struct samr_GetDisplayEnumerationIndex r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.level = level;
	r.in.name = name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_GetDisplayEnumerationIndex, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_GETDISPLAYENUMERATIONINDEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_GetDisplayEnumerationIndex, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*idx = *r.out.idx;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_TestPrivateFunctionsDomain(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *domain_handle)
{
	struct samr_TestPrivateFunctionsDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_TestPrivateFunctionsDomain, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_TESTPRIVATEFUNCTIONSDOMAIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_TestPrivateFunctionsDomain, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_TestPrivateFunctionsUser(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *user_handle)
{
	struct samr_TestPrivateFunctionsUser r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = user_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_TestPrivateFunctionsUser, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_TESTPRIVATEFUNCTIONSUSER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_TestPrivateFunctionsUser, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_GetUserPwInfo(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *user_handle,
				   struct samr_PwInfo *info)
{
	struct samr_GetUserPwInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = user_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_GetUserPwInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_GETUSERPWINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_GetUserPwInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_RemoveMemberFromForeignDomain(struct rpc_pipe_client *cli,
						   TALLOC_CTX *mem_ctx,
						   struct policy_handle *domain_handle,
						   struct dom_sid2 *sid)
{
	struct samr_RemoveMemberFromForeignDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.sid = sid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_RemoveMemberFromForeignDomain, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_REMOVEMEMBERFROMFOREIGNDOMAIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_RemoveMemberFromForeignDomain, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_QueryDomainInfo2(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *domain_handle,
				      uint16_t level,
				      union samr_DomainInfo *info)
{
	struct samr_QueryDomainInfo2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryDomainInfo2, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_QUERYDOMAININFO2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryDomainInfo2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_QueryUserInfo2(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *user_handle,
				    uint16_t level,
				    union samr_UserInfo *info)
{
	struct samr_QueryUserInfo2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = user_handle;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryUserInfo2, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_QUERYUSERINFO2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryUserInfo2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_QueryDisplayInfo2(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *domain_handle,
				       uint16_t level,
				       uint32_t start_idx,
				       uint32_t max_entries,
				       uint32_t buf_size,
				       uint32_t *total_size,
				       uint32_t *returned_size,
				       union samr_DispInfo *info)
{
	struct samr_QueryDisplayInfo2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.level = level;
	r.in.start_idx = start_idx;
	r.in.max_entries = max_entries;
	r.in.buf_size = buf_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryDisplayInfo2, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_QUERYDISPLAYINFO2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryDisplayInfo2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*total_size = *r.out.total_size;
	*returned_size = *r.out.returned_size;
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_GetDisplayEnumerationIndex2(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 struct policy_handle *domain_handle,
						 uint16_t level,
						 struct lsa_String name,
						 uint32_t *idx)
{
	struct samr_GetDisplayEnumerationIndex2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.level = level;
	r.in.name = name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_GetDisplayEnumerationIndex2, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_GETDISPLAYENUMERATIONINDEX2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_GetDisplayEnumerationIndex2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*idx = *r.out.idx;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_CreateUser2(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *domain_handle,
				 struct lsa_String *account_name,
				 uint32_t acct_flags,
				 uint32_t access_mask,
				 struct policy_handle *user_handle,
				 uint32_t *access_granted,
				 uint32_t *rid)
{
	struct samr_CreateUser2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.account_name = account_name;
	r.in.acct_flags = acct_flags;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_CreateUser2, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_CREATEUSER2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_CreateUser2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*user_handle = *r.out.user_handle;
	*access_granted = *r.out.access_granted;
	*rid = *r.out.rid;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_QueryDisplayInfo3(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *domain_handle,
				       uint16_t level,
				       uint32_t start_idx,
				       uint32_t max_entries,
				       uint32_t buf_size,
				       uint32_t *total_size,
				       uint32_t *returned_size,
				       union samr_DispInfo *info)
{
	struct samr_QueryDisplayInfo3 r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.level = level;
	r.in.start_idx = start_idx;
	r.in.max_entries = max_entries;
	r.in.buf_size = buf_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_QueryDisplayInfo3, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_QUERYDISPLAYINFO3,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_QueryDisplayInfo3, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*total_size = *r.out.total_size;
	*returned_size = *r.out.returned_size;
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_AddMultipleMembersToAlias(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *alias_handle,
					       struct lsa_SidArray *sids)
{
	struct samr_AddMultipleMembersToAlias r;
	NTSTATUS status;

	/* In parameters */
	r.in.alias_handle = alias_handle;
	r.in.sids = sids;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_AddMultipleMembersToAlias, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_ADDMULTIPLEMEMBERSTOALIAS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_AddMultipleMembersToAlias, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_RemoveMultipleMembersFromAlias(struct rpc_pipe_client *cli,
						    TALLOC_CTX *mem_ctx,
						    struct policy_handle *alias_handle,
						    struct lsa_SidArray *sids)
{
	struct samr_RemoveMultipleMembersFromAlias r;
	NTSTATUS status;

	/* In parameters */
	r.in.alias_handle = alias_handle;
	r.in.sids = sids;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_RemoveMultipleMembersFromAlias, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_REMOVEMULTIPLEMEMBERSFROMALIAS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_RemoveMultipleMembersFromAlias, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_OemChangePasswordUser2(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    struct lsa_AsciiString *server,
					    struct lsa_AsciiString *account,
					    struct samr_CryptPassword *password,
					    struct samr_Password *hash)
{
	struct samr_OemChangePasswordUser2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = server;
	r.in.account = account;
	r.in.password = password;
	r.in.hash = hash;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_OemChangePasswordUser2, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_OEMCHANGEPASSWORDUSER2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_OemChangePasswordUser2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_ChangePasswordUser2(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct lsa_String *server,
					 struct lsa_String *account,
					 struct samr_CryptPassword *nt_password,
					 struct samr_Password *nt_verifier,
					 uint8_t lm_change,
					 struct samr_CryptPassword *lm_password,
					 struct samr_Password *lm_verifier)
{
	struct samr_ChangePasswordUser2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = server;
	r.in.account = account;
	r.in.nt_password = nt_password;
	r.in.nt_verifier = nt_verifier;
	r.in.lm_change = lm_change;
	r.in.lm_password = lm_password;
	r.in.lm_verifier = lm_verifier;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_ChangePasswordUser2, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_CHANGEPASSWORDUSER2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_ChangePasswordUser2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_GetDomPwInfo(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct lsa_String *domain_name,
				  struct samr_PwInfo *info)
{
	struct samr_GetDomPwInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_name = domain_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_GetDomPwInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_GETDOMPWINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_GetDomPwInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_Connect2(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      const char *system_name,
			      uint32_t access_mask,
			      struct policy_handle *connect_handle)
{
	struct samr_Connect2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = system_name;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_Connect2, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_CONNECT2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_Connect2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*connect_handle = *r.out.connect_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_SetUserInfo2(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *user_handle,
				  uint16_t level,
				  union samr_UserInfo *info)
{
	struct samr_SetUserInfo2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_handle = user_handle;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetUserInfo2, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_SETUSERINFO2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetUserInfo2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_SetBootKeyInformation(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *connect_handle,
					   uint32_t unknown1,
					   uint32_t unknown2,
					   uint32_t unknown3)
{
	struct samr_SetBootKeyInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.connect_handle = connect_handle;
	r.in.unknown1 = unknown1;
	r.in.unknown2 = unknown2;
	r.in.unknown3 = unknown3;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetBootKeyInformation, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_SETBOOTKEYINFORMATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetBootKeyInformation, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_GetBootKeyInformation(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *domain_handle,
					   uint32_t *unknown)
{
	struct samr_GetBootKeyInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_GetBootKeyInformation, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_GETBOOTKEYINFORMATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_GetBootKeyInformation, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*unknown = *r.out.unknown;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_Connect3(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      const char *system_name,
			      uint32_t unknown,
			      uint32_t access_mask,
			      struct policy_handle *connect_handle)
{
	struct samr_Connect3 r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = system_name;
	r.in.unknown = unknown;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_Connect3, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_CONNECT3,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_Connect3, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*connect_handle = *r.out.connect_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_Connect4(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      const char *system_name,
			      uint32_t unknown,
			      uint32_t access_mask,
			      struct policy_handle *connect_handle)
{
	struct samr_Connect4 r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = system_name;
	r.in.unknown = unknown;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_Connect4, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_CONNECT4,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_Connect4, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*connect_handle = *r.out.connect_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_ChangePasswordUser3(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct lsa_String *server,
					 struct lsa_String *account,
					 struct samr_CryptPassword *nt_password,
					 struct samr_Password *nt_verifier,
					 uint8_t lm_change,
					 struct samr_CryptPassword *lm_password,
					 struct samr_Password *lm_verifier,
					 struct samr_CryptPassword *password3,
					 struct samr_DomInfo1 *dominfo,
					 struct samr_ChangeReject *reject)
{
	struct samr_ChangePasswordUser3 r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = server;
	r.in.account = account;
	r.in.nt_password = nt_password;
	r.in.nt_verifier = nt_verifier;
	r.in.lm_change = lm_change;
	r.in.lm_password = lm_password;
	r.in.lm_verifier = lm_verifier;
	r.in.password3 = password3;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_ChangePasswordUser3, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_CHANGEPASSWORDUSER3,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_ChangePasswordUser3, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*dominfo = *r.out.dominfo;
	*reject = *r.out.reject;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_Connect5(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      const char *system_name,
			      uint32_t access_mask,
			      uint32_t level_in,
			      union samr_ConnectInfo *info_in,
			      uint32_t *level_out,
			      union samr_ConnectInfo *info_out,
			      struct policy_handle *connect_handle)
{
	struct samr_Connect5 r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = system_name;
	r.in.access_mask = access_mask;
	r.in.level_in = level_in;
	r.in.info_in = info_in;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_Connect5, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_CONNECT5,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_Connect5, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*level_out = *r.out.level_out;
	*info_out = *r.out.info_out;
	*connect_handle = *r.out.connect_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_RidToSid(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct policy_handle *domain_handle,
			      uint32_t rid,
			      struct dom_sid2 *sid)
{
	struct samr_RidToSid r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_handle = domain_handle;
	r.in.rid = rid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_RidToSid, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_RIDTOSID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_RidToSid, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sid = *r.out.sid;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_SetDsrmPassword(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct lsa_String *name,
				     uint32_t unknown,
				     struct samr_Password *hash)
{
	struct samr_SetDsrmPassword r;
	NTSTATUS status;

	/* In parameters */
	r.in.name = name;
	r.in.unknown = unknown;
	r.in.hash = hash;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_SetDsrmPassword, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_SETDSRMPASSWORD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_SetDsrmPassword, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_samr_ValidatePassword(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      enum samr_ValidatePasswordLevel level,
				      union samr_ValidatePasswordReq req,
				      union samr_ValidatePasswordRep *rep)
{
	struct samr_ValidatePassword r;
	NTSTATUS status;

	/* In parameters */
	r.in.level = level;
	r.in.req = req;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(samr_ValidatePassword, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				PI_SAMR,
				&ndr_table_samr,
				NDR_SAMR_VALIDATEPASSWORD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(samr_ValidatePassword, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*rep = *r.out.rep;

	/* Return result */
	return r.out.result;
}

