#!/bin/sh -e

# Are we a mac?
if test -d /proc/pmu; then
        batteries=$(grep Battery /proc/pmu/info| cut -f2 -d:)
        if test "$batteries" -ne 0; then
                echo "We're a laptop";
                exit 0
        fi
        exit 1
fi

# dmidecode to grab the Chassis type
dmitype=$(dmidecode|grep Chassis -A 10|grep -m1 Type|sed -e 's/.*Type: \(.*\)/\1/')

if test "$dmitype" = "Notebook" || test "$dmitype" = "Portable"; then
        echo "We're a laptop";
        exit 0;
fi

# turn back on for debugging
#echo "$dmitype"

# check for any ACPI batteries
if [ -d /proc/acpi/battery ]; then
        results=`find /proc/acpi/battery/ -type d -mindepth 1`
        if [ ! -z "$results" ]; then
        #we're almost certainly a laptop
                echo "We're a laptop";
                exit 0
        fi
fi

#probably not a laptop; exit 
exit 1
