#!/bin/sh -e

# Are we a mac?
if test -d /proc/pmu; then
        batteries=$(grep Battery /proc/pmu/info| cut -f2 -d:)
        if test "$batteries" -ne 0; then
#                echo "We're a laptop" &>2;
                exit 0
        fi
        exit 1
fi

if [ -r /dev/mem -a -x /usr/sbin/dmidecode ]; then
        # dmidecode to grab the Chassis type
        dmitype=$(dmidecode -s chassis-type)

        if test "$dmitype" = "Notebook" || test "$dmitype" = "Portable"; then
#               echo "We're a laptop" >&2;
                exit 0;
        fi

        # turn back on for debugging
        #echo "$dmitype"
fi

# check for any ACPI batteries
if [ -d /proc/acpi/battery ]; then
        results=`find /proc/acpi/battery/ -mindepth 1 -type d`
        if [ ! -z "$results" ]; then
        #we're almost certainly a laptop
#                echo "We're a laptop" >&2;
                exit 0
        fi
fi

# check for APM batteries. This sucks, because we'll only get a valid response
# if the laptop has a battery fitted at the time
if [ -f /proc/apm ]; then
    battery=`awk '{print $6}' </proc/apm`
    if [ "$battery" != "0xff" ] && [ "$battery" != "0x80" ]; then
	# There's a battery
	exit 0;
    fi
fi

#probably not a laptop; exit 
exit 1
