/***************************************************************************
 *
 * knetworkmanager-nminfo.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig        <thoenig@suse.de>, <thoenig@nouse.net>
 *         Valentine Sinitsyn <e_val@inbox.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <kdebug.h>
#include "knetworkmanager.h"
#include "knetworkmanager-nminfo_dbus.h"
#include "knetworkmanager-dialogfab.h"
#include "knetworkmanager-encryption.h"
#include "knetworkmanager-storage.h"
#include "knetworkmanager-vpn.h"

#include "knetworkmanager-nminfo.h"

void
NetworkManagerInfo::sendPassphrase (Network* net)
{
	NetworkManagerInfoDBus::sendKeyForNetwork (net);
}

void
NetworkManagerInfo::sendPassphraseError ()
{
	NetworkManagerInfoDBus::sendGetKeyError ();
}

void
NetworkManagerInfo::acquirePassphrase (QString obj_path, QString net_path, QString essid, bool new_key)
{
	kdDebug () << k_funcinfo << " fork ahead: user or storage" << endl;
	Network *net = getNetworkProperties(essid);
	bool handled = false;

	// Do we have a key in the KWallet? 
	if (!new_key && net) {
		if (net->getEncryption ()->hasStoredKey ()) {
			SecretMap storedSecret = KNetworkManagerStorage::getInstance ()->credentials(essid);
			if (!storedSecret.isEmpty ()) {
				net->getEncryption ()->setSecrets (storedSecret);

				if (net->getEncryption ()->isValid (essid)) {
					kdDebug () << k_funcinfo << " using secure storage to respond to getKeyForNetwork " << net->getEssid () << endl;
					sendPassphrase (net);
					handled = true;
				}	
			} else {
				kdDebug () << k_funcinfo << " network " << net->getEssid () << "is said to have stored key but there is no such data in the wallet" << endl;
			}
		}
	}
	
	if (handled) {
		delete net;
		return;
	}

	// No, we don't - ask the user
	kdDebug () << k_funcinfo << " asking user: getKeyForNetwork " <<  essid << endl;
	AcquirePasswordDialog* dlg = new AcquirePasswordDialog (_ctx->getTray (), "PassphraseDialog", true, WDestructiveClose, _ctx, obj_path, net_path, essid);
	dlg->show ();
}

QStringList
NetworkManagerInfo::getNetworks ()
{
 	return KNetworkManagerStorage::getInstance ()->networks ();
}

Network*
NetworkManagerInfo::getNetworkProperties (const QString & essid)
{
 	return KNetworkManagerStorage::getInstance ()->networkProperties (essid);
}

void 
NetworkManagerInfo::emitNetworkUpdated (Network* net, bool automatic)
{
	emit networkUpdated (net, automatic);
}

VPNConnection*
NetworkManagerInfo::getVPNConnection (const QString & name)
{
	VPN*           vpn           = _ctx->getVPN ();
	VPNConnection* vpnConnection = NULL;

	if (vpn && vpn->isAvailable ()) {
		VPNList* vpnList = vpn->getVPNList ();

		for (VPNList::iterator i = vpnList->begin (); i != vpnList->end (); ++i) {
			if ((*i)->getName () == name)
				vpnConnection = *i;
		}
	}

	return vpnConnection;
}

QStringList
NetworkManagerInfo::getVPNConnectionNames ()
{
	VPN*        vpn = _ctx->getVPN ();
	QStringList vpnConnectionNames;

	if (vpn && vpn->isAvailable ()) {
		VPNList* vpnList = vpn->getVPNList ();
		
		for (VPNList::iterator i = vpnList->begin (); i != vpnList->end (); ++i) {
			vpnConnectionNames.append ((*i)->getName ());
		}
	}

	return vpnConnectionNames;
}

void
NetworkManagerInfo::push (KNetworkManager* ctx)
{
	NetworkManagerInfoDBus::push (ctx);
	_ctx = ctx;
}

NetworkManagerInfo::NetworkManagerInfo ()
{

}

NetworkManagerInfo::~NetworkManagerInfo ()
{

}

#include "knetworkmanager-nminfo.moc"
