/***************************************************************************
 *   kio-locate: KDE I/O Slave for the locate command                      *
 *                                                                         *
 *   Copyright (C) 2005 by Tobi Vollebregt                                 *
 *   tobivollebregt@gmail.com                                              *
 *                                                                         *
 *   Thanks to Google's Summer Of Code Program!                            *
 *                                                                         *
 *   Copyright (C) 2004 by Armin Straub                                    *
 *   linux@arminstraub.de                                                  *
 *                                                                         *
 *   This program was initially written by Michael Schuerig.               *
 *   Although I have completely rewritten it, most ideas are adopted       *
 *   from his original work.                                               *
 *                                                                         *
 *   Copyright (C) 2002 by Michael Schuerig                                *
 *   michael@schuerig.de                                                   *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qtextcodec.h>

#include <kdebug.h>

#include "locater.h"


Locater::Locater(QObject *parent, const char *name)
	: QObject(parent, name), m_process(QTextCodec::codecForLocale())
{
	DEBUGSTR << "Locater::Locater" << endl;

	connect(&m_process, SIGNAL(processExited(KProcess*)),
			 this, SLOT(finished(KProcess*)));
	connect(&m_process, SIGNAL(readReady(KProcIO*)),
			 this, SLOT(gotOutput(KProcIO*)));

	setupLocate();
}


Locater::~Locater()
{
	DEBUGSTR << "Locater::~Locater" << endl;
}


void Locater::setupLocate(const QString& binary, const QString& additionalArguments)
{
	DEBUGSTR << "Locater::setupLocate(" << binary << ", " << additionalArguments << ")" << endl;

	m_locateBinary = binary;
	m_locateAdditionalArguments = additionalArguments;
}


void Locater::locate(const QString& pattern, bool ignoreCase, bool regExp)
{
	DEBUGSTR << "Locater::locate(" << pattern << "," << ignoreCase << "," << regExp << ")" << endl;

	m_process.resetAll();
	m_process << m_locateBinary;
	if (!m_locateAdditionalArguments.isEmpty()) {
		m_process << m_locateAdditionalArguments;
	}
	if (ignoreCase) {
		// m_process << "--ignore-case";
		m_process << "-i";
	}
	if (regExp) {
		m_process << "-r";
	}
	m_process << pattern;

	bool started = m_process.start(KProcess::Block, false);

	if (!started) {
		emit finished();
	}
}

void Locater::stop()
{
	DEBUGSTR << "Locater::stop()" << endl;

	m_process.kill();
	emit finished();
}


void Locater::gotOutput(KProcIO* /*proc*/)
{
	//DEBUGSTR << "Locater::gotOutput" << endl;

	QStringList items;
	QString line;

	while (m_process.readln(line) != -1) {
		//DEBUGSTR << "OUTPUT>> '" << line << "'" << endl;

		items << line;
	}

	emit found(items);
}


void Locater::finished(KProcess* /*proc*/)
{
	DEBUGSTR << "Locater::finished" << endl;

	emit finished();
}


#include "locater.moc"
