/**********************************************************************
  StickEngine - Engine for "stick" display

  Copyright (C) 2006-2007 Geoffrey R. Hutchison <geoff@geoffhutchison.net>

  This file is part of the Avogadro molecular editor project.
  For more information, see <http://avogadro.sourceforge.net/>

  Avogadro is free software; you can redistribute it and/or modify 
  it under the terms of the GNU General Public License as published by 
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  Avogadro is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
 **********************************************************************/

#ifndef __STICKENGINE_H
#define __STICKENGINE_H

#include <avogadro/global.h>
#include <avogadro/engine.h>

#include <openbabel/mol.h>

#include <QGLWidget>
#include <QObject>
#include <QImage>

namespace Avogadro {

  //! Ball and Stick Engine class.
  class StickEngine : public Engine
  {
    Q_OBJECT

    public:
      //! Constructor
      StickEngine(QObject *parent=0) : Engine(parent), m_glwidget(0), m_update(true) {}
      //! Deconstructor
      ~StickEngine();

      //! \name Description methods
      //@{
      //! @return engine name
      QString name() { return(QString(tr("Stick"))); }
      //! @return engine description
      QString description() { return(QString(tr("Renders as Cylinders"))); }
      //@}

      //! \name Render Methods
      //@{
      //! Render an Atom.
      bool render(const Atom *a);
      //! Render a Bond.
      bool render(const Bond *b);
      //! Render a Molecule.
      bool render(const Molecule *m);

      bool render(GLWidget *gl);
      //@}

      void addPrimitive(Primitive *);
      void updatePrimitive(Primitive *);
      void removePrimitive(Primitive *);

      double radius(const Primitive *p = 0);

    private:
      inline double radius(const Atom *a);

      GLWidget *m_glwidget;
      bool m_update;
  };

  //! Generates instances of our StickEngine class
  class StickEngineFactory : public QObject, public EngineFactory
  {
    Q_OBJECT
    Q_INTERFACES(Avogadro::EngineFactory)

    public:
      Engine *createInstance(QObject *parent = 0) { return new StickEngine(parent); }
  };

} // end namespace Avogadro

#endif
