//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef TRAYICON_H
#define TRAYICON_H

#include <ksystemtray.h>
#include <kpixmap.h>
#include <libkbluetooth/adapter.h>
#include <qobject.h>
#include <dcopobject.h>
#include <map>

class QTimer;
class KToggleAction;
class KAction;
class KActionMenu;
class KPopupMenu;
class KHelpMenu;
class KBluetoothdApp;
namespace KBluetooth {
    class DeviceAddress;
}

/**
@author Fred Schaettgen
*/
class TrayIcon : public KSystemTray
{
Q_OBJECT
public:
    TrayIcon(KBluetoothdApp* app);
    ~TrayIcon();
    void setAlwaysShowIcon(bool state);
    void setAdapterMonitor(bool state);

public slots:
    void slotConnectionStateChanged();
    void slotDeviceFound();
    void slotDeviceLost();
    void slotNoStartupDevice();
    void slotMruMenuUpdate();

private slots:
   // void slotQuitSelected();
    void slotShowIconToggled(bool);
    void slotServiceConfig();
    void slotPairedConfig();
    void slotDeviceConfig();
    void slotConfigureNotifications();
    void slotShowMonitor();
    void slotQuitSelected();
    void slotReportBug();
    void slotAbout();
    void slotShowHelp();
    void updateIcon();
    void slotMruServicesClear();
    void mruItemClicked(int id);
    void slotConnectionComplete(int status, KBluetooth::DeviceAddress addr);
        
protected:
    void mousePressEvent(QMouseEvent *e);
    virtual void closeEvent(QCloseEvent *e);

private:
    bool alwaysVisible;
    bool hasAdapter;
    bool acceptClose;
    //enum IconState {IDLE, CONNECTED};
    //IconState iconState;
    KPixmap iconIdle;
    KPixmap iconConnected;
    KPixmap iconNoAdapter;
    QTimer *blinkTimer;
    bool iconConnectingBlinkState;
    KToggleAction* showIconAction;
    KAction* adapterMonitorAction;
    KAction *serviceConfigAction;
    KAction *pairedConfigAction;
    KAction *deviceConfigAction;
    KAction *showMonitorAction;
    KAction *showHelpAction;
    KActionMenu *configActionMenu;
    KActionMenu *helpActionMenu;
    KAction *mruClearAction;
    KPopupMenu *mruMenu;
    KBluetoothdApp* app;
    KHelpMenu *helpMenu;
    struct Connection {
        KBluetooth::Adapter::ConnectionState state;
    };
    std::map<KBluetooth::DeviceAddress, Connection> connections;
    const int usedServicesBase;
    const int seenDevicesBase;
    std::map<QString, KPixmap> mruAppIconMap;
    std::map<QString, KPixmap> devClassIconMap;
            
    QString localAndEnglish(const QCString& s);
    void plugAdapterMonitorAction();
    void adjustAdapterMonitorActionText();
};

#endif
