/***************************************************************************
 *   Copyright (C) 2004 by Fred Schaettgen <kdebluetooth@schaettgen.de>*
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "pageddeviceswidget.h"
#include <libkbluetooth/deviceinputwidget.h>
#include "klistview.h"
#include "qdatetimeedit.h"
#include "qpushbutton.h"
#include <libkbluetooth/namecache.h>
#include <qdatetime.h>
#include <kmessagebox.h>
#include <klocale.h>

PagedDevicesWidget::PagedDevicesWidget(QWidget *parent) :
    PagedDevicesBase(parent)
{
    connect(addButton, SIGNAL(clicked()), this, SLOT(addDevice()));
    connect(deleteButton, SIGNAL(clicked()), this, SLOT(deleteDevice()));
    connect(deviceList, SIGNAL(selectionChanged()), this, SLOT(selectionChanged()));
    connect(timeEdit, SIGNAL(valueChanged(const QTime&)), 
        this, SLOT(intervalChanged(const QTime&)));
}


PagedDevicesWidget::~PagedDevicesWidget()
{
}

void PagedDevicesWidget::addDevice()
{
    KBluetooth::DeviceAddress addr;
    if (KBluetooth::DeviceInputWidget::showSelectionDialog(this, addr, true)) {
        devInfos[QString(addr)].interval = 300;       
        updateInterface();
        emit dirty();
    }
}

void PagedDevicesWidget::updateInterface()
{
    deviceList->clear();
    std::map<QString,DevInfo>::const_iterator devIt;
    for (devIt = devInfos.begin(); devIt != devInfos.end(); ++devIt) {
        QListViewItem* newItem = new QListViewItem(deviceList, devIt->first);
        QString devName;
        KBluetooth::NameCache::getCachedName(KBluetooth::DeviceAddress(devIt->first), devName);
        newItem->setText(1, devName);
        newItem->setText(2, QTime().addSecs(devIt->second.interval).toString("hh:mm:ss"));
    }
}

void PagedDevicesWidget::deleteDevice()
{
    if (deviceList->selectedItem()) {
        QString devAddr = deviceList->selectedItem()->text(0);
        if (devInfos.find(devAddr) != devInfos.end()) {
            if (KMessageBox::questionYesNo(this, i18n(
"Do you really want to remove device %1?").arg(devAddr)) == KMessageBox::Yes) {
                devInfos.erase(devInfos.find(devAddr));
                updateInterface();
                emit dirty();
            }
        }
    }
}


void PagedDevicesWidget::selectionChanged()
{
    QListViewItem* item = deviceList->selectedItem();
    if (item) {
        QString addr = item->text(0);
        if (devInfos.find(addr) != devInfos.end()) {
            timeEdit->setEnabled(true);
            timeEdit->setTime(QTime().addSecs(devInfos[addr].interval));
        }
        else {
            timeEdit->setEnabled(false);
        }
    }
    else {
        timeEdit->setEnabled(false);
    }
}

void PagedDevicesWidget::intervalChanged(const QTime& /*time*/)
{
    QListViewItem* item = deviceList->selectedItem();
    if (item) {
        QString addr = item->text(0);
        if (devInfos.find(addr) != devInfos.end()) {
            devInfos[addr].interval = QTime().secsTo(timeEdit->time());
            item->setText(2, QTime().addSecs(devInfos[addr].interval).toString("hh:mm:ss"));
            emit dirty();
        }   
    }
}

#include "pageddeviceswidget.moc"
