/*
 *
 *  KBluetooth4 - KDE Bluetooth Framework
 *
 *  Copyright (C) 2008  Tom Patzig <tpatzig@suse.de>
 *
 *  This file is part of kbluetooth4.
 *
 *  kbluetooth4 is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  kbluetooth4 is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth4; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
*/


#include "devicemanager.h"
#include <KDebug>
#include <KApplication>
#include <KProcess>
#include <KMessageBox>
#include <KLocale>
#include <QList>

#include <kjob.h>

DeviceMan::DeviceMan(QObject* parent) : Ui_DeviceManager()
{
//	 setAttribute(Qt::WA_DeleteOnClose);

	 Solid::Control::BluetoothManager &man = Solid::Control::BluetoothManager::self();

//	 iface = man.findBluetoothInterface(man.defaultInterface());
	 iface = new Solid::Control::BluetoothInterface(man.defaultInterface());
	 connect(iface,SIGNAL(trustAdded(const QString&)),this,SLOT(slotTrustAdded(const QString&)));
	 connect(iface,SIGNAL(trustRemoved(const QString&)),this,SLOT(slotTrustRemoved(const QString&)));

	 connect(&man,SIGNAL(inputDeviceCreated(const QString&)),this,SLOT(slotDeviceAdded(const QString&)));
	 connect(&man,SIGNAL(inputDeviceRemoved(const QString&)),this,SLOT(slotDeviceRemoved(const QString&)));

	 kDebug() << "Device Manager - Welcome";
//	 setParent(kapp);
	 setupUi(this);
	 setWindowIcon(KIcon("preferences-system-bluetooth"));

//	 connect(closeButton,SIGNAL(clicked(bool)),this,SLOT(slotQuitApp(bool)));
	 connect(newDevButton,SIGNAL(clicked(bool)),this,SLOT(slotStartWizard(bool)));
	 connect(removeButton,SIGNAL(clicked(bool)),this,SLOT(slotRemoveDevice(bool)));

	 connect(actionConnect,SIGNAL(triggered(bool)),this,SLOT(slotConnectDevice(bool)));
	 connect(actionRemove_Trust,SIGNAL(triggered(bool)),this,SLOT(slotChangeTrust(bool)));
	 connect(actionRemove,SIGNAL(triggered(bool)),this,SLOT(slotRemoveDevice(bool)));
	 connect(actionNew,SIGNAL(triggered(bool)),this,SLOT(slotStartWizard(bool)));

	 connect(menuEdit,SIGNAL(aboutToShow()),this,SLOT(slotMenuActive()));
	 
	 connect(deviceListWidget, SIGNAL(itemSelectionChanged()), this, SLOT(slotShowDetails()));

	 inputDeviceMap = new QMap<QString,Solid::Control::BluetoothInputDevice*>;
	 remoteDeviceMap = new QMap<QString,Solid::Control::BluetoothRemoteDevice*>;
	 show();
	 actionConnect->setEnabled(false);
	 actionRemove->setEnabled(false);
	 actionRemove_Trust->setEnabled(false);
	 removeButton->setEnabled(false);
	 
	 actionQuit->setIcon(KIcon("window-close"));
	 actionConnect->setIcon(KIcon("applications-internet"));
	 actionRemove->setIcon(KIcon("user-trash"));
	 actionNew->setIcon(KIcon("list-add"));
	 actionRemove_Trust->setIcon(KIcon("dialog-password"));
	 
	 current = 0;
	 
	 getConfiguredDevices();
}

DeviceMan::~DeviceMan()
{
	if ( inputDeviceMap->size() > 0 ) {
		qDeleteAll (inputDeviceMap->begin(),inputDeviceMap->end());
		inputDeviceMap->clear();
	}
	if (inputDeviceMap)
  //      	delete inputDeviceMap;
	kDebug() << "inputDeviceMap deleted";

	if ( remoteDeviceMap->size() > 0 ) { 
		qDeleteAll (remoteDeviceMap->begin(),remoteDeviceMap->end());
		remoteDeviceMap->clear();
	}
	if (remoteDeviceMap)
//	        delete remoteDeviceMap;
	kDebug() << "remoteDeviceMap deleted";
	if (iface)
//		delete iface;

	kDebug() << "Device Manager closed";
}


void DeviceMan::slotQuitApp(bool set)
{
        close();
}

void DeviceMan::slotStartWizard(bool)
{
	kDebug() << "Starting Wizard";
	KProcess process;
	process.setProgram("kbluetooth4-inputwizard");
	process.execute();

}

void DeviceMan::getConfiguredDevices()
{
	Solid::Control::BluetoothManager &man = Solid::Control::BluetoothManager::self();
	
	devList = man.bluetoothInputDevices();
	
	kDebug() << "Device List Size: " << devList.size();	
	if (devList.size() > 0) {
		Solid::Control::BluetoothInputDevice dev;
		foreach(dev,devList) {
			kDebug() << dev.name();
			deviceListWidget->addItem(dev.name());
			Solid::Control::BluetoothInputDevice* device = man.createBluetoothInputDevice(dev.ubi());
			inputDeviceMap->insert(dev.address(),device);	
			Solid::Control::BluetoothRemoteDevice* rem = iface->createBluetoothRemoteDevice(dev.address());
			remoteDeviceMap->insert(dev.address(),rem);	
		}

		Solid::Control::BluetoothRemoteDevice* remDev;
		foreach(remDev,remoteDeviceMap->values()) {
			connect(remDev,SIGNAL(disconnected()),this,SLOT(slotDeviceDisconnected()));
			connect(remDev,SIGNAL(connected()),this,SLOT(slotDeviceConnected()));
			kDebug() << "device from Map: " << remDev->name();
			foreach(QString dclass, remDev->serviceClasses()) {
				kDebug() << dclass;
			}

		}
		deviceListWidget->setCurrentRow(0);
		//slotShowDetails(deviceListWidget->item(0));
	}
	//connect(deviceListWidget, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotShowDetails(QListWidgetItem*)));

}

void DeviceMan::slotShowDetails()
{
	current = deviceListWidget->currentItem();
	if(deviceListWidget->selectedItems().size() == 0) {
		current = 0;
	}
	statusbar->clearMessage();
	if (current) {
		actionConnect->setEnabled(true);
		actionRemove->setEnabled(true);
		actionRemove_Trust->setEnabled(true);
		removeButton->setEnabled(true);

		Solid::Control::BluetoothInputDevice dev;
		foreach(dev,devList) {
			if (current->text() == dev.name())
				break;
		}

		Solid::Control::BluetoothRemoteDevice* remoteDev = remoteDeviceMap->value(dev.address());
		
		addressLabel->setText(dev.address());
		QString status;
		if (dev.isConnected()) {
			status = tr("Connected");
			actionConnect->setText("Disconnect");
		} else {
			status = tr("Not connected");
			actionConnect->setText("Connect");
		}

		QString trustVal;
		if (iface->isTrusted(dev.address())) {
			trustVal = tr("Always trust");
			actionRemove_Trust->setText(tr("Remove Trust"));
		} else {
			trustVal = tr("Not trusted");
			actionRemove_Trust->setText(tr("Set Trusted"));
		}

		trustLabel->setText(trustVal);
		statusLabel->setText(status);
		typeLabel->setText(remoteDev->majorClass() + ", " + remoteDev->minorClass());
		iconLabel->setPixmap(findIcon(remoteDev->majorClass(),remoteDev->minorClass()).pixmap(64,64));

	} else {
		actionConnect->setEnabled(false);
		actionRemove->setEnabled(false);
		actionRemove_Trust->setEnabled(false);
		removeButton->setEnabled(false);

		addressLabel->setText("");
		actionConnect->setText(tr("Connect"));
		statusLabel->setText("");
		typeLabel->setText("");
		trustLabel->setText("");
		iconLabel->setPixmap(0);
	}
}

void DeviceMan::slotConnectDevice(bool /*click*/)
{
	current = deviceListWidget->currentItem();
	if (!current)
		return;
	Solid::Control::BluetoothInputDevice dev;
        foreach(dev,devList) {
                if (current->text() == dev.name())
                        break;
        }
	if (dev.isConnected()) {
		dev.slotDisconnect();
		kDebug() << "Device disconnected";
	} else {
		dev.slotConnect();
		kDebug() << "Device connected";
	}
}

void DeviceMan::slotRemoveDevice(bool /*click*/)
{
	kDebug() << "slotRemoveDevice" ;
	current = deviceListWidget->currentItem();
	if (!current)
		return;
	Solid::Control::BluetoothInputDevice dev;
	dev.slotDisconnect();
        foreach(dev,devList) {
                if (current->text() == dev.name())
                        break;
        }

	if(remoteDeviceMap->value(dev.address())->hasBonding()) {
		remoteDeviceMap->value(dev.address())->removeBonding();
	}

	inputDeviceMap->remove(dev.address());
	remoteDeviceMap->remove(dev.address());
	deviceListWidget->removeItemWidget(deviceListWidget->findItems(dev.name(),Qt::MatchExactly).at(0));
	deviceListWidget->takeItem(deviceListWidget->currentRow());
	current = 0;

	Solid::Control::BluetoothManager &man = Solid::Control::BluetoothManager::self();
	man.removeInputDevice(dev.ubi());
	devList = man.bluetoothInputDevices();
}

void DeviceMan::slotDeviceDisconnected()
{
	kDebug() << "slot Device Disconnect";
	if (current && (current->text() == deviceListWidget->currentItem()->text()) ) {
		statusLabel->setText(tr("Not connected"));
		actionConnect->setText(tr("Connect"));
		statusbar->showMessage(tr("Disconnected from ") + current->text()); 
	}
}

void DeviceMan::slotDeviceConnected()
{
	kDebug() << "slot Device Connect";
	if ( current && (current->text() == deviceListWidget->currentItem()->text()) ) {
		statusLabel->setText(tr("Connected"));
		actionConnect->setText(tr("Disconnect"));
		statusbar->showMessage(tr("Connected to ") + current->text());
	}
}

void DeviceMan::slotTrustAdded(const QString& mac)
{
	kDebug() << "Trust Added to " << mac;
	if ( current && (current->text() == deviceListWidget->currentItem()->text()) ) {
		trustLabel->setText(tr("Always trust"));
		actionRemove_Trust->setText(tr("Remove Trust"));
		statusbar->showMessage(tr("Permanent Trust added for ") + iface->getRemoteName(mac)); 
	}

}

void DeviceMan::slotTrustRemoved(const QString& mac)
{
	kDebug() << "Trust Removed to " << mac;
	if ( current && (current->text() == deviceListWidget->currentItem()->text()) ) {
		trustLabel->setText(tr("Not trusted"));
		actionRemove_Trust->setText(tr("Set Trusted"));
		statusbar->showMessage(tr("Permanent Trust removed for ") + iface->getRemoteName(mac));
	}

}

KIcon DeviceMan::findIcon(QString majorClass, QString minorClass)
{
	if (majorClass == "peripheral") {
		if (minorClass == "pointing")
			return KIcon("input-mouse");
		if (minorClass == "keyboard")
			return KIcon("input-keyboard");

	} else if (majorClass == "phone")
		return KIcon("phone");

	return KIcon();
}

void DeviceMan::slotDeviceAdded(const QString& ubi)
{
	kDebug() << "Device Added";
		
	Solid::Control::BluetoothInputDevice dev;
	foreach(dev,devList) {
		kDebug() << dev.name();
		if (dev.ubi() == ubi) {
			kDebug() << "Device " << ubi << "already exists.";
			return;
		} 
	} 

	Solid::Control::BluetoothManager &man = Solid::Control::BluetoothManager::self();
	
	Solid::Control::BluetoothInputDevice* device = man.createBluetoothInputDevice(ubi);
	inputDeviceMap->insert(device->address(),device);	
	Solid::Control::BluetoothRemoteDevice* rem = iface->createBluetoothRemoteDevice(device->address());
	remoteDeviceMap->insert(device->address(),rem);	
//	devList.append(*device);
	devList = man.bluetoothInputDevices();
	deviceListWidget->addItem(device->name());

	connect(rem,SIGNAL(disconnected()),this,SLOT(slotDeviceDisconnected()));
	connect(rem,SIGNAL(connected()),this,SLOT(slotDeviceConnected()));
}

void DeviceMan::slotDeviceRemoved(const QString& ubi)
{
	kDebug() << "Device Removed";
	Solid::Control::BluetoothManager &man = Solid::Control::BluetoothManager::self();

	Solid::Control::BluetoothInputDevice dev;
	foreach(dev,devList) {
		kDebug() << dev.name();
		if (dev.ubi() == ubi) {
			kDebug() << "Device " << dev.name() << " not removed ";
			break;
		} else 
			kDebug() << "Device " << ubi << " succesfully removed ";
	}
}

void DeviceMan::slotChangeTrust(bool clicked)
{
	
	current = deviceListWidget->currentItem();
	if (!current)
		return;
	Solid::Control::BluetoothInputDevice dev;
        foreach(dev,devList) {
                if (current->text() == dev.name())
                        break;
        }
	if (iface->isTrusted(dev.address())) {
		iface->removeTrust(dev.address());
		kDebug() << "Device Trust removed";
	} else {
		iface->setTrusted(dev.address());
		kDebug() << "Device Trust added";
	}



}

void DeviceMan::slotMenuActive()
{

	statusbar->clearMessage();

}

#include "devicemanager.moc" 
