//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Collections.Generic;

	/// <remarks>
	///  This combobox shows a number of recent URLs/directories, as well as some
	///  default directories.
	///  It will manage the default dirs root-directory, home-directory and
	///  Desktop-directory, as well as a number of URLs set via setUrls()
	///  and one additional entry to be set via setUrl().
	///  See <see cref="IKUrlComboBoxSignals"></see> for signals emitted by KUrlComboBox
	/// </remarks>		<author> Carsten Pfeiffer <pfeiffer@kde.org>
	///  </author>
	/// 		<short> A combo box showing a number of recent URLs/directories.</short>

	[SmokeClass("KUrlComboBox")]
	public class KUrlComboBox : KComboBox, IDisposable {
 		protected KUrlComboBox(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KUrlComboBox), this);
		}
		/// <remarks>
		///  This enum describes which kind of items is shown in the combo box.
		///      </remarks>		<short>    This enum describes which kind of items is shown in the combo box.</short>
		public enum Mode {
			Files = -1,
			Directories = 1,
			Both = 0,
		}
		/// <remarks>
		///  This Enumeration is used in setUrl() to determine which items
		///  will be removed when the given list is larger than maxItems().
		/// 
		/// <li>
		/// RemoveTop means that items will be removed from top
		/// </li>
		/// 
		/// <li>
		/// RemoveBottom means, that items will be removed from the bottom
		///      
		/// </li></remarks>		<short>    This Enumeration is used in setUrl() to determine which items  will be removed when the given list is larger than maxItems().</short>
		public enum OverLoadResolving {
			RemoveTop = 0,
			RemoveBottom = 1,
		}
		[Q_PROPERTY("QStringList", "urls")]
		public List<string> Urls {
			get { return (List<string>) interceptor.Invoke("urls", "urls()", typeof(List<string>)); }
			set { interceptor.Invoke("setUrls?", "setUrls(QStringList)", typeof(void), typeof(List<string>), value); }
		}
		[Q_PROPERTY("int", "maxItems")]
		public int MaxItems {
			get { return (int) interceptor.Invoke("maxItems", "maxItems()", typeof(int)); }
			set { interceptor.Invoke("setMaxItems$", "setMaxItems(int)", typeof(void), typeof(int), value); }
		}
		/// <remarks>
		///  Constructs a KUrlComboBox.
		/// <param> name="mode" is either Files, Directories or Both and controls the
		///  following behavior:
		/// </param>
		/// <li>
		/// Files  all inserted URLs will be treated as files, therefore the
		///             url shown in the combo will never show a trailing /
		///             the icon will be the one associated with the file's mimetype.
		/// </li>
		/// 
		/// <li>
		/// Directories  all inserted URLs will be treated as directories, will
		///                   have a trailing slash in the combobox. The current
		///                   directory will show the "open folder" icon, other
		///                   directories the "folder" icon.
		/// </li>
		/// 
		/// <li>
		/// Both  Don't mess with anything, just show the url as given.
		/// </li>
		/// <param> name="parent" The parent object of this widget.
		///      </param></remarks>		<short>    Constructs a KUrlComboBox.</short>
		public KUrlComboBox(KUrlComboBox.Mode mode, QWidget parent) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KUrlComboBox$#", "KUrlComboBox(KUrlComboBox::Mode, QWidget*)", typeof(void), typeof(KUrlComboBox.Mode), mode, typeof(QWidget), parent);
		}
		public KUrlComboBox(KUrlComboBox.Mode mode) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KUrlComboBox$", "KUrlComboBox(KUrlComboBox::Mode)", typeof(void), typeof(KUrlComboBox.Mode), mode);
		}
		public KUrlComboBox(KUrlComboBox.Mode mode, bool rw, QWidget parent) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KUrlComboBox$$#", "KUrlComboBox(KUrlComboBox::Mode, bool, QWidget*)", typeof(void), typeof(KUrlComboBox.Mode), mode, typeof(bool), rw, typeof(QWidget), parent);
		}
		public KUrlComboBox(KUrlComboBox.Mode mode, bool rw) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KUrlComboBox$$", "KUrlComboBox(KUrlComboBox::Mode, bool)", typeof(void), typeof(KUrlComboBox.Mode), mode, typeof(bool), rw);
		}
		/// <remarks>
		///  Sets the current url. This combo handles exactly one url additionally
		///  to the default items and those set via setUrls(). So you can call
		///  setUrl() as often as you want, it will always replace the previous one
		///  set via setUrl().
		///  If <code>url</code> is already in the combo, the last item will stay there
		///  and the existing item becomes the current item.
		///  The current item will always have the open-directory-pixmap as icon.
		///  Note that you won't receive any signals, e.g. textChanged(),
		///  returnPressed() or activated() upon calling this method.
		///      </remarks>		<short>    Sets the current url.</short>
		public void SetUrl(KUrl url) {
			interceptor.Invoke("setUrl#", "setUrl(const KUrl&)", typeof(void), typeof(KUrl), url);
		}
		/// <remarks>
		///  Inserts <code>urls</code> into the combobox below the "default urls" (see
		///  addDefaultUrl).
		///  If the list of urls contains more items than maxItems, the <code>remove</code>
		///  parameter determines whether the first or last items will be stripped.
		///      </remarks>		<short>    Inserts <code>urls</code> into the combobox below the "default urls" (see  addDefaultUrl).</short>
		public void SetUrls(List<string> urls, KUrlComboBox.OverLoadResolving remove) {
			interceptor.Invoke("setUrls?$", "setUrls(const QStringList&, KUrlComboBox::OverLoadResolving)", typeof(void), typeof(List<string>), urls, typeof(KUrlComboBox.OverLoadResolving), remove);
		}
		/// <remarks>
		///  Adds a url that will always be shown in the combobox, it can't be
		///  "rotated away". Default urls won't be returned in urls() and don't
		///  have to be set via setUrls().
		///  If you want to specify a special pixmap, use the overloaded method with
		///  the pixmap parameter.
		///  Default URLs will be inserted into the combobox by setDefaults()
		///      </remarks>		<short>    Adds a url that will always be shown in the combobox, it can't be  "rotated away".</short>
		public void AddDefaultUrl(KUrl url, string text) {
			interceptor.Invoke("addDefaultUrl#$", "addDefaultUrl(const KUrl&, const QString&)", typeof(void), typeof(KUrl), url, typeof(string), text);
		}
		public void AddDefaultUrl(KUrl url) {
			interceptor.Invoke("addDefaultUrl#", "addDefaultUrl(const KUrl&)", typeof(void), typeof(KUrl), url);
		}
		/// <remarks>
		///  Adds a url that will always be shown in the combobox, it can't be
		///  "rotated away". Default urls won't be returned in urls() and don't
		///  have to be set via setUrls().
		///  If you don't need to specify a pixmap, use the overloaded method without
		///  the pixmap parameter.
		///  Default URLs will be inserted into the combobox by setDefaults()
		///      </remarks>		<short>    Adds a url that will always be shown in the combobox, it can't be  "rotated away".</short>
		public void AddDefaultUrl(KUrl url, QIcon icon, string text) {
			interceptor.Invoke("addDefaultUrl##$", "addDefaultUrl(const KUrl&, const QIcon&, const QString&)", typeof(void), typeof(KUrl), url, typeof(QIcon), icon, typeof(string), text);
		}
		public void AddDefaultUrl(KUrl url, QIcon icon) {
			interceptor.Invoke("addDefaultUrl##", "addDefaultUrl(const KUrl&, const QIcon&)", typeof(void), typeof(KUrl), url, typeof(QIcon), icon);
		}
		/// <remarks>
		///  Clears all items and inserts the default urls into the combo. Will be
		///  called implicitly upon the first call to setUrls() or setUrl()
		/// </remarks>		<short>    Clears all items and inserts the default urls into the combo.</short>
		/// 		<see> addDefaultUrl</see>
		public void SetDefaults() {
			interceptor.Invoke("setDefaults", "setDefaults()", typeof(void));
		}
		/// <remarks>
		///  Removes any occurrence of <code>url.</code> If <code>checkDefaultUrls</code> is false
		///  default-urls won't be removed.
		///      </remarks>		<short>    Removes any occurrence of <code>url.</code></short>
		public void RemoveUrl(KUrl url, bool checkDefaultURLs) {
			interceptor.Invoke("removeUrl#$", "removeUrl(const KUrl&, bool)", typeof(void), typeof(KUrl), url, typeof(bool), checkDefaultURLs);
		}
		public void RemoveUrl(KUrl url) {
			interceptor.Invoke("removeUrl#", "removeUrl(const KUrl&)", typeof(void), typeof(KUrl), url);
		}
		~KUrlComboBox() {
			interceptor.Invoke("~KUrlComboBox", "~KUrlComboBox()", typeof(void));
		}
		public new void Dispose() {
			interceptor.Invoke("~KUrlComboBox", "~KUrlComboBox()", typeof(void));
		}
		protected new IKUrlComboBoxSignals Emit {
			get { return (IKUrlComboBoxSignals) Q_EMIT; }
		}
	}

	public interface IKUrlComboBoxSignals : IKComboBoxSignals {
		/// <remarks>
		///  Emitted when an item was clicked at.
		/// <param> name="url" is the url of the now current item. If it is a local url,
		///  it won't have a protocol (file:/), otherwise it will.
		///      </param></remarks>		<short>    Emitted when an item was clicked at.</short>
		[Q_SIGNAL("void urlActivated(const KUrl&)")]
		void UrlActivated(KUrl url);
	}
}
