//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Text;
	using System.Collections.Generic;

	/// <remarks>
	///  This class provides an interface to preferences settings. Preferences items
	///  can be registered by the addItem() function corresponding to the data type of
	///  the seetting. KConfigSkeleton then handles reading and writing of config files and
	///  setting of default values.
	///  Normally you will subclass KConfigSkeleton, add data members for the preferences
	///  settings and register the members in the constructor of the subclass.
	///  Example:
	///  <pre>
	///  class MyPrefs : public KConfigSkeleton
	///  {
	///    public      MyPrefs()
	///      {
	///        setCurrentGroup("MyGroup");
	///        addItemBool("MySetting1",mMyBool,false);
	///        addItemColor("MySetting2",mMyColor,QColor(1,2,3));
	///        setCurrentGroup("MyOtherGroup");
	///        addItemFont("MySetting3",mMyFont,QFont("helvetica",12));
	///      }
	///      bool mMyBool;
	///      QColor mMyColor;
	///      QFont mMyFont;
	///  }
	///  </pre>
	///  It might be convenient in many cases to make this subclass of KConfigSkeleton a
	///  singleton for global access from all over the application without passing
	///  references to the KConfigSkeleton object around.
	///  You can write the data to the configuration file by calling <see cref="#writeConfig"></see>
	///  and read the data from the configuration file by calling <see cref="#readConfig"></see>.
	///  If you want to watch for config changes, use <see cref="#configChanged"></see> signal.
	///  If you have items, which are not covered by the existing addItem() functions
	///  you can add customized code for reading, writing and default setting by
	///  implementing the functions <see cref="#usrUseDefaults"></see>, <see cref="#usrReadConfig"></see> and
	///  <see cref="#usrWriteConfig"></see>.
	///  Internally preferences settings are stored in instances of subclasses of
	///  <see cref="KConfigSkeletonItem"></see>. You can also add KConfigSkeletonItem subclasses
	///  for your own types and call the generic <see cref="#addItem"></see> to register them.
	///  In many cases you don't have to write the specific KConfigSkeleton
	///  subclasses yourself, but you can use \ref kconfig_compiler to automatically
	///  generate the C++ code from an XML description of the configuration options.
	///     See <see cref="IKConfigSkeletonSignals"></see> for signals emitted by KConfigSkeleton
	/// </remarks>		<author> Cornelius Schumacher
	/// </author>
	/// 		<short> Class for handling preferences settings for an application. </short>
	/// 		<see> KConfigSkeletonItem</see>

	[SmokeClass("KConfigSkeleton")]
	public class KConfigSkeleton : QObject, IDisposable {
 		protected KConfigSkeleton(Type dummy) : base((Type) null) {}

		/// <remarks>
		///  Class for handling a string preferences item.
		///    </remarks>		<short>    Class for handling a string preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemString")]
		public class ItemString : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemString(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemString), this);
			}
			// KConfigSkeleton::ItemString* ItemString(const QString& arg1,const QString& arg2,QString& arg3,const QString& arg4,KConfigSkeleton::ItemString::Type arg5); >>>> NOT CONVERTED
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem
			/// <param> name="type" The type of string held by the item
			///      </param></remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			public ItemString(string _group, string _key, StringBuilder reference, string defaultValue) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemString$$$$", "ItemString(const QString&, const QString&, QString&, const QString&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(StringBuilder), reference, typeof(string), defaultValue);
			}
			public ItemString(string _group, string _key, StringBuilder reference) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemString$$$", "ItemString(const QString&, const QString&, QString&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(StringBuilder), reference);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.WriteConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.WriteConfig(KConfig ) </short>
			public void WriteConfig(KConfig config) {
				interceptor.Invoke("writeConfig#", "writeConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>		<short>   @copydoc KConfigSkeletonItem.Property() </short>
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			~ItemString() {
				interceptor.Invoke("~ItemString", "~ItemString()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemString", "~ItemString()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling a password preferences item.
		///    </remarks>		<short>    Class for handling a password preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemPassword")]
		public class ItemPassword : KConfigSkeleton.ItemString, IDisposable {
	 		protected ItemPassword(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemPassword), this);
			}
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			public ItemPassword(string _group, string _key, StringBuilder reference, string defaultValue) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemPassword$$$$", "ItemPassword(const QString&, const QString&, QString&, const QString&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(StringBuilder), reference, typeof(string), defaultValue);
			}
			public ItemPassword(string _group, string _key, StringBuilder reference) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemPassword$$$", "ItemPassword(const QString&, const QString&, QString&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(StringBuilder), reference);
			}
			~ItemPassword() {
				interceptor.Invoke("~ItemPassword", "~ItemPassword()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~ItemPassword", "~ItemPassword()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling a path preferences item.
		///    </remarks>		<short>    Class for handling a path preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemPath")]
		public class ItemPath : KConfigSkeleton.ItemString, IDisposable {
	 		protected ItemPath(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemPath), this);
			}
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			public ItemPath(string _group, string _key, StringBuilder reference, string defaultValue) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemPath$$$$", "ItemPath(const QString&, const QString&, QString&, const QString&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(StringBuilder), reference, typeof(string), defaultValue);
			}
			public ItemPath(string _group, string _key, StringBuilder reference) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemPath$$$", "ItemPath(const QString&, const QString&, QString&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(StringBuilder), reference);
			}
			~ItemPath() {
				interceptor.Invoke("~ItemPath", "~ItemPath()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~ItemPath", "~ItemPath()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling a url preferences item.
		///      </remarks>		<short>    Class for handling a url preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemUrl")]
		public class ItemUrl : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemUrl(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemUrl), this);
			}
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem
			///          </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem          </short>
			public ItemUrl(string _group, string _key, KUrl reference, KUrl defaultValue) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemUrl$$##", "ItemUrl(const QString&, const QString&, KUrl&, const KUrl&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(KUrl), reference, typeof(KUrl), defaultValue);
			}
			public ItemUrl(string _group, string _key, KUrl reference) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemUrl$$#", "ItemUrl(const QString&, const QString&, KUrl&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(KUrl), reference);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.WriteConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.WriteConfig(KConfig ) </short>
			public void WriteConfig(KConfig config) {
				interceptor.Invoke("writeConfig#", "writeConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>		<short>   @copydoc KConfigSkeletonItem.Property() </short>
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			~ItemUrl() {
				interceptor.Invoke("~ItemUrl", "~ItemUrl()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemUrl", "~ItemUrl()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling a QVariant preferences item.
		///    </remarks>		<short>    Class for handling a QVariant preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemProperty")]
		public class ItemProperty : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemProperty(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemProperty), this);
			}
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			public ItemProperty(string _group, string _key, QVariant reference, QVariant defaultValue) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemProperty$$##", "ItemProperty(const QString&, const QString&, QVariant&, const QVariant&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QVariant), reference, typeof(QVariant), defaultValue);
			}
			public ItemProperty(string _group, string _key, QVariant reference) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemProperty$$#", "ItemProperty(const QString&, const QString&, QVariant&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QVariant), reference);
			}
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			~ItemProperty() {
				interceptor.Invoke("~ItemProperty", "~ItemProperty()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemProperty", "~ItemProperty()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling a bool preferences item.
		///    </remarks>		<short>    Class for handling a bool preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemBool")]
		public class ItemBool : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemBool(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemBool), this);
			}
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			public ItemBool(string _group, string _key, bool reference, bool defaultValue) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemBool$$$$", "ItemBool(const QString&, const QString&, bool&, bool)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(bool), reference, typeof(bool), defaultValue);
			}
			public ItemBool(string _group, string _key, bool reference) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemBool$$$", "ItemBool(const QString&, const QString&, bool&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(bool), reference);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>		<short>   @copydoc KConfigSkeletonItem.Property() </short>
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			~ItemBool() {
				interceptor.Invoke("~ItemBool", "~ItemBool()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemBool", "~ItemBool()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling a 32-bit integer preferences item.
		///    </remarks>		<short>    Class for handling a 32-bit integer preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemInt")]
		public class ItemInt : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemInt(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemInt), this);
			}
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			public ItemInt(string _group, string _key, int reference, int defaultValue) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemInt$$$$", "ItemInt(const QString&, const QString&, qint32&, qint32)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(int), reference, typeof(int), defaultValue);
			}
			public ItemInt(string _group, string _key, int reference) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemInt$$$", "ItemInt(const QString&, const QString&, qint32&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(int), reference);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>		<short>   @copydoc KConfigSkeletonItem.Property() </short>
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			/// <remarks> Get the minimum value that is allowed to be stored in this item </remarks>		<short>   Get the minimum value that is allowed to be stored in this item </short>
			public QVariant MinValue() {
				return (QVariant) interceptor.Invoke("minValue", "minValue() const", typeof(QVariant));
			}
			/// <remarks> Get the maximum value this is allowed to be stored in this item </remarks>		<short>   Get the maximum value this is allowed to be stored in this item </short>
			public QVariant MaxValue() {
				return (QVariant) interceptor.Invoke("maxValue", "maxValue() const", typeof(QVariant));
			}
			/// <remarks> Set the minimum value for the item
			///         @sa minValue()
			///      </remarks>		<short>   Set the minimum value for the item         @sa minValue()      </short>
			public void SetMinValue(int arg1) {
				interceptor.Invoke("setMinValue$", "setMinValue(qint32)", typeof(void), typeof(int), arg1);
			}
			/// <remarks> Set the maximum value for the item
			///         @sa maxValue
			///      </remarks>		<short>   Set the maximum value for the item         @sa maxValue      </short>
			public void SetMaxValue(int arg1) {
				interceptor.Invoke("setMaxValue$", "setMaxValue(qint32)", typeof(void), typeof(int), arg1);
			}
			~ItemInt() {
				interceptor.Invoke("~ItemInt", "~ItemInt()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemInt", "~ItemInt()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling a 64-bit integer preferences item.
		///    </remarks>		<short>    Class for handling a 64-bit integer preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemLongLong")]
		public class ItemLongLong : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemLongLong(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemLongLong), this);
			}
			// KConfigSkeleton::ItemLongLong* ItemLongLong(const QString& arg1,const QString& arg2,qint64& arg3,qint64 arg4); >>>> NOT CONVERTED
			// KConfigSkeleton::ItemLongLong* ItemLongLong(const QString& arg1,const QString& arg2,qint64& arg3); >>>> NOT CONVERTED
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>		<short>   @copydoc KConfigSkeletonItem.Property() </short>
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			/// <remarks> @copydoc ItemInt.MinValue() </remarks>		<short>   @copydoc ItemInt.MinValue() </short>
			public QVariant MinValue() {
				return (QVariant) interceptor.Invoke("minValue", "minValue() const", typeof(QVariant));
			}
			/// <remarks> @copydoc ItemInt.MaxValue() </remarks>		<short>   @copydoc ItemInt.MaxValue() </short>
			public QVariant MaxValue() {
				return (QVariant) interceptor.Invoke("maxValue", "maxValue() const", typeof(QVariant));
			}
			/// <remarks> @copydoc ItemInt.SetMinValue(qint32) </remarks>		<short>   @copydoc ItemInt.SetMinValue(qint32) </short>
			public void SetMinValue(long arg1) {
				interceptor.Invoke("setMinValue$", "setMinValue(qint64)", typeof(void), typeof(long), arg1);
			}
			/// <remarks> @copydoc ItemInt.SetMaxValue(qint32) </remarks>		<short>   @copydoc ItemInt.SetMaxValue(qint32) </short>
			public void SetMaxValue(long arg1) {
				interceptor.Invoke("setMaxValue$", "setMaxValue(qint64)", typeof(void), typeof(long), arg1);
			}
			~ItemLongLong() {
				interceptor.Invoke("~ItemLongLong", "~ItemLongLong()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemLongLong", "~ItemLongLong()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling enums.
		///    </remarks>		<short>    Class for handling enums.</short>

		[SmokeClass("KConfigSkeleton::ItemEnum")]
		public class ItemEnum : KConfigSkeleton.ItemInt, IDisposable {
	 		protected ItemEnum(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemEnum), this);
			}
			// KConfigSkeleton::ItemEnum* ItemEnum(const QString& arg1,const QString& arg2,qint32& arg3,const QList<KConfigSkeleton::ItemEnum::Choice>& arg4,qint32 arg5); >>>> NOT CONVERTED
			// KConfigSkeleton::ItemEnum* ItemEnum(const QString& arg1,const QString& arg2,qint32& arg3,const QList<KConfigSkeleton::ItemEnum::Choice>& arg4); >>>> NOT CONVERTED
			// QList<KConfigSkeleton::ItemEnum::Choice> choices(); >>>> NOT CONVERTED
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem
			/// <param> name="choices" The list of enums that can be stored in this item
			///       </param></remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public new void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.WriteConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.WriteConfig(KConfig ) </short>
			public void WriteConfig(KConfig config) {
				interceptor.Invoke("writeConfig#", "writeConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			~ItemEnum() {
				interceptor.Invoke("~ItemEnum", "~ItemEnum()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~ItemEnum", "~ItemEnum()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling an unsingend 32-bit integer preferences item.
		///    </remarks>		<short>    Class for handling an unsingend 32-bit integer preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemUInt")]
		public class ItemUInt : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemUInt(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemUInt), this);
			}
			// KConfigSkeleton::ItemUInt* ItemUInt(const QString& arg1,const QString& arg2,quint32& arg3,quint32 arg4); >>>> NOT CONVERTED
			// KConfigSkeleton::ItemUInt* ItemUInt(const QString& arg1,const QString& arg2,quint32& arg3); >>>> NOT CONVERTED
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>		<short>   @copydoc KConfigSkeletonItem.Property() </short>
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			/// <remarks> @copydoc ItemInt.MinValue() </remarks>		<short>   @copydoc ItemInt.MinValue() </short>
			public QVariant MinValue() {
				return (QVariant) interceptor.Invoke("minValue", "minValue() const", typeof(QVariant));
			}
			/// <remarks> @copydoc ItemInt.MaxValue() </remarks>		<short>   @copydoc ItemInt.MaxValue() </short>
			public QVariant MaxValue() {
				return (QVariant) interceptor.Invoke("maxValue", "maxValue() const", typeof(QVariant));
			}
			/// <remarks> @copydoc ItemInt.SetMinValue(qint32) </remarks>		<short>   @copydoc ItemInt.SetMinValue(qint32) </short>
			public void SetMinValue(uint arg1) {
				interceptor.Invoke("setMinValue$", "setMinValue(quint32)", typeof(void), typeof(uint), arg1);
			}
			/// <remarks> @copydoc ItemInt.SetMaxValue(qint32) </remarks>		<short>   @copydoc ItemInt.SetMaxValue(qint32) </short>
			public void SetMaxValue(uint arg1) {
				interceptor.Invoke("setMaxValue$", "setMaxValue(quint32)", typeof(void), typeof(uint), arg1);
			}
			~ItemUInt() {
				interceptor.Invoke("~ItemUInt", "~ItemUInt()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemUInt", "~ItemUInt()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling unsigned 64-bit integer preferences item.
		///    </remarks>		<short>    Class for handling unsigned 64-bit integer preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemULongLong")]
		public class ItemULongLong : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemULongLong(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemULongLong), this);
			}
			// KConfigSkeleton::ItemULongLong* ItemULongLong(const QString& arg1,const QString& arg2,quint64& arg3,quint64 arg4); >>>> NOT CONVERTED
			// KConfigSkeleton::ItemULongLong* ItemULongLong(const QString& arg1,const QString& arg2,quint64& arg3); >>>> NOT CONVERTED
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>		<short>   @copydoc KConfigSkeletonItem.Property() </short>
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			/// <remarks> @copydoc ItemInt.MinValue() </remarks>		<short>   @copydoc ItemInt.MinValue() </short>
			public QVariant MinValue() {
				return (QVariant) interceptor.Invoke("minValue", "minValue() const", typeof(QVariant));
			}
			/// <remarks> @copydoc ItemInt.MaxValue() </remarks>		<short>   @copydoc ItemInt.MaxValue() </short>
			public QVariant MaxValue() {
				return (QVariant) interceptor.Invoke("maxValue", "maxValue() const", typeof(QVariant));
			}
			/// <remarks> @copydoc ItemInt.SetMinValue(qint32) </remarks>		<short>   @copydoc ItemInt.SetMinValue(qint32) </short>
			public void SetMinValue(ulong arg1) {
				interceptor.Invoke("setMinValue$", "setMinValue(quint64)", typeof(void), typeof(ulong), arg1);
			}
			/// <remarks> @copydoc ItemInt.SetMaxValue(qint32) </remarks>		<short>   @copydoc ItemInt.SetMaxValue(qint32) </short>
			public void SetMaxValue(ulong arg1) {
				interceptor.Invoke("setMaxValue$", "setMaxValue(quint64)", typeof(void), typeof(ulong), arg1);
			}
			~ItemULongLong() {
				interceptor.Invoke("~ItemULongLong", "~ItemULongLong()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemULongLong", "~ItemULongLong()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling a floating point preference item.
		///    </remarks>		<short>    Class for handling a floating point preference item.</short>

		[SmokeClass("KConfigSkeleton::ItemDouble")]
		public class ItemDouble : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemDouble(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemDouble), this);
			}
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			public ItemDouble(string _group, string _key, double reference, double defaultValue) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemDouble$$$$", "ItemDouble(const QString&, const QString&, double&, double)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(double), reference, typeof(double), defaultValue);
			}
			public ItemDouble(string _group, string _key, double reference) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemDouble$$$", "ItemDouble(const QString&, const QString&, double&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(double), reference);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>		<short>   @copydoc KConfigSkeletonItem.Property() </short>
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			/// <remarks> @copydoc ItemInt.MinValue() </remarks>		<short>   @copydoc ItemInt.MinValue() </short>
			public QVariant MinValue() {
				return (QVariant) interceptor.Invoke("minValue", "minValue() const", typeof(QVariant));
			}
			/// <remarks> @copydoc ItemInt.MaxValue() </remarks>		<short>   @copydoc ItemInt.MaxValue() </short>
			public QVariant MaxValue() {
				return (QVariant) interceptor.Invoke("maxValue", "maxValue() const", typeof(QVariant));
			}
			/// <remarks> @copydoc ItemInt.SetMinValue() </remarks>		<short>   @copydoc ItemInt.SetMinValue() </short>
			public void SetMinValue(double arg1) {
				interceptor.Invoke("setMinValue$", "setMinValue(double)", typeof(void), typeof(double), arg1);
			}
			/// <remarks> @copydoc ItemInt.SetMaxValue() </remarks>		<short>   @copydoc ItemInt.SetMaxValue() </short>
			public void SetMaxValue(double arg1) {
				interceptor.Invoke("setMaxValue$", "setMaxValue(double)", typeof(void), typeof(double), arg1);
			}
			~ItemDouble() {
				interceptor.Invoke("~ItemDouble", "~ItemDouble()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemDouble", "~ItemDouble()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling a color preferences item.
		///    </remarks>		<short>    Class for handling a color preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemColor")]
		public class ItemColor : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemColor(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemColor), this);
			}
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			public ItemColor(string _group, string _key, QColor reference, QColor defaultValue) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemColor$$##", "ItemColor(const QString&, const QString&, QColor&, const QColor&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QColor), reference, typeof(QColor), defaultValue);
			}
			public ItemColor(string _group, string _key, QColor reference) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemColor$$#", "ItemColor(const QString&, const QString&, QColor&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QColor), reference);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>		<short>   @copydoc KConfigSkeletonItem.Property() </short>
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			~ItemColor() {
				interceptor.Invoke("~ItemColor", "~ItemColor()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemColor", "~ItemColor()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling a font preferences item.
		///    </remarks>		<short>    Class for handling a font preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemFont")]
		public class ItemFont : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemFont(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemFont), this);
			}
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			public ItemFont(string _group, string _key, QFont reference, QFont defaultValue) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemFont$$##", "ItemFont(const QString&, const QString&, QFont&, const QFont&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QFont), reference, typeof(QFont), defaultValue);
			}
			public ItemFont(string _group, string _key, QFont reference) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemFont$$#", "ItemFont(const QString&, const QString&, QFont&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QFont), reference);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>		<short>   @copydoc KConfigSkeletonItem.Property() </short>
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			~ItemFont() {
				interceptor.Invoke("~ItemFont", "~ItemFont()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemFont", "~ItemFont()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling a QRect preferences item.
		///    </remarks>		<short>    Class for handling a QRect preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemRect")]
		public class ItemRect : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemRect(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemRect), this);
			}
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			public ItemRect(string _group, string _key, QRect reference, QRect defaultValue) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemRect$$##", "ItemRect(const QString&, const QString&, QRect&, const QRect&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QRect), reference, typeof(QRect), defaultValue);
			}
			public ItemRect(string _group, string _key, QRect reference) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemRect$$#", "ItemRect(const QString&, const QString&, QRect&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QRect), reference);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>		<short>   @copydoc KConfigSkeletonItem.Property() </short>
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			~ItemRect() {
				interceptor.Invoke("~ItemRect", "~ItemRect()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemRect", "~ItemRect()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling a QPoint preferences item.
		///    </remarks>		<short>    Class for handling a QPoint preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemPoint")]
		public class ItemPoint : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemPoint(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemPoint), this);
			}
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			public ItemPoint(string _group, string _key, QPoint reference, QPoint defaultValue) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemPoint$$##", "ItemPoint(const QString&, const QString&, QPoint&, const QPoint&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QPoint), reference, typeof(QPoint), defaultValue);
			}
			public ItemPoint(string _group, string _key, QPoint reference) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemPoint$$#", "ItemPoint(const QString&, const QString&, QPoint&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QPoint), reference);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>		<short>   @copydoc KConfigSkeletonItem.Property() </short>
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			~ItemPoint() {
				interceptor.Invoke("~ItemPoint", "~ItemPoint()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemPoint", "~ItemPoint()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling a QSize preferences item.
		///    </remarks>		<short>    Class for handling a QSize preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemSize")]
		public class ItemSize : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemSize(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemSize), this);
			}
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			public ItemSize(string _group, string _key, QSize reference, QSize defaultValue) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemSize$$##", "ItemSize(const QString&, const QString&, QSize&, const QSize&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QSize), reference, typeof(QSize), defaultValue);
			}
			public ItemSize(string _group, string _key, QSize reference) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemSize$$#", "ItemSize(const QString&, const QString&, QSize&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QSize), reference);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>		<short>   @copydoc KConfigSkeletonItem.Property() </short>
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			~ItemSize() {
				interceptor.Invoke("~ItemSize", "~ItemSize()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemSize", "~ItemSize()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling a QDateTime preferences item.
		///    </remarks>		<short>    Class for handling a QDateTime preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemDateTime")]
		public class ItemDateTime : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemDateTime(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemDateTime), this);
			}
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			public ItemDateTime(string _group, string _key, QDateTime reference, QDateTime defaultValue) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemDateTime$$##", "ItemDateTime(const QString&, const QString&, QDateTime&, const QDateTime&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QDateTime), reference, typeof(QDateTime), defaultValue);
			}
			public ItemDateTime(string _group, string _key, QDateTime reference) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemDateTime$$#", "ItemDateTime(const QString&, const QString&, QDateTime&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QDateTime), reference);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>		<short>   @copydoc KConfigSkeletonItem.Property() </short>
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			~ItemDateTime() {
				interceptor.Invoke("~ItemDateTime", "~ItemDateTime()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemDateTime", "~ItemDateTime()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling a string list preferences item.
		///    </remarks>		<short>    Class for handling a string list preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemStringList")]
		public class ItemStringList : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemStringList(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemStringList), this);
			}
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			public ItemStringList(string _group, string _key, List<string> reference, List<string> defaultValue) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemStringList$$??", "ItemStringList(const QString&, const QString&, QStringList&, const QStringList&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(List<string>), reference, typeof(List<string>), defaultValue);
			}
			public ItemStringList(string _group, string _key, List<string> reference) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemStringList$$?", "ItemStringList(const QString&, const QString&, QStringList&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(List<string>), reference);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>		<short>   @copydoc KConfigSkeletonItem.Property() </short>
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			~ItemStringList() {
				interceptor.Invoke("~ItemStringList", "~ItemStringList()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemStringList", "~ItemStringList()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling a path list preferences item.
		///    </remarks>		<short>    Class for handling a path list preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemPathList")]
		public class ItemPathList : KConfigSkeleton.ItemStringList, IDisposable {
	 		protected ItemPathList(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemPathList), this);
			}
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			public ItemPathList(string _group, string _key, List<string> reference, List<string> defaultValue) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemPathList$$??", "ItemPathList(const QString&, const QString&, QStringList&, const QStringList&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(List<string>), reference, typeof(List<string>), defaultValue);
			}
			public ItemPathList(string _group, string _key, List<string> reference) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemPathList$$?", "ItemPathList(const QString&, const QString&, QStringList&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(List<string>), reference);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig </short>
			public new void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.WriteConfig </remarks>		<short>   @copydoc KConfigSkeletonItem.WriteConfig </short>
			public void WriteConfig(KConfig config) {
				interceptor.Invoke("writeConfig#", "writeConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			~ItemPathList() {
				interceptor.Invoke("~ItemPathList", "~ItemPathList()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~ItemPathList", "~ItemPathList()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling a url list preferences item.
		///      </remarks>		<short>    Class for handling a url list preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemUrlList")]
		public class ItemUrlList : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemUrlList(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemUrlList), this);
			}
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			public ItemUrlList(string _group, string _key, List<KUrl> reference, List<KUrl> defaultValue) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemUrlList$$??", "ItemUrlList(const QString&, const QString&, KUrl::List&, const KUrl::List&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(List<KUrl>), reference, typeof(List<KUrl>), defaultValue);
			}
			public ItemUrlList(string _group, string _key, List<KUrl> reference) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ItemUrlList$$?", "ItemUrlList(const QString&, const QString&, KUrl::List&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(List<KUrl>), reference);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.WriteConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.WriteConfig(KConfig ) </short>
			public void WriteConfig(KConfig config) {
				interceptor.Invoke("writeConfig#", "writeConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>		<short>   @copydoc KConfigSkeletonItem.Property() </short>
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			~ItemUrlList() {
				interceptor.Invoke("~ItemUrlList", "~ItemUrlList()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemUrlList", "~ItemUrlList()", typeof(void));
			}
		}

		/// <remarks>
		///  Class for handling an integer list preferences item.
		///    </remarks>		<short>    Class for handling an integer list preferences item.</short>

		[SmokeClass("KConfigSkeleton::ItemIntList")]
		public class ItemIntList : KConfigSkeletonGenericItem, IDisposable {
	 		protected ItemIntList(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ItemIntList), this);
			}
			// KConfigSkeleton::ItemIntList* ItemIntList(const QString& arg1,const QString& arg2,QList <int>& arg3,const QList <int>& arg4); >>>> NOT CONVERTED
			// KConfigSkeleton::ItemIntList* ItemIntList(const QString& arg1,const QString& arg2,QList <int>& arg3); >>>> NOT CONVERTED
			/// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>		<short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
			/// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>		<short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
			public void ReadConfig(KConfig config) {
				interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
			public void SetProperty(QVariant p) {
				interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>		<short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
			public bool IsEqual(QVariant p) {
				return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
			}
			/// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>		<short>   @copydoc KConfigSkeletonItem.Property() </short>
			public QVariant Property() {
				return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
			}
			~ItemIntList() {
				interceptor.Invoke("~ItemIntList", "~ItemIntList()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~ItemIntList", "~ItemIntList()", typeof(void));
			}
		}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KConfigSkeleton), this);
		}
		// KConfigSkeleton* KConfigSkeleton(KSharedConfig::Ptr arg1,QObject* arg2); >>>> NOT CONVERTED
		// KConfigSkeleton* KConfigSkeleton(KSharedConfig::Ptr arg1); >>>> NOT CONVERTED
		// KConfigSkeleton::ItemUInt* addItemUInt(const QString& arg1,quint32& arg2,quint32 arg3,const QString& arg4); >>>> NOT CONVERTED
		// KConfigSkeleton::ItemUInt* addItemUInt(const QString& arg1,quint32& arg2,quint32 arg3); >>>> NOT CONVERTED
		// KConfigSkeleton::ItemUInt* addItemUInt(const QString& arg1,quint32& arg2); >>>> NOT CONVERTED
		// KConfigSkeleton::ItemLongLong* addItemLongLong(const QString& arg1,qint64& arg2,qint64 arg3,const QString& arg4); >>>> NOT CONVERTED
		// KConfigSkeleton::ItemLongLong* addItemLongLong(const QString& arg1,qint64& arg2,qint64 arg3); >>>> NOT CONVERTED
		// KConfigSkeleton::ItemLongLong* addItemLongLong(const QString& arg1,qint64& arg2); >>>> NOT CONVERTED
		// KConfigSkeleton::ItemULongLong* addItemULongLong(const QString& arg1,quint64& arg2,quint64 arg3,const QString& arg4); >>>> NOT CONVERTED
		// KConfigSkeleton::ItemULongLong* addItemULongLong(const QString& arg1,quint64& arg2,quint64 arg3); >>>> NOT CONVERTED
		// KConfigSkeleton::ItemULongLong* addItemULongLong(const QString& arg1,quint64& arg2); >>>> NOT CONVERTED
		// KConfigSkeleton::ItemIntList* addItemIntList(const QString& arg1,QList <int>& arg2,const QList <int>& arg3,const QString& arg4); >>>> NOT CONVERTED
		// KConfigSkeleton::ItemIntList* addItemIntList(const QString& arg1,QList <int>& arg2,const QList <int>& arg3); >>>> NOT CONVERTED
		// KConfigSkeleton::ItemIntList* addItemIntList(const QString& arg1,QList <int>& arg2); >>>> NOT CONVERTED
		// void setSharedConfig(KSharedConfig::Ptr arg1); >>>> NOT CONVERTED
		// KConfigSkeletonItem::List items(); >>>> NOT CONVERTED
		/// <remarks>
		///  Constructor.
		/// <param> name="configname" name of config file. If no name is given, the default
		///  config file as returned by KGlobal.Config() is used.
		///    </param></remarks>		<short>    Constructor.</short>
		public KConfigSkeleton(string configname, QObject parent) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KConfigSkeleton$#", "KConfigSkeleton(const QString&, QObject*)", typeof(void), typeof(string), configname, typeof(QObject), parent);
		}
		public KConfigSkeleton(string configname) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KConfigSkeleton$", "KConfigSkeleton(const QString&)", typeof(void), typeof(string), configname);
		}
		public KConfigSkeleton() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KConfigSkeleton", "KConfigSkeleton()", typeof(void));
		}
		/// <remarks>
		///  Constructor.
		/// <param> name="config" configuration object to use.
		///    </param></remarks>		<short>    Constructor.</short>
		/// <remarks>
		///  Set all registered items to their default values.
		///  This method calls usrSetDefaults() after setting the defaults for the
		///  registered items. You can overridde usrSetDefaults() in derived classes
		///  if you have special requirements.
		///  If you need more fine-grained control of setting the default values of
		///  the registered items you can override setDefaults() in a derived class.
		///    </remarks>		<short>    Set all registered items to their default values.</short>
		[SmokeMethod("setDefaults()")]
		public virtual void SetDefaults() {
			interceptor.Invoke("setDefaults", "setDefaults()", typeof(void));
		}
		/// <remarks>
		///  Read preferences from config file. All registered items are set to the
		///  values read from disk.
		///  This method calls usrReadConfig() after reading the settings of the
		///  registered items from the KConfig. You can overridde usrReadConfig()
		///  in derived classes if you have special requirements.
		///  If you need more fine-grained control of storing the settings from
		///  the registered items you can override readConfig() in a derived class.
		///    </remarks>		<short>    Read preferences from config file.</short>
		[SmokeMethod("readConfig()")]
		public virtual void ReadConfig() {
			interceptor.Invoke("readConfig", "readConfig()", typeof(void));
		}
		/// <remarks>
		///  Write preferences to config file. The values of all registered items are
		///  written to disk.
		///  This method calls usrWriteConfig() after writing the settings from the
		///  registered items to the KConfig. You can overridde usrWriteConfig()
		///  in derived classes if you have special requirements.
		///  If you need more fine-grained control of storing the settings from
		///  the registered items you can override writeConfig() in a derived class.
		///    </remarks>		<short>    Write preferences to config file.</short>
		[SmokeMethod("writeConfig()")]
		public virtual void WriteConfig() {
			interceptor.Invoke("writeConfig", "writeConfig()", typeof(void));
		}
		/// <remarks>
		///  Set the config file group for subsequent addItem() calls. It is valid
		///  until setCurrentGroup() is called with a new argument. Call this before
		///  you add any items. The default value is "No Group".
		///    </remarks>		<short>    Set the config file group for subsequent addItem() calls.</short>
		public void SetCurrentGroup(string group) {
			interceptor.Invoke("setCurrentGroup$", "setCurrentGroup(const QString&)", typeof(void), typeof(string), group);
		}
		/// <remarks>
		///  Returns the current group used for addItem() calls.
		///    </remarks>		<short>    Returns the current group used for addItem() calls.</short>
		public string CurrentGroup() {
			return (string) interceptor.Invoke("currentGroup", "currentGroup() const", typeof(string));
		}
		/// <remarks>
		///  Register a custom <see cref="KConfigSkeletonItem"></see> with a given name. If the name
		///  parameter is null, take the name from KConfigSkeletonItem.Key().
		///  Note that all names must be unique but that multiple entries can have
		///  the same key if they reside in different groups.
		///    </remarks>		<short>    Register a custom @ref KConfigSkeletonItem with a given name.</short>
		public void AddItem(KConfigSkeletonItem arg1, string name) {
			interceptor.Invoke("addItem#$", "addItem(KConfigSkeletonItem*, const QString&)", typeof(void), typeof(KConfigSkeletonItem), arg1, typeof(string), name);
		}
		public void AddItem(KConfigSkeletonItem arg1) {
			interceptor.Invoke("addItem#", "addItem(KConfigSkeletonItem*)", typeof(void), typeof(KConfigSkeletonItem), arg1);
		}
		/// <remarks>
		///  Register an item of type string.
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register an item of type string.</short>
		public KConfigSkeleton.ItemString AddItemString(string name, StringBuilder reference, string defaultValue, string key) {
			return (KConfigSkeleton.ItemString) interceptor.Invoke("addItemString$$$$", "addItemString(const QString&, QString&, const QString&, const QString&)", typeof(KConfigSkeleton.ItemString), typeof(string), name, typeof(StringBuilder), reference, typeof(string), defaultValue, typeof(string), key);
		}
		public KConfigSkeleton.ItemString AddItemString(string name, StringBuilder reference, string defaultValue) {
			return (KConfigSkeleton.ItemString) interceptor.Invoke("addItemString$$$", "addItemString(const QString&, QString&, const QString&)", typeof(KConfigSkeleton.ItemString), typeof(string), name, typeof(StringBuilder), reference, typeof(string), defaultValue);
		}
		public KConfigSkeleton.ItemString AddItemString(string name, StringBuilder reference) {
			return (KConfigSkeleton.ItemString) interceptor.Invoke("addItemString$$", "addItemString(const QString&, QString&)", typeof(KConfigSkeleton.ItemString), typeof(string), name, typeof(StringBuilder), reference);
		}
		/// <remarks>
		///  Register a password item of type string. The string value is written
		///  encrypted to the config file. Note that the current encryption scheme
		///  is very weak.
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register a password item of type string.</short>
		public KConfigSkeleton.ItemPassword AddItemPassword(string name, StringBuilder reference, string defaultValue, string key) {
			return (KConfigSkeleton.ItemPassword) interceptor.Invoke("addItemPassword$$$$", "addItemPassword(const QString&, QString&, const QString&, const QString&)", typeof(KConfigSkeleton.ItemPassword), typeof(string), name, typeof(StringBuilder), reference, typeof(string), defaultValue, typeof(string), key);
		}
		public KConfigSkeleton.ItemPassword AddItemPassword(string name, StringBuilder reference, string defaultValue) {
			return (KConfigSkeleton.ItemPassword) interceptor.Invoke("addItemPassword$$$", "addItemPassword(const QString&, QString&, const QString&)", typeof(KConfigSkeleton.ItemPassword), typeof(string), name, typeof(StringBuilder), reference, typeof(string), defaultValue);
		}
		public KConfigSkeleton.ItemPassword AddItemPassword(string name, StringBuilder reference) {
			return (KConfigSkeleton.ItemPassword) interceptor.Invoke("addItemPassword$$", "addItemPassword(const QString&, QString&)", typeof(KConfigSkeleton.ItemPassword), typeof(string), name, typeof(StringBuilder), reference);
		}
		/// <remarks>
		///  Register a path item of type string. The string value is interpreted
		///  as a path. This means, dollar expension is activated for this value, so
		///  that e.g. $HOME gets expanded.
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register a path item of type string.</short>
		public KConfigSkeleton.ItemPath AddItemPath(string name, StringBuilder reference, string defaultValue, string key) {
			return (KConfigSkeleton.ItemPath) interceptor.Invoke("addItemPath$$$$", "addItemPath(const QString&, QString&, const QString&, const QString&)", typeof(KConfigSkeleton.ItemPath), typeof(string), name, typeof(StringBuilder), reference, typeof(string), defaultValue, typeof(string), key);
		}
		public KConfigSkeleton.ItemPath AddItemPath(string name, StringBuilder reference, string defaultValue) {
			return (KConfigSkeleton.ItemPath) interceptor.Invoke("addItemPath$$$", "addItemPath(const QString&, QString&, const QString&)", typeof(KConfigSkeleton.ItemPath), typeof(string), name, typeof(StringBuilder), reference, typeof(string), defaultValue);
		}
		public KConfigSkeleton.ItemPath AddItemPath(string name, StringBuilder reference) {
			return (KConfigSkeleton.ItemPath) interceptor.Invoke("addItemPath$$", "addItemPath(const QString&, QString&)", typeof(KConfigSkeleton.ItemPath), typeof(string), name, typeof(StringBuilder), reference);
		}
		/// <remarks>
		///  Register a property item of type QVariant. Note that only the following
		///  QVariant types are allowed: String, StringList, Font, Point, Rect, Size,
		///  Color, Int, UInt, Bool, Double, DateTime and Date.
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register a property item of type QVariant.</short>
		public KConfigSkeleton.ItemProperty AddItemProperty(string name, QVariant reference, QVariant defaultValue, string key) {
			return (KConfigSkeleton.ItemProperty) interceptor.Invoke("addItemProperty$##$", "addItemProperty(const QString&, QVariant&, const QVariant&, const QString&)", typeof(KConfigSkeleton.ItemProperty), typeof(string), name, typeof(QVariant), reference, typeof(QVariant), defaultValue, typeof(string), key);
		}
		public KConfigSkeleton.ItemProperty AddItemProperty(string name, QVariant reference, QVariant defaultValue) {
			return (KConfigSkeleton.ItemProperty) interceptor.Invoke("addItemProperty$##", "addItemProperty(const QString&, QVariant&, const QVariant&)", typeof(KConfigSkeleton.ItemProperty), typeof(string), name, typeof(QVariant), reference, typeof(QVariant), defaultValue);
		}
		public KConfigSkeleton.ItemProperty AddItemProperty(string name, QVariant reference) {
			return (KConfigSkeleton.ItemProperty) interceptor.Invoke("addItemProperty$#", "addItemProperty(const QString&, QVariant&)", typeof(KConfigSkeleton.ItemProperty), typeof(string), name, typeof(QVariant), reference);
		}
		/// <remarks>
		///  Register an item of type bool.
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register an item of type bool.</short>
		public KConfigSkeleton.ItemBool AddItemBool(string name, bool reference, bool defaultValue, string key) {
			return (KConfigSkeleton.ItemBool) interceptor.Invoke("addItemBool$$$$", "addItemBool(const QString&, bool&, bool, const QString&)", typeof(KConfigSkeleton.ItemBool), typeof(string), name, typeof(bool), reference, typeof(bool), defaultValue, typeof(string), key);
		}
		public KConfigSkeleton.ItemBool AddItemBool(string name, bool reference, bool defaultValue) {
			return (KConfigSkeleton.ItemBool) interceptor.Invoke("addItemBool$$$", "addItemBool(const QString&, bool&, bool)", typeof(KConfigSkeleton.ItemBool), typeof(string), name, typeof(bool), reference, typeof(bool), defaultValue);
		}
		public KConfigSkeleton.ItemBool AddItemBool(string name, bool reference) {
			return (KConfigSkeleton.ItemBool) interceptor.Invoke("addItemBool$$", "addItemBool(const QString&, bool&)", typeof(KConfigSkeleton.ItemBool), typeof(string), name, typeof(bool), reference);
		}
		/// <remarks>
		///  Register an item of type qint32.
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register an item of type qint32.</short>
		public KConfigSkeleton.ItemInt AddItemInt(string name, int reference, int defaultValue, string key) {
			return (KConfigSkeleton.ItemInt) interceptor.Invoke("addItemInt$$$$", "addItemInt(const QString&, qint32&, qint32, const QString&)", typeof(KConfigSkeleton.ItemInt), typeof(string), name, typeof(int), reference, typeof(int), defaultValue, typeof(string), key);
		}
		public KConfigSkeleton.ItemInt AddItemInt(string name, int reference, int defaultValue) {
			return (KConfigSkeleton.ItemInt) interceptor.Invoke("addItemInt$$$", "addItemInt(const QString&, qint32&, qint32)", typeof(KConfigSkeleton.ItemInt), typeof(string), name, typeof(int), reference, typeof(int), defaultValue);
		}
		public KConfigSkeleton.ItemInt AddItemInt(string name, int reference) {
			return (KConfigSkeleton.ItemInt) interceptor.Invoke("addItemInt$$", "addItemInt(const QString&, qint32&)", typeof(KConfigSkeleton.ItemInt), typeof(string), name, typeof(int), reference);
		}
		/// <remarks>
		///  Register an item of type quint32.
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register an item of type quint32.</short>
		/// <remarks>
		///  Register an item of type qint64.
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register an item of type qint64.</short>
		/// <remarks>
		///  Register an item of type quint64
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register an item of type quint64 </short>
		/// <remarks>
		///  Register an item of type double.
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register an item of type double.</short>
		public KConfigSkeleton.ItemDouble AddItemDouble(string name, double reference, double defaultValue, string key) {
			return (KConfigSkeleton.ItemDouble) interceptor.Invoke("addItemDouble$$$$", "addItemDouble(const QString&, double&, double, const QString&)", typeof(KConfigSkeleton.ItemDouble), typeof(string), name, typeof(double), reference, typeof(double), defaultValue, typeof(string), key);
		}
		public KConfigSkeleton.ItemDouble AddItemDouble(string name, double reference, double defaultValue) {
			return (KConfigSkeleton.ItemDouble) interceptor.Invoke("addItemDouble$$$", "addItemDouble(const QString&, double&, double)", typeof(KConfigSkeleton.ItemDouble), typeof(string), name, typeof(double), reference, typeof(double), defaultValue);
		}
		public KConfigSkeleton.ItemDouble AddItemDouble(string name, double reference) {
			return (KConfigSkeleton.ItemDouble) interceptor.Invoke("addItemDouble$$", "addItemDouble(const QString&, double&)", typeof(KConfigSkeleton.ItemDouble), typeof(string), name, typeof(double), reference);
		}
		/// <remarks>
		///  Register an item of type QColor.
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register an item of type QColor.</short>
		public KConfigSkeleton.ItemColor AddItemColor(string name, QColor reference, QColor defaultValue, string key) {
			return (KConfigSkeleton.ItemColor) interceptor.Invoke("addItemColor$##$", "addItemColor(const QString&, QColor&, const QColor&, const QString&)", typeof(KConfigSkeleton.ItemColor), typeof(string), name, typeof(QColor), reference, typeof(QColor), defaultValue, typeof(string), key);
		}
		public KConfigSkeleton.ItemColor AddItemColor(string name, QColor reference, QColor defaultValue) {
			return (KConfigSkeleton.ItemColor) interceptor.Invoke("addItemColor$##", "addItemColor(const QString&, QColor&, const QColor&)", typeof(KConfigSkeleton.ItemColor), typeof(string), name, typeof(QColor), reference, typeof(QColor), defaultValue);
		}
		public KConfigSkeleton.ItemColor AddItemColor(string name, QColor reference) {
			return (KConfigSkeleton.ItemColor) interceptor.Invoke("addItemColor$#", "addItemColor(const QString&, QColor&)", typeof(KConfigSkeleton.ItemColor), typeof(string), name, typeof(QColor), reference);
		}
		/// <remarks>
		///  Register an item of type QFont.
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register an item of type QFont.</short>
		public KConfigSkeleton.ItemFont AddItemFont(string name, QFont reference, QFont defaultValue, string key) {
			return (KConfigSkeleton.ItemFont) interceptor.Invoke("addItemFont$##$", "addItemFont(const QString&, QFont&, const QFont&, const QString&)", typeof(KConfigSkeleton.ItemFont), typeof(string), name, typeof(QFont), reference, typeof(QFont), defaultValue, typeof(string), key);
		}
		public KConfigSkeleton.ItemFont AddItemFont(string name, QFont reference, QFont defaultValue) {
			return (KConfigSkeleton.ItemFont) interceptor.Invoke("addItemFont$##", "addItemFont(const QString&, QFont&, const QFont&)", typeof(KConfigSkeleton.ItemFont), typeof(string), name, typeof(QFont), reference, typeof(QFont), defaultValue);
		}
		public KConfigSkeleton.ItemFont AddItemFont(string name, QFont reference) {
			return (KConfigSkeleton.ItemFont) interceptor.Invoke("addItemFont$#", "addItemFont(const QString&, QFont&)", typeof(KConfigSkeleton.ItemFont), typeof(string), name, typeof(QFont), reference);
		}
		/// <remarks>
		///  Register an item of type QRect.
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register an item of type QRect.</short>
		public KConfigSkeleton.ItemRect AddItemRect(string name, QRect reference, QRect defaultValue, string key) {
			return (KConfigSkeleton.ItemRect) interceptor.Invoke("addItemRect$##$", "addItemRect(const QString&, QRect&, const QRect&, const QString&)", typeof(KConfigSkeleton.ItemRect), typeof(string), name, typeof(QRect), reference, typeof(QRect), defaultValue, typeof(string), key);
		}
		public KConfigSkeleton.ItemRect AddItemRect(string name, QRect reference, QRect defaultValue) {
			return (KConfigSkeleton.ItemRect) interceptor.Invoke("addItemRect$##", "addItemRect(const QString&, QRect&, const QRect&)", typeof(KConfigSkeleton.ItemRect), typeof(string), name, typeof(QRect), reference, typeof(QRect), defaultValue);
		}
		public KConfigSkeleton.ItemRect AddItemRect(string name, QRect reference) {
			return (KConfigSkeleton.ItemRect) interceptor.Invoke("addItemRect$#", "addItemRect(const QString&, QRect&)", typeof(KConfigSkeleton.ItemRect), typeof(string), name, typeof(QRect), reference);
		}
		/// <remarks>
		///  Register an item of type QPoint.
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register an item of type QPoint.</short>
		public KConfigSkeleton.ItemPoint AddItemPoint(string name, QPoint reference, QPoint defaultValue, string key) {
			return (KConfigSkeleton.ItemPoint) interceptor.Invoke("addItemPoint$##$", "addItemPoint(const QString&, QPoint&, const QPoint&, const QString&)", typeof(KConfigSkeleton.ItemPoint), typeof(string), name, typeof(QPoint), reference, typeof(QPoint), defaultValue, typeof(string), key);
		}
		public KConfigSkeleton.ItemPoint AddItemPoint(string name, QPoint reference, QPoint defaultValue) {
			return (KConfigSkeleton.ItemPoint) interceptor.Invoke("addItemPoint$##", "addItemPoint(const QString&, QPoint&, const QPoint&)", typeof(KConfigSkeleton.ItemPoint), typeof(string), name, typeof(QPoint), reference, typeof(QPoint), defaultValue);
		}
		public KConfigSkeleton.ItemPoint AddItemPoint(string name, QPoint reference) {
			return (KConfigSkeleton.ItemPoint) interceptor.Invoke("addItemPoint$#", "addItemPoint(const QString&, QPoint&)", typeof(KConfigSkeleton.ItemPoint), typeof(string), name, typeof(QPoint), reference);
		}
		/// <remarks>
		///  Register an item of type QSize.
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register an item of type QSize.</short>
		public KConfigSkeleton.ItemSize AddItemSize(string name, QSize reference, QSize defaultValue, string key) {
			return (KConfigSkeleton.ItemSize) interceptor.Invoke("addItemSize$##$", "addItemSize(const QString&, QSize&, const QSize&, const QString&)", typeof(KConfigSkeleton.ItemSize), typeof(string), name, typeof(QSize), reference, typeof(QSize), defaultValue, typeof(string), key);
		}
		public KConfigSkeleton.ItemSize AddItemSize(string name, QSize reference, QSize defaultValue) {
			return (KConfigSkeleton.ItemSize) interceptor.Invoke("addItemSize$##", "addItemSize(const QString&, QSize&, const QSize&)", typeof(KConfigSkeleton.ItemSize), typeof(string), name, typeof(QSize), reference, typeof(QSize), defaultValue);
		}
		public KConfigSkeleton.ItemSize AddItemSize(string name, QSize reference) {
			return (KConfigSkeleton.ItemSize) interceptor.Invoke("addItemSize$#", "addItemSize(const QString&, QSize&)", typeof(KConfigSkeleton.ItemSize), typeof(string), name, typeof(QSize), reference);
		}
		/// <remarks>
		///  Register an item of type QDateTime.
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register an item of type QDateTime.</short>
		public KConfigSkeleton.ItemDateTime AddItemDateTime(string name, QDateTime reference, QDateTime defaultValue, string key) {
			return (KConfigSkeleton.ItemDateTime) interceptor.Invoke("addItemDateTime$##$", "addItemDateTime(const QString&, QDateTime&, const QDateTime&, const QString&)", typeof(KConfigSkeleton.ItemDateTime), typeof(string), name, typeof(QDateTime), reference, typeof(QDateTime), defaultValue, typeof(string), key);
		}
		public KConfigSkeleton.ItemDateTime AddItemDateTime(string name, QDateTime reference, QDateTime defaultValue) {
			return (KConfigSkeleton.ItemDateTime) interceptor.Invoke("addItemDateTime$##", "addItemDateTime(const QString&, QDateTime&, const QDateTime&)", typeof(KConfigSkeleton.ItemDateTime), typeof(string), name, typeof(QDateTime), reference, typeof(QDateTime), defaultValue);
		}
		public KConfigSkeleton.ItemDateTime AddItemDateTime(string name, QDateTime reference) {
			return (KConfigSkeleton.ItemDateTime) interceptor.Invoke("addItemDateTime$#", "addItemDateTime(const QString&, QDateTime&)", typeof(KConfigSkeleton.ItemDateTime), typeof(string), name, typeof(QDateTime), reference);
		}
		/// <remarks>
		///  Register an item of type List<string>.
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register an item of type List<string>.</short>
		public KConfigSkeleton.ItemStringList AddItemStringList(string name, List<string> reference, List<string> defaultValue, string key) {
			return (KConfigSkeleton.ItemStringList) interceptor.Invoke("addItemStringList$??$", "addItemStringList(const QString&, QStringList&, const QStringList&, const QString&)", typeof(KConfigSkeleton.ItemStringList), typeof(string), name, typeof(List<string>), reference, typeof(List<string>), defaultValue, typeof(string), key);
		}
		public KConfigSkeleton.ItemStringList AddItemStringList(string name, List<string> reference, List<string> defaultValue) {
			return (KConfigSkeleton.ItemStringList) interceptor.Invoke("addItemStringList$??", "addItemStringList(const QString&, QStringList&, const QStringList&)", typeof(KConfigSkeleton.ItemStringList), typeof(string), name, typeof(List<string>), reference, typeof(List<string>), defaultValue);
		}
		public KConfigSkeleton.ItemStringList AddItemStringList(string name, List<string> reference) {
			return (KConfigSkeleton.ItemStringList) interceptor.Invoke("addItemStringList$?", "addItemStringList(const QString&, QStringList&)", typeof(KConfigSkeleton.ItemStringList), typeof(string), name, typeof(List<string>), reference);
		}
		/// <remarks>
		///  Register an item of type QList<int>.
		/// <param> name="name" Name used to identify this setting. Names must be unique.
		/// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
		///  calls and read by writeConfig() calls.
		/// </param><param> name="defaultValue" Default value, which is used when the config file
		///  does not yet contain the key of this item.
		/// </param><param> name="key" Key used in config file. If key is null, name is used as key.
		/// </param></remarks>		<return> The created item
		///    </return>
		/// 		<short>    Register an item of type QList<int>.</short>
		/// <remarks>
		///  Return the <see cref="KConfig"></see> object used for reading and writing the settings.
		///    </remarks>		<short>    Return the @ref KConfig object used for reading and writing the settings.</short>
		public KConfig Config() {
			return (KConfig) interceptor.Invoke("config", "config()", typeof(KConfig));
		}
		/// <remarks>
		///  Set the <see cref="KSharedConfig"></see> object used for reading and writing the settings.
		///    </remarks>		<short>    Set the @ref KSharedConfig object used for reading and writing the settings.</short>
		/// <remarks>
		///  Return list of items managed by this KConfigSkeleton object.
		///    </remarks>		<short>    Return list of items managed by this KConfigSkeleton object.</short>
		/// <remarks>
		///  Return whether a certain item is immutable
		///    </remarks>		<short>    Return whether a certain item is immutable    </short>
		public bool IsImmutable(string name) {
			return (bool) interceptor.Invoke("isImmutable$", "isImmutable(const QString&)", typeof(bool), typeof(string), name);
		}
		/// <remarks>
		///  Lookup item by name
		///    </remarks>		<short>    Lookup item by name    </short>
		public KConfigSkeletonItem FindItem(string name) {
			return (KConfigSkeletonItem) interceptor.Invoke("findItem$", "findItem(const QString&)", typeof(KConfigSkeletonItem), typeof(string), name);
		}
		/// <remarks>
		///  Specify whether this object should reflect the actual values or the
		///  default values.
		///  This method is implemented by usrUseDefaults(), which can be overridden
		///  in derived classes if you have special requirements and can call
		///  usrUseDefaults() directly.
		///  If you don't have control wether useDefaults() or usrUseDefaults() is
		///  called override useDefaults() directly.
		/// <param> name="b" true to make this object reflect the default values,
		///           false to make it reflect the actual values.
		/// </param></remarks>		<return> The state prior to this call
		///    </return>
		/// 		<short>    Specify whether this object should reflect the actual values or the  default values.</short>
		public bool UseDefaults(bool b) {
			return (bool) interceptor.Invoke("useDefaults$", "useDefaults(bool)", typeof(bool), typeof(bool), b);
		}
		/// <remarks>
		///  Implemented by subclasses that use special defaults.
		///  It replaces the default values with the actual values and
		///  vice versa.  Called from <see cref="#useDefaults"></see>
		/// <param> name="b" true to make this object reflect the default values,
		///           false to make it reflect the actual values.
		/// </param></remarks>		<return> The state prior to this call
		///    </return>
		/// 		<short>    Implemented by subclasses that use special defaults.</short>
		[SmokeMethod("usrUseDefaults(bool)")]
		protected virtual bool UsrUseDefaults(bool b) {
			return (bool) interceptor.Invoke("usrUseDefaults$", "usrUseDefaults(bool)", typeof(bool), typeof(bool), b);
		}
		/// <remarks>
		///  Perform the actual setting of default values.
		///  Override in derived classes to set special default values.
		///  Called from <see cref="#setDefaults"></see>
		///    </remarks>		<short>    Perform the actual setting of default values.</short>
		[SmokeMethod("usrSetDefaults()")]
		protected virtual void UsrSetDefaults() {
			interceptor.Invoke("usrSetDefaults", "usrSetDefaults()", typeof(void));
		}
		/// <remarks>
		///  Perform the actual reading of the configuration file.
		///  Override in derived classes to read special config values.
		///  Called from <see cref="#readConfig"></see>
		///    </remarks>		<short>    Perform the actual reading of the configuration file.</short>
		[SmokeMethod("usrReadConfig()")]
		protected virtual void UsrReadConfig() {
			interceptor.Invoke("usrReadConfig", "usrReadConfig()", typeof(void));
		}
		/// <remarks>
		///  Perform the actual writing of the configuration file.
		///  Override in derived classes to write special config values.
		///  Called from <see cref="#writeConfig"></see>
		///    </remarks>		<short>    Perform the actual writing of the configuration file.</short>
		[SmokeMethod("usrWriteConfig()")]
		protected virtual void UsrWriteConfig() {
			interceptor.Invoke("usrWriteConfig", "usrWriteConfig()", typeof(void));
		}
		~KConfigSkeleton() {
			interceptor.Invoke("~KConfigSkeleton", "~KConfigSkeleton()", typeof(void));
		}
		public new void Dispose() {
			interceptor.Invoke("~KConfigSkeleton", "~KConfigSkeleton()", typeof(void));
		}
		protected new IKConfigSkeletonSignals Emit {
			get { return (IKConfigSkeletonSignals) Q_EMIT; }
		}
	}

	public interface IKConfigSkeletonSignals : IQObjectSignals {
		/// <remarks>
		///  This signal is emitted when the configuration change.
		///    </remarks>		<short>    This signal is emitted when the configuration change.</short>
		[Q_SIGNAL("void configChanged()")]
		void ConfigChanged();
	}
}
