#!/usr/bin/python
###########################################################################
# setup - description                                                     #
# ------------------------------                                          #
# begin     : Fri Jun 27 2003                                             #
# copyright : (C) 2003-2004 by Simon Edwards                              #
# email     : simon@simonzone.com                                         #
#                                                                         #
###########################################################################
#                                                                         #
#   This program is free software; you can redistribute it and/or modify  #
#   it under the terms of the GNU General Public License as published by  #
#   the Free Software Foundation; either version 2 of the License, or     #
#   (at your option) any later version.                                   #
#                                                                         #
###########################################################################

from distutils.core import Extension
import kdedistutils

###########################################################################
def doit():
    kdedistutils.setup(name="guidance",
        version="0.4.0",
        author="Simon Edwards",
        author_email="simon@simonzone.com",
        url="http://www.simonzone.com/software/guidance/",
        min_kde_version = "3.0.0",
        min_qt_version = "3.0.0",
        license = "GPL",
        executable_links = [('serviceconfig','serviceconfig.py'),
            ('userconfig','userconfig.py'),
            ('mountconfig','mountconfig.py'),
            ('displayconfig','displayconfig.py')],
            
        data_files = [# Icons for in KControl
                      ('share/icons/crystalsvg/16x16/apps',['kde/serviceconfig/pics/16x16/daemons.png',\
                        'kde/mountconfig/pics/16x16/disksfilesystems.png', \
                        'kde/userconfig/pics/16x16/userconfig.png',\
                        'kde/displayconfig/pics/16x16/displayconfig.png'])],

        i18n = ('po',['mountconfig','userconfig','serviceconfig','displayconfig']),

        application_data = [('pics',\
                                ['kde/serviceconfig/pics/laserwarn.png',
                                'kde/serviceconfig/pics/hi32-app-daemons.png',
                                'kde/userconfig/pics/hi16-encrypted.png',
                                'kde/userconfig/pics/hi32-user.png',
                                'kde/userconfig/pics/hi32-group.png',
                                'kde/userconfig/pics/hi32-identity.png',
                                'kde/userconfig/pics/hi32-password.png',
                                'kde/mountconfig/pics/kcmpartitions.png',
                                'kde/mountconfig/pics/kde1.png',
                                'kde/mountconfig/pics/kde2.png',
                                'kde/mountconfig/pics/kde3.png',
                                'kde/mountconfig/pics/kde4.png',
                                'kde/mountconfig/pics/kde5.png',
                                'kde/mountconfig/pics/kde6.png',
                                'kde/mountconfig/pics/hi32-samba.png',
                                'kde/mountconfig/pics/hi16-hdd.png',
                                'kde/mountconfig/pics/hi16-cdrom.png',
                                'kde/mountconfig/pics/hi16-burner.png',
                                'kde/mountconfig/pics/hi16-floppy.png',
                                'kde/mountconfig/pics/hi16-blockdevice.png',
                                'kde/mountconfig/pics/hi16-password.png',
                                'kde/mountconfig/pics/hi16-memory.png',
                                'kde/mountconfig/pics/hi16-network.png',
                                'kde/mountconfig/pics/hi16-lock.png',
                                'kde/mountconfig/pics/greenled.png',
                                'kde/mountconfig/pics/greyled.png',
                                'kde/mountconfig/pics/exec.png',
                                'kde/mountconfig/pics/file.png',
                                'kde/mountconfig/pics/important.png',
                                'kde/mountconfig/pics/tux.png',
                                'kde/mountconfig/pics/user.png',
                                'kde/displayconfig/pics/energystar.png',
                                'kde/displayconfig/pics/hi32-gfxcard.png',
                                'kde/displayconfig/pics/hi32-display.png']),
                            ('pics/displayconfig/dualhead', \
                                ['kde/displayconfig/pics/dualhead/monitor_1.png',
                                'kde/displayconfig/pics/dualhead/monitor_1_hi.png',
                                'kde/displayconfig/pics/dualhead/monitor_2.png',
                                'kde/displayconfig/pics/dualhead/monitor_2_hi.png']),
                            ('pics/displayconfig/monitor_resizable', \
                                ['kde/displayconfig/pics/monitor_resizable/res-01.png',
                                'kde/displayconfig/pics/monitor_resizable/res-02.png',
                                'kde/displayconfig/pics/monitor_resizable/res-03.png',
                                'kde/displayconfig/pics/monitor_resizable/res-04.png',
                                'kde/displayconfig/pics/monitor_resizable/res-06.png',
                                'kde/displayconfig/pics/monitor_resizable/centerimage.png',
                                'kde/displayconfig/pics/monitor_resizable/res-07.png',
                                'kde/displayconfig/pics/monitor_resizable/res-08.png',
                                'kde/displayconfig/pics/monitor_resizable/res-09.png',
                                'kde/displayconfig/pics/monitor_resizable/res-11.png']),
                            ('pics/displayconfig/gammapics', \
                                ['kde/displayconfig/pics/gammapics/DGam14.png',
                                'kde/displayconfig/pics/gammapics/DGam16.png',
                                'kde/displayconfig/pics/gammapics/DGam18.png',
                                'kde/displayconfig/pics/gammapics/DGam20.png',
                                'kde/displayconfig/pics/gammapics/DGam22.png',
                                'kde/displayconfig/pics/gammapics/DGam24.png',
                                'kde/displayconfig/pics/gammapics/Gamma14.png',
                                'kde/displayconfig/pics/gammapics/Gamma16.png',
                                'kde/displayconfig/pics/gammapics/Gamma18.png',
                                'kde/displayconfig/pics/gammapics/Gamma20.png',
                                'kde/displayconfig/pics/gammapics/Gamma22.png',
                                'kde/displayconfig/pics/gammapics/Gamma24.png',
                                'kde/displayconfig/pics/gammapics/MGam14.png',
                                'kde/displayconfig/pics/gammapics/MGam16.png',
                                'kde/displayconfig/pics/gammapics/MGam18.png',
                                'kde/displayconfig/pics/gammapics/MGam20.png',
                                'kde/displayconfig/pics/gammapics/MGam22.png',
                                'kde/displayconfig/pics/gammapics/MGam24.png',
                                'kde/displayconfig/pics/gammapics/ranges.png']),
                            'serviceconfig/serviceconfig.py',\
                            'userconfig/userconfig.py',\
                            'userconfig/unixauthdb.py',\
                            'mountconfig/mountconfig.py',\
                            'mountconfig/MicroHAL.py',\
                            'mountconfig/SMBShareSelectDialog.py',\
                            'mountconfig/SimpleCommandRunner.py',\
                            'mountconfig/fuser.py',\
                            'mountconfig/fuser_ui.py',\
                            'displayconfig/displayconfig.py',\
                            'displayconfig/displayconfigabstraction.py',\
                            'displayconfig/displayconfigwidgets.py',\
                            'displayconfig/ScanPCI.py',\
                            'displayconfig/ktimerdialog.py',\
                            'displayconfig/servertestdialog.py',\
                            'displayconfig/xorgconfig.py',\
                            'displayconfig/vesamodes',\
                            'displayconfig/extramodes'],
                  
        kcontrol_modules = [ \
            ('serviceconfig/serviceconfig.desktop','serviceconfig.py'),
            ('userconfig/userconfig.desktop','userconfig.py'),
            ('mountconfig/mountconfig.desktop','mountconfig.py'),
            ('displayconfig/displayconfig.desktop','displayconfig.py')],

        docbooks = [ ('doc/en','en') ],

        package_dir={'':'modules'},
        py_modules=['xf86misc'],
        ext_modules=[\
            Extension('ixf86misc',\
                sources=['modules/ixf86misc.c'],\
                library_dirs=['/usr/X11R6/lib'],\
                libraries=['X11','Xxf86vm','Xext','Xrandr','Xrender'])]
        )
doit()
