###########################################################################
# SimpleCommandRunner.py - description                                    #
# ------------------------------                                          #
# begin     : Tue May 17 2005                                             #
# copyright : (C) 2005 by Simon Edwards                                   #
# email     : simon@simonzone.com                                         #
#                                                                         #
###########################################################################
#                                                                         #
#   This program is free software; you can redistribute it and/or modify  #
#   it under the terms of the GNU General Public License as published by  #
#   the Free Software Foundation; either version 2 of the License, or     #
#   (at your option) any later version.                                   #
#                                                                         #
###########################################################################
from qt import *
from kdecore import *

debug = False
#debug = True


class SimpleCommandRunner(QObject):
    ########################################################################
    def __init__(self):
        QObject.__init__(self)
        
    ########################################################################
    def run(self,cmdlist,STDOUT_only=False):
        """Run the given command and return the result.
        
        Keyword arguments:
        cmdlist - Command and arguments. Given as a list of strings. The first item is
                  the executable.
        STDOUT_only - Do not return STDERR in the output stream.
                  
        Returns a tuple (rc,output). rc is the numeric return code from
        the command, or None if the command couldn't be started. output
        is the output from stdout and stderr.
        """
        global debug
        if debug: print cmdlist
        self.STDOUT_only = STDOUT_only
        self.output = ""
        proc = KProcess()
        proc.setEnvironment("LANG","US")
        proc.setEnvironment("LC_ALL","US")
        self.connect(proc,SIGNAL("receivedStdout(KProcess *,char *,int)"),self.slotStdout)        
        self.connect(proc,SIGNAL("receivedStderr(KProcess *,char *,int)"),self.slotStderr)
        proc.setArguments(cmdlist)
        rc = None
        if proc.start(proc.Block,proc.AllOutput)==True:
            if proc.normalExit():
                rc = proc.exitStatus()
        return (rc,self.output)

    ########################################################################
    def slotStdout(self,proc,buffer,buflen):
        global debug 
        if debug: print "slotStdout() |"+buffer+"|"
        self.output += buffer

    ########################################################################
    def slotStderr(self,proc,buffer,buflen):
        global debug
        if debug: print "slotStderr() |"+buffer+"|"
        if not self.STDOUT_only:
            self.output += buffer
