#!/usr/bin/python
###########################################################################
# displayconfig-restore.py - description                                  #
# ------------------------------                                          #
# begin     : Wed Dec 15 2004                                             #
# copyright : (C) 2004 by Simon Edwards                                   #
# email     : simon@simonzone.com                                         #
#                                                                         #
###########################################################################
#                                                                         #
#   This program is free software; you can redistribute it and/or modify  #
#   it under the terms of the GNU General Public License as published by  #
#   the Free Software Foundation; either version 2 of the License, or     #
#   (at your option) any later version.                                   #
#                                                                         #
###########################################################################
import os
import os.path
import select

############################################################################
def execWithCapture(command, argv, searchPath = 0, root = '/', stdin = 0,
        catchfd = 1, closefd = -1):

    (read, write) = os.pipe()
    childpid = os.fork()
    if (not childpid):
        if (root and root != '/'): os.chroot(root)
        os.dup2(write, catchfd)
        os.close(write)
        os.close(read)
        
        if closefd != -1:
            os.close(closefd)
        if stdin:
            os.dup2(stdin, 0)
            os.close(stdin)
        if (searchPath):
            os.execvp(command, argv)
        else:
            os.execv(command, argv)
        sys.exit(1)
    os.close(write)

    rc = ""
    s = "1"
    while (s):
        select.select([read], [], [])
        s = os.read(read, 1000)
        rc = rc + s

    os.close(read)

    try:
        os.waitpid(childpid, 0)
    except OSError, (errno, msg):
        print __name__, "waitpid:", msg

    return rc
    
############################################################################
def main():
    configpath = execWithCapture("kde-config",['kde-config','--path','config'],True)
    dirs = configpath.strip().split(":")
    for dir in dirs:
        if dir!="":
            configpath = os.path.join(dir,"displayconfigrc")
            if os.path.exists(configpath):
                # Parse the config file.
                fhandle = open(configpath)
                screens = []
                currentscreen = None
                for line in fhandle.readlines():
                    line = line.strip()
                    if line.startswith("[Screen"):
                        # Screen, width, height, refresh, reflectx, reflecty
                        currentscreen = [int(line[7:-1]), None, None, None, False, False, "0"]
                        screens.append(currentscreen)
                    elif line.startswith("["):
                        currentscreen = None
                    elif currentscreen is not None:
                        if line.startswith("width="):
                            currentscreen[1] = int(line[6:])
                        elif line.startswith("height="):
                            currentscreen[2] = int(line[7:])
                        elif line.startswith("refresh="):
                            currentscreen[3] = int(line[8:])
                        elif line.startswith("reflectX="):
                            currentscreen[4] = line[9:]=="1"
                        elif line.startswith("reflectY="):
                            currentscreen[5] = line[9:]=="1"
                        elif line.startswith("rotate="):
                            currentscreen[6] = line[7:]
                fhandle.close()
                
                if len(screens)!=0:
                    # Set the X server.
                    import xf86misc
                    xserver = xf86misc.XF86Server()
                    for screen in screens:
                        (id,width,height,refresh,reflectx,reflecty,rotate) = screen
                        
                        # Convert the stuff into RandR's rotation bitfield thingy.
                        if rotate=="0":
                            rotation = xf86misc.XF86Screen.RR_Rotate_0
                        elif rotate=="90":
                            rotation = xf86misc.XF86Screen.RR_Rotate_90
                        elif rotate=="180":
                            rotation = xf86misc.XF86Screen.RR_Rotate_180
                        elif rotate=="270":
                            rotation = xf86misc.XF86Screen.RR_Rotate_270
                        if reflectx:
                            rotation |= xf86misc.XF86Screen.RR_Reflect_X
                        if reflecty:
                            rotation |= xf86misc.XF86Screen.RR_Reflect_Y
                        
                        if len(xserver.getScreens())>=id:
                            xscreen = xserver.getScreens()[id]
                            availablesizes = xscreen.getAvailableSizes()
                            for sizeid in range(len(availablesizes)):
                                size = availablesizes[sizeid]
                                if size[0]==width and size[1]==height:
                                    if refresh in xscreen.getAvailableRefreshRates(sizeid):
                                        xscreen.setScreenConfigAndRate(sizeid,rotation,refresh)
                                        break
                return
main()
