/***************************************************************************
 *   Copyright (C) 2004-2005 by Jürgen Kofler                              *
 *   kaffeine@gmx.net                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/


#ifndef _DUMMYPART_H_
#define _DUMMYPART_H_


#include <kparts/factory.h>

#include <gst/gst.h>

#include "kmediapart.h"

#include "timer.h"
#include "video.h"
#include "videosettings.h"
#include "gstreamerconfig.h"

/**
 *  GStreamer based Media Part
 *  Based on kiss by Ronald Bultje <rbultje@ronald.bitfreak.net>
 */
class GStreamerPart : public KMediaPart
{
	Q_OBJECT
public:
	GStreamerPart(QWidget*, const char*, QObject*, const char*, const QStringList&);
	virtual ~GStreamerPart();

	/*
	 *Reimplement from KMediaPart
	 */
	bool isPlaying();
	bool isPaused();
	uint volume() const; /* percent */
	uint position() const; /* percent */
	bool hasVideo();

	bool closeURL();
	static KAboutData* createAboutData();
	void audiocdMRLS(MRL::List& list, bool& ok, bool& supported, const QString& device = QString::null);
	void vcdMRLS(MRL::List& list, bool& ok, bool& supported, const QString& device = QString::null);
	void dvdMRLS(MRL::List& list, bool& ok, bool& supported, const QString& device  = QString::null);

public slots:
	/*
	 * Reimplement from KMediaPart
	 */
	bool openURL(const MRL& mrl);
	void slotPlay();
	void slotTogglePause(bool);
	void slotSetVolume(uint); /* percent */
	void slotSetPosition(uint); /* percent */
	void slotStop();
	void slotMute();
	void slotPrepareForFullscreen(bool fullscreen);

protected:
	void timerEvent(QTimerEvent*);

private slots:
	void slotNext();
	void slotPrevious();
	void slotVolume(int);
	void slotSaturation(int); /* -1000...1000 */
	void slotHue(int); /* -1000...1000 */
	void slotContrast(int); /* -1000...1000 */
	void slotBrightness(int); /* -1000...1000 */
	void slotContextMenu(const QPoint& pos);
	void slotInfo();
	void slotSetVisualPlugin(const QString&);
	void slotVideoSettings();
	void slotConfigDialog();

private:
	bool initGStreamer();
	void loadConfig();
	void saveConfig();
	void gstPlay(const QString& trackUrl, const QString& subtitleUrl);
	void initActions();
	void showError();
	void gstStateChanged();
	void processMetaInfo();
	void setAudioSink(QString sinkName);

	//callbacks
	static void cb_error (GstElement *play, GstElement *src, GError     *err, const char *debug, gpointer data);
	static void cb_foundtag (GstElement *play, GstElement *src, const GstTagList *list, gpointer data);
	static void cb_eos (GstElement *play, gpointer data);
	static void cb_state (GstElement *play, GstElementState old_state, GstElementState new_state, gpointer data);
	static void got_source (GstElement* play, GParamSpec* pspec, gpointer data);

private:
	GstElement* m_play;
	GstElement* m_videosink;
	GstElement* m_audiosink;
	GstElement* m_visual;
	GstElementState m_newState;

	VideoWindow* m_video;
	Timer* m_timer;
	VideoSettings* m_videoSettings;
	GStreamerConfig* m_gstConfig;
	QSlider* m_volume;
	KSelectAction* m_audioVisual;

	MRL::List m_playlist;
	uint m_current;
	bool m_gstReady;
	bool m_mute;
	QString m_logoPath;

	QString m_errorMsg;
	QString m_errorDetails;

	QString m_url;
	QString m_title;
	QString m_artist;
	QString m_album;
	QString m_track;
	QString m_year;
	QString m_genre;
	QString m_comment;
	QString m_audioCodec;
	QString m_videoCodec;

	QString m_audioSinkName;
	QString m_videoSinkName;
	QString m_visualPluginName;
	QStringList m_audioVisualPluginList;
	QStringList m_audioPluginList;
	QStringList m_videoPluginList;
	QString m_device;
	int m_savedVolume;

	KToolBar* m_posToolbar;
};


#endif

