/*
 * Decompiled with CFR 0.152.
 */
package COM.sun.labs.jjtree;

import COM.sun.labs.javacc.Options;
import COM.sun.labs.jjtree.ASTBNFDeclaration;
import COM.sun.labs.jjtree.ASTBNFNodeScope;
import COM.sun.labs.jjtree.ASTBNFNonTerminal;
import COM.sun.labs.jjtree.ASTExpansionNodeScope;
import COM.sun.labs.jjtree.ASTNodeDescriptor;
import COM.sun.labs.jjtree.ASTProduction;
import COM.sun.labs.jjtree.IO;
import COM.sun.labs.jjtree.JJTreeGlobals;
import COM.sun.labs.jjtree.Node;
import COM.sun.labs.jjtree.NodeFiles;
import COM.sun.labs.jjtree.SimpleNode;
import COM.sun.labs.jjtree.Token;
import COM.sun.labs.jjtree.TokenUtils;
import java.util.Enumeration;
import java.util.Hashtable;

public class NodeScope {
    private ASTProduction production;
    private ASTNodeDescriptor node_descriptor;
    private String closedVar;
    private String exceptionVar;
    private String nodeVar;
    private int scopeNumber;

    NodeScope(ASTProduction aSTProduction, ASTNodeDescriptor aSTNodeDescriptor) {
        this.production = aSTProduction;
        if (aSTNodeDescriptor == null) {
            String string = this.production.name;
            if (Options.B("NODE_DEFAULT_VOID")) {
                string = "void";
            }
            this.node_descriptor = ASTNodeDescriptor.indefinite(string);
        } else {
            this.node_descriptor = aSTNodeDescriptor;
        }
        this.scopeNumber = this.production.getNodeScopeNumber(this);
        this.nodeVar = this.constructVariable("n");
        this.closedVar = this.constructVariable("c");
        this.exceptionVar = this.constructVariable("e");
    }

    private String constructVariable(String string) {
        String string2 = "000" + this.scopeNumber;
        return "jjt" + string + string2.substring(string2.length() - 3, string2.length());
    }

    private static void findThrown(Hashtable hashtable, SimpleNode simpleNode) {
        String string;
        SimpleNode simpleNode2;
        if (simpleNode instanceof ASTBNFNonTerminal && (simpleNode2 = (ASTProduction)JJTreeGlobals.productions.get(string = simpleNode.getFirstToken().image)) != null) {
            Enumeration enumeration = simpleNode2.throws_list.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                hashtable.put(string2, string2);
            }
        }
        int n = 0;
        while (n < simpleNode.jjtGetNumChildren()) {
            simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(n);
            NodeScope.findThrown(hashtable, simpleNode2);
            ++n;
        }
    }

    static NodeScope getEnclosingNodeScope(Node node) {
        if (node instanceof ASTBNFDeclaration) {
            return ((ASTBNFDeclaration)node).node_scope;
        }
        Node node2 = node.jjtGetParent();
        while (node2 != null) {
            if (node2 instanceof ASTBNFDeclaration) {
                return ((ASTBNFDeclaration)node2).node_scope;
            }
            if (node2 instanceof ASTBNFNodeScope) {
                return ((ASTBNFNodeScope)node2).node_scope;
            }
            if (node2 instanceof ASTExpansionNodeScope) {
                return ((ASTExpansionNodeScope)node2).node_scope;
            }
            node2 = node2.jjtGetParent();
        }
        return null;
    }

    ASTNodeDescriptor getNodeDescriptor() {
        return this.node_descriptor;
    }

    String getNodeDescriptorText() {
        return this.node_descriptor.getDescriptor();
    }

    String getNodeVariable() {
        return this.nodeVar;
    }

    private void insertCatchBlocks(IO iO, Enumeration enumeration, String string) {
        boolean bl = false;
        if (enumeration.hasMoreElements()) {
            iO.println(String.valueOf(string) + "} catch (Throwable " + this.exceptionVar + ") {");
            if (this.usesCloseNodeVar()) {
                iO.println(String.valueOf(string) + "  if (" + this.closedVar + ") {");
                iO.println(String.valueOf(string) + "    jjtree.clearNodeScope(" + this.nodeVar + ");");
                iO.println(String.valueOf(string) + "    " + this.closedVar + " = false;");
                iO.println(String.valueOf(string) + "  } else {");
                iO.println(String.valueOf(string) + "    jjtree.popNode();");
                iO.println(String.valueOf(string) + "  }");
            }
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                iO.println(String.valueOf(string) + "  if (" + this.exceptionVar + " instanceof " + string2 + ") {");
                iO.println(String.valueOf(string) + "    throw (" + string2 + ")" + this.exceptionVar + ";");
                iO.println(String.valueOf(string) + "  }");
            }
            iO.println(String.valueOf(string) + "  throw (Error)" + this.exceptionVar + ";");
        }
    }

    void insertCloseNodeAction(IO iO, String string) {
        iO.println(String.valueOf(string) + "{");
        this.insertCloseNodeCode(iO, String.valueOf(string) + "  ", false);
        iO.println(String.valueOf(string) + "}");
    }

    void insertCloseNodeCode(IO iO, String string, boolean bl) {
        iO.println(String.valueOf(string) + this.node_descriptor.closeNode(this.nodeVar));
        if (this.usesCloseNodeVar() && !bl) {
            iO.println(String.valueOf(string) + this.closedVar + " = false;");
        }
        if (Options.B("NODE_SCOPE_HOOK")) {
            iO.println(String.valueOf(string) + "jjtreeCloseNodeScope(" + this.nodeVar + ");");
        }
    }

    void insertOpenNodeAction(IO iO, String string) {
        iO.println(String.valueOf(string) + "{");
        this.insertOpenNodeCode(iO, String.valueOf(string) + "  ");
        iO.println(String.valueOf(string) + "}");
    }

    void insertOpenNodeCode(IO iO, String string) {
        String string2 = this.node_descriptor.getNodeType();
        String string3 = this.node_descriptor.getNodeName();
        NodeFiles.ensure(iO, string2);
        iO.print(String.valueOf(string) + string2 + " " + this.nodeVar + " = ");
        if (Options.B("NODE_FACTORY")) {
            if (Options.B("NODE_USES_PARSER")) {
                String string4 = Options.B("STATIC") ? "null" : "this";
                iO.println("(" + string2 + ")" + string2 + ".jjtCreate(" + string4 + ", " + this.node_descriptor.getNodeId() + ");");
            } else {
                iO.println("(" + string2 + ")" + string2 + ".jjtCreate(" + this.node_descriptor.getNodeId() + ");");
            }
        } else if (Options.B("NODE_USES_PARSER")) {
            String string5 = Options.B("STATIC") ? "null" : "this";
            iO.println("new " + string2 + "(" + string5 + ", " + this.node_descriptor.getNodeId() + ");");
        } else {
            iO.println("new " + string2 + "(" + this.node_descriptor.getNodeId() + ");");
        }
        if (this.usesCloseNodeVar()) {
            iO.println(String.valueOf(string) + "boolean " + this.closedVar + " = true;");
        }
        iO.println(String.valueOf(string) + this.node_descriptor.openNode(this.nodeVar));
        if (Options.B("NODE_SCOPE_HOOK")) {
            iO.println(String.valueOf(string) + "jjtreeOpenNodeScope(" + this.nodeVar + ");");
        }
    }

    void insertOpenNodeDeclaration(IO iO, String string) {
        this.insertOpenNodeCode(iO, string);
    }

    boolean isVoid() {
        return this.node_descriptor.isVoid();
    }

    void tryExpansionUnit(IO iO, String string, SimpleNode simpleNode) {
        iO.println(String.valueOf(string) + "try {");
        SimpleNode.closeJJTreeComment(iO);
        simpleNode.print(iO);
        SimpleNode.openJJTreeComment(iO, null);
        iO.println();
        Hashtable hashtable = new Hashtable();
        NodeScope.findThrown(hashtable, simpleNode);
        Enumeration enumeration = hashtable.elements();
        this.insertCatchBlocks(iO, enumeration, string);
        iO.println(String.valueOf(string) + "} finally {");
        if (this.usesCloseNodeVar()) {
            iO.println(String.valueOf(string) + "  if (" + this.closedVar + ") {");
            this.insertCloseNodeCode(iO, String.valueOf(string) + "    ", true);
            iO.println(String.valueOf(string) + "  }");
        }
        iO.println(String.valueOf(string) + "}");
        SimpleNode.closeJJTreeComment(iO);
    }

    void tryTokenSequence(IO iO, String string, Token token, Token token2) {
        iO.println(String.valueOf(string) + "try {");
        SimpleNode.closeJJTreeComment(iO);
        Token token3 = token;
        while (token3 != token2.next) {
            TokenUtils.print(token3, iO, "jjtThis", this.nodeVar);
            token3 = token3.next;
        }
        SimpleNode.openJJTreeComment(iO, null);
        iO.println();
        Enumeration enumeration = this.production.throws_list.elements();
        this.insertCatchBlocks(iO, enumeration, string);
        iO.println(String.valueOf(string) + "} finally {");
        if (this.usesCloseNodeVar()) {
            iO.println(String.valueOf(string) + "  if (" + this.closedVar + ") {");
            this.insertCloseNodeCode(iO, String.valueOf(string) + "    ", true);
            iO.println(String.valueOf(string) + "  }");
        }
        iO.println(String.valueOf(string) + "}");
        SimpleNode.closeJJTreeComment(iO);
    }

    boolean usesCloseNodeVar() {
        return true;
    }
}

