/* player-controller.c generated by valac 0.16.1, the Vala compiler
 * generated from player-controller.vala, do not modify */

/*
Copyright 2010 Canonical Ltd.

Authors:
    Conor Curran <conor.curran@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/dbusmenu-glib.h>
#include <libdbusmenu-glib/enum-types.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>
#include <libdbusmenu-glib/types.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <common-defs.h>


#define TYPE_PLAYER_CONTROLLER (player_controller_get_type ())
#define PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_CONTROLLER, PlayerController))
#define PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_CONTROLLER, PlayerControllerClass))
#define IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_CONTROLLER))
#define IS_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_CONTROLLER))
#define PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_CONTROLLER, PlayerControllerClass))

typedef struct _PlayerController PlayerController;
typedef struct _PlayerControllerClass PlayerControllerClass;
typedef struct _PlayerControllerPrivate PlayerControllerPrivate;

#define TYPE_PLAYER_ITEM (player_item_get_type ())
#define PLAYER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_ITEM, PlayerItem))
#define PLAYER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_ITEM, PlayerItemClass))
#define IS_PLAYER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_ITEM))
#define IS_PLAYER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_ITEM))
#define PLAYER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_ITEM, PlayerItemClass))

typedef struct _PlayerItem PlayerItem;
typedef struct _PlayerItemClass PlayerItemClass;

#define TYPE_MPRIS2_CONTROLLER (mpris2_controller_get_type ())
#define MPRIS2_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS2_CONTROLLER, Mpris2Controller))
#define MPRIS2_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MPRIS2_CONTROLLER, Mpris2ControllerClass))
#define IS_MPRIS2_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS2_CONTROLLER))
#define IS_MPRIS2_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MPRIS2_CONTROLLER))
#define MPRIS2_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MPRIS2_CONTROLLER, Mpris2ControllerClass))

typedef struct _Mpris2Controller Mpris2Controller;
typedef struct _Mpris2ControllerClass Mpris2ControllerClass;

#define TYPE_SPECIFIC_ITEMS_MANAGER (specific_items_manager_get_type ())
#define SPECIFIC_ITEMS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SPECIFIC_ITEMS_MANAGER, SpecificItemsManager))
#define SPECIFIC_ITEMS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SPECIFIC_ITEMS_MANAGER, SpecificItemsManagerClass))
#define IS_SPECIFIC_ITEMS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SPECIFIC_ITEMS_MANAGER))
#define IS_SPECIFIC_ITEMS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SPECIFIC_ITEMS_MANAGER))
#define SPECIFIC_ITEMS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SPECIFIC_ITEMS_MANAGER, SpecificItemsManagerClass))

typedef struct _SpecificItemsManager SpecificItemsManager;
typedef struct _SpecificItemsManagerClass SpecificItemsManagerClass;

#define PLAYER_CONTROLLER_TYPE_WIDGET_ORDER (player_controller_widget_order_get_type ())

#define PLAYER_CONTROLLER_TYPE_STATE (player_controller_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SPECIFIC_ITEMS_MANAGER_TYPE_CATEGORY (specific_items_manager_category_get_type ())

#define TYPE_PLAYLISTS_MENUITEM (playlists_menuitem_get_type ())
#define PLAYLISTS_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYLISTS_MENUITEM, PlaylistsMenuitem))
#define PLAYLISTS_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYLISTS_MENUITEM, PlaylistsMenuitemClass))
#define IS_PLAYLISTS_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYLISTS_MENUITEM))
#define IS_PLAYLISTS_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYLISTS_MENUITEM))
#define PLAYLISTS_MENUITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYLISTS_MENUITEM, PlaylistsMenuitemClass))

typedef struct _PlaylistsMenuitem PlaylistsMenuitem;
typedef struct _PlaylistsMenuitemClass PlaylistsMenuitemClass;
typedef struct _PlayerItemPrivate PlayerItemPrivate;
typedef struct _PlaylistsMenuitemPrivate PlaylistsMenuitemPrivate;

#define TYPE_TRANSPORT_MENUITEM (transport_menuitem_get_type ())
#define TRANSPORT_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSPORT_MENUITEM, TransportMenuitem))
#define TRANSPORT_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSPORT_MENUITEM, TransportMenuitemClass))
#define IS_TRANSPORT_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSPORT_MENUITEM))
#define IS_TRANSPORT_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSPORT_MENUITEM))
#define TRANSPORT_MENUITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSPORT_MENUITEM, TransportMenuitemClass))

typedef struct _TransportMenuitem TransportMenuitem;
typedef struct _TransportMenuitemClass TransportMenuitemClass;

#define TYPE_METADATA_MENUITEM (metadata_menuitem_get_type ())
#define METADATA_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_MENUITEM, MetadataMenuitem))
#define METADATA_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_MENUITEM, MetadataMenuitemClass))
#define IS_METADATA_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_MENUITEM))
#define IS_METADATA_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_MENUITEM))
#define METADATA_MENUITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_MENUITEM, MetadataMenuitemClass))

typedef struct _MetadataMenuitem MetadataMenuitem;
typedef struct _MetadataMenuitemClass MetadataMenuitemClass;

struct _PlayerController {
	GObject parent_instance;
	PlayerControllerPrivate * priv;
	gint current_state;
	DbusmenuMenuitem* root_menu;
	GeeArrayList* custom_items;
	Mpris2Controller* mpris_bridge;
	gboolean* use_playlists;
};

struct _PlayerControllerClass {
	GObjectClass parent_class;
};

struct _PlayerControllerPrivate {
	gchar* _dbus_name;
	GAppInfo* _app_info;
	gint _menu_offset;
	gchar* _icon_name;
	gboolean _is_preferred;
	SpecificItemsManager* track_specific_mgr;
	SpecificItemsManager* player_specific_mgr;
};

typedef enum  {
	PLAYER_CONTROLLER_WIDGET_ORDER_SEPARATOR,
	PLAYER_CONTROLLER_WIDGET_ORDER_METADATA,
	PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT,
	PLAYER_CONTROLLER_WIDGET_ORDER_PLAYLISTS
} PlayerControllerwidget_order;

typedef enum  {
	PLAYER_CONTROLLER_STATE_OFFLINE,
	PLAYER_CONTROLLER_STATE_INSTANTIATING,
	PLAYER_CONTROLLER_STATE_READY,
	PLAYER_CONTROLLER_STATE_CONNECTED,
	PLAYER_CONTROLLER_STATE_DISCONNECTED
} PlayerControllerstate;

typedef enum  {
	SPECIFIC_ITEMS_MANAGER_CATEGORY_TRACK,
	SPECIFIC_ITEMS_MANAGER_CATEGORY_PLAYER
} SpecificItemsManagercategory;

struct _PlayerItem {
	DbusmenuMenuitem parent_instance;
	PlayerItemPrivate * priv;
};

struct _PlayerItemClass {
	DbusmenuMenuitemClass parent_class;
};

struct _PlaylistsMenuitem {
	PlayerItem parent_instance;
	PlaylistsMenuitemPrivate * priv;
	DbusmenuMenuitem* root_item;
};

struct _PlaylistsMenuitemClass {
	PlayerItemClass parent_class;
};


static gpointer player_controller_parent_class = NULL;

GType player_controller_get_type (void) G_GNUC_CONST;
GType player_item_get_type (void) G_GNUC_CONST;
GType mpris2_controller_get_type (void) G_GNUC_CONST;
GType specific_items_manager_get_type (void) G_GNUC_CONST;
#define PLAYER_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PLAYER_CONTROLLER, PlayerControllerPrivate))
enum  {
	PLAYER_CONTROLLER_DUMMY_PROPERTY,
	PLAYER_CONTROLLER_DBUS_NAME,
	PLAYER_CONTROLLER_APP_INFO,
	PLAYER_CONTROLLER_MENU_OFFSET,
	PLAYER_CONTROLLER_ICON_NAME,
	PLAYER_CONTROLLER_IS_PREFERRED
};
GType player_controller_widget_order_get_type (void) G_GNUC_CONST;
GType player_controller_state_get_type (void) G_GNUC_CONST;
#define PLAYER_CONTROLLER_WIDGET_QUANTITY 4
PlayerController* player_controller_new (DbusmenuMenuitem* root, GAppInfo* app, const gchar* dbus_name, const gchar* icon_name, gint offset, gboolean* use_playlists, PlayerControllerstate initial_state, gboolean is_preferred);
PlayerController* player_controller_construct (GType object_type, DbusmenuMenuitem* root, GAppInfo* app, const gchar* dbus_name, const gchar* icon_name, gint offset, gboolean* use_playlists, PlayerControllerstate initial_state, gboolean is_preferred);
static gboolean* _bool_dup (gboolean* self);
void player_controller_set_app_info (PlayerController* self, GAppInfo* value);
void player_controller_set_dbus_name (PlayerController* self, const gchar* value);
void player_controller_set_icon_name (PlayerController* self, const gchar* value);
void player_controller_set_menu_offset (PlayerController* self, gint value);
static void player_controller_set_is_preferred (PlayerController* self, gboolean value);
static void player_controller_construct_widgets (PlayerController* self);
static void player_controller_establish_mpris_connection (PlayerController* self);
void player_controller_update_layout (PlayerController* self);
GAppInfo* player_controller_get_app_info (PlayerController* self);
const gchar* player_controller_get_icon_name (PlayerController* self);
void player_controller_update_state (PlayerController* self, PlayerControllerstate new_state);
void player_controller_activate (PlayerController* self, const gchar* dbus_name);
void player_controller_instantiate (PlayerController* self);
void player_controller_enable_track_specific_items (PlayerController* self, const gchar* object_path);
GType specific_items_manager_category_get_type (void) G_GNUC_CONST;
SpecificItemsManager* specific_items_manager_new (PlayerController* controller, const gchar* path, SpecificItemsManagercategory which_type);
SpecificItemsManager* specific_items_manager_construct (GType object_type, PlayerController* controller, const gchar* path, SpecificItemsManagercategory which_type);
void player_controller_enable_player_specific_items (PlayerController* self, const gchar* object_path);
gint player_controller_track_specific_count (PlayerController* self);
GeeArrayList* specific_items_manager_get_proxy_items (SpecificItemsManager* self);
const gchar* player_controller_get_dbus_name (PlayerController* self);
Mpris2Controller* mpris2_controller_new (PlayerController* ctrl);
Mpris2Controller* mpris2_controller_construct (GType object_type, PlayerController* ctrl);
static void player_controller_determine_state (PlayerController* self);
void player_controller_remove_from_menu (PlayerController* self);
static gboolean _bool_equal (const gboolean* s1, const gboolean* s2);
GType playlists_menuitem_get_type (void) G_GNUC_CONST;
void player_controller_set_as_preferred (PlayerController* self, gboolean val);
void player_controller_hibernate (PlayerController* self);
GType transport_menuitem_get_type (void) G_GNUC_CONST;
void transport_menuitem_change_play_state (TransportMenuitem* self, TransportState update);
void player_item_reset (PlayerItem* self, GeeHashSet* attrs);
GeeHashSet* metadata_menuitem_relevant_attributes_for_ui (void);
GType metadata_menuitem_get_type (void) G_GNUC_CONST;
void metadata_menuitem_toggle_active_triangle (MetadataMenuitem* self, gboolean update);
void metadata_menuitem_should_collapse (MetadataMenuitem* self, gboolean collapse);
gboolean player_controller_get_is_preferred (PlayerController* self);
gboolean player_item_populated (PlayerItem* self, GeeHashSet* attrs);
void transport_menuitem_handle_cached_action (TransportMenuitem* self);
PlayerItem* player_item_new (const gchar* type);
PlayerItem* player_item_construct (GType object_type, const gchar* type);
MetadataMenuitem* metadata_menuitem_new (PlayerController* parent);
MetadataMenuitem* metadata_menuitem_construct (GType object_type, PlayerController* parent);
TransportMenuitem* transport_menuitem_new (PlayerController* parent);
TransportMenuitem* transport_menuitem_construct (GType object_type, PlayerController* parent);
PlaylistsMenuitem* playlists_menuitem_new (PlayerController* parent);
PlaylistsMenuitem* playlists_menuitem_construct (GType object_type, PlayerController* parent);
gint player_controller_get_menu_offset (PlayerController* self);
gboolean mpris2_controller_connected (Mpris2Controller* self);
void mpris2_controller_initial_update (Mpris2Controller* self);
static void player_controller_finalize (GObject* obj);
static void _vala_player_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_player_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType player_controller_widget_order_get_type (void) {
	static volatile gsize player_controller_widget_order_type_id__volatile = 0;
	if (g_once_init_enter (&player_controller_widget_order_type_id__volatile)) {
		static const GEnumValue values[] = {{PLAYER_CONTROLLER_WIDGET_ORDER_SEPARATOR, "PLAYER_CONTROLLER_WIDGET_ORDER_SEPARATOR", "separator"}, {PLAYER_CONTROLLER_WIDGET_ORDER_METADATA, "PLAYER_CONTROLLER_WIDGET_ORDER_METADATA", "metadata"}, {PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT, "PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT", "transport"}, {PLAYER_CONTROLLER_WIDGET_ORDER_PLAYLISTS, "PLAYER_CONTROLLER_WIDGET_ORDER_PLAYLISTS", "playlists"}, {0, NULL, NULL}};
		GType player_controller_widget_order_type_id;
		player_controller_widget_order_type_id = g_enum_register_static ("PlayerControllerwidget_order", values);
		g_once_init_leave (&player_controller_widget_order_type_id__volatile, player_controller_widget_order_type_id);
	}
	return player_controller_widget_order_type_id__volatile;
}


GType player_controller_state_get_type (void) {
	static volatile gsize player_controller_state_type_id__volatile = 0;
	if (g_once_init_enter (&player_controller_state_type_id__volatile)) {
		static const GEnumValue values[] = {{PLAYER_CONTROLLER_STATE_OFFLINE, "PLAYER_CONTROLLER_STATE_OFFLINE", "offline"}, {PLAYER_CONTROLLER_STATE_INSTANTIATING, "PLAYER_CONTROLLER_STATE_INSTANTIATING", "instantiating"}, {PLAYER_CONTROLLER_STATE_READY, "PLAYER_CONTROLLER_STATE_READY", "ready"}, {PLAYER_CONTROLLER_STATE_CONNECTED, "PLAYER_CONTROLLER_STATE_CONNECTED", "connected"}, {PLAYER_CONTROLLER_STATE_DISCONNECTED, "PLAYER_CONTROLLER_STATE_DISCONNECTED", "disconnected"}, {0, NULL, NULL}};
		GType player_controller_state_type_id;
		player_controller_state_type_id = g_enum_register_static ("PlayerControllerstate", values);
		g_once_init_leave (&player_controller_state_type_id__volatile, player_controller_state_type_id);
	}
	return player_controller_state_type_id__volatile;
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


PlayerController* player_controller_construct (GType object_type, DbusmenuMenuitem* root, GAppInfo* app, const gchar* dbus_name, const gchar* icon_name, gint offset, gboolean* use_playlists, PlayerControllerstate initial_state, gboolean is_preferred) {
	PlayerController * self = NULL;
	gboolean* _tmp0_;
	gboolean* _tmp1_;
	DbusmenuMenuitem* _tmp2_;
	DbusmenuMenuitem* _tmp3_;
	GAppInfo* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GeeArrayList* _tmp7_;
	PlayerControllerstate _tmp8_;
	gint _tmp9_;
	gboolean _tmp10_;
	GAppInfo* _tmp11_;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_;
	g_return_val_if_fail (root != NULL, NULL);
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	self = (PlayerController*) g_object_new (object_type, NULL);
	_tmp0_ = use_playlists;
	_tmp1_ = __bool_dup0 (_tmp0_);
	_g_free0 (self->use_playlists);
	self->use_playlists = _tmp1_;
	_tmp2_ = root;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->root_menu);
	self->root_menu = _tmp3_;
	_tmp4_ = app;
	player_controller_set_app_info (self, _tmp4_);
	_tmp5_ = dbus_name;
	player_controller_set_dbus_name (self, _tmp5_);
	_tmp6_ = icon_name;
	player_controller_set_icon_name (self, _tmp6_);
	_tmp7_ = gee_array_list_new (TYPE_PLAYER_ITEM, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_g_object_unref0 (self->custom_items);
	self->custom_items = _tmp7_;
	_tmp8_ = initial_state;
	self->current_state = (gint) _tmp8_;
	_tmp9_ = offset;
	player_controller_set_menu_offset (self, _tmp9_);
	_tmp10_ = is_preferred;
	player_controller_set_is_preferred (self, _tmp10_);
	player_controller_construct_widgets (self);
	player_controller_establish_mpris_connection (self);
	player_controller_update_layout (self);
	_tmp11_ = self->priv->_app_info;
	_tmp12_ = g_app_info_get_name (_tmp11_);
	_tmp13_ = self->priv->_icon_name;
	g_debug ("player-controller.vala:78: New player controller  for %s with icon nam" \
"e %s", _tmp12_, _tmp13_);
	return self;
}


PlayerController* player_controller_new (DbusmenuMenuitem* root, GAppInfo* app, const gchar* dbus_name, const gchar* icon_name, gint offset, gboolean* use_playlists, PlayerControllerstate initial_state, gboolean is_preferred) {
	return player_controller_construct (TYPE_PLAYER_CONTROLLER, root, app, dbus_name, icon_name, offset, use_playlists, initial_state, is_preferred);
}


void player_controller_update_state (PlayerController* self, PlayerControllerstate new_state) {
	GAppInfo* _tmp0_;
	const gchar* _tmp1_ = NULL;
	PlayerControllerstate _tmp2_;
	PlayerControllerstate _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_app_info;
	_tmp1_ = g_app_info_get_name (_tmp0_);
	_tmp2_ = new_state;
	g_debug ("player-controller.vala:83: update_state - player controller %s : new s" \
"tate %i", _tmp1_, (gint) _tmp2_);
	_tmp3_ = new_state;
	self->current_state = (gint) _tmp3_;
	player_controller_update_layout (self);
}


void player_controller_activate (PlayerController* self, const gchar* dbus_name) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbus_name != NULL);
	_tmp0_ = dbus_name;
	player_controller_set_dbus_name (self, _tmp0_);
	player_controller_establish_mpris_connection (self);
}


void player_controller_instantiate (PlayerController* self) {
	GAppInfo* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_app_info;
	_tmp1_ = g_app_info_get_name (_tmp0_);
	g_debug ("player-controller.vala:103: instantiate in player controller for %s", _tmp1_);
	{
		GAppInfo* _tmp2_;
		_tmp2_ = self->priv->_app_info;
		g_app_info_launch (_tmp2_, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		player_controller_update_state (self, PLAYER_CONTROLLER_STATE_INSTANTIATING);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* _error_ = NULL;
		GAppInfo* _tmp3_;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = self->priv->_app_info;
		_tmp4_ = g_app_info_get_name (_tmp3_);
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->message;
		g_warning ("player-controller.vala:109: Failed to launch app %s with error message" \
": %s", _tmp4_, _tmp6_);
		_g_error_free0 (_error_);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void player_controller_enable_track_specific_items (PlayerController* self, const gchar* object_path) {
	SpecificItemsManager* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object_path != NULL);
	_tmp0_ = self->priv->track_specific_mgr;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		SpecificItemsManager* _tmp2_;
		_tmp1_ = object_path;
		_tmp2_ = specific_items_manager_new (self, _tmp1_, SPECIFIC_ITEMS_MANAGER_CATEGORY_TRACK);
		_g_object_unref0 (self->priv->track_specific_mgr);
		self->priv->track_specific_mgr = _tmp2_;
	}
}


void player_controller_enable_player_specific_items (PlayerController* self, const gchar* object_path) {
	SpecificItemsManager* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object_path != NULL);
	_tmp0_ = self->priv->player_specific_mgr;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		SpecificItemsManager* _tmp2_;
		_tmp1_ = object_path;
		_tmp2_ = specific_items_manager_new (self, _tmp1_, SPECIFIC_ITEMS_MANAGER_CATEGORY_PLAYER);
		_g_object_unref0 (self->priv->player_specific_mgr);
		self->priv->player_specific_mgr = _tmp2_;
	}
}


gint player_controller_track_specific_count (PlayerController* self) {
	gint result = 0;
	SpecificItemsManager* _tmp0_;
	SpecificItemsManager* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->track_specific_mgr;
	if (_tmp0_ == NULL) {
		result = 0;
		return result;
	}
	_tmp1_ = self->priv->track_specific_mgr;
	_tmp2_ = specific_items_manager_get_proxy_items (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	result = _tmp5_;
	return result;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


static void player_controller_establish_mpris_connection (PlayerController* self) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp3_;
	gboolean* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	Mpris2Controller* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->current_state;
	if (_tmp1_ != ((gint) PLAYER_CONTROLLER_STATE_READY)) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_dbus_name;
		_tmp0_ = _tmp2_ == NULL;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		g_debug ("player-controller.vala:143: establish_mpris_connection - Not ready to " \
"connect");
		return;
	}
	_tmp4_ = self->use_playlists;
	_tmp5_ = bool_to_string (*_tmp4_);
	_tmp6_ = _tmp5_;
	g_debug ("player-controller.vala:146:  establish mpris connection - use playlist" \
"s value = %s ", _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = mpris2_controller_new (self);
	_g_object_unref0 (self->mpris_bridge);
	self->mpris_bridge = _tmp7_;
	player_controller_determine_state (self);
}


static gboolean _bool_equal (const gboolean* s1, const gboolean* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


void player_controller_remove_from_menu (PlayerController* self) {
	gboolean* _tmp13_;
	gboolean _tmp14_;
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _item_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _item_size;
		gint _item_index;
		_tmp0_ = self->custom_items;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_item_list = _tmp1_;
		_tmp2_ = _item_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_item_size = _tmp4_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			PlayerItem* item;
			DbusmenuMenuitem* _tmp11_;
			PlayerItem* _tmp12_;
			_tmp5_ = _item_index;
			_item_index = _tmp5_ + 1;
			_tmp6_ = _item_index;
			_tmp7_ = _item_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _item_list;
			_tmp9_ = _item_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			item = (PlayerItem*) _tmp10_;
			_tmp11_ = self->root_menu;
			_tmp12_ = item;
			dbusmenu_menuitem_child_delete (_tmp11_, (DbusmenuMenuitem*) _tmp12_);
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_list);
	}
	_tmp13_ = self->use_playlists;
	_tmp14_ = TRUE;
	if (_bool_equal (_tmp13_, &_tmp14_) == TRUE) {
		GeeArrayList* _tmp15_;
		gpointer _tmp16_ = NULL;
		PlaylistsMenuitem* playlists_menuitem;
		DbusmenuMenuitem* _tmp17_;
		PlaylistsMenuitem* _tmp18_;
		DbusmenuMenuitem* _tmp19_;
		_tmp15_ = self->custom_items;
		_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_PLAYLISTS);
		playlists_menuitem = IS_PLAYLISTS_MENUITEM ((PlayerItem*) _tmp16_) ? ((PlaylistsMenuitem*) ((PlayerItem*) _tmp16_)) : NULL;
		_tmp17_ = self->root_menu;
		_tmp18_ = playlists_menuitem;
		_tmp19_ = _tmp18_->root_item;
		dbusmenu_menuitem_child_delete (_tmp17_, _tmp19_);
		_g_object_unref0 (playlists_menuitem);
	}
}


void player_controller_set_as_preferred (PlayerController* self, gboolean val) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = val;
	player_controller_set_is_preferred (self, _tmp0_);
	player_controller_update_layout (self);
}


void player_controller_hibernate (PlayerController* self) {
	GeeArrayList* _tmp0_;
	gpointer _tmp1_ = NULL;
	TransportMenuitem* transport;
	GeeArrayList* _tmp2_;
	gpointer _tmp3_ = NULL;
	PlayerItem* _tmp4_;
	GeeHashSet* _tmp5_ = NULL;
	GeeHashSet* _tmp6_;
	GeeArrayList* _tmp7_;
	gpointer _tmp8_ = NULL;
	MetadataMenuitem* md;
	g_return_if_fail (self != NULL);
	player_controller_update_state (self, PLAYER_CONTROLLER_STATE_OFFLINE);
	_tmp0_ = self->custom_items;
	_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT);
	transport = IS_TRANSPORT_MENUITEM ((PlayerItem*) _tmp1_) ? ((TransportMenuitem*) ((PlayerItem*) _tmp1_)) : NULL;
	transport_menuitem_change_play_state (transport, TRANSPORT_STATE_PAUSED);
	_tmp2_ = self->custom_items;
	_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _tmp2_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_METADATA);
	_tmp4_ = (PlayerItem*) _tmp3_;
	_tmp5_ = metadata_menuitem_relevant_attributes_for_ui ();
	_tmp6_ = _tmp5_;
	player_item_reset (_tmp4_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	_tmp7_ = self->custom_items;
	_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_METADATA);
	md = IS_METADATA_MENUITEM ((PlayerItem*) _tmp8_) ? ((MetadataMenuitem*) ((PlayerItem*) _tmp8_)) : NULL;
	metadata_menuitem_toggle_active_triangle (md, FALSE);
	_g_object_unref0 (self->mpris_bridge);
	self->mpris_bridge = NULL;
	_g_object_unref0 (md);
	_g_object_unref0 (transport);
}


void player_controller_update_layout (PlayerController* self) {
	GeeArrayList* _tmp0_;
	gpointer _tmp1_ = NULL;
	PlaylistsMenuitem* playlists_menuitem;
	GeeArrayList* _tmp2_;
	gpointer _tmp3_ = NULL;
	MetadataMenuitem* metadata_menuitem;
	gint _tmp4_;
	GeeArrayList* _tmp12_;
	gpointer _tmp13_ = NULL;
	PlayerItem* _tmp14_;
	GeeHashSet* _tmp15_ = NULL;
	GeeHashSet* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_;
	gboolean should_collapse;
	MetadataMenuitem* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	PlaylistsMenuitem* _tmp28_;
	DbusmenuMenuitem* _tmp29_;
	gboolean* _tmp30_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->custom_items;
	_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_PLAYLISTS);
	playlists_menuitem = IS_PLAYLISTS_MENUITEM ((PlayerItem*) _tmp1_) ? ((PlaylistsMenuitem*) ((PlayerItem*) _tmp1_)) : NULL;
	_tmp2_ = self->custom_items;
	_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _tmp2_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_METADATA);
	metadata_menuitem = IS_METADATA_MENUITEM ((PlayerItem*) _tmp3_) ? ((MetadataMenuitem*) ((PlayerItem*) _tmp3_)) : NULL;
	_tmp4_ = self->current_state;
	if (_tmp4_ != ((gint) PLAYER_CONTROLLER_STATE_CONNECTED)) {
		MetadataMenuitem* _tmp5_;
		PlaylistsMenuitem* _tmp6_;
		DbusmenuMenuitem* _tmp7_;
		GeeArrayList* _tmp8_;
		gpointer _tmp9_ = NULL;
		PlayerItem* _tmp10_;
		gboolean _tmp11_;
		_tmp5_ = metadata_menuitem;
		metadata_menuitem_should_collapse (_tmp5_, TRUE);
		_tmp6_ = playlists_menuitem;
		_tmp7_ = _tmp6_->root_item;
		dbusmenu_menuitem_property_set_bool (_tmp7_, DBUSMENU_MENUITEM_PROP_VISIBLE, FALSE);
		_tmp8_ = self->custom_items;
		_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT);
		_tmp10_ = (PlayerItem*) _tmp9_;
		_tmp11_ = self->priv->_is_preferred;
		dbusmenu_menuitem_property_set_bool ((DbusmenuMenuitem*) _tmp10_, DBUSMENU_MENUITEM_PROP_VISIBLE, _tmp11_);
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (metadata_menuitem);
		_g_object_unref0 (playlists_menuitem);
		return;
	}
	_tmp12_ = self->custom_items;
	_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_METADATA);
	_tmp14_ = (PlayerItem*) _tmp13_;
	_tmp15_ = metadata_menuitem_relevant_attributes_for_ui ();
	_tmp16_ = _tmp15_;
	_tmp17_ = player_item_populated (_tmp14_, _tmp16_);
	_tmp18_ = !_tmp17_;
	_g_object_unref0 (_tmp16_);
	_g_object_unref0 (_tmp14_);
	should_collapse = _tmp18_;
	_tmp19_ = metadata_menuitem;
	_tmp20_ = should_collapse;
	metadata_menuitem_should_collapse (_tmp19_, _tmp20_);
	_tmp21_ = self->priv->_is_preferred;
	if (_tmp21_) {
		GeeArrayList* _tmp22_;
		gpointer _tmp23_ = NULL;
		TransportMenuitem* transport;
		TransportMenuitem* _tmp24_;
		_tmp22_ = self->custom_items;
		_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT);
		transport = IS_TRANSPORT_MENUITEM ((PlayerItem*) _tmp23_) ? ((TransportMenuitem*) ((PlayerItem*) _tmp23_)) : NULL;
		_tmp24_ = transport;
		transport_menuitem_handle_cached_action (_tmp24_);
		_g_object_unref0 (transport);
	} else {
		GeeArrayList* _tmp25_;
		gpointer _tmp26_ = NULL;
		PlayerItem* _tmp27_;
		_tmp25_ = self->custom_items;
		_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT);
		_tmp27_ = (PlayerItem*) _tmp26_;
		dbusmenu_menuitem_property_set_bool ((DbusmenuMenuitem*) _tmp27_, DBUSMENU_MENUITEM_PROP_VISIBLE, TRUE);
		_g_object_unref0 (_tmp27_);
	}
	_tmp28_ = playlists_menuitem;
	_tmp29_ = _tmp28_->root_item;
	_tmp30_ = self->use_playlists;
	dbusmenu_menuitem_property_set_bool (_tmp29_, DBUSMENU_MENUITEM_PROP_VISIBLE, *_tmp30_);
	_g_object_unref0 (metadata_menuitem);
	_g_object_unref0 (playlists_menuitem);
}


static void player_controller_construct_widgets (PlayerController* self) {
	GeeArrayList* _tmp0_;
	PlayerItem* _tmp1_;
	PlayerItem* _tmp2_;
	MetadataMenuitem* _tmp3_;
	MetadataMenuitem* metadata_item;
	GeeArrayList* _tmp4_;
	MetadataMenuitem* _tmp5_;
	TransportMenuitem* _tmp6_;
	TransportMenuitem* transport_item;
	GeeArrayList* _tmp7_;
	TransportMenuitem* _tmp8_;
	PlaylistsMenuitem* _tmp9_;
	PlaylistsMenuitem* playlist_menuitem;
	GeeArrayList* _tmp10_;
	PlaylistsMenuitem* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->custom_items;
	_tmp1_ = player_item_new (DBUSMENU_CLIENT_TYPES_SEPARATOR);
	_tmp2_ = _tmp1_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = metadata_menuitem_new (self);
	metadata_item = _tmp3_;
	_tmp4_ = self->custom_items;
	_tmp5_ = metadata_item;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, (PlayerItem*) _tmp5_);
	_tmp6_ = transport_menuitem_new (self);
	transport_item = _tmp6_;
	_tmp7_ = self->custom_items;
	_tmp8_ = transport_item;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, (PlayerItem*) _tmp8_);
	_tmp9_ = playlists_menuitem_new (self);
	playlist_menuitem = _tmp9_;
	_tmp10_ = self->custom_items;
	_tmp11_ = playlist_menuitem;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, (PlayerItem*) _tmp11_);
	{
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
		GeeArrayList* _item_list;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _item_size;
		gint _item_index;
		_tmp12_ = self->custom_items;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_item_list = _tmp13_;
		_tmp14_ = _item_list;
		_tmp15_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_item_size = _tmp16_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			GeeArrayList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_ = NULL;
			PlayerItem* item;
			GeeArrayList* _tmp23_;
			PlayerItem* _tmp24_;
			gint _tmp25_ = 0;
			_tmp17_ = _item_index;
			_item_index = _tmp17_ + 1;
			_tmp18_ = _item_index;
			_tmp19_ = _item_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _item_list;
			_tmp21_ = _item_index;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _tmp21_);
			item = (PlayerItem*) _tmp22_;
			_tmp23_ = self->custom_items;
			_tmp24_ = item;
			_tmp25_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp23_, _tmp24_);
			if (_tmp25_ == (PLAYER_CONTROLLER_WIDGET_QUANTITY - 1)) {
				PlayerItem* _tmp26_;
				PlaylistsMenuitem* _tmp27_;
				PlaylistsMenuitem* playlists_menuitem;
				DbusmenuMenuitem* _tmp28_;
				PlaylistsMenuitem* _tmp29_;
				DbusmenuMenuitem* _tmp30_;
				gint _tmp31_;
				GeeArrayList* _tmp32_;
				PlayerItem* _tmp33_;
				gint _tmp34_ = 0;
				_tmp26_ = item;
				_tmp27_ = _g_object_ref0 (IS_PLAYLISTS_MENUITEM (_tmp26_) ? ((PlaylistsMenuitem*) _tmp26_) : NULL);
				playlists_menuitem = _tmp27_;
				_tmp28_ = self->root_menu;
				_tmp29_ = playlists_menuitem;
				_tmp30_ = _tmp29_->root_item;
				_tmp31_ = self->priv->_menu_offset;
				_tmp32_ = self->custom_items;
				_tmp33_ = item;
				_tmp34_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp32_, _tmp33_);
				dbusmenu_menuitem_child_add_position (_tmp28_, _tmp30_, (guint) (_tmp31_ + _tmp34_));
				_g_object_unref0 (playlists_menuitem);
			} else {
				DbusmenuMenuitem* _tmp35_;
				PlayerItem* _tmp36_;
				gint _tmp37_;
				GeeArrayList* _tmp38_;
				PlayerItem* _tmp39_;
				gint _tmp40_ = 0;
				_tmp35_ = self->root_menu;
				_tmp36_ = item;
				_tmp37_ = self->priv->_menu_offset;
				_tmp38_ = self->custom_items;
				_tmp39_ = item;
				_tmp40_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp38_, _tmp39_);
				dbusmenu_menuitem_child_add_position (_tmp35_, (DbusmenuMenuitem*) _tmp36_, (guint) (_tmp37_ + _tmp40_));
			}
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_list);
	}
	_g_object_unref0 (playlist_menuitem);
	_g_object_unref0 (transport_item);
	_g_object_unref0 (metadata_item);
}


static void player_controller_determine_state (PlayerController* self) {
	Mpris2Controller* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->mpris_bridge;
	_tmp1_ = mpris2_controller_connected (_tmp0_);
	if (_tmp1_ == TRUE) {
		GeeArrayList* _tmp2_;
		gpointer _tmp3_ = NULL;
		MetadataMenuitem* md;
		MetadataMenuitem* _tmp4_;
		Mpris2Controller* _tmp5_;
		player_controller_update_state (self, PLAYER_CONTROLLER_STATE_CONNECTED);
		_tmp2_ = self->custom_items;
		_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _tmp2_, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_METADATA);
		md = IS_METADATA_MENUITEM ((PlayerItem*) _tmp3_) ? ((MetadataMenuitem*) ((PlayerItem*) _tmp3_)) : NULL;
		_tmp4_ = md;
		metadata_menuitem_toggle_active_triangle (_tmp4_, TRUE);
		_tmp5_ = self->mpris_bridge;
		mpris2_controller_initial_update (_tmp5_);
		_g_object_unref0 (md);
	} else {
		player_controller_update_state (self, PLAYER_CONTROLLER_STATE_DISCONNECTED);
	}
}


const gchar* player_controller_get_dbus_name (PlayerController* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dbus_name;
	result = _tmp0_;
	return result;
}


void player_controller_set_dbus_name (PlayerController* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_dbus_name);
	self->priv->_dbus_name = _tmp1_;
	g_object_notify ((GObject *) self, "dbus-name");
}


GAppInfo* player_controller_get_app_info (PlayerController* self) {
	GAppInfo* result;
	GAppInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_info;
	result = _tmp0_;
	return result;
}


void player_controller_set_app_info (PlayerController* self, GAppInfo* value) {
	GAppInfo* _tmp0_;
	GAppInfo* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_app_info);
	self->priv->_app_info = _tmp1_;
	g_object_notify ((GObject *) self, "app-info");
}


gint player_controller_get_menu_offset (PlayerController* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_menu_offset;
	result = _tmp0_;
	return result;
}


void player_controller_set_menu_offset (PlayerController* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_menu_offset = _tmp0_;
	g_object_notify ((GObject *) self, "menu-offset");
}


const gchar* player_controller_get_icon_name (PlayerController* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}


void player_controller_set_icon_name (PlayerController* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_icon_name);
	self->priv->_icon_name = _tmp1_;
	g_object_notify ((GObject *) self, "icon-name");
}


gboolean player_controller_get_is_preferred (PlayerController* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_preferred;
	result = _tmp0_;
	return result;
}


static void player_controller_set_is_preferred (PlayerController* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_preferred = _tmp0_;
	g_object_notify ((GObject *) self, "is-preferred");
}


static void player_controller_class_init (PlayerControllerClass * klass) {
	player_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PlayerControllerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_player_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_player_controller_set_property;
	G_OBJECT_CLASS (klass)->finalize = player_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLAYER_CONTROLLER_DBUS_NAME, g_param_spec_string ("dbus-name", "dbus-name", "dbus-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLAYER_CONTROLLER_APP_INFO, g_param_spec_object ("app-info", "app-info", "app-info", g_app_info_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLAYER_CONTROLLER_MENU_OFFSET, g_param_spec_int ("menu-offset", "menu-offset", "menu-offset", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLAYER_CONTROLLER_ICON_NAME, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLAYER_CONTROLLER_IS_PREFERRED, g_param_spec_boolean ("is-preferred", "is-preferred", "is-preferred", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void player_controller_instance_init (PlayerController * self) {
	self->priv = PLAYER_CONTROLLER_GET_PRIVATE (self);
	self->current_state = (gint) PLAYER_CONTROLLER_STATE_OFFLINE;
}


static void player_controller_finalize (GObject* obj) {
	PlayerController * self;
	self = PLAYER_CONTROLLER (obj);
	_g_object_unref0 (self->root_menu);
	_g_free0 (self->priv->_dbus_name);
	_g_object_unref0 (self->custom_items);
	_g_object_unref0 (self->mpris_bridge);
	_g_object_unref0 (self->priv->_app_info);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->use_playlists);
	_g_object_unref0 (self->priv->track_specific_mgr);
	_g_object_unref0 (self->priv->player_specific_mgr);
	G_OBJECT_CLASS (player_controller_parent_class)->finalize (obj);
}


GType player_controller_get_type (void) {
	static volatile gsize player_controller_type_id__volatile = 0;
	if (g_once_init_enter (&player_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PlayerControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) player_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlayerController), 0, (GInstanceInitFunc) player_controller_instance_init, NULL };
		GType player_controller_type_id;
		player_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "PlayerController", &g_define_type_info, 0);
		g_once_init_leave (&player_controller_type_id__volatile, player_controller_type_id);
	}
	return player_controller_type_id__volatile;
}


static void _vala_player_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PlayerController * self;
	self = PLAYER_CONTROLLER (object);
	switch (property_id) {
		case PLAYER_CONTROLLER_DBUS_NAME:
		g_value_set_string (value, player_controller_get_dbus_name (self));
		break;
		case PLAYER_CONTROLLER_APP_INFO:
		g_value_set_object (value, player_controller_get_app_info (self));
		break;
		case PLAYER_CONTROLLER_MENU_OFFSET:
		g_value_set_int (value, player_controller_get_menu_offset (self));
		break;
		case PLAYER_CONTROLLER_ICON_NAME:
		g_value_set_string (value, player_controller_get_icon_name (self));
		break;
		case PLAYER_CONTROLLER_IS_PREFERRED:
		g_value_set_boolean (value, player_controller_get_is_preferred (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_player_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PlayerController * self;
	self = PLAYER_CONTROLLER (object);
	switch (property_id) {
		case PLAYER_CONTROLLER_DBUS_NAME:
		player_controller_set_dbus_name (self, g_value_get_string (value));
		break;
		case PLAYER_CONTROLLER_APP_INFO:
		player_controller_set_app_info (self, g_value_get_object (value));
		break;
		case PLAYER_CONTROLLER_MENU_OFFSET:
		player_controller_set_menu_offset (self, g_value_get_int (value));
		break;
		case PLAYER_CONTROLLER_ICON_NAME:
		player_controller_set_icon_name (self, g_value_get_string (value));
		break;
		case PLAYER_CONTROLLER_IS_PREFERRED:
		player_controller_set_is_preferred (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



