/* mpris2-controller.c generated by valac 0.12.0, the Vala compiler
 * generated from mpris2-controller.vala, do not modify */

/*
Copyright 2010 Canonical Ltd.

Authors:
    Conor Curran <conor.curran@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <common-defs.h>
#include <gee.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/dbusmenu-glib.h>
#include <libdbusmenu-glib/enum-types.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>
#include <libdbusmenu-glib/types.h>


#define TYPE_MPRIS2_CONTROLLER (mpris2_controller_get_type ())
#define MPRIS2_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS2_CONTROLLER, Mpris2Controller))
#define MPRIS2_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MPRIS2_CONTROLLER, Mpris2ControllerClass))
#define IS_MPRIS2_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS2_CONTROLLER))
#define IS_MPRIS2_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MPRIS2_CONTROLLER))
#define MPRIS2_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MPRIS2_CONTROLLER, Mpris2ControllerClass))

typedef struct _Mpris2Controller Mpris2Controller;
typedef struct _Mpris2ControllerClass Mpris2ControllerClass;
typedef struct _Mpris2ControllerPrivate Mpris2ControllerPrivate;

#define TYPE_MPRIS_ROOT (mpris_root_get_type ())
#define MPRIS_ROOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS_ROOT, MprisRoot))
#define IS_MPRIS_ROOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS_ROOT))
#define MPRIS_ROOT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MPRIS_ROOT, MprisRootIface))

typedef struct _MprisRoot MprisRoot;
typedef struct _MprisRootIface MprisRootIface;

#define TYPE_MPRIS_ROOT_PROXY (mpris_root_proxy_get_type ())

#define TYPE_MPRIS_PLAYER (mpris_player_get_type ())
#define MPRIS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS_PLAYER, MprisPlayer))
#define IS_MPRIS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS_PLAYER))
#define MPRIS_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MPRIS_PLAYER, MprisPlayerIface))

typedef struct _MprisPlayer MprisPlayer;
typedef struct _MprisPlayerIface MprisPlayerIface;

#define TYPE_MPRIS_PLAYER_PROXY (mpris_player_proxy_get_type ())

#define TYPE_MPRIS_PLAYLISTS (mpris_playlists_get_type ())
#define MPRIS_PLAYLISTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS_PLAYLISTS, MprisPlaylists))
#define IS_MPRIS_PLAYLISTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS_PLAYLISTS))
#define MPRIS_PLAYLISTS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MPRIS_PLAYLISTS, MprisPlaylistsIface))

typedef struct _MprisPlaylists MprisPlaylists;
typedef struct _MprisPlaylistsIface MprisPlaylistsIface;

#define TYPE_MPRIS_PLAYLISTS_PROXY (mpris_playlists_proxy_get_type ())

#define TYPE_PLAYLIST_DETAILS (playlist_details_get_type ())
typedef struct _PlaylistDetails PlaylistDetails;

#define TYPE_ACTIVE_PLAYLIST_CONTAINER (active_playlist_container_get_type ())
typedef struct _ActivePlaylistContainer ActivePlaylistContainer;

#define TYPE_FREE_DESKTOP_PROPERTIES (free_desktop_properties_get_type ())
#define FREE_DESKTOP_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FREE_DESKTOP_PROPERTIES, FreeDesktopProperties))
#define IS_FREE_DESKTOP_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FREE_DESKTOP_PROPERTIES))
#define FREE_DESKTOP_PROPERTIES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FREE_DESKTOP_PROPERTIES, FreeDesktopPropertiesIface))

typedef struct _FreeDesktopProperties FreeDesktopProperties;
typedef struct _FreeDesktopPropertiesIface FreeDesktopPropertiesIface;

#define TYPE_FREE_DESKTOP_PROPERTIES_PROXY (free_desktop_properties_proxy_get_type ())

#define TYPE_PLAYER_CONTROLLER (player_controller_get_type ())
#define PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_CONTROLLER, PlayerController))
#define PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_CONTROLLER, PlayerControllerClass))
#define IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_CONTROLLER))
#define IS_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_CONTROLLER))
#define PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_CONTROLLER, PlayerControllerClass))

typedef struct _PlayerController PlayerController;
typedef struct _PlayerControllerClass PlayerControllerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _PlayerControllerPrivate PlayerControllerPrivate;

#define TYPE_PLAYER_ITEM (player_item_get_type ())
#define PLAYER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_ITEM, PlayerItem))
#define PLAYER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_ITEM, PlayerItemClass))
#define IS_PLAYER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_ITEM))
#define IS_PLAYER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_ITEM))
#define PLAYER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_ITEM, PlayerItemClass))

typedef struct _PlayerItem PlayerItem;
typedef struct _PlayerItemClass PlayerItemClass;

#define PLAYER_CONTROLLER_TYPE_WIDGET_ORDER (player_controller_widget_order_get_type ())

#define TYPE_TRANSPORT_MENUITEM (transport_menuitem_get_type ())
#define TRANSPORT_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSPORT_MENUITEM, TransportMenuitem))
#define TRANSPORT_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSPORT_MENUITEM, TransportMenuitemClass))
#define IS_TRANSPORT_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSPORT_MENUITEM))
#define IS_TRANSPORT_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSPORT_MENUITEM))
#define TRANSPORT_MENUITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSPORT_MENUITEM, TransportMenuitemClass))

typedef struct _TransportMenuitem TransportMenuitem;
typedef struct _TransportMenuitemClass TransportMenuitemClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_TITLE_MENUITEM (title_menuitem_get_type ())
#define TITLE_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TITLE_MENUITEM, TitleMenuitem))
#define TITLE_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TITLE_MENUITEM, TitleMenuitemClass))
#define IS_TITLE_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TITLE_MENUITEM))
#define IS_TITLE_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TITLE_MENUITEM))
#define TITLE_MENUITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TITLE_MENUITEM, TitleMenuitemClass))

typedef struct _TitleMenuitem TitleMenuitem;
typedef struct _TitleMenuitemClass TitleMenuitemClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_PLAYLISTS_MENUITEM (playlists_menuitem_get_type ())
#define PLAYLISTS_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYLISTS_MENUITEM, PlaylistsMenuitem))
#define PLAYLISTS_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYLISTS_MENUITEM, PlaylistsMenuitemClass))
#define IS_PLAYLISTS_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYLISTS_MENUITEM))
#define IS_PLAYLISTS_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYLISTS_MENUITEM))
#define PLAYLISTS_MENUITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYLISTS_MENUITEM, PlaylistsMenuitemClass))

typedef struct _PlaylistsMenuitem PlaylistsMenuitem;
typedef struct _PlaylistsMenuitemClass PlaylistsMenuitemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Mpris2ControllerFetchPlaylistsData Mpris2ControllerFetchPlaylistsData;

struct _Mpris2Controller {
	GObject parent_instance;
	Mpris2ControllerPrivate * priv;
};

struct _Mpris2ControllerClass {
	GObjectClass parent_class;
};

struct _MprisRootIface {
	GTypeInterface parent_iface;
	void (*Quit) (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Quit_finish) (MprisRoot* self, GAsyncResult* _res_, GError** error);
	void (*Raise) (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Raise_finish) (MprisRoot* self, GAsyncResult* _res_, GError** error);
	gboolean (*get_HasTracklist) (MprisRoot* self);
	void (*set_HasTracklist) (MprisRoot* self, gboolean value);
	gboolean (*get_CanQuit) (MprisRoot* self);
	void (*set_CanQuit) (MprisRoot* self, gboolean value);
	gboolean (*get_CanRaise) (MprisRoot* self);
	void (*set_CanRaise) (MprisRoot* self, gboolean value);
	gchar* (*get_Identity) (MprisRoot* self);
	void (*set_Identity) (MprisRoot* self, const gchar* value);
	gchar* (*get_DesktopEntry) (MprisRoot* self);
	void (*set_DesktopEntry) (MprisRoot* self, const gchar* value);
};

struct _MprisPlayerIface {
	GTypeInterface parent_iface;
	void (*PlayPause) (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*PlayPause_finish) (MprisPlayer* self, GAsyncResult* _res_, GError** error);
	void (*Next) (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Next_finish) (MprisPlayer* self, GAsyncResult* _res_, GError** error);
	void (*Previous) (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Previous_finish) (MprisPlayer* self, GAsyncResult* _res_, GError** error);
	void (*Seek) (MprisPlayer* self, gint64 offset, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Seek_finish) (MprisPlayer* self, GAsyncResult* _res_, GError** error);
	GHashTable* (*get_Metadata) (MprisPlayer* self);
	void (*set_Metadata) (MprisPlayer* self, GHashTable* value);
	gint32 (*get_Position) (MprisPlayer* self);
	void (*set_Position) (MprisPlayer* self, gint32 value);
	gchar* (*get_PlaybackStatus) (MprisPlayer* self);
	void (*set_PlaybackStatus) (MprisPlayer* self, const gchar* value);
};

struct _PlaylistDetails {
	char* path;
	gchar* name;
	gchar* icon_path;
};

struct _ActivePlaylistContainer {
	gboolean valid;
	PlaylistDetails details;
};

struct _MprisPlaylistsIface {
	GTypeInterface parent_iface;
	void (*ActivatePlaylist) (MprisPlaylists* self, const char* playlist_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*ActivatePlaylist_finish) (MprisPlaylists* self, GAsyncResult* _res_, GError** error);
	void (*GetPlaylists) (MprisPlaylists* self, guint32 index, guint32 max_count, const gchar* order, gboolean reverse_order, GAsyncReadyCallback _callback_, gpointer _user_data_);
	PlaylistDetails* (*GetPlaylists_finish) (MprisPlaylists* self, GAsyncResult* _res_, int* result_length1, GError** error);
	gchar** (*get_Orderings) (MprisPlaylists* self, int* result_length1);
	void (*set_Orderings) (MprisPlaylists* self, gchar** value, int value_length1);
	guint32 (*get_PlaylistCount) (MprisPlaylists* self);
	void (*set_PlaylistCount) (MprisPlaylists* self, guint32 value);
	void (*get_ActivePlaylist) (MprisPlaylists* self, ActivePlaylistContainer* value);
	void (*set_ActivePlaylist) (MprisPlaylists* self, ActivePlaylistContainer* value);
};

struct _FreeDesktopPropertiesIface {
	GTypeInterface parent_iface;
};

struct _Mpris2ControllerPrivate {
	MprisRoot* _mpris2_root;
	MprisPlayer* _player;
	MprisPlaylists* _playlists;
	FreeDesktopProperties* _properties_interface;
	PlayerController* _owner;
};

struct _PlayerController {
	GObject parent_instance;
	PlayerControllerPrivate * priv;
	gint current_state;
	GeeArrayList* custom_items;
	Mpris2Controller* mpris_bridge;
	gboolean* use_playlists;
};

struct _PlayerControllerClass {
	GObjectClass parent_class;
};

typedef enum  {
	PLAYER_CONTROLLER_WIDGET_ORDER_SEPARATOR,
	PLAYER_CONTROLLER_WIDGET_ORDER_TITLE,
	PLAYER_CONTROLLER_WIDGET_ORDER_METADATA,
	PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT,
	PLAYER_CONTROLLER_WIDGET_ORDER_PLAYLISTS
} PlayerControllerwidget_order;

struct _Mpris2ControllerFetchPlaylistsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Mpris2Controller* self;
	PlaylistDetails* current_playlists;
	gint current_playlists_length1;
	gint _current_playlists_size_;
	gint _tmp0_;
	PlaylistDetails* _tmp1_;
	PlaylistDetails* _tmp2_;
	gint _tmp2__length1;
	gint __tmp2__size_;
	GError * e;
	gpointer _tmp3_;
	PlayerItem* _tmp4_;
	PlaylistsMenuitem* playlists_item;
	gboolean _tmp5_;
	gboolean* _tmp6_;
	GError * _inner_error_;
};


static gpointer mpris2_controller_parent_class = NULL;

GType mpris2_controller_get_type (void) G_GNUC_CONST;
GType mpris_root_proxy_get_type (void) G_GNUC_CONST;
guint mpris_root_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType mpris_root_get_type (void) G_GNUC_CONST;
GType mpris_player_proxy_get_type (void) G_GNUC_CONST;
guint mpris_player_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType mpris_player_get_type (void) G_GNUC_CONST;
GType mpris_playlists_proxy_get_type (void) G_GNUC_CONST;
guint mpris_playlists_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType playlist_details_get_type (void) G_GNUC_CONST;
PlaylistDetails* playlist_details_dup (const PlaylistDetails* self);
void playlist_details_free (PlaylistDetails* self);
void playlist_details_copy (const PlaylistDetails* self, PlaylistDetails* dest);
void playlist_details_destroy (PlaylistDetails* self);
GType active_playlist_container_get_type (void) G_GNUC_CONST;
ActivePlaylistContainer* active_playlist_container_dup (const ActivePlaylistContainer* self);
void active_playlist_container_free (ActivePlaylistContainer* self);
void active_playlist_container_copy (const ActivePlaylistContainer* self, ActivePlaylistContainer* dest);
void active_playlist_container_destroy (ActivePlaylistContainer* self);
GType mpris_playlists_get_type (void) G_GNUC_CONST;
GType free_desktop_properties_get_type (void) G_GNUC_CONST;
GType free_desktop_properties_proxy_get_type (void) G_GNUC_CONST;
guint free_desktop_properties_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType player_controller_get_type (void) G_GNUC_CONST;
#define MPRIS2_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MPRIS2_CONTROLLER, Mpris2ControllerPrivate))
enum  {
	MPRIS2_CONTROLLER_DUMMY_PROPERTY,
	MPRIS2_CONTROLLER_MPRIS2_ROOT,
	MPRIS2_CONTROLLER_PLAYER,
	MPRIS2_CONTROLLER_PLAYLISTS,
	MPRIS2_CONTROLLER_PROPERTIES_INTERFACE,
	MPRIS2_CONTROLLER_OWNER
};
Mpris2Controller* mpris2_controller_new (PlayerController* ctrl);
Mpris2Controller* mpris2_controller_construct (GType object_type, PlayerController* ctrl);
void mpris2_controller_property_changed_cb (Mpris2Controller* self, const gchar* interface_source, GHashTable* changed_properties, gchar** invalid, int invalid_length1);
#define MPRIS_PREFIX "org.mpris.MediaPlayer2."
MprisPlayer* mpris2_controller_get_player (Mpris2Controller* self);
gchar* mpris_player_get_PlaybackStatus (MprisPlayer* self);
static gboolean mpris2_controller_ensure_correct_playback_status (Mpris2Controller* self);
static gboolean _mpris2_controller_ensure_correct_playback_status_gsource_func (gpointer self);
static TransportState mpris2_controller_determine_play_state (Mpris2Controller* self, const gchar* status);
PlayerController* mpris2_controller_get_owner (Mpris2Controller* self);
GType player_item_get_type (void) G_GNUC_CONST;
GType player_controller_widget_order_get_type (void) G_GNUC_CONST;
GType transport_menuitem_get_type (void) G_GNUC_CONST;
void transport_menuitem_change_play_state (TransportMenuitem* self, TransportState update);
static GHashTable* mpris2_controller_clean_metadata (Mpris2Controller* self);
void player_item_reset (PlayerItem* self, GeeHashSet* attrs);
GeeHashSet* metadata_menuitem_attributes_format (void);
void player_item_update (PlayerItem* self, GHashTable* data, GeeHashSet* attributes);
gboolean player_item_populated (PlayerItem* self, GeeHashSet* attrs);
static gboolean _bool_equal (const gboolean* s1, const gboolean* s2);
static gboolean mpris2_controller_fetch_active_playlist (Mpris2Controller* self);
static gboolean _mpris2_controller_fetch_active_playlist_gsource_func (gpointer self);
void mpris2_controller_fetch_playlists (Mpris2Controller* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris2_controller_fetch_playlists_finish (Mpris2Controller* self, GAsyncResult* _res_);
GType title_menuitem_get_type (void) G_GNUC_CONST;
void title_menuitem_alter_label (TitleMenuitem* self, const gchar* new_title);
MprisRoot* mpris2_controller_get_mpris2_root (Mpris2Controller* self);
gchar* mpris_root_get_Identity (MprisRoot* self);
GHashTable* mpris_player_get_Metadata (MprisPlayer* self);
static GVariant* _variant_new1 (const gchar* value);
void mpris2_controller_initial_update (Mpris2Controller* self);
void mpris2_controller_transport_update (Mpris2Controller* self, TransportAction command);
void mpris_player_PlayPause (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_player_PlayPause_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error);
void mpris_player_Previous (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_player_Previous_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error);
void mpris_player_Next (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_player_Next_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error);
void mpris_player_Seek (MprisPlayer* self, gint64 offset, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_player_Seek_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error);
gboolean mpris2_controller_connected (Mpris2Controller* self);
void mpris2_controller_expose (Mpris2Controller* self);
void mpris_root_Raise (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_root_Raise_finish (MprisRoot* self, GAsyncResult* _res_, GError** error);
static void mpris2_controller_on_playlistdetails_changed (Mpris2Controller* self, PlaylistDetails* details);
GType playlists_menuitem_get_type (void) G_GNUC_CONST;
void playlists_menuitem_update_individual_playlist (PlaylistsMenuitem* self, PlaylistDetails* new_detail);
static void mpris2_controller_fetch_playlists_data_free (gpointer _data);
static gboolean mpris2_controller_fetch_playlists_co (Mpris2ControllerFetchPlaylistsData* data);
MprisPlaylists* mpris2_controller_get_playlists (Mpris2Controller* self);
void mpris_playlists_GetPlaylists (MprisPlaylists* self, guint32 index, guint32 max_count, const gchar* order, gboolean reverse_order, GAsyncReadyCallback _callback_, gpointer _user_data_);
PlaylistDetails* mpris_playlists_GetPlaylists_finish (MprisPlaylists* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void mpris2_controller_fetch_playlists_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_PlaylistDetails_array_free (PlaylistDetails* array, gint array_length);
void playlists_menuitem_update (PlaylistsMenuitem* self, PlaylistDetails* playlists, int playlists_length1);
static gboolean* _bool_dup (gboolean* self);
void mpris_playlists_get_ActivePlaylist (MprisPlaylists* self, ActivePlaylistContainer* result);
void playlists_menuitem_active_playlist_update (PlaylistsMenuitem* self, PlaylistDetails* detail);
void mpris2_controller_activate_playlist (Mpris2Controller* self, const char* path);
void mpris_playlists_ActivatePlaylist (MprisPlaylists* self, const char* playlist_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_playlists_ActivatePlaylist_finish (MprisPlaylists* self, GAsyncResult* _res_, GError** error);
static void mpris2_controller_set_mpris2_root (Mpris2Controller* self, MprisRoot* value);
static void mpris2_controller_set_player (Mpris2Controller* self, MprisPlayer* value);
static void mpris2_controller_set_playlists (Mpris2Controller* self, MprisPlaylists* value);
FreeDesktopProperties* mpris2_controller_get_properties_interface (Mpris2Controller* self);
static void mpris2_controller_set_properties_interface (Mpris2Controller* self, FreeDesktopProperties* value);
static void mpris2_controller_set_owner (Mpris2Controller* self, PlayerController* value);
static GObject * mpris2_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
const gchar* player_controller_get_dbus_name (PlayerController* self);
static void _mpris2_controller_property_changed_cb_free_desktop_properties_properties_changed (FreeDesktopProperties* _sender, const gchar* source, GHashTable* changed_properties, gchar** invalid, int invalid_length1, gpointer self);
static void _mpris2_controller_on_playlistdetails_changed_mpris_playlists_playlist_changed (MprisPlaylists* _sender, PlaylistDetails* details, gpointer self);
static void mpris2_controller_finalize (GObject* obj);
static void _vala_mpris2_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_mpris2_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


Mpris2Controller* mpris2_controller_construct (GType object_type, PlayerController* ctrl) {
	Mpris2Controller * self = NULL;
	g_return_val_if_fail (ctrl != NULL, NULL);
	self = (Mpris2Controller*) g_object_new (object_type, "owner", ctrl, NULL);
	return self;
}


Mpris2Controller* mpris2_controller_new (PlayerController* ctrl) {
	return mpris2_controller_construct (TYPE_MPRIS2_CONTROLLER, ctrl);
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static gboolean _mpris2_controller_ensure_correct_playback_status_gsource_func (gpointer self) {
	gboolean result;
	result = mpris2_controller_ensure_correct_playback_status (self);
	return result;
}


static gboolean _bool_equal (const gboolean* s1, const gboolean* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


static gboolean _mpris2_controller_fetch_active_playlist_gsource_func (gpointer self) {
	gboolean result;
	result = mpris2_controller_fetch_active_playlist (self);
	return result;
}


void mpris2_controller_property_changed_cb (Mpris2Controller* self, const gchar* interface_source, GHashTable* changed_properties, gchar** invalid, int invalid_length1) {
	gboolean _tmp0_ = FALSE;
	gconstpointer _tmp2_ = NULL;
	GVariant* _tmp3_;
	GVariant* play_v;
	gconstpointer _tmp9_ = NULL;
	GVariant* _tmp10_;
	GVariant* meta_v;
	gconstpointer _tmp20_ = NULL;
	GVariant* _tmp21_;
	GVariant* playlist_v;
	gboolean _tmp22_ = FALSE;
	gconstpointer _tmp24_ = NULL;
	GVariant* _tmp25_;
	GVariant* playlist_count_v;
	gboolean _tmp26_ = FALSE;
	gconstpointer _tmp28_ = NULL;
	GVariant* _tmp29_;
	GVariant* playlist_orderings_v;
	gboolean _tmp30_ = FALSE;
	gconstpointer _tmp32_ = NULL;
	GVariant* _tmp33_;
	GVariant* identity_v;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interface_source != NULL);
	g_return_if_fail (changed_properties != NULL);
	if (changed_properties == NULL) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_;
		_tmp1_ = g_str_has_prefix (interface_source, MPRIS_PREFIX);
		_tmp0_ = _tmp1_ == FALSE;
	}
	if (_tmp0_) {
		g_warning ("mpris2-controller.vala:71: Property-changed hash is null or this is an" \
" interface that doesn't concern us");
		return;
	}
	_tmp2_ = g_hash_table_lookup (changed_properties, "PlaybackStatus");
	_tmp3_ = _g_variant_ref0 ((GVariant*) _tmp2_);
	play_v = _tmp3_;
	if (play_v != NULL) {
		gchar* _tmp4_ = NULL;
		gchar* state;
		TransportState _tmp5_;
		TransportState p;
		gpointer _tmp6_ = NULL;
		PlayerItem* _tmp7_;
		TransportMenuitem* _tmp8_;
		_tmp4_ = mpris_player_get_PlaybackStatus (self->priv->_player);
		state = _tmp4_;
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _mpris2_controller_ensure_correct_playback_status_gsource_func, g_object_ref (self), g_object_unref);
		_tmp5_ = mpris2_controller_determine_play_state (self, state);
		p = (TransportState) _tmp5_;
		_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->_owner->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT);
		_tmp7_ = (PlayerItem*) _tmp6_;
		_tmp8_ = IS_TRANSPORT_MENUITEM (_tmp7_) ? ((TransportMenuitem*) _tmp7_) : NULL;
		transport_menuitem_change_play_state (_tmp8_, p);
		_g_object_unref0 (_tmp8_);
		_g_free0 (state);
	}
	_tmp9_ = g_hash_table_lookup (changed_properties, "Metadata");
	_tmp10_ = _g_variant_ref0 ((GVariant*) _tmp9_);
	meta_v = _tmp10_;
	if (meta_v != NULL) {
		GHashTable* _tmp11_ = NULL;
		GHashTable* changed_updates;
		gpointer _tmp12_ = NULL;
		PlayerItem* metadata;
		GeeHashSet* _tmp13_ = NULL;
		GeeHashSet* _tmp14_;
		GeeHashSet* _tmp15_ = NULL;
		GeeHashSet* _tmp16_;
		GeeHashSet* _tmp17_ = NULL;
		GeeHashSet* _tmp18_;
		gboolean _tmp19_;
		_tmp11_ = mpris2_controller_clean_metadata (self);
		changed_updates = _tmp11_;
		_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->_owner->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_METADATA);
		metadata = (PlayerItem*) _tmp12_;
		_tmp13_ = metadata_menuitem_attributes_format ();
		_tmp14_ = _tmp13_;
		player_item_reset (metadata, _tmp14_);
		_g_object_unref0 (_tmp14_);
		_tmp15_ = metadata_menuitem_attributes_format ();
		_tmp16_ = _tmp15_;
		player_item_update (metadata, changed_updates, _tmp16_);
		_g_object_unref0 (_tmp16_);
		_tmp17_ = metadata_menuitem_attributes_format ();
		_tmp18_ = _tmp17_;
		_tmp19_ = player_item_populated (metadata, _tmp18_);
		dbusmenu_menuitem_property_set_bool ((DbusmenuMenuitem*) metadata, DBUSMENU_MENUITEM_PROP_VISIBLE, _tmp19_);
		_g_object_unref0 (_tmp18_);
		_g_object_unref0 (metadata);
		_g_hash_table_unref0 (changed_updates);
	}
	_tmp20_ = g_hash_table_lookup (changed_properties, "ActivePlaylist");
	_tmp21_ = _g_variant_ref0 ((GVariant*) _tmp20_);
	playlist_v = _tmp21_;
	if (playlist_v != NULL) {
		gboolean _tmp23_;
		_tmp23_ = TRUE;
		_tmp22_ = _bool_equal (self->priv->_owner->use_playlists, &_tmp23_) == TRUE;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, _mpris2_controller_fetch_active_playlist_gsource_func, g_object_ref (self), g_object_unref);
	}
	_tmp24_ = g_hash_table_lookup (changed_properties, "PlaylistCount");
	_tmp25_ = _g_variant_ref0 ((GVariant*) _tmp24_);
	playlist_count_v = _tmp25_;
	if (playlist_count_v != NULL) {
		gboolean _tmp27_;
		_tmp27_ = TRUE;
		_tmp26_ = _bool_equal (self->priv->_owner->use_playlists, &_tmp27_) == TRUE;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		mpris2_controller_fetch_playlists (self, NULL, NULL);
		mpris2_controller_fetch_active_playlist (self);
	}
	_tmp28_ = g_hash_table_lookup (changed_properties, "Orderings");
	_tmp29_ = _g_variant_ref0 ((GVariant*) _tmp28_);
	playlist_orderings_v = _tmp29_;
	if (playlist_orderings_v != NULL) {
		gboolean _tmp31_;
		_tmp31_ = TRUE;
		_tmp30_ = _bool_equal (self->priv->_owner->use_playlists, &_tmp31_) == TRUE;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		mpris2_controller_fetch_playlists (self, NULL, NULL);
		mpris2_controller_fetch_active_playlist (self);
	}
	_tmp32_ = g_hash_table_lookup (changed_properties, "Identity");
	_tmp33_ = _g_variant_ref0 ((GVariant*) _tmp32_);
	identity_v = _tmp33_;
	if (identity_v != NULL) {
		gpointer _tmp34_ = NULL;
		PlayerItem* _tmp35_;
		TitleMenuitem* title;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_;
		_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->_owner->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TITLE);
		_tmp35_ = (PlayerItem*) _tmp34_;
		title = IS_TITLE_MENUITEM (_tmp35_) ? ((TitleMenuitem*) _tmp35_) : NULL;
		_tmp36_ = mpris_root_get_Identity (self->priv->_mpris2_root);
		_tmp37_ = _tmp36_;
		title_menuitem_alter_label (title, _tmp37_);
		_g_free0 (_tmp37_);
		_g_object_unref0 (title);
	}
	_g_variant_unref0 (identity_v);
	_g_variant_unref0 (playlist_orderings_v);
	_g_variant_unref0 (playlist_count_v);
	_g_variant_unref0 (playlist_v);
	_g_variant_unref0 (meta_v);
	_g_variant_unref0 (play_v);
}


static gboolean mpris2_controller_ensure_correct_playback_status (Mpris2Controller* self) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	TransportState _tmp2_;
	TransportState _tmp3_;
	TransportState p;
	gpointer _tmp4_ = NULL;
	PlayerItem* _tmp5_;
	TransportMenuitem* _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = mpris_player_get_PlaybackStatus (self->priv->_player);
	_tmp1_ = _tmp0_;
	_tmp2_ = mpris2_controller_determine_play_state (self, _tmp1_);
	_tmp3_ = (TransportState) _tmp2_;
	_g_free0 (_tmp1_);
	p = _tmp3_;
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->_owner->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT);
	_tmp5_ = (PlayerItem*) _tmp4_;
	_tmp6_ = IS_TRANSPORT_MENUITEM (_tmp5_) ? ((TransportMenuitem*) _tmp5_) : NULL;
	transport_menuitem_change_play_state (_tmp6_, p);
	_g_object_unref0 (_tmp6_);
	result = FALSE;
	return result;
}


static GVariant* _variant_new1 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GHashTable* mpris2_controller_clean_metadata (Mpris2Controller* self) {
	GHashTable* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* changed_updates;
	GHashTable* _tmp1_ = NULL;
	GHashTable* _tmp2_;
	gconstpointer _tmp3_ = NULL;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* artist_v;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = mpris_player_get_Metadata (self->priv->_player);
	changed_updates = _tmp0_;
	_tmp1_ = mpris_player_get_Metadata (self->priv->_player);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_hash_table_lookup (_tmp2_, "xesam:artist");
	_tmp4_ = _g_variant_ref0 ((GVariant*) _tmp3_);
	_tmp5_ = _tmp4_;
	_g_hash_table_unref0 (_tmp2_);
	artist_v = _tmp5_;
	if (artist_v != NULL) {
		GHashTable* _tmp6_ = NULL;
		GHashTable* _tmp7_;
		gconstpointer _tmp8_ = NULL;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		GVariant* v_artists;
		gchar* display_artists = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp17_;
		_tmp6_ = mpris_player_get_Metadata (self->priv->_player);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_hash_table_lookup (_tmp7_, "xesam:artist");
		_tmp9_ = _g_variant_ref0 ((GVariant*) _tmp8_);
		_tmp10_ = _tmp9_;
		_g_hash_table_unref0 (_tmp7_);
		v_artists = _tmp10_;
		_tmp11_ = g_variant_get_type_string (v_artists);
		if (g_strcmp0 (_tmp11_, "s") == 0) {
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			_tmp12_ = g_variant_get_string (v_artists, NULL);
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (display_artists);
			display_artists = _tmp13_;
		} else {
			size_t _tmp14_;
			gchar** _tmp15_ = NULL;
			gchar** artists;
			gint artists_length1;
			gint _artists_size_;
			gchar* _tmp16_ = NULL;
			_tmp15_ = g_variant_dup_strv (v_artists, &_tmp14_);
			artists = _tmp15_;
			artists_length1 = _tmp14_;
			_artists_size_ = _tmp14_;
			_tmp16_ = g_strjoinv (", ", artists);
			_g_free0 (display_artists);
			display_artists = _tmp16_;
			artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp17_ = g_strdup ("xesam:artist");
		g_hash_table_replace (changed_updates, _tmp17_, _variant_new1 (display_artists));
		_g_free0 (display_artists);
		_g_variant_unref0 (v_artists);
	}
	result = changed_updates;
	_g_variant_unref0 (artist_v);
	return result;
}


static TransportState mpris2_controller_determine_play_state (Mpris2Controller* self, const gchar* status) {
	TransportState result = 0;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	if (status != NULL) {
		_tmp0_ = g_strcmp0 (status, "Playing") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRANSPORT_STATE_PLAYING;
		return result;
	}
	result = TRANSPORT_STATE_PAUSED;
	return result;
}


void mpris2_controller_initial_update (Mpris2Controller* self) {
	TransportState update = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_;
	gpointer _tmp13_ = NULL;
	PlayerItem* _tmp14_;
	TransportMenuitem* _tmp15_;
	GHashTable* _tmp16_ = NULL;
	GHashTable* cleaned_metadata;
	gpointer _tmp17_ = NULL;
	PlayerItem* _tmp18_;
	GeeHashSet* _tmp19_ = NULL;
	GeeHashSet* _tmp20_;
	gboolean _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = mpris_player_get_PlaybackStatus (self->priv->_player);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		update = TRANSPORT_STATE_PAUSED;
	} else {
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		TransportState _tmp5_;
		_tmp3_ = mpris_player_get_PlaybackStatus (self->priv->_player);
		_tmp4_ = _tmp3_;
		_tmp5_ = mpris2_controller_determine_play_state (self, _tmp4_);
		update = _tmp5_;
		_g_free0 (_tmp4_);
	}
	_tmp6_ = mpris_root_get_Identity (self->priv->_mpris2_root);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_ != NULL;
	_g_free0 (_tmp7_);
	if (_tmp8_) {
		gpointer _tmp9_ = NULL;
		PlayerItem* _tmp10_;
		TitleMenuitem* title;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->_owner->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TITLE);
		_tmp10_ = (PlayerItem*) _tmp9_;
		title = IS_TITLE_MENUITEM (_tmp10_) ? ((TitleMenuitem*) _tmp10_) : NULL;
		_tmp11_ = mpris_root_get_Identity (self->priv->_mpris2_root);
		_tmp12_ = _tmp11_;
		title_menuitem_alter_label (title, _tmp12_);
		_g_free0 (_tmp12_);
		_g_object_unref0 (title);
	}
	_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->_owner->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_TRANSPORT);
	_tmp14_ = (PlayerItem*) _tmp13_;
	_tmp15_ = IS_TRANSPORT_MENUITEM (_tmp14_) ? ((TransportMenuitem*) _tmp14_) : NULL;
	transport_menuitem_change_play_state (_tmp15_, update);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = mpris2_controller_clean_metadata (self);
	cleaned_metadata = _tmp16_;
	_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->_owner->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_METADATA);
	_tmp18_ = (PlayerItem*) _tmp17_;
	_tmp19_ = metadata_menuitem_attributes_format ();
	_tmp20_ = _tmp19_;
	player_item_update (_tmp18_, cleaned_metadata, _tmp20_);
	_g_object_unref0 (_tmp20_);
	_g_object_unref0 (_tmp18_);
	_tmp21_ = TRUE;
	if (_bool_equal (self->priv->_owner->use_playlists, &_tmp21_) == TRUE) {
		mpris2_controller_fetch_playlists (self, NULL, NULL);
		mpris2_controller_fetch_active_playlist (self);
	}
	_g_hash_table_unref0 (cleaned_metadata);
}


void mpris2_controller_transport_update (Mpris2Controller* self, TransportAction command) {
	g_return_if_fail (self != NULL);
	if (command == TRANSPORT_ACTION_PLAY_PAUSE) {
		mpris_player_PlayPause (self->priv->_player, NULL, NULL);
	} else {
		if (command == TRANSPORT_ACTION_PREVIOUS) {
			mpris_player_Previous (self->priv->_player, NULL, NULL);
		} else {
			if (command == TRANSPORT_ACTION_NEXT) {
				mpris_player_Next (self->priv->_player, NULL, NULL);
			} else {
				if (command == TRANSPORT_ACTION_REWIND) {
					mpris_player_Seek (self->priv->_player, (gint64) (-500000), NULL, NULL);
				} else {
					if (command == TRANSPORT_ACTION_FORWIND) {
						mpris_player_Seek (self->priv->_player, (gint64) 400000, NULL, NULL);
					}
				}
			}
		}
	}
}


gboolean mpris2_controller_connected (Mpris2Controller* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_player != NULL) {
		_tmp0_ = self->priv->_mpris2_root != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


void mpris2_controller_expose (Mpris2Controller* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = mpris2_controller_connected (self);
	if (_tmp0_ == TRUE) {
		mpris_root_Raise (self->priv->_mpris2_root, NULL, NULL);
	}
}


static void mpris2_controller_on_playlistdetails_changed (Mpris2Controller* self, PlaylistDetails* details) {
	gpointer _tmp0_ = NULL;
	PlayerItem* _tmp1_;
	PlaylistsMenuitem* playlists_item;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->_owner->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_PLAYLISTS);
	_tmp1_ = (PlayerItem*) _tmp0_;
	playlists_item = IS_PLAYLISTS_MENUITEM (_tmp1_) ? ((PlaylistsMenuitem*) _tmp1_) : NULL;
	playlists_menuitem_update_individual_playlist (playlists_item, details);
	_g_object_unref0 (playlists_item);
}


static void mpris2_controller_fetch_playlists_data_free (gpointer _data) {
	Mpris2ControllerFetchPlaylistsData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (Mpris2ControllerFetchPlaylistsData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void mpris2_controller_fetch_playlists (Mpris2Controller* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Mpris2ControllerFetchPlaylistsData* _data_;
	_data_ = g_slice_new0 (Mpris2ControllerFetchPlaylistsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, mpris2_controller_fetch_playlists);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, mpris2_controller_fetch_playlists_data_free);
	_data_->self = _g_object_ref0 (self);
	mpris2_controller_fetch_playlists_co (_data_);
}


void mpris2_controller_fetch_playlists_finish (Mpris2Controller* self, GAsyncResult* _res_) {
	Mpris2ControllerFetchPlaylistsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void mpris2_controller_fetch_playlists_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	Mpris2ControllerFetchPlaylistsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	mpris2_controller_fetch_playlists_co (data);
}


static void _vala_PlaylistDetails_array_free (PlaylistDetails* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			playlist_details_destroy (&array[i]);
		}
	}
	g_free (array);
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


static gboolean mpris2_controller_fetch_playlists_co (Mpris2ControllerFetchPlaylistsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->current_playlists = NULL;
	data->current_playlists_length1 = 0;
	data->_current_playlists_size_ = 0;
	data->_state_ = 1;
	mpris_playlists_GetPlaylists (data->self->priv->_playlists, (guint32) 0, (guint32) 10, "Alphabetical", FALSE, mpris2_controller_fetch_playlists_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = mpris_playlists_GetPlaylists_finish (data->self->priv->_playlists, data->_res_, &data->_tmp0_, &data->_inner_error_);
	data->_tmp2_ = data->_tmp1_;
	data->_tmp2__length1 = data->_tmp0_;
	data->__tmp2__size_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			goto __catch11_g_io_error;
		}
		data->current_playlists = (_vala_PlaylistDetails_array_free (data->current_playlists, data->current_playlists_length1), NULL);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->current_playlists = (_vala_PlaylistDetails_array_free (data->current_playlists, data->current_playlists_length1), NULL);
	data->current_playlists = data->_tmp2_;
	data->current_playlists_length1 = data->_tmp2__length1;
	data->_current_playlists_size_ = data->_tmp2__length1;
	goto __finally11;
	__catch11_g_io_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		_g_error_free0 (data->e);
		data->current_playlists = (_vala_PlaylistDetails_array_free (data->current_playlists, data->current_playlists_length1), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally11:
	if (data->_inner_error_ != NULL) {
		data->current_playlists = (_vala_PlaylistDetails_array_free (data->current_playlists, data->current_playlists_length1), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->current_playlists != NULL) {
		data->_tmp3_ = NULL;
		data->_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) data->self->priv->_owner->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_PLAYLISTS);
		data->_tmp4_ = (PlayerItem*) data->_tmp3_;
		data->playlists_item = IS_PLAYLISTS_MENUITEM (data->_tmp4_) ? ((PlaylistsMenuitem*) data->_tmp4_) : NULL;
		playlists_menuitem_update (data->playlists_item, data->current_playlists, data->current_playlists_length1);
		_g_object_unref0 (data->playlists_item);
	} else {
		g_warning ("mpris2-controller.vala:240:  Playlists are on but its returning no cur" \
"rent_playlists");
		data->_tmp5_ = FALSE;
		data->_tmp6_ = __bool_dup0 (&data->_tmp5_);
		_g_free0 (data->self->priv->_owner->use_playlists);
		data->self->priv->_owner->use_playlists = data->_tmp6_;
	}
	data->current_playlists = (_vala_PlaylistDetails_array_free (data->current_playlists, data->current_playlists_length1), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean mpris2_controller_fetch_active_playlist (Mpris2Controller* self) {
	gboolean result = FALSE;
	ActivePlaylistContainer _tmp0_ = {0};
	ActivePlaylistContainer _tmp1_;
	gboolean _tmp2_;
	gpointer _tmp3_ = NULL;
	PlayerItem* _tmp4_;
	PlaylistsMenuitem* playlists_item;
	ActivePlaylistContainer _tmp5_ = {0};
	ActivePlaylistContainer _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	mpris_playlists_get_ActivePlaylist (self->priv->_playlists, &_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_.valid == FALSE;
	active_playlist_container_destroy (&_tmp1_);
	if (_tmp2_) {
	}
	_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->_owner->custom_items, (gint) PLAYER_CONTROLLER_WIDGET_ORDER_PLAYLISTS);
	_tmp4_ = (PlayerItem*) _tmp3_;
	playlists_item = IS_PLAYLISTS_MENUITEM (_tmp4_) ? ((PlaylistsMenuitem*) _tmp4_) : NULL;
	mpris_playlists_get_ActivePlaylist (self->priv->_playlists, &_tmp5_);
	_tmp6_ = _tmp5_;
	playlists_menuitem_active_playlist_update (playlists_item, &_tmp6_.details);
	active_playlist_container_destroy (&_tmp6_);
	result = FALSE;
	_g_object_unref0 (playlists_item);
	return result;
}


void mpris2_controller_activate_playlist (Mpris2Controller* self, const char* path) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	mpris_playlists_ActivatePlaylist (self->priv->_playlists, path, NULL, NULL);
	goto __finally12;
	__catch12_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


MprisRoot* mpris2_controller_get_mpris2_root (Mpris2Controller* self) {
	MprisRoot* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_mpris2_root;
	return result;
}


static void mpris2_controller_set_mpris2_root (Mpris2Controller* self, MprisRoot* value) {
	MprisRoot* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_mpris2_root);
	self->priv->_mpris2_root = _tmp0_;
	g_object_notify ((GObject *) self, "mpris2-root");
}


MprisPlayer* mpris2_controller_get_player (Mpris2Controller* self) {
	MprisPlayer* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_player;
	return result;
}


static void mpris2_controller_set_player (Mpris2Controller* self, MprisPlayer* value) {
	MprisPlayer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_player);
	self->priv->_player = _tmp0_;
	g_object_notify ((GObject *) self, "player");
}


MprisPlaylists* mpris2_controller_get_playlists (Mpris2Controller* self) {
	MprisPlaylists* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_playlists;
	return result;
}


static void mpris2_controller_set_playlists (Mpris2Controller* self, MprisPlaylists* value) {
	MprisPlaylists* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_playlists);
	self->priv->_playlists = _tmp0_;
	g_object_notify ((GObject *) self, "playlists");
}


FreeDesktopProperties* mpris2_controller_get_properties_interface (Mpris2Controller* self) {
	FreeDesktopProperties* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_properties_interface;
	return result;
}


static void mpris2_controller_set_properties_interface (Mpris2Controller* self, FreeDesktopProperties* value) {
	FreeDesktopProperties* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_properties_interface);
	self->priv->_properties_interface = _tmp0_;
	g_object_notify ((GObject *) self, "properties-interface");
}


PlayerController* mpris2_controller_get_owner (Mpris2Controller* self) {
	PlayerController* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_owner;
	return result;
}


static void mpris2_controller_set_owner (Mpris2Controller* self, PlayerController* value) {
	PlayerController* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_owner);
	self->priv->_owner = _tmp0_;
	g_object_notify ((GObject *) self, "owner");
}


static void _mpris2_controller_property_changed_cb_free_desktop_properties_properties_changed (FreeDesktopProperties* _sender, const gchar* source, GHashTable* changed_properties, gchar** invalid, int invalid_length1, gpointer self) {
	mpris2_controller_property_changed_cb (self, source, changed_properties, invalid, invalid_length1);
}


static void _mpris2_controller_on_playlistdetails_changed_mpris_playlists_playlist_changed (MprisPlaylists* _sender, PlaylistDetails* details, gpointer self) {
	mpris2_controller_on_playlistdetails_changed (self, details);
}


static GObject * mpris2_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Mpris2Controller * self;
	const gchar* _tmp0_ = NULL;
	MprisRoot* _tmp1_ = NULL;
	MprisRoot* _tmp2_;
	MprisRoot* _tmp3_;
	const gchar* _tmp4_ = NULL;
	MprisPlayer* _tmp5_ = NULL;
	MprisPlayer* _tmp6_;
	MprisPlayer* _tmp7_;
	FreeDesktopProperties* _tmp8_ = NULL;
	FreeDesktopProperties* _tmp9_;
	FreeDesktopProperties* _tmp10_;
	gboolean _tmp11_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (mpris2_controller_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MPRIS2_CONTROLLER (obj);
	_tmp0_ = player_controller_get_dbus_name (self->priv->_owner);
	_tmp1_ = g_initable_new (TYPE_MPRIS_ROOT_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", _tmp0_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/mpris/MediaPlayer2", "g-interface-name", "org.mpris.MediaPlayer2", NULL);
	_tmp2_ = (MprisRoot*) _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch13_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp3_ = _tmp2_;
	mpris2_controller_set_mpris2_root (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = player_controller_get_dbus_name (self->priv->_owner);
	_tmp5_ = g_initable_new (TYPE_MPRIS_PLAYER_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", _tmp4_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/mpris/MediaPlayer2", "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
	_tmp6_ = (MprisPlayer*) _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch13_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp7_ = _tmp6_;
	mpris2_controller_set_player (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = g_initable_new (TYPE_FREE_DESKTOP_PROPERTIES_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.freedesktop.Properties.PropertiesChanged", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/mpris/MediaPlayer2", "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
	_tmp9_ = (FreeDesktopProperties*) _tmp8_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch13_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp10_ = _tmp9_;
	mpris2_controller_set_properties_interface (self, _tmp10_);
	_g_object_unref0 (_tmp10_);
	g_signal_connect_object (self->priv->_properties_interface, "properties-changed", (GCallback) _mpris2_controller_property_changed_cb_free_desktop_properties_properties_changed, self, 0);
	_tmp11_ = TRUE;
	if (_bool_equal (self->priv->_owner->use_playlists, &_tmp11_) == TRUE) {
		const gchar* _tmp12_ = NULL;
		MprisPlaylists* _tmp13_ = NULL;
		MprisPlaylists* _tmp14_;
		MprisPlaylists* _tmp15_;
		_tmp12_ = player_controller_get_dbus_name (self->priv->_owner);
		_tmp13_ = g_initable_new (TYPE_MPRIS_PLAYLISTS_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", _tmp12_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/mpris/MediaPlayer2", "g-interface-name", "org.mpris.MediaPlayer2.Playlists", NULL);
		_tmp14_ = (MprisPlaylists*) _tmp13_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch13_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp15_ = _tmp14_;
		mpris2_controller_set_playlists (self, _tmp15_);
		_g_object_unref0 (_tmp15_);
		g_signal_connect_object (self->priv->_playlists, "playlist-changed", (GCallback) _mpris2_controller_on_playlistdetails_changed_mpris_playlists_playlist_changed, self, 0);
	}
	goto __finally13;
	__catch13_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("mpris2-controller.vala:60: Problems connecting to the session bus - %s", e->message);
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void mpris2_controller_class_init (Mpris2ControllerClass * klass) {
	mpris2_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (Mpris2ControllerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_mpris2_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mpris2_controller_set_property;
	G_OBJECT_CLASS (klass)->constructor = mpris2_controller_constructor;
	G_OBJECT_CLASS (klass)->finalize = mpris2_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MPRIS2_CONTROLLER_MPRIS2_ROOT, g_param_spec_object ("mpris2-root", "mpris2-root", "mpris2-root", TYPE_MPRIS_ROOT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MPRIS2_CONTROLLER_PLAYER, g_param_spec_object ("player", "player", "player", TYPE_MPRIS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MPRIS2_CONTROLLER_PLAYLISTS, g_param_spec_object ("playlists", "playlists", "playlists", TYPE_MPRIS_PLAYLISTS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MPRIS2_CONTROLLER_PROPERTIES_INTERFACE, g_param_spec_object ("properties-interface", "properties-interface", "properties-interface", TYPE_FREE_DESKTOP_PROPERTIES, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MPRIS2_CONTROLLER_OWNER, g_param_spec_object ("owner", "owner", "owner", TYPE_PLAYER_CONTROLLER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void mpris2_controller_instance_init (Mpris2Controller * self) {
	self->priv = MPRIS2_CONTROLLER_GET_PRIVATE (self);
}


static void mpris2_controller_finalize (GObject* obj) {
	Mpris2Controller * self;
	self = MPRIS2_CONTROLLER (obj);
	_g_object_unref0 (self->priv->_mpris2_root);
	_g_object_unref0 (self->priv->_player);
	_g_object_unref0 (self->priv->_playlists);
	_g_object_unref0 (self->priv->_properties_interface);
	_g_object_unref0 (self->priv->_owner);
	G_OBJECT_CLASS (mpris2_controller_parent_class)->finalize (obj);
}


GType mpris2_controller_get_type (void) {
	static volatile gsize mpris2_controller_type_id__volatile = 0;
	if (g_once_init_enter (&mpris2_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (Mpris2ControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mpris2_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Mpris2Controller), 0, (GInstanceInitFunc) mpris2_controller_instance_init, NULL };
		GType mpris2_controller_type_id;
		mpris2_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "Mpris2Controller", &g_define_type_info, 0);
		g_once_init_leave (&mpris2_controller_type_id__volatile, mpris2_controller_type_id);
	}
	return mpris2_controller_type_id__volatile;
}


static void _vala_mpris2_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Mpris2Controller * self;
	self = MPRIS2_CONTROLLER (object);
	switch (property_id) {
		case MPRIS2_CONTROLLER_MPRIS2_ROOT:
		g_value_set_object (value, mpris2_controller_get_mpris2_root (self));
		break;
		case MPRIS2_CONTROLLER_PLAYER:
		g_value_set_object (value, mpris2_controller_get_player (self));
		break;
		case MPRIS2_CONTROLLER_PLAYLISTS:
		g_value_set_object (value, mpris2_controller_get_playlists (self));
		break;
		case MPRIS2_CONTROLLER_PROPERTIES_INTERFACE:
		g_value_set_object (value, mpris2_controller_get_properties_interface (self));
		break;
		case MPRIS2_CONTROLLER_OWNER:
		g_value_set_object (value, mpris2_controller_get_owner (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_mpris2_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Mpris2Controller * self;
	self = MPRIS2_CONTROLLER (object);
	switch (property_id) {
		case MPRIS2_CONTROLLER_MPRIS2_ROOT:
		mpris2_controller_set_mpris2_root (self, g_value_get_object (value));
		break;
		case MPRIS2_CONTROLLER_PLAYER:
		mpris2_controller_set_player (self, g_value_get_object (value));
		break;
		case MPRIS2_CONTROLLER_PLAYLISTS:
		mpris2_controller_set_playlists (self, g_value_get_object (value));
		break;
		case MPRIS2_CONTROLLER_PROPERTIES_INTERFACE:
		mpris2_controller_set_properties_interface (self, g_value_get_object (value));
		break;
		case MPRIS2_CONTROLLER_OWNER:
		mpris2_controller_set_owner (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



