from gi.repository import Signon
import gobject
gobject.threads_init()

class Authentication:
  def __init__(self, account, logger):
    self.account = account
    self.logger = logger
    self._reply = None

  def login(self):
    auth = self.account["auth"]

    self.auth_session = Signon.AuthSession.new(auth["id"], auth["method"])
    self._authenticating = True
    self._loop = gobject.MainLoop()
    self.auth_session.process(auth["parameters"],
                              auth["mechanism"],
                              self._login_cb, None)
    if self._authenticating:
      self._loop.run()
    return self._reply

  def _login_cb(self, session, reply, error, user_data):
    logger = self.logger
    logger.debug("Login completed")
    self._authenticating = False
    if error:
      logger.error("Got authentication error: %s" % error.message)
    else:
      self._reply = reply
    self._loop.quit()

