// Copyright (C) 2000-2005, Luca Padovani <luca.padovani@cs.unibo.it>.
//
// This file is part of GtkMathView, a Gtk widget for MathML.
// 
// GtkMathView is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// GtkMathView is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GtkMathView; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// For details, see the GtkMathView World-Wide-Web page,
// http://helm.cs.unibo.it/mml-widget/, or send a mail to
// <lpadovan@cs.unibo.it>

#include "TFM.hh"

static TFM::Font font = {
"CMSSI",

  0xec,
  "TeX text",
  0x00900000,
  0x2ba19717,
  7,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x000366a0 },
  { 0x02, "space", 0x00057b40 },
  { 0x03, "space_stretch", 0x0002bda0 },
  { 0x04, "space_shrink", 0x0001d3c0 },
  { 0x05, "x_height", 0x00071c72 },
  { 0x06, "quad", 0x001071c0 },
  { 0x07, "extra_space", 0x0001d3c0 }
};


static TFM::Kerning C_0b_Kerning[] = {
  { 0x21, 0x00012459 },
  { 0x27, 0x00012459 },
  { 0x29, 0x00012459 },
  { 0x3f, 0x00012459 },
  { 0x5d, 0x00012459 }
};

static TFM::Kerning C_20_Kerning[] = {
  { 0x4c, 0xfffbbda4 },
  { 0x6c, 0xfffc12f9 }
};

static TFM::Kerning C_27_Kerning[] = {
  { 0x21, 0x0001d3c0 },
  { 0x3f, 0x0001d3c0 }
};

static TFM::Kerning C_41_Kerning[] = {
  { 0x43, 0xffff8b10 },
  { 0x47, 0xffff8b10 },
  { 0x4f, 0xffff8b10 },
  { 0x51, 0xffff8b10 },
  { 0x54, 0xfffea130 },
  { 0x55, 0xffff8b10 },
  { 0x56, 0xfffe2c40 },
  { 0x57, 0xfffe2c40 },
  { 0x59, 0xfffea130 },
  { 0x74, 0xffff8b10 }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x41, 0xffff8b10 },
  { 0x56, 0xffff8b10 },
  { 0x57, 0xffff8b10 },
  { 0x58, 0xffff8b10 },
  { 0x59, 0xffff8b10 }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x41, 0xfffea130 },
  { 0x43, 0xffff8b10 },
  { 0x47, 0xffff8b10 },
  { 0x4f, 0xffff8b10 },
  { 0x51, 0xffff8b10 },
  { 0x61, 0xffff8b10 },
  { 0x65, 0xffff8b10 },
  { 0x6f, 0xffff8b10 },
  { 0x72, 0xffff8b10 },
  { 0x75, 0xffff8b10 }
};

static TFM::Kerning C_49_Kerning[] = {
  { 0x49, 0x000074f0 }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x43, 0xffff8b10 },
  { 0x47, 0xffff8b10 },
  { 0x4f, 0xffff8b10 },
  { 0x51, 0xffff8b10 }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x54, 0xfffea130 },
  { 0x56, 0xfffe2c40 },
  { 0x57, 0xfffe2c40 },
  { 0x59, 0xfffea130 }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x41, 0xffff8b10 },
  { 0x56, 0xffff8b10 },
  { 0x57, 0xffff8b10 },
  { 0x58, 0xffff8b10 },
  { 0x59, 0xffff8b10 }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x2c, 0xfffea130 },
  { 0x2e, 0xfffea130 },
  { 0x41, 0xfffea130 },
  { 0x61, 0xffff8b10 },
  { 0x65, 0xffff8b10 },
  { 0x6f, 0xffff8b10 }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x41, 0xfffea130 },
  { 0x61, 0xfffea130 },
  { 0x65, 0xfffea130 },
  { 0x6f, 0xfffea130 },
  { 0x72, 0xfffea130 },
  { 0x75, 0xfffea130 },
  { 0x79, 0xfffea130 }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x41, 0xfffea130 },
  { 0x43, 0xffff8b10 },
  { 0x47, 0xffff8b10 },
  { 0x4f, 0xffff8b10 },
  { 0x51, 0xffff8b10 },
  { 0x61, 0xffff8b10 },
  { 0x65, 0xffff8b10 },
  { 0x6f, 0xffff8b10 },
  { 0x72, 0xffff8b10 },
  { 0x75, 0xffff8b10 }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x41, 0xfffea130 },
  { 0x43, 0xffff8b10 },
  { 0x47, 0xffff8b10 },
  { 0x4f, 0xffff8b10 },
  { 0x51, 0xffff8b10 },
  { 0x61, 0xffff8b10 },
  { 0x65, 0xffff8b10 },
  { 0x6f, 0xffff8b10 },
  { 0x72, 0xffff8b10 },
  { 0x75, 0xffff8b10 }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x43, 0xffff8b10 },
  { 0x47, 0xffff8b10 },
  { 0x4f, 0xffff8b10 },
  { 0x51, 0xffff8b10 }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x41, 0xfffea130 },
  { 0x61, 0xfffea130 },
  { 0x65, 0xfffea130 },
  { 0x6f, 0xfffea130 },
  { 0x72, 0xfffea130 },
  { 0x75, 0xfffea130 }
};

static TFM::Kerning C_61_Kerning[] = {
  { 0x72, 0xffff8b10 },
  { 0x77, 0xffff8b10 },
  { 0x79, 0xffff8b10 }
};

static TFM::Kerning C_62_Kerning[] = {
  { 0x63, 0x000074f0 },
  { 0x64, 0x000074f0 },
  { 0x65, 0x000074f0 },
  { 0x6f, 0x000074f0 },
  { 0x71, 0x000074f0 },
  { 0x72, 0xffff8b10 },
  { 0x77, 0xffff8b10 },
  { 0x78, 0xffff8b10 },
  { 0x79, 0xffff8b10 }
};

static TFM::Kerning C_66_Kerning[] = {
  { 0x21, 0x00012459 },
  { 0x27, 0x00012459 },
  { 0x29, 0x00012459 },
  { 0x3f, 0x00012459 },
  { 0x5d, 0x00012459 }
};

static TFM::Kerning C_67_Kerning[] = {
  { 0x6a, 0x000074f0 }
};

static TFM::Kerning C_6b_Kerning[] = {
  { 0x61, 0xffff8b10 },
  { 0x63, 0xffff8b10 },
  { 0x65, 0xffff8b10 },
  { 0x6f, 0xffff8b10 }
};

static TFM::Kerning C_6f_Kerning[] = {
  { 0x63, 0x000074f0 },
  { 0x64, 0x000074f0 },
  { 0x65, 0x000074f0 },
  { 0x6f, 0x000074f0 },
  { 0x71, 0x000074f0 },
  { 0x72, 0xffff8b10 },
  { 0x77, 0xffff8b10 },
  { 0x78, 0xffff8b10 },
  { 0x79, 0xffff8b10 }
};

static TFM::Kerning C_70_Kerning[] = {
  { 0x63, 0x000074f0 },
  { 0x64, 0x000074f0 },
  { 0x65, 0x000074f0 },
  { 0x6f, 0x000074f0 },
  { 0x71, 0x000074f0 },
  { 0x72, 0xffff8b10 },
  { 0x77, 0xffff8b10 },
  { 0x78, 0xffff8b10 },
  { 0x79, 0xffff8b10 }
};

static TFM::Kerning C_74_Kerning[] = {
  { 0x77, 0xffff8b10 },
  { 0x79, 0xffff8b10 }
};

static TFM::Kerning C_75_Kerning[] = {
  { 0x77, 0xffff8b10 }
};

static TFM::Kerning C_77_Kerning[] = {
  { 0x61, 0xffff8b10 },
  { 0x63, 0xffff8b10 },
  { 0x65, 0xffff8b10 },
  { 0x6f, 0xffff8b10 }
};

static TFM::Kerning C_79_Kerning[] = {
  { 0x2c, 0xfffea130 },
  { 0x2e, 0xfffea130 },
  { 0x61, 0xffff8b10 },
  { 0x65, 0xffff8b10 },
  { 0x6f, 0xffff8b10 }
};

static TFM::Ligature C_0b_Ligature[] = {
  { 0x69, 0x00, 0x0e },
  { 0x6c, 0x00, 0x0f }
};

static TFM::Ligature C_21_Ligature[] = {
  { 0x60, 0x00, 0x3c }
};

static TFM::Ligature C_27_Ligature[] = {
  { 0x27, 0x00, 0x22 }
};

static TFM::Ligature C_2d_Ligature[] = {
  { 0x2d, 0x00, 0x7b }
};

static TFM::Ligature C_3f_Ligature[] = {
  { 0x60, 0x00, 0x3e }
};

static TFM::Ligature C_60_Ligature[] = {
  { 0x60, 0x00, 0x5c }
};

static TFM::Ligature C_66_Ligature[] = {
  { 0x66, 0x00, 0x0b },
  { 0x69, 0x00, 0x0c },
  { 0x6c, 0x00, 0x0d }
};

static TFM::Ligature C_7b_Ligature[] = {
  { 0x2d, 0x00, 0x7c }
};


static TFM::Character character[] = {
  { 0x00, 0x0008f680, 0x000b1c72, 0x00000000, 0x00002944, 0, 0, 0, 0 },
  { 0x01, 0x000db420, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x000cca40, 0x000b1c72, 0x00000000, 0x00004c89, 0, 0, 0, 0 },
  { 0x03, 0x000a12f2, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x000af680, 0x000b1c72, 0x00000000, 0x0000e7ab, 0, 0, 0, 0 },
  { 0x05, 0x000ba12b, 0x000b1c72, 0x00000000, 0x00008244, 0, 0, 0, 0 },
  { 0x06, 0x000be060, 0x000b1c72, 0x00000000, 0x0000d207, 0, 0, 0, 0 },
  { 0x07, 0x000cca40, 0x000b1c72, 0x00000000, 0x00003e60, 0, 0, 0, 0 },
  { 0x08, 0x000be060, 0x000b1c72, 0x00000000, 0x0000b95c, 0, 0, 0, 0 },
  { 0x09, 0x000cca40, 0x000b1c72, 0x00000000, 0x00003e60, 0, 0, 0, 0 },
  { 0x0a, 0x000be060, 0x000b1c72, 0x00000000, 0x0000a557, 0, 0, 0, 0 },
  { 0x0b, 0x000997b0, 0x000b1c72, 0x00000000, 0x000064b9, 5, C_0b_Kerning, 2, C_0b_Ligature },
  { 0x0c, 0x0008d094, 0x000b1c72, 0x00000000, 0x00007ce7, 0, 0, 0, 0 },
  { 0x0d, 0x0008d094, 0x000b1c72, 0x00000000, 0x0000764e, 0, 0, 0, 0 },
  { 0x0e, 0x000d61f4, 0x000b1c72, 0x00000000, 0x00007ce7, 0, 0, 0, 0 },
  { 0x0f, 0x000d61f4, 0x000b1c72, 0x00000000, 0x0000764e, 0, 0, 0, 0 },
  { 0x10, 0x0003ed07, 0x00071c72, 0x00000000, 0x0000ac09, 0, 0, 0, 0 },
  { 0x11, 0x000461f7, 0x00071c72, 0x00031c72, 0x0000ac09, 0, 0, 0, 0 },
  { 0x12, 0x000838e0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x000838e0, 0x000b1c72, 0x00000000, 0x000049f5, 0, 0, 0, 0 },
  { 0x14, 0x000838e0, 0x000a1c72, 0x00000000, 0x0000ac09, 0, 0, 0, 0 },
  { 0x15, 0x000838e0, 0x000b1c72, 0x00000000, 0x000064b9, 0, 0, 0, 0 },
  { 0x16, 0x000838e0, 0x0009ceb2, 0x00000000, 0x00002944, 0, 0, 0, 0 },
  { 0x17, 0x000c1f07, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x00074f00, 0x00000000, 0x0002b8e4, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x0007e6b4, 0x000b1c72, 0x00000000, 0x000049f5, 0, 0, 0, 0 },
  { 0x1a, 0x000be060, 0x00071c72, 0x00000000, 0x00003e60, 0, 0, 0, 0 },
  { 0x1b, 0x000cca40, 0x00071c72, 0x00000000, 0x00003e60, 0, 0, 0, 0 },
  { 0x1c, 0x000838e0, 0x0008aaab, 0x00018e39, 0x0000c30c, 0, 0, 0, 0 },
  { 0x1d, 0x000e2c39, 0x000b1c72, 0x00000000, 0x0000d207, 0, 0, 0, 0 },
  { 0x1e, 0x000ffff9, 0x000b1c72, 0x00000000, 0x0000d207, 0, 0, 0, 0 },
  { 0x1f, 0x000cca40, 0x000be38e, 0x0000c71c, 0x00004c89, 0, 0, 0, 0 },
  { 0x20, 0x0003ed07, 0x00071c72, 0x00000000, 0x00000000, 2, C_20_Kerning, 0, 0 },
  { 0x21, 0x000535b9, 0x000b1c72, 0x00000000, 0x0000e7ab, 0, 0, 1, C_21_Ligature },
  { 0x22, 0x000838e0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x23, 0x000db420, 0x000b1c72, 0x00031c72, 0x0000d207, 0, 0, 0, 0 },
  { 0x24, 0x000838e0, 0x000c0000, 0x0000e38e, 0x0000ac09, 0, 0, 0, 0 },
  { 0x25, 0x000db420, 0x000c0000, 0x0000e38e, 0x00007ce7, 0, 0, 0, 0 },
  { 0x26, 0x000c7814, 0x000b1c72, 0x00000000, 0x0000764e, 0, 0, 0, 0 },
  { 0x27, 0x00049160, 0x000b1c72, 0x00000000, 0x0000602e, 2, C_27_Kerning, 1, C_27_Ligature },
  { 0x28, 0x00066520, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x29, 0x00066520, 0x000c0000, 0x00040000, 0x000064b9, 0, 0, 0, 0 },
  { 0x2a, 0x000838e0, 0x000c0000, 0x00000000, 0x0000b95c, 0, 0, 0, 0 },
  { 0x2b, 0x000cca40, 0x00097b40, 0x00017b40, 0x000064b9, 0, 0, 0, 0 },
  { 0x2c, 0x00049160, 0x000161f9, 0x00020652, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x00057b40, 0x00071c72, 0x00000000, 0x00004c89, 0, 0, 1, C_2d_Ligature },
  { 0x2e, 0x00049160, 0x000161f9, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x000838e0, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x30, 0x000838e0, 0x000a7819, 0x00000000, 0x0000ac09, 0, 0, 0, 0 },
  { 0x31, 0x000838e0, 0x000a7819, 0x00000000, 0x0000ac09, 0, 0, 0, 0 },
  { 0x32, 0x000838e0, 0x000a7819, 0x00000000, 0x0000ac09, 0, 0, 0, 0 },
  { 0x33, 0x000838e0, 0x000a7819, 0x00000000, 0x0000ac09, 0, 0, 0, 0 },
  { 0x34, 0x000838e0, 0x000a7819, 0x00000000, 0x0000ac09, 0, 0, 0, 0 },
  { 0x35, 0x000838e0, 0x000a7819, 0x00000000, 0x0000ac09, 0, 0, 0, 0 },
  { 0x36, 0x000838e0, 0x000a7819, 0x00000000, 0x0000ac09, 0, 0, 0, 0 },
  { 0x37, 0x000838e0, 0x000a7819, 0x00000000, 0x0000ac09, 0, 0, 0, 0 },
  { 0x38, 0x000838e0, 0x000a7819, 0x00000000, 0x0000ac09, 0, 0, 0, 0 },
  { 0x39, 0x000838e0, 0x000a7819, 0x00000000, 0x0000ac09, 0, 0, 0, 0 },
  { 0x3a, 0x00049160, 0x00071c72, 0x00000000, 0x0000602e, 0, 0, 0, 0 },
  { 0x3b, 0x00049160, 0x00071c72, 0x00020652, 0x0000602e, 0, 0, 0, 0 },
  { 0x3c, 0x000535b9, 0x00080000, 0x00031c72, 0x00003e60, 0, 0, 0, 0 },
  { 0x3d, 0x000cca40, 0x00060247, 0xfffe0247, 0x0000d207, 0, 0, 0, 0 },
  { 0x3e, 0x0007c3f0, 0x00080000, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x0007c3f0, 0x000b1c72, 0x00000000, 0x0000c30c, 0, 0, 1, C_3f_Ligature },
  { 0x40, 0x000af680, 0x000b1c72, 0x00000000, 0x00004c89, 0, 0, 0, 0 },
  { 0x41, 0x000afcd2, 0x000b1c72, 0x00000000, 0x00000000, 10, C_41_Kerning, 0, 0 },
  { 0x42, 0x000af9a9, 0x000b1c72, 0x00000000, 0x0000a557, 0, 0, 0, 0 },
  { 0x43, 0x000a8190, 0x000b1c72, 0x00000000, 0x0000d207, 0, 0, 0, 0 },
  { 0x44, 0x000be389, 0x000b1c72, 0x00000000, 0x00004c89, 5, C_44_Kerning, 0, 0 },
  { 0x45, 0x0009e060, 0x000b1c72, 0x00000000, 0x0000d207, 0, 0, 0, 0 },
  { 0x46, 0x00096b70, 0x000b1c72, 0x00000000, 0x00002944, 10, C_46_Kerning, 0, 0 },
  { 0x47, 0x000af680, 0x000b1c72, 0x00000000, 0x0000d207, 0, 0, 0, 0 },
  { 0x48, 0x000ba12b, 0x000b1c72, 0x00000000, 0x00008244, 0, 0, 0, 0 },
  { 0x49, 0x000497b2, 0x000b1c72, 0x00000000, 0x00002944, 1, C_49_Kerning, 0, 0 },
  { 0x4a, 0x0007c719, 0x000b1c72, 0x00000000, 0x00008244, 0, 0, 0, 0 },
  { 0x4b, 0x000b71c2, 0x000b1c72, 0x00000000, 0x0000d207, 4, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x0008f680, 0x000b1c72, 0x00000000, 0x00000000, 4, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x000e5ecb, 0x000b1c72, 0x00000000, 0x00008244, 0, 0, 0, 0 },
  { 0x4e, 0x000ba12b, 0x000b1c72, 0x00000000, 0x00008244, 0, 0, 0, 0 },
  { 0x4f, 0x000c25e7, 0x000b1c72, 0x00000000, 0x00004c89, 5, C_4f_Kerning, 0, 0 },
  { 0x50, 0x000a84b9, 0x000b1c72, 0x00000000, 0x0000a557, 6, C_50_Kerning, 0, 0 },
  { 0x51, 0x000c25e7, 0x000b1c72, 0x00020652, 0x00004c89, 0, 0, 0, 0 },
  { 0x52, 0x000aa77c, 0x000b1c72, 0x00000000, 0x0000a557, 0, 0, 0, 0 },
  { 0x53, 0x000922c0, 0x000b1c72, 0x00000000, 0x000049f5, 0, 0, 0, 0 },
  { 0x54, 0x000b3c07, 0x000b1c72, 0x00000000, 0x00002944, 7, C_54_Kerning, 0, 0 },
  { 0x55, 0x000b4efe, 0x000b1c72, 0x00000000, 0x00008244, 0, 0, 0, 0 },
  { 0x56, 0x000afcd2, 0x000b1c72, 0x00000000, 0x00004c89, 10, C_56_Kerning, 0, 0 },
  { 0x57, 0x000f8e32, 0x000b1c72, 0x00000000, 0x00004c89, 10, C_57_Kerning, 0, 0 },
  { 0x58, 0x000afcd2, 0x000b1c72, 0x00000000, 0x00002944, 4, C_58_Kerning, 0, 0 },
  { 0x59, 0x000afcd2, 0x000b1c72, 0x00000000, 0x0000602e, 6, C_59_Kerning, 0, 0 },
  { 0x5a, 0x000a0ca0, 0x000b1c72, 0x00000000, 0x0000d207, 0, 0, 0, 0 },
  { 0x5b, 0x0004c71b, 0x000c0000, 0x00040000, 0x000049f5, 0, 0, 0, 0 },
  { 0x5c, 0x000838e0, 0x000b1c72, 0x00000000, 0x00003e60, 0, 0, 0, 0 },
  { 0x5d, 0x0004c71b, 0x000c0000, 0x00040000, 0x0000c30c, 0, 0, 0, 0 },
  { 0x5e, 0x000838e0, 0x000b1c72, 0x00000000, 0x0000764e, 0, 0, 0, 0 },
  { 0x5f, 0x00049160, 0x000aec97, 0x00000000, 0x00007ce7, 0, 0, 0, 0 },
  { 0x60, 0x00049160, 0x000b1c72, 0x00000000, 0x0000602e, 0, 0, 1, C_60_Ligature },
  { 0x61, 0x0007e6b4, 0x00071c72, 0x00000000, 0x00002944, 3, C_61_Kerning, 0, 0 },
  { 0x62, 0x00087e67, 0x000b1c72, 0x00000000, 0x00008244, 9, C_62_Kerning, 0, 0 },
  { 0x63, 0x00074f00, 0x00071c72, 0x00000000, 0x0000b95c, 0, 0, 0, 0 },
  { 0x64, 0x00087e67, 0x000b1c72, 0x00000000, 0x0000764e, 0, 0, 0, 0 },
  { 0x65, 0x00074f02, 0x00071c72, 0x00000000, 0x00003e60, 0, 0, 0, 0 },
  { 0x66, 0x00050650, 0x000b1c72, 0x00000000, 0x000064b9, 5, C_66_Kerning, 3, C_66_Ligature },
  { 0x67, 0x000838e0, 0x00071c72, 0x00031c72, 0x0000a557, 1, C_67_Kerning, 0, 0 },
  { 0x68, 0x00087e67, 0x000b1c72, 0x00000000, 0x000049f5, 0, 0, 0, 0 },
  { 0x69, 0x0003ed07, 0x000aec97, 0x00000000, 0x00008244, 0, 0, 0, 0 },
  { 0x6a, 0x000461f7, 0x000aec97, 0x00031c72, 0x0000602e, 0, 0, 0, 0 },
  { 0x6b, 0x00080977, 0x000b1c72, 0x00000000, 0x0000b95c, 4, C_6b_Kerning, 0, 0 },
  { 0x6c, 0x0003ed07, 0x000b1c72, 0x00000000, 0x0000764e, 0, 0, 0, 0 },
  { 0x6d, 0x000d0fc7, 0x00071c72, 0x00000000, 0x000049f5, 0, 0, 0, 0 },
  { 0x6e, 0x00087e67, 0x00071c72, 0x00000000, 0x000049f5, 0, 0, 0, 0 },
  { 0x6f, 0x000838e0, 0x00071c72, 0x00000000, 0x00002944, 9, C_6f_Kerning, 0, 0 },
  { 0x70, 0x00087e67, 0x00071c72, 0x00031c72, 0x0000a557, 9, C_70_Kerning, 0, 0 },
  { 0x71, 0x00087e67, 0x00071c72, 0x00031c72, 0x0000ac09, 0, 0, 0, 0 },
  { 0x72, 0x00059e04, 0x00071c72, 0x00000000, 0x0000a557, 0, 0, 0, 0 },
  { 0x73, 0x00064dbe, 0x00071c72, 0x00000000, 0x000064b9, 0, 0, 0, 0 },
  { 0x74, 0x0005f030, 0x00092495, 0x00000000, 0x000049f5, 2, C_74_Kerning, 0, 0 },
  { 0x75, 0x00087e67, 0x00071c72, 0x00000000, 0x0000ac09, 1, C_75_Kerning, 0, 0 },
  { 0x76, 0x00079487, 0x00071c72, 0x00000000, 0x0000a557, 0, 0, 0, 0 },
  { 0x77, 0x000b3c07, 0x00071c72, 0x00000000, 0x0000a557, 4, C_77_Kerning, 0, 0 },
  { 0x78, 0x00079487, 0x00071c72, 0x00000000, 0x00004c89, 0, 0, 0, 0 },
  { 0x79, 0x00079487, 0x00071c72, 0x00031c72, 0x0000a557, 5, C_79_Kerning, 0, 0 },
  { 0x7a, 0x000725e9, 0x00071c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7b, 0x000838e0, 0x00071c72, 0x00000000, 0x0000d207, 0, 0, 1, C_7b_Ligature },
  { 0x7c, 0x001071c0, 0x00071c72, 0x00000000, 0x0000d207, 0, 0, 0, 0 },
  { 0x7d, 0x000838e0, 0x000b1c72, 0x00000000, 0x000049f5, 0, 0, 0, 0 },
  { 0x7e, 0x000838e0, 0x000ad9a0, 0x00000000, 0x0000e7ab, 0, 0, 0, 0 },
  { 0x7f, 0x000838e0, 0x000aec97, 0x00000000, 0x00000000, 0, 0, 0, 0 }
};

void
cmssi9_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
