// Copyright (C) 2000-2005, Luca Padovani <luca.padovani@cs.unibo.it>.
//
// This file is part of GtkMathView, a Gtk widget for MathML.
// 
// GtkMathView is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// GtkMathView is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GtkMathView; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// For details, see the GtkMathView World-Wide-Web page,
// http://helm.cs.unibo.it/mml-widget/, or send a mail to
// <lpadovan@cs.unibo.it>

#include "TFM.hh"

static TFM::Font font = {
"CMMI",

  0xea,
  "TeX math italic",
  0x00a00000,
  0x0ba0623e,
  7,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00040000 },
  { 0x02, "space", 0x00000000 },
  { 0x03, "space_stretch", 0x00000000 },
  { 0x04, "space_shrink", 0x00000000 },
  { 0x05, "x_height", 0x0006e38e },
  { 0x06, "quad", 0x00100003 },
  { 0x07, "extra_space", 0x00000000 }
};


static TFM::Kerning C_00_Kerning[] = {
  { 0x3a, 0xfffe38e3 },
  { 0x3b, 0xfffe38e3 },
  { 0x3d, 0xffff1c72 },
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_01_Kerning[] = {
  { 0x7f, 0x0002aab0 }
};

static TFM::Kerning C_02_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_03_Kerning[] = {
  { 0x7f, 0x0002aab0 }
};

static TFM::Kerning C_04_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_05_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 },
  { 0x3d, 0xffff1c72 },
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_06_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_07_Kerning[] = {
  { 0x3a, 0xfffe38e3 },
  { 0x3b, 0xfffe38e3 },
  { 0x3d, 0xffff1c72 },
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_08_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_09_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 },
  { 0x3d, 0xffff1c72 },
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_0a_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_0b_Kerning[] = {
  { 0x7f, 0x000071c8 }
};

static TFM::Kerning C_0c_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_0e_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 },
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_0f_Kerning[] = {
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_10_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_11_Kerning[] = {
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_12_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_13_Kerning[] = {
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_16_Kerning[] = {
  { 0x7f, 0x000071c8 }
};

static TFM::Kerning C_17_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 },
  { 0x7f, 0x000071c8 }
};

static TFM::Kerning C_18_Kerning[] = {
  { 0x7f, 0x0001c720 }
};

static TFM::Kerning C_1a_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_1b_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 }
};

static TFM::Kerning C_1c_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 },
  { 0x7f, 0x000071c8 }
};

static TFM::Kerning C_1d_Kerning[] = {
  { 0x7f, 0x000071c8 }
};

static TFM::Kerning C_1e_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_1f_Kerning[] = {
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_20_Kerning[] = {
  { 0x7f, 0x0001c720 }
};

static TFM::Kerning C_22_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_23_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_25_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_26_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_27_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_3d_Kerning[] = {
  { 0x01, 0xffff1c72 },
  { 0x41, 0xffff1c72 },
  { 0x4d, 0xffff1c72 },
  { 0x4e, 0xffff1c72 },
  { 0x59, 0x0000e38e },
  { 0x5a, 0xffff1c72 }
};

static TFM::Kerning C_40_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_41_Kerning[] = {
  { 0x7f, 0x000238e8 }
};

static TFM::Kerning C_42_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_43_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 },
  { 0x3d, 0xffff8e38 },
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_45_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x3a, 0xfffe38e3 },
  { 0x3b, 0xfffe38e3 },
  { 0x3d, 0xffff1c72 },
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_47_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_48_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 },
  { 0x3d, 0xffff1c72 },
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_49_Kerning[] = {
  { 0x7f, 0x0001c720 }
};

static TFM::Kerning C_4a_Kerning[] = {
  { 0x3a, 0xfffe38e3 },
  { 0x3b, 0xfffe38e3 },
  { 0x3d, 0xffff1c72 },
  { 0x7f, 0x0002aab0 }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 },
  { 0x3d, 0xffff1c72 },
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x7f, 0x000071c8 }
};

static TFM::Kerning C_4d_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 },
  { 0x3d, 0xffff1c72 },
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_4e_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 },
  { 0x3d, 0xfffeaaaa },
  { 0x3d, 0xffff8e38 },
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x3a, 0xfffe38e3 },
  { 0x3b, 0xfffe38e3 },
  { 0x3d, 0xffff1c72 },
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_51_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_52_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_53_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 },
  { 0x3d, 0xffff1c72 },
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 },
  { 0x3d, 0xffff8e38 },
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_55_Kerning[] = {
  { 0x3a, 0xfffe38e3 },
  { 0x3b, 0xfffe38e3 },
  { 0x3d, 0xffff1c72 },
  { 0x7f, 0x000071c8 }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x3a, 0xfffd5555 },
  { 0x3b, 0xfffd5555 },
  { 0x3d, 0xfffe38e3 }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x3a, 0xfffd5555 },
  { 0x3b, 0xfffd5555 },
  { 0x3d, 0xfffe38e3 }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 },
  { 0x3d, 0xfffeaaaa },
  { 0x3d, 0xffff8e38 },
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x3a, 0xfffd5555 },
  { 0x3b, 0xfffd5555 },
  { 0x3d, 0xfffe38e3 }
};

static TFM::Kerning C_5a_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 },
  { 0x3d, 0xffff1c72 },
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_60_Kerning[] = {
  { 0x7f, 0x0001c720 }
};

static TFM::Kerning C_63_Kerning[] = {
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_64_Kerning[] = {
  { 0x59, 0x0000e38e },
  { 0x5a, 0xffff1c72 },
  { 0x66, 0xfffd5555 },
  { 0x6a, 0xfffe38e3 },
  { 0x7f, 0x0002aab0 }
};

static TFM::Kerning C_65_Kerning[] = {
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_66_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 },
  { 0x7f, 0x0002aab0 }
};

static TFM::Kerning C_67_Kerning[] = {
  { 0x7f, 0x000071c8 }
};

static TFM::Kerning C_68_Kerning[] = {
  { 0x7f, 0xffff8e38 }
};

static TFM::Kerning C_6a_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 }
};

static TFM::Kerning C_6c_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_6f_Kerning[] = {
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_70_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_71_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_72_Kerning[] = {
  { 0x3a, 0xffff1c72 },
  { 0x3b, 0xffff1c72 },
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_73_Kerning[] = {
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_74_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_75_Kerning[] = {
  { 0x7f, 0x000071c8 }
};

static TFM::Kerning C_76_Kerning[] = {
  { 0x7f, 0x000071c8 }
};

static TFM::Kerning C_77_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_78_Kerning[] = {
  { 0x7f, 0x000071c8 }
};

static TFM::Kerning C_79_Kerning[] = {
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_7a_Kerning[] = {
  { 0x7f, 0x0000e390 }
};

static TFM::Kerning C_7b_Kerning[] = {
  { 0x7f, 0x000071c8 }
};

static TFM::Kerning C_7c_Kerning[] = {
  { 0x7f, 0x00015558 }
};

static TFM::Kerning C_7d_Kerning[] = {
  { 0x7f, 0x0001c720 }
};


static TFM::Character character[] = {
  { 0x00, 0x0009d82e, 0x000aeeee, 0x00000000, 0x0000d82e, 4, C_00_Kerning, 0, 0 },
  { 0x01, 0x000d5558, 0x000aeeee, 0x00000000, 0x00000000, 1, C_01_Kerning, 0, 0 },
  { 0x02, 0x000c3455, 0x000aeeee, 0x00000000, 0x000071c8, 1, C_02_Kerning, 0, 0 },
  { 0x03, 0x000b1c73, 0x000aeeee, 0x00000000, 0x00000000, 1, C_03_Kerning, 0, 0 },
  { 0x04, 0x000be0b8, 0x000aeeee, 0x00000000, 0x0000509a, 1, C_04_Kerning, 0, 0 },
  { 0x05, 0x000d4cce, 0x000aeeee, 0x00000000, 0x000080f2, 4, C_05_Kerning, 0, 0 },
  { 0x06, 0x000c7a52, 0x000aeeee, 0x00000000, 0x0000ec16, 1, C_06_Kerning, 0, 0 },
  { 0x07, 0x00095555, 0x000aeeee, 0x00000000, 0x0000d82e, 4, C_07_Kerning, 0, 0 },
  { 0x08, 0x000aaaab, 0x000aeeee, 0x00000000, 0x00000000, 1, C_08_Kerning, 0, 0 },
  { 0x09, 0x0009cbaa, 0x000aeeee, 0x00000000, 0x0000bc72, 4, C_09_Kerning, 0, 0 },
  { 0x0a, 0x000c5bbe, 0x000aeeee, 0x00000000, 0x0000cd82, 1, C_0a_Kerning, 0, 0 },
  { 0x0b, 0x000a3c38, 0x0006e38e, 0x00000000, 0x00000f2a, 1, C_0b_Kerning, 0, 0 },
  { 0x0c, 0x00090cce, 0x000b1c72, 0x00031c72, 0x0000d82e, 1, C_0c_Kerning, 0, 0 },
  { 0x0d, 0x000848a0, 0x0006e38e, 0x00031c72, 0x0000e38e, 0, 0, 0, 0 },
  { 0x0e, 0x00071c72, 0x000b1c72, 0x00000000, 0x00009b05, 3, C_0e_Kerning, 0, 0 },
  { 0x0f, 0x00067e95, 0x0006e38e, 0x00000000, 0x00000000, 1, C_0f_Kerning, 0, 0 },
  { 0x10, 0x00070002, 0x000b1c72, 0x00031c72, 0x00001fa5, 1, C_10_Kerning, 0, 0 },
  { 0x11, 0x0007f1cb, 0x0006e38e, 0x00031c72, 0x000092f6, 1, C_11_Kerning, 0, 0 },
  { 0x12, 0x000782d8, 0x000b1c72, 0x00000000, 0x000071c8, 1, C_12_Kerning, 0, 0 },
  { 0x13, 0x0005a9ba, 0x0006e38e, 0x00000000, 0x00000000, 1, C_13_Kerning, 0, 0 },
  { 0x14, 0x000937f3, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x15, 0x00095558, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x0009a40b, 0x0006e38e, 0x00031c72, 0x00000000, 1, C_16_Kerning, 0, 0 },
  { 0x17, 0x0007e75b, 0x0006e38e, 0x00000000, 0x00000000, 3, C_17_Kerning, 0, 0 },
  { 0x18, 0x00070002, 0x000b1c72, 0x00031c72, 0x0000bc72, 1, C_18_Kerning, 0, 0 },
  { 0x19, 0x00091ed5, 0x0006e38e, 0x00000000, 0x000092f6, 0, 0, 0, 0 },
  { 0x1a, 0x000845b2, 0x0006e38e, 0x00031c72, 0x00000000, 1, C_1a_Kerning, 0, 0 },
  { 0x1b, 0x00092483, 0x0006e38e, 0x00000000, 0x000092f6, 2, C_1b_Kerning, 0, 0 },
  { 0x1c, 0x0006fe96, 0x0006e38e, 0x00000000, 0x0000cd82, 3, C_1c_Kerning, 0, 0 },
  { 0x1d, 0x0008a4fd, 0x0006e38e, 0x00000000, 0x000092f6, 1, C_1d_Kerning, 0, 0 },
  { 0x1e, 0x0009888a, 0x000b1c72, 0x00031c72, 0x00000000, 1, C_1e_Kerning, 0, 0 },
  { 0x1f, 0x000a02d6, 0x0006e38e, 0x00031c72, 0x00000000, 1, C_1f_Kerning, 0, 0 },
  { 0x20, 0x000a6c1a, 0x000b1c72, 0x00031c72, 0x000092f6, 1, C_20_Kerning, 0, 0 },
  { 0x21, 0x0009f593, 0x0006e38e, 0x00000000, 0x000092f6, 0, 0, 0, 0 },
  { 0x22, 0x0007760a, 0x0006e38e, 0x00000000, 0x00000000, 1, C_22_Kerning, 0, 0 },
  { 0x23, 0x0009768a, 0x000b1c72, 0x00000000, 0x00000000, 1, C_23_Kerning, 0, 0 },
  { 0x24, 0x000d4005, 0x0006e38e, 0x00000000, 0x000071c8, 0, 0, 0, 0 },
  { 0x25, 0x000845b2, 0x0006e38e, 0x00031c72, 0x00000000, 1, C_25_Kerning, 0, 0 },
  { 0x26, 0x0005ce3a, 0x0006e38e, 0x00018e3a, 0x000071c8, 1, C_26_Kerning, 0, 0 },
  { 0x27, 0x000a7778, 0x0006e38e, 0x00031c72, 0x00000000, 1, C_27_Kerning, 0, 0 },
  { 0x28, 0x00100003, 0x0005deb8, 0xfffddeb8, 0x00000000, 0, 0, 0, 0 },
  { 0x29, 0x00100003, 0x0005deb8, 0xfffddeb8, 0x00000000, 0, 0, 0, 0 },
  { 0x2a, 0x00100003, 0x0005deb8, 0xfffddeb8, 0x00000000, 0, 0, 0, 0 },
  { 0x2b, 0x00100003, 0x0005deb8, 0xfffddeb8, 0x00000000, 0, 0, 0, 0 },
  { 0x2c, 0x000471c8, 0x00076b83, 0xffff6b83, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x000471c8, 0x00076b83, 0xffff6b83, 0x00000000, 0, 0, 0, 0 },
  { 0x2e, 0x00080002, 0x000771c8, 0xffff71c8, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x00080002, 0x000771c8, 0xffff71c8, 0x00000000, 0, 0, 0, 0 },
  { 0x30, 0x00080002, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x31, 0x00080002, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x32, 0x00080002, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x33, 0x00080002, 0x0006e38e, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x34, 0x00080002, 0x0006e38e, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x35, 0x00080002, 0x0006e38e, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x36, 0x00080002, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x37, 0x00080002, 0x0006e38e, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x38, 0x00080002, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x39, 0x00080002, 0x0006e38e, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x3a, 0x000471c8, 0x0001b05b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3b, 0x000471c8, 0x0001b05b, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x3c, 0x000c71ca, 0x0008a025, 0x0000a025, 0x00000000, 0, 0, 0, 0 },
  { 0x3d, 0x00080002, 0x000c0000, 0x00040000, 0x00000000, 6, C_3d_Kerning, 0, 0 },
  { 0x3e, 0x000c71ca, 0x0008a025, 0x0000a025, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x00080002, 0x000771c8, 0xffff71c8, 0x00000000, 0, 0, 0, 0 },
  { 0x40, 0x00087e95, 0x000b1c72, 0x00000000, 0x0000e38e, 1, C_40_Kerning, 0, 0 },
  { 0x41, 0x000c0002, 0x000aeeee, 0x00000000, 0x00000000, 1, C_41_Kerning, 0, 0 },
  { 0x42, 0x000c22db, 0x000aeeee, 0x00000000, 0x0000cd82, 1, C_42_Kerning, 0, 0 },
  { 0x43, 0x000b6f80, 0x000aeeee, 0x00000000, 0x00000f2a, 4, C_43_Kerning, 0, 0 },
  { 0x44, 0x000d3f26, 0x000aeeee, 0x00000000, 0x000071c8, 1, C_44_Kerning, 0, 0 },
  { 0x45, 0x000bcfa6, 0x000aeeee, 0x00000000, 0x0000ec16, 1, C_45_Kerning, 0, 0 },
  { 0x46, 0x000a49f6, 0x000aeeee, 0x00000000, 0x0000d82e, 4, C_46_Kerning, 0, 0 },
  { 0x47, 0x000c947a, 0x000aeeee, 0x00000000, 0x00000000, 1, C_47_Kerning, 0, 0 },
  { 0x48, 0x000d4cce, 0x000aeeee, 0x00000000, 0x000080f2, 4, C_48_Kerning, 0, 0 },
  { 0x49, 0x0007088a, 0x000aeeee, 0x00000000, 0x00006e38, 1, C_49_Kerning, 0, 0 },
  { 0x4a, 0x0008df4a, 0x000aeeee, 0x00000000, 0x000092f6, 4, C_4a_Kerning, 0, 0 },
  { 0x4b, 0x000d96c3, 0x000aeeee, 0x00000000, 0x00000f2a, 4, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x000ae390, 0x000aeeee, 0x00000000, 0x00000000, 1, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x000f85b2, 0x000aeeee, 0x00000000, 0x0000b425, 4, C_4d_Kerning, 0, 0 },
  { 0x4e, 0x000cdb06, 0x000aeeee, 0x00000000, 0x0000b425, 5, C_4e_Kerning, 0, 0 },
  { 0x4f, 0x000c3455, 0x000aeeee, 0x00000000, 0x000071c8, 1, C_4f_Kerning, 0, 0 },
  { 0x50, 0x000a45b0, 0x000aeeee, 0x00000000, 0x0000d82e, 4, C_50_Kerning, 0, 0 },
  { 0x51, 0x000ca61d, 0x000aeeee, 0x00031c72, 0x00000000, 1, C_51_Kerning, 0, 0 },
  { 0x52, 0x000c260d, 0x000aeeee, 0x00000000, 0x00001fa5, 1, C_52_Kerning, 0, 0 },
  { 0x53, 0x0009cfa6, 0x000aeeee, 0x00000000, 0x0000ec16, 4, C_53_Kerning, 0, 0 },
  { 0x54, 0x0009599b, 0x000aeeee, 0x00000000, 0x0000d82e, 4, C_54_Kerning, 0, 0 },
  { 0x55, 0x000aeca8, 0x000aeeee, 0x00000000, 0x0000b425, 4, C_55_Kerning, 0, 0 },
  { 0x56, 0x00095556, 0x000aeeee, 0x00000000, 0x0000ea78, 3, C_56_Kerning, 0, 0 },
  { 0x57, 0x000f1c73, 0x000aeeee, 0x00000000, 0x0000d82e, 3, C_57_Kerning, 0, 0 },
  { 0x58, 0x000d416e, 0x000aeeee, 0x00000000, 0x00006e38, 5, C_58_Kerning, 0, 0 },
  { 0x59, 0x000949f6, 0x000aeeee, 0x00000000, 0x0000ea78, 3, C_59_Kerning, 0, 0 },
  { 0x5a, 0x000aec18, 0x000aeeee, 0x00000000, 0x00000f2a, 4, C_5a_Kerning, 0, 0 },
  { 0x5b, 0x000638e5, 0x000c0000, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5c, 0x000638e5, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x5d, 0x000638e5, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x5e, 0x00100003, 0x0005b8e5, 0xfffdb8e5, 0x00000000, 0, 0, 0, 0 },
  { 0x5f, 0x00100003, 0x0005b8e5, 0xfffdb8e5, 0x00000000, 0, 0, 0, 0 },
  { 0x60, 0x0006aaae, 0x000b1c72, 0x00000000, 0x00000000, 1, C_60_Kerning, 0, 0 },
  { 0x61, 0x0008751b, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x62, 0x0006ddde, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x63, 0x0006ec92, 0x0006e38e, 0x00000000, 0x00000000, 1, C_63_Kerning, 0, 0 },
  { 0x64, 0x000853eb, 0x000b1c72, 0x00000000, 0x00000000, 5, C_64_Kerning, 0, 0 },
  { 0x65, 0x00077335, 0x0006e38e, 0x00000000, 0x00000000, 1, C_65_Kerning, 0, 0 },
  { 0x66, 0x0007d558, 0x000b1c72, 0x00031c72, 0x00009b05, 3, C_66_Kerning, 0, 0 },
  { 0x67, 0x0007a1aa, 0x0006e38e, 0x00031c72, 0x000092f6, 1, C_67_Kerning, 0, 0 },
  { 0x68, 0x000937f3, 0x000b1c72, 0x00000000, 0x00000000, 1, C_68_Kerning, 0, 0 },
  { 0x69, 0x00058320, 0x000a8d6a, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6a, 0x000696c3, 0x000a8d6a, 0x00031c72, 0x0000ea78, 2, C_6a_Kerning, 0, 0 },
  { 0x6b, 0x00085465, 0x000b1c72, 0x00000000, 0x000080f2, 0, 0, 0, 0 },
  { 0x6c, 0x0004c62a, 0x000b1c72, 0x00000000, 0x0000509a, 1, C_6c_Kerning, 0, 0 },
  { 0x6d, 0x000e0c58, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6e, 0x00099a90, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6f, 0x0007c16d, 0x0006e38e, 0x00000000, 0x00000000, 1, C_6f_Kerning, 0, 0 },
  { 0x70, 0x00080cce, 0x0006e38e, 0x00031c72, 0x00000000, 1, C_70_Kerning, 0, 0 },
  { 0x71, 0x00072483, 0x0006e38e, 0x00031c72, 0x000092f6, 1, C_71_Kerning, 0, 0 },
  { 0x72, 0x000737f3, 0x0006e38e, 0x00000000, 0x000071c8, 3, C_72_Kerning, 0, 0 },
  { 0x73, 0x00078000, 0x0006e38e, 0x00000000, 0x00000000, 1, C_73_Kerning, 0, 0 },
  { 0x74, 0x0005c71e, 0x0009d75e, 0x00000000, 0x00000000, 1, C_74_Kerning, 0, 0 },
  { 0x75, 0x000928ca, 0x0006e38e, 0x00000000, 0x00000000, 1, C_75_Kerning, 0, 0 },
  { 0x76, 0x0007c16e, 0x0006e38e, 0x00000000, 0x000092f6, 1, C_76_Kerning, 0, 0 },
  { 0x77, 0x000b7466, 0x0006e38e, 0x00000000, 0x00006e38, 1, C_77_Kerning, 0, 0 },
  { 0x78, 0x000924fb, 0x0006e38e, 0x00000000, 0x00000000, 1, C_78_Kerning, 0, 0 },
  { 0x79, 0x0007d832, 0x0006e38e, 0x00031c72, 0x000092f6, 1, C_79_Kerning, 0, 0 },
  { 0x7a, 0x000770d8, 0x0006e38e, 0x00000000, 0x0000b425, 1, C_7a_Kerning, 0, 0 },
  { 0x7b, 0x000528c8, 0x0006e38e, 0x00000000, 0x00000000, 1, C_7b_Kerning, 0, 0 },
  { 0x7c, 0x000624fd, 0x0006e38e, 0x00031c72, 0x00000000, 1, C_7c_Kerning, 0, 0 },
  { 0x7d, 0x000a2ef0, 0x0006e38e, 0x00031c72, 0x00000000, 1, C_7d_Kerning, 0, 0 },
  { 0x7e, 0x00080002, 0x000b6e5d, 0x00000000, 0x0000e38e, 0, 0, 0, 0 },
  { 0x7f, 0x000471c8, 0x000b1c72, 0x00000000, 0x0000ec16, 0, 0, 0, 0 }
};

void
cmmi10_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
