// Copyright (C) 2000-2005, Luca Padovani <luca.padovani@cs.unibo.it>.
//
// This file is part of GtkMathView, a Gtk widget for MathML.
// 
// GtkMathView is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// GtkMathView is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GtkMathView; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// For details, see the GtkMathView World-Wide-Web page,
// http://helm.cs.unibo.it/mml-widget/, or send a mail to
// <lpadovan@cs.unibo.it>

#include "TFM.hh"

static TFM::Font font = {
"CMBSY",

  0xea,
  "TeX math symbols",
  0x00a00000,
  0xe0c98c0c,
  22,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00040000 },
  { 0x02, "space", 0x00000000 },
  { 0x03, "space_stretch", 0x00000000 },
  { 0x04, "space_shrink", 0x00000000 },
  { 0x05, "x_height", 0x00071c72 },
  { 0x06, "quad", 0x00126660 },
  { 0x07, "extra_space", 0x00000000 },
  { 0x08, "num1", 0x000bf288 },
  { 0x09, "num2", 0x0006c86e },
  { 0x0a, "num3", 0x0007953b },
  { 0x0b, "denom1", 0x000c1936 },
  { 0x0c, "denom2", 0x0006002d },
  { 0x0d, "sup1", 0x00069b35 },
  { 0x0e, "sup2", 0x0005ce68 },
  { 0x0f, "sup3", 0x00049f4a },
  { 0x10, "sub1", 0x00026666 },
  { 0x11, "sub2", 0x0004f290 },
  { 0x12, "supdrop", 0x00062d80 },
  { 0x13, "subdrop", 0x0000cccd },
  { 0x14, "delim1", 0x00263d70 },
  { 0x15, "delim2", 0x001028f6 },
  { 0x16, "axis_height", 0x00040000 }
};


static TFM::Kerning C_41_Kerning[] = {
  { 0x30, 0x000393e8 }
};

static TFM::Kerning C_42_Kerning[] = {
  { 0x30, 0x00028e38 }
};

static TFM::Kerning C_43_Kerning[] = {
  { 0x30, 0x00028e38 }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x30, 0x00018888 }
};

static TFM::Kerning C_45_Kerning[] = {
  { 0x30, 0x00020b60 }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x30, 0x00020b60 }
};

static TFM::Kerning C_47_Kerning[] = {
  { 0x30, 0x00020b60 }
};

static TFM::Kerning C_48_Kerning[] = {
  { 0x30, 0x00020b60 }
};

static TFM::Kerning C_49_Kerning[] = {
  { 0x30, 0x000082d8 }
};

static TFM::Kerning C_4a_Kerning[] = {
  { 0x30, 0x00031110 }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x30, 0x000105b0 }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x30, 0x00028e38 }
};

static TFM::Kerning C_4d_Kerning[] = {
  { 0x30, 0x00028e38 }
};

static TFM::Kerning C_4e_Kerning[] = {
  { 0x30, 0x00018888 }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x30, 0x00020b60 }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x30, 0x00018888 }
};

static TFM::Kerning C_51_Kerning[] = {
  { 0x30, 0x00020b60 }
};

static TFM::Kerning C_52_Kerning[] = {
  { 0x30, 0x00018888 }
};

static TFM::Kerning C_53_Kerning[] = {
  { 0x30, 0x00028e38 }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x30, 0x000082d8 }
};

static TFM::Kerning C_55_Kerning[] = {
  { 0x30, 0x00018888 }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x30, 0x000082d8 }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x30, 0x00018888 }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x30, 0x00028e38 }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x30, 0x00018888 }
};

static TFM::Kerning C_5a_Kerning[] = {
  { 0x30, 0x00028e38 }
};


static TFM::Character character[] = {
  { 0x00, 0x000e4fa0, 0x000a2220, 0x00022220, 0x00000000, 0, 0, 0, 0 },
  { 0x01, 0x00051c70, 0x000793e8, 0xffff93e8, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x000e4fa0, 0x000a2220, 0x00022220, 0x00000000, 0, 0, 0, 0 },
  { 0x03, 0x00093330, 0x00078e3a, 0xffff8e3a, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x000e4fa0, 0x000a2220, 0x00022220, 0x00000000, 0, 0, 0, 0 },
  { 0x05, 0x00093330, 0x000793e8, 0xffff93e8, 0x00000000, 0, 0, 0, 0 },
  { 0x06, 0x000e4fa0, 0x000a2220, 0x00022220, 0x00000000, 0, 0, 0, 0 },
  { 0x07, 0x000e4fa0, 0x000a2220, 0x00022220, 0x00000000, 0, 0, 0, 0 },
  { 0x08, 0x000e4fa0, 0x000a2220, 0x00022220, 0x00000000, 0, 0, 0, 0 },
  { 0x09, 0x000e4fa0, 0x000a2220, 0x00022220, 0x00000000, 0, 0, 0, 0 },
  { 0x0a, 0x000e4fa0, 0x000a2220, 0x00022220, 0x00000000, 0, 0, 0, 0 },
  { 0x0b, 0x000e4fa0, 0x000a2220, 0x00022220, 0x00000000, 0, 0, 0, 0 },
  { 0x0c, 0x000e4fa0, 0x000a2220, 0x00022220, 0x00000000, 0, 0, 0, 0 },
  { 0x0d, 0x00126660, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x0e, 0x00093330, 0x000793e8, 0xffff93e8, 0x00000000, 0, 0, 0, 0 },
  { 0x0f, 0x00093330, 0x000793e8, 0xffff93e8, 0x00000000, 0, 0, 0, 0 },
  { 0x10, 0x000e4fa0, 0x0008091b, 0x0000091b, 0x00000000, 0, 0, 0, 0 },
  { 0x11, 0x000e4fa0, 0x0008091b, 0x0000091b, 0x00000000, 0, 0, 0, 0 },
  { 0x12, 0x000e4fa0, 0x000b258d, 0x0003258d, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x000e4fa0, 0x000b258d, 0x0003258d, 0x00000000, 0, 0, 0, 0 },
  { 0x14, 0x000e4fa0, 0x000b258d, 0x0003258d, 0x00000000, 0, 0, 0, 0 },
  { 0x15, 0x000e4fa0, 0x000b258d, 0x0003258d, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x000e4fa0, 0x000b258d, 0x0003258d, 0x00000000, 0, 0, 0, 0 },
  { 0x17, 0x000e4fa0, 0x000b258d, 0x0003258d, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x000e4fa0, 0x000641fe, 0xfffe41fe, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x000e4fa0, 0x00086420, 0x00006420, 0x00000000, 0, 0, 0, 0 },
  { 0x1a, 0x000e4fa0, 0x00095e70, 0x00015e70, 0x00000000, 0, 0, 0, 0 },
  { 0x1b, 0x000e4fa0, 0x00095e70, 0x00015e70, 0x00000000, 0, 0, 0, 0 },
  { 0x1c, 0x00126660, 0x00095e70, 0x00015e70, 0x00000000, 0, 0, 0, 0 },
  { 0x1d, 0x00126660, 0x00095e70, 0x00015e70, 0x00000000, 0, 0, 0, 0 },
  { 0x1e, 0x000e4fa0, 0x00095e70, 0x00015e70, 0x00000000, 0, 0, 0, 0 },
  { 0x1f, 0x000e4fa0, 0x00095e70, 0x00015e70, 0x00000000, 0, 0, 0, 0 },
  { 0x20, 0x00126660, 0x000641fe, 0xfffe41fe, 0x00000000, 0, 0, 0, 0 },
  { 0x21, 0x00126660, 0x000641fe, 0xfffe41fe, 0x00000000, 0, 0, 0, 0 },
  { 0x22, 0x00093330, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x23, 0x00093330, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x24, 0x00126660, 0x000641fe, 0xfffe41fe, 0x00000000, 0, 0, 0, 0 },
  { 0x25, 0x00126660, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x26, 0x00126660, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x27, 0x000e4fa0, 0x0008091b, 0x0000091b, 0x00000000, 0, 0, 0, 0 },
  { 0x28, 0x00126660, 0x000641fe, 0xfffe41fe, 0x00000000, 0, 0, 0, 0 },
  { 0x29, 0x00126660, 0x000641fe, 0xfffe41fe, 0x00000000, 0, 0, 0, 0 },
  { 0x2a, 0x000b3e90, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x2b, 0x000b3e90, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x2c, 0x00126660, 0x000641fe, 0xfffe41fe, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x00126660, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x2e, 0x00126660, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x000e4fa0, 0x00071c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x30, 0x000582d6, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x31, 0x00126660, 0x00071c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x32, 0x000c4440, 0x00095e70, 0x00015e70, 0x00000000, 0, 0, 0, 0 },
  { 0x33, 0x000c4440, 0x00095e70, 0x00015e70, 0x00000000, 0, 0, 0, 0 },
  { 0x34, 0x00105b00, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x35, 0x00105b00, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x36, 0x00000000, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x37, 0x00000000, 0x000641fe, 0xfffe41fe, 0x00000000, 0, 0, 0, 0 },
  { 0x38, 0x000a38e0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x39, 0x000a38e0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3a, 0x000c4440, 0x00071c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3b, 0x00093330, 0x000c0000, 0x0000e38e, 0x00000000, 0, 0, 0, 0 },
  { 0x3c, 0x000d49f0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3d, 0x000d49f0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3e, 0x000e4fa0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x000e4fa0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x40, 0x000b3e90, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x41, 0x000ebb4d, 0x000afa50, 0x00000000, 0x00000000, 1, C_41_Kerning, 0, 0 },
  { 0x42, 0x000bf72b, 0x000afa50, 0x00000000, 0x00005c33, 1, C_42_Kerning, 0, 0 },
  { 0x43, 0x0009cec6, 0x000afa50, 0x00000000, 0x0000c11b, 1, C_43_Kerning, 0, 0 },
  { 0x44, 0x000e45f5, 0x000afa50, 0x00000000, 0x000082d8, 1, C_44_Kerning, 0, 0 },
  { 0x45, 0x0009b608, 0x000afa50, 0x00000000, 0x0001539e, 1, C_45_Kerning, 0, 0 },
  { 0x46, 0x000d0682, 0x000afa50, 0x00000000, 0x0001a0b6, 1, C_46_Kerning, 0, 0 },
  { 0x47, 0x000ae7d0, 0x000afa50, 0x00018e3a, 0x0000e44b, 1, C_47_Kerning, 0, 0 },
  { 0x48, 0x000fcc58, 0x000afa50, 0x00000000, 0x00000000, 1, C_48_Kerning, 0, 0 },
  { 0x49, 0x000a473b, 0x000afa50, 0x00000000, 0x00014d7a, 1, C_49_Kerning, 0, 0 },
  { 0x4a, 0x000c7896, 0x000afa50, 0x00018e3a, 0x00030002, 1, C_4a_Kerning, 0, 0 },
  { 0x4b, 0x000df0a3, 0x000afa50, 0x00000000, 0x00000000, 1, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x000c9c6d, 0x000afa50, 0x00000000, 0x00000000, 1, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x00160b93, 0x000afa50, 0x00000000, 0x00000000, 1, C_4d_Kerning, 0, 0 },
  { 0x4e, 0x000eff45, 0x000afa50, 0x00000000, 0x00026ea6, 1, C_4e_Kerning, 0, 0 },
  { 0x4f, 0x000e7d23, 0x000afa50, 0x00000000, 0x000082d8, 1, C_4f_Kerning, 0, 0 },
  { 0x50, 0x000cf52d, 0x000afa50, 0x00000000, 0x00015a73, 1, C_50_Kerning, 0, 0 },
  { 0x51, 0x000f06ce, 0x000afa50, 0x00018e3a, 0x00000000, 1, C_51_Kerning, 0, 0 },
  { 0x52, 0x000fd54e, 0x000afa50, 0x00000000, 0x00000000, 1, C_52_Kerning, 0, 0 },
  { 0x53, 0x000b2465, 0x000afa50, 0x00000000, 0x00012400, 1, C_53_Kerning, 0, 0 },
  { 0x54, 0x000a4e68, 0x000afa50, 0x00000000, 0x0004471d, 1, C_54_Kerning, 0, 0 },
  { 0x55, 0x000b6f78, 0x000afa50, 0x00000000, 0x0001a0b6, 1, C_55_Kerning, 0, 0 },
  { 0x56, 0x000bcc38, 0x000afa50, 0x00000000, 0x00015a73, 1, C_56_Kerning, 0, 0 },
  { 0x57, 0x0012b29b, 0x000afa50, 0x00000000, 0x00015a73, 1, C_57_Kerning, 0, 0 },
  { 0x58, 0x000d114b, 0x000afa50, 0x00000000, 0x00025a36, 1, C_58_Kerning, 0, 0 },
  { 0x59, 0x000c2343, 0x000afa50, 0x00018e3a, 0x00015a73, 1, C_59_Kerning, 0, 0 },
  { 0x5a, 0x000d1875, 0x000afa50, 0x00000000, 0x00014d5d, 1, C_5a_Kerning, 0, 0 },
  { 0x5b, 0x000c4440, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5c, 0x000c4440, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5d, 0x000c4440, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5e, 0x000c4440, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5f, 0x000c4440, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x60, 0x000b3e90, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x61, 0x000b3e90, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x62, 0x00082d80, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x63, 0x00082d80, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x64, 0x00082d80, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x65, 0x00082d80, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x66, 0x00093330, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x67, 0x00093330, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x68, 0x000727d0, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x69, 0x000727d0, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6a, 0x00051c70, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6b, 0x00093330, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6c, 0x00093330, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6d, 0x000b3e90, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6e, 0x00093330, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6f, 0x00051c70, 0x000b1c72, 0x00031c70, 0x00000000, 0, 0, 0, 0 },
  { 0x70, 0x000f5550, 0x0000f5c3, 0x000f0a3d, 0x00000000, 0, 0, 0, 0 },
  { 0x71, 0x000e6662, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x72, 0x000f5550, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x73, 0x0009199a, 0x000b1c72, 0x00031c72, 0x00020b60, 0, 0, 0, 0 },
  { 0x74, 0x000c4440, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x75, 0x000c4440, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x76, 0x000e4fa0, 0x000b258d, 0x0003258d, 0x00000000, 0, 0, 0, 0 },
  { 0x77, 0x000e4fa0, 0x000b258d, 0x0003258d, 0x00000000, 0, 0, 0, 0 },
  { 0x78, 0x00086c15, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x79, 0x00082d80, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x7a, 0x00082d80, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x7b, 0x000b3e90, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x7c, 0x000e4fa0, 0x000b1c72, 0x000212f6, 0x00000000, 0, 0, 0, 0 },
  { 0x7d, 0x000e4fa0, 0x000b1c72, 0x000212f6, 0x00000000, 0, 0, 0, 0 },
  { 0x7e, 0x000e4fa0, 0x000b1c72, 0x000212f6, 0x00000000, 0, 0, 0, 0 },
  { 0x7f, 0x000e4fa0, 0x000b1c72, 0x000212f6, 0x00000000, 0, 0, 0, 0 }
};

void
cmbsy10_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
