/* grepmap
 * arch-tag: cedc5a03-e58d-4418-89ec-cbf2042d371e
 *
 * Copyright © 2004 Canonical Ltd.
 * Author: Scott James Remnant <scott@canonical.com>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef GREPMAP_GREPMAP_H
#define GREPMAP_GREPMAP_H

/* Required includes */
#include <stdio.h>
#include <gettext.h>


/* Make gettext a little friendlier */
#define _(String) gettext (String)
#define N_(String) gettext_noop (String)

/* Check a flag is set */
#define FLAG_SET(set, flag) (((set) & (flag)) == (flag))


/* Program's name */
extern const char *program_name;


/* Utility functions */
extern void  suggest_help (void);
extern char *fgets_alloc  (FILE *stream);
extern int   parse_hex    (const char *str, unsigned int *hex);

/* Map functions */
extern int pcimap_modules      (FILE *mapf, const char *file, char *argv[]);
extern int usbmap_modules      (FILE *mapf, const char *file, char *argv[]);
extern int inputmap_modules    (FILE *mapf, const char *file, char *argv[]);
extern int ieee1394map_modules (FILE *mapf, const char *file, char *argv[]);

#endif /* ! GREPMAP_GREPMAP_H */
