// This file was generated by go generate; DO NOT EDIT

package precis

// UnicodeVersion is the Unicode version from which the tables in this package are derived.
const UnicodeVersion = "8.0.0"

// lookup returns the trie value for the first UTF-8 encoding in s and
// the width in bytes of this encoding. The size will be 0 if s does not
// hold enough bytes to complete the encoding. len(s) must be greater than 0.
func (t *derivedPropertiesTrie) lookup(s []byte) (v uint8, sz int) {
	c0 := s[0]
	switch {
	case c0 < 0x80: // is ASCII
		return derivedPropertiesValues[c0], 1
	case c0 < 0xC2:
		return 0, 1 // Illegal UTF-8: not a starter, not ASCII.
	case c0 < 0xE0: // 2-byte UTF-8
		if len(s) < 2 {
			return 0, 0
		}
		i := derivedPropertiesIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		return t.lookupValue(uint32(i), c1), 2
	case c0 < 0xF0: // 3-byte UTF-8
		if len(s) < 3 {
			return 0, 0
		}
		i := derivedPropertiesIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		o := uint32(i)<<6 + uint32(c1)
		i = derivedPropertiesIndex[o]
		c2 := s[2]
		if c2 < 0x80 || 0xC0 <= c2 {
			return 0, 2 // Illegal UTF-8: not a continuation byte.
		}
		return t.lookupValue(uint32(i), c2), 3
	case c0 < 0xF8: // 4-byte UTF-8
		if len(s) < 4 {
			return 0, 0
		}
		i := derivedPropertiesIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		o := uint32(i)<<6 + uint32(c1)
		i = derivedPropertiesIndex[o]
		c2 := s[2]
		if c2 < 0x80 || 0xC0 <= c2 {
			return 0, 2 // Illegal UTF-8: not a continuation byte.
		}
		o = uint32(i)<<6 + uint32(c2)
		i = derivedPropertiesIndex[o]
		c3 := s[3]
		if c3 < 0x80 || 0xC0 <= c3 {
			return 0, 3 // Illegal UTF-8: not a continuation byte.
		}
		return t.lookupValue(uint32(i), c3), 4
	}
	// Illegal rune
	return 0, 1
}

// lookupUnsafe returns the trie value for the first UTF-8 encoding in s.
// s must start with a full and valid UTF-8 encoded rune.
func (t *derivedPropertiesTrie) lookupUnsafe(s []byte) uint8 {
	c0 := s[0]
	if c0 < 0x80 { // is ASCII
		return derivedPropertiesValues[c0]
	}
	i := derivedPropertiesIndex[c0]
	if c0 < 0xE0 { // 2-byte UTF-8
		return t.lookupValue(uint32(i), s[1])
	}
	i = derivedPropertiesIndex[uint32(i)<<6+uint32(s[1])]
	if c0 < 0xF0 { // 3-byte UTF-8
		return t.lookupValue(uint32(i), s[2])
	}
	i = derivedPropertiesIndex[uint32(i)<<6+uint32(s[2])]
	if c0 < 0xF8 { // 4-byte UTF-8
		return t.lookupValue(uint32(i), s[3])
	}
	return 0
}

// lookupString returns the trie value for the first UTF-8 encoding in s and
// the width in bytes of this encoding. The size will be 0 if s does not
// hold enough bytes to complete the encoding. len(s) must be greater than 0.
func (t *derivedPropertiesTrie) lookupString(s string) (v uint8, sz int) {
	c0 := s[0]
	switch {
	case c0 < 0x80: // is ASCII
		return derivedPropertiesValues[c0], 1
	case c0 < 0xC2:
		return 0, 1 // Illegal UTF-8: not a starter, not ASCII.
	case c0 < 0xE0: // 2-byte UTF-8
		if len(s) < 2 {
			return 0, 0
		}
		i := derivedPropertiesIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		return t.lookupValue(uint32(i), c1), 2
	case c0 < 0xF0: // 3-byte UTF-8
		if len(s) < 3 {
			return 0, 0
		}
		i := derivedPropertiesIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		o := uint32(i)<<6 + uint32(c1)
		i = derivedPropertiesIndex[o]
		c2 := s[2]
		if c2 < 0x80 || 0xC0 <= c2 {
			return 0, 2 // Illegal UTF-8: not a continuation byte.
		}
		return t.lookupValue(uint32(i), c2), 3
	case c0 < 0xF8: // 4-byte UTF-8
		if len(s) < 4 {
			return 0, 0
		}
		i := derivedPropertiesIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		o := uint32(i)<<6 + uint32(c1)
		i = derivedPropertiesIndex[o]
		c2 := s[2]
		if c2 < 0x80 || 0xC0 <= c2 {
			return 0, 2 // Illegal UTF-8: not a continuation byte.
		}
		o = uint32(i)<<6 + uint32(c2)
		i = derivedPropertiesIndex[o]
		c3 := s[3]
		if c3 < 0x80 || 0xC0 <= c3 {
			return 0, 3 // Illegal UTF-8: not a continuation byte.
		}
		return t.lookupValue(uint32(i), c3), 4
	}
	// Illegal rune
	return 0, 1
}

// lookupStringUnsafe returns the trie value for the first UTF-8 encoding in s.
// s must start with a full and valid UTF-8 encoded rune.
func (t *derivedPropertiesTrie) lookupStringUnsafe(s string) uint8 {
	c0 := s[0]
	if c0 < 0x80 { // is ASCII
		return derivedPropertiesValues[c0]
	}
	i := derivedPropertiesIndex[c0]
	if c0 < 0xE0 { // 2-byte UTF-8
		return t.lookupValue(uint32(i), s[1])
	}
	i = derivedPropertiesIndex[uint32(i)<<6+uint32(s[1])]
	if c0 < 0xF0 { // 3-byte UTF-8
		return t.lookupValue(uint32(i), s[2])
	}
	i = derivedPropertiesIndex[uint32(i)<<6+uint32(s[2])]
	if c0 < 0xF8 { // 4-byte UTF-8
		return t.lookupValue(uint32(i), s[3])
	}
	return 0
}

// derivedPropertiesTrie. Total size: 23104 bytes (22.56 KiB). Checksum: 47ee43f70f6cbb55.
type derivedPropertiesTrie struct{}

func newDerivedPropertiesTrie(i int) *derivedPropertiesTrie {
	return &derivedPropertiesTrie{}
}

// lookupValue determines the type of block n and looks up the value for b.
func (t *derivedPropertiesTrie) lookupValue(n uint32, b byte) uint8 {
	switch {
	default:
		return uint8(derivedPropertiesValues[n<<6+uint32(b)])
	}
}

// derivedPropertiesValues: 293 blocks, 18752 entries, 18752 bytes
// The third block is the zero block.
var derivedPropertiesValues = [18752]uint8{
	// Block 0x0, offset 0x0
	0x00: 0x0001, 0x01: 0x0001, 0x02: 0x0001, 0x03: 0x0001, 0x04: 0x0001, 0x05: 0x0001,
	0x06: 0x0001, 0x07: 0x0001, 0x08: 0x0001, 0x09: 0x0001, 0x0a: 0x0001, 0x0b: 0x0001,
	0x0c: 0x0001, 0x0d: 0x0001, 0x0e: 0x0001, 0x0f: 0x0001, 0x10: 0x0001, 0x11: 0x0001,
	0x12: 0x0001, 0x13: 0x0001, 0x14: 0x0001, 0x15: 0x0001, 0x16: 0x0001, 0x17: 0x0001,
	0x18: 0x0001, 0x19: 0x0001, 0x1a: 0x0001, 0x1b: 0x0001, 0x1c: 0x0001, 0x1d: 0x0001,
	0x1e: 0x0001, 0x1f: 0x0001, 0x20: 0x0004, 0x21: 0x0005, 0x22: 0x0005, 0x23: 0x0005,
	0x24: 0x0005, 0x25: 0x0005, 0x26: 0x0005, 0x27: 0x0005, 0x28: 0x0005, 0x29: 0x0005,
	0x2a: 0x0005, 0x2b: 0x0005, 0x2c: 0x0005, 0x2d: 0x0005, 0x2e: 0x0005, 0x2f: 0x0005,
	0x30: 0x0005, 0x31: 0x0005, 0x32: 0x0005, 0x33: 0x0005, 0x34: 0x0005, 0x35: 0x0005,
	0x36: 0x0005, 0x37: 0x0005, 0x38: 0x0005, 0x39: 0x0005, 0x3a: 0x0005, 0x3b: 0x0005,
	0x3c: 0x0005, 0x3d: 0x0005, 0x3e: 0x0005, 0x3f: 0x0005,
	// Block 0x1, offset 0x40
	0x40: 0x0005, 0x41: 0x0005, 0x42: 0x0005, 0x43: 0x0005, 0x44: 0x0005, 0x45: 0x0005,
	0x46: 0x0005, 0x47: 0x0005, 0x48: 0x0005, 0x49: 0x0005, 0x4a: 0x0005, 0x4b: 0x0005,
	0x4c: 0x0005, 0x4d: 0x0005, 0x4e: 0x0005, 0x4f: 0x0005, 0x50: 0x0005, 0x51: 0x0005,
	0x52: 0x0005, 0x53: 0x0005, 0x54: 0x0005, 0x55: 0x0005, 0x56: 0x0005, 0x57: 0x0005,
	0x58: 0x0005, 0x59: 0x0005, 0x5a: 0x0005, 0x5b: 0x0005, 0x5c: 0x0005, 0x5d: 0x0005,
	0x5e: 0x0005, 0x5f: 0x0005, 0x60: 0x0005, 0x61: 0x0005, 0x62: 0x0005, 0x63: 0x0005,
	0x64: 0x0005, 0x65: 0x0005, 0x66: 0x0005, 0x67: 0x0005, 0x68: 0x0005, 0x69: 0x0005,
	0x6a: 0x0005, 0x6b: 0x0005, 0x6c: 0x0005, 0x6d: 0x0005, 0x6e: 0x0005, 0x6f: 0x0005,
	0x70: 0x0005, 0x71: 0x0005, 0x72: 0x0005, 0x73: 0x0005, 0x74: 0x0005, 0x75: 0x0005,
	0x76: 0x0005, 0x77: 0x0005, 0x78: 0x0005, 0x79: 0x0005, 0x7a: 0x0005, 0x7b: 0x0005,
	0x7c: 0x0005, 0x7d: 0x0005, 0x7e: 0x0005, 0x7f: 0x0001,
	// Block 0x2, offset 0x80
	// Block 0x3, offset 0xc0
	0xc0: 0x0001, 0xc1: 0x0001, 0xc2: 0x0001, 0xc3: 0x0001, 0xc4: 0x0001, 0xc5: 0x0001,
	0xc6: 0x0001, 0xc7: 0x0001, 0xc8: 0x0001, 0xc9: 0x0001, 0xca: 0x0001, 0xcb: 0x0001,
	0xcc: 0x0001, 0xcd: 0x0001, 0xce: 0x0001, 0xcf: 0x0001, 0xd0: 0x0001, 0xd1: 0x0001,
	0xd2: 0x0001, 0xd3: 0x0001, 0xd4: 0x0001, 0xd5: 0x0001, 0xd6: 0x0001, 0xd7: 0x0001,
	0xd8: 0x0001, 0xd9: 0x0001, 0xda: 0x0001, 0xdb: 0x0001, 0xdc: 0x0001, 0xdd: 0x0001,
	0xde: 0x0001, 0xdf: 0x0001, 0xe0: 0x0004, 0xe1: 0x0004, 0xe2: 0x0004, 0xe3: 0x0004,
	0xe4: 0x0004, 0xe5: 0x0004, 0xe6: 0x0004, 0xe7: 0x0004, 0xe8: 0x0004, 0xe9: 0x0004,
	0xea: 0x0004, 0xeb: 0x0004, 0xec: 0x0004, 0xed: 0x0001, 0xee: 0x0004, 0xef: 0x0004,
	0xf0: 0x0004, 0xf1: 0x0004, 0xf2: 0x0004, 0xf3: 0x0004, 0xf4: 0x0004, 0xf5: 0x0004,
	0xf6: 0x0004, 0xf7: 0x0002, 0xf8: 0x0004, 0xf9: 0x0004, 0xfa: 0x0004, 0xfb: 0x0004,
	0xfc: 0x0004, 0xfd: 0x0004, 0xfe: 0x0004, 0xff: 0x0004,
	// Block 0x4, offset 0x100
	0x100: 0x0005, 0x101: 0x0005, 0x102: 0x0005, 0x103: 0x0005, 0x104: 0x0005, 0x105: 0x0005,
	0x106: 0x0005, 0x107: 0x0005, 0x108: 0x0005, 0x109: 0x0005, 0x10a: 0x0005, 0x10b: 0x0005,
	0x10c: 0x0005, 0x10d: 0x0005, 0x10e: 0x0005, 0x10f: 0x0005, 0x110: 0x0005, 0x111: 0x0005,
	0x112: 0x0005, 0x113: 0x0005, 0x114: 0x0005, 0x115: 0x0005, 0x116: 0x0005, 0x117: 0x0004,
	0x118: 0x0005, 0x119: 0x0005, 0x11a: 0x0005, 0x11b: 0x0005, 0x11c: 0x0005, 0x11d: 0x0005,
	0x11e: 0x0005, 0x11f: 0x0005, 0x120: 0x0005, 0x121: 0x0005, 0x122: 0x0005, 0x123: 0x0005,
	0x124: 0x0005, 0x125: 0x0005, 0x126: 0x0005, 0x127: 0x0005, 0x128: 0x0005, 0x129: 0x0005,
	0x12a: 0x0005, 0x12b: 0x0005, 0x12c: 0x0005, 0x12d: 0x0005, 0x12e: 0x0005, 0x12f: 0x0005,
	0x130: 0x0005, 0x131: 0x0005, 0x132: 0x0005, 0x133: 0x0005, 0x134: 0x0005, 0x135: 0x0005,
	0x136: 0x0005, 0x137: 0x0004, 0x138: 0x0005, 0x139: 0x0005, 0x13a: 0x0005, 0x13b: 0x0005,
	0x13c: 0x0005, 0x13d: 0x0005, 0x13e: 0x0005, 0x13f: 0x0005,
	// Block 0x5, offset 0x140
	0x140: 0x0005, 0x141: 0x0005, 0x142: 0x0005, 0x143: 0x0005, 0x144: 0x0005, 0x145: 0x0005,
	0x146: 0x0005, 0x147: 0x0005, 0x148: 0x0005, 0x149: 0x0005, 0x14a: 0x0005, 0x14b: 0x0005,
	0x14c: 0x0005, 0x14d: 0x0005, 0x14e: 0x0005, 0x14f: 0x0005, 0x150: 0x0005, 0x151: 0x0005,
	0x152: 0x0005, 0x153: 0x0005, 0x154: 0x0005, 0x155: 0x0005, 0x156: 0x0005, 0x157: 0x0005,
	0x158: 0x0005, 0x159: 0x0005, 0x15a: 0x0005, 0x15b: 0x0005, 0x15c: 0x0005, 0x15d: 0x0005,
	0x15e: 0x0005, 0x15f: 0x0005, 0x160: 0x0005, 0x161: 0x0005, 0x162: 0x0005, 0x163: 0x0005,
	0x164: 0x0005, 0x165: 0x0005, 0x166: 0x0005, 0x167: 0x0005, 0x168: 0x0005, 0x169: 0x0005,
	0x16a: 0x0005, 0x16b: 0x0005, 0x16c: 0x0005, 0x16d: 0x0005, 0x16e: 0x0005, 0x16f: 0x0005,
	0x170: 0x0005, 0x171: 0x0005, 0x172: 0x0004, 0x173: 0x0004, 0x174: 0x0005, 0x175: 0x0005,
	0x176: 0x0005, 0x177: 0x0005, 0x178: 0x0005, 0x179: 0x0005, 0x17a: 0x0005, 0x17b: 0x0005,
	0x17c: 0x0005, 0x17d: 0x0005, 0x17e: 0x0005, 0x17f: 0x0004,
	// Block 0x6, offset 0x180
	0x180: 0x0004, 0x181: 0x0005, 0x182: 0x0005, 0x183: 0x0005, 0x184: 0x0005, 0x185: 0x0005,
	0x186: 0x0005, 0x187: 0x0005, 0x188: 0x0005, 0x189: 0x0004, 0x18a: 0x0005, 0x18b: 0x0005,
	0x18c: 0x0005, 0x18d: 0x0005, 0x18e: 0x0005, 0x18f: 0x0005, 0x190: 0x0005, 0x191: 0x0005,
	0x192: 0x0005, 0x193: 0x0005, 0x194: 0x0005, 0x195: 0x0005, 0x196: 0x0005, 0x197: 0x0005,
	0x198: 0x0005, 0x199: 0x0005, 0x19a: 0x0005, 0x19b: 0x0005, 0x19c: 0x0005, 0x19d: 0x0005,
	0x19e: 0x0005, 0x19f: 0x0005, 0x1a0: 0x0005, 0x1a1: 0x0005, 0x1a2: 0x0005, 0x1a3: 0x0005,
	0x1a4: 0x0005, 0x1a5: 0x0005, 0x1a6: 0x0005, 0x1a7: 0x0005, 0x1a8: 0x0005, 0x1a9: 0x0005,
	0x1aa: 0x0005, 0x1ab: 0x0005, 0x1ac: 0x0005, 0x1ad: 0x0005, 0x1ae: 0x0005, 0x1af: 0x0005,
	0x1b0: 0x0005, 0x1b1: 0x0005, 0x1b2: 0x0005, 0x1b3: 0x0005, 0x1b4: 0x0005, 0x1b5: 0x0005,
	0x1b6: 0x0005, 0x1b7: 0x0005, 0x1b8: 0x0005, 0x1b9: 0x0005, 0x1ba: 0x0005, 0x1bb: 0x0005,
	0x1bc: 0x0005, 0x1bd: 0x0005, 0x1be: 0x0005, 0x1bf: 0x0004,
	// Block 0x7, offset 0x1c0
	0x1c0: 0x0005, 0x1c1: 0x0005, 0x1c2: 0x0005, 0x1c3: 0x0005, 0x1c4: 0x0005, 0x1c5: 0x0005,
	0x1c6: 0x0005, 0x1c7: 0x0005, 0x1c8: 0x0005, 0x1c9: 0x0005, 0x1ca: 0x0005, 0x1cb: 0x0005,
	0x1cc: 0x0005, 0x1cd: 0x0005, 0x1ce: 0x0005, 0x1cf: 0x0005, 0x1d0: 0x0005, 0x1d1: 0x0005,
	0x1d2: 0x0005, 0x1d3: 0x0005, 0x1d4: 0x0005, 0x1d5: 0x0005, 0x1d6: 0x0005, 0x1d7: 0x0005,
	0x1d8: 0x0005, 0x1d9: 0x0005, 0x1da: 0x0005, 0x1db: 0x0005, 0x1dc: 0x0005, 0x1dd: 0x0005,
	0x1de: 0x0005, 0x1df: 0x0005, 0x1e0: 0x0005, 0x1e1: 0x0005, 0x1e2: 0x0005, 0x1e3: 0x0005,
	0x1e4: 0x0005, 0x1e5: 0x0005, 0x1e6: 0x0005, 0x1e7: 0x0005, 0x1e8: 0x0005, 0x1e9: 0x0005,
	0x1ea: 0x0005, 0x1eb: 0x0005, 0x1ec: 0x0005, 0x1ed: 0x0005, 0x1ee: 0x0005, 0x1ef: 0x0005,
	0x1f0: 0x0005, 0x1f1: 0x0005, 0x1f2: 0x0005, 0x1f3: 0x0005, 0x1f4: 0x0005, 0x1f5: 0x0005,
	0x1f6: 0x0005, 0x1f7: 0x0005, 0x1f8: 0x0005, 0x1f9: 0x0005, 0x1fa: 0x0005, 0x1fb: 0x0005,
	0x1fc: 0x0005, 0x1fd: 0x0005, 0x1fe: 0x0005, 0x1ff: 0x0005,
	// Block 0x8, offset 0x200
	0x200: 0x0005, 0x201: 0x0005, 0x202: 0x0005, 0x203: 0x0005, 0x204: 0x0004, 0x205: 0x0004,
	0x206: 0x0004, 0x207: 0x0004, 0x208: 0x0004, 0x209: 0x0004, 0x20a: 0x0004, 0x20b: 0x0004,
	0x20c: 0x0004, 0x20d: 0x0005, 0x20e: 0x0005, 0x20f: 0x0005, 0x210: 0x0005, 0x211: 0x0005,
	0x212: 0x0005, 0x213: 0x0005, 0x214: 0x0005, 0x215: 0x0005, 0x216: 0x0005, 0x217: 0x0005,
	0x218: 0x0005, 0x219: 0x0005, 0x21a: 0x0005, 0x21b: 0x0005, 0x21c: 0x0005, 0x21d: 0x0005,
	0x21e: 0x0005, 0x21f: 0x0005, 0x220: 0x0005, 0x221: 0x0005, 0x222: 0x0005, 0x223: 0x0005,
	0x224: 0x0005, 0x225: 0x0005, 0x226: 0x0005, 0x227: 0x0005, 0x228: 0x0005, 0x229: 0x0005,
	0x22a: 0x0005, 0x22b: 0x0005, 0x22c: 0x0005, 0x22d: 0x0005, 0x22e: 0x0005, 0x22f: 0x0005,
	0x230: 0x0005, 0x231: 0x0004, 0x232: 0x0004, 0x233: 0x0004, 0x234: 0x0005, 0x235: 0x0005,
	0x236: 0x0005, 0x237: 0x0005, 0x238: 0x0005, 0x239: 0x0005, 0x23a: 0x0005, 0x23b: 0x0005,
	0x23c: 0x0005, 0x23d: 0x0005, 0x23e: 0x0005, 0x23f: 0x0005,
	// Block 0x9, offset 0x240
	0x240: 0x0005, 0x241: 0x0005, 0x242: 0x0005, 0x243: 0x0005, 0x244: 0x0005, 0x245: 0x0005,
	0x246: 0x0005, 0x247: 0x0005, 0x248: 0x0005, 0x249: 0x0005, 0x24a: 0x0005, 0x24b: 0x0005,
	0x24c: 0x0005, 0x24d: 0x0005, 0x24e: 0x0005, 0x24f: 0x0005, 0x250: 0x0005, 0x251: 0x0005,
	0x252: 0x0005, 0x253: 0x0005, 0x254: 0x0005, 0x255: 0x0005, 0x256: 0x0005, 0x257: 0x0005,
	0x258: 0x0005, 0x259: 0x0005, 0x25a: 0x0005, 0x25b: 0x0005, 0x25c: 0x0005, 0x25d: 0x0005,
	0x25e: 0x0005, 0x25f: 0x0005, 0x260: 0x0005, 0x261: 0x0005, 0x262: 0x0005, 0x263: 0x0005,
	0x264: 0x0005, 0x265: 0x0005, 0x266: 0x0005, 0x267: 0x0005, 0x268: 0x0005, 0x269: 0x0005,
	0x26a: 0x0005, 0x26b: 0x0005, 0x26c: 0x0005, 0x26d: 0x0005, 0x26e: 0x0005, 0x26f: 0x0005,
	0x270: 0x0004, 0x271: 0x0004, 0x272: 0x0004, 0x273: 0x0004, 0x274: 0x0004, 0x275: 0x0004,
	0x276: 0x0004, 0x277: 0x0004, 0x278: 0x0004, 0x279: 0x0005, 0x27a: 0x0005, 0x27b: 0x0005,
	0x27c: 0x0005, 0x27d: 0x0005, 0x27e: 0x0005, 0x27f: 0x0005,
	// Block 0xa, offset 0x280
	0x280: 0x0005, 0x281: 0x0005, 0x282: 0x0004, 0x283: 0x0004, 0x284: 0x0004, 0x285: 0x0004,
	0x286: 0x0005, 0x287: 0x0005, 0x288: 0x0005, 0x289: 0x0005, 0x28a: 0x0005, 0x28b: 0x0005,
	0x28c: 0x0005, 0x28d: 0x0005, 0x28e: 0x0005, 0x28f: 0x0005, 0x290: 0x0005, 0x291: 0x0005,
	0x292: 0x0004, 0x293: 0x0004, 0x294: 0x0004, 0x295: 0x0004, 0x296: 0x0004, 0x297: 0x0004,
	0x298: 0x0004, 0x299: 0x0004, 0x29a: 0x0004, 0x29b: 0x0004, 0x29c: 0x0004, 0x29d: 0x0004,
	0x29e: 0x0004, 0x29f: 0x0004, 0x2a0: 0x0004, 0x2a1: 0x0004, 0x2a2: 0x0004, 0x2a3: 0x0004,
	0x2a4: 0x0004, 0x2a5: 0x0004, 0x2a6: 0x0004, 0x2a7: 0x0004, 0x2a8: 0x0004, 0x2a9: 0x0004,
	0x2aa: 0x0004, 0x2ab: 0x0004, 0x2ac: 0x0005, 0x2ad: 0x0004, 0x2ae: 0x0005, 0x2af: 0x0004,
	0x2b0: 0x0004, 0x2b1: 0x0004, 0x2b2: 0x0004, 0x2b3: 0x0004, 0x2b4: 0x0004, 0x2b5: 0x0004,
	0x2b6: 0x0004, 0x2b7: 0x0004, 0x2b8: 0x0004, 0x2b9: 0x0004, 0x2ba: 0x0004, 0x2bb: 0x0004,
	0x2bc: 0x0004, 0x2bd: 0x0004, 0x2be: 0x0004, 0x2bf: 0x0004,
	// Block 0xb, offset 0x2c0
	0x2c0: 0x0004, 0x2c1: 0x0004, 0x2c2: 0x0005, 0x2c3: 0x0004, 0x2c4: 0x0004, 0x2c5: 0x0005,
	0x2c6: 0x0005, 0x2c7: 0x0005, 0x2c8: 0x0005, 0x2c9: 0x0005, 0x2ca: 0x0005, 0x2cb: 0x0005,
	0x2cc: 0x0005, 0x2cd: 0x0005, 0x2ce: 0x0005, 0x2cf: 0x0001, 0x2d0: 0x0005, 0x2d1: 0x0005,
	0x2d2: 0x0005, 0x2d3: 0x0005, 0x2d4: 0x0005, 0x2d5: 0x0005, 0x2d6: 0x0005, 0x2d7: 0x0005,
	0x2d8: 0x0005, 0x2d9: 0x0005, 0x2da: 0x0005, 0x2db: 0x0005, 0x2dc: 0x0005, 0x2dd: 0x0005,
	0x2de: 0x0005, 0x2df: 0x0005, 0x2e0: 0x0005, 0x2e1: 0x0005, 0x2e2: 0x0005, 0x2e3: 0x0005,
	0x2e4: 0x0005, 0x2e5: 0x0005, 0x2e6: 0x0005, 0x2e7: 0x0005, 0x2e8: 0x0005, 0x2e9: 0x0005,
	0x2ea: 0x0005, 0x2eb: 0x0005, 0x2ec: 0x0005, 0x2ed: 0x0005, 0x2ee: 0x0005, 0x2ef: 0x0005,
	0x2f0: 0x0005, 0x2f1: 0x0005, 0x2f2: 0x0005, 0x2f3: 0x0005, 0x2f4: 0x0004, 0x2f5: 0x0002,
	0x2f6: 0x0005, 0x2f7: 0x0005, 0x2fa: 0x0004, 0x2fb: 0x0005,
	0x2fc: 0x0005, 0x2fd: 0x0005, 0x2fe: 0x0004, 0x2ff: 0x0005,
	// Block 0xc, offset 0x300
	0x304: 0x0004, 0x305: 0x0004,
	0x306: 0x0005, 0x307: 0x0004, 0x308: 0x0005, 0x309: 0x0005, 0x30a: 0x0005,
	0x30c: 0x0005, 0x30e: 0x0005, 0x30f: 0x0005, 0x310: 0x0005, 0x311: 0x0005,
	0x312: 0x0005, 0x313: 0x0005, 0x314: 0x0005, 0x315: 0x0005, 0x316: 0x0005, 0x317: 0x0005,
	0x318: 0x0005, 0x319: 0x0005, 0x31a: 0x0005, 0x31b: 0x0005, 0x31c: 0x0005, 0x31d: 0x0005,
	0x31e: 0x0005, 0x31f: 0x0005, 0x320: 0x0005, 0x321: 0x0005, 0x323: 0x0005,
	0x324: 0x0005, 0x325: 0x0005, 0x326: 0x0005, 0x327: 0x0005, 0x328: 0x0005, 0x329: 0x0005,
	0x32a: 0x0005, 0x32b: 0x0005, 0x32c: 0x0005, 0x32d: 0x0005, 0x32e: 0x0005, 0x32f: 0x0005,
	0x330: 0x0005, 0x331: 0x0005, 0x332: 0x0005, 0x333: 0x0005, 0x334: 0x0005, 0x335: 0x0005,
	0x336: 0x0005, 0x337: 0x0005, 0x338: 0x0005, 0x339: 0x0005, 0x33a: 0x0005, 0x33b: 0x0005,
	0x33c: 0x0005, 0x33d: 0x0005, 0x33e: 0x0005, 0x33f: 0x0005,
	// Block 0xd, offset 0x340
	0x340: 0x0005, 0x341: 0x0005, 0x342: 0x0005, 0x343: 0x0005, 0x344: 0x0005, 0x345: 0x0005,
	0x346: 0x0005, 0x347: 0x0005, 0x348: 0x0005, 0x349: 0x0005, 0x34a: 0x0005, 0x34b: 0x0005,
	0x34c: 0x0005, 0x34d: 0x0005, 0x34e: 0x0005, 0x34f: 0x0005, 0x350: 0x0004, 0x351: 0x0004,
	0x352: 0x0004, 0x353: 0x0004, 0x354: 0x0004, 0x355: 0x0004, 0x356: 0x0004, 0x357: 0x0005,
	0x358: 0x0005, 0x359: 0x0005, 0x35a: 0x0005, 0x35b: 0x0005, 0x35c: 0x0005, 0x35d: 0x0005,
	0x35e: 0x0005, 0x35f: 0x0005, 0x360: 0x0005, 0x361: 0x0005, 0x362: 0x0005, 0x363: 0x0005,
	0x364: 0x0005, 0x365: 0x0005, 0x366: 0x0005, 0x367: 0x0005, 0x368: 0x0005, 0x369: 0x0005,
	0x36a: 0x0005, 0x36b: 0x0005, 0x36c: 0x0005, 0x36d: 0x0005, 0x36e: 0x0005, 0x36f: 0x0005,
	0x370: 0x0004, 0x371: 0x0004, 0x372: 0x0004, 0x373: 0x0005, 0x374: 0x0004, 0x375: 0x0004,
	0x376: 0x0004, 0x377: 0x0005, 0x378: 0x0005, 0x379: 0x0004, 0x37a: 0x0005, 0x37b: 0x0005,
	0x37c: 0x0005, 0x37d: 0x0005, 0x37e: 0x0005, 0x37f: 0x0005,
	// Block 0xe, offset 0x380
	0x380: 0x0005, 0x381: 0x0005, 0x382: 0x0004, 0x383: 0x0005, 0x384: 0x0005, 0x385: 0x0005,
	0x386: 0x0005, 0x387: 0x0005, 0x388: 0x0004, 0x389: 0x0004, 0x38a: 0x0005, 0x38b: 0x0005,
	0x38c: 0x0005, 0x38d: 0x0005, 0x38e: 0x0005, 0x38f: 0x0005, 0x390: 0x0005, 0x391: 0x0005,
	0x392: 0x0005, 0x393: 0x0005, 0x394: 0x0005, 0x395: 0x0005, 0x396: 0x0005, 0x397: 0x0005,
	0x398: 0x0005, 0x399: 0x0005, 0x39a: 0x0005, 0x39b: 0x0005, 0x39c: 0x0005, 0x39d: 0x0005,
	0x39e: 0x0005, 0x39f: 0x0005, 0x3a0: 0x0005, 0x3a1: 0x0005, 0x3a2: 0x0005, 0x3a3: 0x0005,
	0x3a4: 0x0005, 0x3a5: 0x0005, 0x3a6: 0x0005, 0x3a7: 0x0005, 0x3a8: 0x0005, 0x3a9: 0x0005,
	0x3aa: 0x0005, 0x3ab: 0x0005, 0x3ac: 0x0005, 0x3ad: 0x0005, 0x3ae: 0x0005, 0x3af: 0x0005,
	0x3b0: 0x0005, 0x3b1: 0x0005, 0x3b2: 0x0005, 0x3b3: 0x0005, 0x3b4: 0x0005, 0x3b5: 0x0005,
	0x3b6: 0x0005, 0x3b7: 0x0005, 0x3b8: 0x0005, 0x3b9: 0x0005, 0x3ba: 0x0005, 0x3bb: 0x0005,
	0x3bc: 0x0005, 0x3bd: 0x0005, 0x3be: 0x0005, 0x3bf: 0x0005,
	// Block 0xf, offset 0x3c0
	0x3c0: 0x0005, 0x3c1: 0x0005, 0x3c2: 0x0005, 0x3c3: 0x0005, 0x3c4: 0x0005, 0x3c5: 0x0005,
	0x3c6: 0x0005, 0x3c7: 0x0005, 0x3c8: 0x0005, 0x3c9: 0x0005, 0x3ca: 0x0005, 0x3cb: 0x0005,
	0x3cc: 0x0005, 0x3cd: 0x0005, 0x3ce: 0x0005, 0x3cf: 0x0005, 0x3d0: 0x0005, 0x3d1: 0x0005,
	0x3d2: 0x0005, 0x3d3: 0x0005, 0x3d4: 0x0005, 0x3d5: 0x0005, 0x3d6: 0x0005, 0x3d7: 0x0005,
	0x3d8: 0x0005, 0x3d9: 0x0005, 0x3da: 0x0005, 0x3db: 0x0005, 0x3dc: 0x0005, 0x3dd: 0x0005,
	0x3de: 0x0005, 0x3df: 0x0005, 0x3e0: 0x0005, 0x3e1: 0x0005, 0x3e2: 0x0005, 0x3e3: 0x0005,
	0x3e4: 0x0005, 0x3e5: 0x0005, 0x3e6: 0x0005, 0x3e7: 0x0005, 0x3e8: 0x0005, 0x3e9: 0x0005,
	0x3ea: 0x0005, 0x3eb: 0x0005, 0x3ec: 0x0005, 0x3ed: 0x0005, 0x3ee: 0x0005, 0x3ef: 0x0005,
	0x3f1: 0x0005, 0x3f2: 0x0005, 0x3f3: 0x0005, 0x3f4: 0x0005, 0x3f5: 0x0005,
	0x3f6: 0x0005, 0x3f7: 0x0005, 0x3f8: 0x0005, 0x3f9: 0x0005, 0x3fa: 0x0005, 0x3fb: 0x0005,
	0x3fc: 0x0005, 0x3fd: 0x0005, 0x3fe: 0x0005, 0x3ff: 0x0005,
	// Block 0x10, offset 0x400
	0x400: 0x0005, 0x401: 0x0005, 0x402: 0x0005, 0x403: 0x0005, 0x404: 0x0005, 0x405: 0x0005,
	0x406: 0x0005, 0x407: 0x0005, 0x408: 0x0005, 0x409: 0x0005, 0x40a: 0x0005, 0x40b: 0x0005,
	0x40c: 0x0005, 0x40d: 0x0005, 0x40e: 0x0005, 0x40f: 0x0005, 0x410: 0x0005, 0x411: 0x0005,
	0x412: 0x0005, 0x413: 0x0005, 0x414: 0x0005, 0x415: 0x0005, 0x416: 0x0005,
	0x419: 0x0005, 0x41a: 0x0004, 0x41b: 0x0004, 0x41c: 0x0004, 0x41d: 0x0004,
	0x41e: 0x0004, 0x41f: 0x0004, 0x421: 0x0005, 0x422: 0x0005, 0x423: 0x0005,
	0x424: 0x0005, 0x425: 0x0005, 0x426: 0x0005, 0x427: 0x0005, 0x428: 0x0005, 0x429: 0x0005,
	0x42a: 0x0005, 0x42b: 0x0005, 0x42c: 0x0005, 0x42d: 0x0005, 0x42e: 0x0005, 0x42f: 0x0005,
	0x430: 0x0005, 0x431: 0x0005, 0x432: 0x0005, 0x433: 0x0005, 0x434: 0x0005, 0x435: 0x0005,
	0x436: 0x0005, 0x437: 0x0005, 0x438: 0x0005, 0x439: 0x0005, 0x43a: 0x0005, 0x43b: 0x0005,
	0x43c: 0x0005, 0x43d: 0x0005, 0x43e: 0x0005, 0x43f: 0x0005,
	// Block 0x11, offset 0x440
	0x440: 0x0005, 0x441: 0x0005, 0x442: 0x0005, 0x443: 0x0005, 0x444: 0x0005, 0x445: 0x0005,
	0x446: 0x0005, 0x447: 0x0004, 0x449: 0x0004, 0x44a: 0x0004,
	0x44d: 0x0004, 0x44e: 0x0004, 0x44f: 0x0004, 0x451: 0x0005,
	0x452: 0x0005, 0x453: 0x0005, 0x454: 0x0005, 0x455: 0x0005, 0x456: 0x0005, 0x457: 0x0005,
	0x458: 0x0005, 0x459: 0x0005, 0x45a: 0x0005, 0x45b: 0x0005, 0x45c: 0x0005, 0x45d: 0x0005,
	0x45e: 0x0005, 0x45f: 0x0005, 0x460: 0x0005, 0x461: 0x0005, 0x462: 0x0005, 0x463: 0x0005,
	0x464: 0x0005, 0x465: 0x0005, 0x466: 0x0005, 0x467: 0x0005, 0x468: 0x0005, 0x469: 0x0005,
	0x46a: 0x0005, 0x46b: 0x0005, 0x46c: 0x0005, 0x46d: 0x0005, 0x46e: 0x0005, 0x46f: 0x0005,
	0x470: 0x0005, 0x471: 0x0005, 0x472: 0x0005, 0x473: 0x0005, 0x474: 0x0005, 0x475: 0x0005,
	0x476: 0x0005, 0x477: 0x0005, 0x478: 0x0005, 0x479: 0x0005, 0x47a: 0x0005, 0x47b: 0x0005,
	0x47c: 0x0005, 0x47d: 0x0005, 0x47e: 0x0004, 0x47f: 0x0005,
	// Block 0x12, offset 0x480
	0x480: 0x0004, 0x481: 0x0005, 0x482: 0x0005, 0x483: 0x0004, 0x484: 0x0005, 0x485: 0x0005,
	0x486: 0x0004, 0x487: 0x0005,
	0x490: 0x0005, 0x491: 0x0005,
	0x492: 0x0005, 0x493: 0x0005, 0x494: 0x0005, 0x495: 0x0005, 0x496: 0x0005, 0x497: 0x0005,
	0x498: 0x0005, 0x499: 0x0005, 0x49a: 0x0005, 0x49b: 0x0005, 0x49c: 0x0005, 0x49d: 0x0005,
	0x49e: 0x0005, 0x49f: 0x0005, 0x4a0: 0x0005, 0x4a1: 0x0005, 0x4a2: 0x0005, 0x4a3: 0x0005,
	0x4a4: 0x0005, 0x4a5: 0x0005, 0x4a6: 0x0005, 0x4a7: 0x0005, 0x4a8: 0x0005, 0x4a9: 0x0005,
	0x4aa: 0x0005,
	0x4b0: 0x0005, 0x4b1: 0x0005, 0x4b2: 0x0005, 0x4b3: 0x0002, 0x4b4: 0x0002,
	// Block 0x13, offset 0x4c0
	0x4c0: 0x0001, 0x4c1: 0x0001, 0x4c2: 0x0001, 0x4c3: 0x0001, 0x4c4: 0x0001, 0x4c5: 0x0001,
	0x4c6: 0x0004, 0x4c7: 0x0004, 0x4c8: 0x0004, 0x4c9: 0x0004, 0x4ca: 0x0004, 0x4cb: 0x0004,
	0x4cc: 0x0004, 0x4cd: 0x0004, 0x4ce: 0x0004, 0x4cf: 0x0004, 0x4d0: 0x0005, 0x4d1: 0x0005,
	0x4d2: 0x0005, 0x4d3: 0x0005, 0x4d4: 0x0005, 0x4d5: 0x0005, 0x4d6: 0x0005, 0x4d7: 0x0005,
	0x4d8: 0x0005, 0x4d9: 0x0005, 0x4da: 0x0005, 0x4db: 0x0004, 0x4dc: 0x0001,
	0x4de: 0x0004, 0x4df: 0x0004, 0x4e0: 0x0005, 0x4e1: 0x0005, 0x4e2: 0x0005, 0x4e3: 0x0005,
	0x4e4: 0x0005, 0x4e5: 0x0005, 0x4e6: 0x0005, 0x4e7: 0x0005, 0x4e8: 0x0005, 0x4e9: 0x0005,
	0x4ea: 0x0005, 0x4eb: 0x0005, 0x4ec: 0x0005, 0x4ed: 0x0005, 0x4ee: 0x0005, 0x4ef: 0x0005,
	0x4f0: 0x0005, 0x4f1: 0x0005, 0x4f2: 0x0005, 0x4f3: 0x0005, 0x4f4: 0x0005, 0x4f5: 0x0005,
	0x4f6: 0x0005, 0x4f7: 0x0005, 0x4f8: 0x0005, 0x4f9: 0x0005, 0x4fa: 0x0005, 0x4fb: 0x0005,
	0x4fc: 0x0005, 0x4fd: 0x0005, 0x4fe: 0x0005, 0x4ff: 0x0005,
	// Block 0x14, offset 0x500
	0x500: 0x0001, 0x501: 0x0005, 0x502: 0x0005, 0x503: 0x0005, 0x504: 0x0005, 0x505: 0x0005,
	0x506: 0x0005, 0x507: 0x0005, 0x508: 0x0005, 0x509: 0x0005, 0x50a: 0x0005, 0x50b: 0x0005,
	0x50c: 0x0005, 0x50d: 0x0005, 0x50e: 0x0005, 0x50f: 0x0005, 0x510: 0x0005, 0x511: 0x0005,
	0x512: 0x0005, 0x513: 0x0005, 0x514: 0x0005, 0x515: 0x0005, 0x516: 0x0005, 0x517: 0x0005,
	0x518: 0x0005, 0x519: 0x0005, 0x51a: 0x0005, 0x51b: 0x0005, 0x51c: 0x0005, 0x51d: 0x0005,
	0x51e: 0x0005, 0x51f: 0x0005, 0x520: 0x0002, 0x521: 0x0002, 0x522: 0x0002, 0x523: 0x0002,
	0x524: 0x0002, 0x525: 0x0002, 0x526: 0x0002, 0x527: 0x0002, 0x528: 0x0002, 0x529: 0x0002,
	0x52a: 0x0004, 0x52b: 0x0004, 0x52c: 0x0004, 0x52d: 0x0004, 0x52e: 0x0005, 0x52f: 0x0005,
	0x530: 0x0005, 0x531: 0x0005, 0x532: 0x0005, 0x533: 0x0005, 0x534: 0x0005, 0x535: 0x0004,
	0x536: 0x0004, 0x537: 0x0004, 0x538: 0x0004, 0x539: 0x0005, 0x53a: 0x0005, 0x53b: 0x0005,
	0x53c: 0x0005, 0x53d: 0x0005, 0x53e: 0x0005, 0x53f: 0x0005,
	// Block 0x15, offset 0x540
	0x540: 0x0005, 0x541: 0x0005, 0x542: 0x0005, 0x543: 0x0005, 0x544: 0x0005, 0x545: 0x0005,
	0x546: 0x0005, 0x547: 0x0005, 0x548: 0x0005, 0x549: 0x0005, 0x54a: 0x0005, 0x54b: 0x0005,
	0x54c: 0x0005, 0x54d: 0x0005, 0x54e: 0x0005, 0x54f: 0x0005, 0x550: 0x0005, 0x551: 0x0005,
	0x552: 0x0005, 0x553: 0x0005, 0x554: 0x0004, 0x555: 0x0005, 0x556: 0x0005, 0x557: 0x0005,
	0x558: 0x0005, 0x559: 0x0005, 0x55a: 0x0005, 0x55b: 0x0005, 0x55c: 0x0005, 0x55d: 0x0001,
	0x55e: 0x0004, 0x55f: 0x0005, 0x560: 0x0005, 0x561: 0x0005, 0x562: 0x0005, 0x563: 0x0005,
	0x564: 0x0005, 0x565: 0x0005, 0x566: 0x0005, 0x567: 0x0005, 0x568: 0x0005, 0x569: 0x0004,
	0x56a: 0x0005, 0x56b: 0x0005, 0x56c: 0x0005, 0x56d: 0x0005, 0x56e: 0x0005, 0x56f: 0x0005,
	0x570: 0x0002, 0x571: 0x0002, 0x572: 0x0002, 0x573: 0x0002, 0x574: 0x0002, 0x575: 0x0002,
	0x576: 0x0002, 0x577: 0x0002, 0x578: 0x0002, 0x579: 0x0002, 0x57a: 0x0005, 0x57b: 0x0005,
	0x57c: 0x0005, 0x57d: 0x0005, 0x57e: 0x0005, 0x57f: 0x0005,
	// Block 0x16, offset 0x580
	0x580: 0x0004, 0x581: 0x0004, 0x582: 0x0004, 0x583: 0x0004, 0x584: 0x0004, 0x585: 0x0004,
	0x586: 0x0004, 0x587: 0x0004, 0x588: 0x0004, 0x589: 0x0004, 0x58a: 0x0004, 0x58b: 0x0004,
	0x58c: 0x0004, 0x58d: 0x0004, 0x58f: 0x0001, 0x590: 0x0005, 0x591: 0x0005,
	0x592: 0x0005, 0x593: 0x0005, 0x594: 0x0005, 0x595: 0x0005, 0x596: 0x0005, 0x597: 0x0005,
	0x598: 0x0005, 0x599: 0x0005, 0x59a: 0x0005, 0x59b: 0x0005, 0x59c: 0x0005, 0x59d: 0x0005,
	0x59e: 0x0005, 0x59f: 0x0005, 0x5a0: 0x0005, 0x5a1: 0x0005, 0x5a2: 0x0005, 0x5a3: 0x0005,
	0x5a4: 0x0005, 0x5a5: 0x0005, 0x5a6: 0x0005, 0x5a7: 0x0005, 0x5a8: 0x0005, 0x5a9: 0x0005,
	0x5aa: 0x0005, 0x5ab: 0x0005, 0x5ac: 0x0005, 0x5ad: 0x0005, 0x5ae: 0x0005, 0x5af: 0x0005,
	0x5b0: 0x0005, 0x5b1: 0x0005, 0x5b2: 0x0005, 0x5b3: 0x0005, 0x5b4: 0x0005, 0x5b5: 0x0005,
	0x5b6: 0x0005, 0x5b7: 0x0005, 0x5b8: 0x0005, 0x5b9: 0x0005, 0x5ba: 0x0005, 0x5bb: 0x0005,
	0x5bc: 0x0005, 0x5bd: 0x0005, 0x5be: 0x0005, 0x5bf: 0x0005,
	// Block 0x17, offset 0x5c0
	0x5c0: 0x0005, 0x5c1: 0x0005, 0x5c2: 0x0005, 0x5c3: 0x0005, 0x5c4: 0x0005, 0x5c5: 0x0005,
	0x5c6: 0x0005, 0x5c7: 0x0005, 0x5c8: 0x0005, 0x5c9: 0x0005, 0x5ca: 0x0005,
	0x5cd: 0x0005, 0x5ce: 0x0005, 0x5cf: 0x0005, 0x5d0: 0x0005, 0x5d1: 0x0005,
	0x5d2: 0x0005, 0x5d3: 0x0005, 0x5d4: 0x0005, 0x5d5: 0x0005, 0x5d6: 0x0005, 0x5d7: 0x0005,
	0x5d8: 0x0005, 0x5d9: 0x0005, 0x5da: 0x0005, 0x5db: 0x0005, 0x5dc: 0x0005, 0x5dd: 0x0005,
	0x5de: 0x0005, 0x5df: 0x0005, 0x5e0: 0x0005, 0x5e1: 0x0005, 0x5e2: 0x0005, 0x5e3: 0x0005,
	0x5e4: 0x0005, 0x5e5: 0x0005, 0x5e6: 0x0005, 0x5e7: 0x0005, 0x5e8: 0x0005, 0x5e9: 0x0005,
	0x5ea: 0x0005, 0x5eb: 0x0005, 0x5ec: 0x0005, 0x5ed: 0x0005, 0x5ee: 0x0005, 0x5ef: 0x0005,
	0x5f0: 0x0005, 0x5f1: 0x0005, 0x5f2: 0x0005, 0x5f3: 0x0005, 0x5f4: 0x0005, 0x5f5: 0x0005,
	0x5f6: 0x0005, 0x5f7: 0x0005, 0x5f8: 0x0005, 0x5f9: 0x0005, 0x5fa: 0x0005, 0x5fb: 0x0005,
	0x5fc: 0x0005, 0x5fd: 0x0005, 0x5fe: 0x0005, 0x5ff: 0x0005,
	// Block 0x18, offset 0x600
	0x600: 0x0005, 0x601: 0x0005, 0x602: 0x0005, 0x603: 0x0005, 0x604: 0x0005, 0x605: 0x0005,
	0x606: 0x0005, 0x607: 0x0005, 0x608: 0x0005, 0x609: 0x0005, 0x60a: 0x0005, 0x60b: 0x0005,
	0x60c: 0x0005, 0x60d: 0x0005, 0x60e: 0x0005, 0x60f: 0x0005, 0x610: 0x0005, 0x611: 0x0005,
	0x612: 0x0005, 0x613: 0x0005, 0x614: 0x0005, 0x615: 0x0005, 0x616: 0x0005, 0x617: 0x0005,
	0x618: 0x0005, 0x619: 0x0005, 0x61a: 0x0005, 0x61b: 0x0005, 0x61c: 0x0005, 0x61d: 0x0005,
	0x61e: 0x0005, 0x61f: 0x0005, 0x620: 0x0005, 0x621: 0x0005, 0x622: 0x0005, 0x623: 0x0005,
	0x624: 0x0005, 0x625: 0x0005, 0x626: 0x0005, 0x627: 0x0005, 0x628: 0x0005, 0x629: 0x0005,
	0x62a: 0x0005, 0x62b: 0x0005, 0x62c: 0x0005, 0x62d: 0x0005, 0x62e: 0x0005, 0x62f: 0x0005,
	0x630: 0x0005, 0x631: 0x0005,
	// Block 0x19, offset 0x640
	0x640: 0x0005, 0x641: 0x0005, 0x642: 0x0005, 0x643: 0x0005, 0x644: 0x0005, 0x645: 0x0005,
	0x646: 0x0005, 0x647: 0x0005, 0x648: 0x0005, 0x649: 0x0005, 0x64a: 0x0005, 0x64b: 0x0005,
	0x64c: 0x0005, 0x64d: 0x0005, 0x64e: 0x0005, 0x64f: 0x0005, 0x650: 0x0005, 0x651: 0x0005,
	0x652: 0x0005, 0x653: 0x0005, 0x654: 0x0005, 0x655: 0x0005, 0x656: 0x0005, 0x657: 0x0005,
	0x658: 0x0005, 0x659: 0x0005, 0x65a: 0x0005, 0x65b: 0x0005, 0x65c: 0x0005, 0x65d: 0x0005,
	0x65e: 0x0005, 0x65f: 0x0005, 0x660: 0x0005, 0x661: 0x0005, 0x662: 0x0005, 0x663: 0x0005,
	0x664: 0x0005, 0x665: 0x0005, 0x666: 0x0005, 0x667: 0x0005, 0x668: 0x0005, 0x669: 0x0005,
	0x66a: 0x0005, 0x66b: 0x0005, 0x66c: 0x0005, 0x66d: 0x0005, 0x66e: 0x0005, 0x66f: 0x0005,
	0x670: 0x0005, 0x671: 0x0005, 0x672: 0x0005, 0x673: 0x0005, 0x674: 0x0005, 0x675: 0x0005,
	0x676: 0x0004, 0x677: 0x0004, 0x678: 0x0004, 0x679: 0x0004, 0x67a: 0x0001,
	// Block 0x1a, offset 0x680
	0x680: 0x0005, 0x681: 0x0005, 0x682: 0x0005, 0x683: 0x0005, 0x684: 0x0005, 0x685: 0x0005,
	0x686: 0x0005, 0x687: 0x0005, 0x688: 0x0005, 0x689: 0x0005, 0x68a: 0x0005, 0x68b: 0x0005,
	0x68c: 0x0005, 0x68d: 0x0005, 0x68e: 0x0005, 0x68f: 0x0005, 0x690: 0x0005, 0x691: 0x0005,
	0x692: 0x0005, 0x693: 0x0005, 0x694: 0x0005, 0x695: 0x0005, 0x696: 0x0005, 0x697: 0x0005,
	0x698: 0x0005, 0x699: 0x0005, 0x69a: 0x0005, 0x69b: 0x0005, 0x69c: 0x0005, 0x69d: 0x0005,
	0x69e: 0x0005, 0x69f: 0x0005, 0x6a0: 0x0005, 0x6a1: 0x0005, 0x6a2: 0x0005, 0x6a3: 0x0005,
	0x6a4: 0x0005, 0x6a5: 0x0005, 0x6a6: 0x0005, 0x6a7: 0x0005, 0x6a8: 0x0005, 0x6a9: 0x0005,
	0x6aa: 0x0005, 0x6ab: 0x0005, 0x6ac: 0x0005, 0x6ad: 0x0005,
	0x6b0: 0x0004, 0x6b1: 0x0004, 0x6b2: 0x0004, 0x6b3: 0x0004, 0x6b4: 0x0004, 0x6b5: 0x0004,
	0x6b6: 0x0004, 0x6b7: 0x0004, 0x6b8: 0x0004, 0x6b9: 0x0004, 0x6ba: 0x0004, 0x6bb: 0x0004,
	0x6bc: 0x0004, 0x6bd: 0x0004, 0x6be: 0x0004,
	// Block 0x1b, offset 0x6c0
	0x6c0: 0x0005, 0x6c1: 0x0005, 0x6c2: 0x0005, 0x6c3: 0x0005, 0x6c4: 0x0005, 0x6c5: 0x0005,
	0x6c6: 0x0005, 0x6c7: 0x0005, 0x6c8: 0x0005, 0x6c9: 0x0005, 0x6ca: 0x0005, 0x6cb: 0x0005,
	0x6cc: 0x0005, 0x6cd: 0x0005, 0x6ce: 0x0005, 0x6cf: 0x0005, 0x6d0: 0x0005, 0x6d1: 0x0005,
	0x6d2: 0x0005, 0x6d3: 0x0005, 0x6d4: 0x0005, 0x6d5: 0x0005, 0x6d6: 0x0005, 0x6d7: 0x0005,
	0x6d8: 0x0005, 0x6d9: 0x0005, 0x6da: 0x0005, 0x6db: 0x0005,
	0x6de: 0x0004,
	// Block 0x1c, offset 0x700
	0x720: 0x0005, 0x721: 0x0005, 0x722: 0x0005, 0x723: 0x0005,
	0x724: 0x0005, 0x725: 0x0005, 0x726: 0x0005, 0x727: 0x0005, 0x728: 0x0005, 0x729: 0x0005,
	0x72a: 0x0005, 0x72b: 0x0005, 0x72c: 0x0005, 0x72d: 0x0005, 0x72e: 0x0005, 0x72f: 0x0005,
	0x730: 0x0005, 0x731: 0x0005, 0x732: 0x0005, 0x733: 0x0005, 0x734: 0x0005,
	// Block 0x1d, offset 0x740
	0x763: 0x0005,
	0x764: 0x0005, 0x765: 0x0005, 0x766: 0x0005, 0x767: 0x0005, 0x768: 0x0005, 0x769: 0x0005,
	0x76a: 0x0005, 0x76b: 0x0005, 0x76c: 0x0005, 0x76d: 0x0005, 0x76e: 0x0005, 0x76f: 0x0005,
	0x770: 0x0005, 0x771: 0x0005, 0x772: 0x0005, 0x773: 0x0005, 0x774: 0x0005, 0x775: 0x0005,
	0x776: 0x0005, 0x777: 0x0005, 0x778: 0x0005, 0x779: 0x0005, 0x77a: 0x0005, 0x77b: 0x0005,
	0x77c: 0x0005, 0x77d: 0x0005, 0x77e: 0x0005, 0x77f: 0x0005,
	// Block 0x1e, offset 0x780
	0x780: 0x0005, 0x781: 0x0005, 0x782: 0x0005, 0x783: 0x0005, 0x784: 0x0005, 0x785: 0x0005,
	0x786: 0x0005, 0x787: 0x0005, 0x788: 0x0005, 0x789: 0x0005, 0x78a: 0x0005, 0x78b: 0x0005,
	0x78c: 0x0005, 0x78d: 0x0005, 0x78e: 0x0005, 0x78f: 0x0005, 0x790: 0x0005, 0x791: 0x0005,
	0x792: 0x0005, 0x793: 0x0005, 0x794: 0x0005, 0x795: 0x0005, 0x796: 0x0005, 0x797: 0x0005,
	0x798: 0x0004, 0x799: 0x0004, 0x79a: 0x0004, 0x79b: 0x0004, 0x79c: 0x0004, 0x79d: 0x0004,
	0x79e: 0x0004, 0x79f: 0x0004, 0x7a0: 0x0005, 0x7a1: 0x0005, 0x7a2: 0x0005, 0x7a3: 0x0005,
	0x7a4: 0x0004, 0x7a5: 0x0004, 0x7a6: 0x0005, 0x7a7: 0x0005, 0x7a8: 0x0005, 0x7a9: 0x0005,
	0x7aa: 0x0005, 0x7ab: 0x0005, 0x7ac: 0x0005, 0x7ad: 0x0005, 0x7ae: 0x0005, 0x7af: 0x0005,
	0x7b0: 0x0004, 0x7b1: 0x0005, 0x7b2: 0x0005, 0x7b3: 0x0005, 0x7b4: 0x0005, 0x7b5: 0x0005,
	0x7b6: 0x0005, 0x7b7: 0x0005, 0x7b8: 0x0005, 0x7b9: 0x0005, 0x7ba: 0x0005, 0x7bb: 0x0005,
	0x7bc: 0x0005, 0x7bd: 0x0005, 0x7be: 0x0005, 0x7bf: 0x0005,
	// Block 0x1f, offset 0x7c0
	0x7c0: 0x0005, 0x7c1: 0x0005, 0x7c2: 0x0005, 0x7c3: 0x0005, 0x7c5: 0x0005,
	0x7c6: 0x0005, 0x7c7: 0x0005, 0x7c8: 0x0005, 0x7c9: 0x0005, 0x7ca: 0x0005, 0x7cb: 0x0005,
	0x7cc: 0x0005, 0x7cf: 0x0005, 0x7d0: 0x0005,
	0x7d3: 0x0005, 0x7d4: 0x0005, 0x7d5: 0x0005, 0x7d6: 0x0005, 0x7d7: 0x0005,
	0x7d8: 0x0005, 0x7d9: 0x0005, 0x7da: 0x0005, 0x7db: 0x0005, 0x7dc: 0x0005, 0x7dd: 0x0005,
	0x7de: 0x0005, 0x7df: 0x0005, 0x7e0: 0x0005, 0x7e1: 0x0005, 0x7e2: 0x0005, 0x7e3: 0x0005,
	0x7e4: 0x0005, 0x7e5: 0x0005, 0x7e6: 0x0005, 0x7e7: 0x0005, 0x7e8: 0x0005,
	0x7ea: 0x0005, 0x7eb: 0x0005, 0x7ec: 0x0005, 0x7ed: 0x0005, 0x7ee: 0x0005, 0x7ef: 0x0005,
	0x7f0: 0x0005, 0x7f2: 0x0005,
	0x7f6: 0x0005, 0x7f7: 0x0005, 0x7f8: 0x0005, 0x7f9: 0x0005,
	0x7fc: 0x0005, 0x7fd: 0x0005, 0x7fe: 0x0005, 0x7ff: 0x0005,
	// Block 0x20, offset 0x800
	0x800: 0x0005, 0x801: 0x0005, 0x802: 0x0005, 0x803: 0x0005, 0x804: 0x0005,
	0x807: 0x0005, 0x808: 0x0005, 0x80b: 0x0005,
	0x80c: 0x0005, 0x80d: 0x0005, 0x80e: 0x0005,
	0x817: 0x0005,
	0x81c: 0x0004, 0x81d: 0x0004,
	0x81f: 0x0004, 0x820: 0x0005, 0x821: 0x0005, 0x822: 0x0005, 0x823: 0x0005,
	0x826: 0x0005, 0x827: 0x0005, 0x828: 0x0005, 0x829: 0x0005,
	0x82a: 0x0005, 0x82b: 0x0005, 0x82c: 0x0005, 0x82d: 0x0005, 0x82e: 0x0005, 0x82f: 0x0005,
	0x830: 0x0005, 0x831: 0x0005, 0x832: 0x0004, 0x833: 0x0004, 0x834: 0x0004, 0x835: 0x0004,
	0x836: 0x0004, 0x837: 0x0004, 0x838: 0x0004, 0x839: 0x0004, 0x83a: 0x0004, 0x83b: 0x0004,
	// Block 0x21, offset 0x840
	0x841: 0x0005, 0x842: 0x0005, 0x843: 0x0005, 0x845: 0x0005,
	0x846: 0x0005, 0x847: 0x0005, 0x848: 0x0005, 0x849: 0x0005, 0x84a: 0x0005,
	0x84f: 0x0005, 0x850: 0x0005,
	0x853: 0x0005, 0x854: 0x0005, 0x855: 0x0005, 0x856: 0x0005, 0x857: 0x0005,
	0x858: 0x0005, 0x859: 0x0005, 0x85a: 0x0005, 0x85b: 0x0005, 0x85c: 0x0005, 0x85d: 0x0005,
	0x85e: 0x0005, 0x85f: 0x0005, 0x860: 0x0005, 0x861: 0x0005, 0x862: 0x0005, 0x863: 0x0005,
	0x864: 0x0005, 0x865: 0x0005, 0x866: 0x0005, 0x867: 0x0005, 0x868: 0x0005,
	0x86a: 0x0005, 0x86b: 0x0005, 0x86c: 0x0005, 0x86d: 0x0005, 0x86e: 0x0005, 0x86f: 0x0005,
	0x870: 0x0005, 0x872: 0x0005, 0x873: 0x0004, 0x875: 0x0005,
	0x876: 0x0004, 0x878: 0x0005, 0x879: 0x0005,
	0x87c: 0x0005, 0x87e: 0x0005, 0x87f: 0x0005,
	// Block 0x22, offset 0x880
	0x880: 0x0005, 0x881: 0x0005, 0x882: 0x0005,
	0x887: 0x0005, 0x888: 0x0005, 0x88b: 0x0005,
	0x88c: 0x0005, 0x88d: 0x0005, 0x891: 0x0005,
	0x899: 0x0004, 0x89a: 0x0004, 0x89b: 0x0004, 0x89c: 0x0005,
	0x89e: 0x0004,
	0x8a6: 0x0005, 0x8a7: 0x0005, 0x8a8: 0x0005, 0x8a9: 0x0005,
	0x8aa: 0x0005, 0x8ab: 0x0005, 0x8ac: 0x0005, 0x8ad: 0x0005, 0x8ae: 0x0005, 0x8af: 0x0005,
	0x8b0: 0x0005, 0x8b1: 0x0005, 0x8b2: 0x0005, 0x8b3: 0x0005, 0x8b4: 0x0005, 0x8b5: 0x0005,
	// Block 0x23, offset 0x8c0
	0x8c1: 0x0005, 0x8c2: 0x0005, 0x8c3: 0x0005, 0x8c5: 0x0005,
	0x8c6: 0x0005, 0x8c7: 0x0005, 0x8c8: 0x0005, 0x8c9: 0x0005, 0x8ca: 0x0005, 0x8cb: 0x0005,
	0x8cc: 0x0005, 0x8cd: 0x0005, 0x8cf: 0x0005, 0x8d0: 0x0005, 0x8d1: 0x0005,
	0x8d3: 0x0005, 0x8d4: 0x0005, 0x8d5: 0x0005, 0x8d6: 0x0005, 0x8d7: 0x0005,
	0x8d8: 0x0005, 0x8d9: 0x0005, 0x8da: 0x0005, 0x8db: 0x0005, 0x8dc: 0x0005, 0x8dd: 0x0005,
	0x8de: 0x0005, 0x8df: 0x0005, 0x8e0: 0x0005, 0x8e1: 0x0005, 0x8e2: 0x0005, 0x8e3: 0x0005,
	0x8e4: 0x0005, 0x8e5: 0x0005, 0x8e6: 0x0005, 0x8e7: 0x0005, 0x8e8: 0x0005,
	0x8ea: 0x0005, 0x8eb: 0x0005, 0x8ec: 0x0005, 0x8ed: 0x0005, 0x8ee: 0x0005, 0x8ef: 0x0005,
	0x8f0: 0x0005, 0x8f2: 0x0005, 0x8f3: 0x0005, 0x8f5: 0x0005,
	0x8f6: 0x0005, 0x8f7: 0x0005, 0x8f8: 0x0005, 0x8f9: 0x0005,
	0x8fc: 0x0005, 0x8fd: 0x0005, 0x8fe: 0x0005, 0x8ff: 0x0005,
	// Block 0x24, offset 0x900
	0x900: 0x0005, 0x901: 0x0005, 0x902: 0x0005, 0x903: 0x0005, 0x904: 0x0005, 0x905: 0x0005,
	0x907: 0x0005, 0x908: 0x0005, 0x909: 0x0005, 0x90b: 0x0005,
	0x90c: 0x0005, 0x90d: 0x0005, 0x910: 0x0005,
	0x920: 0x0005, 0x921: 0x0005, 0x922: 0x0005, 0x923: 0x0005,
	0x926: 0x0005, 0x927: 0x0005, 0x928: 0x0005, 0x929: 0x0005,
	0x92a: 0x0005, 0x92b: 0x0005, 0x92c: 0x0005, 0x92d: 0x0005, 0x92e: 0x0005, 0x92f: 0x0005,
	0x930: 0x0004, 0x931: 0x0004,
	0x939: 0x0005,
	// Block 0x25, offset 0x940
	0x941: 0x0005, 0x942: 0x0005, 0x943: 0x0005, 0x945: 0x0005,
	0x946: 0x0005, 0x947: 0x0005, 0x948: 0x0005, 0x949: 0x0005, 0x94a: 0x0005, 0x94b: 0x0005,
	0x94c: 0x0005, 0x94f: 0x0005, 0x950: 0x0005,
	0x953: 0x0005, 0x954: 0x0005, 0x955: 0x0005, 0x956: 0x0005, 0x957: 0x0005,
	0x958: 0x0005, 0x959: 0x0005, 0x95a: 0x0005, 0x95b: 0x0005, 0x95c: 0x0005, 0x95d: 0x0005,
	0x95e: 0x0005, 0x95f: 0x0005, 0x960: 0x0005, 0x961: 0x0005, 0x962: 0x0005, 0x963: 0x0005,
	0x964: 0x0005, 0x965: 0x0005, 0x966: 0x0005, 0x967: 0x0005, 0x968: 0x0005,
	0x96a: 0x0005, 0x96b: 0x0005, 0x96c: 0x0005, 0x96d: 0x0005, 0x96e: 0x0005, 0x96f: 0x0005,
	0x970: 0x0005, 0x972: 0x0005, 0x973: 0x0005, 0x975: 0x0005,
	0x976: 0x0005, 0x977: 0x0005, 0x978: 0x0005, 0x979: 0x0005,
	0x97c: 0x0005, 0x97d: 0x0005, 0x97e: 0x0005, 0x97f: 0x0005,
	// Block 0x26, offset 0x980
	0x980: 0x0005, 0x981: 0x0005, 0x982: 0x0005, 0x983: 0x0005, 0x984: 0x0005,
	0x987: 0x0005, 0x988: 0x0005, 0x98b: 0x0005,
	0x98c: 0x0005, 0x98d: 0x0005,
	0x996: 0x0005, 0x997: 0x0005,
	0x99c: 0x0004, 0x99d: 0x0004,
	0x99f: 0x0005, 0x9a0: 0x0005, 0x9a1: 0x0005, 0x9a2: 0x0005, 0x9a3: 0x0005,
	0x9a6: 0x0005, 0x9a7: 0x0005, 0x9a8: 0x0005, 0x9a9: 0x0005,
	0x9aa: 0x0005, 0x9ab: 0x0005, 0x9ac: 0x0005, 0x9ad: 0x0005, 0x9ae: 0x0005, 0x9af: 0x0005,
	0x9b0: 0x0004, 0x9b1: 0x0005, 0x9b2: 0x0004, 0x9b3: 0x0004, 0x9b4: 0x0004, 0x9b5: 0x0004,
	0x9b6: 0x0004, 0x9b7: 0x0004,
	// Block 0x27, offset 0x9c0
	0x9c2: 0x0005, 0x9c3: 0x0005, 0x9c5: 0x0005,
	0x9c6: 0x0005, 0x9c7: 0x0005, 0x9c8: 0x0005, 0x9c9: 0x0005, 0x9ca: 0x0005,
	0x9ce: 0x0005, 0x9cf: 0x0005, 0x9d0: 0x0005,
	0x9d2: 0x0005, 0x9d3: 0x0005, 0x9d4: 0x0005, 0x9d5: 0x0005,
	0x9d9: 0x0005, 0x9da: 0x0005, 0x9dc: 0x0005,
	0x9de: 0x0005, 0x9df: 0x0005, 0x9e3: 0x0005,
	0x9e4: 0x0005, 0x9e8: 0x0005, 0x9e9: 0x0005,
	0x9ea: 0x0005, 0x9ee: 0x0005, 0x9ef: 0x0005,
	0x9f0: 0x0005, 0x9f1: 0x0005, 0x9f2: 0x0005, 0x9f3: 0x0005, 0x9f4: 0x0005, 0x9f5: 0x0005,
	0x9f6: 0x0005, 0x9f7: 0x0005, 0x9f8: 0x0005, 0x9f9: 0x0005,
	0x9fe: 0x0005, 0x9ff: 0x0005,
	// Block 0x28, offset 0xa00
	0xa00: 0x0005, 0xa01: 0x0005, 0xa02: 0x0005,
	0xa06: 0x0005, 0xa07: 0x0005, 0xa08: 0x0005, 0xa0a: 0x0005, 0xa0b: 0x0005,
	0xa0c: 0x0005, 0xa0d: 0x0005, 0xa10: 0x0005,
	0xa17: 0x0005,
	0xa26: 0x0005, 0xa27: 0x0005, 0xa28: 0x0005, 0xa29: 0x0005,
	0xa2a: 0x0005, 0xa2b: 0x0005, 0xa2c: 0x0005, 0xa2d: 0x0005, 0xa2e: 0x0005, 0xa2f: 0x0005,
	0xa30: 0x0004, 0xa31: 0x0004, 0xa32: 0x0004, 0xa33: 0x0004, 0xa34: 0x0004, 0xa35: 0x0004,
	0xa36: 0x0004, 0xa37: 0x0004, 0xa38: 0x0004, 0xa39: 0x0004, 0xa3a: 0x0004,
	// Block 0x29, offset 0xa40
	0xa40: 0x0005, 0xa41: 0x0005, 0xa42: 0x0005, 0xa43: 0x0005, 0xa45: 0x0005,
	0xa46: 0x0005, 0xa47: 0x0005, 0xa48: 0x0005, 0xa49: 0x0005, 0xa4a: 0x0005, 0xa4b: 0x0005,
	0xa4c: 0x0005, 0xa4e: 0x0005, 0xa4f: 0x0005, 0xa50: 0x0005,
	0xa52: 0x0005, 0xa53: 0x0005, 0xa54: 0x0005, 0xa55: 0x0005, 0xa56: 0x0005, 0xa57: 0x0005,
	0xa58: 0x0005, 0xa59: 0x0005, 0xa5a: 0x0005, 0xa5b: 0x0005, 0xa5c: 0x0005, 0xa5d: 0x0005,
	0xa5e: 0x0005, 0xa5f: 0x0005, 0xa60: 0x0005, 0xa61: 0x0005, 0xa62: 0x0005, 0xa63: 0x0005,
	0xa64: 0x0005, 0xa65: 0x0005, 0xa66: 0x0005, 0xa67: 0x0005, 0xa68: 0x0005,
	0xa6a: 0x0005, 0xa6b: 0x0005, 0xa6c: 0x0005, 0xa6d: 0x0005, 0xa6e: 0x0005, 0xa6f: 0x0005,
	0xa70: 0x0005, 0xa71: 0x0005, 0xa72: 0x0005, 0xa73: 0x0005, 0xa74: 0x0005, 0xa75: 0x0005,
	0xa76: 0x0005, 0xa77: 0x0005, 0xa78: 0x0005, 0xa79: 0x0005,
	0xa7d: 0x0005, 0xa7e: 0x0005, 0xa7f: 0x0005,
	// Block 0x2a, offset 0xa80
	0xa80: 0x0005, 0xa81: 0x0005, 0xa82: 0x0005, 0xa83: 0x0005, 0xa84: 0x0005,
	0xa86: 0x0005, 0xa87: 0x0005, 0xa88: 0x0005, 0xa8a: 0x0005, 0xa8b: 0x0005,
	0xa8c: 0x0005, 0xa8d: 0x0005,
	0xa95: 0x0005, 0xa96: 0x0005,
	0xa98: 0x0005, 0xa99: 0x0005, 0xa9a: 0x0005,
	0xaa0: 0x0005, 0xaa1: 0x0005, 0xaa2: 0x0005, 0xaa3: 0x0005,
	0xaa6: 0x0005, 0xaa7: 0x0005, 0xaa8: 0x0005, 0xaa9: 0x0005,
	0xaaa: 0x0005, 0xaab: 0x0005, 0xaac: 0x0005, 0xaad: 0x0005, 0xaae: 0x0005, 0xaaf: 0x0005,
	0xab8: 0x0004, 0xab9: 0x0004, 0xaba: 0x0004, 0xabb: 0x0004,
	0xabc: 0x0004, 0xabd: 0x0004, 0xabe: 0x0004, 0xabf: 0x0004,
	// Block 0x2b, offset 0xac0
	0xac1: 0x0005, 0xac2: 0x0005, 0xac3: 0x0005, 0xac5: 0x0005,
	0xac6: 0x0005, 0xac7: 0x0005, 0xac8: 0x0005, 0xac9: 0x0005, 0xaca: 0x0005, 0xacb: 0x0005,
	0xacc: 0x0005, 0xace: 0x0005, 0xacf: 0x0005, 0xad0: 0x0005,
	0xad2: 0x0005, 0xad3: 0x0005, 0xad4: 0x0005, 0xad5: 0x0005, 0xad6: 0x0005, 0xad7: 0x0005,
	0xad8: 0x0005, 0xad9: 0x0005, 0xada: 0x0005, 0xadb: 0x0005, 0xadc: 0x0005, 0xadd: 0x0005,
	0xade: 0x0005, 0xadf: 0x0005, 0xae0: 0x0005, 0xae1: 0x0005, 0xae2: 0x0005, 0xae3: 0x0005,
	0xae4: 0x0005, 0xae5: 0x0005, 0xae6: 0x0005, 0xae7: 0x0005, 0xae8: 0x0005,
	0xaea: 0x0005, 0xaeb: 0x0005, 0xaec: 0x0005, 0xaed: 0x0005, 0xaee: 0x0005, 0xaef: 0x0005,
	0xaf0: 0x0005, 0xaf1: 0x0005, 0xaf2: 0x0005, 0xaf3: 0x0005, 0xaf5: 0x0005,
	0xaf6: 0x0005, 0xaf7: 0x0005, 0xaf8: 0x0005, 0xaf9: 0x0005,
	0xafc: 0x0005, 0xafd: 0x0005, 0xafe: 0x0005, 0xaff: 0x0005,
	// Block 0x2c, offset 0xb00
	0xb00: 0x0005, 0xb01: 0x0005, 0xb02: 0x0005, 0xb03: 0x0005, 0xb04: 0x0005,
	0xb06: 0x0005, 0xb07: 0x0005, 0xb08: 0x0005, 0xb0a: 0x0005, 0xb0b: 0x0005,
	0xb0c: 0x0005, 0xb0d: 0x0005,
	0xb15: 0x0005, 0xb16: 0x0005,
	0xb1e: 0x0005, 0xb20: 0x0005, 0xb21: 0x0005, 0xb22: 0x0005, 0xb23: 0x0005,
	0xb26: 0x0005, 0xb27: 0x0005, 0xb28: 0x0005, 0xb29: 0x0005,
	0xb2a: 0x0005, 0xb2b: 0x0005, 0xb2c: 0x0005, 0xb2d: 0x0005, 0xb2e: 0x0005, 0xb2f: 0x0005,
	0xb31: 0x0005, 0xb32: 0x0005,
	// Block 0x2d, offset 0xb40
	0xb41: 0x0005, 0xb42: 0x0005, 0xb43: 0x0005, 0xb45: 0x0005,
	0xb46: 0x0005, 0xb47: 0x0005, 0xb48: 0x0005, 0xb49: 0x0005, 0xb4a: 0x0005, 0xb4b: 0x0005,
	0xb4c: 0x0005, 0xb4e: 0x0005, 0xb4f: 0x0005, 0xb50: 0x0005,
	0xb52: 0x0005, 0xb53: 0x0005, 0xb54: 0x0005, 0xb55: 0x0005, 0xb56: 0x0005, 0xb57: 0x0005,
	0xb58: 0x0005, 0xb59: 0x0005, 0xb5a: 0x0005, 0xb5b: 0x0005, 0xb5c: 0x0005, 0xb5d: 0x0005,
	0xb5e: 0x0005, 0xb5f: 0x0005, 0xb60: 0x0005, 0xb61: 0x0005, 0xb62: 0x0005, 0xb63: 0x0005,
	0xb64: 0x0005, 0xb65: 0x0005, 0xb66: 0x0005, 0xb67: 0x0005, 0xb68: 0x0005, 0xb69: 0x0005,
	0xb6a: 0x0005, 0xb6b: 0x0005, 0xb6c: 0x0005, 0xb6d: 0x0005, 0xb6e: 0x0005, 0xb6f: 0x0005,
	0xb70: 0x0005, 0xb71: 0x0005, 0xb72: 0x0005, 0xb73: 0x0005, 0xb74: 0x0005, 0xb75: 0x0005,
	0xb76: 0x0005, 0xb77: 0x0005, 0xb78: 0x0005, 0xb79: 0x0005, 0xb7a: 0x0005,
	0xb7d: 0x0005, 0xb7e: 0x0005, 0xb7f: 0x0005,
	// Block 0x2e, offset 0xb80
	0xb80: 0x0005, 0xb81: 0x0005, 0xb82: 0x0005, 0xb83: 0x0005, 0xb84: 0x0005,
	0xb86: 0x0005, 0xb87: 0x0005, 0xb88: 0x0005, 0xb8a: 0x0005, 0xb8b: 0x0005,
	0xb8c: 0x0005, 0xb8d: 0x0005, 0xb8e: 0x0005,
	0xb97: 0x0005,
	0xb9f: 0x0005, 0xba0: 0x0005, 0xba1: 0x0005, 0xba2: 0x0005, 0xba3: 0x0005,
	0xba6: 0x0005, 0xba7: 0x0005, 0xba8: 0x0005, 0xba9: 0x0005,
	0xbaa: 0x0005, 0xbab: 0x0005, 0xbac: 0x0005, 0xbad: 0x0005, 0xbae: 0x0005, 0xbaf: 0x0005,
	0xbb0: 0x0004, 0xbb1: 0x0004, 0xbb2: 0x0004, 0xbb3: 0x0004, 0xbb4: 0x0004, 0xbb5: 0x0004,
	0xbb9: 0x0004, 0xbba: 0x0005, 0xbbb: 0x0005,
	0xbbc: 0x0005, 0xbbd: 0x0005, 0xbbe: 0x0005, 0xbbf: 0x0005,
	// Block 0x2f, offset 0xbc0
	0xbc2: 0x0005, 0xbc3: 0x0005, 0xbc5: 0x0005,
	0xbc6: 0x0005, 0xbc7: 0x0005, 0xbc8: 0x0005, 0xbc9: 0x0005, 0xbca: 0x0005, 0xbcb: 0x0005,
	0xbcc: 0x0005, 0xbcd: 0x0005, 0xbce: 0x0005, 0xbcf: 0x0005, 0xbd0: 0x0005, 0xbd1: 0x0005,
	0xbd2: 0x0005, 0xbd3: 0x0005, 0xbd4: 0x0005, 0xbd5: 0x0005, 0xbd6: 0x0005,
	0xbda: 0x0005, 0xbdb: 0x0005, 0xbdc: 0x0005, 0xbdd: 0x0005,
	0xbde: 0x0005, 0xbdf: 0x0005, 0xbe0: 0x0005, 0xbe1: 0x0005, 0xbe2: 0x0005, 0xbe3: 0x0005,
	0xbe4: 0x0005, 0xbe5: 0x0005, 0xbe6: 0x0005, 0xbe7: 0x0005, 0xbe8: 0x0005, 0xbe9: 0x0005,
	0xbea: 0x0005, 0xbeb: 0x0005, 0xbec: 0x0005, 0xbed: 0x0005, 0xbee: 0x0005, 0xbef: 0x0005,
	0xbf0: 0x0005, 0xbf1: 0x0005, 0xbf3: 0x0005, 0xbf4: 0x0005, 0xbf5: 0x0005,
	0xbf6: 0x0005, 0xbf7: 0x0005, 0xbf8: 0x0005, 0xbf9: 0x0005, 0xbfa: 0x0005, 0xbfb: 0x0005,
	0xbfd: 0x0005,
	// Block 0x30, offset 0xc00
	0xc00: 0x0005, 0xc01: 0x0005, 0xc02: 0x0005, 0xc03: 0x0005, 0xc04: 0x0005, 0xc05: 0x0005,
	0xc06: 0x0005, 0xc0a: 0x0005,
	0xc0f: 0x0005, 0xc10: 0x0005, 0xc11: 0x0005,
	0xc12: 0x0005, 0xc13: 0x0005, 0xc14: 0x0005, 0xc16: 0x0005,
	0xc18: 0x0005, 0xc19: 0x0005, 0xc1a: 0x0005, 0xc1b: 0x0005, 0xc1c: 0x0005, 0xc1d: 0x0005,
	0xc1e: 0x0005, 0xc1f: 0x0005,
	0xc26: 0x0005, 0xc27: 0x0005, 0xc28: 0x0005, 0xc29: 0x0005,
	0xc2a: 0x0005, 0xc2b: 0x0005, 0xc2c: 0x0005, 0xc2d: 0x0005, 0xc2e: 0x0005, 0xc2f: 0x0005,
	0xc32: 0x0005, 0xc33: 0x0005, 0xc34: 0x0004,
	// Block 0x31, offset 0xc40
	0xc41: 0x0005, 0xc42: 0x0005, 0xc43: 0x0005, 0xc44: 0x0005, 0xc45: 0x0005,
	0xc46: 0x0005, 0xc47: 0x0005, 0xc48: 0x0005, 0xc49: 0x0005, 0xc4a: 0x0005, 0xc4b: 0x0005,
	0xc4c: 0x0005, 0xc4d: 0x0005, 0xc4e: 0x0005, 0xc4f: 0x0005, 0xc50: 0x0005, 0xc51: 0x0005,
	0xc52: 0x0005, 0xc53: 0x0005, 0xc54: 0x0005, 0xc55: 0x0005, 0xc56: 0x0005, 0xc57: 0x0005,
	0xc58: 0x0005, 0xc59: 0x0005, 0xc5a: 0x0005, 0xc5b: 0x0005, 0xc5c: 0x0005, 0xc5d: 0x0005,
	0xc5e: 0x0005, 0xc5f: 0x0005, 0xc60: 0x0005, 0xc61: 0x0005, 0xc62: 0x0005, 0xc63: 0x0005,
	0xc64: 0x0005, 0xc65: 0x0005, 0xc66: 0x0005, 0xc67: 0x0005, 0xc68: 0x0005, 0xc69: 0x0005,
	0xc6a: 0x0005, 0xc6b: 0x0005, 0xc6c: 0x0005, 0xc6d: 0x0005, 0xc6e: 0x0005, 0xc6f: 0x0005,
	0xc70: 0x0005, 0xc71: 0x0005, 0xc72: 0x0005, 0xc73: 0x0004, 0xc74: 0x0005, 0xc75: 0x0005,
	0xc76: 0x0005, 0xc77: 0x0005, 0xc78: 0x0005, 0xc79: 0x0005, 0xc7a: 0x0005,
	0xc7f: 0x0004,
	// Block 0x32, offset 0xc80
	0xc80: 0x0005, 0xc81: 0x0005, 0xc82: 0x0005, 0xc83: 0x0005, 0xc84: 0x0005, 0xc85: 0x0005,
	0xc86: 0x0005, 0xc87: 0x0005, 0xc88: 0x0005, 0xc89: 0x0005, 0xc8a: 0x0005, 0xc8b: 0x0005,
	0xc8c: 0x0005, 0xc8d: 0x0005, 0xc8e: 0x0005, 0xc8f: 0x0004, 0xc90: 0x0005, 0xc91: 0x0005,
	0xc92: 0x0005, 0xc93: 0x0005, 0xc94: 0x0005, 0xc95: 0x0005, 0xc96: 0x0005, 0xc97: 0x0005,
	0xc98: 0x0005, 0xc99: 0x0005, 0xc9a: 0x0004, 0xc9b: 0x0004,
	// Block 0x33, offset 0xcc0
	0xcc1: 0x0005, 0xcc2: 0x0005, 0xcc4: 0x0005,
	0xcc7: 0x0005, 0xcc8: 0x0005, 0xcca: 0x0005,
	0xccd: 0x0005,
	0xcd4: 0x0005, 0xcd5: 0x0005, 0xcd6: 0x0005, 0xcd7: 0x0005,
	0xcd9: 0x0005, 0xcda: 0x0005, 0xcdb: 0x0005, 0xcdc: 0x0005, 0xcdd: 0x0005,
	0xcde: 0x0005, 0xcdf: 0x0005, 0xce1: 0x0005, 0xce2: 0x0005, 0xce3: 0x0005,
	0xce5: 0x0005, 0xce7: 0x0005,
	0xcea: 0x0005, 0xceb: 0x0005, 0xced: 0x0005, 0xcee: 0x0005, 0xcef: 0x0005,
	0xcf0: 0x0005, 0xcf1: 0x0005, 0xcf2: 0x0005, 0xcf3: 0x0004, 0xcf4: 0x0005, 0xcf5: 0x0005,
	0xcf6: 0x0005, 0xcf7: 0x0005, 0xcf8: 0x0005, 0xcf9: 0x0005, 0xcfb: 0x0005,
	0xcfc: 0x0005, 0xcfd: 0x0005,
	// Block 0x34, offset 0xd00
	0xd00: 0x0005, 0xd01: 0x0005, 0xd02: 0x0005, 0xd03: 0x0005, 0xd04: 0x0005,
	0xd06: 0x0005, 0xd08: 0x0005, 0xd09: 0x0005, 0xd0a: 0x0005, 0xd0b: 0x0005,
	0xd0c: 0x0005, 0xd0d: 0x0005, 0xd10: 0x0005, 0xd11: 0x0005,
	0xd12: 0x0005, 0xd13: 0x0005, 0xd14: 0x0005, 0xd15: 0x0005, 0xd16: 0x0005, 0xd17: 0x0005,
	0xd18: 0x0005, 0xd19: 0x0005, 0xd1c: 0x0004, 0xd1d: 0x0004,
	0xd1e: 0x0005, 0xd1f: 0x0005,
	// Block 0x35, offset 0xd40
	0xd40: 0x0005, 0xd41: 0x0004, 0xd42: 0x0004, 0xd43: 0x0004, 0xd44: 0x0004, 0xd45: 0x0004,
	0xd46: 0x0004, 0xd47: 0x0004, 0xd48: 0x0004, 0xd49: 0x0004, 0xd4a: 0x0004, 0xd4b: 0x0005,
	0xd4c: 0x0004, 0xd4d: 0x0004, 0xd4e: 0x0004, 0xd4f: 0x0004, 0xd50: 0x0004, 0xd51: 0x0004,
	0xd52: 0x0004, 0xd53: 0x0004, 0xd54: 0x0004, 0xd55: 0x0004, 0xd56: 0x0004, 0xd57: 0x0004,
	0xd58: 0x0005, 0xd59: 0x0005, 0xd5a: 0x0004, 0xd5b: 0x0004, 0xd5c: 0x0004, 0xd5d: 0x0004,
	0xd5e: 0x0004, 0xd5f: 0x0004, 0xd60: 0x0005, 0xd61: 0x0005, 0xd62: 0x0005, 0xd63: 0x0005,
	0xd64: 0x0005, 0xd65: 0x0005, 0xd66: 0x0005, 0xd67: 0x0005, 0xd68: 0x0005, 0xd69: 0x0005,
	0xd6a: 0x0004, 0xd6b: 0x0004, 0xd6c: 0x0004, 0xd6d: 0x0004, 0xd6e: 0x0004, 0xd6f: 0x0004,
	0xd70: 0x0004, 0xd71: 0x0004, 0xd72: 0x0004, 0xd73: 0x0004, 0xd74: 0x0004, 0xd75: 0x0005,
	0xd76: 0x0004, 0xd77: 0x0005, 0xd78: 0x0004, 0xd79: 0x0005, 0xd7a: 0x0004, 0xd7b: 0x0004,
	0xd7c: 0x0004, 0xd7d: 0x0004, 0xd7e: 0x0005, 0xd7f: 0x0005,
	// Block 0x36, offset 0xd80
	0xd80: 0x0005, 0xd81: 0x0005, 0xd82: 0x0005, 0xd83: 0x0004, 0xd84: 0x0005, 0xd85: 0x0005,
	0xd86: 0x0005, 0xd87: 0x0005, 0xd89: 0x0005, 0xd8a: 0x0005, 0xd8b: 0x0005,
	0xd8c: 0x0005, 0xd8d: 0x0004, 0xd8e: 0x0005, 0xd8f: 0x0005, 0xd90: 0x0005, 0xd91: 0x0005,
	0xd92: 0x0004, 0xd93: 0x0005, 0xd94: 0x0005, 0xd95: 0x0005, 0xd96: 0x0005, 0xd97: 0x0004,
	0xd98: 0x0005, 0xd99: 0x0005, 0xd9a: 0x0005, 0xd9b: 0x0005, 0xd9c: 0x0004, 0xd9d: 0x0005,
	0xd9e: 0x0005, 0xd9f: 0x0005, 0xda0: 0x0005, 0xda1: 0x0005, 0xda2: 0x0005, 0xda3: 0x0005,
	0xda4: 0x0005, 0xda5: 0x0005, 0xda6: 0x0005, 0xda7: 0x0005, 0xda8: 0x0005, 0xda9: 0x0004,
	0xdaa: 0x0005, 0xdab: 0x0005, 0xdac: 0x0005,
	0xdb1: 0x0005, 0xdb2: 0x0005, 0xdb3: 0x0004, 0xdb4: 0x0005, 0xdb5: 0x0004,
	0xdb6: 0x0004, 0xdb7: 0x0004, 0xdb8: 0x0004, 0xdb9: 0x0004, 0xdba: 0x0005, 0xdbb: 0x0005,
	0xdbc: 0x0005, 0xdbd: 0x0005, 0xdbe: 0x0005, 0xdbf: 0x0005,
	// Block 0x37, offset 0xdc0
	0xdc0: 0x0005, 0xdc1: 0x0004, 0xdc2: 0x0005, 0xdc3: 0x0005, 0xdc4: 0x0005, 0xdc5: 0x0004,
	0xdc6: 0x0005, 0xdc7: 0x0005, 0xdc8: 0x0005, 0xdc9: 0x0005, 0xdca: 0x0005, 0xdcb: 0x0005,
	0xdcc: 0x0005, 0xdcd: 0x0005, 0xdce: 0x0005, 0xdcf: 0x0005, 0xdd0: 0x0005, 0xdd1: 0x0005,
	0xdd2: 0x0005, 0xdd3: 0x0004, 0xdd4: 0x0005, 0xdd5: 0x0005, 0xdd6: 0x0005, 0xdd7: 0x0005,
	0xdd9: 0x0005, 0xdda: 0x0005, 0xddb: 0x0005, 0xddc: 0x0005, 0xddd: 0x0004,
	0xdde: 0x0005, 0xddf: 0x0005, 0xde0: 0x0005, 0xde1: 0x0005, 0xde2: 0x0004, 0xde3: 0x0005,
	0xde4: 0x0005, 0xde5: 0x0005, 0xde6: 0x0005, 0xde7: 0x0004, 0xde8: 0x0005, 0xde9: 0x0005,
	0xdea: 0x0005, 0xdeb: 0x0005, 0xdec: 0x0004, 0xded: 0x0005, 0xdee: 0x0005, 0xdef: 0x0005,
	0xdf0: 0x0005, 0xdf1: 0x0005, 0xdf2: 0x0005, 0xdf3: 0x0005, 0xdf4: 0x0005, 0xdf5: 0x0005,
	0xdf6: 0x0005, 0xdf7: 0x0005, 0xdf8: 0x0005, 0xdf9: 0x0004, 0xdfa: 0x0005, 0xdfb: 0x0005,
	0xdfc: 0x0005, 0xdfe: 0x0004, 0xdff: 0x0004,
	// Block 0x38, offset 0xe00
	0xe00: 0x0004, 0xe01: 0x0004, 0xe02: 0x0004, 0xe03: 0x0004, 0xe04: 0x0004, 0xe05: 0x0004,
	0xe06: 0x0005, 0xe07: 0x0004, 0xe08: 0x0004, 0xe09: 0x0004, 0xe0a: 0x0004, 0xe0b: 0x0004,
	0xe0c: 0x0004, 0xe0e: 0x0004, 0xe0f: 0x0004, 0xe10: 0x0004, 0xe11: 0x0004,
	0xe12: 0x0004, 0xe13: 0x0004, 0xe14: 0x0004, 0xe15: 0x0004, 0xe16: 0x0004, 0xe17: 0x0004,
	0xe18: 0x0004, 0xe19: 0x0004, 0xe1a: 0x0004,
	// Block 0x39, offset 0xe40
	0xe40: 0x0005, 0xe41: 0x0005, 0xe42: 0x0005, 0xe43: 0x0005, 0xe44: 0x0005, 0xe45: 0x0005,
	0xe46: 0x0005, 0xe47: 0x0005, 0xe48: 0x0005, 0xe49: 0x0005, 0xe4a: 0x0004, 0xe4b: 0x0004,
	0xe4c: 0x0004, 0xe4d: 0x0004, 0xe4e: 0x0004, 0xe4f: 0x0004, 0xe50: 0x0005, 0xe51: 0x0005,
	0xe52: 0x0005, 0xe53: 0x0005, 0xe54: 0x0005, 0xe55: 0x0005, 0xe56: 0x0005, 0xe57: 0x0005,
	0xe58: 0x0005, 0xe59: 0x0005, 0xe5a: 0x0005, 0xe5b: 0x0005, 0xe5c: 0x0005, 0xe5d: 0x0005,
	0xe5e: 0x0005, 0xe5f: 0x0005, 0xe60: 0x0005, 0xe61: 0x0005, 0xe62: 0x0005, 0xe63: 0x0005,
	0xe64: 0x0005, 0xe65: 0x0005, 0xe66: 0x0005, 0xe67: 0x0005, 0xe68: 0x0005, 0xe69: 0x0005,
	0xe6a: 0x0005, 0xe6b: 0x0005, 0xe6c: 0x0005, 0xe6d: 0x0005, 0xe6e: 0x0005, 0xe6f: 0x0005,
	0xe70: 0x0005, 0xe71: 0x0005, 0xe72: 0x0005, 0xe73: 0x0005, 0xe74: 0x0005, 0xe75: 0x0005,
	0xe76: 0x0005, 0xe77: 0x0005, 0xe78: 0x0005, 0xe79: 0x0005, 0xe7a: 0x0005, 0xe7b: 0x0005,
	0xe7c: 0x0005, 0xe7d: 0x0005, 0xe7e: 0x0005, 0xe7f: 0x0005,
	// Block 0x3a, offset 0xe80
	0xe80: 0x0005, 0xe81: 0x0005, 0xe82: 0x0005, 0xe83: 0x0005, 0xe84: 0x0005, 0xe85: 0x0005,
	0xe86: 0x0005, 0xe87: 0x0005, 0xe88: 0x0005, 0xe89: 0x0005, 0xe8a: 0x0005, 0xe8b: 0x0005,
	0xe8c: 0x0005, 0xe8d: 0x0005, 0xe8e: 0x0005, 0xe8f: 0x0005, 0xe90: 0x0005, 0xe91: 0x0005,
	0xe92: 0x0005, 0xe93: 0x0005, 0xe94: 0x0005, 0xe95: 0x0005, 0xe96: 0x0005, 0xe97: 0x0005,
	0xe98: 0x0005, 0xe99: 0x0005, 0xe9a: 0x0005, 0xe9b: 0x0005, 0xe9c: 0x0005, 0xe9d: 0x0005,
	0xe9e: 0x0004, 0xe9f: 0x0004, 0xea0: 0x0005, 0xea1: 0x0005, 0xea2: 0x0005, 0xea3: 0x0005,
	0xea4: 0x0005, 0xea5: 0x0005, 0xea6: 0x0005, 0xea7: 0x0005, 0xea8: 0x0005, 0xea9: 0x0005,
	0xeaa: 0x0005, 0xeab: 0x0005, 0xeac: 0x0005, 0xead: 0x0005, 0xeae: 0x0005, 0xeaf: 0x0005,
	0xeb0: 0x0005, 0xeb1: 0x0005, 0xeb2: 0x0005, 0xeb3: 0x0005, 0xeb4: 0x0005, 0xeb5: 0x0005,
	0xeb6: 0x0005, 0xeb7: 0x0005, 0xeb8: 0x0005, 0xeb9: 0x0005, 0xeba: 0x0005, 0xebb: 0x0005,
	0xebc: 0x0005, 0xebd: 0x0005, 0xebe: 0x0005, 0xebf: 0x0005,
	// Block 0x3b, offset 0xec0
	0xec0: 0x0005, 0xec1: 0x0005, 0xec2: 0x0005, 0xec3: 0x0005, 0xec4: 0x0005, 0xec5: 0x0005,
	0xec7: 0x0005,
	0xecd: 0x0005, 0xed0: 0x0005, 0xed1: 0x0005,
	0xed2: 0x0005, 0xed3: 0x0005, 0xed4: 0x0005, 0xed5: 0x0005, 0xed6: 0x0005, 0xed7: 0x0005,
	0xed8: 0x0005, 0xed9: 0x0005, 0xeda: 0x0005, 0xedb: 0x0005, 0xedc: 0x0005, 0xedd: 0x0005,
	0xede: 0x0005, 0xedf: 0x0005, 0xee0: 0x0005, 0xee1: 0x0005, 0xee2: 0x0005, 0xee3: 0x0005,
	0xee4: 0x0005, 0xee5: 0x0005, 0xee6: 0x0005, 0xee7: 0x0005, 0xee8: 0x0005, 0xee9: 0x0005,
	0xeea: 0x0005, 0xeeb: 0x0005, 0xeec: 0x0005, 0xeed: 0x0005, 0xeee: 0x0005, 0xeef: 0x0005,
	0xef0: 0x0005, 0xef1: 0x0005, 0xef2: 0x0005, 0xef3: 0x0005, 0xef4: 0x0005, 0xef5: 0x0005,
	0xef6: 0x0005, 0xef7: 0x0005, 0xef8: 0x0005, 0xef9: 0x0005, 0xefa: 0x0005, 0xefb: 0x0004,
	0xefc: 0x0004, 0xefd: 0x0005, 0xefe: 0x0005, 0xeff: 0x0005,
	// Block 0x3c, offset 0xf00
	0xf00: 0x0001, 0xf01: 0x0001, 0xf02: 0x0001, 0xf03: 0x0001, 0xf04: 0x0001, 0xf05: 0x0001,
	0xf06: 0x0001, 0xf07: 0x0001, 0xf08: 0x0001, 0xf09: 0x0001, 0xf0a: 0x0001, 0xf0b: 0x0001,
	0xf0c: 0x0001, 0xf0d: 0x0001, 0xf0e: 0x0001, 0xf0f: 0x0001, 0xf10: 0x0001, 0xf11: 0x0001,
	0xf12: 0x0001, 0xf13: 0x0001, 0xf14: 0x0001, 0xf15: 0x0001, 0xf16: 0x0001, 0xf17: 0x0001,
	0xf18: 0x0001, 0xf19: 0x0001, 0xf1a: 0x0001, 0xf1b: 0x0001, 0xf1c: 0x0001, 0xf1d: 0x0001,
	0xf1e: 0x0001, 0xf1f: 0x0001, 0xf20: 0x0001, 0xf21: 0x0001, 0xf22: 0x0001, 0xf23: 0x0001,
	0xf24: 0x0001, 0xf25: 0x0001, 0xf26: 0x0001, 0xf27: 0x0001, 0xf28: 0x0001, 0xf29: 0x0001,
	0xf2a: 0x0001, 0xf2b: 0x0001, 0xf2c: 0x0001, 0xf2d: 0x0001, 0xf2e: 0x0001, 0xf2f: 0x0001,
	0xf30: 0x0001, 0xf31: 0x0001, 0xf32: 0x0001, 0xf33: 0x0001, 0xf34: 0x0001, 0xf35: 0x0001,
	0xf36: 0x0001, 0xf37: 0x0001, 0xf38: 0x0001, 0xf39: 0x0001, 0xf3a: 0x0001, 0xf3b: 0x0001,
	0xf3c: 0x0001, 0xf3d: 0x0001, 0xf3e: 0x0001, 0xf3f: 0x0001,
	// Block 0x3d, offset 0xf40
	0xf40: 0x0005, 0xf41: 0x0005, 0xf42: 0x0005, 0xf43: 0x0005, 0xf44: 0x0005, 0xf45: 0x0005,
	0xf46: 0x0005, 0xf47: 0x0005, 0xf48: 0x0005, 0xf4a: 0x0005, 0xf4b: 0x0005,
	0xf4c: 0x0005, 0xf4d: 0x0005, 0xf50: 0x0005, 0xf51: 0x0005,
	0xf52: 0x0005, 0xf53: 0x0005, 0xf54: 0x0005, 0xf55: 0x0005, 0xf56: 0x0005,
	0xf58: 0x0005, 0xf5a: 0x0005, 0xf5b: 0x0005, 0xf5c: 0x0005, 0xf5d: 0x0005,
	0xf60: 0x0005, 0xf61: 0x0005, 0xf62: 0x0005, 0xf63: 0x0005,
	0xf64: 0x0005, 0xf65: 0x0005, 0xf66: 0x0005, 0xf67: 0x0005, 0xf68: 0x0005, 0xf69: 0x0005,
	0xf6a: 0x0005, 0xf6b: 0x0005, 0xf6c: 0x0005, 0xf6d: 0x0005, 0xf6e: 0x0005, 0xf6f: 0x0005,
	0xf70: 0x0005, 0xf71: 0x0005, 0xf72: 0x0005, 0xf73: 0x0005, 0xf74: 0x0005, 0xf75: 0x0005,
	0xf76: 0x0005, 0xf77: 0x0005, 0xf78: 0x0005, 0xf79: 0x0005, 0xf7a: 0x0005, 0xf7b: 0x0005,
	0xf7c: 0x0005, 0xf7d: 0x0005, 0xf7e: 0x0005, 0xf7f: 0x0005,
	// Block 0x3e, offset 0xf80
	0xf80: 0x0005, 0xf81: 0x0005, 0xf82: 0x0005, 0xf83: 0x0005, 0xf84: 0x0005, 0xf85: 0x0005,
	0xf86: 0x0005, 0xf87: 0x0005, 0xf88: 0x0005, 0xf8a: 0x0005, 0xf8b: 0x0005,
	0xf8c: 0x0005, 0xf8d: 0x0005, 0xf90: 0x0005, 0xf91: 0x0005,
	0xf92: 0x0005, 0xf93: 0x0005, 0xf94: 0x0005, 0xf95: 0x0005, 0xf96: 0x0005, 0xf97: 0x0005,
	0xf98: 0x0005, 0xf99: 0x0005, 0xf9a: 0x0005, 0xf9b: 0x0005, 0xf9c: 0x0005, 0xf9d: 0x0005,
	0xf9e: 0x0005, 0xf9f: 0x0005, 0xfa0: 0x0005, 0xfa1: 0x0005, 0xfa2: 0x0005, 0xfa3: 0x0005,
	0xfa4: 0x0005, 0xfa5: 0x0005, 0xfa6: 0x0005, 0xfa7: 0x0005, 0xfa8: 0x0005, 0xfa9: 0x0005,
	0xfaa: 0x0005, 0xfab: 0x0005, 0xfac: 0x0005, 0xfad: 0x0005, 0xfae: 0x0005, 0xfaf: 0x0005,
	0xfb0: 0x0005, 0xfb2: 0x0005, 0xfb3: 0x0005, 0xfb4: 0x0005, 0xfb5: 0x0005,
	0xfb8: 0x0005, 0xfb9: 0x0005, 0xfba: 0x0005, 0xfbb: 0x0005,
	0xfbc: 0x0005, 0xfbd: 0x0005, 0xfbe: 0x0005,
	// Block 0x3f, offset 0xfc0
	0xfc0: 0x0005, 0xfc2: 0x0005, 0xfc3: 0x0005, 0xfc4: 0x0005, 0xfc5: 0x0005,
	0xfc8: 0x0005, 0xfc9: 0x0005, 0xfca: 0x0005, 0xfcb: 0x0005,
	0xfcc: 0x0005, 0xfcd: 0x0005, 0xfce: 0x0005, 0xfcf: 0x0005, 0xfd0: 0x0005, 0xfd1: 0x0005,
	0xfd2: 0x0005, 0xfd3: 0x0005, 0xfd4: 0x0005, 0xfd5: 0x0005, 0xfd6: 0x0005,
	0xfd8: 0x0005, 0xfd9: 0x0005, 0xfda: 0x0005, 0xfdb: 0x0005, 0xfdc: 0x0005, 0xfdd: 0x0005,
	0xfde: 0x0005, 0xfdf: 0x0005, 0xfe0: 0x0005, 0xfe1: 0x0005, 0xfe2: 0x0005, 0xfe3: 0x0005,
	0xfe4: 0x0005, 0xfe5: 0x0005, 0xfe6: 0x0005, 0xfe7: 0x0005, 0xfe8: 0x0005, 0xfe9: 0x0005,
	0xfea: 0x0005, 0xfeb: 0x0005, 0xfec: 0x0005, 0xfed: 0x0005, 0xfee: 0x0005, 0xfef: 0x0005,
	0xff0: 0x0005, 0xff1: 0x0005, 0xff2: 0x0005, 0xff3: 0x0005, 0xff4: 0x0005, 0xff5: 0x0005,
	0xff6: 0x0005, 0xff7: 0x0005, 0xff8: 0x0005, 0xff9: 0x0005, 0xffa: 0x0005, 0xffb: 0x0005,
	0xffc: 0x0005, 0xffd: 0x0005, 0xffe: 0x0005, 0xfff: 0x0005,
	// Block 0x40, offset 0x1000
	0x1000: 0x0005, 0x1001: 0x0005, 0x1002: 0x0005, 0x1003: 0x0005, 0x1004: 0x0005, 0x1005: 0x0005,
	0x1006: 0x0005, 0x1007: 0x0005, 0x1008: 0x0005, 0x1009: 0x0005, 0x100a: 0x0005, 0x100b: 0x0005,
	0x100c: 0x0005, 0x100d: 0x0005, 0x100e: 0x0005, 0x100f: 0x0005, 0x1010: 0x0005,
	0x1012: 0x0005, 0x1013: 0x0005, 0x1014: 0x0005, 0x1015: 0x0005,
	0x1018: 0x0005, 0x1019: 0x0005, 0x101a: 0x0005, 0x101b: 0x0005, 0x101c: 0x0005, 0x101d: 0x0005,
	0x101e: 0x0005, 0x101f: 0x0005, 0x1020: 0x0005, 0x1021: 0x0005, 0x1022: 0x0005, 0x1023: 0x0005,
	0x1024: 0x0005, 0x1025: 0x0005, 0x1026: 0x0005, 0x1027: 0x0005, 0x1028: 0x0005, 0x1029: 0x0005,
	0x102a: 0x0005, 0x102b: 0x0005, 0x102c: 0x0005, 0x102d: 0x0005, 0x102e: 0x0005, 0x102f: 0x0005,
	0x1030: 0x0005, 0x1031: 0x0005, 0x1032: 0x0005, 0x1033: 0x0005, 0x1034: 0x0005, 0x1035: 0x0005,
	0x1036: 0x0005, 0x1037: 0x0005, 0x1038: 0x0005, 0x1039: 0x0005, 0x103a: 0x0005, 0x103b: 0x0005,
	0x103c: 0x0005, 0x103d: 0x0005, 0x103e: 0x0005, 0x103f: 0x0005,
	// Block 0x41, offset 0x1040
	0x1040: 0x0005, 0x1041: 0x0005, 0x1042: 0x0005, 0x1043: 0x0005, 0x1044: 0x0005, 0x1045: 0x0005,
	0x1046: 0x0005, 0x1047: 0x0005, 0x1048: 0x0005, 0x1049: 0x0005, 0x104a: 0x0005, 0x104b: 0x0005,
	0x104c: 0x0005, 0x104d: 0x0005, 0x104e: 0x0005, 0x104f: 0x0005, 0x1050: 0x0005, 0x1051: 0x0005,
	0x1052: 0x0005, 0x1053: 0x0005, 0x1054: 0x0005, 0x1055: 0x0005, 0x1056: 0x0005, 0x1057: 0x0005,
	0x1058: 0x0005, 0x1059: 0x0005, 0x105a: 0x0005, 0x105d: 0x0005,
	0x105e: 0x0005, 0x105f: 0x0005, 0x1060: 0x0004, 0x1061: 0x0004, 0x1062: 0x0004, 0x1063: 0x0004,
	0x1064: 0x0004, 0x1065: 0x0004, 0x1066: 0x0004, 0x1067: 0x0004, 0x1068: 0x0004, 0x1069: 0x0004,
	0x106a: 0x0004, 0x106b: 0x0004, 0x106c: 0x0004, 0x106d: 0x0004, 0x106e: 0x0004, 0x106f: 0x0004,
	0x1070: 0x0004, 0x1071: 0x0004, 0x1072: 0x0004, 0x1073: 0x0004, 0x1074: 0x0004, 0x1075: 0x0004,
	0x1076: 0x0004, 0x1077: 0x0004, 0x1078: 0x0004, 0x1079: 0x0004, 0x107a: 0x0004, 0x107b: 0x0004,
	0x107c: 0x0004,
	// Block 0x42, offset 0x1080
	0x1080: 0x0005, 0x1081: 0x0005, 0x1082: 0x0005, 0x1083: 0x0005, 0x1084: 0x0005, 0x1085: 0x0005,
	0x1086: 0x0005, 0x1087: 0x0005, 0x1088: 0x0005, 0x1089: 0x0005, 0x108a: 0x0005, 0x108b: 0x0005,
	0x108c: 0x0005, 0x108d: 0x0005, 0x108e: 0x0005, 0x108f: 0x0005, 0x1090: 0x0004, 0x1091: 0x0004,
	0x1092: 0x0004, 0x1093: 0x0004, 0x1094: 0x0004, 0x1095: 0x0004, 0x1096: 0x0004, 0x1097: 0x0004,
	0x1098: 0x0004, 0x1099: 0x0004,
	0x10a0: 0x0005, 0x10a1: 0x0005, 0x10a2: 0x0005, 0x10a3: 0x0005,
	0x10a4: 0x0005, 0x10a5: 0x0005, 0x10a6: 0x0005, 0x10a7: 0x0005, 0x10a8: 0x0005, 0x10a9: 0x0005,
	0x10aa: 0x0005, 0x10ab: 0x0005, 0x10ac: 0x0005, 0x10ad: 0x0005, 0x10ae: 0x0005, 0x10af: 0x0005,
	0x10b0: 0x0005, 0x10b1: 0x0005, 0x10b2: 0x0005, 0x10b3: 0x0005, 0x10b4: 0x0005, 0x10b5: 0x0005,
	0x10b6: 0x0005, 0x10b7: 0x0005, 0x10b8: 0x0005, 0x10b9: 0x0005, 0x10ba: 0x0005, 0x10bb: 0x0005,
	0x10bc: 0x0005, 0x10bd: 0x0005, 0x10be: 0x0005, 0x10bf: 0x0005,
	// Block 0x43, offset 0x10c0
	0x10c0: 0x0005, 0x10c1: 0x0005, 0x10c2: 0x0005, 0x10c3: 0x0005, 0x10c4: 0x0005, 0x10c5: 0x0005,
	0x10c6: 0x0005, 0x10c7: 0x0005, 0x10c8: 0x0005, 0x10c9: 0x0005, 0x10ca: 0x0005, 0x10cb: 0x0005,
	0x10cc: 0x0005, 0x10cd: 0x0005, 0x10ce: 0x0005, 0x10cf: 0x0005, 0x10d0: 0x0005, 0x10d1: 0x0005,
	0x10d2: 0x0005, 0x10d3: 0x0005, 0x10d4: 0x0005, 0x10d5: 0x0005, 0x10d6: 0x0005, 0x10d7: 0x0005,
	0x10d8: 0x0005, 0x10d9: 0x0005, 0x10da: 0x0005, 0x10db: 0x0005, 0x10dc: 0x0005, 0x10dd: 0x0005,
	0x10de: 0x0005, 0x10df: 0x0005, 0x10e0: 0x0005, 0x10e1: 0x0005, 0x10e2: 0x0005, 0x10e3: 0x0005,
	0x10e4: 0x0005, 0x10e5: 0x0005, 0x10e6: 0x0005, 0x10e7: 0x0005, 0x10e8: 0x0005, 0x10e9: 0x0005,
	0x10ea: 0x0005, 0x10eb: 0x0005, 0x10ec: 0x0005, 0x10ed: 0x0005, 0x10ee: 0x0005, 0x10ef: 0x0005,
	0x10f0: 0x0005, 0x10f1: 0x0005, 0x10f2: 0x0005, 0x10f3: 0x0005, 0x10f4: 0x0005, 0x10f5: 0x0005,
	0x10f8: 0x0005, 0x10f9: 0x0005, 0x10fa: 0x0005, 0x10fb: 0x0005,
	0x10fc: 0x0005, 0x10fd: 0x0005,
	// Block 0x44, offset 0x1100
	0x1100: 0x0004, 0x1101: 0x0005, 0x1102: 0x0005, 0x1103: 0x0005, 0x1104: 0x0005, 0x1105: 0x0005,
	0x1106: 0x0005, 0x1107: 0x0005, 0x1108: 0x0005, 0x1109: 0x0005, 0x110a: 0x0005, 0x110b: 0x0005,
	0x110c: 0x0005, 0x110d: 0x0005, 0x110e: 0x0005, 0x110f: 0x0005, 0x1110: 0x0005, 0x1111: 0x0005,
	0x1112: 0x0005, 0x1113: 0x0005, 0x1114: 0x0005, 0x1115: 0x0005, 0x1116: 0x0005, 0x1117: 0x0005,
	0x1118: 0x0005, 0x1119: 0x0005, 0x111a: 0x0005, 0x111b: 0x0005, 0x111c: 0x0005, 0x111d: 0x0005,
	0x111e: 0x0005, 0x111f: 0x0005, 0x1120: 0x0005, 0x1121: 0x0005, 0x1122: 0x0005, 0x1123: 0x0005,
	0x1124: 0x0005, 0x1125: 0x0005, 0x1126: 0x0005, 0x1127: 0x0005, 0x1128: 0x0005, 0x1129: 0x0005,
	0x112a: 0x0005, 0x112b: 0x0005, 0x112c: 0x0005, 0x112d: 0x0005, 0x112e: 0x0005, 0x112f: 0x0005,
	0x1130: 0x0005, 0x1131: 0x0005, 0x1132: 0x0005, 0x1133: 0x0005, 0x1134: 0x0005, 0x1135: 0x0005,
	0x1136: 0x0005, 0x1137: 0x0005, 0x1138: 0x0005, 0x1139: 0x0005, 0x113a: 0x0005, 0x113b: 0x0005,
	0x113c: 0x0005, 0x113d: 0x0005, 0x113e: 0x0005, 0x113f: 0x0005,
	// Block 0x45, offset 0x1140
	0x1140: 0x0005, 0x1141: 0x0005, 0x1142: 0x0005, 0x1143: 0x0005, 0x1144: 0x0005, 0x1145: 0x0005,
	0x1146: 0x0005, 0x1147: 0x0005, 0x1148: 0x0005, 0x1149: 0x0005, 0x114a: 0x0005, 0x114b: 0x0005,
	0x114c: 0x0005, 0x114d: 0x0005, 0x114e: 0x0005, 0x114f: 0x0005, 0x1150: 0x0005, 0x1151: 0x0005,
	0x1152: 0x0005, 0x1153: 0x0005, 0x1154: 0x0005, 0x1155: 0x0005, 0x1156: 0x0005, 0x1157: 0x0005,
	0x1158: 0x0005, 0x1159: 0x0005, 0x115a: 0x0005, 0x115b: 0x0005, 0x115c: 0x0005, 0x115d: 0x0005,
	0x115e: 0x0005, 0x115f: 0x0005, 0x1160: 0x0005, 0x1161: 0x0005, 0x1162: 0x0005, 0x1163: 0x0005,
	0x1164: 0x0005, 0x1165: 0x0005, 0x1166: 0x0005, 0x1167: 0x0005, 0x1168: 0x0005, 0x1169: 0x0005,
	0x116a: 0x0005, 0x116b: 0x0005, 0x116c: 0x0005, 0x116d: 0x0004, 0x116e: 0x0004, 0x116f: 0x0005,
	0x1170: 0x0005, 0x1171: 0x0005, 0x1172: 0x0005, 0x1173: 0x0005, 0x1174: 0x0005, 0x1175: 0x0005,
	0x1176: 0x0005, 0x1177: 0x0005, 0x1178: 0x0005, 0x1179: 0x0005, 0x117a: 0x0005, 0x117b: 0x0005,
	0x117c: 0x0005, 0x117d: 0x0005, 0x117e: 0x0005, 0x117f: 0x0005,
	// Block 0x46, offset 0x1180
	0x1180: 0x0004, 0x1181: 0x0005, 0x1182: 0x0005, 0x1183: 0x0005, 0x1184: 0x0005, 0x1185: 0x0005,
	0x1186: 0x0005, 0x1187: 0x0005, 0x1188: 0x0005, 0x1189: 0x0005, 0x118a: 0x0005, 0x118b: 0x0005,
	0x118c: 0x0005, 0x118d: 0x0005, 0x118e: 0x0005, 0x118f: 0x0005, 0x1190: 0x0005, 0x1191: 0x0005,
	0x1192: 0x0005, 0x1193: 0x0005, 0x1194: 0x0005, 0x1195: 0x0005, 0x1196: 0x0005, 0x1197: 0x0005,
	0x1198: 0x0005, 0x1199: 0x0005, 0x119a: 0x0005, 0x119b: 0x0004, 0x119c: 0x0004,
	0x11a0: 0x0005, 0x11a1: 0x0005, 0x11a2: 0x0005, 0x11a3: 0x0005,
	0x11a4: 0x0005, 0x11a5: 0x0005, 0x11a6: 0x0005, 0x11a7: 0x0005, 0x11a8: 0x0005, 0x11a9: 0x0005,
	0x11aa: 0x0005, 0x11ab: 0x0005, 0x11ac: 0x0005, 0x11ad: 0x0005, 0x11ae: 0x0005, 0x11af: 0x0005,
	0x11b0: 0x0005, 0x11b1: 0x0005, 0x11b2: 0x0005, 0x11b3: 0x0005, 0x11b4: 0x0005, 0x11b5: 0x0005,
	0x11b6: 0x0005, 0x11b7: 0x0005, 0x11b8: 0x0005, 0x11b9: 0x0005, 0x11ba: 0x0005, 0x11bb: 0x0005,
	0x11bc: 0x0005, 0x11bd: 0x0005, 0x11be: 0x0005, 0x11bf: 0x0005,
	// Block 0x47, offset 0x11c0
	0x11c0: 0x0005, 0x11c1: 0x0005, 0x11c2: 0x0005, 0x11c3: 0x0005, 0x11c4: 0x0005, 0x11c5: 0x0005,
	0x11c6: 0x0005, 0x11c7: 0x0005, 0x11c8: 0x0005, 0x11c9: 0x0005, 0x11ca: 0x0005, 0x11cb: 0x0005,
	0x11cc: 0x0005, 0x11cd: 0x0005, 0x11ce: 0x0005, 0x11cf: 0x0005, 0x11d0: 0x0005, 0x11d1: 0x0005,
	0x11d2: 0x0005, 0x11d3: 0x0005, 0x11d4: 0x0005, 0x11d5: 0x0005, 0x11d6: 0x0005, 0x11d7: 0x0005,
	0x11d8: 0x0005, 0x11d9: 0x0005, 0x11da: 0x0005, 0x11db: 0x0005, 0x11dc: 0x0005, 0x11dd: 0x0005,
	0x11de: 0x0005, 0x11df: 0x0005, 0x11e0: 0x0005, 0x11e1: 0x0005, 0x11e2: 0x0005, 0x11e3: 0x0005,
	0x11e4: 0x0005, 0x11e5: 0x0005, 0x11e6: 0x0005, 0x11e7: 0x0005, 0x11e8: 0x0005, 0x11e9: 0x0005,
	0x11ea: 0x0005, 0x11eb: 0x0004, 0x11ec: 0x0004, 0x11ed: 0x0004, 0x11ee: 0x0004, 0x11ef: 0x0004,
	0x11f0: 0x0004, 0x11f1: 0x0005, 0x11f2: 0x0005, 0x11f3: 0x0005, 0x11f4: 0x0005, 0x11f5: 0x0005,
	0x11f6: 0x0005, 0x11f7: 0x0005, 0x11f8: 0x0005,
	// Block 0x48, offset 0x1200
	0x1200: 0x0005, 0x1201: 0x0005, 0x1202: 0x0005, 0x1203: 0x0005, 0x1204: 0x0005, 0x1205: 0x0005,
	0x1206: 0x0005, 0x1207: 0x0005, 0x1208: 0x0005, 0x1209: 0x0005, 0x120a: 0x0005, 0x120b: 0x0005,
	0x120c: 0x0005, 0x120e: 0x0005, 0x120f: 0x0005, 0x1210: 0x0005, 0x1211: 0x0005,
	0x1212: 0x0005, 0x1213: 0x0005, 0x1214: 0x0005,
	0x1220: 0x0005, 0x1221: 0x0005, 0x1222: 0x0005, 0x1223: 0x0005,
	0x1224: 0x0005, 0x1225: 0x0005, 0x1226: 0x0005, 0x1227: 0x0005, 0x1228: 0x0005, 0x1229: 0x0005,
	0x122a: 0x0005, 0x122b: 0x0005, 0x122c: 0x0005, 0x122d: 0x0005, 0x122e: 0x0005, 0x122f: 0x0005,
	0x1230: 0x0005, 0x1231: 0x0005, 0x1232: 0x0005, 0x1233: 0x0005, 0x1234: 0x0005, 0x1235: 0x0004,
	0x1236: 0x0004,
	// Block 0x49, offset 0x1240
	0x1240: 0x0005, 0x1241: 0x0005, 0x1242: 0x0005, 0x1243: 0x0005, 0x1244: 0x0005, 0x1245: 0x0005,
	0x1246: 0x0005, 0x1247: 0x0005, 0x1248: 0x0005, 0x1249: 0x0005, 0x124a: 0x0005, 0x124b: 0x0005,
	0x124c: 0x0005, 0x124d: 0x0005, 0x124e: 0x0005, 0x124f: 0x0005, 0x1250: 0x0005, 0x1251: 0x0005,
	0x1252: 0x0005, 0x1253: 0x0005,
	0x1260: 0x0005, 0x1261: 0x0005, 0x1262: 0x0005, 0x1263: 0x0005,
	0x1264: 0x0005, 0x1265: 0x0005, 0x1266: 0x0005, 0x1267: 0x0005, 0x1268: 0x0005, 0x1269: 0x0005,
	0x126a: 0x0005, 0x126b: 0x0005, 0x126c: 0x0005, 0x126e: 0x0005, 0x126f: 0x0005,
	0x1270: 0x0005, 0x1272: 0x0005, 0x1273: 0x0005,
	// Block 0x4a, offset 0x1280
	0x1280: 0x0005, 0x1281: 0x0005, 0x1282: 0x0005, 0x1283: 0x0005, 0x1284: 0x0005, 0x1285: 0x0005,
	0x1286: 0x0005, 0x1287: 0x0005, 0x1288: 0x0005, 0x1289: 0x0005, 0x128a: 0x0005, 0x128b: 0x0005,
	0x128c: 0x0005, 0x128d: 0x0005, 0x128e: 0x0005, 0x128f: 0x0005, 0x1290: 0x0005, 0x1291: 0x0005,
	0x1292: 0x0005, 0x1293: 0x0005, 0x1294: 0x0005, 0x1295: 0x0005, 0x1296: 0x0005, 0x1297: 0x0005,
	0x1298: 0x0005, 0x1299: 0x0005, 0x129a: 0x0005, 0x129b: 0x0005, 0x129c: 0x0005, 0x129d: 0x0005,
	0x129e: 0x0005, 0x129f: 0x0005, 0x12a0: 0x0005, 0x12a1: 0x0005, 0x12a2: 0x0005, 0x12a3: 0x0005,
	0x12a4: 0x0005, 0x12a5: 0x0005, 0x12a6: 0x0005, 0x12a7: 0x0005, 0x12a8: 0x0005, 0x12a9: 0x0005,
	0x12aa: 0x0005, 0x12ab: 0x0005, 0x12ac: 0x0005, 0x12ad: 0x0005, 0x12ae: 0x0005, 0x12af: 0x0005,
	0x12b0: 0x0005, 0x12b1: 0x0005, 0x12b2: 0x0005, 0x12b3: 0x0005, 0x12b4: 0x0001, 0x12b5: 0x0001,
	0x12b6: 0x0005, 0x12b7: 0x0005, 0x12b8: 0x0005, 0x12b9: 0x0005, 0x12ba: 0x0005, 0x12bb: 0x0005,
	0x12bc: 0x0005, 0x12bd: 0x0005, 0x12be: 0x0005, 0x12bf: 0x0005,
	// Block 0x4b, offset 0x12c0
	0x12c0: 0x0005, 0x12c1: 0x0005, 0x12c2: 0x0005, 0x12c3: 0x0005, 0x12c4: 0x0005, 0x12c5: 0x0005,
	0x12c6: 0x0005, 0x12c7: 0x0005, 0x12c8: 0x0005, 0x12c9: 0x0005, 0x12ca: 0x0005, 0x12cb: 0x0005,
	0x12cc: 0x0005, 0x12cd: 0x0005, 0x12ce: 0x0005, 0x12cf: 0x0005, 0x12d0: 0x0005, 0x12d1: 0x0005,
	0x12d2: 0x0005, 0x12d3: 0x0005, 0x12d4: 0x0004, 0x12d5: 0x0004, 0x12d6: 0x0004, 0x12d7: 0x0005,
	0x12d8: 0x0004, 0x12d9: 0x0004, 0x12da: 0x0004, 0x12db: 0x0004, 0x12dc: 0x0005, 0x12dd: 0x0005,
	0x12e0: 0x0005, 0x12e1: 0x0005, 0x12e2: 0x0005, 0x12e3: 0x0005,
	0x12e4: 0x0005, 0x12e5: 0x0005, 0x12e6: 0x0005, 0x12e7: 0x0005, 0x12e8: 0x0005, 0x12e9: 0x0005,
	0x12f0: 0x0004, 0x12f1: 0x0004, 0x12f2: 0x0004, 0x12f3: 0x0004, 0x12f4: 0x0004, 0x12f5: 0x0004,
	0x12f6: 0x0004, 0x12f7: 0x0004, 0x12f8: 0x0004, 0x12f9: 0x0004,
	// Block 0x4c, offset 0x1300
	0x1300: 0x0004, 0x1301: 0x0004, 0x1302: 0x0004, 0x1303: 0x0004, 0x1304: 0x0004, 0x1305: 0x0004,
	0x1306: 0x0004, 0x1307: 0x0004, 0x1308: 0x0004, 0x1309: 0x0004, 0x130a: 0x0004, 0x130b: 0x0001,
	0x130c: 0x0001, 0x130d: 0x0001, 0x130e: 0x0001, 0x1310: 0x0005, 0x1311: 0x0005,
	0x1312: 0x0005, 0x1313: 0x0005, 0x1314: 0x0005, 0x1315: 0x0005, 0x1316: 0x0005, 0x1317: 0x0005,
	0x1318: 0x0005, 0x1319: 0x0005,
	0x1320: 0x0005, 0x1321: 0x0005, 0x1322: 0x0005, 0x1323: 0x0005,
	0x1324: 0x0005, 0x1325: 0x0005, 0x1326: 0x0005, 0x1327: 0x0005, 0x1328: 0x0005, 0x1329: 0x0005,
	0x132a: 0x0005, 0x132b: 0x0005, 0x132c: 0x0005, 0x132d: 0x0005, 0x132e: 0x0005, 0x132f: 0x0005,
	0x1330: 0x0005, 0x1331: 0x0005, 0x1332: 0x0005, 0x1333: 0x0005, 0x1334: 0x0005, 0x1335: 0x0005,
	0x1336: 0x0005, 0x1337: 0x0005, 0x1338: 0x0005, 0x1339: 0x0005, 0x133a: 0x0005, 0x133b: 0x0005,
	0x133c: 0x0005, 0x133d: 0x0005, 0x133e: 0x0005, 0x133f: 0x0005,
	// Block 0x4d, offset 0x1340
	0x1340: 0x0005, 0x1341: 0x0005, 0x1342: 0x0005, 0x1343: 0x0005, 0x1344: 0x0005, 0x1345: 0x0005,
	0x1346: 0x0005, 0x1347: 0x0005, 0x1348: 0x0005, 0x1349: 0x0005, 0x134a: 0x0005, 0x134b: 0x0005,
	0x134c: 0x0005, 0x134d: 0x0005, 0x134e: 0x0005, 0x134f: 0x0005, 0x1350: 0x0005, 0x1351: 0x0005,
	0x1352: 0x0005, 0x1353: 0x0005, 0x1354: 0x0005, 0x1355: 0x0005, 0x1356: 0x0005, 0x1357: 0x0005,
	0x1358: 0x0005, 0x1359: 0x0005, 0x135a: 0x0005, 0x135b: 0x0005, 0x135c: 0x0005, 0x135d: 0x0005,
	0x135e: 0x0005, 0x135f: 0x0005, 0x1360: 0x0005, 0x1361: 0x0005, 0x1362: 0x0005, 0x1363: 0x0005,
	0x1364: 0x0005, 0x1365: 0x0005, 0x1366: 0x0005, 0x1367: 0x0005, 0x1368: 0x0005, 0x1369: 0x0005,
	0x136a: 0x0005, 0x136b: 0x0005, 0x136c: 0x0005, 0x136d: 0x0005, 0x136e: 0x0005, 0x136f: 0x0005,
	0x1370: 0x0005, 0x1371: 0x0005, 0x1372: 0x0005, 0x1373: 0x0005, 0x1374: 0x0005, 0x1375: 0x0005,
	0x1376: 0x0005, 0x1377: 0x0005,
	// Block 0x4e, offset 0x1380
	0x1380: 0x0005, 0x1381: 0x0005, 0x1382: 0x0005, 0x1383: 0x0005, 0x1384: 0x0005, 0x1385: 0x0005,
	0x1386: 0x0005, 0x1387: 0x0005, 0x1388: 0x0005, 0x1389: 0x0005, 0x138a: 0x0005, 0x138b: 0x0005,
	0x138c: 0x0005, 0x138d: 0x0005, 0x138e: 0x0005, 0x138f: 0x0005, 0x1390: 0x0005, 0x1391: 0x0005,
	0x1392: 0x0005, 0x1393: 0x0005, 0x1394: 0x0005, 0x1395: 0x0005, 0x1396: 0x0005, 0x1397: 0x0005,
	0x1398: 0x0005, 0x1399: 0x0005, 0x139a: 0x0005, 0x139b: 0x0005, 0x139c: 0x0005, 0x139d: 0x0005,
	0x139e: 0x0005, 0x139f: 0x0005, 0x13a0: 0x0005, 0x13a1: 0x0005, 0x13a2: 0x0005, 0x13a3: 0x0005,
	0x13a4: 0x0005, 0x13a5: 0x0005, 0x13a6: 0x0005, 0x13a7: 0x0005, 0x13a8: 0x0005, 0x13a9: 0x0005,
	0x13aa: 0x0005,
	0x13b0: 0x0005, 0x13b1: 0x0005, 0x13b2: 0x0005, 0x13b3: 0x0005, 0x13b4: 0x0005, 0x13b5: 0x0005,
	0x13b6: 0x0005, 0x13b7: 0x0005, 0x13b8: 0x0005, 0x13b9: 0x0005, 0x13ba: 0x0005, 0x13bb: 0x0005,
	0x13bc: 0x0005, 0x13bd: 0x0005, 0x13be: 0x0005, 0x13bf: 0x0005,
	// Block 0x4f, offset 0x13c0
	0x13c0: 0x0005, 0x13c1: 0x0005, 0x13c2: 0x0005, 0x13c3: 0x0005, 0x13c4: 0x0005, 0x13c5: 0x0005,
	0x13c6: 0x0005, 0x13c7: 0x0005, 0x13c8: 0x0005, 0x13c9: 0x0005, 0x13ca: 0x0005, 0x13cb: 0x0005,
	0x13cc: 0x0005, 0x13cd: 0x0005, 0x13ce: 0x0005, 0x13cf: 0x0005, 0x13d0: 0x0005, 0x13d1: 0x0005,
	0x13d2: 0x0005, 0x13d3: 0x0005, 0x13d4: 0x0005, 0x13d5: 0x0005, 0x13d6: 0x0005, 0x13d7: 0x0005,
	0x13d8: 0x0005, 0x13d9: 0x0005, 0x13da: 0x0005, 0x13db: 0x0005, 0x13dc: 0x0005, 0x13dd: 0x0005,
	0x13de: 0x0005, 0x13df: 0x0005, 0x13e0: 0x0005, 0x13e1: 0x0005, 0x13e2: 0x0005, 0x13e3: 0x0005,
	0x13e4: 0x0005, 0x13e5: 0x0005, 0x13e6: 0x0005, 0x13e7: 0x0005, 0x13e8: 0x0005, 0x13e9: 0x0005,
	0x13ea: 0x0005, 0x13eb: 0x0005, 0x13ec: 0x0005, 0x13ed: 0x0005, 0x13ee: 0x0005, 0x13ef: 0x0005,
	0x13f0: 0x0005, 0x13f1: 0x0005, 0x13f2: 0x0005, 0x13f3: 0x0005, 0x13f4: 0x0005, 0x13f5: 0x0005,
	// Block 0x50, offset 0x1400
	0x1400: 0x0005, 0x1401: 0x0005, 0x1402: 0x0005, 0x1403: 0x0005, 0x1404: 0x0005, 0x1405: 0x0005,
	0x1406: 0x0005, 0x1407: 0x0005, 0x1408: 0x0005, 0x1409: 0x0005, 0x140a: 0x0005, 0x140b: 0x0005,
	0x140c: 0x0005, 0x140d: 0x0005, 0x140e: 0x0005, 0x140f: 0x0005, 0x1410: 0x0005, 0x1411: 0x0005,
	0x1412: 0x0005, 0x1413: 0x0005, 0x1414: 0x0005, 0x1415: 0x0005, 0x1416: 0x0005, 0x1417: 0x0005,
	0x1418: 0x0005, 0x1419: 0x0005, 0x141a: 0x0005, 0x141b: 0x0005, 0x141c: 0x0005, 0x141d: 0x0005,
	0x141e: 0x0005, 0x1420: 0x0005, 0x1421: 0x0005, 0x1422: 0x0005, 0x1423: 0x0005,
	0x1424: 0x0005, 0x1425: 0x0005, 0x1426: 0x0005, 0x1427: 0x0005, 0x1428: 0x0005, 0x1429: 0x0005,
	0x142a: 0x0005, 0x142b: 0x0005,
	0x1430: 0x0005, 0x1431: 0x0005, 0x1432: 0x0005, 0x1433: 0x0005, 0x1434: 0x0005, 0x1435: 0x0005,
	0x1436: 0x0005, 0x1437: 0x0005, 0x1438: 0x0005, 0x1439: 0x0005, 0x143a: 0x0005, 0x143b: 0x0005,
	// Block 0x51, offset 0x1440
	0x1440: 0x0004, 0x1444: 0x0004, 0x1445: 0x0004,
	0x1446: 0x0005, 0x1447: 0x0005, 0x1448: 0x0005, 0x1449: 0x0005, 0x144a: 0x0005, 0x144b: 0x0005,
	0x144c: 0x0005, 0x144d: 0x0005, 0x144e: 0x0005, 0x144f: 0x0005, 0x1450: 0x0005, 0x1451: 0x0005,
	0x1452: 0x0005, 0x1453: 0x0005, 0x1454: 0x0005, 0x1455: 0x0005, 0x1456: 0x0005, 0x1457: 0x0005,
	0x1458: 0x0005, 0x1459: 0x0005, 0x145a: 0x0005, 0x145b: 0x0005, 0x145c: 0x0005, 0x145d: 0x0005,
	0x145e: 0x0005, 0x145f: 0x0005, 0x1460: 0x0005, 0x1461: 0x0005, 0x1462: 0x0005, 0x1463: 0x0005,
	0x1464: 0x0005, 0x1465: 0x0005, 0x1466: 0x0005, 0x1467: 0x0005, 0x1468: 0x0005, 0x1469: 0x0005,
	0x146a: 0x0005, 0x146b: 0x0005, 0x146c: 0x0005, 0x146d: 0x0005,
	0x1470: 0x0005, 0x1471: 0x0005, 0x1472: 0x0005, 0x1473: 0x0005, 0x1474: 0x0005,
	// Block 0x52, offset 0x1480
	0x1480: 0x0005, 0x1481: 0x0005, 0x1482: 0x0005, 0x1483: 0x0005, 0x1484: 0x0005, 0x1485: 0x0005,
	0x1486: 0x0005, 0x1487: 0x0005, 0x1488: 0x0005, 0x1489: 0x0005, 0x148a: 0x0005, 0x148b: 0x0005,
	0x148c: 0x0005, 0x148d: 0x0005, 0x148e: 0x0005, 0x148f: 0x0005, 0x1490: 0x0005, 0x1491: 0x0005,
	0x1492: 0x0005, 0x1493: 0x0005, 0x1494: 0x0005, 0x1495: 0x0005, 0x1496: 0x0005, 0x1497: 0x0005,
	0x1498: 0x0005, 0x1499: 0x0005, 0x149a: 0x0005, 0x149b: 0x0005, 0x149c: 0x0005, 0x149d: 0x0005,
	0x149e: 0x0005, 0x149f: 0x0005, 0x14a0: 0x0005, 0x14a1: 0x0005, 0x14a2: 0x0005, 0x14a3: 0x0005,
	0x14a4: 0x0005, 0x14a5: 0x0005, 0x14a6: 0x0005, 0x14a7: 0x0005, 0x14a8: 0x0005, 0x14a9: 0x0005,
	0x14aa: 0x0005, 0x14ab: 0x0005,
	0x14b0: 0x0005, 0x14b1: 0x0005, 0x14b2: 0x0005, 0x14b3: 0x0005, 0x14b4: 0x0005, 0x14b5: 0x0005,
	0x14b6: 0x0005, 0x14b7: 0x0005, 0x14b8: 0x0005, 0x14b9: 0x0005, 0x14ba: 0x0005, 0x14bb: 0x0005,
	0x14bc: 0x0005, 0x14bd: 0x0005, 0x14be: 0x0005, 0x14bf: 0x0005,
	// Block 0x53, offset 0x14c0
	0x14c0: 0x0005, 0x14c1: 0x0005, 0x14c2: 0x0005, 0x14c3: 0x0005, 0x14c4: 0x0005, 0x14c5: 0x0005,
	0x14c6: 0x0005, 0x14c7: 0x0005, 0x14c8: 0x0005, 0x14c9: 0x0005,
	0x14d0: 0x0005, 0x14d1: 0x0005,
	0x14d2: 0x0005, 0x14d3: 0x0005, 0x14d4: 0x0005, 0x14d5: 0x0005, 0x14d6: 0x0005, 0x14d7: 0x0005,
	0x14d8: 0x0005, 0x14d9: 0x0005, 0x14da: 0x0004,
	0x14de: 0x0004, 0x14df: 0x0004, 0x14e0: 0x0004, 0x14e1: 0x0004, 0x14e2: 0x0004, 0x14e3: 0x0004,
	0x14e4: 0x0004, 0x14e5: 0x0004, 0x14e6: 0x0004, 0x14e7: 0x0004, 0x14e8: 0x0004, 0x14e9: 0x0004,
	0x14ea: 0x0004, 0x14eb: 0x0004, 0x14ec: 0x0004, 0x14ed: 0x0004, 0x14ee: 0x0004, 0x14ef: 0x0004,
	0x14f0: 0x0004, 0x14f1: 0x0004, 0x14f2: 0x0004, 0x14f3: 0x0004, 0x14f4: 0x0004, 0x14f5: 0x0004,
	0x14f6: 0x0004, 0x14f7: 0x0004, 0x14f8: 0x0004, 0x14f9: 0x0004, 0x14fa: 0x0004, 0x14fb: 0x0004,
	0x14fc: 0x0004, 0x14fd: 0x0004, 0x14fe: 0x0004, 0x14ff: 0x0004,
	// Block 0x54, offset 0x1500
	0x1500: 0x0005, 0x1501: 0x0005, 0x1502: 0x0005, 0x1503: 0x0005, 0x1504: 0x0005, 0x1505: 0x0005,
	0x1506: 0x0005, 0x1507: 0x0005, 0x1508: 0x0005, 0x1509: 0x0005, 0x150a: 0x0005, 0x150b: 0x0005,
	0x150c: 0x0005, 0x150d: 0x0005, 0x150e: 0x0005, 0x150f: 0x0005, 0x1510: 0x0005, 0x1511: 0x0005,
	0x1512: 0x0005, 0x1513: 0x0005, 0x1514: 0x0005, 0x1515: 0x0005, 0x1516: 0x0005, 0x1517: 0x0005,
	0x1518: 0x0005, 0x1519: 0x0005, 0x151a: 0x0005, 0x151b: 0x0005,
	0x151e: 0x0004, 0x151f: 0x0004, 0x1520: 0x0005, 0x1521: 0x0005, 0x1522: 0x0005, 0x1523: 0x0005,
	0x1524: 0x0005, 0x1525: 0x0005, 0x1526: 0x0005, 0x1527: 0x0005, 0x1528: 0x0005, 0x1529: 0x0005,
	0x152a: 0x0005, 0x152b: 0x0005, 0x152c: 0x0005, 0x152d: 0x0005, 0x152e: 0x0005, 0x152f: 0x0005,
	0x1530: 0x0005, 0x1531: 0x0005, 0x1532: 0x0005, 0x1533: 0x0005, 0x1534: 0x0005, 0x1535: 0x0005,
	0x1536: 0x0005, 0x1537: 0x0005, 0x1538: 0x0005, 0x1539: 0x0005, 0x153a: 0x0005, 0x153b: 0x0005,
	0x153c: 0x0005, 0x153d: 0x0005, 0x153e: 0x0005, 0x153f: 0x0005,
	// Block 0x55, offset 0x1540
	0x1540: 0x0005, 0x1541: 0x0005, 0x1542: 0x0005, 0x1543: 0x0005, 0x1544: 0x0005, 0x1545: 0x0005,
	0x1546: 0x0005, 0x1547: 0x0005, 0x1548: 0x0005, 0x1549: 0x0005, 0x154a: 0x0005, 0x154b: 0x0005,
	0x154c: 0x0005, 0x154d: 0x0005, 0x154e: 0x0005, 0x154f: 0x0005, 0x1550: 0x0005, 0x1551: 0x0005,
	0x1552: 0x0005, 0x1553: 0x0005, 0x1554: 0x0005, 0x1555: 0x0005, 0x1556: 0x0005, 0x1557: 0x0005,
	0x1558: 0x0005, 0x1559: 0x0005, 0x155a: 0x0005, 0x155b: 0x0005, 0x155c: 0x0005, 0x155d: 0x0005,
	0x155e: 0x0005, 0x1560: 0x0005, 0x1561: 0x0005, 0x1562: 0x0005, 0x1563: 0x0005,
	0x1564: 0x0005, 0x1565: 0x0005, 0x1566: 0x0005, 0x1567: 0x0005, 0x1568: 0x0005, 0x1569: 0x0005,
	0x156a: 0x0005, 0x156b: 0x0005, 0x156c: 0x0005, 0x156d: 0x0005, 0x156e: 0x0005, 0x156f: 0x0005,
	0x1570: 0x0005, 0x1571: 0x0005, 0x1572: 0x0005, 0x1573: 0x0005, 0x1574: 0x0005, 0x1575: 0x0005,
	0x1576: 0x0005, 0x1577: 0x0005, 0x1578: 0x0005, 0x1579: 0x0005, 0x157a: 0x0005, 0x157b: 0x0005,
	0x157c: 0x0005, 0x157f: 0x0005,
	// Block 0x56, offset 0x1580
	0x1580: 0x0005, 0x1581: 0x0005, 0x1582: 0x0005, 0x1583: 0x0005, 0x1584: 0x0005, 0x1585: 0x0005,
	0x1586: 0x0005, 0x1587: 0x0005, 0x1588: 0x0005, 0x1589: 0x0005,
	0x1590: 0x0005, 0x1591: 0x0005,
	0x1592: 0x0005, 0x1593: 0x0005, 0x1594: 0x0005, 0x1595: 0x0005, 0x1596: 0x0005, 0x1597: 0x0005,
	0x1598: 0x0005, 0x1599: 0x0005,
	0x15a0: 0x0004, 0x15a1: 0x0004, 0x15a2: 0x0004, 0x15a3: 0x0004,
	0x15a4: 0x0004, 0x15a5: 0x0004, 0x15a6: 0x0004, 0x15a7: 0x0005, 0x15a8: 0x0004, 0x15a9: 0x0004,
	0x15aa: 0x0004, 0x15ab: 0x0004, 0x15ac: 0x0004, 0x15ad: 0x0004,
	0x15b0: 0x0005, 0x15b1: 0x0005, 0x15b2: 0x0005, 0x15b3: 0x0005, 0x15b4: 0x0005, 0x15b5: 0x0005,
	0x15b6: 0x0005, 0x15b7: 0x0005, 0x15b8: 0x0005, 0x15b9: 0x0005, 0x15ba: 0x0005, 0x15bb: 0x0005,
	0x15bc: 0x0005, 0x15bd: 0x0005, 0x15be: 0x0004,
	// Block 0x57, offset 0x15c0
	0x15c0: 0x0005, 0x15c1: 0x0005, 0x15c2: 0x0005, 0x15c3: 0x0005, 0x15c4: 0x0005, 0x15c5: 0x0005,
	0x15c6: 0x0005, 0x15c7: 0x0005, 0x15c8: 0x0005, 0x15c9: 0x0005, 0x15ca: 0x0005, 0x15cb: 0x0005,
	0x15d0: 0x0005, 0x15d1: 0x0005,
	0x15d2: 0x0005, 0x15d3: 0x0005, 0x15d4: 0x0005, 0x15d5: 0x0005, 0x15d6: 0x0005, 0x15d7: 0x0005,
	0x15d8: 0x0005, 0x15d9: 0x0005, 0x15da: 0x0004, 0x15db: 0x0004, 0x15dc: 0x0004, 0x15dd: 0x0004,
	0x15de: 0x0004, 0x15df: 0x0004, 0x15e0: 0x0004, 0x15e1: 0x0004, 0x15e2: 0x0004, 0x15e3: 0x0004,
	0x15e4: 0x0004, 0x15e5: 0x0004, 0x15e6: 0x0004, 0x15e7: 0x0004, 0x15e8: 0x0004, 0x15e9: 0x0004,
	0x15ea: 0x0004, 0x15eb: 0x0005, 0x15ec: 0x0005, 0x15ed: 0x0005, 0x15ee: 0x0005, 0x15ef: 0x0005,
	0x15f0: 0x0005, 0x15f1: 0x0005, 0x15f2: 0x0005, 0x15f3: 0x0005, 0x15f4: 0x0004, 0x15f5: 0x0004,
	0x15f6: 0x0004, 0x15f7: 0x0004, 0x15f8: 0x0004, 0x15f9: 0x0004, 0x15fa: 0x0004, 0x15fb: 0x0004,
	0x15fc: 0x0004,
	// Block 0x58, offset 0x1600
	0x1600: 0x0005, 0x1601: 0x0005, 0x1602: 0x0005, 0x1603: 0x0005, 0x1604: 0x0005, 0x1605: 0x0005,
	0x1606: 0x0005, 0x1607: 0x0005, 0x1608: 0x0005, 0x1609: 0x0005, 0x160a: 0x0005, 0x160b: 0x0005,
	0x160c: 0x0005, 0x160d: 0x0005, 0x160e: 0x0005, 0x160f: 0x0005, 0x1610: 0x0005, 0x1611: 0x0005,
	0x1612: 0x0005, 0x1613: 0x0005, 0x1614: 0x0005, 0x1615: 0x0005, 0x1616: 0x0005, 0x1617: 0x0005,
	0x1618: 0x0005, 0x1619: 0x0005, 0x161a: 0x0005, 0x161b: 0x0005, 0x161c: 0x0005, 0x161d: 0x0005,
	0x161e: 0x0005, 0x161f: 0x0005, 0x1620: 0x0005, 0x1621: 0x0005, 0x1622: 0x0005, 0x1623: 0x0005,
	0x1624: 0x0005, 0x1625: 0x0005, 0x1626: 0x0005, 0x1627: 0x0005, 0x1628: 0x0005, 0x1629: 0x0005,
	0x162a: 0x0005, 0x162b: 0x0005, 0x162c: 0x0005, 0x162d: 0x0005, 0x162e: 0x0005, 0x162f: 0x0005,
	0x1630: 0x0005, 0x1631: 0x0005, 0x1632: 0x0005, 0x1633: 0x0005,
	0x163c: 0x0004, 0x163d: 0x0004, 0x163e: 0x0004, 0x163f: 0x0004,
	// Block 0x59, offset 0x1640
	0x1640: 0x0005, 0x1641: 0x0005, 0x1642: 0x0005, 0x1643: 0x0005, 0x1644: 0x0005, 0x1645: 0x0005,
	0x1646: 0x0005, 0x1647: 0x0005, 0x1648: 0x0005, 0x1649: 0x0005, 0x164a: 0x0005, 0x164b: 0x0005,
	0x164c: 0x0005, 0x164d: 0x0005, 0x164e: 0x0005, 0x164f: 0x0005, 0x1650: 0x0005, 0x1651: 0x0005,
	0x1652: 0x0005, 0x1653: 0x0005, 0x1654: 0x0005, 0x1655: 0x0005, 0x1656: 0x0005, 0x1657: 0x0005,
	0x1658: 0x0005, 0x1659: 0x0005, 0x165a: 0x0005, 0x165b: 0x0005, 0x165c: 0x0005, 0x165d: 0x0005,
	0x165e: 0x0005, 0x165f: 0x0005, 0x1660: 0x0005, 0x1661: 0x0005, 0x1662: 0x0005, 0x1663: 0x0005,
	0x1664: 0x0005, 0x1665: 0x0005, 0x1666: 0x0005, 0x1667: 0x0005, 0x1668: 0x0005, 0x1669: 0x0005,
	0x166a: 0x0005, 0x166b: 0x0005, 0x166c: 0x0005, 0x166d: 0x0005, 0x166e: 0x0005, 0x166f: 0x0005,
	0x1670: 0x0005, 0x1671: 0x0005, 0x1672: 0x0005, 0x1673: 0x0005, 0x1674: 0x0005, 0x1675: 0x0005,
	0x1676: 0x0005, 0x1677: 0x0005, 0x167b: 0x0004,
	0x167c: 0x0004, 0x167d: 0x0004, 0x167e: 0x0004, 0x167f: 0x0004,
	// Block 0x5a, offset 0x1680
	0x1680: 0x0005, 0x1681: 0x0005, 0x1682: 0x0005, 0x1683: 0x0005, 0x1684: 0x0005, 0x1685: 0x0005,
	0x1686: 0x0005, 0x1687: 0x0005, 0x1688: 0x0005, 0x1689: 0x0005,
	0x168d: 0x0005, 0x168e: 0x0005, 0x168f: 0x0005, 0x1690: 0x0005, 0x1691: 0x0005,
	0x1692: 0x0005, 0x1693: 0x0005, 0x1694: 0x0005, 0x1695: 0x0005, 0x1696: 0x0005, 0x1697: 0x0005,
	0x1698: 0x0005, 0x1699: 0x0005, 0x169a: 0x0005, 0x169b: 0x0005, 0x169c: 0x0005, 0x169d: 0x0005,
	0x169e: 0x0005, 0x169f: 0x0005, 0x16a0: 0x0005, 0x16a1: 0x0005, 0x16a2: 0x0005, 0x16a3: 0x0005,
	0x16a4: 0x0005, 0x16a5: 0x0005, 0x16a6: 0x0005, 0x16a7: 0x0005, 0x16a8: 0x0005, 0x16a9: 0x0005,
	0x16aa: 0x0005, 0x16ab: 0x0005, 0x16ac: 0x0005, 0x16ad: 0x0005, 0x16ae: 0x0005, 0x16af: 0x0005,
	0x16b0: 0x0005, 0x16b1: 0x0005, 0x16b2: 0x0005, 0x16b3: 0x0005, 0x16b4: 0x0005, 0x16b5: 0x0005,
	0x16b6: 0x0005, 0x16b7: 0x0005, 0x16b8: 0x0005, 0x16b9: 0x0005, 0x16ba: 0x0005, 0x16bb: 0x0005,
	0x16bc: 0x0005, 0x16bd: 0x0005, 0x16be: 0x0004, 0x16bf: 0x0004,
	// Block 0x5b, offset 0x16c0
	0x16c0: 0x0004, 0x16c1: 0x0004, 0x16c2: 0x0004, 0x16c3: 0x0004, 0x16c4: 0x0004, 0x16c5: 0x0004,
	0x16c6: 0x0004, 0x16c7: 0x0004,
	0x16d0: 0x0005, 0x16d1: 0x0005,
	0x16d2: 0x0005, 0x16d3: 0x0004, 0x16d4: 0x0005, 0x16d5: 0x0005, 0x16d6: 0x0005, 0x16d7: 0x0005,
	0x16d8: 0x0005, 0x16d9: 0x0005, 0x16da: 0x0005, 0x16db: 0x0005, 0x16dc: 0x0005, 0x16dd: 0x0005,
	0x16de: 0x0005, 0x16df: 0x0005, 0x16e0: 0x0005, 0x16e1: 0x0005, 0x16e2: 0x0005, 0x16e3: 0x0005,
	0x16e4: 0x0005, 0x16e5: 0x0005, 0x16e6: 0x0005, 0x16e7: 0x0005, 0x16e8: 0x0005, 0x16e9: 0x0005,
	0x16ea: 0x0005, 0x16eb: 0x0005, 0x16ec: 0x0005, 0x16ed: 0x0005, 0x16ee: 0x0005, 0x16ef: 0x0005,
	0x16f0: 0x0005, 0x16f1: 0x0005, 0x16f2: 0x0005, 0x16f3: 0x0005, 0x16f4: 0x0005, 0x16f5: 0x0005,
	0x16f6: 0x0005, 0x16f8: 0x0005, 0x16f9: 0x0005,
	// Block 0x5c, offset 0x1700
	0x1700: 0x0005, 0x1701: 0x0005, 0x1702: 0x0005, 0x1703: 0x0005, 0x1704: 0x0005, 0x1705: 0x0005,
	0x1706: 0x0005, 0x1707: 0x0005, 0x1708: 0x0005, 0x1709: 0x0005, 0x170a: 0x0005, 0x170b: 0x0005,
	0x170c: 0x0005, 0x170d: 0x0005, 0x170e: 0x0005, 0x170f: 0x0005, 0x1710: 0x0005, 0x1711: 0x0005,
	0x1712: 0x0005, 0x1713: 0x0005, 0x1714: 0x0005, 0x1715: 0x0005, 0x1716: 0x0005, 0x1717: 0x0005,
	0x1718: 0x0005, 0x1719: 0x0005, 0x171a: 0x0005, 0x171b: 0x0005, 0x171c: 0x0005, 0x171d: 0x0005,
	0x171e: 0x0005, 0x171f: 0x0005, 0x1720: 0x0005, 0x1721: 0x0005, 0x1722: 0x0005, 0x1723: 0x0005,
	0x1724: 0x0005, 0x1725: 0x0005, 0x1726: 0x0005, 0x1727: 0x0005, 0x1728: 0x0005, 0x1729: 0x0005,
	0x172a: 0x0005, 0x172b: 0x0005, 0x172c: 0x0004, 0x172d: 0x0004, 0x172e: 0x0004, 0x172f: 0x0005,
	0x1730: 0x0004, 0x1731: 0x0004, 0x1732: 0x0004, 0x1733: 0x0004, 0x1734: 0x0004, 0x1735: 0x0004,
	0x1736: 0x0004, 0x1737: 0x0004, 0x1738: 0x0004, 0x1739: 0x0004, 0x173a: 0x0004, 0x173b: 0x0005,
	0x173c: 0x0004, 0x173d: 0x0004, 0x173e: 0x0004, 0x173f: 0x0004,
	// Block 0x5d, offset 0x1740
	0x1740: 0x0004, 0x1741: 0x0004, 0x1742: 0x0004, 0x1743: 0x0004, 0x1744: 0x0004, 0x1745: 0x0004,
	0x1746: 0x0004, 0x1747: 0x0004, 0x1748: 0x0004, 0x1749: 0x0004, 0x174a: 0x0004, 0x174b: 0x0004,
	0x174c: 0x0004, 0x174d: 0x0004, 0x174e: 0x0005, 0x174f: 0x0004, 0x1750: 0x0004, 0x1751: 0x0004,
	0x1752: 0x0004, 0x1753: 0x0004, 0x1754: 0x0004, 0x1755: 0x0004, 0x1756: 0x0004, 0x1757: 0x0004,
	0x1758: 0x0004, 0x1759: 0x0004, 0x175a: 0x0004, 0x175b: 0x0004, 0x175c: 0x0004, 0x175d: 0x0004,
	0x175e: 0x0004, 0x175f: 0x0004, 0x1760: 0x0004, 0x1761: 0x0004, 0x1762: 0x0004, 0x1763: 0x0004,
	0x1764: 0x0004, 0x1765: 0x0004, 0x1766: 0x0004, 0x1767: 0x0004, 0x1768: 0x0004, 0x1769: 0x0004,
	0x176a: 0x0004, 0x176b: 0x0005, 0x176c: 0x0005, 0x176d: 0x0005, 0x176e: 0x0005, 0x176f: 0x0005,
	0x1770: 0x0005, 0x1771: 0x0005, 0x1772: 0x0005, 0x1773: 0x0005, 0x1774: 0x0005, 0x1775: 0x0005,
	0x1776: 0x0005, 0x1777: 0x0005, 0x1778: 0x0004, 0x1779: 0x0005, 0x177a: 0x0005, 0x177b: 0x0005,
	0x177c: 0x0005, 0x177d: 0x0005, 0x177e: 0x0005, 0x177f: 0x0005,
	// Block 0x5e, offset 0x1780
	0x1780: 0x0005, 0x1781: 0x0005, 0x1782: 0x0005, 0x1783: 0x0005, 0x1784: 0x0005, 0x1785: 0x0005,
	0x1786: 0x0005, 0x1787: 0x0005, 0x1788: 0x0005, 0x1789: 0x0005, 0x178a: 0x0005, 0x178b: 0x0005,
	0x178c: 0x0005, 0x178d: 0x0005, 0x178e: 0x0005, 0x178f: 0x0005, 0x1790: 0x0005, 0x1791: 0x0005,
	0x1792: 0x0005, 0x1793: 0x0005, 0x1794: 0x0005, 0x1795: 0x0005, 0x1796: 0x0005, 0x1797: 0x0005,
	0x1798: 0x0005, 0x1799: 0x0005, 0x179a: 0x0005, 0x179b: 0x0004, 0x179c: 0x0004, 0x179d: 0x0004,
	0x179e: 0x0004, 0x179f: 0x0004, 0x17a0: 0x0004, 0x17a1: 0x0004, 0x17a2: 0x0004, 0x17a3: 0x0004,
	0x17a4: 0x0004, 0x17a5: 0x0004, 0x17a6: 0x0004, 0x17a7: 0x0004, 0x17a8: 0x0004, 0x17a9: 0x0004,
	0x17aa: 0x0004, 0x17ab: 0x0004, 0x17ac: 0x0004, 0x17ad: 0x0004, 0x17ae: 0x0004, 0x17af: 0x0004,
	0x17b0: 0x0004, 0x17b1: 0x0004, 0x17b2: 0x0004, 0x17b3: 0x0004, 0x17b4: 0x0004, 0x17b5: 0x0004,
	0x17b6: 0x0004, 0x17b7: 0x0004, 0x17b8: 0x0004, 0x17b9: 0x0004, 0x17ba: 0x0004, 0x17bb: 0x0004,
	0x17bc: 0x0004, 0x17bd: 0x0004, 0x17be: 0x0004, 0x17bf: 0x0004,
	// Block 0x5f, offset 0x17c0
	0x17c0: 0x0005, 0x17c1: 0x0005, 0x17c2: 0x0005, 0x17c3: 0x0005, 0x17c4: 0x0005, 0x17c5: 0x0005,
	0x17c6: 0x0005, 0x17c7: 0x0005, 0x17c8: 0x0005, 0x17c9: 0x0005, 0x17ca: 0x0005, 0x17cb: 0x0005,
	0x17cc: 0x0005, 0x17cd: 0x0005, 0x17ce: 0x0005, 0x17cf: 0x0005, 0x17d0: 0x0005, 0x17d1: 0x0005,
	0x17d2: 0x0005, 0x17d3: 0x0005, 0x17d4: 0x0005, 0x17d5: 0x0005, 0x17d6: 0x0005, 0x17d7: 0x0005,
	0x17d8: 0x0005, 0x17d9: 0x0005, 0x17da: 0x0005, 0x17db: 0x0005, 0x17dc: 0x0005, 0x17dd: 0x0005,
	0x17de: 0x0005, 0x17df: 0x0005, 0x17e0: 0x0005, 0x17e1: 0x0005, 0x17e2: 0x0005, 0x17e3: 0x0005,
	0x17e4: 0x0005, 0x17e5: 0x0005, 0x17e6: 0x0005, 0x17e7: 0x0005, 0x17e8: 0x0005, 0x17e9: 0x0005,
	0x17ea: 0x0005, 0x17eb: 0x0005, 0x17ec: 0x0005, 0x17ed: 0x0005, 0x17ee: 0x0005, 0x17ef: 0x0005,
	0x17f0: 0x0005, 0x17f1: 0x0005, 0x17f2: 0x0005, 0x17f3: 0x0005, 0x17f4: 0x0005, 0x17f5: 0x0005,
	0x17fc: 0x0005, 0x17fd: 0x0005, 0x17fe: 0x0005, 0x17ff: 0x0005,
	// Block 0x60, offset 0x1800
	0x1800: 0x0005, 0x1801: 0x0005, 0x1802: 0x0005, 0x1803: 0x0005, 0x1804: 0x0005, 0x1805: 0x0005,
	0x1806: 0x0005, 0x1807: 0x0005, 0x1808: 0x0005, 0x1809: 0x0005, 0x180a: 0x0005, 0x180b: 0x0005,
	0x180c: 0x0005, 0x180d: 0x0005, 0x180e: 0x0005, 0x180f: 0x0005, 0x1810: 0x0005, 0x1811: 0x0005,
	0x1812: 0x0005, 0x1813: 0x0005, 0x1814: 0x0005, 0x1815: 0x0005, 0x1816: 0x0005, 0x1817: 0x0005,
	0x1818: 0x0005, 0x1819: 0x0005, 0x181a: 0x0004, 0x181b: 0x0004, 0x181c: 0x0005, 0x181d: 0x0005,
	0x181e: 0x0005, 0x181f: 0x0005, 0x1820: 0x0005, 0x1821: 0x0005, 0x1822: 0x0005, 0x1823: 0x0005,
	0x1824: 0x0005, 0x1825: 0x0005, 0x1826: 0x0005, 0x1827: 0x0005, 0x1828: 0x0005, 0x1829: 0x0005,
	0x182a: 0x0005, 0x182b: 0x0005, 0x182c: 0x0005, 0x182d: 0x0005, 0x182e: 0x0005, 0x182f: 0x0005,
	0x1830: 0x0005, 0x1831: 0x0005, 0x1832: 0x0005, 0x1833: 0x0005, 0x1834: 0x0005, 0x1835: 0x0005,
	0x1836: 0x0005, 0x1837: 0x0005, 0x1838: 0x0005, 0x1839: 0x0005, 0x183a: 0x0005, 0x183b: 0x0005,
	0x183c: 0x0005, 0x183d: 0x0005, 0x183e: 0x0005, 0x183f: 0x0005,
	// Block 0x61, offset 0x1840
	0x1840: 0x0005, 0x1841: 0x0005, 0x1842: 0x0005, 0x1843: 0x0005, 0x1844: 0x0005, 0x1845: 0x0005,
	0x1846: 0x0005, 0x1847: 0x0005, 0x1848: 0x0005, 0x1849: 0x0005, 0x184a: 0x0005, 0x184b: 0x0005,
	0x184c: 0x0005, 0x184d: 0x0005, 0x184e: 0x0005, 0x184f: 0x0005, 0x1850: 0x0005, 0x1851: 0x0005,
	0x1852: 0x0005, 0x1853: 0x0005, 0x1854: 0x0005, 0x1855: 0x0005,
	0x1858: 0x0005, 0x1859: 0x0005, 0x185a: 0x0005, 0x185b: 0x0005, 0x185c: 0x0005, 0x185d: 0x0005,
	0x1860: 0x0005, 0x1861: 0x0005, 0x1862: 0x0005, 0x1863: 0x0005,
	0x1864: 0x0005, 0x1865: 0x0005, 0x1866: 0x0005, 0x1867: 0x0005, 0x1868: 0x0005, 0x1869: 0x0005,
	0x186a: 0x0005, 0x186b: 0x0005, 0x186c: 0x0005, 0x186d: 0x0005, 0x186e: 0x0005, 0x186f: 0x0005,
	0x1870: 0x0005, 0x1871: 0x0005, 0x1872: 0x0005, 0x1873: 0x0005, 0x1874: 0x0005, 0x1875: 0x0005,
	0x1876: 0x0005, 0x1877: 0x0005, 0x1878: 0x0005, 0x1879: 0x0005, 0x187a: 0x0005, 0x187b: 0x0005,
	0x187c: 0x0005, 0x187d: 0x0005, 0x187e: 0x0005, 0x187f: 0x0005,
	// Block 0x62, offset 0x1880
	0x1880: 0x0005, 0x1881: 0x0005, 0x1882: 0x0005, 0x1883: 0x0005, 0x1884: 0x0005, 0x1885: 0x0005,
	0x1888: 0x0005, 0x1889: 0x0005, 0x188a: 0x0005, 0x188b: 0x0005,
	0x188c: 0x0005, 0x188d: 0x0005, 0x1890: 0x0005, 0x1891: 0x0005,
	0x1892: 0x0005, 0x1893: 0x0005, 0x1894: 0x0005, 0x1895: 0x0005, 0x1896: 0x0005, 0x1897: 0x0005,
	0x1899: 0x0005, 0x189b: 0x0005, 0x189d: 0x0005,
	0x189f: 0x0005, 0x18a0: 0x0005, 0x18a1: 0x0005, 0x18a2: 0x0005, 0x18a3: 0x0005,
	0x18a4: 0x0005, 0x18a5: 0x0005, 0x18a6: 0x0005, 0x18a7: 0x0005, 0x18a8: 0x0005, 0x18a9: 0x0005,
	0x18aa: 0x0005, 0x18ab: 0x0005, 0x18ac: 0x0005, 0x18ad: 0x0005, 0x18ae: 0x0005, 0x18af: 0x0005,
	0x18b0: 0x0005, 0x18b1: 0x0004, 0x18b2: 0x0005, 0x18b3: 0x0004, 0x18b4: 0x0005, 0x18b5: 0x0004,
	0x18b6: 0x0005, 0x18b7: 0x0004, 0x18b8: 0x0005, 0x18b9: 0x0004, 0x18ba: 0x0005, 0x18bb: 0x0004,
	0x18bc: 0x0005, 0x18bd: 0x0004,
	// Block 0x63, offset 0x18c0
	0x18c0: 0x0005, 0x18c1: 0x0005, 0x18c2: 0x0005, 0x18c3: 0x0005, 0x18c4: 0x0005, 0x18c5: 0x0005,
	0x18c6: 0x0005, 0x18c7: 0x0005, 0x18c8: 0x0004, 0x18c9: 0x0004, 0x18ca: 0x0004, 0x18cb: 0x0004,
	0x18cc: 0x0004, 0x18cd: 0x0004, 0x18ce: 0x0004, 0x18cf: 0x0004, 0x18d0: 0x0005, 0x18d1: 0x0005,
	0x18d2: 0x0005, 0x18d3: 0x0005, 0x18d4: 0x0005, 0x18d5: 0x0005, 0x18d6: 0x0005, 0x18d7: 0x0005,
	0x18d8: 0x0004, 0x18d9: 0x0004, 0x18da: 0x0004, 0x18db: 0x0004, 0x18dc: 0x0004, 0x18dd: 0x0004,
	0x18de: 0x0004, 0x18df: 0x0004, 0x18e0: 0x0005, 0x18e1: 0x0005, 0x18e2: 0x0005, 0x18e3: 0x0005,
	0x18e4: 0x0005, 0x18e5: 0x0005, 0x18e6: 0x0005, 0x18e7: 0x0005, 0x18e8: 0x0004, 0x18e9: 0x0004,
	0x18ea: 0x0004, 0x18eb: 0x0004, 0x18ec: 0x0004, 0x18ed: 0x0004, 0x18ee: 0x0004, 0x18ef: 0x0004,
	0x18f0: 0x0005, 0x18f1: 0x0005, 0x18f2: 0x0005, 0x18f3: 0x0005, 0x18f4: 0x0005,
	0x18f6: 0x0005, 0x18f7: 0x0005, 0x18f8: 0x0005, 0x18f9: 0x0005, 0x18fa: 0x0005, 0x18fb: 0x0004,
	0x18fc: 0x0004, 0x18fd: 0x0004, 0x18fe: 0x0004, 0x18ff: 0x0004,
	// Block 0x64, offset 0x1900
	0x1900: 0x0004, 0x1901: 0x0004, 0x1902: 0x0005, 0x1903: 0x0005, 0x1904: 0x0005,
	0x1906: 0x0005, 0x1907: 0x0005, 0x1908: 0x0005, 0x1909: 0x0004, 0x190a: 0x0005, 0x190b: 0x0004,
	0x190c: 0x0004, 0x190d: 0x0004, 0x190e: 0x0004, 0x190f: 0x0004, 0x1910: 0x0005, 0x1911: 0x0005,
	0x1912: 0x0005, 0x1913: 0x0004, 0x1916: 0x0005, 0x1917: 0x0005,
	0x1918: 0x0005, 0x1919: 0x0005, 0x191a: 0x0005, 0x191b: 0x0004, 0x191d: 0x0004,
	0x191e: 0x0004, 0x191f: 0x0004, 0x1920: 0x0005, 0x1921: 0x0005, 0x1922: 0x0005, 0x1923: 0x0004,
	0x1924: 0x0005, 0x1925: 0x0005, 0x1926: 0x0005, 0x1927: 0x0005, 0x1928: 0x0005, 0x1929: 0x0005,
	0x192a: 0x0005, 0x192b: 0x0004, 0x192c: 0x0005, 0x192d: 0x0004, 0x192e: 0x0004, 0x192f: 0x0004,
	0x1932: 0x0005, 0x1933: 0x0005, 0x1934: 0x0005,
	0x1936: 0x0005, 0x1937: 0x0005, 0x1938: 0x0005, 0x1939: 0x0004, 0x193a: 0x0005, 0x193b: 0x0004,
	0x193c: 0x0004, 0x193d: 0x0004, 0x193e: 0x0004,
	// Block 0x65, offset 0x1940
	0x1940: 0x0004, 0x1941: 0x0004, 0x1942: 0x0004, 0x1943: 0x0004, 0x1944: 0x0004, 0x1945: 0x0004,
	0x1946: 0x0004, 0x1947: 0x0004, 0x1948: 0x0004, 0x1949: 0x0004, 0x194a: 0x0004, 0x194b: 0x0001,
	0x194c: 0x0003, 0x194d: 0x0003, 0x194e: 0x0001, 0x194f: 0x0001, 0x1950: 0x0004, 0x1951: 0x0004,
	0x1952: 0x0004, 0x1953: 0x0004, 0x1954: 0x0004, 0x1955: 0x0004, 0x1956: 0x0004, 0x1957: 0x0004,
	0x1958: 0x0004, 0x1959: 0x0004, 0x195a: 0x0004, 0x195b: 0x0004, 0x195c: 0x0004, 0x195d: 0x0004,
	0x195e: 0x0004, 0x195f: 0x0004, 0x1960: 0x0004, 0x1961: 0x0004, 0x1962: 0x0004, 0x1963: 0x0004,
	0x1964: 0x0004, 0x1965: 0x0004, 0x1966: 0x0004, 0x1967: 0x0004, 0x1968: 0x0001, 0x1969: 0x0001,
	0x196a: 0x0001, 0x196b: 0x0001, 0x196c: 0x0001, 0x196d: 0x0001, 0x196e: 0x0001, 0x196f: 0x0004,
	0x1970: 0x0004, 0x1971: 0x0004, 0x1972: 0x0004, 0x1973: 0x0004, 0x1974: 0x0004, 0x1975: 0x0004,
	0x1976: 0x0004, 0x1977: 0x0004, 0x1978: 0x0004, 0x1979: 0x0004, 0x197a: 0x0004, 0x197b: 0x0004,
	0x197c: 0x0004, 0x197d: 0x0004, 0x197e: 0x0004, 0x197f: 0x0004,
	// Block 0x66, offset 0x1980
	0x1980: 0x0004, 0x1981: 0x0004, 0x1982: 0x0004, 0x1983: 0x0004, 0x1984: 0x0004, 0x1985: 0x0004,
	0x1986: 0x0004, 0x1987: 0x0004, 0x1988: 0x0004, 0x1989: 0x0004, 0x198a: 0x0004, 0x198b: 0x0004,
	0x198c: 0x0004, 0x198d: 0x0004, 0x198e: 0x0004, 0x198f: 0x0004, 0x1990: 0x0004, 0x1991: 0x0004,
	0x1992: 0x0004, 0x1993: 0x0004, 0x1994: 0x0004, 0x1995: 0x0004, 0x1996: 0x0004, 0x1997: 0x0004,
	0x1998: 0x0004, 0x1999: 0x0004, 0x199a: 0x0004, 0x199b: 0x0004, 0x199c: 0x0004, 0x199d: 0x0004,
	0x199e: 0x0004, 0x199f: 0x0004, 0x19a0: 0x0001, 0x19a1: 0x0001, 0x19a2: 0x0001, 0x19a3: 0x0001,
	0x19a4: 0x0001, 0x19a6: 0x0001, 0x19a7: 0x0001, 0x19a8: 0x0001, 0x19a9: 0x0001,
	0x19aa: 0x0001, 0x19ab: 0x0001, 0x19ac: 0x0001, 0x19ad: 0x0001, 0x19ae: 0x0001, 0x19af: 0x0001,
	0x19b0: 0x0004, 0x19b1: 0x0004, 0x19b4: 0x0004, 0x19b5: 0x0004,
	0x19b6: 0x0004, 0x19b7: 0x0004, 0x19b8: 0x0004, 0x19b9: 0x0004, 0x19ba: 0x0004, 0x19bb: 0x0004,
	0x19bc: 0x0004, 0x19bd: 0x0004, 0x19be: 0x0004, 0x19bf: 0x0004,
	// Block 0x67, offset 0x19c0
	0x19c0: 0x0004, 0x19c1: 0x0004, 0x19c2: 0x0004, 0x19c3: 0x0004, 0x19c4: 0x0004, 0x19c5: 0x0004,
	0x19c6: 0x0004, 0x19c7: 0x0004, 0x19c8: 0x0004, 0x19c9: 0x0004, 0x19ca: 0x0004, 0x19cb: 0x0004,
	0x19cc: 0x0004, 0x19cd: 0x0004, 0x19ce: 0x0004, 0x19d0: 0x0004, 0x19d1: 0x0004,
	0x19d2: 0x0004, 0x19d3: 0x0004, 0x19d4: 0x0004, 0x19d5: 0x0004, 0x19d6: 0x0004, 0x19d7: 0x0004,
	0x19d8: 0x0004, 0x19d9: 0x0004, 0x19da: 0x0004, 0x19db: 0x0004, 0x19dc: 0x0004,
	0x19e0: 0x0004, 0x19e1: 0x0004, 0x19e2: 0x0004, 0x19e3: 0x0004,
	0x19e4: 0x0004, 0x19e5: 0x0004, 0x19e6: 0x0004, 0x19e7: 0x0004, 0x19e8: 0x0004, 0x19e9: 0x0004,
	0x19ea: 0x0004, 0x19eb: 0x0004, 0x19ec: 0x0004, 0x19ed: 0x0004, 0x19ee: 0x0004, 0x19ef: 0x0004,
	0x19f0: 0x0004, 0x19f1: 0x0004, 0x19f2: 0x0004, 0x19f3: 0x0004, 0x19f4: 0x0004, 0x19f5: 0x0004,
	0x19f6: 0x0004, 0x19f7: 0x0004, 0x19f8: 0x0004, 0x19f9: 0x0004, 0x19fa: 0x0004, 0x19fb: 0x0004,
	0x19fc: 0x0004, 0x19fd: 0x0004, 0x19fe: 0x0004,
	// Block 0x68, offset 0x1a00
	0x1a10: 0x0005, 0x1a11: 0x0005,
	0x1a12: 0x0005, 0x1a13: 0x0005, 0x1a14: 0x0005, 0x1a15: 0x0005, 0x1a16: 0x0005, 0x1a17: 0x0005,
	0x1a18: 0x0005, 0x1a19: 0x0005, 0x1a1a: 0x0005, 0x1a1b: 0x0005, 0x1a1c: 0x0005, 0x1a1d: 0x0004,
	0x1a1e: 0x0004, 0x1a1f: 0x0004, 0x1a20: 0x0004, 0x1a21: 0x0005, 0x1a22: 0x0004, 0x1a23: 0x0004,
	0x1a24: 0x0004, 0x1a25: 0x0005, 0x1a26: 0x0005, 0x1a27: 0x0005, 0x1a28: 0x0005, 0x1a29: 0x0005,
	0x1a2a: 0x0005, 0x1a2b: 0x0005, 0x1a2c: 0x0005, 0x1a2d: 0x0005, 0x1a2e: 0x0005, 0x1a2f: 0x0005,
	0x1a30: 0x0005,
	// Block 0x69, offset 0x1a40
	0x1a40: 0x0004, 0x1a41: 0x0004, 0x1a42: 0x0004, 0x1a43: 0x0004, 0x1a44: 0x0004, 0x1a45: 0x0004,
	0x1a46: 0x0004, 0x1a47: 0x0004, 0x1a48: 0x0004, 0x1a49: 0x0004, 0x1a4a: 0x0004, 0x1a4b: 0x0004,
	0x1a4c: 0x0004, 0x1a4d: 0x0004, 0x1a4e: 0x0004, 0x1a4f: 0x0004, 0x1a50: 0x0004, 0x1a51: 0x0004,
	0x1a52: 0x0004, 0x1a53: 0x0004, 0x1a54: 0x0004, 0x1a55: 0x0004, 0x1a56: 0x0004, 0x1a57: 0x0004,
	0x1a58: 0x0004, 0x1a59: 0x0004, 0x1a5a: 0x0004, 0x1a5b: 0x0004, 0x1a5c: 0x0004, 0x1a5d: 0x0004,
	0x1a5e: 0x0004, 0x1a5f: 0x0004, 0x1a60: 0x0004, 0x1a61: 0x0004, 0x1a62: 0x0004, 0x1a63: 0x0004,
	0x1a64: 0x0004, 0x1a65: 0x0004, 0x1a66: 0x0004, 0x1a67: 0x0004, 0x1a68: 0x0004, 0x1a69: 0x0004,
	0x1a6a: 0x0004, 0x1a6b: 0x0004, 0x1a6c: 0x0004, 0x1a6d: 0x0004, 0x1a6e: 0x0004, 0x1a6f: 0x0004,
	0x1a70: 0x0004, 0x1a71: 0x0004, 0x1a72: 0x0005, 0x1a73: 0x0004, 0x1a74: 0x0004, 0x1a75: 0x0004,
	0x1a76: 0x0004, 0x1a77: 0x0004, 0x1a78: 0x0004, 0x1a79: 0x0004, 0x1a7a: 0x0004, 0x1a7b: 0x0004,
	0x1a7c: 0x0004, 0x1a7d: 0x0004, 0x1a7e: 0x0004, 0x1a7f: 0x0004,
	// Block 0x6a, offset 0x1a80
	0x1a80: 0x0004, 0x1a81: 0x0004, 0x1a82: 0x0004, 0x1a83: 0x0004, 0x1a84: 0x0004, 0x1a85: 0x0004,
	0x1a86: 0x0004, 0x1a87: 0x0004, 0x1a88: 0x0004, 0x1a89: 0x0004, 0x1a8a: 0x0004, 0x1a8b: 0x0004,
	0x1a8c: 0x0004, 0x1a8d: 0x0004, 0x1a8e: 0x0005, 0x1a8f: 0x0004, 0x1a90: 0x0004, 0x1a91: 0x0004,
	0x1a92: 0x0004, 0x1a93: 0x0004, 0x1a94: 0x0004, 0x1a95: 0x0004, 0x1a96: 0x0004, 0x1a97: 0x0004,
	0x1a98: 0x0004, 0x1a99: 0x0004, 0x1a9a: 0x0004, 0x1a9b: 0x0004, 0x1a9c: 0x0004, 0x1a9d: 0x0004,
	0x1a9e: 0x0004, 0x1a9f: 0x0004, 0x1aa0: 0x0004, 0x1aa1: 0x0004, 0x1aa2: 0x0004, 0x1aa3: 0x0004,
	0x1aa4: 0x0004, 0x1aa5: 0x0004, 0x1aa6: 0x0004, 0x1aa7: 0x0004, 0x1aa8: 0x0004, 0x1aa9: 0x0004,
	0x1aaa: 0x0004, 0x1aab: 0x0004, 0x1aac: 0x0004, 0x1aad: 0x0004, 0x1aae: 0x0004, 0x1aaf: 0x0004,
	0x1ab0: 0x0004, 0x1ab1: 0x0004, 0x1ab2: 0x0004, 0x1ab3: 0x0004, 0x1ab4: 0x0004, 0x1ab5: 0x0004,
	0x1ab6: 0x0004, 0x1ab7: 0x0004, 0x1ab8: 0x0004, 0x1ab9: 0x0004, 0x1aba: 0x0004, 0x1abb: 0x0004,
	0x1abc: 0x0004, 0x1abd: 0x0004, 0x1abe: 0x0004, 0x1abf: 0x0004,
	// Block 0x6b, offset 0x1ac0
	0x1ac0: 0x0004, 0x1ac1: 0x0004, 0x1ac2: 0x0004, 0x1ac3: 0x0005, 0x1ac4: 0x0005, 0x1ac5: 0x0004,
	0x1ac6: 0x0004, 0x1ac7: 0x0004, 0x1ac8: 0x0004, 0x1ac9: 0x0004, 0x1aca: 0x0004, 0x1acb: 0x0004,
	0x1ad0: 0x0004, 0x1ad1: 0x0004,
	0x1ad2: 0x0004, 0x1ad3: 0x0004, 0x1ad4: 0x0004, 0x1ad5: 0x0004, 0x1ad6: 0x0004, 0x1ad7: 0x0004,
	0x1ad8: 0x0004, 0x1ad9: 0x0004, 0x1ada: 0x0004, 0x1adb: 0x0004, 0x1adc: 0x0004, 0x1add: 0x0004,
	0x1ade: 0x0004, 0x1adf: 0x0004, 0x1ae0: 0x0004, 0x1ae1: 0x0004, 0x1ae2: 0x0004, 0x1ae3: 0x0004,
	0x1ae4: 0x0004, 0x1ae5: 0x0004, 0x1ae6: 0x0004, 0x1ae7: 0x0004, 0x1ae8: 0x0004, 0x1ae9: 0x0004,
	0x1aea: 0x0004, 0x1aeb: 0x0004, 0x1aec: 0x0004, 0x1aed: 0x0004, 0x1aee: 0x0004, 0x1aef: 0x0004,
	0x1af0: 0x0004, 0x1af1: 0x0004, 0x1af2: 0x0004, 0x1af3: 0x0004, 0x1af4: 0x0004, 0x1af5: 0x0004,
	0x1af6: 0x0004, 0x1af7: 0x0004, 0x1af8: 0x0004, 0x1af9: 0x0004, 0x1afa: 0x0004, 0x1afb: 0x0004,
	0x1afc: 0x0004, 0x1afd: 0x0004, 0x1afe: 0x0004, 0x1aff: 0x0004,
	// Block 0x6c, offset 0x1b00
	0x1b00: 0x0004, 0x1b01: 0x0004, 0x1b02: 0x0004, 0x1b03: 0x0004, 0x1b04: 0x0004, 0x1b05: 0x0004,
	0x1b06: 0x0004, 0x1b07: 0x0004, 0x1b08: 0x0004, 0x1b09: 0x0004, 0x1b0a: 0x0004, 0x1b0b: 0x0004,
	0x1b0c: 0x0004, 0x1b0d: 0x0004, 0x1b0e: 0x0004, 0x1b0f: 0x0004, 0x1b10: 0x0004, 0x1b11: 0x0004,
	0x1b12: 0x0004, 0x1b13: 0x0004, 0x1b14: 0x0004, 0x1b15: 0x0004, 0x1b16: 0x0004, 0x1b17: 0x0004,
	0x1b18: 0x0004, 0x1b19: 0x0004, 0x1b1a: 0x0004, 0x1b1b: 0x0004, 0x1b1c: 0x0004, 0x1b1d: 0x0004,
	0x1b1e: 0x0004, 0x1b1f: 0x0004, 0x1b20: 0x0004, 0x1b21: 0x0004, 0x1b22: 0x0004, 0x1b23: 0x0004,
	0x1b24: 0x0004, 0x1b25: 0x0004, 0x1b26: 0x0004, 0x1b27: 0x0004, 0x1b28: 0x0004, 0x1b29: 0x0004,
	0x1b2a: 0x0004, 0x1b2b: 0x0004, 0x1b2c: 0x0004, 0x1b2d: 0x0004, 0x1b2e: 0x0004, 0x1b2f: 0x0004,
	0x1b30: 0x0004, 0x1b31: 0x0004, 0x1b32: 0x0004, 0x1b33: 0x0004, 0x1b34: 0x0004, 0x1b35: 0x0004,
	0x1b36: 0x0004, 0x1b37: 0x0004, 0x1b38: 0x0004, 0x1b39: 0x0004, 0x1b3a: 0x0004, 0x1b3b: 0x0004,
	0x1b3c: 0x0004, 0x1b3d: 0x0004, 0x1b3e: 0x0004, 0x1b3f: 0x0004,
	// Block 0x6d, offset 0x1b40
	0x1b40: 0x0004, 0x1b41: 0x0004, 0x1b42: 0x0004, 0x1b43: 0x0004, 0x1b44: 0x0004, 0x1b45: 0x0004,
	0x1b46: 0x0004, 0x1b47: 0x0004, 0x1b48: 0x0004, 0x1b49: 0x0004, 0x1b4a: 0x0004, 0x1b4b: 0x0004,
	0x1b4c: 0x0004, 0x1b4d: 0x0004, 0x1b4e: 0x0004, 0x1b4f: 0x0004, 0x1b50: 0x0004, 0x1b51: 0x0004,
	0x1b52: 0x0004, 0x1b53: 0x0004, 0x1b54: 0x0004, 0x1b55: 0x0004, 0x1b56: 0x0004, 0x1b57: 0x0004,
	0x1b58: 0x0004, 0x1b59: 0x0004, 0x1b5a: 0x0004, 0x1b5b: 0x0004, 0x1b5c: 0x0004, 0x1b5d: 0x0004,
	0x1b5e: 0x0004, 0x1b5f: 0x0004, 0x1b60: 0x0004, 0x1b61: 0x0004, 0x1b62: 0x0004, 0x1b63: 0x0004,
	0x1b64: 0x0004, 0x1b65: 0x0004, 0x1b66: 0x0004, 0x1b67: 0x0004, 0x1b68: 0x0004, 0x1b69: 0x0004,
	0x1b6a: 0x0004, 0x1b6b: 0x0004, 0x1b6c: 0x0004, 0x1b6d: 0x0004, 0x1b6e: 0x0004, 0x1b6f: 0x0004,
	0x1b70: 0x0004, 0x1b71: 0x0004, 0x1b72: 0x0004, 0x1b73: 0x0004, 0x1b74: 0x0004, 0x1b75: 0x0004,
	0x1b76: 0x0004, 0x1b77: 0x0004, 0x1b78: 0x0004, 0x1b79: 0x0004, 0x1b7a: 0x0004,
	// Block 0x6e, offset 0x1b80
	0x1b80: 0x0004, 0x1b81: 0x0004, 0x1b82: 0x0004, 0x1b83: 0x0004, 0x1b84: 0x0004, 0x1b85: 0x0004,
	0x1b86: 0x0004, 0x1b87: 0x0004, 0x1b88: 0x0004, 0x1b89: 0x0004, 0x1b8a: 0x0004, 0x1b8b: 0x0004,
	0x1b8c: 0x0004, 0x1b8d: 0x0004, 0x1b8e: 0x0004, 0x1b8f: 0x0004, 0x1b90: 0x0004, 0x1b91: 0x0004,
	0x1b92: 0x0004, 0x1b93: 0x0004, 0x1b94: 0x0004, 0x1b95: 0x0004, 0x1b96: 0x0004, 0x1b97: 0x0004,
	0x1b98: 0x0004, 0x1b99: 0x0004, 0x1b9a: 0x0004, 0x1b9b: 0x0004, 0x1b9c: 0x0004, 0x1b9d: 0x0004,
	0x1b9e: 0x0004, 0x1b9f: 0x0004, 0x1ba0: 0x0004, 0x1ba1: 0x0004, 0x1ba2: 0x0004, 0x1ba3: 0x0004,
	0x1ba4: 0x0004, 0x1ba5: 0x0004, 0x1ba6: 0x0004,
	// Block 0x6f, offset 0x1bc0
	0x1bc0: 0x0004, 0x1bc1: 0x0004, 0x1bc2: 0x0004, 0x1bc3: 0x0004, 0x1bc4: 0x0004, 0x1bc5: 0x0004,
	0x1bc6: 0x0004, 0x1bc7: 0x0004, 0x1bc8: 0x0004, 0x1bc9: 0x0004, 0x1bca: 0x0004,
	0x1be0: 0x0004, 0x1be1: 0x0004, 0x1be2: 0x0004, 0x1be3: 0x0004,
	0x1be4: 0x0004, 0x1be5: 0x0004, 0x1be6: 0x0004, 0x1be7: 0x0004, 0x1be8: 0x0004, 0x1be9: 0x0004,
	0x1bea: 0x0004, 0x1beb: 0x0004, 0x1bec: 0x0004, 0x1bed: 0x0004, 0x1bee: 0x0004, 0x1bef: 0x0004,
	0x1bf0: 0x0004, 0x1bf1: 0x0004, 0x1bf2: 0x0004, 0x1bf3: 0x0004, 0x1bf4: 0x0004, 0x1bf5: 0x0004,
	0x1bf6: 0x0004, 0x1bf7: 0x0004, 0x1bf8: 0x0004, 0x1bf9: 0x0004, 0x1bfa: 0x0004, 0x1bfb: 0x0004,
	0x1bfc: 0x0004, 0x1bfd: 0x0004, 0x1bfe: 0x0004, 0x1bff: 0x0004,
	// Block 0x70, offset 0x1c00
	0x1c00: 0x0004, 0x1c01: 0x0004, 0x1c02: 0x0004, 0x1c03: 0x0004, 0x1c04: 0x0004, 0x1c05: 0x0004,
	0x1c06: 0x0004, 0x1c07: 0x0004, 0x1c08: 0x0004, 0x1c09: 0x0004, 0x1c0a: 0x0004, 0x1c0b: 0x0004,
	0x1c0c: 0x0004, 0x1c0d: 0x0004, 0x1c0e: 0x0004, 0x1c0f: 0x0004, 0x1c10: 0x0004, 0x1c11: 0x0004,
	0x1c12: 0x0004, 0x1c13: 0x0004, 0x1c14: 0x0004, 0x1c15: 0x0004, 0x1c16: 0x0004, 0x1c17: 0x0004,
	0x1c18: 0x0004, 0x1c19: 0x0004, 0x1c1a: 0x0004, 0x1c1b: 0x0004, 0x1c1c: 0x0004, 0x1c1d: 0x0004,
	0x1c1e: 0x0004, 0x1c1f: 0x0004, 0x1c20: 0x0004, 0x1c21: 0x0004, 0x1c22: 0x0004, 0x1c23: 0x0004,
	0x1c24: 0x0004, 0x1c25: 0x0004, 0x1c26: 0x0004, 0x1c27: 0x0004, 0x1c28: 0x0004, 0x1c29: 0x0004,
	0x1c2a: 0x0004, 0x1c2b: 0x0004, 0x1c2c: 0x0004, 0x1c2d: 0x0004, 0x1c2e: 0x0004, 0x1c2f: 0x0004,
	0x1c30: 0x0004, 0x1c31: 0x0004, 0x1c32: 0x0004, 0x1c33: 0x0004,
	0x1c36: 0x0004, 0x1c37: 0x0004, 0x1c38: 0x0004, 0x1c39: 0x0004, 0x1c3a: 0x0004, 0x1c3b: 0x0004,
	0x1c3c: 0x0004, 0x1c3d: 0x0004, 0x1c3e: 0x0004, 0x1c3f: 0x0004,
	// Block 0x71, offset 0x1c40
	0x1c40: 0x0004, 0x1c41: 0x0004, 0x1c42: 0x0004, 0x1c43: 0x0004, 0x1c44: 0x0004, 0x1c45: 0x0004,
	0x1c46: 0x0004, 0x1c47: 0x0004, 0x1c48: 0x0004, 0x1c49: 0x0004, 0x1c4a: 0x0004, 0x1c4b: 0x0004,
	0x1c4c: 0x0004, 0x1c4d: 0x0004, 0x1c4e: 0x0004, 0x1c4f: 0x0004, 0x1c50: 0x0004, 0x1c51: 0x0004,
	0x1c52: 0x0004, 0x1c53: 0x0004, 0x1c54: 0x0004, 0x1c55: 0x0004,
	0x1c58: 0x0004, 0x1c59: 0x0004, 0x1c5a: 0x0004, 0x1c5b: 0x0004, 0x1c5c: 0x0004, 0x1c5d: 0x0004,
	0x1c5e: 0x0004, 0x1c5f: 0x0004, 0x1c60: 0x0004, 0x1c61: 0x0004, 0x1c62: 0x0004, 0x1c63: 0x0004,
	0x1c64: 0x0004, 0x1c65: 0x0004, 0x1c66: 0x0004, 0x1c67: 0x0004, 0x1c68: 0x0004, 0x1c69: 0x0004,
	0x1c6a: 0x0004, 0x1c6b: 0x0004, 0x1c6c: 0x0004, 0x1c6d: 0x0004, 0x1c6e: 0x0004, 0x1c6f: 0x0004,
	0x1c70: 0x0004, 0x1c71: 0x0004, 0x1c72: 0x0004, 0x1c73: 0x0004, 0x1c74: 0x0004, 0x1c75: 0x0004,
	0x1c76: 0x0004, 0x1c77: 0x0004, 0x1c78: 0x0004, 0x1c79: 0x0004,
	0x1c7d: 0x0004, 0x1c7e: 0x0004, 0x1c7f: 0x0004,
	// Block 0x72, offset 0x1c80
	0x1c80: 0x0004, 0x1c81: 0x0004, 0x1c82: 0x0004, 0x1c83: 0x0004, 0x1c84: 0x0004, 0x1c85: 0x0004,
	0x1c86: 0x0004, 0x1c87: 0x0004, 0x1c88: 0x0004, 0x1c8a: 0x0004, 0x1c8b: 0x0004,
	0x1c8c: 0x0004, 0x1c8d: 0x0004, 0x1c8e: 0x0004, 0x1c8f: 0x0004, 0x1c90: 0x0004, 0x1c91: 0x0004,
	0x1cac: 0x0004, 0x1cad: 0x0004, 0x1cae: 0x0004, 0x1caf: 0x0004,
	// Block 0x73, offset 0x1cc0
	0x1cc0: 0x0005, 0x1cc1: 0x0005, 0x1cc2: 0x0005, 0x1cc3: 0x0005, 0x1cc4: 0x0005, 0x1cc5: 0x0005,
	0x1cc6: 0x0005, 0x1cc7: 0x0005, 0x1cc8: 0x0005, 0x1cc9: 0x0005, 0x1cca: 0x0005, 0x1ccb: 0x0005,
	0x1ccc: 0x0005, 0x1ccd: 0x0005, 0x1cce: 0x0005, 0x1ccf: 0x0005, 0x1cd0: 0x0005, 0x1cd1: 0x0005,
	0x1cd2: 0x0005, 0x1cd3: 0x0005, 0x1cd4: 0x0005, 0x1cd5: 0x0005, 0x1cd6: 0x0005, 0x1cd7: 0x0005,
	0x1cd8: 0x0005, 0x1cd9: 0x0005, 0x1cda: 0x0005, 0x1cdb: 0x0005, 0x1cdc: 0x0005, 0x1cdd: 0x0005,
	0x1cde: 0x0005, 0x1cdf: 0x0005, 0x1ce0: 0x0005, 0x1ce1: 0x0005, 0x1ce2: 0x0005, 0x1ce3: 0x0005,
	0x1ce4: 0x0005, 0x1ce5: 0x0005, 0x1ce6: 0x0005, 0x1ce7: 0x0005, 0x1ce8: 0x0005, 0x1ce9: 0x0005,
	0x1cea: 0x0005, 0x1ceb: 0x0005, 0x1cec: 0x0005, 0x1ced: 0x0005, 0x1cee: 0x0005,
	0x1cf0: 0x0005, 0x1cf1: 0x0005, 0x1cf2: 0x0005, 0x1cf3: 0x0005, 0x1cf4: 0x0005, 0x1cf5: 0x0005,
	0x1cf6: 0x0005, 0x1cf7: 0x0005, 0x1cf8: 0x0005, 0x1cf9: 0x0005, 0x1cfa: 0x0005, 0x1cfb: 0x0005,
	0x1cfc: 0x0005, 0x1cfd: 0x0005, 0x1cfe: 0x0005, 0x1cff: 0x0005,
	// Block 0x74, offset 0x1d00
	0x1d00: 0x0005, 0x1d01: 0x0005, 0x1d02: 0x0005, 0x1d03: 0x0005, 0x1d04: 0x0005, 0x1d05: 0x0005,
	0x1d06: 0x0005, 0x1d07: 0x0005, 0x1d08: 0x0005, 0x1d09: 0x0005, 0x1d0a: 0x0005, 0x1d0b: 0x0005,
	0x1d0c: 0x0005, 0x1d0d: 0x0005, 0x1d0e: 0x0005, 0x1d0f: 0x0005, 0x1d10: 0x0005, 0x1d11: 0x0005,
	0x1d12: 0x0005, 0x1d13: 0x0005, 0x1d14: 0x0005, 0x1d15: 0x0005, 0x1d16: 0x0005, 0x1d17: 0x0005,
	0x1d18: 0x0005, 0x1d19: 0x0005, 0x1d1a: 0x0005, 0x1d1b: 0x0005, 0x1d1c: 0x0005, 0x1d1d: 0x0005,
	0x1d1e: 0x0005, 0x1d20: 0x0005, 0x1d21: 0x0005, 0x1d22: 0x0005, 0x1d23: 0x0005,
	0x1d24: 0x0005, 0x1d25: 0x0005, 0x1d26: 0x0005, 0x1d27: 0x0005, 0x1d28: 0x0005, 0x1d29: 0x0005,
	0x1d2a: 0x0005, 0x1d2b: 0x0005, 0x1d2c: 0x0005, 0x1d2d: 0x0005, 0x1d2e: 0x0005, 0x1d2f: 0x0005,
	0x1d30: 0x0005, 0x1d31: 0x0005, 0x1d32: 0x0005, 0x1d33: 0x0005, 0x1d34: 0x0005, 0x1d35: 0x0005,
	0x1d36: 0x0005, 0x1d37: 0x0005, 0x1d38: 0x0005, 0x1d39: 0x0005, 0x1d3a: 0x0005, 0x1d3b: 0x0005,
	0x1d3c: 0x0004, 0x1d3d: 0x0004, 0x1d3e: 0x0005, 0x1d3f: 0x0005,
	// Block 0x75, offset 0x1d40
	0x1d40: 0x0005, 0x1d41: 0x0005, 0x1d42: 0x0005, 0x1d43: 0x0005, 0x1d44: 0x0005, 0x1d45: 0x0005,
	0x1d46: 0x0005, 0x1d47: 0x0005, 0x1d48: 0x0005, 0x1d49: 0x0005, 0x1d4a: 0x0005, 0x1d4b: 0x0005,
	0x1d4c: 0x0005, 0x1d4d: 0x0005, 0x1d4e: 0x0005, 0x1d4f: 0x0005, 0x1d50: 0x0005, 0x1d51: 0x0005,
	0x1d52: 0x0005, 0x1d53: 0x0005, 0x1d54: 0x0005, 0x1d55: 0x0005, 0x1d56: 0x0005, 0x1d57: 0x0005,
	0x1d58: 0x0005, 0x1d59: 0x0005, 0x1d5a: 0x0005, 0x1d5b: 0x0005, 0x1d5c: 0x0005, 0x1d5d: 0x0005,
	0x1d5e: 0x0005, 0x1d5f: 0x0005, 0x1d60: 0x0005, 0x1d61: 0x0005, 0x1d62: 0x0005, 0x1d63: 0x0005,
	0x1d64: 0x0005, 0x1d65: 0x0004, 0x1d66: 0x0004, 0x1d67: 0x0004, 0x1d68: 0x0004, 0x1d69: 0x0004,
	0x1d6a: 0x0004, 0x1d6b: 0x0005, 0x1d6c: 0x0005, 0x1d6d: 0x0005, 0x1d6e: 0x0005, 0x1d6f: 0x0005,
	0x1d70: 0x0005, 0x1d71: 0x0005, 0x1d72: 0x0005, 0x1d73: 0x0005,
	0x1d79: 0x0004, 0x1d7a: 0x0004, 0x1d7b: 0x0004,
	0x1d7c: 0x0004, 0x1d7d: 0x0004, 0x1d7e: 0x0004, 0x1d7f: 0x0004,
	// Block 0x76, offset 0x1d80
	0x1d80: 0x0005, 0x1d81: 0x0005, 0x1d82: 0x0005, 0x1d83: 0x0005, 0x1d84: 0x0005, 0x1d85: 0x0005,
	0x1d86: 0x0005, 0x1d87: 0x0005, 0x1d88: 0x0005, 0x1d89: 0x0005, 0x1d8a: 0x0005, 0x1d8b: 0x0005,
	0x1d8c: 0x0005, 0x1d8d: 0x0005, 0x1d8e: 0x0005, 0x1d8f: 0x0005, 0x1d90: 0x0005, 0x1d91: 0x0005,
	0x1d92: 0x0005, 0x1d93: 0x0005, 0x1d94: 0x0005, 0x1d95: 0x0005, 0x1d96: 0x0005, 0x1d97: 0x0005,
	0x1d98: 0x0005, 0x1d99: 0x0005, 0x1d9a: 0x0005, 0x1d9b: 0x0005, 0x1d9c: 0x0005, 0x1d9d: 0x0005,
	0x1d9e: 0x0005, 0x1d9f: 0x0005, 0x1da0: 0x0005, 0x1da1: 0x0005, 0x1da2: 0x0005, 0x1da3: 0x0005,
	0x1da4: 0x0005, 0x1da5: 0x0005, 0x1da7: 0x0005,
	0x1dad: 0x0005,
	0x1db0: 0x0005, 0x1db1: 0x0005, 0x1db2: 0x0005, 0x1db3: 0x0005, 0x1db4: 0x0005, 0x1db5: 0x0005,
	0x1db6: 0x0005, 0x1db7: 0x0005, 0x1db8: 0x0005, 0x1db9: 0x0005, 0x1dba: 0x0005, 0x1dbb: 0x0005,
	0x1dbc: 0x0005, 0x1dbd: 0x0005, 0x1dbe: 0x0005, 0x1dbf: 0x0005,
	// Block 0x77, offset 0x1dc0
	0x1dc0: 0x0005, 0x1dc1: 0x0005, 0x1dc2: 0x0005, 0x1dc3: 0x0005, 0x1dc4: 0x0005, 0x1dc5: 0x0005,
	0x1dc6: 0x0005, 0x1dc7: 0x0005, 0x1dc8: 0x0005, 0x1dc9: 0x0005, 0x1dca: 0x0005, 0x1dcb: 0x0005,
	0x1dcc: 0x0005, 0x1dcd: 0x0005, 0x1dce: 0x0005, 0x1dcf: 0x0005, 0x1dd0: 0x0005, 0x1dd1: 0x0005,
	0x1dd2: 0x0005, 0x1dd3: 0x0005, 0x1dd4: 0x0005, 0x1dd5: 0x0005, 0x1dd6: 0x0005, 0x1dd7: 0x0005,
	0x1dd8: 0x0005, 0x1dd9: 0x0005, 0x1dda: 0x0005, 0x1ddb: 0x0005, 0x1ddc: 0x0005, 0x1ddd: 0x0005,
	0x1dde: 0x0005, 0x1ddf: 0x0005, 0x1de0: 0x0005, 0x1de1: 0x0005, 0x1de2: 0x0005, 0x1de3: 0x0005,
	0x1de4: 0x0005, 0x1de5: 0x0005, 0x1de6: 0x0005, 0x1de7: 0x0005,
	0x1def: 0x0004,
	0x1df0: 0x0004,
	0x1dff: 0x0005,
	// Block 0x78, offset 0x1e00
	0x1e00: 0x0005, 0x1e01: 0x0005, 0x1e02: 0x0005, 0x1e03: 0x0005, 0x1e04: 0x0005, 0x1e05: 0x0005,
	0x1e06: 0x0005, 0x1e07: 0x0005, 0x1e08: 0x0005, 0x1e09: 0x0005, 0x1e0a: 0x0005, 0x1e0b: 0x0005,
	0x1e0c: 0x0005, 0x1e0d: 0x0005, 0x1e0e: 0x0005, 0x1e0f: 0x0005, 0x1e10: 0x0005, 0x1e11: 0x0005,
	0x1e12: 0x0005, 0x1e13: 0x0005, 0x1e14: 0x0005, 0x1e15: 0x0005, 0x1e16: 0x0005,
	0x1e20: 0x0005, 0x1e21: 0x0005, 0x1e22: 0x0005, 0x1e23: 0x0005,
	0x1e24: 0x0005, 0x1e25: 0x0005, 0x1e26: 0x0005, 0x1e28: 0x0005, 0x1e29: 0x0005,
	0x1e2a: 0x0005, 0x1e2b: 0x0005, 0x1e2c: 0x0005, 0x1e2d: 0x0005, 0x1e2e: 0x0005,
	0x1e30: 0x0005, 0x1e31: 0x0005, 0x1e32: 0x0005, 0x1e33: 0x0005, 0x1e34: 0x0005, 0x1e35: 0x0005,
	0x1e36: 0x0005, 0x1e38: 0x0005, 0x1e39: 0x0005, 0x1e3a: 0x0005, 0x1e3b: 0x0005,
	0x1e3c: 0x0005, 0x1e3d: 0x0005, 0x1e3e: 0x0005,
	// Block 0x79, offset 0x1e40
	0x1e40: 0x0005, 0x1e41: 0x0005, 0x1e42: 0x0005, 0x1e43: 0x0005, 0x1e44: 0x0005, 0x1e45: 0x0005,
	0x1e46: 0x0005, 0x1e48: 0x0005, 0x1e49: 0x0005, 0x1e4a: 0x0005, 0x1e4b: 0x0005,
	0x1e4c: 0x0005, 0x1e4d: 0x0005, 0x1e4e: 0x0005, 0x1e50: 0x0005, 0x1e51: 0x0005,
	0x1e52: 0x0005, 0x1e53: 0x0005, 0x1e54: 0x0005, 0x1e55: 0x0005, 0x1e56: 0x0005,
	0x1e58: 0x0005, 0x1e59: 0x0005, 0x1e5a: 0x0005, 0x1e5b: 0x0005, 0x1e5c: 0x0005, 0x1e5d: 0x0005,
	0x1e5e: 0x0005, 0x1e60: 0x0005, 0x1e61: 0x0005, 0x1e62: 0x0005, 0x1e63: 0x0005,
	0x1e64: 0x0005, 0x1e65: 0x0005, 0x1e66: 0x0005, 0x1e67: 0x0005, 0x1e68: 0x0005, 0x1e69: 0x0005,
	0x1e6a: 0x0005, 0x1e6b: 0x0005, 0x1e6c: 0x0005, 0x1e6d: 0x0005, 0x1e6e: 0x0005, 0x1e6f: 0x0005,
	0x1e70: 0x0005, 0x1e71: 0x0005, 0x1e72: 0x0005, 0x1e73: 0x0005, 0x1e74: 0x0005, 0x1e75: 0x0005,
	0x1e76: 0x0005, 0x1e77: 0x0005, 0x1e78: 0x0005, 0x1e79: 0x0005, 0x1e7a: 0x0005, 0x1e7b: 0x0005,
	0x1e7c: 0x0005, 0x1e7d: 0x0005, 0x1e7e: 0x0005, 0x1e7f: 0x0005,
	// Block 0x7a, offset 0x1e80
	0x1e80: 0x0004, 0x1e81: 0x0004, 0x1e82: 0x0004, 0x1e83: 0x0004, 0x1e84: 0x0004, 0x1e85: 0x0004,
	0x1e86: 0x0004, 0x1e87: 0x0004, 0x1e88: 0x0004, 0x1e89: 0x0004, 0x1e8a: 0x0004, 0x1e8b: 0x0004,
	0x1e8c: 0x0004, 0x1e8d: 0x0004, 0x1e8e: 0x0004, 0x1e8f: 0x0004, 0x1e90: 0x0004, 0x1e91: 0x0004,
	0x1e92: 0x0004, 0x1e93: 0x0004, 0x1e94: 0x0004, 0x1e95: 0x0004, 0x1e96: 0x0004, 0x1e97: 0x0004,
	0x1e98: 0x0004, 0x1e99: 0x0004, 0x1e9a: 0x0004, 0x1e9b: 0x0004, 0x1e9c: 0x0004, 0x1e9d: 0x0004,
	0x1e9e: 0x0004, 0x1e9f: 0x0004, 0x1ea0: 0x0004, 0x1ea1: 0x0004, 0x1ea2: 0x0004, 0x1ea3: 0x0004,
	0x1ea4: 0x0004, 0x1ea5: 0x0004, 0x1ea6: 0x0004, 0x1ea7: 0x0004, 0x1ea8: 0x0004, 0x1ea9: 0x0004,
	0x1eaa: 0x0004, 0x1eab: 0x0004, 0x1eac: 0x0004, 0x1ead: 0x0004, 0x1eae: 0x0004, 0x1eaf: 0x0005,
	0x1eb0: 0x0004, 0x1eb1: 0x0004, 0x1eb2: 0x0004, 0x1eb3: 0x0004, 0x1eb4: 0x0004, 0x1eb5: 0x0004,
	0x1eb6: 0x0004, 0x1eb7: 0x0004, 0x1eb8: 0x0004, 0x1eb9: 0x0004, 0x1eba: 0x0004, 0x1ebb: 0x0004,
	0x1ebc: 0x0004, 0x1ebd: 0x0004, 0x1ebe: 0x0004, 0x1ebf: 0x0004,
	// Block 0x7b, offset 0x1ec0
	0x1ec0: 0x0004, 0x1ec1: 0x0004, 0x1ec2: 0x0004,
	// Block 0x7c, offset 0x1f00
	0x1f00: 0x0004, 0x1f01: 0x0004, 0x1f02: 0x0004, 0x1f03: 0x0004, 0x1f04: 0x0004, 0x1f05: 0x0004,
	0x1f06: 0x0004, 0x1f07: 0x0004, 0x1f08: 0x0004, 0x1f09: 0x0004, 0x1f0a: 0x0004, 0x1f0b: 0x0004,
	0x1f0c: 0x0004, 0x1f0d: 0x0004, 0x1f0e: 0x0004, 0x1f0f: 0x0004, 0x1f10: 0x0004, 0x1f11: 0x0004,
	0x1f12: 0x0004, 0x1f13: 0x0004, 0x1f14: 0x0004, 0x1f15: 0x0004, 0x1f16: 0x0004, 0x1f17: 0x0004,
	0x1f18: 0x0004, 0x1f19: 0x0004, 0x1f1b: 0x0004, 0x1f1c: 0x0004, 0x1f1d: 0x0004,
	0x1f1e: 0x0004, 0x1f1f: 0x0004, 0x1f20: 0x0004, 0x1f21: 0x0004, 0x1f22: 0x0004, 0x1f23: 0x0004,
	0x1f24: 0x0004, 0x1f25: 0x0004, 0x1f26: 0x0004, 0x1f27: 0x0004, 0x1f28: 0x0004, 0x1f29: 0x0004,
	0x1f2a: 0x0004, 0x1f2b: 0x0004, 0x1f2c: 0x0004, 0x1f2d: 0x0004, 0x1f2e: 0x0004, 0x1f2f: 0x0004,
	0x1f30: 0x0004, 0x1f31: 0x0004, 0x1f32: 0x0004, 0x1f33: 0x0004, 0x1f34: 0x0004, 0x1f35: 0x0004,
	0x1f36: 0x0004, 0x1f37: 0x0004, 0x1f38: 0x0004, 0x1f39: 0x0004, 0x1f3a: 0x0004, 0x1f3b: 0x0004,
	0x1f3c: 0x0004, 0x1f3d: 0x0004, 0x1f3e: 0x0004, 0x1f3f: 0x0004,
	// Block 0x7d, offset 0x1f40
	0x1f40: 0x0004, 0x1f41: 0x0004, 0x1f42: 0x0004, 0x1f43: 0x0004, 0x1f44: 0x0004, 0x1f45: 0x0004,
	0x1f46: 0x0004, 0x1f47: 0x0004, 0x1f48: 0x0004, 0x1f49: 0x0004, 0x1f4a: 0x0004, 0x1f4b: 0x0004,
	0x1f4c: 0x0004, 0x1f4d: 0x0004, 0x1f4e: 0x0004, 0x1f4f: 0x0004, 0x1f50: 0x0004, 0x1f51: 0x0004,
	0x1f52: 0x0004, 0x1f53: 0x0004, 0x1f54: 0x0004, 0x1f55: 0x0004, 0x1f56: 0x0004, 0x1f57: 0x0004,
	0x1f58: 0x0004, 0x1f59: 0x0004, 0x1f5a: 0x0004, 0x1f5b: 0x0004, 0x1f5c: 0x0004, 0x1f5d: 0x0004,
	0x1f5e: 0x0004, 0x1f5f: 0x0004, 0x1f60: 0x0004, 0x1f61: 0x0004, 0x1f62: 0x0004, 0x1f63: 0x0004,
	0x1f64: 0x0004, 0x1f65: 0x0004, 0x1f66: 0x0004, 0x1f67: 0x0004, 0x1f68: 0x0004, 0x1f69: 0x0004,
	0x1f6a: 0x0004, 0x1f6b: 0x0004, 0x1f6c: 0x0004, 0x1f6d: 0x0004, 0x1f6e: 0x0004, 0x1f6f: 0x0004,
	0x1f70: 0x0004, 0x1f71: 0x0004, 0x1f72: 0x0004, 0x1f73: 0x0004,
	// Block 0x7e, offset 0x1f80
	0x1f80: 0x0004, 0x1f81: 0x0004, 0x1f82: 0x0004, 0x1f83: 0x0004, 0x1f84: 0x0004, 0x1f85: 0x0004,
	0x1f86: 0x0004, 0x1f87: 0x0004, 0x1f88: 0x0004, 0x1f89: 0x0004, 0x1f8a: 0x0004, 0x1f8b: 0x0004,
	0x1f8c: 0x0004, 0x1f8d: 0x0004, 0x1f8e: 0x0004, 0x1f8f: 0x0004, 0x1f90: 0x0004, 0x1f91: 0x0004,
	0x1f92: 0x0004, 0x1f93: 0x0004, 0x1f94: 0x0004, 0x1f95: 0x0004,
	0x1fb0: 0x0004, 0x1fb1: 0x0004, 0x1fb2: 0x0004, 0x1fb3: 0x0004, 0x1fb4: 0x0004, 0x1fb5: 0x0004,
	0x1fb6: 0x0004, 0x1fb7: 0x0004, 0x1fb8: 0x0004, 0x1fb9: 0x0004, 0x1fba: 0x0004, 0x1fbb: 0x0004,
	// Block 0x7f, offset 0x1fc0
	0x1fc0: 0x0004, 0x1fc1: 0x0004, 0x1fc2: 0x0004, 0x1fc3: 0x0004, 0x1fc4: 0x0004, 0x1fc5: 0x0005,
	0x1fc6: 0x0005, 0x1fc7: 0x0005, 0x1fc8: 0x0004, 0x1fc9: 0x0004, 0x1fca: 0x0004, 0x1fcb: 0x0004,
	0x1fcc: 0x0004, 0x1fcd: 0x0004, 0x1fce: 0x0004, 0x1fcf: 0x0004, 0x1fd0: 0x0004, 0x1fd1: 0x0004,
	0x1fd2: 0x0004, 0x1fd3: 0x0004, 0x1fd4: 0x0004, 0x1fd5: 0x0004, 0x1fd6: 0x0004, 0x1fd7: 0x0004,
	0x1fd8: 0x0004, 0x1fd9: 0x0004, 0x1fda: 0x0004, 0x1fdb: 0x0004, 0x1fdc: 0x0004, 0x1fdd: 0x0004,
	0x1fde: 0x0004, 0x1fdf: 0x0004, 0x1fe0: 0x0004, 0x1fe1: 0x0004, 0x1fe2: 0x0004, 0x1fe3: 0x0004,
	0x1fe4: 0x0004, 0x1fe5: 0x0004, 0x1fe6: 0x0004, 0x1fe7: 0x0004, 0x1fe8: 0x0004, 0x1fe9: 0x0004,
	0x1fea: 0x0005, 0x1feb: 0x0005, 0x1fec: 0x0005, 0x1fed: 0x0005, 0x1fee: 0x0001, 0x1fef: 0x0001,
	0x1ff0: 0x0004, 0x1ff1: 0x0001, 0x1ff2: 0x0001, 0x1ff3: 0x0001, 0x1ff4: 0x0001, 0x1ff5: 0x0001,
	0x1ff6: 0x0004, 0x1ff7: 0x0004, 0x1ff8: 0x0004, 0x1ff9: 0x0004, 0x1ffa: 0x0004, 0x1ffb: 0x0001,
	0x1ffc: 0x0005, 0x1ffd: 0x0004, 0x1ffe: 0x0004, 0x1fff: 0x0004,
	// Block 0x80, offset 0x2000
	0x2001: 0x0005, 0x2002: 0x0005, 0x2003: 0x0005, 0x2004: 0x0005, 0x2005: 0x0005,
	0x2006: 0x0005, 0x2007: 0x0005, 0x2008: 0x0005, 0x2009: 0x0005, 0x200a: 0x0005, 0x200b: 0x0005,
	0x200c: 0x0005, 0x200d: 0x0005, 0x200e: 0x0005, 0x200f: 0x0005, 0x2010: 0x0005, 0x2011: 0x0005,
	0x2012: 0x0005, 0x2013: 0x0005, 0x2014: 0x0005, 0x2015: 0x0005, 0x2016: 0x0005, 0x2017: 0x0005,
	0x2018: 0x0005, 0x2019: 0x0005, 0x201a: 0x0005, 0x201b: 0x0005, 0x201c: 0x0005, 0x201d: 0x0005,
	0x201e: 0x0005, 0x201f: 0x0005, 0x2020: 0x0005, 0x2021: 0x0005, 0x2022: 0x0005, 0x2023: 0x0005,
	0x2024: 0x0005, 0x2025: 0x0005, 0x2026: 0x0005, 0x2027: 0x0005, 0x2028: 0x0005, 0x2029: 0x0005,
	0x202a: 0x0005, 0x202b: 0x0005, 0x202c: 0x0005, 0x202d: 0x0005, 0x202e: 0x0005, 0x202f: 0x0005,
	0x2030: 0x0005, 0x2031: 0x0005, 0x2032: 0x0005, 0x2033: 0x0005, 0x2034: 0x0005, 0x2035: 0x0005,
	0x2036: 0x0005, 0x2037: 0x0005, 0x2038: 0x0005, 0x2039: 0x0005, 0x203a: 0x0005, 0x203b: 0x0005,
	0x203c: 0x0005, 0x203d: 0x0005, 0x203e: 0x0005, 0x203f: 0x0005,
	// Block 0x81, offset 0x2040
	0x2040: 0x0005, 0x2041: 0x0005, 0x2042: 0x0005, 0x2043: 0x0005, 0x2044: 0x0005, 0x2045: 0x0005,
	0x2046: 0x0005, 0x2047: 0x0005, 0x2048: 0x0005, 0x2049: 0x0005, 0x204a: 0x0005, 0x204b: 0x0005,
	0x204c: 0x0005, 0x204d: 0x0005, 0x204e: 0x0005, 0x204f: 0x0005, 0x2050: 0x0005, 0x2051: 0x0005,
	0x2052: 0x0005, 0x2053: 0x0005, 0x2054: 0x0005, 0x2055: 0x0005, 0x2056: 0x0005,
	0x2059: 0x0005, 0x205a: 0x0005, 0x205b: 0x0004, 0x205c: 0x0004, 0x205d: 0x0005,
	0x205e: 0x0005, 0x205f: 0x0004, 0x2060: 0x0004, 0x2061: 0x0005, 0x2062: 0x0005, 0x2063: 0x0005,
	0x2064: 0x0005, 0x2065: 0x0005, 0x2066: 0x0005, 0x2067: 0x0005, 0x2068: 0x0005, 0x2069: 0x0005,
	0x206a: 0x0005, 0x206b: 0x0005, 0x206c: 0x0005, 0x206d: 0x0005, 0x206e: 0x0005, 0x206f: 0x0005,
	0x2070: 0x0005, 0x2071: 0x0005, 0x2072: 0x0005, 0x2073: 0x0005, 0x2074: 0x0005, 0x2075: 0x0005,
	0x2076: 0x0005, 0x2077: 0x0005, 0x2078: 0x0005, 0x2079: 0x0005, 0x207a: 0x0005, 0x207b: 0x0005,
	0x207c: 0x0005, 0x207d: 0x0005, 0x207e: 0x0005, 0x207f: 0x0005,
	// Block 0x82, offset 0x2080
	0x2080: 0x0005, 0x2081: 0x0005, 0x2082: 0x0005, 0x2083: 0x0005, 0x2084: 0x0005, 0x2085: 0x0005,
	0x2086: 0x0005, 0x2087: 0x0005, 0x2088: 0x0005, 0x2089: 0x0005, 0x208a: 0x0005, 0x208b: 0x0005,
	0x208c: 0x0005, 0x208d: 0x0005, 0x208e: 0x0005, 0x208f: 0x0005, 0x2090: 0x0005, 0x2091: 0x0005,
	0x2092: 0x0005, 0x2093: 0x0005, 0x2094: 0x0005, 0x2095: 0x0005, 0x2096: 0x0005, 0x2097: 0x0005,
	0x2098: 0x0005, 0x2099: 0x0005, 0x209a: 0x0005, 0x209b: 0x0005, 0x209c: 0x0005, 0x209d: 0x0005,
	0x209e: 0x0005, 0x209f: 0x0005, 0x20a0: 0x0005, 0x20a1: 0x0005, 0x20a2: 0x0005, 0x20a3: 0x0005,
	0x20a4: 0x0005, 0x20a5: 0x0005, 0x20a6: 0x0005, 0x20a7: 0x0005, 0x20a8: 0x0005, 0x20a9: 0x0005,
	0x20aa: 0x0005, 0x20ab: 0x0005, 0x20ac: 0x0005, 0x20ad: 0x0005, 0x20ae: 0x0005, 0x20af: 0x0005,
	0x20b0: 0x0005, 0x20b1: 0x0005, 0x20b2: 0x0005, 0x20b3: 0x0005, 0x20b4: 0x0005, 0x20b5: 0x0005,
	0x20b6: 0x0005, 0x20b7: 0x0005, 0x20b8: 0x0005, 0x20b9: 0x0005, 0x20ba: 0x0005, 0x20bb: 0x0002,
	0x20bc: 0x0005, 0x20bd: 0x0005, 0x20be: 0x0005, 0x20bf: 0x0004,
	// Block 0x83, offset 0x20c0
	0x20c5: 0x0005,
	0x20c6: 0x0005, 0x20c7: 0x0005, 0x20c8: 0x0005, 0x20c9: 0x0005, 0x20ca: 0x0005, 0x20cb: 0x0005,
	0x20cc: 0x0005, 0x20cd: 0x0005, 0x20ce: 0x0005, 0x20cf: 0x0005, 0x20d0: 0x0005, 0x20d1: 0x0005,
	0x20d2: 0x0005, 0x20d3: 0x0005, 0x20d4: 0x0005, 0x20d5: 0x0005, 0x20d6: 0x0005, 0x20d7: 0x0005,
	0x20d8: 0x0005, 0x20d9: 0x0005, 0x20da: 0x0005, 0x20db: 0x0005, 0x20dc: 0x0005, 0x20dd: 0x0005,
	0x20de: 0x0005, 0x20df: 0x0005, 0x20e0: 0x0005, 0x20e1: 0x0005, 0x20e2: 0x0005, 0x20e3: 0x0005,
	0x20e4: 0x0005, 0x20e5: 0x0005, 0x20e6: 0x0005, 0x20e7: 0x0005, 0x20e8: 0x0005, 0x20e9: 0x0005,
	0x20ea: 0x0005, 0x20eb: 0x0005, 0x20ec: 0x0005, 0x20ed: 0x0005,
	0x20f1: 0x0004, 0x20f2: 0x0004, 0x20f3: 0x0004, 0x20f4: 0x0004, 0x20f5: 0x0004,
	0x20f6: 0x0004, 0x20f7: 0x0004, 0x20f8: 0x0004, 0x20f9: 0x0004, 0x20fa: 0x0004, 0x20fb: 0x0004,
	0x20fc: 0x0004, 0x20fd: 0x0004, 0x20fe: 0x0004, 0x20ff: 0x0004,
	// Block 0x84, offset 0x2100
	0x2100: 0x0004, 0x2101: 0x0004, 0x2102: 0x0004, 0x2103: 0x0004, 0x2104: 0x0004, 0x2105: 0x0004,
	0x2106: 0x0004, 0x2107: 0x0004, 0x2108: 0x0004, 0x2109: 0x0004, 0x210a: 0x0004, 0x210b: 0x0004,
	0x210c: 0x0004, 0x210d: 0x0004, 0x210e: 0x0004, 0x210f: 0x0004, 0x2110: 0x0004, 0x2111: 0x0004,
	0x2112: 0x0004, 0x2113: 0x0004, 0x2114: 0x0004, 0x2115: 0x0004, 0x2116: 0x0004, 0x2117: 0x0004,
	0x2118: 0x0004, 0x2119: 0x0004, 0x211a: 0x0004, 0x211b: 0x0004, 0x211c: 0x0004, 0x211d: 0x0004,
	0x211e: 0x0004, 0x211f: 0x0004, 0x2120: 0x0004, 0x2121: 0x0004, 0x2122: 0x0004, 0x2123: 0x0004,
	0x2124: 0x0001, 0x2125: 0x0004, 0x2126: 0x0004, 0x2127: 0x0004, 0x2128: 0x0004, 0x2129: 0x0004,
	0x212a: 0x0004, 0x212b: 0x0004, 0x212c: 0x0004, 0x212d: 0x0004, 0x212e: 0x0004, 0x212f: 0x0004,
	0x2130: 0x0004, 0x2131: 0x0004, 0x2132: 0x0004, 0x2133: 0x0004, 0x2134: 0x0004, 0x2135: 0x0004,
	0x2136: 0x0004, 0x2137: 0x0004, 0x2138: 0x0004, 0x2139: 0x0004, 0x213a: 0x0004, 0x213b: 0x0004,
	0x213c: 0x0004, 0x213d: 0x0004, 0x213e: 0x0004, 0x213f: 0x0004,
	// Block 0x85, offset 0x2140
	0x2140: 0x0004, 0x2141: 0x0004, 0x2142: 0x0004, 0x2143: 0x0004, 0x2144: 0x0004, 0x2145: 0x0004,
	0x2146: 0x0004, 0x2147: 0x0004, 0x2148: 0x0004, 0x2149: 0x0004, 0x214a: 0x0004, 0x214b: 0x0004,
	0x214c: 0x0004, 0x214d: 0x0004, 0x214e: 0x0004, 0x2150: 0x0004, 0x2151: 0x0004,
	0x2152: 0x0004, 0x2153: 0x0004, 0x2154: 0x0004, 0x2155: 0x0004, 0x2156: 0x0004, 0x2157: 0x0004,
	0x2158: 0x0004, 0x2159: 0x0004, 0x215a: 0x0004, 0x215b: 0x0004, 0x215c: 0x0004, 0x215d: 0x0004,
	0x215e: 0x0004, 0x215f: 0x0004, 0x2160: 0x0005, 0x2161: 0x0005, 0x2162: 0x0005, 0x2163: 0x0005,
	0x2164: 0x0005, 0x2165: 0x0005, 0x2166: 0x0005, 0x2167: 0x0005, 0x2168: 0x0005, 0x2169: 0x0005,
	0x216a: 0x0005, 0x216b: 0x0005, 0x216c: 0x0005, 0x216d: 0x0005, 0x216e: 0x0005, 0x216f: 0x0005,
	0x2170: 0x0005, 0x2171: 0x0005, 0x2172: 0x0005, 0x2173: 0x0005, 0x2174: 0x0005, 0x2175: 0x0005,
	0x2176: 0x0005, 0x2177: 0x0005, 0x2178: 0x0005, 0x2179: 0x0005, 0x217a: 0x0005,
	// Block 0x86, offset 0x2180
	0x2180: 0x0004, 0x2181: 0x0004, 0x2182: 0x0004, 0x2183: 0x0004, 0x2184: 0x0004, 0x2185: 0x0004,
	0x2186: 0x0004, 0x2187: 0x0004, 0x2188: 0x0004, 0x2189: 0x0004, 0x218a: 0x0004, 0x218b: 0x0004,
	0x218c: 0x0004, 0x218d: 0x0004, 0x218e: 0x0004, 0x218f: 0x0004, 0x2190: 0x0004, 0x2191: 0x0004,
	0x2192: 0x0004, 0x2193: 0x0004, 0x2194: 0x0004, 0x2195: 0x0004, 0x2196: 0x0004, 0x2197: 0x0004,
	0x2198: 0x0004, 0x2199: 0x0004, 0x219a: 0x0004, 0x219b: 0x0004, 0x219c: 0x0004, 0x219d: 0x0004,
	0x219e: 0x0004, 0x219f: 0x0004, 0x21a0: 0x0004, 0x21a1: 0x0004, 0x21a2: 0x0004, 0x21a3: 0x0004,
	0x21b0: 0x0005, 0x21b1: 0x0005, 0x21b2: 0x0005, 0x21b3: 0x0005, 0x21b4: 0x0005, 0x21b5: 0x0005,
	0x21b6: 0x0005, 0x21b7: 0x0005, 0x21b8: 0x0005, 0x21b9: 0x0005, 0x21ba: 0x0005, 0x21bb: 0x0005,
	0x21bc: 0x0005, 0x21bd: 0x0005, 0x21be: 0x0005, 0x21bf: 0x0005,
	// Block 0x87, offset 0x21c0
	0x21c0: 0x0004, 0x21c1: 0x0004, 0x21c2: 0x0004, 0x21c3: 0x0004, 0x21c4: 0x0004, 0x21c5: 0x0004,
	0x21c6: 0x0004, 0x21c7: 0x0004, 0x21c8: 0x0004, 0x21c9: 0x0004, 0x21ca: 0x0004, 0x21cb: 0x0004,
	0x21cc: 0x0004, 0x21cd: 0x0004, 0x21ce: 0x0004, 0x21cf: 0x0004, 0x21d0: 0x0004, 0x21d1: 0x0004,
	0x21d2: 0x0004, 0x21d3: 0x0004, 0x21d4: 0x0004, 0x21d5: 0x0004, 0x21d6: 0x0004, 0x21d7: 0x0004,
	0x21d8: 0x0004, 0x21d9: 0x0004, 0x21da: 0x0004, 0x21db: 0x0004, 0x21dc: 0x0004, 0x21dd: 0x0004,
	0x21de: 0x0004, 0x21e0: 0x0004, 0x21e1: 0x0004, 0x21e2: 0x0004, 0x21e3: 0x0004,
	0x21e4: 0x0004, 0x21e5: 0x0004, 0x21e6: 0x0004, 0x21e7: 0x0004, 0x21e8: 0x0004, 0x21e9: 0x0004,
	0x21ea: 0x0004, 0x21eb: 0x0004, 0x21ec: 0x0004, 0x21ed: 0x0004, 0x21ee: 0x0004, 0x21ef: 0x0004,
	0x21f0: 0x0004, 0x21f1: 0x0004, 0x21f2: 0x0004, 0x21f3: 0x0004, 0x21f4: 0x0004, 0x21f5: 0x0004,
	0x21f6: 0x0004, 0x21f7: 0x0004, 0x21f8: 0x0004, 0x21f9: 0x0004, 0x21fa: 0x0004, 0x21fb: 0x0004,
	0x21fc: 0x0004, 0x21fd: 0x0004, 0x21fe: 0x0004, 0x21ff: 0x0004,
	// Block 0x88, offset 0x2200
	0x2200: 0x0004, 0x2201: 0x0004, 0x2202: 0x0004, 0x2203: 0x0004, 0x2204: 0x0004, 0x2205: 0x0004,
	0x2206: 0x0004, 0x2207: 0x0004, 0x2208: 0x0004, 0x2209: 0x0004, 0x220a: 0x0004, 0x220b: 0x0004,
	0x220c: 0x0004, 0x220d: 0x0004, 0x220e: 0x0004, 0x220f: 0x0004, 0x2210: 0x0004, 0x2211: 0x0004,
	0x2212: 0x0004, 0x2213: 0x0004, 0x2214: 0x0004, 0x2215: 0x0004, 0x2216: 0x0004, 0x2217: 0x0004,
	0x2218: 0x0004, 0x2219: 0x0004, 0x221a: 0x0004, 0x221b: 0x0004, 0x221c: 0x0004, 0x221d: 0x0004,
	0x221e: 0x0004, 0x221f: 0x0004, 0x2220: 0x0004, 0x2221: 0x0004, 0x2222: 0x0004, 0x2223: 0x0004,
	0x2224: 0x0004, 0x2225: 0x0004, 0x2226: 0x0004, 0x2227: 0x0004, 0x2228: 0x0004, 0x2229: 0x0004,
	0x222a: 0x0004, 0x222b: 0x0004, 0x222c: 0x0004, 0x222d: 0x0004, 0x222e: 0x0004, 0x222f: 0x0004,
	0x2230: 0x0004, 0x2231: 0x0004, 0x2232: 0x0004, 0x2233: 0x0004, 0x2234: 0x0004, 0x2235: 0x0004,
	0x2236: 0x0004, 0x2237: 0x0004, 0x2238: 0x0004, 0x2239: 0x0004, 0x223a: 0x0004, 0x223b: 0x0004,
	0x223c: 0x0004, 0x223d: 0x0004, 0x223e: 0x0004,
	// Block 0x89, offset 0x2240
	0x2240: 0x0005, 0x2241: 0x0005, 0x2242: 0x0005, 0x2243: 0x0005, 0x2244: 0x0005, 0x2245: 0x0005,
	0x2246: 0x0005, 0x2247: 0x0005, 0x2248: 0x0005, 0x2249: 0x0005, 0x224a: 0x0005, 0x224b: 0x0005,
	0x224c: 0x0005, 0x224d: 0x0005, 0x224e: 0x0005, 0x224f: 0x0005, 0x2250: 0x0005, 0x2251: 0x0005,
	0x2252: 0x0005, 0x2253: 0x0005, 0x2254: 0x0005, 0x2255: 0x0005,
	// Block 0x8a, offset 0x2280
	0x2280: 0x0005, 0x2281: 0x0005, 0x2282: 0x0005, 0x2283: 0x0005, 0x2284: 0x0005, 0x2285: 0x0005,
	0x2286: 0x0005, 0x2287: 0x0005, 0x2288: 0x0005, 0x2289: 0x0005, 0x228a: 0x0005, 0x228b: 0x0005,
	0x228c: 0x0005, 0x2290: 0x0004, 0x2291: 0x0004,
	0x2292: 0x0004, 0x2293: 0x0004, 0x2294: 0x0004, 0x2295: 0x0004, 0x2296: 0x0004, 0x2297: 0x0004,
	0x2298: 0x0004, 0x2299: 0x0004, 0x229a: 0x0004, 0x229b: 0x0004, 0x229c: 0x0004, 0x229d: 0x0004,
	0x229e: 0x0004, 0x229f: 0x0004, 0x22a0: 0x0004, 0x22a1: 0x0004, 0x22a2: 0x0004, 0x22a3: 0x0004,
	0x22a4: 0x0004, 0x22a5: 0x0004, 0x22a6: 0x0004, 0x22a7: 0x0004, 0x22a8: 0x0004, 0x22a9: 0x0004,
	0x22aa: 0x0004, 0x22ab: 0x0004, 0x22ac: 0x0004, 0x22ad: 0x0004, 0x22ae: 0x0004, 0x22af: 0x0004,
	0x22b0: 0x0004, 0x22b1: 0x0004, 0x22b2: 0x0004, 0x22b3: 0x0004, 0x22b4: 0x0004, 0x22b5: 0x0004,
	0x22b6: 0x0004, 0x22b7: 0x0004, 0x22b8: 0x0004, 0x22b9: 0x0004, 0x22ba: 0x0004, 0x22bb: 0x0004,
	0x22bc: 0x0004, 0x22bd: 0x0004, 0x22be: 0x0004, 0x22bf: 0x0004,
	// Block 0x8b, offset 0x22c0
	0x22c0: 0x0004, 0x22c1: 0x0004, 0x22c2: 0x0004, 0x22c3: 0x0004, 0x22c4: 0x0004, 0x22c5: 0x0004,
	0x22c6: 0x0004,
	0x22d0: 0x0005, 0x22d1: 0x0005,
	0x22d2: 0x0005, 0x22d3: 0x0005, 0x22d4: 0x0005, 0x22d5: 0x0005, 0x22d6: 0x0005, 0x22d7: 0x0005,
	0x22d8: 0x0005, 0x22d9: 0x0005, 0x22da: 0x0005, 0x22db: 0x0005, 0x22dc: 0x0005, 0x22dd: 0x0005,
	0x22de: 0x0005, 0x22df: 0x0005, 0x22e0: 0x0005, 0x22e1: 0x0005, 0x22e2: 0x0005, 0x22e3: 0x0005,
	0x22e4: 0x0005, 0x22e5: 0x0005, 0x22e6: 0x0005, 0x22e7: 0x0005, 0x22e8: 0x0005, 0x22e9: 0x0005,
	0x22ea: 0x0005, 0x22eb: 0x0005, 0x22ec: 0x0005, 0x22ed: 0x0005, 0x22ee: 0x0005, 0x22ef: 0x0005,
	0x22f0: 0x0005, 0x22f1: 0x0005, 0x22f2: 0x0005, 0x22f3: 0x0005, 0x22f4: 0x0005, 0x22f5: 0x0005,
	0x22f6: 0x0005, 0x22f7: 0x0005, 0x22f8: 0x0005, 0x22f9: 0x0005, 0x22fa: 0x0005, 0x22fb: 0x0005,
	0x22fc: 0x0005, 0x22fd: 0x0005, 0x22fe: 0x0004, 0x22ff: 0x0004,
	// Block 0x8c, offset 0x2300
	0x2300: 0x0005, 0x2301: 0x0005, 0x2302: 0x0005, 0x2303: 0x0005, 0x2304: 0x0005, 0x2305: 0x0005,
	0x2306: 0x0005, 0x2307: 0x0005, 0x2308: 0x0005, 0x2309: 0x0005, 0x230a: 0x0005, 0x230b: 0x0005,
	0x230c: 0x0005, 0x230d: 0x0004, 0x230e: 0x0004, 0x230f: 0x0004, 0x2310: 0x0005, 0x2311: 0x0005,
	0x2312: 0x0005, 0x2313: 0x0005, 0x2314: 0x0005, 0x2315: 0x0005, 0x2316: 0x0005, 0x2317: 0x0005,
	0x2318: 0x0005, 0x2319: 0x0005, 0x231a: 0x0005, 0x231b: 0x0005, 0x231c: 0x0005, 0x231d: 0x0005,
	0x231e: 0x0005, 0x231f: 0x0005, 0x2320: 0x0005, 0x2321: 0x0005, 0x2322: 0x0005, 0x2323: 0x0005,
	0x2324: 0x0005, 0x2325: 0x0005, 0x2326: 0x0005, 0x2327: 0x0005, 0x2328: 0x0005, 0x2329: 0x0005,
	0x232a: 0x0005, 0x232b: 0x0005,
	// Block 0x8d, offset 0x2340
	0x2340: 0x0005, 0x2341: 0x0005, 0x2342: 0x0005, 0x2343: 0x0005, 0x2344: 0x0005, 0x2345: 0x0005,
	0x2346: 0x0005, 0x2347: 0x0005, 0x2348: 0x0005, 0x2349: 0x0005, 0x234a: 0x0005, 0x234b: 0x0005,
	0x234c: 0x0005, 0x234d: 0x0005, 0x234e: 0x0005, 0x234f: 0x0005, 0x2350: 0x0005, 0x2351: 0x0005,
	0x2352: 0x0005, 0x2353: 0x0005, 0x2354: 0x0005, 0x2355: 0x0005, 0x2356: 0x0005, 0x2357: 0x0005,
	0x2358: 0x0005, 0x2359: 0x0005, 0x235a: 0x0005, 0x235b: 0x0005, 0x235c: 0x0005, 0x235d: 0x0005,
	0x235e: 0x0005, 0x235f: 0x0005, 0x2360: 0x0005, 0x2361: 0x0005, 0x2362: 0x0005, 0x2363: 0x0005,
	0x2364: 0x0005, 0x2365: 0x0005, 0x2366: 0x0005, 0x2367: 0x0005, 0x2368: 0x0005, 0x2369: 0x0005,
	0x236a: 0x0005, 0x236b: 0x0005, 0x236c: 0x0005, 0x236d: 0x0005, 0x236e: 0x0005, 0x236f: 0x0005,
	0x2370: 0x0004, 0x2371: 0x0004, 0x2372: 0x0004, 0x2373: 0x0004, 0x2374: 0x0005, 0x2375: 0x0005,
	0x2376: 0x0005, 0x2377: 0x0005, 0x2378: 0x0005, 0x2379: 0x0005, 0x237a: 0x0005, 0x237b: 0x0005,
	0x237c: 0x0005, 0x237d: 0x0005, 0x237e: 0x0004, 0x237f: 0x0005,
	// Block 0x8e, offset 0x2380
	0x2380: 0x0005, 0x2381: 0x0005, 0x2382: 0x0005, 0x2383: 0x0005, 0x2384: 0x0005, 0x2385: 0x0005,
	0x2386: 0x0005, 0x2387: 0x0005, 0x2388: 0x0005, 0x2389: 0x0005, 0x238a: 0x0005, 0x238b: 0x0005,
	0x238c: 0x0005, 0x238d: 0x0005, 0x238e: 0x0005, 0x238f: 0x0005, 0x2390: 0x0005, 0x2391: 0x0005,
	0x2392: 0x0005, 0x2393: 0x0005, 0x2394: 0x0005, 0x2395: 0x0005, 0x2396: 0x0005, 0x2397: 0x0005,
	0x2398: 0x0005, 0x2399: 0x0005, 0x239a: 0x0005, 0x239b: 0x0005, 0x239c: 0x0004, 0x239d: 0x0004,
	0x239e: 0x0005, 0x239f: 0x0005, 0x23a0: 0x0005, 0x23a1: 0x0005, 0x23a2: 0x0005, 0x23a3: 0x0005,
	0x23a4: 0x0005, 0x23a5: 0x0005, 0x23a6: 0x0005, 0x23a7: 0x0005, 0x23a8: 0x0005, 0x23a9: 0x0005,
	0x23aa: 0x0005, 0x23ab: 0x0005, 0x23ac: 0x0005, 0x23ad: 0x0005, 0x23ae: 0x0005, 0x23af: 0x0005,
	0x23b0: 0x0005, 0x23b1: 0x0005, 0x23b2: 0x0005, 0x23b3: 0x0005, 0x23b4: 0x0005, 0x23b5: 0x0005,
	0x23b6: 0x0005, 0x23b7: 0x0005, 0x23b8: 0x0005, 0x23b9: 0x0005, 0x23ba: 0x0005, 0x23bb: 0x0005,
	0x23bc: 0x0005, 0x23bd: 0x0005, 0x23be: 0x0005, 0x23bf: 0x0005,
	// Block 0x8f, offset 0x23c0
	0x23c0: 0x0005, 0x23c1: 0x0005, 0x23c2: 0x0005, 0x23c3: 0x0005, 0x23c4: 0x0005, 0x23c5: 0x0005,
	0x23c6: 0x0005, 0x23c7: 0x0005, 0x23c8: 0x0005, 0x23c9: 0x0005, 0x23ca: 0x0005, 0x23cb: 0x0005,
	0x23cc: 0x0005, 0x23cd: 0x0005, 0x23ce: 0x0005, 0x23cf: 0x0005, 0x23d0: 0x0005, 0x23d1: 0x0005,
	0x23d2: 0x0005, 0x23d3: 0x0005, 0x23d4: 0x0005, 0x23d5: 0x0005, 0x23d6: 0x0005, 0x23d7: 0x0005,
	0x23d8: 0x0005, 0x23d9: 0x0005, 0x23da: 0x0005, 0x23db: 0x0005, 0x23dc: 0x0005, 0x23dd: 0x0005,
	0x23de: 0x0005, 0x23df: 0x0005, 0x23e0: 0x0005, 0x23e1: 0x0005, 0x23e2: 0x0005, 0x23e3: 0x0005,
	0x23e4: 0x0005, 0x23e5: 0x0005, 0x23e6: 0x0004, 0x23e7: 0x0004, 0x23e8: 0x0004, 0x23e9: 0x0004,
	0x23ea: 0x0004, 0x23eb: 0x0004, 0x23ec: 0x0004, 0x23ed: 0x0004, 0x23ee: 0x0004, 0x23ef: 0x0004,
	0x23f0: 0x0005, 0x23f1: 0x0005, 0x23f2: 0x0004, 0x23f3: 0x0004, 0x23f4: 0x0004, 0x23f5: 0x0004,
	0x23f6: 0x0004, 0x23f7: 0x0004,
	// Block 0x90, offset 0x2400
	0x2400: 0x0004, 0x2401: 0x0004, 0x2402: 0x0004, 0x2403: 0x0004, 0x2404: 0x0004, 0x2405: 0x0004,
	0x2406: 0x0004, 0x2407: 0x0004, 0x2408: 0x0004, 0x2409: 0x0004, 0x240a: 0x0004, 0x240b: 0x0004,
	0x240c: 0x0004, 0x240d: 0x0004, 0x240e: 0x0004, 0x240f: 0x0004, 0x2410: 0x0004, 0x2411: 0x0004,
	0x2412: 0x0004, 0x2413: 0x0004, 0x2414: 0x0004, 0x2415: 0x0004, 0x2416: 0x0004, 0x2417: 0x0005,
	0x2418: 0x0005, 0x2419: 0x0005, 0x241a: 0x0005, 0x241b: 0x0005, 0x241c: 0x0005, 0x241d: 0x0005,
	0x241e: 0x0005, 0x241f: 0x0005, 0x2420: 0x0004, 0x2421: 0x0004, 0x2422: 0x0005, 0x2423: 0x0005,
	0x2424: 0x0005, 0x2425: 0x0005, 0x2426: 0x0005, 0x2427: 0x0005, 0x2428: 0x0005, 0x2429: 0x0005,
	0x242a: 0x0005, 0x242b: 0x0005, 0x242c: 0x0005, 0x242d: 0x0005, 0x242e: 0x0005, 0x242f: 0x0005,
	0x2430: 0x0005, 0x2431: 0x0005, 0x2432: 0x0005, 0x2433: 0x0005, 0x2434: 0x0005, 0x2435: 0x0005,
	0x2436: 0x0005, 0x2437: 0x0005, 0x2438: 0x0005, 0x2439: 0x0005, 0x243a: 0x0005, 0x243b: 0x0005,
	0x243c: 0x0005, 0x243d: 0x0005, 0x243e: 0x0005, 0x243f: 0x0005,
	// Block 0x91, offset 0x2440
	0x2440: 0x0005, 0x2441: 0x0005, 0x2442: 0x0005, 0x2443: 0x0005, 0x2444: 0x0005, 0x2445: 0x0005,
	0x2446: 0x0005, 0x2447: 0x0005, 0x2448: 0x0005, 0x2449: 0x0005, 0x244a: 0x0005, 0x244b: 0x0005,
	0x244c: 0x0005, 0x244d: 0x0005, 0x244e: 0x0005, 0x244f: 0x0005, 0x2450: 0x0005, 0x2451: 0x0005,
	0x2452: 0x0005, 0x2453: 0x0005, 0x2454: 0x0005, 0x2455: 0x0005, 0x2456: 0x0005, 0x2457: 0x0005,
	0x2458: 0x0005, 0x2459: 0x0005, 0x245a: 0x0005, 0x245b: 0x0005, 0x245c: 0x0005, 0x245d: 0x0005,
	0x245e: 0x0005, 0x245f: 0x0005, 0x2460: 0x0005, 0x2461: 0x0005, 0x2462: 0x0005, 0x2463: 0x0005,
	0x2464: 0x0005, 0x2465: 0x0005, 0x2466: 0x0005, 0x2467: 0x0005, 0x2468: 0x0005, 0x2469: 0x0005,
	0x246a: 0x0005, 0x246b: 0x0005, 0x246c: 0x0005, 0x246d: 0x0005, 0x246e: 0x0005, 0x246f: 0x0005,
	0x2470: 0x0004, 0x2471: 0x0005, 0x2472: 0x0005, 0x2473: 0x0005, 0x2474: 0x0005, 0x2475: 0x0005,
	0x2476: 0x0005, 0x2477: 0x0005, 0x2478: 0x0005, 0x2479: 0x0005, 0x247a: 0x0005, 0x247b: 0x0005,
	0x247c: 0x0005, 0x247d: 0x0005, 0x247e: 0x0005, 0x247f: 0x0005,
	// Block 0x92, offset 0x2480
	0x2480: 0x0005, 0x2481: 0x0005, 0x2482: 0x0005, 0x2483: 0x0005, 0x2484: 0x0005, 0x2485: 0x0005,
	0x2486: 0x0005, 0x2487: 0x0005, 0x2488: 0x0005, 0x2489: 0x0004, 0x248a: 0x0004, 0x248b: 0x0005,
	0x248c: 0x0005, 0x248d: 0x0005, 0x248e: 0x0005, 0x248f: 0x0005, 0x2490: 0x0005, 0x2491: 0x0005,
	0x2492: 0x0005, 0x2493: 0x0005, 0x2494: 0x0005, 0x2495: 0x0005, 0x2496: 0x0005, 0x2497: 0x0005,
	0x2498: 0x0005, 0x2499: 0x0005, 0x249a: 0x0005, 0x249b: 0x0005, 0x249c: 0x0005, 0x249d: 0x0005,
	0x249e: 0x0005, 0x249f: 0x0005, 0x24a0: 0x0005, 0x24a1: 0x0005, 0x24a2: 0x0005, 0x24a3: 0x0005,
	0x24a4: 0x0005, 0x24a5: 0x0005, 0x24a6: 0x0005, 0x24a7: 0x0005, 0x24a8: 0x0005, 0x24a9: 0x0005,
	0x24aa: 0x0005, 0x24ab: 0x0005, 0x24ac: 0x0005, 0x24ad: 0x0005,
	0x24b0: 0x0005, 0x24b1: 0x0005, 0x24b2: 0x0005, 0x24b3: 0x0005, 0x24b4: 0x0005, 0x24b5: 0x0005,
	0x24b6: 0x0005, 0x24b7: 0x0005,
	// Block 0x93, offset 0x24c0
	0x24f7: 0x0005, 0x24f8: 0x0004, 0x24f9: 0x0004, 0x24fa: 0x0005, 0x24fb: 0x0005,
	0x24fc: 0x0005, 0x24fd: 0x0005, 0x24fe: 0x0005, 0x24ff: 0x0005,
	// Block 0x94, offset 0x2500
	0x2500: 0x0005, 0x2501: 0x0005, 0x2502: 0x0005, 0x2503: 0x0005, 0x2504: 0x0005, 0x2505: 0x0005,
	0x2506: 0x0005, 0x2507: 0x0005, 0x2508: 0x0005, 0x2509: 0x0005, 0x250a: 0x0005, 0x250b: 0x0005,
	0x250c: 0x0005, 0x250d: 0x0005, 0x250e: 0x0005, 0x250f: 0x0005, 0x2510: 0x0005, 0x2511: 0x0005,
	0x2512: 0x0005, 0x2513: 0x0005, 0x2514: 0x0005, 0x2515: 0x0005, 0x2516: 0x0005, 0x2517: 0x0005,
	0x2518: 0x0005, 0x2519: 0x0005, 0x251a: 0x0005, 0x251b: 0x0005, 0x251c: 0x0005, 0x251d: 0x0005,
	0x251e: 0x0005, 0x251f: 0x0005, 0x2520: 0x0005, 0x2521: 0x0005, 0x2522: 0x0005, 0x2523: 0x0005,
	0x2524: 0x0005, 0x2525: 0x0005, 0x2526: 0x0005, 0x2527: 0x0005, 0x2528: 0x0004, 0x2529: 0x0004,
	0x252a: 0x0004, 0x252b: 0x0004,
	0x2530: 0x0004, 0x2531: 0x0004, 0x2532: 0x0004, 0x2533: 0x0004, 0x2534: 0x0004, 0x2535: 0x0004,
	0x2536: 0x0004, 0x2537: 0x0004, 0x2538: 0x0004, 0x2539: 0x0004,
	// Block 0x95, offset 0x2540
	0x2540: 0x0005, 0x2541: 0x0005, 0x2542: 0x0005, 0x2543: 0x0005, 0x2544: 0x0005, 0x2545: 0x0005,
	0x2546: 0x0005, 0x2547: 0x0005, 0x2548: 0x0005, 0x2549: 0x0005, 0x254a: 0x0005, 0x254b: 0x0005,
	0x254c: 0x0005, 0x254d: 0x0005, 0x254e: 0x0005, 0x254f: 0x0005, 0x2550: 0x0005, 0x2551: 0x0005,
	0x2552: 0x0005, 0x2553: 0x0005, 0x2554: 0x0005, 0x2555: 0x0005, 0x2556: 0x0005, 0x2557: 0x0005,
	0x2558: 0x0005, 0x2559: 0x0005, 0x255a: 0x0005, 0x255b: 0x0005, 0x255c: 0x0005, 0x255d: 0x0005,
	0x255e: 0x0005, 0x255f: 0x0005, 0x2560: 0x0005, 0x2561: 0x0005, 0x2562: 0x0005, 0x2563: 0x0005,
	0x2564: 0x0005, 0x2565: 0x0005, 0x2566: 0x0005, 0x2567: 0x0005, 0x2568: 0x0005, 0x2569: 0x0005,
	0x256a: 0x0005, 0x256b: 0x0005, 0x256c: 0x0005, 0x256d: 0x0005, 0x256e: 0x0005, 0x256f: 0x0005,
	0x2570: 0x0005, 0x2571: 0x0005, 0x2572: 0x0005, 0x2573: 0x0005, 0x2574: 0x0004, 0x2575: 0x0004,
	0x2576: 0x0004, 0x2577: 0x0004,
	// Block 0x96, offset 0x2580
	0x2580: 0x0005, 0x2581: 0x0005, 0x2582: 0x0005, 0x2583: 0x0005, 0x2584: 0x0005,
	0x258e: 0x0004, 0x258f: 0x0004, 0x2590: 0x0005, 0x2591: 0x0005,
	0x2592: 0x0005, 0x2593: 0x0005, 0x2594: 0x0005, 0x2595: 0x0005, 0x2596: 0x0005, 0x2597: 0x0005,
	0x2598: 0x0005, 0x2599: 0x0005,
	0x25a0: 0x0005, 0x25a1: 0x0005, 0x25a2: 0x0005, 0x25a3: 0x0005,
	0x25a4: 0x0005, 0x25a5: 0x0005, 0x25a6: 0x0005, 0x25a7: 0x0005, 0x25a8: 0x0005, 0x25a9: 0x0005,
	0x25aa: 0x0005, 0x25ab: 0x0005, 0x25ac: 0x0005, 0x25ad: 0x0005, 0x25ae: 0x0005, 0x25af: 0x0005,
	0x25b0: 0x0005, 0x25b1: 0x0005, 0x25b2: 0x0005, 0x25b3: 0x0005, 0x25b4: 0x0005, 0x25b5: 0x0005,
	0x25b6: 0x0005, 0x25b7: 0x0005, 0x25b8: 0x0004, 0x25b9: 0x0004, 0x25ba: 0x0004, 0x25bb: 0x0005,
	0x25bc: 0x0004, 0x25bd: 0x0005,
	// Block 0x97, offset 0x25c0
	0x25c0: 0x0005, 0x25c1: 0x0005, 0x25c2: 0x0005, 0x25c3: 0x0005, 0x25c4: 0x0005, 0x25c5: 0x0005,
	0x25c6: 0x0005, 0x25c7: 0x0005, 0x25c8: 0x0005, 0x25c9: 0x0005, 0x25ca: 0x0005, 0x25cb: 0x0005,
	0x25cc: 0x0005, 0x25cd: 0x0005, 0x25ce: 0x0005, 0x25cf: 0x0005, 0x25d0: 0x0005, 0x25d1: 0x0005,
	0x25d2: 0x0005, 0x25d3: 0x0005, 0x25d4: 0x0005, 0x25d5: 0x0005, 0x25d6: 0x0005, 0x25d7: 0x0005,
	0x25d8: 0x0005, 0x25d9: 0x0005, 0x25da: 0x0005, 0x25db: 0x0005, 0x25dc: 0x0005, 0x25dd: 0x0005,
	0x25de: 0x0005, 0x25df: 0x0005, 0x25e0: 0x0005, 0x25e1: 0x0005, 0x25e2: 0x0005, 0x25e3: 0x0005,
	0x25e4: 0x0005, 0x25e5: 0x0005, 0x25e6: 0x0005, 0x25e7: 0x0005, 0x25e8: 0x0005, 0x25e9: 0x0005,
	0x25ea: 0x0005, 0x25eb: 0x0005, 0x25ec: 0x0005, 0x25ed: 0x0005, 0x25ee: 0x0004, 0x25ef: 0x0004,
	0x25f0: 0x0005, 0x25f1: 0x0005, 0x25f2: 0x0005, 0x25f3: 0x0005, 0x25f4: 0x0005, 0x25f5: 0x0005,
	0x25f6: 0x0005, 0x25f7: 0x0005, 0x25f8: 0x0005, 0x25f9: 0x0005, 0x25fa: 0x0005, 0x25fb: 0x0005,
	0x25fc: 0x0005, 0x25fd: 0x0005, 0x25fe: 0x0005, 0x25ff: 0x0005,
	// Block 0x98, offset 0x2600
	0x2600: 0x0005, 0x2601: 0x0005, 0x2602: 0x0005, 0x2603: 0x0005, 0x2604: 0x0005, 0x2605: 0x0005,
	0x2606: 0x0005, 0x2607: 0x0005, 0x2608: 0x0005, 0x2609: 0x0005, 0x260a: 0x0005, 0x260b: 0x0005,
	0x260c: 0x0005, 0x260d: 0x0005, 0x260e: 0x0005, 0x260f: 0x0005, 0x2610: 0x0005, 0x2611: 0x0005,
	0x2612: 0x0005, 0x2613: 0x0005,
	0x261f: 0x0004, 0x2620: 0x0001, 0x2621: 0x0001, 0x2622: 0x0001, 0x2623: 0x0001,
	0x2624: 0x0001, 0x2625: 0x0001, 0x2626: 0x0001, 0x2627: 0x0001, 0x2628: 0x0001, 0x2629: 0x0001,
	0x262a: 0x0001, 0x262b: 0x0001, 0x262c: 0x0001, 0x262d: 0x0001, 0x262e: 0x0001, 0x262f: 0x0001,
	0x2630: 0x0001, 0x2631: 0x0001, 0x2632: 0x0001, 0x2633: 0x0001, 0x2634: 0x0001, 0x2635: 0x0001,
	0x2636: 0x0001, 0x2637: 0x0001, 0x2638: 0x0001, 0x2639: 0x0001, 0x263a: 0x0001, 0x263b: 0x0001,
	0x263c: 0x0001,
	// Block 0x99, offset 0x2640
	0x2640: 0x0005, 0x2641: 0x0004, 0x2642: 0x0004, 0x2643: 0x0004, 0x2644: 0x0004, 0x2645: 0x0004,
	0x2646: 0x0004, 0x2647: 0x0004, 0x2648: 0x0004, 0x2649: 0x0004, 0x264a: 0x0004, 0x264b: 0x0004,
	0x264c: 0x0004, 0x264d: 0x0004, 0x264f: 0x0005, 0x2650: 0x0005, 0x2651: 0x0005,
	0x2652: 0x0005, 0x2653: 0x0005, 0x2654: 0x0005, 0x2655: 0x0005, 0x2656: 0x0005, 0x2657: 0x0005,
	0x2658: 0x0005, 0x2659: 0x0005,
	0x265e: 0x0004, 0x265f: 0x0004, 0x2660: 0x0005, 0x2661: 0x0005, 0x2662: 0x0005, 0x2663: 0x0005,
	0x2664: 0x0005, 0x2665: 0x0005, 0x2666: 0x0005, 0x2667: 0x0005, 0x2668: 0x0005, 0x2669: 0x0005,
	0x266a: 0x0005, 0x266b: 0x0005, 0x266c: 0x0005, 0x266d: 0x0005, 0x266e: 0x0005, 0x266f: 0x0005,
	0x2670: 0x0005, 0x2671: 0x0005, 0x2672: 0x0005, 0x2673: 0x0005, 0x2674: 0x0005, 0x2675: 0x0005,
	0x2676: 0x0005, 0x2677: 0x0005, 0x2678: 0x0005, 0x2679: 0x0005, 0x267a: 0x0005, 0x267b: 0x0005,
	0x267c: 0x0005, 0x267d: 0x0005, 0x267e: 0x0005,
	// Block 0x9a, offset 0x2680
	0x2680: 0x0005, 0x2681: 0x0005, 0x2682: 0x0005, 0x2683: 0x0005, 0x2684: 0x0005, 0x2685: 0x0005,
	0x2686: 0x0005, 0x2687: 0x0005, 0x2688: 0x0005, 0x2689: 0x0005, 0x268a: 0x0005, 0x268b: 0x0005,
	0x268c: 0x0005, 0x268d: 0x0005, 0x268e: 0x0005, 0x268f: 0x0005, 0x2690: 0x0005, 0x2691: 0x0005,
	0x2692: 0x0005, 0x2693: 0x0005, 0x2694: 0x0005, 0x2695: 0x0005, 0x2696: 0x0005, 0x2697: 0x0005,
	0x2698: 0x0005, 0x2699: 0x0005, 0x269a: 0x0005, 0x269b: 0x0005, 0x269c: 0x0005, 0x269d: 0x0005,
	0x269e: 0x0005, 0x269f: 0x0005, 0x26a0: 0x0005, 0x26a1: 0x0005, 0x26a2: 0x0005, 0x26a3: 0x0005,
	0x26a4: 0x0005, 0x26a5: 0x0005, 0x26a6: 0x0005, 0x26a7: 0x0005, 0x26a8: 0x0005, 0x26a9: 0x0005,
	0x26aa: 0x0005, 0x26ab: 0x0005, 0x26ac: 0x0005, 0x26ad: 0x0005, 0x26ae: 0x0005, 0x26af: 0x0005,
	0x26b0: 0x0005, 0x26b1: 0x0005, 0x26b2: 0x0005, 0x26b3: 0x0005, 0x26b4: 0x0005, 0x26b5: 0x0005,
	0x26b6: 0x0005,
	// Block 0x9b, offset 0x26c0
	0x26c0: 0x0005, 0x26c1: 0x0005, 0x26c2: 0x0005, 0x26c3: 0x0005, 0x26c4: 0x0005, 0x26c5: 0x0005,
	0x26c6: 0x0005, 0x26c7: 0x0005, 0x26c8: 0x0005, 0x26c9: 0x0005, 0x26ca: 0x0005, 0x26cb: 0x0005,
	0x26cc: 0x0005, 0x26cd: 0x0005, 0x26d0: 0x0005, 0x26d1: 0x0005,
	0x26d2: 0x0005, 0x26d3: 0x0005, 0x26d4: 0x0005, 0x26d5: 0x0005, 0x26d6: 0x0005, 0x26d7: 0x0005,
	0x26d8: 0x0005, 0x26d9: 0x0005, 0x26dc: 0x0004, 0x26dd: 0x0004,
	0x26de: 0x0004, 0x26df: 0x0004, 0x26e0: 0x0005, 0x26e1: 0x0005, 0x26e2: 0x0005, 0x26e3: 0x0005,
	0x26e4: 0x0005, 0x26e5: 0x0005, 0x26e6: 0x0005, 0x26e7: 0x0005, 0x26e8: 0x0005, 0x26e9: 0x0005,
	0x26ea: 0x0005, 0x26eb: 0x0005, 0x26ec: 0x0005, 0x26ed: 0x0005, 0x26ee: 0x0005, 0x26ef: 0x0005,
	0x26f0: 0x0005, 0x26f1: 0x0005, 0x26f2: 0x0005, 0x26f3: 0x0005, 0x26f4: 0x0005, 0x26f5: 0x0005,
	0x26f6: 0x0005, 0x26f7: 0x0004, 0x26f8: 0x0004, 0x26f9: 0x0004, 0x26fa: 0x0005, 0x26fb: 0x0005,
	0x26fc: 0x0005, 0x26fd: 0x0005, 0x26fe: 0x0005, 0x26ff: 0x0005,
	// Block 0x9c, offset 0x2700
	0x2700: 0x0005, 0x2701: 0x0005, 0x2702: 0x0005,
	0x271b: 0x0005, 0x271c: 0x0005, 0x271d: 0x0005,
	0x271e: 0x0004, 0x271f: 0x0004, 0x2720: 0x0005, 0x2721: 0x0005, 0x2722: 0x0005, 0x2723: 0x0005,
	0x2724: 0x0005, 0x2725: 0x0005, 0x2726: 0x0005, 0x2727: 0x0005, 0x2728: 0x0005, 0x2729: 0x0005,
	0x272a: 0x0005, 0x272b: 0x0005, 0x272c: 0x0005, 0x272d: 0x0005, 0x272e: 0x0005, 0x272f: 0x0005,
	0x2730: 0x0004, 0x2731: 0x0004, 0x2732: 0x0005, 0x2733: 0x0005, 0x2734: 0x0005, 0x2735: 0x0005,
	0x2736: 0x0005,
	// Block 0x9d, offset 0x2740
	0x2741: 0x0005, 0x2742: 0x0005, 0x2743: 0x0005, 0x2744: 0x0005, 0x2745: 0x0005,
	0x2746: 0x0005, 0x2749: 0x0005, 0x274a: 0x0005, 0x274b: 0x0005,
	0x274c: 0x0005, 0x274d: 0x0005, 0x274e: 0x0005, 0x2751: 0x0005,
	0x2752: 0x0005, 0x2753: 0x0005, 0x2754: 0x0005, 0x2755: 0x0005, 0x2756: 0x0005,
	0x2760: 0x0005, 0x2761: 0x0005, 0x2762: 0x0005, 0x2763: 0x0005,
	0x2764: 0x0005, 0x2765: 0x0005, 0x2766: 0x0005, 0x2768: 0x0005, 0x2769: 0x0005,
	0x276a: 0x0005, 0x276b: 0x0005, 0x276c: 0x0005, 0x276d: 0x0005, 0x276e: 0x0005,
	0x2770: 0x0005, 0x2771: 0x0005, 0x2772: 0x0005, 0x2773: 0x0005, 0x2774: 0x0005, 0x2775: 0x0005,
	0x2776: 0x0005, 0x2777: 0x0005, 0x2778: 0x0005, 0x2779: 0x0005, 0x277a: 0x0005, 0x277b: 0x0005,
	0x277c: 0x0005, 0x277d: 0x0005, 0x277e: 0x0005, 0x277f: 0x0005,
	// Block 0x9e, offset 0x2780
	0x2780: 0x0005, 0x2781: 0x0005, 0x2782: 0x0005, 0x2783: 0x0005, 0x2784: 0x0005, 0x2785: 0x0005,
	0x2786: 0x0005, 0x2787: 0x0005, 0x2788: 0x0005, 0x2789: 0x0005, 0x278a: 0x0005, 0x278b: 0x0005,
	0x278c: 0x0005, 0x278d: 0x0005, 0x278e: 0x0005, 0x278f: 0x0005, 0x2790: 0x0005, 0x2791: 0x0005,
	0x2792: 0x0005, 0x2793: 0x0005, 0x2794: 0x0005, 0x2795: 0x0005, 0x2796: 0x0005, 0x2797: 0x0005,
	0x2798: 0x0005, 0x2799: 0x0005, 0x279a: 0x0005, 0x279b: 0x0004, 0x279c: 0x0004, 0x279d: 0x0004,
	0x279e: 0x0004, 0x279f: 0x0004, 0x27a0: 0x0005, 0x27a1: 0x0005, 0x27a2: 0x0005, 0x27a3: 0x0005,
	0x27a4: 0x0005, 0x27a5: 0x0005,
	0x27b0: 0x0005, 0x27b1: 0x0005, 0x27b2: 0x0005, 0x27b3: 0x0005, 0x27b4: 0x0005, 0x27b5: 0x0005,
	0x27b6: 0x0005, 0x27b7: 0x0005, 0x27b8: 0x0005, 0x27b9: 0x0005, 0x27ba: 0x0005, 0x27bb: 0x0005,
	0x27bc: 0x0005, 0x27bd: 0x0005, 0x27be: 0x0005, 0x27bf: 0x0005,
	// Block 0x9f, offset 0x27c0
	0x27c0: 0x0005, 0x27c1: 0x0005, 0x27c2: 0x0005, 0x27c3: 0x0005, 0x27c4: 0x0005, 0x27c5: 0x0005,
	0x27c6: 0x0005, 0x27c7: 0x0005, 0x27c8: 0x0005, 0x27c9: 0x0005, 0x27ca: 0x0005, 0x27cb: 0x0005,
	0x27cc: 0x0005, 0x27cd: 0x0005, 0x27ce: 0x0005, 0x27cf: 0x0005, 0x27d0: 0x0005, 0x27d1: 0x0005,
	0x27d2: 0x0005, 0x27d3: 0x0005, 0x27d4: 0x0005, 0x27d5: 0x0005, 0x27d6: 0x0005, 0x27d7: 0x0005,
	0x27d8: 0x0005, 0x27d9: 0x0005, 0x27da: 0x0005, 0x27db: 0x0005, 0x27dc: 0x0005, 0x27dd: 0x0005,
	0x27de: 0x0005, 0x27df: 0x0005, 0x27e0: 0x0005, 0x27e1: 0x0005, 0x27e2: 0x0005, 0x27e3: 0x0005,
	0x27e4: 0x0005, 0x27e5: 0x0005, 0x27e6: 0x0005, 0x27e7: 0x0005, 0x27e8: 0x0005, 0x27e9: 0x0005,
	0x27ea: 0x0005, 0x27eb: 0x0004, 0x27ec: 0x0005, 0x27ed: 0x0005,
	0x27f0: 0x0005, 0x27f1: 0x0005, 0x27f2: 0x0005, 0x27f3: 0x0005, 0x27f4: 0x0005, 0x27f5: 0x0005,
	0x27f6: 0x0005, 0x27f7: 0x0005, 0x27f8: 0x0005, 0x27f9: 0x0005,
	// Block 0xa0, offset 0x2800
	0x2800: 0x0005, 0x2801: 0x0005, 0x2802: 0x0005, 0x2803: 0x0005, 0x2804: 0x0005, 0x2805: 0x0005,
	0x2806: 0x0005, 0x2807: 0x0005, 0x2808: 0x0005, 0x2809: 0x0005, 0x280a: 0x0005, 0x280b: 0x0005,
	0x280c: 0x0005, 0x280d: 0x0005, 0x280e: 0x0005, 0x280f: 0x0005, 0x2810: 0x0005, 0x2811: 0x0005,
	0x2812: 0x0005, 0x2813: 0x0005, 0x2814: 0x0005, 0x2815: 0x0005, 0x2816: 0x0005, 0x2817: 0x0005,
	0x2818: 0x0005, 0x2819: 0x0005, 0x281a: 0x0005, 0x281b: 0x0005, 0x281c: 0x0005, 0x281d: 0x0005,
	0x281e: 0x0005, 0x281f: 0x0005, 0x2820: 0x0005, 0x2821: 0x0005, 0x2822: 0x0005, 0x2823: 0x0005,
	0x2830: 0x0001, 0x2831: 0x0001, 0x2832: 0x0001, 0x2833: 0x0001, 0x2834: 0x0001, 0x2835: 0x0001,
	0x2836: 0x0001, 0x2837: 0x0001, 0x2838: 0x0001, 0x2839: 0x0001, 0x283a: 0x0001, 0x283b: 0x0001,
	0x283c: 0x0001, 0x283d: 0x0001, 0x283e: 0x0001, 0x283f: 0x0001,
	// Block 0xa1, offset 0x2840
	0x2840: 0x0001, 0x2841: 0x0001, 0x2842: 0x0001, 0x2843: 0x0001, 0x2844: 0x0001, 0x2845: 0x0001,
	0x2846: 0x0001, 0x284b: 0x0001,
	0x284c: 0x0001, 0x284d: 0x0001, 0x284e: 0x0001, 0x284f: 0x0001, 0x2850: 0x0001, 0x2851: 0x0001,
	0x2852: 0x0001, 0x2853: 0x0001, 0x2854: 0x0001, 0x2855: 0x0001, 0x2856: 0x0001, 0x2857: 0x0001,
	0x2858: 0x0001, 0x2859: 0x0001, 0x285a: 0x0001, 0x285b: 0x0001, 0x285c: 0x0001, 0x285d: 0x0001,
	0x285e: 0x0001, 0x285f: 0x0001, 0x2860: 0x0001, 0x2861: 0x0001, 0x2862: 0x0001, 0x2863: 0x0001,
	0x2864: 0x0001, 0x2865: 0x0001, 0x2866: 0x0001, 0x2867: 0x0001, 0x2868: 0x0001, 0x2869: 0x0001,
	0x286a: 0x0001, 0x286b: 0x0001, 0x286c: 0x0001, 0x286d: 0x0001, 0x286e: 0x0001, 0x286f: 0x0001,
	0x2870: 0x0001, 0x2871: 0x0001, 0x2872: 0x0001, 0x2873: 0x0001, 0x2874: 0x0001, 0x2875: 0x0001,
	0x2876: 0x0001, 0x2877: 0x0001, 0x2878: 0x0001, 0x2879: 0x0001, 0x287a: 0x0001, 0x287b: 0x0001,
	// Block 0xa2, offset 0x2880
	0x2880: 0x0004, 0x2881: 0x0004, 0x2882: 0x0004, 0x2883: 0x0004, 0x2884: 0x0004, 0x2885: 0x0004,
	0x2886: 0x0004, 0x2887: 0x0004, 0x2888: 0x0004, 0x2889: 0x0004, 0x288a: 0x0004, 0x288b: 0x0004,
	0x288c: 0x0004, 0x288d: 0x0004, 0x288e: 0x0005, 0x288f: 0x0005, 0x2890: 0x0004, 0x2891: 0x0005,
	0x2892: 0x0004, 0x2893: 0x0005, 0x2894: 0x0005, 0x2895: 0x0004, 0x2896: 0x0004, 0x2897: 0x0004,
	0x2898: 0x0004, 0x2899: 0x0004, 0x289a: 0x0004, 0x289b: 0x0004, 0x289c: 0x0004, 0x289d: 0x0004,
	0x289e: 0x0004, 0x289f: 0x0005, 0x28a0: 0x0004, 0x28a1: 0x0005, 0x28a2: 0x0004, 0x28a3: 0x0005,
	0x28a4: 0x0005, 0x28a5: 0x0004, 0x28a6: 0x0004, 0x28a7: 0x0005, 0x28a8: 0x0005, 0x28a9: 0x0005,
	0x28aa: 0x0004, 0x28ab: 0x0004, 0x28ac: 0x0004, 0x28ad: 0x0004, 0x28ae: 0x0004, 0x28af: 0x0004,
	0x28b0: 0x0004, 0x28b1: 0x0004, 0x28b2: 0x0004, 0x28b3: 0x0004, 0x28b4: 0x0004, 0x28b5: 0x0004,
	0x28b6: 0x0004, 0x28b7: 0x0004, 0x28b8: 0x0004, 0x28b9: 0x0004, 0x28ba: 0x0004, 0x28bb: 0x0004,
	0x28bc: 0x0004, 0x28bd: 0x0004, 0x28be: 0x0004, 0x28bf: 0x0004,
	// Block 0xa3, offset 0x28c0
	0x28c0: 0x0004, 0x28c1: 0x0004, 0x28c2: 0x0004, 0x28c3: 0x0004, 0x28c4: 0x0004, 0x28c5: 0x0004,
	0x28c6: 0x0004, 0x28c7: 0x0004, 0x28c8: 0x0004, 0x28c9: 0x0004, 0x28ca: 0x0004, 0x28cb: 0x0004,
	0x28cc: 0x0004, 0x28cd: 0x0004, 0x28ce: 0x0004, 0x28cf: 0x0004, 0x28d0: 0x0004, 0x28d1: 0x0004,
	0x28d2: 0x0004, 0x28d3: 0x0004, 0x28d4: 0x0004, 0x28d5: 0x0004, 0x28d6: 0x0004, 0x28d7: 0x0004,
	0x28d8: 0x0004, 0x28d9: 0x0004, 0x28da: 0x0004, 0x28db: 0x0004, 0x28dc: 0x0004, 0x28dd: 0x0004,
	0x28de: 0x0004, 0x28df: 0x0004, 0x28e0: 0x0004, 0x28e1: 0x0004, 0x28e2: 0x0004, 0x28e3: 0x0004,
	0x28e4: 0x0004, 0x28e5: 0x0004, 0x28e6: 0x0004, 0x28e7: 0x0004, 0x28e8: 0x0004, 0x28e9: 0x0004,
	0x28ea: 0x0004, 0x28eb: 0x0004, 0x28ec: 0x0004, 0x28ed: 0x0004,
	0x28f0: 0x0004, 0x28f1: 0x0004, 0x28f2: 0x0004, 0x28f3: 0x0004, 0x28f4: 0x0004, 0x28f5: 0x0004,
	0x28f6: 0x0004, 0x28f7: 0x0004, 0x28f8: 0x0004, 0x28f9: 0x0004, 0x28fa: 0x0004, 0x28fb: 0x0004,
	0x28fc: 0x0004, 0x28fd: 0x0004, 0x28fe: 0x0004, 0x28ff: 0x0004,
	// Block 0xa4, offset 0x2900
	0x2900: 0x0004, 0x2901: 0x0004, 0x2902: 0x0004, 0x2903: 0x0004, 0x2904: 0x0004, 0x2905: 0x0004,
	0x2906: 0x0004, 0x2907: 0x0004, 0x2908: 0x0004, 0x2909: 0x0004, 0x290a: 0x0004, 0x290b: 0x0004,
	0x290c: 0x0004, 0x290d: 0x0004, 0x290e: 0x0004, 0x290f: 0x0004, 0x2910: 0x0004, 0x2911: 0x0004,
	0x2912: 0x0004, 0x2913: 0x0004, 0x2914: 0x0004, 0x2915: 0x0004, 0x2916: 0x0004, 0x2917: 0x0004,
	0x2918: 0x0004, 0x2919: 0x0004,
	// Block 0xa5, offset 0x2940
	0x2940: 0x0004, 0x2941: 0x0004, 0x2942: 0x0004, 0x2943: 0x0004, 0x2944: 0x0004, 0x2945: 0x0004,
	0x2946: 0x0004,
	0x2953: 0x0004, 0x2954: 0x0004, 0x2955: 0x0004, 0x2956: 0x0004, 0x2957: 0x0004,
	0x295d: 0x0004,
	0x295e: 0x0005, 0x295f: 0x0004, 0x2960: 0x0004, 0x2961: 0x0004, 0x2962: 0x0004, 0x2963: 0x0004,
	0x2964: 0x0004, 0x2965: 0x0004, 0x2966: 0x0004, 0x2967: 0x0004, 0x2968: 0x0004, 0x2969: 0x0004,
	0x296a: 0x0004, 0x296b: 0x0004, 0x296c: 0x0004, 0x296d: 0x0004, 0x296e: 0x0004, 0x296f: 0x0004,
	0x2970: 0x0004, 0x2971: 0x0004, 0x2972: 0x0004, 0x2973: 0x0004, 0x2974: 0x0004, 0x2975: 0x0004,
	0x2976: 0x0004, 0x2978: 0x0004, 0x2979: 0x0004, 0x297a: 0x0004, 0x297b: 0x0004,
	0x297c: 0x0004, 0x297e: 0x0004,
	// Block 0xa6, offset 0x2980
	0x2980: 0x0004, 0x2981: 0x0004, 0x2983: 0x0004, 0x2984: 0x0004,
	0x2986: 0x0004, 0x2987: 0x0004, 0x2988: 0x0004, 0x2989: 0x0004, 0x298a: 0x0004, 0x298b: 0x0004,
	0x298c: 0x0004, 0x298d: 0x0004, 0x298e: 0x0004, 0x298f: 0x0004, 0x2990: 0x0004, 0x2991: 0x0004,
	0x2992: 0x0004, 0x2993: 0x0004, 0x2994: 0x0004, 0x2995: 0x0004, 0x2996: 0x0004, 0x2997: 0x0004,
	0x2998: 0x0004, 0x2999: 0x0004, 0x299a: 0x0004, 0x299b: 0x0004, 0x299c: 0x0004, 0x299d: 0x0004,
	0x299e: 0x0004, 0x299f: 0x0004, 0x29a0: 0x0004, 0x29a1: 0x0004, 0x29a2: 0x0004, 0x29a3: 0x0004,
	0x29a4: 0x0004, 0x29a5: 0x0004, 0x29a6: 0x0004, 0x29a7: 0x0004, 0x29a8: 0x0004, 0x29a9: 0x0004,
	0x29aa: 0x0004, 0x29ab: 0x0004, 0x29ac: 0x0004, 0x29ad: 0x0004, 0x29ae: 0x0004, 0x29af: 0x0004,
	0x29b0: 0x0004, 0x29b1: 0x0004, 0x29b2: 0x0004, 0x29b3: 0x0004, 0x29b4: 0x0004, 0x29b5: 0x0004,
	0x29b6: 0x0004, 0x29b7: 0x0004, 0x29b8: 0x0004, 0x29b9: 0x0004, 0x29ba: 0x0004, 0x29bb: 0x0004,
	0x29bc: 0x0004, 0x29bd: 0x0004, 0x29be: 0x0004, 0x29bf: 0x0004,
	// Block 0xa7, offset 0x29c0
	0x29c0: 0x0004, 0x29c1: 0x0004,
	0x29d3: 0x0004, 0x29d4: 0x0004, 0x29d5: 0x0004, 0x29d6: 0x0004, 0x29d7: 0x0004,
	0x29d8: 0x0004, 0x29d9: 0x0004, 0x29da: 0x0004, 0x29db: 0x0004, 0x29dc: 0x0004, 0x29dd: 0x0004,
	0x29de: 0x0004, 0x29df: 0x0004, 0x29e0: 0x0004, 0x29e1: 0x0004, 0x29e2: 0x0004, 0x29e3: 0x0004,
	0x29e4: 0x0004, 0x29e5: 0x0004, 0x29e6: 0x0004, 0x29e7: 0x0004, 0x29e8: 0x0004, 0x29e9: 0x0004,
	0x29ea: 0x0004, 0x29eb: 0x0004, 0x29ec: 0x0004, 0x29ed: 0x0004, 0x29ee: 0x0004, 0x29ef: 0x0004,
	0x29f0: 0x0004, 0x29f1: 0x0004, 0x29f2: 0x0004, 0x29f3: 0x0004, 0x29f4: 0x0004, 0x29f5: 0x0004,
	0x29f6: 0x0004, 0x29f7: 0x0004, 0x29f8: 0x0004, 0x29f9: 0x0004, 0x29fa: 0x0004, 0x29fb: 0x0004,
	0x29fc: 0x0004, 0x29fd: 0x0004, 0x29fe: 0x0004, 0x29ff: 0x0004,
	// Block 0xa8, offset 0x2a00
	0x2a10: 0x0004, 0x2a11: 0x0004,
	0x2a12: 0x0004, 0x2a13: 0x0004, 0x2a14: 0x0004, 0x2a15: 0x0004, 0x2a16: 0x0004, 0x2a17: 0x0004,
	0x2a18: 0x0004, 0x2a19: 0x0004, 0x2a1a: 0x0004, 0x2a1b: 0x0004, 0x2a1c: 0x0004, 0x2a1d: 0x0004,
	0x2a1e: 0x0004, 0x2a1f: 0x0004, 0x2a20: 0x0004, 0x2a21: 0x0004, 0x2a22: 0x0004, 0x2a23: 0x0004,
	0x2a24: 0x0004, 0x2a25: 0x0004, 0x2a26: 0x0004, 0x2a27: 0x0004, 0x2a28: 0x0004, 0x2a29: 0x0004,
	0x2a2a: 0x0004, 0x2a2b: 0x0004, 0x2a2c: 0x0004, 0x2a2d: 0x0004, 0x2a2e: 0x0004, 0x2a2f: 0x0004,
	0x2a30: 0x0004, 0x2a31: 0x0004, 0x2a32: 0x0004, 0x2a33: 0x0004, 0x2a34: 0x0004, 0x2a35: 0x0004,
	0x2a36: 0x0004, 0x2a37: 0x0004, 0x2a38: 0x0004, 0x2a39: 0x0004, 0x2a3a: 0x0004, 0x2a3b: 0x0004,
	0x2a3c: 0x0004, 0x2a3d: 0x0004, 0x2a3e: 0x0004, 0x2a3f: 0x0004,
	// Block 0xa9, offset 0x2a40
	0x2a40: 0x0004, 0x2a41: 0x0004, 0x2a42: 0x0004, 0x2a43: 0x0004, 0x2a44: 0x0004, 0x2a45: 0x0004,
	0x2a46: 0x0004, 0x2a47: 0x0004, 0x2a48: 0x0004, 0x2a49: 0x0004, 0x2a4a: 0x0004, 0x2a4b: 0x0004,
	0x2a4c: 0x0004, 0x2a4d: 0x0004, 0x2a4e: 0x0004, 0x2a4f: 0x0004,
	0x2a52: 0x0004, 0x2a53: 0x0004, 0x2a54: 0x0004, 0x2a55: 0x0004, 0x2a56: 0x0004, 0x2a57: 0x0004,
	0x2a58: 0x0004, 0x2a59: 0x0004, 0x2a5a: 0x0004, 0x2a5b: 0x0004, 0x2a5c: 0x0004, 0x2a5d: 0x0004,
	0x2a5e: 0x0004, 0x2a5f: 0x0004, 0x2a60: 0x0004, 0x2a61: 0x0004, 0x2a62: 0x0004, 0x2a63: 0x0004,
	0x2a64: 0x0004, 0x2a65: 0x0004, 0x2a66: 0x0004, 0x2a67: 0x0004, 0x2a68: 0x0004, 0x2a69: 0x0004,
	0x2a6a: 0x0004, 0x2a6b: 0x0004, 0x2a6c: 0x0004, 0x2a6d: 0x0004, 0x2a6e: 0x0004, 0x2a6f: 0x0004,
	0x2a70: 0x0004, 0x2a71: 0x0004, 0x2a72: 0x0004, 0x2a73: 0x0004, 0x2a74: 0x0004, 0x2a75: 0x0004,
	0x2a76: 0x0004, 0x2a77: 0x0004, 0x2a78: 0x0004, 0x2a79: 0x0004, 0x2a7a: 0x0004, 0x2a7b: 0x0004,
	0x2a7c: 0x0004, 0x2a7d: 0x0004, 0x2a7e: 0x0004, 0x2a7f: 0x0004,
	// Block 0xaa, offset 0x2a80
	0x2a80: 0x0004, 0x2a81: 0x0004, 0x2a82: 0x0004, 0x2a83: 0x0004, 0x2a84: 0x0004, 0x2a85: 0x0004,
	0x2a86: 0x0004, 0x2a87: 0x0004,
	0x2ab0: 0x0004, 0x2ab1: 0x0004, 0x2ab2: 0x0004, 0x2ab3: 0x0004, 0x2ab4: 0x0004, 0x2ab5: 0x0004,
	0x2ab6: 0x0004, 0x2ab7: 0x0004, 0x2ab8: 0x0004, 0x2ab9: 0x0004, 0x2aba: 0x0004, 0x2abb: 0x0004,
	0x2abc: 0x0004, 0x2abd: 0x0004,
	// Block 0xab, offset 0x2ac0
	0x2ac0: 0x0001, 0x2ac1: 0x0001, 0x2ac2: 0x0001, 0x2ac3: 0x0001, 0x2ac4: 0x0001, 0x2ac5: 0x0001,
	0x2ac6: 0x0001, 0x2ac7: 0x0001, 0x2ac8: 0x0001, 0x2ac9: 0x0001, 0x2aca: 0x0001, 0x2acb: 0x0001,
	0x2acc: 0x0001, 0x2acd: 0x0001, 0x2ace: 0x0001, 0x2acf: 0x0001, 0x2ad0: 0x0004, 0x2ad1: 0x0004,
	0x2ad2: 0x0004, 0x2ad3: 0x0004, 0x2ad4: 0x0004, 0x2ad5: 0x0004, 0x2ad6: 0x0004, 0x2ad7: 0x0004,
	0x2ad8: 0x0004, 0x2ad9: 0x0004,
	0x2ae0: 0x0005, 0x2ae1: 0x0005, 0x2ae2: 0x0005, 0x2ae3: 0x0005,
	0x2ae4: 0x0005, 0x2ae5: 0x0005, 0x2ae6: 0x0005, 0x2ae7: 0x0005, 0x2ae8: 0x0005, 0x2ae9: 0x0005,
	0x2aea: 0x0005, 0x2aeb: 0x0005, 0x2aec: 0x0005, 0x2aed: 0x0005, 0x2aee: 0x0005, 0x2aef: 0x0005,
	0x2af0: 0x0004, 0x2af1: 0x0004, 0x2af2: 0x0004, 0x2af3: 0x0004, 0x2af4: 0x0004, 0x2af5: 0x0004,
	0x2af6: 0x0004, 0x2af7: 0x0004, 0x2af8: 0x0004, 0x2af9: 0x0004, 0x2afa: 0x0004, 0x2afb: 0x0004,
	0x2afc: 0x0004, 0x2afd: 0x0004, 0x2afe: 0x0004, 0x2aff: 0x0004,
	// Block 0xac, offset 0x2b00
	0x2b00: 0x0004, 0x2b01: 0x0004, 0x2b02: 0x0004, 0x2b03: 0x0004, 0x2b04: 0x0004, 0x2b05: 0x0004,
	0x2b06: 0x0004, 0x2b07: 0x0004, 0x2b08: 0x0004, 0x2b09: 0x0004, 0x2b0a: 0x0004, 0x2b0b: 0x0004,
	0x2b0c: 0x0004, 0x2b0d: 0x0004, 0x2b0e: 0x0004, 0x2b0f: 0x0004, 0x2b10: 0x0004, 0x2b11: 0x0004,
	0x2b12: 0x0004, 0x2b14: 0x0004, 0x2b15: 0x0004, 0x2b16: 0x0004, 0x2b17: 0x0004,
	0x2b18: 0x0004, 0x2b19: 0x0004, 0x2b1a: 0x0004, 0x2b1b: 0x0004, 0x2b1c: 0x0004, 0x2b1d: 0x0004,
	0x2b1e: 0x0004, 0x2b1f: 0x0004, 0x2b20: 0x0004, 0x2b21: 0x0004, 0x2b22: 0x0004, 0x2b23: 0x0004,
	0x2b24: 0x0004, 0x2b25: 0x0004, 0x2b26: 0x0004, 0x2b28: 0x0004, 0x2b29: 0x0004,
	0x2b2a: 0x0004, 0x2b2b: 0x0004,
	0x2b30: 0x0004, 0x2b31: 0x0004, 0x2b32: 0x0004, 0x2b33: 0x0005, 0x2b34: 0x0004,
	0x2b36: 0x0004, 0x2b37: 0x0004, 0x2b38: 0x0004, 0x2b39: 0x0004, 0x2b3a: 0x0004, 0x2b3b: 0x0004,
	0x2b3c: 0x0004, 0x2b3d: 0x0004, 0x2b3e: 0x0004, 0x2b3f: 0x0004,
	// Block 0xad, offset 0x2b40
	0x2b40: 0x0004, 0x2b41: 0x0004, 0x2b42: 0x0004, 0x2b43: 0x0004, 0x2b44: 0x0004, 0x2b45: 0x0004,
	0x2b46: 0x0004, 0x2b47: 0x0004, 0x2b48: 0x0004, 0x2b49: 0x0004, 0x2b4a: 0x0004, 0x2b4b: 0x0004,
	0x2b4c: 0x0004, 0x2b4d: 0x0004, 0x2b4e: 0x0004, 0x2b4f: 0x0004, 0x2b50: 0x0004, 0x2b51: 0x0004,
	0x2b52: 0x0004, 0x2b53: 0x0004, 0x2b54: 0x0004, 0x2b55: 0x0004, 0x2b56: 0x0004, 0x2b57: 0x0004,
	0x2b58: 0x0004, 0x2b59: 0x0004, 0x2b5a: 0x0004, 0x2b5b: 0x0004, 0x2b5c: 0x0004, 0x2b5d: 0x0004,
	0x2b5e: 0x0004, 0x2b5f: 0x0004, 0x2b60: 0x0004, 0x2b61: 0x0004, 0x2b62: 0x0004, 0x2b63: 0x0004,
	0x2b64: 0x0004, 0x2b65: 0x0004, 0x2b66: 0x0004, 0x2b67: 0x0004, 0x2b68: 0x0004, 0x2b69: 0x0004,
	0x2b6a: 0x0004, 0x2b6b: 0x0004, 0x2b6c: 0x0004, 0x2b6d: 0x0004, 0x2b6e: 0x0004, 0x2b6f: 0x0004,
	0x2b70: 0x0004, 0x2b71: 0x0004, 0x2b72: 0x0004, 0x2b73: 0x0004, 0x2b74: 0x0004, 0x2b75: 0x0004,
	0x2b76: 0x0004, 0x2b77: 0x0004, 0x2b78: 0x0004, 0x2b79: 0x0004, 0x2b7a: 0x0004, 0x2b7b: 0x0004,
	0x2b7c: 0x0004, 0x2b7f: 0x0001,
	// Block 0xae, offset 0x2b80
	0x2b81: 0x0004, 0x2b82: 0x0004, 0x2b83: 0x0004, 0x2b84: 0x0004, 0x2b85: 0x0004,
	0x2b86: 0x0004, 0x2b87: 0x0004, 0x2b88: 0x0004, 0x2b89: 0x0004, 0x2b8a: 0x0004, 0x2b8b: 0x0004,
	0x2b8c: 0x0004, 0x2b8d: 0x0004, 0x2b8e: 0x0004, 0x2b8f: 0x0004, 0x2b90: 0x0004, 0x2b91: 0x0004,
	0x2b92: 0x0004, 0x2b93: 0x0004, 0x2b94: 0x0004, 0x2b95: 0x0004, 0x2b96: 0x0004, 0x2b97: 0x0004,
	0x2b98: 0x0004, 0x2b99: 0x0004, 0x2b9a: 0x0004, 0x2b9b: 0x0004, 0x2b9c: 0x0004, 0x2b9d: 0x0004,
	0x2b9e: 0x0004, 0x2b9f: 0x0004, 0x2ba0: 0x0004, 0x2ba1: 0x0004, 0x2ba2: 0x0004, 0x2ba3: 0x0004,
	0x2ba4: 0x0004, 0x2ba5: 0x0004, 0x2ba6: 0x0004, 0x2ba7: 0x0004, 0x2ba8: 0x0004, 0x2ba9: 0x0004,
	0x2baa: 0x0004, 0x2bab: 0x0004, 0x2bac: 0x0004, 0x2bad: 0x0004, 0x2bae: 0x0004, 0x2baf: 0x0004,
	0x2bb0: 0x0004, 0x2bb1: 0x0004, 0x2bb2: 0x0004, 0x2bb3: 0x0004, 0x2bb4: 0x0004, 0x2bb5: 0x0004,
	0x2bb6: 0x0004, 0x2bb7: 0x0004, 0x2bb8: 0x0004, 0x2bb9: 0x0004, 0x2bba: 0x0004, 0x2bbb: 0x0004,
	0x2bbc: 0x0004, 0x2bbd: 0x0004, 0x2bbe: 0x0004, 0x2bbf: 0x0004,
	// Block 0xaf, offset 0x2bc0
	0x2bc0: 0x0004, 0x2bc1: 0x0004, 0x2bc2: 0x0004, 0x2bc3: 0x0004, 0x2bc4: 0x0004, 0x2bc5: 0x0004,
	0x2bc6: 0x0004, 0x2bc7: 0x0004, 0x2bc8: 0x0004, 0x2bc9: 0x0004, 0x2bca: 0x0004, 0x2bcb: 0x0004,
	0x2bcc: 0x0004, 0x2bcd: 0x0004, 0x2bce: 0x0004, 0x2bcf: 0x0004, 0x2bd0: 0x0004, 0x2bd1: 0x0004,
	0x2bd2: 0x0004, 0x2bd3: 0x0004, 0x2bd4: 0x0004, 0x2bd5: 0x0004, 0x2bd6: 0x0004, 0x2bd7: 0x0004,
	0x2bd8: 0x0004, 0x2bd9: 0x0004, 0x2bda: 0x0004, 0x2bdb: 0x0004, 0x2bdc: 0x0004, 0x2bdd: 0x0004,
	0x2bde: 0x0004, 0x2bdf: 0x0004, 0x2be0: 0x0001, 0x2be1: 0x0004, 0x2be2: 0x0004, 0x2be3: 0x0004,
	0x2be4: 0x0004, 0x2be5: 0x0004, 0x2be6: 0x0004, 0x2be7: 0x0004, 0x2be8: 0x0004, 0x2be9: 0x0004,
	0x2bea: 0x0004, 0x2beb: 0x0004, 0x2bec: 0x0004, 0x2bed: 0x0004, 0x2bee: 0x0004, 0x2bef: 0x0004,
	0x2bf0: 0x0004, 0x2bf1: 0x0004, 0x2bf2: 0x0004, 0x2bf3: 0x0004, 0x2bf4: 0x0004, 0x2bf5: 0x0004,
	0x2bf6: 0x0004, 0x2bf7: 0x0004, 0x2bf8: 0x0004, 0x2bf9: 0x0004, 0x2bfa: 0x0004, 0x2bfb: 0x0004,
	0x2bfc: 0x0004, 0x2bfd: 0x0004, 0x2bfe: 0x0004,
	// Block 0xb0, offset 0x2c00
	0x2c02: 0x0004, 0x2c03: 0x0004, 0x2c04: 0x0004, 0x2c05: 0x0004,
	0x2c06: 0x0004, 0x2c07: 0x0004, 0x2c0a: 0x0004, 0x2c0b: 0x0004,
	0x2c0c: 0x0004, 0x2c0d: 0x0004, 0x2c0e: 0x0004, 0x2c0f: 0x0004,
	0x2c12: 0x0004, 0x2c13: 0x0004, 0x2c14: 0x0004, 0x2c15: 0x0004, 0x2c16: 0x0004, 0x2c17: 0x0004,
	0x2c1a: 0x0004, 0x2c1b: 0x0004, 0x2c1c: 0x0004,
	0x2c20: 0x0004, 0x2c21: 0x0004, 0x2c22: 0x0004, 0x2c23: 0x0004,
	0x2c24: 0x0004, 0x2c25: 0x0004, 0x2c26: 0x0004, 0x2c28: 0x0004, 0x2c29: 0x0004,
	0x2c2a: 0x0004, 0x2c2b: 0x0004, 0x2c2c: 0x0004, 0x2c2d: 0x0004, 0x2c2e: 0x0004,
	0x2c39: 0x0001, 0x2c3a: 0x0001, 0x2c3b: 0x0001,
	0x2c3c: 0x0004, 0x2c3d: 0x0004,
	// Block 0xb1, offset 0x2c40
	0x2c40: 0x0005, 0x2c41: 0x0005, 0x2c42: 0x0005, 0x2c43: 0x0005, 0x2c44: 0x0005, 0x2c45: 0x0005,
	0x2c46: 0x0005, 0x2c47: 0x0005, 0x2c48: 0x0005, 0x2c49: 0x0005, 0x2c4a: 0x0005, 0x2c4b: 0x0005,
	0x2c4d: 0x0005, 0x2c4e: 0x0005, 0x2c4f: 0x0005, 0x2c50: 0x0005, 0x2c51: 0x0005,
	0x2c52: 0x0005, 0x2c53: 0x0005, 0x2c54: 0x0005, 0x2c55: 0x0005, 0x2c56: 0x0005, 0x2c57: 0x0005,
	0x2c58: 0x0005, 0x2c59: 0x0005, 0x2c5a: 0x0005, 0x2c5b: 0x0005, 0x2c5c: 0x0005, 0x2c5d: 0x0005,
	0x2c5e: 0x0005, 0x2c5f: 0x0005, 0x2c60: 0x0005, 0x2c61: 0x0005, 0x2c62: 0x0005, 0x2c63: 0x0005,
	0x2c64: 0x0005, 0x2c65: 0x0005, 0x2c66: 0x0005, 0x2c68: 0x0005, 0x2c69: 0x0005,
	0x2c6a: 0x0005, 0x2c6b: 0x0005, 0x2c6c: 0x0005, 0x2c6d: 0x0005, 0x2c6e: 0x0005, 0x2c6f: 0x0005,
	0x2c70: 0x0005, 0x2c71: 0x0005, 0x2c72: 0x0005, 0x2c73: 0x0005, 0x2c74: 0x0005, 0x2c75: 0x0005,
	0x2c76: 0x0005, 0x2c77: 0x0005, 0x2c78: 0x0005, 0x2c79: 0x0005, 0x2c7a: 0x0005,
	0x2c7c: 0x0005, 0x2c7d: 0x0005, 0x2c7f: 0x0005,
	// Block 0xb2, offset 0x2c80
	0x2c80: 0x0005, 0x2c81: 0x0005, 0x2c82: 0x0005, 0x2c83: 0x0005, 0x2c84: 0x0005, 0x2c85: 0x0005,
	0x2c86: 0x0005, 0x2c87: 0x0005, 0x2c88: 0x0005, 0x2c89: 0x0005, 0x2c8a: 0x0005, 0x2c8b: 0x0005,
	0x2c8c: 0x0005, 0x2c8d: 0x0005, 0x2c90: 0x0005, 0x2c91: 0x0005,
	0x2c92: 0x0005, 0x2c93: 0x0005, 0x2c94: 0x0005, 0x2c95: 0x0005, 0x2c96: 0x0005, 0x2c97: 0x0005,
	0x2c98: 0x0005, 0x2c99: 0x0005, 0x2c9a: 0x0005, 0x2c9b: 0x0005, 0x2c9c: 0x0005, 0x2c9d: 0x0005,
	// Block 0xb3, offset 0x2cc0
	0x2cc0: 0x0005, 0x2cc1: 0x0005, 0x2cc2: 0x0005, 0x2cc3: 0x0005, 0x2cc4: 0x0005, 0x2cc5: 0x0005,
	0x2cc6: 0x0005, 0x2cc7: 0x0005, 0x2cc8: 0x0005, 0x2cc9: 0x0005, 0x2cca: 0x0005, 0x2ccb: 0x0005,
	0x2ccc: 0x0005, 0x2ccd: 0x0005, 0x2cce: 0x0005, 0x2ccf: 0x0005, 0x2cd0: 0x0005, 0x2cd1: 0x0005,
	0x2cd2: 0x0005, 0x2cd3: 0x0005, 0x2cd4: 0x0005, 0x2cd5: 0x0005, 0x2cd6: 0x0005, 0x2cd7: 0x0005,
	0x2cd8: 0x0005, 0x2cd9: 0x0005, 0x2cda: 0x0005, 0x2cdb: 0x0005, 0x2cdc: 0x0005, 0x2cdd: 0x0005,
	0x2cde: 0x0005, 0x2cdf: 0x0005, 0x2ce0: 0x0005, 0x2ce1: 0x0005, 0x2ce2: 0x0005, 0x2ce3: 0x0005,
	0x2ce4: 0x0005, 0x2ce5: 0x0005, 0x2ce6: 0x0005, 0x2ce7: 0x0005, 0x2ce8: 0x0005, 0x2ce9: 0x0005,
	0x2cea: 0x0005, 0x2ceb: 0x0005, 0x2cec: 0x0005, 0x2ced: 0x0005, 0x2cee: 0x0005, 0x2cef: 0x0005,
	0x2cf0: 0x0005, 0x2cf1: 0x0005, 0x2cf2: 0x0005, 0x2cf3: 0x0005, 0x2cf4: 0x0005, 0x2cf5: 0x0005,
	0x2cf6: 0x0005, 0x2cf7: 0x0005, 0x2cf8: 0x0005, 0x2cf9: 0x0005, 0x2cfa: 0x0005,
	// Block 0xb4, offset 0x2d00
	0x2d00: 0x0004, 0x2d01: 0x0004, 0x2d02: 0x0004,
	0x2d07: 0x0004, 0x2d08: 0x0004, 0x2d09: 0x0004, 0x2d0a: 0x0004, 0x2d0b: 0x0004,
	0x2d0c: 0x0004, 0x2d0d: 0x0004, 0x2d0e: 0x0004, 0x2d0f: 0x0004, 0x2d10: 0x0004, 0x2d11: 0x0004,
	0x2d12: 0x0004, 0x2d13: 0x0004, 0x2d14: 0x0004, 0x2d15: 0x0004, 0x2d16: 0x0004, 0x2d17: 0x0004,
	0x2d18: 0x0004, 0x2d19: 0x0004, 0x2d1a: 0x0004, 0x2d1b: 0x0004, 0x2d1c: 0x0004, 0x2d1d: 0x0004,
	0x2d1e: 0x0004, 0x2d1f: 0x0004, 0x2d20: 0x0004, 0x2d21: 0x0004, 0x2d22: 0x0004, 0x2d23: 0x0004,
	0x2d24: 0x0004, 0x2d25: 0x0004, 0x2d26: 0x0004, 0x2d27: 0x0004, 0x2d28: 0x0004, 0x2d29: 0x0004,
	0x2d2a: 0x0004, 0x2d2b: 0x0004, 0x2d2c: 0x0004, 0x2d2d: 0x0004, 0x2d2e: 0x0004, 0x2d2f: 0x0004,
	0x2d30: 0x0004, 0x2d31: 0x0004, 0x2d32: 0x0004, 0x2d33: 0x0004,
	0x2d37: 0x0004, 0x2d38: 0x0004, 0x2d39: 0x0004, 0x2d3a: 0x0004, 0x2d3b: 0x0004,
	0x2d3c: 0x0004, 0x2d3d: 0x0004, 0x2d3e: 0x0004, 0x2d3f: 0x0004,
	// Block 0xb5, offset 0x2d40
	0x2d40: 0x0004, 0x2d41: 0x0004, 0x2d42: 0x0004, 0x2d43: 0x0004, 0x2d44: 0x0004, 0x2d45: 0x0004,
	0x2d46: 0x0004, 0x2d47: 0x0004, 0x2d48: 0x0004, 0x2d49: 0x0004, 0x2d4a: 0x0004, 0x2d4b: 0x0004,
	0x2d4c: 0x0004, 0x2d50: 0x0004, 0x2d51: 0x0004,
	0x2d52: 0x0004, 0x2d53: 0x0004, 0x2d54: 0x0004, 0x2d55: 0x0004, 0x2d56: 0x0004, 0x2d57: 0x0004,
	0x2d58: 0x0004, 0x2d59: 0x0004, 0x2d5a: 0x0004, 0x2d5b: 0x0004,
	0x2d60: 0x0004,
	// Block 0xb6, offset 0x2d80
	0x2d90: 0x0004, 0x2d91: 0x0004,
	0x2d92: 0x0004, 0x2d93: 0x0004, 0x2d94: 0x0004, 0x2d95: 0x0004, 0x2d96: 0x0004, 0x2d97: 0x0004,
	0x2d98: 0x0004, 0x2d99: 0x0004, 0x2d9a: 0x0004, 0x2d9b: 0x0004, 0x2d9c: 0x0004, 0x2d9d: 0x0004,
	0x2d9e: 0x0004, 0x2d9f: 0x0004, 0x2da0: 0x0004, 0x2da1: 0x0004, 0x2da2: 0x0004, 0x2da3: 0x0004,
	0x2da4: 0x0004, 0x2da5: 0x0004, 0x2da6: 0x0004, 0x2da7: 0x0004, 0x2da8: 0x0004, 0x2da9: 0x0004,
	0x2daa: 0x0004, 0x2dab: 0x0004, 0x2dac: 0x0004, 0x2dad: 0x0004, 0x2dae: 0x0004, 0x2daf: 0x0004,
	0x2db0: 0x0004, 0x2db1: 0x0004, 0x2db2: 0x0004, 0x2db3: 0x0004, 0x2db4: 0x0004, 0x2db5: 0x0004,
	0x2db6: 0x0004, 0x2db7: 0x0004, 0x2db8: 0x0004, 0x2db9: 0x0004, 0x2dba: 0x0004, 0x2dbb: 0x0004,
	0x2dbc: 0x0004, 0x2dbd: 0x0005,
	// Block 0xb7, offset 0x2dc0
	0x2dc0: 0x0005, 0x2dc1: 0x0005, 0x2dc2: 0x0005, 0x2dc3: 0x0005, 0x2dc4: 0x0005, 0x2dc5: 0x0005,
	0x2dc6: 0x0005, 0x2dc7: 0x0005, 0x2dc8: 0x0005, 0x2dc9: 0x0005, 0x2dca: 0x0005, 0x2dcb: 0x0005,
	0x2dcc: 0x0005, 0x2dcd: 0x0005, 0x2dce: 0x0005, 0x2dcf: 0x0005, 0x2dd0: 0x0005, 0x2dd1: 0x0005,
	0x2dd2: 0x0005, 0x2dd3: 0x0005, 0x2dd4: 0x0005, 0x2dd5: 0x0005, 0x2dd6: 0x0005, 0x2dd7: 0x0005,
	0x2dd8: 0x0005, 0x2dd9: 0x0005, 0x2dda: 0x0005, 0x2ddb: 0x0005, 0x2ddc: 0x0005,
	0x2de0: 0x0005, 0x2de1: 0x0005, 0x2de2: 0x0005, 0x2de3: 0x0005,
	0x2de4: 0x0005, 0x2de5: 0x0005, 0x2de6: 0x0005, 0x2de7: 0x0005, 0x2de8: 0x0005, 0x2de9: 0x0005,
	0x2dea: 0x0005, 0x2deb: 0x0005, 0x2dec: 0x0005, 0x2ded: 0x0005, 0x2dee: 0x0005, 0x2def: 0x0005,
	0x2df0: 0x0005, 0x2df1: 0x0005, 0x2df2: 0x0005, 0x2df3: 0x0005, 0x2df4: 0x0005, 0x2df5: 0x0005,
	0x2df6: 0x0005, 0x2df7: 0x0005, 0x2df8: 0x0005, 0x2df9: 0x0005, 0x2dfa: 0x0005, 0x2dfb: 0x0005,
	0x2dfc: 0x0005, 0x2dfd: 0x0005, 0x2dfe: 0x0005, 0x2dff: 0x0005,
	// Block 0xb8, offset 0x2e00
	0x2e00: 0x0005, 0x2e01: 0x0005, 0x2e02: 0x0005, 0x2e03: 0x0005, 0x2e04: 0x0005, 0x2e05: 0x0005,
	0x2e06: 0x0005, 0x2e07: 0x0005, 0x2e08: 0x0005, 0x2e09: 0x0005, 0x2e0a: 0x0005, 0x2e0b: 0x0005,
	0x2e0c: 0x0005, 0x2e0d: 0x0005, 0x2e0e: 0x0005, 0x2e0f: 0x0005, 0x2e10: 0x0005,
	0x2e20: 0x0005, 0x2e21: 0x0004, 0x2e22: 0x0004, 0x2e23: 0x0004,
	0x2e24: 0x0004, 0x2e25: 0x0004, 0x2e26: 0x0004, 0x2e27: 0x0004, 0x2e28: 0x0004, 0x2e29: 0x0004,
	0x2e2a: 0x0004, 0x2e2b: 0x0004, 0x2e2c: 0x0004, 0x2e2d: 0x0004, 0x2e2e: 0x0004, 0x2e2f: 0x0004,
	0x2e30: 0x0004, 0x2e31: 0x0004, 0x2e32: 0x0004, 0x2e33: 0x0004, 0x2e34: 0x0004, 0x2e35: 0x0004,
	0x2e36: 0x0004, 0x2e37: 0x0004, 0x2e38: 0x0004, 0x2e39: 0x0004, 0x2e3a: 0x0004, 0x2e3b: 0x0004,
	// Block 0xb9, offset 0x2e40
	0x2e40: 0x0005, 0x2e41: 0x0005, 0x2e42: 0x0005, 0x2e43: 0x0005, 0x2e44: 0x0005, 0x2e45: 0x0005,
	0x2e46: 0x0005, 0x2e47: 0x0005, 0x2e48: 0x0005, 0x2e49: 0x0005, 0x2e4a: 0x0005, 0x2e4b: 0x0005,
	0x2e4c: 0x0005, 0x2e4d: 0x0005, 0x2e4e: 0x0005, 0x2e4f: 0x0005, 0x2e50: 0x0005, 0x2e51: 0x0005,
	0x2e52: 0x0005, 0x2e53: 0x0005, 0x2e54: 0x0005, 0x2e55: 0x0005, 0x2e56: 0x0005, 0x2e57: 0x0005,
	0x2e58: 0x0005, 0x2e59: 0x0005, 0x2e5a: 0x0005, 0x2e5b: 0x0005, 0x2e5c: 0x0005, 0x2e5d: 0x0005,
	0x2e5e: 0x0005, 0x2e5f: 0x0005, 0x2e60: 0x0004, 0x2e61: 0x0004, 0x2e62: 0x0004, 0x2e63: 0x0004,
	0x2e70: 0x0005, 0x2e71: 0x0005, 0x2e72: 0x0005, 0x2e73: 0x0005, 0x2e74: 0x0005, 0x2e75: 0x0005,
	0x2e76: 0x0005, 0x2e77: 0x0005, 0x2e78: 0x0005, 0x2e79: 0x0005, 0x2e7a: 0x0005, 0x2e7b: 0x0005,
	0x2e7c: 0x0005, 0x2e7d: 0x0005, 0x2e7e: 0x0005, 0x2e7f: 0x0005,
	// Block 0xba, offset 0x2e80
	0x2e80: 0x0005, 0x2e81: 0x0004, 0x2e82: 0x0005, 0x2e83: 0x0005, 0x2e84: 0x0005, 0x2e85: 0x0005,
	0x2e86: 0x0005, 0x2e87: 0x0005, 0x2e88: 0x0005, 0x2e89: 0x0005, 0x2e8a: 0x0004,
	0x2e90: 0x0005, 0x2e91: 0x0005,
	0x2e92: 0x0005, 0x2e93: 0x0005, 0x2e94: 0x0005, 0x2e95: 0x0005, 0x2e96: 0x0005, 0x2e97: 0x0005,
	0x2e98: 0x0005, 0x2e99: 0x0005, 0x2e9a: 0x0005, 0x2e9b: 0x0005, 0x2e9c: 0x0005, 0x2e9d: 0x0005,
	0x2e9e: 0x0005, 0x2e9f: 0x0005, 0x2ea0: 0x0005, 0x2ea1: 0x0005, 0x2ea2: 0x0005, 0x2ea3: 0x0005,
	0x2ea4: 0x0005, 0x2ea5: 0x0005, 0x2ea6: 0x0005, 0x2ea7: 0x0005, 0x2ea8: 0x0005, 0x2ea9: 0x0005,
	0x2eaa: 0x0005, 0x2eab: 0x0005, 0x2eac: 0x0005, 0x2ead: 0x0005, 0x2eae: 0x0005, 0x2eaf: 0x0005,
	0x2eb0: 0x0005, 0x2eb1: 0x0005, 0x2eb2: 0x0005, 0x2eb3: 0x0005, 0x2eb4: 0x0005, 0x2eb5: 0x0005,
	0x2eb6: 0x0005, 0x2eb7: 0x0005, 0x2eb8: 0x0005, 0x2eb9: 0x0005, 0x2eba: 0x0005,
	// Block 0xbb, offset 0x2ec0
	0x2ec0: 0x0005, 0x2ec1: 0x0005, 0x2ec2: 0x0005, 0x2ec3: 0x0005, 0x2ec4: 0x0005, 0x2ec5: 0x0005,
	0x2ec6: 0x0005, 0x2ec7: 0x0005, 0x2ec8: 0x0005, 0x2ec9: 0x0005, 0x2eca: 0x0005, 0x2ecb: 0x0005,
	0x2ecc: 0x0005, 0x2ecd: 0x0005, 0x2ece: 0x0005, 0x2ecf: 0x0005, 0x2ed0: 0x0005, 0x2ed1: 0x0005,
	0x2ed2: 0x0005, 0x2ed3: 0x0005, 0x2ed4: 0x0005, 0x2ed5: 0x0005, 0x2ed6: 0x0005, 0x2ed7: 0x0005,
	0x2ed8: 0x0005, 0x2ed9: 0x0005, 0x2eda: 0x0005, 0x2edb: 0x0005, 0x2edc: 0x0005, 0x2edd: 0x0005,
	0x2edf: 0x0004, 0x2ee0: 0x0005, 0x2ee1: 0x0005, 0x2ee2: 0x0005, 0x2ee3: 0x0005,
	0x2ee4: 0x0005, 0x2ee5: 0x0005, 0x2ee6: 0x0005, 0x2ee7: 0x0005, 0x2ee8: 0x0005, 0x2ee9: 0x0005,
	0x2eea: 0x0005, 0x2eeb: 0x0005, 0x2eec: 0x0005, 0x2eed: 0x0005, 0x2eee: 0x0005, 0x2eef: 0x0005,
	0x2ef0: 0x0005, 0x2ef1: 0x0005, 0x2ef2: 0x0005, 0x2ef3: 0x0005, 0x2ef4: 0x0005, 0x2ef5: 0x0005,
	0x2ef6: 0x0005, 0x2ef7: 0x0005, 0x2ef8: 0x0005, 0x2ef9: 0x0005, 0x2efa: 0x0005, 0x2efb: 0x0005,
	0x2efc: 0x0005, 0x2efd: 0x0005, 0x2efe: 0x0005, 0x2eff: 0x0005,
	// Block 0xbc, offset 0x2f00
	0x2f00: 0x0005, 0x2f01: 0x0005, 0x2f02: 0x0005, 0x2f03: 0x0005,
	0x2f08: 0x0005, 0x2f09: 0x0005, 0x2f0a: 0x0005, 0x2f0b: 0x0005,
	0x2f0c: 0x0005, 0x2f0d: 0x0005, 0x2f0e: 0x0005, 0x2f0f: 0x0005, 0x2f10: 0x0004, 0x2f11: 0x0004,
	0x2f12: 0x0004, 0x2f13: 0x0004, 0x2f14: 0x0004, 0x2f15: 0x0004,
	// Block 0xbd, offset 0x2f40
	0x2f40: 0x0005, 0x2f41: 0x0005, 0x2f42: 0x0005, 0x2f43: 0x0005, 0x2f44: 0x0005, 0x2f45: 0x0005,
	0x2f46: 0x0005, 0x2f47: 0x0005, 0x2f48: 0x0005, 0x2f49: 0x0005, 0x2f4a: 0x0005, 0x2f4b: 0x0005,
	0x2f4c: 0x0005, 0x2f4d: 0x0005, 0x2f4e: 0x0005, 0x2f4f: 0x0005, 0x2f50: 0x0005, 0x2f51: 0x0005,
	0x2f52: 0x0005, 0x2f53: 0x0005, 0x2f54: 0x0005, 0x2f55: 0x0005, 0x2f56: 0x0005, 0x2f57: 0x0005,
	0x2f58: 0x0005, 0x2f59: 0x0005, 0x2f5a: 0x0005, 0x2f5b: 0x0005, 0x2f5c: 0x0005, 0x2f5d: 0x0005,
	0x2f60: 0x0005, 0x2f61: 0x0005, 0x2f62: 0x0005, 0x2f63: 0x0005,
	0x2f64: 0x0005, 0x2f65: 0x0005, 0x2f66: 0x0005, 0x2f67: 0x0005, 0x2f68: 0x0005, 0x2f69: 0x0005,
	// Block 0xbe, offset 0x2f80
	0x2f80: 0x0005, 0x2f81: 0x0005, 0x2f82: 0x0005, 0x2f83: 0x0005, 0x2f84: 0x0005, 0x2f85: 0x0005,
	0x2f86: 0x0005, 0x2f87: 0x0005, 0x2f88: 0x0005, 0x2f89: 0x0005, 0x2f8a: 0x0005, 0x2f8b: 0x0005,
	0x2f8c: 0x0005, 0x2f8d: 0x0005, 0x2f8e: 0x0005, 0x2f8f: 0x0005, 0x2f90: 0x0005, 0x2f91: 0x0005,
	0x2f92: 0x0005, 0x2f93: 0x0005, 0x2f94: 0x0005, 0x2f95: 0x0005, 0x2f96: 0x0005, 0x2f97: 0x0005,
	0x2f98: 0x0005, 0x2f99: 0x0005, 0x2f9a: 0x0005, 0x2f9b: 0x0005, 0x2f9c: 0x0005, 0x2f9d: 0x0005,
	0x2f9e: 0x0005, 0x2f9f: 0x0005, 0x2fa0: 0x0005, 0x2fa1: 0x0005, 0x2fa2: 0x0005, 0x2fa3: 0x0005,
	0x2fa4: 0x0005, 0x2fa5: 0x0005, 0x2fa6: 0x0005, 0x2fa7: 0x0005,
	0x2fb0: 0x0005, 0x2fb1: 0x0005, 0x2fb2: 0x0005, 0x2fb3: 0x0005, 0x2fb4: 0x0005, 0x2fb5: 0x0005,
	0x2fb6: 0x0005, 0x2fb7: 0x0005, 0x2fb8: 0x0005, 0x2fb9: 0x0005, 0x2fba: 0x0005, 0x2fbb: 0x0005,
	0x2fbc: 0x0005, 0x2fbd: 0x0005, 0x2fbe: 0x0005, 0x2fbf: 0x0005,
	// Block 0xbf, offset 0x2fc0
	0x2fc0: 0x0005, 0x2fc1: 0x0005, 0x2fc2: 0x0005, 0x2fc3: 0x0005, 0x2fc4: 0x0005, 0x2fc5: 0x0005,
	0x2fc6: 0x0005, 0x2fc7: 0x0005, 0x2fc8: 0x0005, 0x2fc9: 0x0005, 0x2fca: 0x0005, 0x2fcb: 0x0005,
	0x2fcc: 0x0005, 0x2fcd: 0x0005, 0x2fce: 0x0005, 0x2fcf: 0x0005, 0x2fd0: 0x0005, 0x2fd1: 0x0005,
	0x2fd2: 0x0005, 0x2fd3: 0x0005, 0x2fd4: 0x0005, 0x2fd5: 0x0005, 0x2fd6: 0x0005, 0x2fd7: 0x0005,
	0x2fd8: 0x0005, 0x2fd9: 0x0005, 0x2fda: 0x0005, 0x2fdb: 0x0005, 0x2fdc: 0x0005, 0x2fdd: 0x0005,
	0x2fde: 0x0005, 0x2fdf: 0x0005, 0x2fe0: 0x0005, 0x2fe1: 0x0005, 0x2fe2: 0x0005, 0x2fe3: 0x0005,
	0x2fef: 0x0004,
	// Block 0xc0, offset 0x3000
	0x3000: 0x0005, 0x3001: 0x0005, 0x3002: 0x0005, 0x3003: 0x0005, 0x3004: 0x0005, 0x3005: 0x0005,
	0x3006: 0x0005, 0x3007: 0x0005, 0x3008: 0x0005, 0x3009: 0x0005, 0x300a: 0x0005, 0x300b: 0x0005,
	0x300c: 0x0005, 0x300d: 0x0005, 0x300e: 0x0005, 0x300f: 0x0005, 0x3010: 0x0005, 0x3011: 0x0005,
	0x3012: 0x0005, 0x3013: 0x0005, 0x3014: 0x0005, 0x3015: 0x0005,
	0x3020: 0x0005, 0x3021: 0x0005, 0x3022: 0x0005, 0x3023: 0x0005,
	0x3024: 0x0005, 0x3025: 0x0005, 0x3026: 0x0005, 0x3027: 0x0005,
	// Block 0xc1, offset 0x3040
	0x3040: 0x0005, 0x3041: 0x0005, 0x3042: 0x0005, 0x3043: 0x0005, 0x3044: 0x0005, 0x3045: 0x0005,
	0x3048: 0x0005, 0x304a: 0x0005, 0x304b: 0x0005,
	0x304c: 0x0005, 0x304d: 0x0005, 0x304e: 0x0005, 0x304f: 0x0005, 0x3050: 0x0005, 0x3051: 0x0005,
	0x3052: 0x0005, 0x3053: 0x0005, 0x3054: 0x0005, 0x3055: 0x0005, 0x3056: 0x0005, 0x3057: 0x0005,
	0x3058: 0x0005, 0x3059: 0x0005, 0x305a: 0x0005, 0x305b: 0x0005, 0x305c: 0x0005, 0x305d: 0x0005,
	0x305e: 0x0005, 0x305f: 0x0005, 0x3060: 0x0005, 0x3061: 0x0005, 0x3062: 0x0005, 0x3063: 0x0005,
	0x3064: 0x0005, 0x3065: 0x0005, 0x3066: 0x0005, 0x3067: 0x0005, 0x3068: 0x0005, 0x3069: 0x0005,
	0x306a: 0x0005, 0x306b: 0x0005, 0x306c: 0x0005, 0x306d: 0x0005, 0x306e: 0x0005, 0x306f: 0x0005,
	0x3070: 0x0005, 0x3071: 0x0005, 0x3072: 0x0005, 0x3073: 0x0005, 0x3074: 0x0005, 0x3075: 0x0005,
	0x3077: 0x0005, 0x3078: 0x0005,
	0x307c: 0x0005, 0x307f: 0x0005,
	// Block 0xc2, offset 0x3080
	0x3080: 0x0005, 0x3081: 0x0005, 0x3082: 0x0005, 0x3083: 0x0005, 0x3084: 0x0005, 0x3085: 0x0005,
	0x3086: 0x0005, 0x3087: 0x0005, 0x3088: 0x0005, 0x3089: 0x0005, 0x308a: 0x0005, 0x308b: 0x0005,
	0x308c: 0x0005, 0x308d: 0x0005, 0x308e: 0x0005, 0x308f: 0x0005, 0x3090: 0x0005, 0x3091: 0x0005,
	0x3092: 0x0005, 0x3093: 0x0005, 0x3094: 0x0005, 0x3095: 0x0005, 0x3097: 0x0004,
	0x3098: 0x0004, 0x3099: 0x0004, 0x309a: 0x0004, 0x309b: 0x0004, 0x309c: 0x0004, 0x309d: 0x0004,
	0x309e: 0x0004, 0x309f: 0x0004, 0x30a0: 0x0005, 0x30a1: 0x0005, 0x30a2: 0x0005, 0x30a3: 0x0005,
	0x30a4: 0x0005, 0x30a5: 0x0005, 0x30a6: 0x0005, 0x30a7: 0x0005, 0x30a8: 0x0005, 0x30a9: 0x0005,
	0x30aa: 0x0005, 0x30ab: 0x0005, 0x30ac: 0x0005, 0x30ad: 0x0005, 0x30ae: 0x0005, 0x30af: 0x0005,
	0x30b0: 0x0005, 0x30b1: 0x0005, 0x30b2: 0x0005, 0x30b3: 0x0005, 0x30b4: 0x0005, 0x30b5: 0x0005,
	0x30b6: 0x0005, 0x30b7: 0x0004, 0x30b8: 0x0004, 0x30b9: 0x0004, 0x30ba: 0x0004, 0x30bb: 0x0004,
	0x30bc: 0x0004, 0x30bd: 0x0004, 0x30be: 0x0004, 0x30bf: 0x0004,
	// Block 0xc3, offset 0x30c0
	0x30c0: 0x0005, 0x30c1: 0x0005, 0x30c2: 0x0005, 0x30c3: 0x0005, 0x30c4: 0x0005, 0x30c5: 0x0005,
	0x30c6: 0x0005, 0x30c7: 0x0005, 0x30c8: 0x0005, 0x30c9: 0x0005, 0x30ca: 0x0005, 0x30cb: 0x0005,
	0x30cc: 0x0005, 0x30cd: 0x0005, 0x30ce: 0x0005, 0x30cf: 0x0005, 0x30d0: 0x0005, 0x30d1: 0x0005,
	0x30d2: 0x0005, 0x30d3: 0x0005, 0x30d4: 0x0005, 0x30d5: 0x0005, 0x30d6: 0x0005, 0x30d7: 0x0005,
	0x30d8: 0x0005, 0x30d9: 0x0005, 0x30da: 0x0005, 0x30db: 0x0005, 0x30dc: 0x0005, 0x30dd: 0x0005,
	0x30de: 0x0005,
	0x30e7: 0x0004, 0x30e8: 0x0004, 0x30e9: 0x0004,
	0x30ea: 0x0004, 0x30eb: 0x0004, 0x30ec: 0x0004, 0x30ed: 0x0004, 0x30ee: 0x0004, 0x30ef: 0x0004,
	// Block 0xc4, offset 0x3100
	0x3120: 0x0005, 0x3121: 0x0005, 0x3122: 0x0005, 0x3123: 0x0005,
	0x3124: 0x0005, 0x3125: 0x0005, 0x3126: 0x0005, 0x3127: 0x0005, 0x3128: 0x0005, 0x3129: 0x0005,
	0x312a: 0x0005, 0x312b: 0x0005, 0x312c: 0x0005, 0x312d: 0x0005, 0x312e: 0x0005, 0x312f: 0x0005,
	0x3130: 0x0005, 0x3131: 0x0005, 0x3132: 0x0005, 0x3134: 0x0005, 0x3135: 0x0005,
	0x313b: 0x0004,
	0x313c: 0x0004, 0x313d: 0x0004, 0x313e: 0x0004, 0x313f: 0x0004,
	// Block 0xc5, offset 0x3140
	0x3140: 0x0005, 0x3141: 0x0005, 0x3142: 0x0005, 0x3143: 0x0005, 0x3144: 0x0005, 0x3145: 0x0005,
	0x3146: 0x0005, 0x3147: 0x0005, 0x3148: 0x0005, 0x3149: 0x0005, 0x314a: 0x0005, 0x314b: 0x0005,
	0x314c: 0x0005, 0x314d: 0x0005, 0x314e: 0x0005, 0x314f: 0x0005, 0x3150: 0x0005, 0x3151: 0x0005,
	0x3152: 0x0005, 0x3153: 0x0005, 0x3154: 0x0005, 0x3155: 0x0005, 0x3156: 0x0004, 0x3157: 0x0004,
	0x3158: 0x0004, 0x3159: 0x0004, 0x315a: 0x0004, 0x315b: 0x0004,
	0x315f: 0x0004, 0x3160: 0x0005, 0x3161: 0x0005, 0x3162: 0x0005, 0x3163: 0x0005,
	0x3164: 0x0005, 0x3165: 0x0005, 0x3166: 0x0005, 0x3167: 0x0005, 0x3168: 0x0005, 0x3169: 0x0005,
	0x316a: 0x0005, 0x316b: 0x0005, 0x316c: 0x0005, 0x316d: 0x0005, 0x316e: 0x0005, 0x316f: 0x0005,
	0x3170: 0x0005, 0x3171: 0x0005, 0x3172: 0x0005, 0x3173: 0x0005, 0x3174: 0x0005, 0x3175: 0x0005,
	0x3176: 0x0005, 0x3177: 0x0005, 0x3178: 0x0005, 0x3179: 0x0005,
	0x317f: 0x0004,
	// Block 0xc6, offset 0x3180
	0x3180: 0x0005, 0x3181: 0x0005, 0x3182: 0x0005, 0x3183: 0x0005, 0x3184: 0x0005, 0x3185: 0x0005,
	0x3186: 0x0005, 0x3187: 0x0005, 0x3188: 0x0005, 0x3189: 0x0005, 0x318a: 0x0005, 0x318b: 0x0005,
	0x318c: 0x0005, 0x318d: 0x0005, 0x318e: 0x0005, 0x318f: 0x0005, 0x3190: 0x0005, 0x3191: 0x0005,
	0x3192: 0x0005, 0x3193: 0x0005, 0x3194: 0x0005, 0x3195: 0x0005, 0x3196: 0x0005, 0x3197: 0x0005,
	0x3198: 0x0005, 0x3199: 0x0005, 0x319a: 0x0005, 0x319b: 0x0005, 0x319c: 0x0005, 0x319d: 0x0005,
	0x319e: 0x0005, 0x319f: 0x0005, 0x31a0: 0x0005, 0x31a1: 0x0005, 0x31a2: 0x0005, 0x31a3: 0x0005,
	0x31a4: 0x0005, 0x31a5: 0x0005, 0x31a6: 0x0005, 0x31a7: 0x0005, 0x31a8: 0x0005, 0x31a9: 0x0005,
	0x31aa: 0x0005, 0x31ab: 0x0005, 0x31ac: 0x0005, 0x31ad: 0x0005, 0x31ae: 0x0005, 0x31af: 0x0005,
	0x31b0: 0x0005, 0x31b1: 0x0005, 0x31b2: 0x0005, 0x31b3: 0x0005, 0x31b4: 0x0005, 0x31b5: 0x0005,
	0x31b6: 0x0005, 0x31b7: 0x0005,
	0x31bc: 0x0004, 0x31bd: 0x0004, 0x31be: 0x0005, 0x31bf: 0x0005,
	// Block 0xc7, offset 0x31c0
	0x31c0: 0x0005, 0x31c1: 0x0005, 0x31c2: 0x0005, 0x31c3: 0x0005, 0x31c5: 0x0005,
	0x31c6: 0x0005,
	0x31cc: 0x0005, 0x31cd: 0x0005, 0x31ce: 0x0005, 0x31cf: 0x0005, 0x31d0: 0x0005, 0x31d1: 0x0005,
	0x31d2: 0x0005, 0x31d3: 0x0005, 0x31d5: 0x0005, 0x31d6: 0x0005, 0x31d7: 0x0005,
	0x31d9: 0x0005, 0x31da: 0x0005, 0x31db: 0x0005, 0x31dc: 0x0005, 0x31dd: 0x0005,
	0x31de: 0x0005, 0x31df: 0x0005, 0x31e0: 0x0005, 0x31e1: 0x0005, 0x31e2: 0x0005, 0x31e3: 0x0005,
	0x31e4: 0x0005, 0x31e5: 0x0005, 0x31e6: 0x0005, 0x31e7: 0x0005, 0x31e8: 0x0005, 0x31e9: 0x0005,
	0x31ea: 0x0005, 0x31eb: 0x0005, 0x31ec: 0x0005, 0x31ed: 0x0005, 0x31ee: 0x0005, 0x31ef: 0x0005,
	0x31f0: 0x0005, 0x31f1: 0x0005, 0x31f2: 0x0005, 0x31f3: 0x0005,
	0x31f8: 0x0005, 0x31f9: 0x0005, 0x31fa: 0x0005,
	0x31ff: 0x0005,
	// Block 0xc8, offset 0x3200
	0x3200: 0x0004, 0x3201: 0x0004, 0x3202: 0x0004, 0x3203: 0x0004, 0x3204: 0x0004, 0x3205: 0x0004,
	0x3206: 0x0004, 0x3207: 0x0004,
	0x3210: 0x0004, 0x3211: 0x0004,
	0x3212: 0x0004, 0x3213: 0x0004, 0x3214: 0x0004, 0x3215: 0x0004, 0x3216: 0x0004, 0x3217: 0x0004,
	0x3218: 0x0004,
	0x3220: 0x0005, 0x3221: 0x0005, 0x3222: 0x0005, 0x3223: 0x0005,
	0x3224: 0x0005, 0x3225: 0x0005, 0x3226: 0x0005, 0x3227: 0x0005, 0x3228: 0x0005, 0x3229: 0x0005,
	0x322a: 0x0005, 0x322b: 0x0005, 0x322c: 0x0005, 0x322d: 0x0005, 0x322e: 0x0005, 0x322f: 0x0005,
	0x3230: 0x0005, 0x3231: 0x0005, 0x3232: 0x0005, 0x3233: 0x0005, 0x3234: 0x0005, 0x3235: 0x0005,
	0x3236: 0x0005, 0x3237: 0x0005, 0x3238: 0x0005, 0x3239: 0x0005, 0x323a: 0x0005, 0x323b: 0x0005,
	0x323c: 0x0005, 0x323d: 0x0004, 0x323e: 0x0004, 0x323f: 0x0004,
	// Block 0xc9, offset 0x3240
	0x3240: 0x0005, 0x3241: 0x0005, 0x3242: 0x0005, 0x3243: 0x0005, 0x3244: 0x0005, 0x3245: 0x0005,
	0x3246: 0x0005, 0x3247: 0x0005, 0x3248: 0x0005, 0x3249: 0x0005, 0x324a: 0x0005, 0x324b: 0x0005,
	0x324c: 0x0005, 0x324d: 0x0005, 0x324e: 0x0005, 0x324f: 0x0005, 0x3250: 0x0005, 0x3251: 0x0005,
	0x3252: 0x0005, 0x3253: 0x0005, 0x3254: 0x0005, 0x3255: 0x0005, 0x3256: 0x0005, 0x3257: 0x0005,
	0x3258: 0x0005, 0x3259: 0x0005, 0x325a: 0x0005, 0x325b: 0x0005, 0x325c: 0x0005, 0x325d: 0x0004,
	0x325e: 0x0004, 0x325f: 0x0004,
	// Block 0xca, offset 0x3280
	0x3280: 0x0005, 0x3281: 0x0005, 0x3282: 0x0005, 0x3283: 0x0005, 0x3284: 0x0005, 0x3285: 0x0005,
	0x3286: 0x0005, 0x3287: 0x0005, 0x3288: 0x0004, 0x3289: 0x0005, 0x328a: 0x0005, 0x328b: 0x0005,
	0x328c: 0x0005, 0x328d: 0x0005, 0x328e: 0x0005, 0x328f: 0x0005, 0x3290: 0x0005, 0x3291: 0x0005,
	0x3292: 0x0005, 0x3293: 0x0005, 0x3294: 0x0005, 0x3295: 0x0005, 0x3296: 0x0005, 0x3297: 0x0005,
	0x3298: 0x0005, 0x3299: 0x0005, 0x329a: 0x0005, 0x329b: 0x0005, 0x329c: 0x0005, 0x329d: 0x0005,
	0x329e: 0x0005, 0x329f: 0x0005, 0x32a0: 0x0005, 0x32a1: 0x0005, 0x32a2: 0x0005, 0x32a3: 0x0005,
	0x32a4: 0x0005, 0x32a5: 0x0005, 0x32a6: 0x0005,
	0x32ab: 0x0004, 0x32ac: 0x0004, 0x32ad: 0x0004, 0x32ae: 0x0004, 0x32af: 0x0004,
	0x32b0: 0x0004, 0x32b1: 0x0004, 0x32b2: 0x0004, 0x32b3: 0x0004, 0x32b4: 0x0004, 0x32b5: 0x0004,
	0x32b6: 0x0004,
	// Block 0xcb, offset 0x32c0
	0x32c0: 0x0005, 0x32c1: 0x0005, 0x32c2: 0x0005, 0x32c3: 0x0005, 0x32c4: 0x0005, 0x32c5: 0x0005,
	0x32c6: 0x0005, 0x32c7: 0x0005, 0x32c8: 0x0005, 0x32c9: 0x0005, 0x32ca: 0x0005, 0x32cb: 0x0005,
	0x32cc: 0x0005, 0x32cd: 0x0005, 0x32ce: 0x0005, 0x32cf: 0x0005, 0x32d0: 0x0005, 0x32d1: 0x0005,
	0x32d2: 0x0005, 0x32d3: 0x0005, 0x32d4: 0x0005, 0x32d5: 0x0005, 0x32d6: 0x0005, 0x32d7: 0x0005,
	0x32d8: 0x0005, 0x32d9: 0x0005, 0x32da: 0x0005, 0x32db: 0x0005, 0x32dc: 0x0005, 0x32dd: 0x0005,
	0x32de: 0x0005, 0x32df: 0x0005, 0x32e0: 0x0005, 0x32e1: 0x0005, 0x32e2: 0x0005, 0x32e3: 0x0005,
	0x32e4: 0x0005, 0x32e5: 0x0005, 0x32e6: 0x0005, 0x32e7: 0x0005, 0x32e8: 0x0005, 0x32e9: 0x0005,
	0x32ea: 0x0005, 0x32eb: 0x0005, 0x32ec: 0x0005, 0x32ed: 0x0005, 0x32ee: 0x0005, 0x32ef: 0x0005,
	0x32f0: 0x0005, 0x32f1: 0x0005, 0x32f2: 0x0005, 0x32f3: 0x0005, 0x32f4: 0x0005, 0x32f5: 0x0005,
	0x32f9: 0x0004, 0x32fa: 0x0004, 0x32fb: 0x0004,
	0x32fc: 0x0004, 0x32fd: 0x0004, 0x32fe: 0x0004, 0x32ff: 0x0004,
	// Block 0xcc, offset 0x3300
	0x3300: 0x0005, 0x3301: 0x0005, 0x3302: 0x0005, 0x3303: 0x0005, 0x3304: 0x0005, 0x3305: 0x0005,
	0x3306: 0x0005, 0x3307: 0x0005, 0x3308: 0x0005, 0x3309: 0x0005, 0x330a: 0x0005, 0x330b: 0x0005,
	0x330c: 0x0005, 0x330d: 0x0005, 0x330e: 0x0005, 0x330f: 0x0005, 0x3310: 0x0005, 0x3311: 0x0005,
	0x3312: 0x0005, 0x3313: 0x0005, 0x3314: 0x0005, 0x3315: 0x0005,
	0x3318: 0x0004, 0x3319: 0x0004, 0x331a: 0x0004, 0x331b: 0x0004, 0x331c: 0x0004, 0x331d: 0x0004,
	0x331e: 0x0004, 0x331f: 0x0004, 0x3320: 0x0005, 0x3321: 0x0005, 0x3322: 0x0005, 0x3323: 0x0005,
	0x3324: 0x0005, 0x3325: 0x0005, 0x3326: 0x0005, 0x3327: 0x0005, 0x3328: 0x0005, 0x3329: 0x0005,
	0x332a: 0x0005, 0x332b: 0x0005, 0x332c: 0x0005, 0x332d: 0x0005, 0x332e: 0x0005, 0x332f: 0x0005,
	0x3330: 0x0005, 0x3331: 0x0005, 0x3332: 0x0005,
	0x3338: 0x0004, 0x3339: 0x0004, 0x333a: 0x0004, 0x333b: 0x0004,
	0x333c: 0x0004, 0x333d: 0x0004, 0x333e: 0x0004, 0x333f: 0x0004,
	// Block 0xcd, offset 0x3340
	0x3340: 0x0005, 0x3341: 0x0005, 0x3342: 0x0005, 0x3343: 0x0005, 0x3344: 0x0005, 0x3345: 0x0005,
	0x3346: 0x0005, 0x3347: 0x0005, 0x3348: 0x0005, 0x3349: 0x0005, 0x334a: 0x0005, 0x334b: 0x0005,
	0x334c: 0x0005, 0x334d: 0x0005, 0x334e: 0x0005, 0x334f: 0x0005, 0x3350: 0x0005, 0x3351: 0x0005,
	0x3359: 0x0004, 0x335a: 0x0004, 0x335b: 0x0004, 0x335c: 0x0004,
	0x3369: 0x0004,
	0x336a: 0x0004, 0x336b: 0x0004, 0x336c: 0x0004, 0x336d: 0x0004, 0x336e: 0x0004, 0x336f: 0x0004,
	// Block 0xce, offset 0x3380
	0x3380: 0x0005, 0x3381: 0x0005, 0x3382: 0x0005, 0x3383: 0x0005, 0x3384: 0x0005, 0x3385: 0x0005,
	0x3386: 0x0005, 0x3387: 0x0005, 0x3388: 0x0005,
	// Block 0xcf, offset 0x33c0
	0x33c0: 0x0005, 0x33c1: 0x0005, 0x33c2: 0x0005, 0x33c3: 0x0005, 0x33c4: 0x0005, 0x33c5: 0x0005,
	0x33c6: 0x0005, 0x33c7: 0x0005, 0x33c8: 0x0005, 0x33c9: 0x0005, 0x33ca: 0x0005, 0x33cb: 0x0005,
	0x33cc: 0x0005, 0x33cd: 0x0005, 0x33ce: 0x0005, 0x33cf: 0x0005, 0x33d0: 0x0005, 0x33d1: 0x0005,
	0x33d2: 0x0005, 0x33d3: 0x0005, 0x33d4: 0x0005, 0x33d5: 0x0005, 0x33d6: 0x0005, 0x33d7: 0x0005,
	0x33d8: 0x0005, 0x33d9: 0x0005, 0x33da: 0x0005, 0x33db: 0x0005, 0x33dc: 0x0005, 0x33dd: 0x0005,
	0x33de: 0x0005, 0x33df: 0x0005, 0x33e0: 0x0005, 0x33e1: 0x0005, 0x33e2: 0x0005, 0x33e3: 0x0005,
	0x33e4: 0x0005, 0x33e5: 0x0005, 0x33e6: 0x0005, 0x33e7: 0x0005, 0x33e8: 0x0005, 0x33e9: 0x0005,
	0x33ea: 0x0005, 0x33eb: 0x0005, 0x33ec: 0x0005, 0x33ed: 0x0005, 0x33ee: 0x0005, 0x33ef: 0x0005,
	0x33f0: 0x0005, 0x33f1: 0x0005, 0x33f2: 0x0005,
	// Block 0xd0, offset 0x3400
	0x3400: 0x0005, 0x3401: 0x0005, 0x3402: 0x0005, 0x3403: 0x0005, 0x3404: 0x0005, 0x3405: 0x0005,
	0x3406: 0x0005, 0x3407: 0x0005, 0x3408: 0x0005, 0x3409: 0x0005, 0x340a: 0x0005, 0x340b: 0x0005,
	0x340c: 0x0005, 0x340d: 0x0005, 0x340e: 0x0005, 0x340f: 0x0005, 0x3410: 0x0005, 0x3411: 0x0005,
	0x3412: 0x0005, 0x3413: 0x0005, 0x3414: 0x0005, 0x3415: 0x0005, 0x3416: 0x0005, 0x3417: 0x0005,
	0x3418: 0x0005, 0x3419: 0x0005, 0x341a: 0x0005, 0x341b: 0x0005, 0x341c: 0x0005, 0x341d: 0x0005,
	0x341e: 0x0005, 0x341f: 0x0005, 0x3420: 0x0005, 0x3421: 0x0005, 0x3422: 0x0005, 0x3423: 0x0005,
	0x3424: 0x0005, 0x3425: 0x0005, 0x3426: 0x0005, 0x3427: 0x0005, 0x3428: 0x0005, 0x3429: 0x0005,
	0x342a: 0x0005, 0x342b: 0x0005, 0x342c: 0x0005, 0x342d: 0x0005, 0x342e: 0x0005, 0x342f: 0x0005,
	0x3430: 0x0005, 0x3431: 0x0005, 0x3432: 0x0005,
	0x343a: 0x0004, 0x343b: 0x0004,
	0x343c: 0x0004, 0x343d: 0x0004, 0x343e: 0x0004, 0x343f: 0x0004,
	// Block 0xd1, offset 0x3440
	0x3460: 0x0004, 0x3461: 0x0004, 0x3462: 0x0004, 0x3463: 0x0004,
	0x3464: 0x0004, 0x3465: 0x0004, 0x3466: 0x0004, 0x3467: 0x0004, 0x3468: 0x0004, 0x3469: 0x0004,
	0x346a: 0x0004, 0x346b: 0x0004, 0x346c: 0x0004, 0x346d: 0x0004, 0x346e: 0x0004, 0x346f: 0x0004,
	0x3470: 0x0004, 0x3471: 0x0004, 0x3472: 0x0004, 0x3473: 0x0004, 0x3474: 0x0004, 0x3475: 0x0004,
	0x3476: 0x0004, 0x3477: 0x0004, 0x3478: 0x0004, 0x3479: 0x0004, 0x347a: 0x0004, 0x347b: 0x0004,
	0x347c: 0x0004, 0x347d: 0x0004, 0x347e: 0x0004,
	// Block 0xd2, offset 0x3480
	0x3480: 0x0005, 0x3481: 0x0005, 0x3482: 0x0005, 0x3483: 0x0005, 0x3484: 0x0005, 0x3485: 0x0005,
	0x3486: 0x0005, 0x3487: 0x0004, 0x3488: 0x0004, 0x3489: 0x0004, 0x348a: 0x0004, 0x348b: 0x0004,
	0x348c: 0x0004, 0x348d: 0x0004,
	0x3492: 0x0004, 0x3493: 0x0004, 0x3494: 0x0004, 0x3495: 0x0004, 0x3496: 0x0004, 0x3497: 0x0004,
	0x3498: 0x0004, 0x3499: 0x0004, 0x349a: 0x0004, 0x349b: 0x0004, 0x349c: 0x0004, 0x349d: 0x0004,
	0x349e: 0x0004, 0x349f: 0x0004, 0x34a0: 0x0004, 0x34a1: 0x0004, 0x34a2: 0x0004, 0x34a3: 0x0004,
	0x34a4: 0x0004, 0x34a5: 0x0004, 0x34a6: 0x0005, 0x34a7: 0x0005, 0x34a8: 0x0005, 0x34a9: 0x0005,
	0x34aa: 0x0005, 0x34ab: 0x0005, 0x34ac: 0x0005, 0x34ad: 0x0005, 0x34ae: 0x0005, 0x34af: 0x0005,
	0x34bf: 0x0005,
	// Block 0xd3, offset 0x34c0
	0x34c0: 0x0005, 0x34c1: 0x0005, 0x34c2: 0x0005, 0x34c3: 0x0005, 0x34c4: 0x0005, 0x34c5: 0x0005,
	0x34c6: 0x0005, 0x34c7: 0x0005, 0x34c8: 0x0005, 0x34c9: 0x0005, 0x34ca: 0x0005, 0x34cb: 0x0005,
	0x34cc: 0x0005, 0x34cd: 0x0005, 0x34ce: 0x0005, 0x34cf: 0x0005, 0x34d0: 0x0005, 0x34d1: 0x0005,
	0x34d2: 0x0005, 0x34d3: 0x0005, 0x34d4: 0x0005, 0x34d5: 0x0005, 0x34d6: 0x0005, 0x34d7: 0x0005,
	0x34d8: 0x0005, 0x34d9: 0x0005, 0x34da: 0x0005, 0x34db: 0x0005, 0x34dc: 0x0005, 0x34dd: 0x0005,
	0x34de: 0x0005, 0x34df: 0x0005, 0x34e0: 0x0005, 0x34e1: 0x0005, 0x34e2: 0x0005, 0x34e3: 0x0005,
	0x34e4: 0x0005, 0x34e5: 0x0005, 0x34e6: 0x0005, 0x34e7: 0x0005, 0x34e8: 0x0005, 0x34e9: 0x0005,
	0x34ea: 0x0005, 0x34eb: 0x0005, 0x34ec: 0x0005, 0x34ed: 0x0005, 0x34ee: 0x0005, 0x34ef: 0x0005,
	0x34f0: 0x0005, 0x34f1: 0x0005, 0x34f2: 0x0005, 0x34f3: 0x0005, 0x34f4: 0x0005, 0x34f5: 0x0005,
	0x34f6: 0x0005, 0x34f7: 0x0005, 0x34f8: 0x0005, 0x34f9: 0x0005, 0x34fa: 0x0005, 0x34fb: 0x0004,
	0x34fc: 0x0004, 0x34fd: 0x0001, 0x34fe: 0x0004, 0x34ff: 0x0004,
	// Block 0xd4, offset 0x3500
	0x3500: 0x0004, 0x3501: 0x0004,
	0x3510: 0x0005, 0x3511: 0x0005,
	0x3512: 0x0005, 0x3513: 0x0005, 0x3514: 0x0005, 0x3515: 0x0005, 0x3516: 0x0005, 0x3517: 0x0005,
	0x3518: 0x0005, 0x3519: 0x0005, 0x351a: 0x0005, 0x351b: 0x0005, 0x351c: 0x0005, 0x351d: 0x0005,
	0x351e: 0x0005, 0x351f: 0x0005, 0x3520: 0x0005, 0x3521: 0x0005, 0x3522: 0x0005, 0x3523: 0x0005,
	0x3524: 0x0005, 0x3525: 0x0005, 0x3526: 0x0005, 0x3527: 0x0005, 0x3528: 0x0005,
	0x3530: 0x0005, 0x3531: 0x0005, 0x3532: 0x0005, 0x3533: 0x0005, 0x3534: 0x0005, 0x3535: 0x0005,
	0x3536: 0x0005, 0x3537: 0x0005, 0x3538: 0x0005, 0x3539: 0x0005,
	// Block 0xd5, offset 0x3540
	0x3540: 0x0005, 0x3541: 0x0005, 0x3542: 0x0005, 0x3543: 0x0005, 0x3544: 0x0005, 0x3545: 0x0005,
	0x3546: 0x0005, 0x3547: 0x0005, 0x3548: 0x0005, 0x3549: 0x0005, 0x354a: 0x0005, 0x354b: 0x0005,
	0x354c: 0x0005, 0x354d: 0x0005, 0x354e: 0x0005, 0x354f: 0x0005, 0x3550: 0x0005, 0x3551: 0x0005,
	0x3552: 0x0005, 0x3553: 0x0005, 0x3554: 0x0005, 0x3555: 0x0005, 0x3556: 0x0005, 0x3557: 0x0005,
	0x3558: 0x0005, 0x3559: 0x0005, 0x355a: 0x0005, 0x355b: 0x0005, 0x355c: 0x0005, 0x355d: 0x0005,
	0x355e: 0x0005, 0x355f: 0x0005, 0x3560: 0x0005, 0x3561: 0x0005, 0x3562: 0x0005, 0x3563: 0x0005,
	0x3564: 0x0005, 0x3565: 0x0005, 0x3566: 0x0005, 0x3567: 0x0005, 0x3568: 0x0005, 0x3569: 0x0005,
	0x356a: 0x0005, 0x356b: 0x0005, 0x356c: 0x0005, 0x356d: 0x0005, 0x356e: 0x0005, 0x356f: 0x0005,
	0x3570: 0x0005, 0x3571: 0x0005, 0x3572: 0x0005, 0x3573: 0x0005, 0x3574: 0x0005,
	0x3576: 0x0005, 0x3577: 0x0005, 0x3578: 0x0005, 0x3579: 0x0005, 0x357a: 0x0005, 0x357b: 0x0005,
	0x357c: 0x0005, 0x357d: 0x0005, 0x357e: 0x0005, 0x357f: 0x0005,
	// Block 0xd6, offset 0x3580
	0x3580: 0x0004, 0x3581: 0x0004, 0x3582: 0x0004, 0x3583: 0x0004,
	0x3590: 0x0005, 0x3591: 0x0005,
	0x3592: 0x0005, 0x3593: 0x0005, 0x3594: 0x0005, 0x3595: 0x0005, 0x3596: 0x0005, 0x3597: 0x0005,
	0x3598: 0x0005, 0x3599: 0x0005, 0x359a: 0x0005, 0x359b: 0x0005, 0x359c: 0x0005, 0x359d: 0x0005,
	0x359e: 0x0005, 0x359f: 0x0005, 0x35a0: 0x0005, 0x35a1: 0x0005, 0x35a2: 0x0005, 0x35a3: 0x0005,
	0x35a4: 0x0005, 0x35a5: 0x0005, 0x35a6: 0x0005, 0x35a7: 0x0005, 0x35a8: 0x0005, 0x35a9: 0x0005,
	0x35aa: 0x0005, 0x35ab: 0x0005, 0x35ac: 0x0005, 0x35ad: 0x0005, 0x35ae: 0x0005, 0x35af: 0x0005,
	0x35b0: 0x0005, 0x35b1: 0x0005, 0x35b2: 0x0005, 0x35b3: 0x0005, 0x35b4: 0x0004, 0x35b5: 0x0004,
	0x35b6: 0x0005,
	// Block 0xd7, offset 0x35c0
	0x35c0: 0x0005, 0x35c1: 0x0005, 0x35c2: 0x0005, 0x35c3: 0x0005, 0x35c4: 0x0005, 0x35c5: 0x0004,
	0x35c6: 0x0004, 0x35c7: 0x0004, 0x35c8: 0x0004, 0x35c9: 0x0004, 0x35ca: 0x0005, 0x35cb: 0x0005,
	0x35cc: 0x0005, 0x35cd: 0x0004, 0x35d0: 0x0005, 0x35d1: 0x0005,
	0x35d2: 0x0005, 0x35d3: 0x0005, 0x35d4: 0x0005, 0x35d5: 0x0005, 0x35d6: 0x0005, 0x35d7: 0x0005,
	0x35d8: 0x0005, 0x35d9: 0x0005, 0x35da: 0x0005, 0x35db: 0x0004, 0x35dc: 0x0005, 0x35dd: 0x0004,
	0x35de: 0x0004, 0x35df: 0x0004, 0x35e1: 0x0004, 0x35e2: 0x0004, 0x35e3: 0x0004,
	0x35e4: 0x0004, 0x35e5: 0x0004, 0x35e6: 0x0004, 0x35e7: 0x0004, 0x35e8: 0x0004, 0x35e9: 0x0004,
	0x35ea: 0x0004, 0x35eb: 0x0004, 0x35ec: 0x0004, 0x35ed: 0x0004, 0x35ee: 0x0004, 0x35ef: 0x0004,
	0x35f0: 0x0004, 0x35f1: 0x0004, 0x35f2: 0x0004, 0x35f3: 0x0004, 0x35f4: 0x0004,
	// Block 0xd8, offset 0x3600
	0x3600: 0x0005, 0x3601: 0x0005, 0x3602: 0x0005, 0x3603: 0x0005, 0x3604: 0x0005, 0x3605: 0x0005,
	0x3606: 0x0005, 0x3607: 0x0005, 0x3608: 0x0005, 0x3609: 0x0005, 0x360a: 0x0005, 0x360b: 0x0005,
	0x360c: 0x0005, 0x360d: 0x0005, 0x360e: 0x0005, 0x360f: 0x0005, 0x3610: 0x0005, 0x3611: 0x0005,
	0x3613: 0x0005, 0x3614: 0x0005, 0x3615: 0x0005, 0x3616: 0x0005, 0x3617: 0x0005,
	0x3618: 0x0005, 0x3619: 0x0005, 0x361a: 0x0005, 0x361b: 0x0005, 0x361c: 0x0005, 0x361d: 0x0005,
	0x361e: 0x0005, 0x361f: 0x0005, 0x3620: 0x0005, 0x3621: 0x0005, 0x3622: 0x0005, 0x3623: 0x0005,
	0x3624: 0x0005, 0x3625: 0x0005, 0x3626: 0x0005, 0x3627: 0x0005, 0x3628: 0x0005, 0x3629: 0x0005,
	0x362a: 0x0005, 0x362b: 0x0005, 0x362c: 0x0005, 0x362d: 0x0005, 0x362e: 0x0005, 0x362f: 0x0005,
	0x3630: 0x0005, 0x3631: 0x0005, 0x3632: 0x0005, 0x3633: 0x0005, 0x3634: 0x0005, 0x3635: 0x0005,
	0x3636: 0x0005, 0x3637: 0x0005, 0x3638: 0x0004, 0x3639: 0x0004, 0x363a: 0x0004, 0x363b: 0x0004,
	0x363c: 0x0004, 0x363d: 0x0004,
	// Block 0xd9, offset 0x3640
	0x3640: 0x0005, 0x3641: 0x0005, 0x3642: 0x0005, 0x3643: 0x0005, 0x3644: 0x0005, 0x3645: 0x0005,
	0x3646: 0x0005, 0x3648: 0x0005, 0x364a: 0x0005, 0x364b: 0x0005,
	0x364c: 0x0005, 0x364d: 0x0005, 0x364f: 0x0005, 0x3650: 0x0005, 0x3651: 0x0005,
	0x3652: 0x0005, 0x3653: 0x0005, 0x3654: 0x0005, 0x3655: 0x0005, 0x3656: 0x0005, 0x3657: 0x0005,
	0x3658: 0x0005, 0x3659: 0x0005, 0x365a: 0x0005, 0x365b: 0x0005, 0x365c: 0x0005, 0x365d: 0x0005,
	0x365f: 0x0005, 0x3660: 0x0005, 0x3661: 0x0005, 0x3662: 0x0005, 0x3663: 0x0005,
	0x3664: 0x0005, 0x3665: 0x0005, 0x3666: 0x0005, 0x3667: 0x0005, 0x3668: 0x0005, 0x3669: 0x0004,
	0x3670: 0x0005, 0x3671: 0x0005, 0x3672: 0x0005, 0x3673: 0x0005, 0x3674: 0x0005, 0x3675: 0x0005,
	0x3676: 0x0005, 0x3677: 0x0005, 0x3678: 0x0005, 0x3679: 0x0005, 0x367a: 0x0005, 0x367b: 0x0005,
	0x367c: 0x0005, 0x367d: 0x0005, 0x367e: 0x0005, 0x367f: 0x0005,
	// Block 0xda, offset 0x3680
	0x3680: 0x0005, 0x3681: 0x0005, 0x3682: 0x0005, 0x3683: 0x0005, 0x3684: 0x0005, 0x3685: 0x0005,
	0x3686: 0x0005, 0x3687: 0x0005, 0x3688: 0x0005, 0x3689: 0x0005, 0x368a: 0x0005, 0x368b: 0x0005,
	0x368c: 0x0005, 0x368d: 0x0005, 0x368e: 0x0005, 0x368f: 0x0005, 0x3690: 0x0005, 0x3691: 0x0005,
	0x3692: 0x0005, 0x3693: 0x0005, 0x3694: 0x0005, 0x3695: 0x0005, 0x3696: 0x0005, 0x3697: 0x0005,
	0x3698: 0x0005, 0x3699: 0x0005, 0x369a: 0x0005, 0x369b: 0x0005, 0x369c: 0x0005, 0x369d: 0x0005,
	0x369e: 0x0005, 0x369f: 0x0005, 0x36a0: 0x0005, 0x36a1: 0x0005, 0x36a2: 0x0005, 0x36a3: 0x0005,
	0x36a4: 0x0005, 0x36a5: 0x0005, 0x36a6: 0x0005, 0x36a7: 0x0005, 0x36a8: 0x0005, 0x36a9: 0x0005,
	0x36aa: 0x0005,
	0x36b0: 0x0005, 0x36b1: 0x0005, 0x36b2: 0x0005, 0x36b3: 0x0005, 0x36b4: 0x0005, 0x36b5: 0x0005,
	0x36b6: 0x0005, 0x36b7: 0x0005, 0x36b8: 0x0005, 0x36b9: 0x0005,
	// Block 0xdb, offset 0x36c0
	0x36c0: 0x0005, 0x36c1: 0x0005, 0x36c2: 0x0005, 0x36c3: 0x0005, 0x36c5: 0x0005,
	0x36c6: 0x0005, 0x36c7: 0x0005, 0x36c8: 0x0005, 0x36c9: 0x0005, 0x36ca: 0x0005, 0x36cb: 0x0005,
	0x36cc: 0x0005, 0x36cf: 0x0005, 0x36d0: 0x0005,
	0x36d3: 0x0005, 0x36d4: 0x0005, 0x36d5: 0x0005, 0x36d6: 0x0005, 0x36d7: 0x0005,
	0x36d8: 0x0005, 0x36d9: 0x0005, 0x36da: 0x0005, 0x36db: 0x0005, 0x36dc: 0x0005, 0x36dd: 0x0005,
	0x36de: 0x0005, 0x36df: 0x0005, 0x36e0: 0x0005, 0x36e1: 0x0005, 0x36e2: 0x0005, 0x36e3: 0x0005,
	0x36e4: 0x0005, 0x36e5: 0x0005, 0x36e6: 0x0005, 0x36e7: 0x0005, 0x36e8: 0x0005,
	0x36ea: 0x0005, 0x36eb: 0x0005, 0x36ec: 0x0005, 0x36ed: 0x0005, 0x36ee: 0x0005, 0x36ef: 0x0005,
	0x36f0: 0x0005, 0x36f2: 0x0005, 0x36f3: 0x0005, 0x36f5: 0x0005,
	0x36f6: 0x0005, 0x36f7: 0x0005, 0x36f8: 0x0005, 0x36f9: 0x0005,
	0x36fc: 0x0005, 0x36fd: 0x0005, 0x36fe: 0x0005, 0x36ff: 0x0005,
	// Block 0xdc, offset 0x3700
	0x3700: 0x0005, 0x3701: 0x0005, 0x3702: 0x0005, 0x3703: 0x0005, 0x3704: 0x0005,
	0x3707: 0x0005, 0x3708: 0x0005, 0x370b: 0x0005,
	0x370c: 0x0005, 0x370d: 0x0005, 0x3710: 0x0005,
	0x3717: 0x0005,
	0x371d: 0x0005,
	0x371e: 0x0005, 0x371f: 0x0005, 0x3720: 0x0005, 0x3721: 0x0005, 0x3722: 0x0005, 0x3723: 0x0005,
	0x3726: 0x0005, 0x3727: 0x0005, 0x3728: 0x0005, 0x3729: 0x0005,
	0x372a: 0x0005, 0x372b: 0x0005, 0x372c: 0x0005,
	0x3730: 0x0005, 0x3731: 0x0005, 0x3732: 0x0005, 0x3733: 0x0005, 0x3734: 0x0005,
	// Block 0xdd, offset 0x3740
	0x3740: 0x0005, 0x3741: 0x0005, 0x3742: 0x0005, 0x3743: 0x0005, 0x3744: 0x0005, 0x3745: 0x0005,
	0x3746: 0x0004, 0x3747: 0x0005,
	0x3750: 0x0005, 0x3751: 0x0005,
	0x3752: 0x0005, 0x3753: 0x0005, 0x3754: 0x0005, 0x3755: 0x0005, 0x3756: 0x0005, 0x3757: 0x0005,
	0x3758: 0x0005, 0x3759: 0x0005,
	// Block 0xde, offset 0x3780
	0x3780: 0x0005, 0x3781: 0x0005, 0x3782: 0x0005, 0x3783: 0x0005, 0x3784: 0x0005, 0x3785: 0x0005,
	0x3786: 0x0005, 0x3787: 0x0005, 0x3788: 0x0005, 0x3789: 0x0005, 0x378a: 0x0005, 0x378b: 0x0005,
	0x378c: 0x0005, 0x378d: 0x0005, 0x378e: 0x0005, 0x378f: 0x0005, 0x3790: 0x0005, 0x3791: 0x0005,
	0x3792: 0x0005, 0x3793: 0x0005, 0x3794: 0x0005, 0x3795: 0x0005, 0x3796: 0x0005, 0x3797: 0x0005,
	0x3798: 0x0005, 0x3799: 0x0005, 0x379a: 0x0005, 0x379b: 0x0005, 0x379c: 0x0005, 0x379d: 0x0005,
	0x379e: 0x0005, 0x379f: 0x0005, 0x37a0: 0x0005, 0x37a1: 0x0005, 0x37a2: 0x0005, 0x37a3: 0x0005,
	0x37a4: 0x0005, 0x37a5: 0x0005, 0x37a6: 0x0005, 0x37a7: 0x0005, 0x37a8: 0x0005, 0x37a9: 0x0005,
	0x37aa: 0x0005, 0x37ab: 0x0005, 0x37ac: 0x0005, 0x37ad: 0x0005, 0x37ae: 0x0005, 0x37af: 0x0005,
	0x37b0: 0x0005, 0x37b1: 0x0005, 0x37b2: 0x0005, 0x37b3: 0x0005, 0x37b4: 0x0005, 0x37b5: 0x0005,
	0x37b8: 0x0005, 0x37b9: 0x0005, 0x37ba: 0x0005, 0x37bb: 0x0005,
	0x37bc: 0x0005, 0x37bd: 0x0005, 0x37be: 0x0005, 0x37bf: 0x0005,
	// Block 0xdf, offset 0x37c0
	0x37c0: 0x0005, 0x37c1: 0x0004, 0x37c2: 0x0004, 0x37c3: 0x0004, 0x37c4: 0x0004, 0x37c5: 0x0004,
	0x37c6: 0x0004, 0x37c7: 0x0004, 0x37c8: 0x0004, 0x37c9: 0x0004, 0x37ca: 0x0004, 0x37cb: 0x0004,
	0x37cc: 0x0004, 0x37cd: 0x0004, 0x37ce: 0x0004, 0x37cf: 0x0004, 0x37d0: 0x0004, 0x37d1: 0x0004,
	0x37d2: 0x0004, 0x37d3: 0x0004, 0x37d4: 0x0004, 0x37d5: 0x0004, 0x37d6: 0x0004, 0x37d7: 0x0004,
	0x37d8: 0x0005, 0x37d9: 0x0005, 0x37da: 0x0005, 0x37db: 0x0005, 0x37dc: 0x0005, 0x37dd: 0x0005,
	// Block 0xe0, offset 0x3800
	0x3800: 0x0005, 0x3801: 0x0004, 0x3802: 0x0004, 0x3803: 0x0004, 0x3804: 0x0005,
	0x3810: 0x0005, 0x3811: 0x0005,
	0x3812: 0x0005, 0x3813: 0x0005, 0x3814: 0x0005, 0x3815: 0x0005, 0x3816: 0x0005, 0x3817: 0x0005,
	0x3818: 0x0005, 0x3819: 0x0005,
	// Block 0xe1, offset 0x3840
	0x3840: 0x0005, 0x3841: 0x0005, 0x3842: 0x0005, 0x3843: 0x0005, 0x3844: 0x0005, 0x3845: 0x0005,
	0x3846: 0x0005, 0x3847: 0x0005, 0x3848: 0x0005, 0x3849: 0x0005,
	// Block 0xe2, offset 0x3880
	0x3880: 0x0005, 0x3881: 0x0005, 0x3882: 0x0005, 0x3883: 0x0005, 0x3884: 0x0005, 0x3885: 0x0005,
	0x3886: 0x0005, 0x3887: 0x0005, 0x3888: 0x0005, 0x3889: 0x0005, 0x388a: 0x0005, 0x388b: 0x0005,
	0x388c: 0x0005, 0x388d: 0x0005, 0x388e: 0x0005, 0x388f: 0x0005, 0x3890: 0x0005, 0x3891: 0x0005,
	0x3892: 0x0005, 0x3893: 0x0005, 0x3894: 0x0005, 0x3895: 0x0005, 0x3896: 0x0005, 0x3897: 0x0005,
	0x3898: 0x0005, 0x3899: 0x0005, 0x389d: 0x0005,
	0x389e: 0x0005, 0x389f: 0x0005, 0x38a0: 0x0005, 0x38a1: 0x0005, 0x38a2: 0x0005, 0x38a3: 0x0005,
	0x38a4: 0x0005, 0x38a5: 0x0005, 0x38a6: 0x0005, 0x38a7: 0x0005, 0x38a8: 0x0005, 0x38a9: 0x0005,
	0x38aa: 0x0005, 0x38ab: 0x0005,
	0x38b0: 0x0005, 0x38b1: 0x0005, 0x38b2: 0x0005, 0x38b3: 0x0005, 0x38b4: 0x0005, 0x38b5: 0x0005,
	0x38b6: 0x0005, 0x38b7: 0x0005, 0x38b8: 0x0005, 0x38b9: 0x0005, 0x38ba: 0x0004, 0x38bb: 0x0004,
	0x38bc: 0x0004, 0x38bd: 0x0004, 0x38be: 0x0004, 0x38bf: 0x0004,
	// Block 0xe3, offset 0x38c0
	0x38e0: 0x0005, 0x38e1: 0x0005, 0x38e2: 0x0005, 0x38e3: 0x0005,
	0x38e4: 0x0005, 0x38e5: 0x0005, 0x38e6: 0x0005, 0x38e7: 0x0005, 0x38e8: 0x0005, 0x38e9: 0x0005,
	0x38ea: 0x0005, 0x38eb: 0x0005, 0x38ec: 0x0005, 0x38ed: 0x0005, 0x38ee: 0x0005, 0x38ef: 0x0005,
	0x38f0: 0x0005, 0x38f1: 0x0005, 0x38f2: 0x0005, 0x38f3: 0x0005, 0x38f4: 0x0005, 0x38f5: 0x0005,
	0x38f6: 0x0005, 0x38f7: 0x0005, 0x38f8: 0x0005, 0x38f9: 0x0005, 0x38fa: 0x0005, 0x38fb: 0x0005,
	0x38fc: 0x0005, 0x38fd: 0x0005, 0x38fe: 0x0005, 0x38ff: 0x0005,
	// Block 0xe4, offset 0x3900
	0x3900: 0x0005, 0x3901: 0x0005, 0x3902: 0x0005, 0x3903: 0x0005, 0x3904: 0x0005, 0x3905: 0x0005,
	0x3906: 0x0005, 0x3907: 0x0005, 0x3908: 0x0005, 0x3909: 0x0005, 0x390a: 0x0005, 0x390b: 0x0005,
	0x390c: 0x0005, 0x390d: 0x0005, 0x390e: 0x0005, 0x390f: 0x0005, 0x3910: 0x0005, 0x3911: 0x0005,
	0x3912: 0x0005, 0x3913: 0x0005, 0x3914: 0x0005, 0x3915: 0x0005, 0x3916: 0x0005, 0x3917: 0x0005,
	0x3918: 0x0005, 0x3919: 0x0005, 0x391a: 0x0005, 0x391b: 0x0005, 0x391c: 0x0005, 0x391d: 0x0005,
	0x391e: 0x0005, 0x391f: 0x0005, 0x3920: 0x0005, 0x3921: 0x0005, 0x3922: 0x0005, 0x3923: 0x0005,
	0x3924: 0x0005, 0x3925: 0x0005, 0x3926: 0x0005, 0x3927: 0x0005, 0x3928: 0x0005, 0x3929: 0x0005,
	0x392a: 0x0004, 0x392b: 0x0004, 0x392c: 0x0004, 0x392d: 0x0004, 0x392e: 0x0004, 0x392f: 0x0004,
	0x3930: 0x0004, 0x3931: 0x0004, 0x3932: 0x0004,
	0x393f: 0x0005,
	// Block 0xe5, offset 0x3940
	0x3940: 0x0005, 0x3941: 0x0005, 0x3942: 0x0005, 0x3943: 0x0005, 0x3944: 0x0005, 0x3945: 0x0005,
	0x3946: 0x0005, 0x3947: 0x0005, 0x3948: 0x0005, 0x3949: 0x0005, 0x394a: 0x0005, 0x394b: 0x0005,
	0x394c: 0x0005, 0x394d: 0x0005, 0x394e: 0x0005, 0x394f: 0x0005, 0x3950: 0x0005, 0x3951: 0x0005,
	0x3952: 0x0005, 0x3953: 0x0005, 0x3954: 0x0005, 0x3955: 0x0005, 0x3956: 0x0005, 0x3957: 0x0005,
	0x3958: 0x0005, 0x3959: 0x0005, 0x395a: 0x0005, 0x395b: 0x0005, 0x395c: 0x0005, 0x395d: 0x0005,
	0x395e: 0x0005, 0x395f: 0x0005, 0x3960: 0x0005, 0x3961: 0x0005, 0x3962: 0x0005, 0x3963: 0x0005,
	0x3964: 0x0005, 0x3965: 0x0005, 0x3966: 0x0005, 0x3967: 0x0005, 0x3968: 0x0005, 0x3969: 0x0005,
	0x396a: 0x0005, 0x396b: 0x0005, 0x396c: 0x0005, 0x396d: 0x0005, 0x396e: 0x0005, 0x396f: 0x0005,
	0x3970: 0x0005, 0x3971: 0x0005, 0x3972: 0x0005, 0x3973: 0x0005, 0x3974: 0x0005, 0x3975: 0x0005,
	0x3976: 0x0005, 0x3977: 0x0005, 0x3978: 0x0005,
	// Block 0xe6, offset 0x3980
	0x3980: 0x0005, 0x3981: 0x0005, 0x3982: 0x0005, 0x3983: 0x0005, 0x3984: 0x0005, 0x3985: 0x0005,
	0x3986: 0x0005, 0x3987: 0x0005, 0x3988: 0x0005, 0x3989: 0x0005, 0x398a: 0x0005, 0x398b: 0x0005,
	0x398c: 0x0005, 0x398d: 0x0005, 0x398e: 0x0005, 0x398f: 0x0005, 0x3990: 0x0005, 0x3991: 0x0005,
	0x3992: 0x0005, 0x3993: 0x0005, 0x3994: 0x0005, 0x3995: 0x0005, 0x3996: 0x0005, 0x3997: 0x0005,
	0x3998: 0x0005, 0x3999: 0x0005,
	// Block 0xe7, offset 0x39c0
	0x39c0: 0x0004, 0x39c1: 0x0004, 0x39c2: 0x0004, 0x39c3: 0x0004, 0x39c4: 0x0004, 0x39c5: 0x0004,
	0x39c6: 0x0004, 0x39c7: 0x0004, 0x39c8: 0x0004, 0x39c9: 0x0004, 0x39ca: 0x0004, 0x39cb: 0x0004,
	0x39cc: 0x0004, 0x39cd: 0x0004, 0x39ce: 0x0004, 0x39cf: 0x0004, 0x39d0: 0x0004, 0x39d1: 0x0004,
	0x39d2: 0x0004, 0x39d3: 0x0004, 0x39d4: 0x0004, 0x39d5: 0x0004, 0x39d6: 0x0004, 0x39d7: 0x0004,
	0x39d8: 0x0004, 0x39d9: 0x0004, 0x39da: 0x0004, 0x39db: 0x0004, 0x39dc: 0x0004, 0x39dd: 0x0004,
	0x39de: 0x0004, 0x39df: 0x0004, 0x39e0: 0x0004, 0x39e1: 0x0004, 0x39e2: 0x0004, 0x39e3: 0x0004,
	0x39e4: 0x0004, 0x39e5: 0x0004, 0x39e6: 0x0004, 0x39e7: 0x0004, 0x39e8: 0x0004, 0x39e9: 0x0004,
	0x39ea: 0x0004, 0x39eb: 0x0004, 0x39ec: 0x0004, 0x39ed: 0x0004, 0x39ee: 0x0004,
	0x39f0: 0x0004, 0x39f1: 0x0004, 0x39f2: 0x0004, 0x39f3: 0x0004, 0x39f4: 0x0004,
	// Block 0xe8, offset 0x3a00
	0x3a00: 0x0005, 0x3a01: 0x0005, 0x3a02: 0x0005, 0x3a03: 0x0005,
	// Block 0xe9, offset 0x3a40
	0x3a40: 0x0005, 0x3a41: 0x0005, 0x3a42: 0x0005, 0x3a43: 0x0005, 0x3a44: 0x0005, 0x3a45: 0x0005,
	0x3a46: 0x0005, 0x3a47: 0x0005, 0x3a48: 0x0005, 0x3a49: 0x0005, 0x3a4a: 0x0005, 0x3a4b: 0x0005,
	0x3a4c: 0x0005, 0x3a4d: 0x0005, 0x3a4e: 0x0005, 0x3a4f: 0x0005, 0x3a50: 0x0005, 0x3a51: 0x0005,
	0x3a52: 0x0005, 0x3a53: 0x0005, 0x3a54: 0x0005, 0x3a55: 0x0005, 0x3a56: 0x0005, 0x3a57: 0x0005,
	0x3a58: 0x0005, 0x3a59: 0x0005, 0x3a5a: 0x0005, 0x3a5b: 0x0005, 0x3a5c: 0x0005, 0x3a5d: 0x0005,
	0x3a5e: 0x0005, 0x3a5f: 0x0005, 0x3a60: 0x0005, 0x3a61: 0x0005, 0x3a62: 0x0005, 0x3a63: 0x0005,
	0x3a64: 0x0005, 0x3a65: 0x0005, 0x3a66: 0x0005, 0x3a67: 0x0005, 0x3a68: 0x0005, 0x3a69: 0x0005,
	0x3a6a: 0x0005, 0x3a6b: 0x0005, 0x3a6c: 0x0005, 0x3a6d: 0x0005, 0x3a6e: 0x0005,
	// Block 0xea, offset 0x3a80
	0x3a80: 0x0005, 0x3a81: 0x0005, 0x3a82: 0x0005, 0x3a83: 0x0005, 0x3a84: 0x0005, 0x3a85: 0x0005,
	0x3a86: 0x0005,
	// Block 0xeb, offset 0x3ac0
	0x3ac0: 0x0005, 0x3ac1: 0x0005, 0x3ac2: 0x0005, 0x3ac3: 0x0005, 0x3ac4: 0x0005, 0x3ac5: 0x0005,
	0x3ac6: 0x0005, 0x3ac7: 0x0005, 0x3ac8: 0x0005, 0x3ac9: 0x0005, 0x3aca: 0x0005, 0x3acb: 0x0005,
	0x3acc: 0x0005, 0x3acd: 0x0005, 0x3ace: 0x0005, 0x3acf: 0x0005, 0x3ad0: 0x0005, 0x3ad1: 0x0005,
	0x3ad2: 0x0005, 0x3ad3: 0x0005, 0x3ad4: 0x0005, 0x3ad5: 0x0005, 0x3ad6: 0x0005, 0x3ad7: 0x0005,
	0x3ad8: 0x0005, 0x3ad9: 0x0005, 0x3ada: 0x0005, 0x3adb: 0x0005, 0x3adc: 0x0005, 0x3add: 0x0005,
	0x3ade: 0x0005, 0x3ae0: 0x0005, 0x3ae1: 0x0005, 0x3ae2: 0x0005, 0x3ae3: 0x0005,
	0x3ae4: 0x0005, 0x3ae5: 0x0005, 0x3ae6: 0x0005, 0x3ae7: 0x0005, 0x3ae8: 0x0005, 0x3ae9: 0x0005,
	0x3aee: 0x0004, 0x3aef: 0x0004,
	// Block 0xec, offset 0x3b00
	0x3b10: 0x0005, 0x3b11: 0x0005,
	0x3b12: 0x0005, 0x3b13: 0x0005, 0x3b14: 0x0005, 0x3b15: 0x0005, 0x3b16: 0x0005, 0x3b17: 0x0005,
	0x3b18: 0x0005, 0x3b19: 0x0005, 0x3b1a: 0x0005, 0x3b1b: 0x0005, 0x3b1c: 0x0005, 0x3b1d: 0x0005,
	0x3b1e: 0x0005, 0x3b1f: 0x0005, 0x3b20: 0x0005, 0x3b21: 0x0005, 0x3b22: 0x0005, 0x3b23: 0x0005,
	0x3b24: 0x0005, 0x3b25: 0x0005, 0x3b26: 0x0005, 0x3b27: 0x0005, 0x3b28: 0x0005, 0x3b29: 0x0005,
	0x3b2a: 0x0005, 0x3b2b: 0x0005, 0x3b2c: 0x0005, 0x3b2d: 0x0005,
	0x3b30: 0x0005, 0x3b31: 0x0005, 0x3b32: 0x0005, 0x3b33: 0x0005, 0x3b34: 0x0005, 0x3b35: 0x0004,
	// Block 0xed, offset 0x3b40
	0x3b40: 0x0005, 0x3b41: 0x0005, 0x3b42: 0x0005, 0x3b43: 0x0005, 0x3b44: 0x0005, 0x3b45: 0x0005,
	0x3b46: 0x0005, 0x3b47: 0x0005, 0x3b48: 0x0005, 0x3b49: 0x0005, 0x3b4a: 0x0005, 0x3b4b: 0x0005,
	0x3b4c: 0x0005, 0x3b4d: 0x0005, 0x3b4e: 0x0005, 0x3b4f: 0x0005, 0x3b50: 0x0005, 0x3b51: 0x0005,
	0x3b52: 0x0005, 0x3b53: 0x0005, 0x3b54: 0x0005, 0x3b55: 0x0005, 0x3b56: 0x0005, 0x3b57: 0x0005,
	0x3b58: 0x0005, 0x3b59: 0x0005, 0x3b5a: 0x0005, 0x3b5b: 0x0005, 0x3b5c: 0x0005, 0x3b5d: 0x0005,
	0x3b5e: 0x0005, 0x3b5f: 0x0005, 0x3b60: 0x0005, 0x3b61: 0x0005, 0x3b62: 0x0005, 0x3b63: 0x0005,
	0x3b64: 0x0005, 0x3b65: 0x0005, 0x3b66: 0x0005, 0x3b67: 0x0005, 0x3b68: 0x0005, 0x3b69: 0x0005,
	0x3b6a: 0x0005, 0x3b6b: 0x0005, 0x3b6c: 0x0005, 0x3b6d: 0x0005, 0x3b6e: 0x0005, 0x3b6f: 0x0005,
	0x3b70: 0x0005, 0x3b71: 0x0005, 0x3b72: 0x0005, 0x3b73: 0x0005, 0x3b74: 0x0005, 0x3b75: 0x0005,
	0x3b76: 0x0005, 0x3b77: 0x0004, 0x3b78: 0x0004, 0x3b79: 0x0004, 0x3b7a: 0x0004, 0x3b7b: 0x0004,
	0x3b7c: 0x0004, 0x3b7d: 0x0004, 0x3b7e: 0x0004, 0x3b7f: 0x0004,
	// Block 0xee, offset 0x3b80
	0x3b80: 0x0005, 0x3b81: 0x0005, 0x3b82: 0x0005, 0x3b83: 0x0005, 0x3b84: 0x0004, 0x3b85: 0x0004,
	0x3b90: 0x0005, 0x3b91: 0x0005,
	0x3b92: 0x0005, 0x3b93: 0x0005, 0x3b94: 0x0005, 0x3b95: 0x0005, 0x3b96: 0x0005, 0x3b97: 0x0005,
	0x3b98: 0x0005, 0x3b99: 0x0005, 0x3b9b: 0x0004, 0x3b9c: 0x0004, 0x3b9d: 0x0004,
	0x3b9e: 0x0004, 0x3b9f: 0x0004, 0x3ba0: 0x0004, 0x3ba1: 0x0004, 0x3ba3: 0x0005,
	0x3ba4: 0x0005, 0x3ba5: 0x0005, 0x3ba6: 0x0005, 0x3ba7: 0x0005, 0x3ba8: 0x0005, 0x3ba9: 0x0005,
	0x3baa: 0x0005, 0x3bab: 0x0005, 0x3bac: 0x0005, 0x3bad: 0x0005, 0x3bae: 0x0005, 0x3baf: 0x0005,
	0x3bb0: 0x0005, 0x3bb1: 0x0005, 0x3bb2: 0x0005, 0x3bb3: 0x0005, 0x3bb4: 0x0005, 0x3bb5: 0x0005,
	0x3bb6: 0x0005, 0x3bb7: 0x0005,
	0x3bbd: 0x0005, 0x3bbe: 0x0005, 0x3bbf: 0x0005,
	// Block 0xef, offset 0x3bc0
	0x3bc0: 0x0005, 0x3bc1: 0x0005, 0x3bc2: 0x0005, 0x3bc3: 0x0005, 0x3bc4: 0x0005, 0x3bc5: 0x0005,
	0x3bc6: 0x0005, 0x3bc7: 0x0005, 0x3bc8: 0x0005, 0x3bc9: 0x0005, 0x3bca: 0x0005, 0x3bcb: 0x0005,
	0x3bcc: 0x0005, 0x3bcd: 0x0005, 0x3bce: 0x0005, 0x3bcf: 0x0005,
	// Block 0xf0, offset 0x3c00
	0x3c00: 0x0005, 0x3c01: 0x0005, 0x3c02: 0x0005, 0x3c03: 0x0005, 0x3c04: 0x0005,
	0x3c10: 0x0005, 0x3c11: 0x0005,
	0x3c12: 0x0005, 0x3c13: 0x0005, 0x3c14: 0x0005, 0x3c15: 0x0005, 0x3c16: 0x0005, 0x3c17: 0x0005,
	0x3c18: 0x0005, 0x3c19: 0x0005, 0x3c1a: 0x0005, 0x3c1b: 0x0005, 0x3c1c: 0x0005, 0x3c1d: 0x0005,
	0x3c1e: 0x0005, 0x3c1f: 0x0005, 0x3c20: 0x0005, 0x3c21: 0x0005, 0x3c22: 0x0005, 0x3c23: 0x0005,
	0x3c24: 0x0005, 0x3c25: 0x0005, 0x3c26: 0x0005, 0x3c27: 0x0005, 0x3c28: 0x0005, 0x3c29: 0x0005,
	0x3c2a: 0x0005, 0x3c2b: 0x0005, 0x3c2c: 0x0005, 0x3c2d: 0x0005, 0x3c2e: 0x0005, 0x3c2f: 0x0005,
	0x3c30: 0x0005, 0x3c31: 0x0005, 0x3c32: 0x0005, 0x3c33: 0x0005, 0x3c34: 0x0005, 0x3c35: 0x0005,
	0x3c36: 0x0005, 0x3c37: 0x0005, 0x3c38: 0x0005, 0x3c39: 0x0005, 0x3c3a: 0x0005, 0x3c3b: 0x0005,
	0x3c3c: 0x0005, 0x3c3d: 0x0005, 0x3c3e: 0x0005,
	// Block 0xf1, offset 0x3c40
	0x3c4f: 0x0005, 0x3c50: 0x0005, 0x3c51: 0x0005,
	0x3c52: 0x0005, 0x3c53: 0x0005, 0x3c54: 0x0005, 0x3c55: 0x0005, 0x3c56: 0x0005, 0x3c57: 0x0005,
	0x3c58: 0x0005, 0x3c59: 0x0005, 0x3c5a: 0x0005, 0x3c5b: 0x0005, 0x3c5c: 0x0005, 0x3c5d: 0x0005,
	0x3c5e: 0x0005, 0x3c5f: 0x0005,
	// Block 0xf2, offset 0x3c80
	0x3c80: 0x0005, 0x3c81: 0x0005,
	// Block 0xf3, offset 0x3cc0
	0x3cc0: 0x0005, 0x3cc1: 0x0005, 0x3cc2: 0x0005, 0x3cc3: 0x0005, 0x3cc4: 0x0005, 0x3cc5: 0x0005,
	0x3cc6: 0x0005, 0x3cc7: 0x0005, 0x3cc8: 0x0005, 0x3cc9: 0x0005, 0x3cca: 0x0005, 0x3ccb: 0x0005,
	0x3ccc: 0x0005, 0x3ccd: 0x0005, 0x3cce: 0x0005, 0x3ccf: 0x0005, 0x3cd0: 0x0005, 0x3cd1: 0x0005,
	0x3cd2: 0x0005, 0x3cd3: 0x0005, 0x3cd4: 0x0005, 0x3cd5: 0x0005, 0x3cd6: 0x0005, 0x3cd7: 0x0005,
	0x3cd8: 0x0005, 0x3cd9: 0x0005, 0x3cda: 0x0005, 0x3cdb: 0x0005, 0x3cdc: 0x0005, 0x3cdd: 0x0005,
	0x3cde: 0x0005, 0x3cdf: 0x0005, 0x3ce0: 0x0005, 0x3ce1: 0x0005, 0x3ce2: 0x0005, 0x3ce3: 0x0005,
	0x3ce4: 0x0005, 0x3ce5: 0x0005, 0x3ce6: 0x0005, 0x3ce7: 0x0005, 0x3ce8: 0x0005, 0x3ce9: 0x0005,
	0x3cea: 0x0005,
	0x3cf0: 0x0005, 0x3cf1: 0x0005, 0x3cf2: 0x0005, 0x3cf3: 0x0005, 0x3cf4: 0x0005, 0x3cf5: 0x0005,
	0x3cf6: 0x0005, 0x3cf7: 0x0005, 0x3cf8: 0x0005, 0x3cf9: 0x0005, 0x3cfa: 0x0005, 0x3cfb: 0x0005,
	0x3cfc: 0x0005,
	// Block 0xf4, offset 0x3d00
	0x3d00: 0x0005, 0x3d01: 0x0005, 0x3d02: 0x0005, 0x3d03: 0x0005, 0x3d04: 0x0005, 0x3d05: 0x0005,
	0x3d06: 0x0005, 0x3d07: 0x0005, 0x3d08: 0x0005,
	0x3d10: 0x0005, 0x3d11: 0x0005,
	0x3d12: 0x0005, 0x3d13: 0x0005, 0x3d14: 0x0005, 0x3d15: 0x0005, 0x3d16: 0x0005, 0x3d17: 0x0005,
	0x3d18: 0x0005, 0x3d19: 0x0005, 0x3d1c: 0x0004, 0x3d1d: 0x0005,
	0x3d1e: 0x0005, 0x3d1f: 0x0004, 0x3d20: 0x0001, 0x3d21: 0x0001, 0x3d22: 0x0001, 0x3d23: 0x0001,
	// Block 0xf5, offset 0x3d40
	0x3d40: 0x0004, 0x3d41: 0x0004, 0x3d42: 0x0004, 0x3d43: 0x0004, 0x3d44: 0x0004, 0x3d45: 0x0004,
	0x3d46: 0x0004, 0x3d47: 0x0004, 0x3d48: 0x0004, 0x3d49: 0x0004, 0x3d4a: 0x0004, 0x3d4b: 0x0004,
	0x3d4c: 0x0004, 0x3d4d: 0x0004, 0x3d4e: 0x0004, 0x3d4f: 0x0004, 0x3d50: 0x0004, 0x3d51: 0x0004,
	0x3d52: 0x0004, 0x3d53: 0x0004, 0x3d54: 0x0004, 0x3d55: 0x0004, 0x3d56: 0x0004, 0x3d57: 0x0004,
	0x3d58: 0x0004, 0x3d59: 0x0004, 0x3d5a: 0x0004, 0x3d5b: 0x0004, 0x3d5c: 0x0004, 0x3d5d: 0x0004,
	0x3d5e: 0x0004, 0x3d5f: 0x0004, 0x3d60: 0x0004, 0x3d61: 0x0004, 0x3d62: 0x0004, 0x3d63: 0x0004,
	0x3d64: 0x0004, 0x3d65: 0x0004, 0x3d66: 0x0004, 0x3d67: 0x0004, 0x3d68: 0x0004, 0x3d69: 0x0004,
	0x3d6a: 0x0004, 0x3d6b: 0x0004, 0x3d6c: 0x0004, 0x3d6d: 0x0004, 0x3d6e: 0x0004, 0x3d6f: 0x0004,
	0x3d70: 0x0004, 0x3d71: 0x0004, 0x3d72: 0x0004, 0x3d73: 0x0004, 0x3d74: 0x0004, 0x3d75: 0x0004,
	// Block 0xf6, offset 0x3d80
	0x3d80: 0x0004, 0x3d81: 0x0004, 0x3d82: 0x0004, 0x3d83: 0x0004, 0x3d84: 0x0004, 0x3d85: 0x0004,
	0x3d86: 0x0004, 0x3d87: 0x0004, 0x3d88: 0x0004, 0x3d89: 0x0004, 0x3d8a: 0x0004, 0x3d8b: 0x0004,
	0x3d8c: 0x0004, 0x3d8d: 0x0004, 0x3d8e: 0x0004, 0x3d8f: 0x0004, 0x3d90: 0x0004, 0x3d91: 0x0004,
	0x3d92: 0x0004, 0x3d93: 0x0004, 0x3d94: 0x0004, 0x3d95: 0x0004, 0x3d96: 0x0004, 0x3d97: 0x0004,
	0x3d98: 0x0004, 0x3d99: 0x0004, 0x3d9a: 0x0004, 0x3d9b: 0x0004, 0x3d9c: 0x0004, 0x3d9d: 0x0004,
	0x3d9e: 0x0004, 0x3d9f: 0x0004, 0x3da0: 0x0004, 0x3da1: 0x0004, 0x3da2: 0x0004, 0x3da3: 0x0004,
	0x3da4: 0x0004, 0x3da5: 0x0004, 0x3da6: 0x0004, 0x3da9: 0x0004,
	0x3daa: 0x0004, 0x3dab: 0x0004, 0x3dac: 0x0004, 0x3dad: 0x0004, 0x3dae: 0x0004, 0x3daf: 0x0004,
	0x3db0: 0x0004, 0x3db1: 0x0004, 0x3db2: 0x0004, 0x3db3: 0x0004, 0x3db4: 0x0004, 0x3db5: 0x0004,
	0x3db6: 0x0004, 0x3db7: 0x0004, 0x3db8: 0x0004, 0x3db9: 0x0004, 0x3dba: 0x0004, 0x3dbb: 0x0004,
	0x3dbc: 0x0004, 0x3dbd: 0x0004, 0x3dbe: 0x0004, 0x3dbf: 0x0004,
	// Block 0xf7, offset 0x3dc0
	0x3dc0: 0x0004, 0x3dc1: 0x0004, 0x3dc2: 0x0004, 0x3dc3: 0x0004, 0x3dc4: 0x0004, 0x3dc5: 0x0004,
	0x3dc6: 0x0004, 0x3dc7: 0x0004, 0x3dc8: 0x0004, 0x3dc9: 0x0004, 0x3dca: 0x0004, 0x3dcb: 0x0004,
	0x3dcc: 0x0004, 0x3dcd: 0x0004, 0x3dce: 0x0004, 0x3dcf: 0x0004, 0x3dd0: 0x0004, 0x3dd1: 0x0004,
	0x3dd2: 0x0004, 0x3dd3: 0x0004, 0x3dd4: 0x0004, 0x3dd5: 0x0004, 0x3dd6: 0x0004, 0x3dd7: 0x0004,
	0x3dd8: 0x0004, 0x3dd9: 0x0004, 0x3dda: 0x0004, 0x3ddb: 0x0004, 0x3ddc: 0x0004, 0x3ddd: 0x0004,
	0x3dde: 0x0004, 0x3ddf: 0x0004, 0x3de0: 0x0004, 0x3de1: 0x0004, 0x3de2: 0x0004, 0x3de3: 0x0004,
	0x3de4: 0x0004, 0x3de5: 0x0005, 0x3de6: 0x0005, 0x3de7: 0x0005, 0x3de8: 0x0005, 0x3de9: 0x0005,
	0x3dea: 0x0004, 0x3deb: 0x0004, 0x3dec: 0x0004, 0x3ded: 0x0005, 0x3dee: 0x0005, 0x3def: 0x0005,
	0x3df0: 0x0005, 0x3df1: 0x0005, 0x3df2: 0x0005, 0x3df3: 0x0001, 0x3df4: 0x0001, 0x3df5: 0x0001,
	0x3df6: 0x0001, 0x3df7: 0x0001, 0x3df8: 0x0001, 0x3df9: 0x0001, 0x3dfa: 0x0001, 0x3dfb: 0x0005,
	0x3dfc: 0x0005, 0x3dfd: 0x0005, 0x3dfe: 0x0005, 0x3dff: 0x0005,
	// Block 0xf8, offset 0x3e00
	0x3e00: 0x0005, 0x3e01: 0x0005, 0x3e02: 0x0005, 0x3e03: 0x0004, 0x3e04: 0x0004, 0x3e05: 0x0005,
	0x3e06: 0x0005, 0x3e07: 0x0005, 0x3e08: 0x0005, 0x3e09: 0x0005, 0x3e0a: 0x0005, 0x3e0b: 0x0005,
	0x3e0c: 0x0004, 0x3e0d: 0x0004, 0x3e0e: 0x0004, 0x3e0f: 0x0004, 0x3e10: 0x0004, 0x3e11: 0x0004,
	0x3e12: 0x0004, 0x3e13: 0x0004, 0x3e14: 0x0004, 0x3e15: 0x0004, 0x3e16: 0x0004, 0x3e17: 0x0004,
	0x3e18: 0x0004, 0x3e19: 0x0004, 0x3e1a: 0x0004, 0x3e1b: 0x0004, 0x3e1c: 0x0004, 0x3e1d: 0x0004,
	0x3e1e: 0x0004, 0x3e1f: 0x0004, 0x3e20: 0x0004, 0x3e21: 0x0004, 0x3e22: 0x0004, 0x3e23: 0x0004,
	0x3e24: 0x0004, 0x3e25: 0x0004, 0x3e26: 0x0004, 0x3e27: 0x0004, 0x3e28: 0x0004, 0x3e29: 0x0004,
	0x3e2a: 0x0005, 0x3e2b: 0x0005, 0x3e2c: 0x0005, 0x3e2d: 0x0005, 0x3e2e: 0x0004, 0x3e2f: 0x0004,
	0x3e30: 0x0004, 0x3e31: 0x0004, 0x3e32: 0x0004, 0x3e33: 0x0004, 0x3e34: 0x0004, 0x3e35: 0x0004,
	0x3e36: 0x0004, 0x3e37: 0x0004, 0x3e38: 0x0004, 0x3e39: 0x0004, 0x3e3a: 0x0004, 0x3e3b: 0x0004,
	0x3e3c: 0x0004, 0x3e3d: 0x0004, 0x3e3e: 0x0004, 0x3e3f: 0x0004,
	// Block 0xf9, offset 0x3e40
	0x3e40: 0x0004, 0x3e41: 0x0004, 0x3e42: 0x0004, 0x3e43: 0x0004, 0x3e44: 0x0004, 0x3e45: 0x0004,
	0x3e46: 0x0004, 0x3e47: 0x0004, 0x3e48: 0x0004, 0x3e49: 0x0004, 0x3e4a: 0x0004, 0x3e4b: 0x0004,
	0x3e4c: 0x0004, 0x3e4d: 0x0004, 0x3e4e: 0x0004, 0x3e4f: 0x0004, 0x3e50: 0x0004, 0x3e51: 0x0004,
	0x3e52: 0x0004, 0x3e53: 0x0004, 0x3e54: 0x0004, 0x3e55: 0x0004, 0x3e56: 0x0004, 0x3e57: 0x0004,
	0x3e58: 0x0004, 0x3e59: 0x0004, 0x3e5a: 0x0004, 0x3e5b: 0x0004, 0x3e5c: 0x0004, 0x3e5d: 0x0004,
	0x3e5e: 0x0004, 0x3e5f: 0x0004, 0x3e60: 0x0004, 0x3e61: 0x0004, 0x3e62: 0x0004, 0x3e63: 0x0004,
	0x3e64: 0x0004, 0x3e65: 0x0004, 0x3e66: 0x0004, 0x3e67: 0x0004, 0x3e68: 0x0004,
	// Block 0xfa, offset 0x3e80
	0x3e80: 0x0004, 0x3e81: 0x0004, 0x3e82: 0x0005, 0x3e83: 0x0005, 0x3e84: 0x0005, 0x3e85: 0x0004,
	// Block 0xfb, offset 0x3ec0
	0x3ec0: 0x0004, 0x3ec1: 0x0004, 0x3ec2: 0x0004, 0x3ec3: 0x0004, 0x3ec4: 0x0004, 0x3ec5: 0x0004,
	0x3ec6: 0x0004, 0x3ec7: 0x0004, 0x3ec8: 0x0004, 0x3ec9: 0x0004, 0x3eca: 0x0004, 0x3ecb: 0x0004,
	0x3ecc: 0x0004, 0x3ecd: 0x0004, 0x3ece: 0x0004, 0x3ecf: 0x0004, 0x3ed0: 0x0004, 0x3ed1: 0x0004,
	0x3ed2: 0x0004, 0x3ed3: 0x0004, 0x3ed4: 0x0004, 0x3ed5: 0x0004, 0x3ed6: 0x0004,
	0x3ee0: 0x0004, 0x3ee1: 0x0004, 0x3ee2: 0x0004, 0x3ee3: 0x0004,
	0x3ee4: 0x0004, 0x3ee5: 0x0004, 0x3ee6: 0x0004, 0x3ee7: 0x0004, 0x3ee8: 0x0004, 0x3ee9: 0x0004,
	0x3eea: 0x0004, 0x3eeb: 0x0004, 0x3eec: 0x0004, 0x3eed: 0x0004, 0x3eee: 0x0004, 0x3eef: 0x0004,
	0x3ef0: 0x0004, 0x3ef1: 0x0004,
	// Block 0xfc, offset 0x3f00
	0x3f00: 0x0004, 0x3f01: 0x0004, 0x3f02: 0x0004, 0x3f03: 0x0004, 0x3f04: 0x0004, 0x3f05: 0x0004,
	0x3f06: 0x0004, 0x3f07: 0x0004, 0x3f08: 0x0004, 0x3f09: 0x0004, 0x3f0a: 0x0004, 0x3f0b: 0x0004,
	0x3f0c: 0x0004, 0x3f0d: 0x0004, 0x3f0e: 0x0004, 0x3f0f: 0x0004, 0x3f10: 0x0004, 0x3f11: 0x0004,
	0x3f12: 0x0004, 0x3f13: 0x0004, 0x3f14: 0x0004, 0x3f16: 0x0004, 0x3f17: 0x0004,
	0x3f18: 0x0004, 0x3f19: 0x0004, 0x3f1a: 0x0004, 0x3f1b: 0x0004, 0x3f1c: 0x0004, 0x3f1d: 0x0004,
	0x3f1e: 0x0004, 0x3f1f: 0x0004, 0x3f20: 0x0004, 0x3f21: 0x0004, 0x3f22: 0x0004, 0x3f23: 0x0004,
	0x3f24: 0x0004, 0x3f25: 0x0004, 0x3f26: 0x0004, 0x3f27: 0x0004, 0x3f28: 0x0004, 0x3f29: 0x0004,
	0x3f2a: 0x0004, 0x3f2b: 0x0004, 0x3f2c: 0x0004, 0x3f2d: 0x0004, 0x3f2e: 0x0004, 0x3f2f: 0x0004,
	0x3f30: 0x0004, 0x3f31: 0x0004, 0x3f32: 0x0004, 0x3f33: 0x0004, 0x3f34: 0x0004, 0x3f35: 0x0004,
	0x3f36: 0x0004, 0x3f37: 0x0004, 0x3f38: 0x0004, 0x3f39: 0x0004, 0x3f3a: 0x0004, 0x3f3b: 0x0004,
	0x3f3c: 0x0004, 0x3f3d: 0x0004, 0x3f3e: 0x0004, 0x3f3f: 0x0004,
	// Block 0xfd, offset 0x3f40
	0x3f40: 0x0004, 0x3f41: 0x0004, 0x3f42: 0x0004, 0x3f43: 0x0004, 0x3f44: 0x0004, 0x3f45: 0x0004,
	0x3f46: 0x0004, 0x3f47: 0x0004, 0x3f48: 0x0004, 0x3f49: 0x0004, 0x3f4a: 0x0004, 0x3f4b: 0x0004,
	0x3f4c: 0x0004, 0x3f4d: 0x0004, 0x3f4e: 0x0004, 0x3f4f: 0x0004, 0x3f50: 0x0004, 0x3f51: 0x0004,
	0x3f52: 0x0004, 0x3f53: 0x0004, 0x3f54: 0x0004, 0x3f55: 0x0004, 0x3f56: 0x0004, 0x3f57: 0x0004,
	0x3f58: 0x0004, 0x3f59: 0x0004, 0x3f5a: 0x0004, 0x3f5b: 0x0004, 0x3f5c: 0x0004,
	0x3f5e: 0x0004, 0x3f5f: 0x0004, 0x3f62: 0x0004,
	0x3f65: 0x0004, 0x3f66: 0x0004, 0x3f69: 0x0004,
	0x3f6a: 0x0004, 0x3f6b: 0x0004, 0x3f6c: 0x0004, 0x3f6e: 0x0004, 0x3f6f: 0x0004,
	0x3f70: 0x0004, 0x3f71: 0x0004, 0x3f72: 0x0004, 0x3f73: 0x0004, 0x3f74: 0x0004, 0x3f75: 0x0004,
	0x3f76: 0x0004, 0x3f77: 0x0004, 0x3f78: 0x0004, 0x3f79: 0x0004, 0x3f7b: 0x0004,
	0x3f7d: 0x0004, 0x3f7e: 0x0004, 0x3f7f: 0x0004,
	// Block 0xfe, offset 0x3f80
	0x3f80: 0x0004, 0x3f81: 0x0004, 0x3f82: 0x0004, 0x3f83: 0x0004, 0x3f85: 0x0004,
	0x3f86: 0x0004, 0x3f87: 0x0004, 0x3f88: 0x0004, 0x3f89: 0x0004, 0x3f8a: 0x0004, 0x3f8b: 0x0004,
	0x3f8c: 0x0004, 0x3f8d: 0x0004, 0x3f8e: 0x0004, 0x3f8f: 0x0004, 0x3f90: 0x0004, 0x3f91: 0x0004,
	0x3f92: 0x0004, 0x3f93: 0x0004, 0x3f94: 0x0004, 0x3f95: 0x0004, 0x3f96: 0x0004, 0x3f97: 0x0004,
	0x3f98: 0x0004, 0x3f99: 0x0004, 0x3f9a: 0x0004, 0x3f9b: 0x0004, 0x3f9c: 0x0004, 0x3f9d: 0x0004,
	0x3f9e: 0x0004, 0x3f9f: 0x0004, 0x3fa0: 0x0004, 0x3fa1: 0x0004, 0x3fa2: 0x0004, 0x3fa3: 0x0004,
	0x3fa4: 0x0004, 0x3fa5: 0x0004, 0x3fa6: 0x0004, 0x3fa7: 0x0004, 0x3fa8: 0x0004, 0x3fa9: 0x0004,
	0x3faa: 0x0004, 0x3fab: 0x0004, 0x3fac: 0x0004, 0x3fad: 0x0004, 0x3fae: 0x0004, 0x3faf: 0x0004,
	0x3fb0: 0x0004, 0x3fb1: 0x0004, 0x3fb2: 0x0004, 0x3fb3: 0x0004, 0x3fb4: 0x0004, 0x3fb5: 0x0004,
	0x3fb6: 0x0004, 0x3fb7: 0x0004, 0x3fb8: 0x0004, 0x3fb9: 0x0004, 0x3fba: 0x0004, 0x3fbb: 0x0004,
	0x3fbc: 0x0004, 0x3fbd: 0x0004, 0x3fbe: 0x0004, 0x3fbf: 0x0004,
	// Block 0xff, offset 0x3fc0
	0x3fc0: 0x0004, 0x3fc1: 0x0004, 0x3fc2: 0x0004, 0x3fc3: 0x0004, 0x3fc4: 0x0004, 0x3fc5: 0x0004,
	0x3fc7: 0x0004, 0x3fc8: 0x0004, 0x3fc9: 0x0004, 0x3fca: 0x0004,
	0x3fcd: 0x0004, 0x3fce: 0x0004, 0x3fcf: 0x0004, 0x3fd0: 0x0004, 0x3fd1: 0x0004,
	0x3fd2: 0x0004, 0x3fd3: 0x0004, 0x3fd4: 0x0004, 0x3fd6: 0x0004, 0x3fd7: 0x0004,
	0x3fd8: 0x0004, 0x3fd9: 0x0004, 0x3fda: 0x0004, 0x3fdb: 0x0004, 0x3fdc: 0x0004,
	0x3fde: 0x0004, 0x3fdf: 0x0004, 0x3fe0: 0x0004, 0x3fe1: 0x0004, 0x3fe2: 0x0004, 0x3fe3: 0x0004,
	0x3fe4: 0x0004, 0x3fe5: 0x0004, 0x3fe6: 0x0004, 0x3fe7: 0x0004, 0x3fe8: 0x0004, 0x3fe9: 0x0004,
	0x3fea: 0x0004, 0x3feb: 0x0004, 0x3fec: 0x0004, 0x3fed: 0x0004, 0x3fee: 0x0004, 0x3fef: 0x0004,
	0x3ff0: 0x0004, 0x3ff1: 0x0004, 0x3ff2: 0x0004, 0x3ff3: 0x0004, 0x3ff4: 0x0004, 0x3ff5: 0x0004,
	0x3ff6: 0x0004, 0x3ff7: 0x0004, 0x3ff8: 0x0004, 0x3ff9: 0x0004, 0x3ffb: 0x0004,
	0x3ffc: 0x0004, 0x3ffd: 0x0004, 0x3ffe: 0x0004,
	// Block 0x100, offset 0x4000
	0x4000: 0x0004, 0x4001: 0x0004, 0x4002: 0x0004, 0x4003: 0x0004, 0x4004: 0x0004,
	0x4006: 0x0004, 0x400a: 0x0004, 0x400b: 0x0004,
	0x400c: 0x0004, 0x400d: 0x0004, 0x400e: 0x0004, 0x400f: 0x0004, 0x4010: 0x0004,
	0x4012: 0x0004, 0x4013: 0x0004, 0x4014: 0x0004, 0x4015: 0x0004, 0x4016: 0x0004, 0x4017: 0x0004,
	0x4018: 0x0004, 0x4019: 0x0004, 0x401a: 0x0004, 0x401b: 0x0004, 0x401c: 0x0004, 0x401d: 0x0004,
	0x401e: 0x0004, 0x401f: 0x0004, 0x4020: 0x0004, 0x4021: 0x0004, 0x4022: 0x0004, 0x4023: 0x0004,
	0x4024: 0x0004, 0x4025: 0x0004, 0x4026: 0x0004, 0x4027: 0x0004, 0x4028: 0x0004, 0x4029: 0x0004,
	0x402a: 0x0004, 0x402b: 0x0004, 0x402c: 0x0004, 0x402d: 0x0004, 0x402e: 0x0004, 0x402f: 0x0004,
	0x4030: 0x0004, 0x4031: 0x0004, 0x4032: 0x0004, 0x4033: 0x0004, 0x4034: 0x0004, 0x4035: 0x0004,
	0x4036: 0x0004, 0x4037: 0x0004, 0x4038: 0x0004, 0x4039: 0x0004, 0x403a: 0x0004, 0x403b: 0x0004,
	0x403c: 0x0004, 0x403d: 0x0004, 0x403e: 0x0004, 0x403f: 0x0004,
	// Block 0x101, offset 0x4040
	0x4040: 0x0004, 0x4041: 0x0004, 0x4042: 0x0004, 0x4043: 0x0004, 0x4044: 0x0004, 0x4045: 0x0004,
	0x4046: 0x0004, 0x4047: 0x0004, 0x4048: 0x0004, 0x4049: 0x0004, 0x404a: 0x0004, 0x404b: 0x0004,
	0x404c: 0x0004, 0x404d: 0x0004, 0x404e: 0x0004, 0x404f: 0x0004, 0x4050: 0x0004, 0x4051: 0x0004,
	0x4052: 0x0004, 0x4053: 0x0004, 0x4054: 0x0004, 0x4055: 0x0004, 0x4056: 0x0004, 0x4057: 0x0004,
	0x4058: 0x0004, 0x4059: 0x0004, 0x405a: 0x0004, 0x405b: 0x0004, 0x405c: 0x0004, 0x405d: 0x0004,
	0x405e: 0x0004, 0x405f: 0x0004, 0x4060: 0x0004, 0x4061: 0x0004, 0x4062: 0x0004, 0x4063: 0x0004,
	0x4064: 0x0004, 0x4065: 0x0004, 0x4068: 0x0004, 0x4069: 0x0004,
	0x406a: 0x0004, 0x406b: 0x0004, 0x406c: 0x0004, 0x406d: 0x0004, 0x406e: 0x0004, 0x406f: 0x0004,
	0x4070: 0x0004, 0x4071: 0x0004, 0x4072: 0x0004, 0x4073: 0x0004, 0x4074: 0x0004, 0x4075: 0x0004,
	0x4076: 0x0004, 0x4077: 0x0004, 0x4078: 0x0004, 0x4079: 0x0004, 0x407a: 0x0004, 0x407b: 0x0004,
	0x407c: 0x0004, 0x407d: 0x0004, 0x407e: 0x0004, 0x407f: 0x0004,
	// Block 0x102, offset 0x4080
	0x4080: 0x0004, 0x4081: 0x0004, 0x4082: 0x0004, 0x4083: 0x0004, 0x4084: 0x0004, 0x4085: 0x0004,
	0x4086: 0x0004, 0x4087: 0x0004, 0x4088: 0x0004, 0x4089: 0x0004, 0x408a: 0x0004, 0x408b: 0x0004,
	0x408e: 0x0004, 0x408f: 0x0004, 0x4090: 0x0004, 0x4091: 0x0004,
	0x4092: 0x0004, 0x4093: 0x0004, 0x4094: 0x0004, 0x4095: 0x0004, 0x4096: 0x0004, 0x4097: 0x0004,
	0x4098: 0x0004, 0x4099: 0x0004, 0x409a: 0x0004, 0x409b: 0x0004, 0x409c: 0x0004, 0x409d: 0x0004,
	0x409e: 0x0004, 0x409f: 0x0004, 0x40a0: 0x0004, 0x40a1: 0x0004, 0x40a2: 0x0004, 0x40a3: 0x0004,
	0x40a4: 0x0004, 0x40a5: 0x0004, 0x40a6: 0x0004, 0x40a7: 0x0004, 0x40a8: 0x0004, 0x40a9: 0x0004,
	0x40aa: 0x0004, 0x40ab: 0x0004, 0x40ac: 0x0004, 0x40ad: 0x0004, 0x40ae: 0x0004, 0x40af: 0x0004,
	0x40b0: 0x0004, 0x40b1: 0x0004, 0x40b2: 0x0004, 0x40b3: 0x0004, 0x40b4: 0x0004, 0x40b5: 0x0004,
	0x40b6: 0x0004, 0x40b7: 0x0004, 0x40b8: 0x0004, 0x40b9: 0x0004, 0x40ba: 0x0004, 0x40bb: 0x0004,
	0x40bc: 0x0004, 0x40bd: 0x0004, 0x40be: 0x0004, 0x40bf: 0x0004,
	// Block 0x103, offset 0x40c0
	0x40c0: 0x0005, 0x40c1: 0x0005, 0x40c2: 0x0005, 0x40c3: 0x0005, 0x40c4: 0x0005, 0x40c5: 0x0005,
	0x40c6: 0x0005, 0x40c7: 0x0005, 0x40c8: 0x0005, 0x40c9: 0x0005, 0x40ca: 0x0005, 0x40cb: 0x0005,
	0x40cc: 0x0005, 0x40cd: 0x0005, 0x40ce: 0x0005, 0x40cf: 0x0005, 0x40d0: 0x0005, 0x40d1: 0x0005,
	0x40d2: 0x0005, 0x40d3: 0x0005, 0x40d4: 0x0005, 0x40d5: 0x0005, 0x40d6: 0x0005, 0x40d7: 0x0005,
	0x40d8: 0x0005, 0x40d9: 0x0005, 0x40da: 0x0005, 0x40db: 0x0005, 0x40dc: 0x0005, 0x40dd: 0x0005,
	0x40de: 0x0005, 0x40df: 0x0005, 0x40e0: 0x0005, 0x40e1: 0x0005, 0x40e2: 0x0005, 0x40e3: 0x0005,
	0x40e4: 0x0005, 0x40e5: 0x0005, 0x40e6: 0x0005, 0x40e7: 0x0005, 0x40e8: 0x0005, 0x40e9: 0x0005,
	0x40ea: 0x0005, 0x40eb: 0x0005, 0x40ec: 0x0005, 0x40ed: 0x0005, 0x40ee: 0x0005, 0x40ef: 0x0005,
	0x40f0: 0x0005, 0x40f1: 0x0005, 0x40f2: 0x0005, 0x40f3: 0x0005, 0x40f4: 0x0005, 0x40f5: 0x0005,
	0x40f6: 0x0005, 0x40f7: 0x0004, 0x40f8: 0x0004, 0x40f9: 0x0004, 0x40fa: 0x0004, 0x40fb: 0x0005,
	0x40fc: 0x0005, 0x40fd: 0x0005, 0x40fe: 0x0005, 0x40ff: 0x0005,
	// Block 0x104, offset 0x4100
	0x4100: 0x0005, 0x4101: 0x0005, 0x4102: 0x0005, 0x4103: 0x0005, 0x4104: 0x0005, 0x4105: 0x0005,
	0x4106: 0x0005, 0x4107: 0x0005, 0x4108: 0x0005, 0x4109: 0x0005, 0x410a: 0x0005, 0x410b: 0x0005,
	0x410c: 0x0005, 0x410d: 0x0005, 0x410e: 0x0005, 0x410f: 0x0005, 0x4110: 0x0005, 0x4111: 0x0005,
	0x4112: 0x0005, 0x4113: 0x0005, 0x4114: 0x0005, 0x4115: 0x0005, 0x4116: 0x0005, 0x4117: 0x0005,
	0x4118: 0x0005, 0x4119: 0x0005, 0x411a: 0x0005, 0x411b: 0x0005, 0x411c: 0x0005, 0x411d: 0x0005,
	0x411e: 0x0005, 0x411f: 0x0005, 0x4120: 0x0005, 0x4121: 0x0005, 0x4122: 0x0005, 0x4123: 0x0005,
	0x4124: 0x0005, 0x4125: 0x0005, 0x4126: 0x0005, 0x4127: 0x0005, 0x4128: 0x0005, 0x4129: 0x0005,
	0x412a: 0x0005, 0x412b: 0x0005, 0x412c: 0x0005, 0x412d: 0x0004, 0x412e: 0x0004, 0x412f: 0x0004,
	0x4130: 0x0004, 0x4131: 0x0004, 0x4132: 0x0004, 0x4133: 0x0004, 0x4134: 0x0004, 0x4135: 0x0005,
	0x4136: 0x0004, 0x4137: 0x0004, 0x4138: 0x0004, 0x4139: 0x0004, 0x413a: 0x0004, 0x413b: 0x0004,
	0x413c: 0x0004, 0x413d: 0x0004, 0x413e: 0x0004, 0x413f: 0x0004,
	// Block 0x105, offset 0x4140
	0x4140: 0x0004, 0x4141: 0x0004, 0x4142: 0x0004, 0x4143: 0x0004, 0x4144: 0x0005, 0x4145: 0x0004,
	0x4146: 0x0004, 0x4147: 0x0004, 0x4148: 0x0004, 0x4149: 0x0004, 0x414a: 0x0004, 0x414b: 0x0004,
	0x415b: 0x0005, 0x415c: 0x0005, 0x415d: 0x0005,
	0x415e: 0x0005, 0x415f: 0x0005, 0x4161: 0x0005, 0x4162: 0x0005, 0x4163: 0x0005,
	0x4164: 0x0005, 0x4165: 0x0005, 0x4166: 0x0005, 0x4167: 0x0005, 0x4168: 0x0005, 0x4169: 0x0005,
	0x416a: 0x0005, 0x416b: 0x0005, 0x416c: 0x0005, 0x416d: 0x0005, 0x416e: 0x0005, 0x416f: 0x0005,
	// Block 0x106, offset 0x4180
	0x4180: 0x0005, 0x4181: 0x0005, 0x4182: 0x0005, 0x4183: 0x0005, 0x4184: 0x0005,
	0x4187: 0x0004, 0x4188: 0x0004, 0x4189: 0x0004, 0x418a: 0x0004, 0x418b: 0x0004,
	0x418c: 0x0004, 0x418d: 0x0004, 0x418e: 0x0004, 0x418f: 0x0004, 0x4190: 0x0005, 0x4191: 0x0005,
	0x4192: 0x0005, 0x4193: 0x0005, 0x4194: 0x0005, 0x4195: 0x0005, 0x4196: 0x0005,
	// Block 0x107, offset 0x41c0
	0x41c0: 0x0004, 0x41c1: 0x0004, 0x41c2: 0x0004, 0x41c3: 0x0004, 0x41c5: 0x0004,
	0x41c6: 0x0004, 0x41c7: 0x0004, 0x41c8: 0x0004, 0x41c9: 0x0004, 0x41ca: 0x0004, 0x41cb: 0x0004,
	0x41cc: 0x0004, 0x41cd: 0x0004, 0x41ce: 0x0004, 0x41cf: 0x0004, 0x41d0: 0x0004, 0x41d1: 0x0004,
	0x41d2: 0x0004, 0x41d3: 0x0004, 0x41d4: 0x0004, 0x41d5: 0x0004, 0x41d6: 0x0004, 0x41d7: 0x0004,
	0x41d8: 0x0004, 0x41d9: 0x0004, 0x41da: 0x0004, 0x41db: 0x0004, 0x41dc: 0x0004, 0x41dd: 0x0004,
	0x41de: 0x0004, 0x41df: 0x0004, 0x41e1: 0x0004, 0x41e2: 0x0004,
	0x41e4: 0x0004, 0x41e7: 0x0004, 0x41e9: 0x0004,
	0x41ea: 0x0004, 0x41eb: 0x0004, 0x41ec: 0x0004, 0x41ed: 0x0004, 0x41ee: 0x0004, 0x41ef: 0x0004,
	0x41f0: 0x0004, 0x41f1: 0x0004, 0x41f2: 0x0004, 0x41f4: 0x0004, 0x41f5: 0x0004,
	0x41f6: 0x0004, 0x41f7: 0x0004, 0x41f9: 0x0004, 0x41fb: 0x0004,
	// Block 0x108, offset 0x4200
	0x4202: 0x0004,
	0x4207: 0x0004, 0x4209: 0x0004, 0x420b: 0x0004,
	0x420d: 0x0004, 0x420e: 0x0004, 0x420f: 0x0004, 0x4211: 0x0004,
	0x4212: 0x0004, 0x4214: 0x0004, 0x4217: 0x0004,
	0x4219: 0x0004, 0x421b: 0x0004, 0x421d: 0x0004,
	0x421f: 0x0004, 0x4221: 0x0004, 0x4222: 0x0004,
	0x4224: 0x0004, 0x4227: 0x0004, 0x4228: 0x0004, 0x4229: 0x0004,
	0x422a: 0x0004, 0x422c: 0x0004, 0x422d: 0x0004, 0x422e: 0x0004, 0x422f: 0x0004,
	0x4230: 0x0004, 0x4231: 0x0004, 0x4232: 0x0004, 0x4234: 0x0004, 0x4235: 0x0004,
	0x4236: 0x0004, 0x4237: 0x0004, 0x4239: 0x0004, 0x423a: 0x0004, 0x423b: 0x0004,
	0x423c: 0x0004, 0x423e: 0x0004,
	// Block 0x109, offset 0x4240
	0x4240: 0x0004, 0x4241: 0x0004, 0x4242: 0x0004, 0x4243: 0x0004, 0x4244: 0x0004, 0x4245: 0x0004,
	0x4246: 0x0004, 0x4247: 0x0004, 0x4248: 0x0004, 0x4249: 0x0004, 0x424b: 0x0004,
	0x424c: 0x0004, 0x424d: 0x0004, 0x424e: 0x0004, 0x424f: 0x0004, 0x4250: 0x0004, 0x4251: 0x0004,
	0x4252: 0x0004, 0x4253: 0x0004, 0x4254: 0x0004, 0x4255: 0x0004, 0x4256: 0x0004, 0x4257: 0x0004,
	0x4258: 0x0004, 0x4259: 0x0004, 0x425a: 0x0004, 0x425b: 0x0004,
	0x4261: 0x0004, 0x4262: 0x0004, 0x4263: 0x0004,
	0x4265: 0x0004, 0x4266: 0x0004, 0x4267: 0x0004, 0x4268: 0x0004, 0x4269: 0x0004,
	0x426b: 0x0004, 0x426c: 0x0004, 0x426d: 0x0004, 0x426e: 0x0004, 0x426f: 0x0004,
	0x4270: 0x0004, 0x4271: 0x0004, 0x4272: 0x0004, 0x4273: 0x0004, 0x4274: 0x0004, 0x4275: 0x0004,
	0x4276: 0x0004, 0x4277: 0x0004, 0x4278: 0x0004, 0x4279: 0x0004, 0x427a: 0x0004, 0x427b: 0x0004,
	// Block 0x10a, offset 0x4280
	0x42b0: 0x0004, 0x42b1: 0x0004,
	// Block 0x10b, offset 0x42c0
	0x42c0: 0x0004, 0x42c1: 0x0004, 0x42c2: 0x0004, 0x42c3: 0x0004, 0x42c4: 0x0004, 0x42c5: 0x0004,
	0x42c6: 0x0004, 0x42c7: 0x0004, 0x42c8: 0x0004, 0x42c9: 0x0004, 0x42ca: 0x0004, 0x42cb: 0x0004,
	0x42cc: 0x0004, 0x42cd: 0x0004, 0x42ce: 0x0004, 0x42cf: 0x0004, 0x42d0: 0x0004, 0x42d1: 0x0004,
	0x42d2: 0x0004, 0x42d3: 0x0004, 0x42d4: 0x0004, 0x42d5: 0x0004, 0x42d6: 0x0004, 0x42d7: 0x0004,
	0x42d8: 0x0004, 0x42d9: 0x0004, 0x42da: 0x0004, 0x42db: 0x0004, 0x42dc: 0x0004, 0x42dd: 0x0004,
	0x42de: 0x0004, 0x42df: 0x0004, 0x42e0: 0x0004, 0x42e1: 0x0004, 0x42e2: 0x0004, 0x42e3: 0x0004,
	0x42e4: 0x0004, 0x42e5: 0x0004, 0x42e6: 0x0004, 0x42e7: 0x0004, 0x42e8: 0x0004, 0x42e9: 0x0004,
	0x42ea: 0x0004, 0x42eb: 0x0004,
	0x42f0: 0x0004, 0x42f1: 0x0004, 0x42f2: 0x0004, 0x42f3: 0x0004, 0x42f4: 0x0004, 0x42f5: 0x0004,
	0x42f6: 0x0004, 0x42f7: 0x0004, 0x42f8: 0x0004, 0x42f9: 0x0004, 0x42fa: 0x0004, 0x42fb: 0x0004,
	0x42fc: 0x0004, 0x42fd: 0x0004, 0x42fe: 0x0004, 0x42ff: 0x0004,
	// Block 0x10c, offset 0x4300
	0x4300: 0x0004, 0x4301: 0x0004, 0x4302: 0x0004, 0x4303: 0x0004, 0x4304: 0x0004, 0x4305: 0x0004,
	0x4306: 0x0004, 0x4307: 0x0004, 0x4308: 0x0004, 0x4309: 0x0004, 0x430a: 0x0004, 0x430b: 0x0004,
	0x430c: 0x0004, 0x430d: 0x0004, 0x430e: 0x0004, 0x430f: 0x0004, 0x4310: 0x0004, 0x4311: 0x0004,
	0x4312: 0x0004, 0x4313: 0x0004,
	0x4320: 0x0004, 0x4321: 0x0004, 0x4322: 0x0004, 0x4323: 0x0004,
	0x4324: 0x0004, 0x4325: 0x0004, 0x4326: 0x0004, 0x4327: 0x0004, 0x4328: 0x0004, 0x4329: 0x0004,
	0x432a: 0x0004, 0x432b: 0x0004, 0x432c: 0x0004, 0x432d: 0x0004, 0x432e: 0x0004,
	0x4331: 0x0004, 0x4332: 0x0004, 0x4333: 0x0004, 0x4334: 0x0004, 0x4335: 0x0004,
	0x4336: 0x0004, 0x4337: 0x0004, 0x4338: 0x0004, 0x4339: 0x0004, 0x433a: 0x0004, 0x433b: 0x0004,
	0x433c: 0x0004, 0x433d: 0x0004, 0x433e: 0x0004, 0x433f: 0x0004,
	// Block 0x10d, offset 0x4340
	0x4341: 0x0004, 0x4342: 0x0004, 0x4343: 0x0004, 0x4344: 0x0004, 0x4345: 0x0004,
	0x4346: 0x0004, 0x4347: 0x0004, 0x4348: 0x0004, 0x4349: 0x0004, 0x434a: 0x0004, 0x434b: 0x0004,
	0x434c: 0x0004, 0x434d: 0x0004, 0x434e: 0x0004, 0x434f: 0x0004, 0x4351: 0x0004,
	0x4352: 0x0004, 0x4353: 0x0004, 0x4354: 0x0004, 0x4355: 0x0004, 0x4356: 0x0004, 0x4357: 0x0004,
	0x4358: 0x0004, 0x4359: 0x0004, 0x435a: 0x0004, 0x435b: 0x0004, 0x435c: 0x0004, 0x435d: 0x0004,
	0x435e: 0x0004, 0x435f: 0x0004, 0x4360: 0x0004, 0x4361: 0x0004, 0x4362: 0x0004, 0x4363: 0x0004,
	0x4364: 0x0004, 0x4365: 0x0004, 0x4366: 0x0004, 0x4367: 0x0004, 0x4368: 0x0004, 0x4369: 0x0004,
	0x436a: 0x0004, 0x436b: 0x0004, 0x436c: 0x0004, 0x436d: 0x0004, 0x436e: 0x0004, 0x436f: 0x0004,
	0x4370: 0x0004, 0x4371: 0x0004, 0x4372: 0x0004, 0x4373: 0x0004, 0x4374: 0x0004, 0x4375: 0x0004,
	// Block 0x10e, offset 0x4380
	0x4380: 0x0004, 0x4381: 0x0004, 0x4382: 0x0004, 0x4383: 0x0004, 0x4384: 0x0004, 0x4385: 0x0004,
	0x4386: 0x0004, 0x4387: 0x0004, 0x4388: 0x0004, 0x4389: 0x0004, 0x438a: 0x0004, 0x438b: 0x0004,
	0x438c: 0x0004, 0x4390: 0x0004, 0x4391: 0x0004,
	0x4392: 0x0004, 0x4393: 0x0004, 0x4394: 0x0004, 0x4395: 0x0004, 0x4396: 0x0004, 0x4397: 0x0004,
	0x4398: 0x0004, 0x4399: 0x0004, 0x439a: 0x0004, 0x439b: 0x0004, 0x439c: 0x0004, 0x439d: 0x0004,
	0x439e: 0x0004, 0x439f: 0x0004, 0x43a0: 0x0004, 0x43a1: 0x0004, 0x43a2: 0x0004, 0x43a3: 0x0004,
	0x43a4: 0x0004, 0x43a5: 0x0004, 0x43a6: 0x0004, 0x43a7: 0x0004, 0x43a8: 0x0004, 0x43a9: 0x0004,
	0x43aa: 0x0004, 0x43ab: 0x0004, 0x43ac: 0x0004, 0x43ad: 0x0004, 0x43ae: 0x0004,
	0x43b0: 0x0004, 0x43b1: 0x0004, 0x43b2: 0x0004, 0x43b3: 0x0004, 0x43b4: 0x0004, 0x43b5: 0x0004,
	0x43b6: 0x0004, 0x43b7: 0x0004, 0x43b8: 0x0004, 0x43b9: 0x0004, 0x43ba: 0x0004, 0x43bb: 0x0004,
	0x43bc: 0x0004, 0x43bd: 0x0004, 0x43be: 0x0004, 0x43bf: 0x0004,
	// Block 0x10f, offset 0x43c0
	0x43c0: 0x0004, 0x43c1: 0x0004, 0x43c2: 0x0004, 0x43c3: 0x0004, 0x43c4: 0x0004, 0x43c5: 0x0004,
	0x43c6: 0x0004, 0x43c7: 0x0004, 0x43c8: 0x0004, 0x43c9: 0x0004, 0x43ca: 0x0004, 0x43cb: 0x0004,
	0x43cc: 0x0004, 0x43cd: 0x0004, 0x43ce: 0x0004, 0x43cf: 0x0004, 0x43d0: 0x0004, 0x43d1: 0x0004,
	0x43d2: 0x0004, 0x43d3: 0x0004, 0x43d4: 0x0004, 0x43d5: 0x0004, 0x43d6: 0x0004, 0x43d7: 0x0004,
	0x43d8: 0x0004, 0x43d9: 0x0004, 0x43da: 0x0004,
	// Block 0x110, offset 0x4400
	0x4426: 0x0004, 0x4427: 0x0004, 0x4428: 0x0004, 0x4429: 0x0004,
	0x442a: 0x0004, 0x442b: 0x0004, 0x442c: 0x0004, 0x442d: 0x0004, 0x442e: 0x0004, 0x442f: 0x0004,
	0x4430: 0x0004, 0x4431: 0x0004, 0x4432: 0x0004, 0x4433: 0x0004, 0x4434: 0x0004, 0x4435: 0x0004,
	0x4436: 0x0004, 0x4437: 0x0004, 0x4438: 0x0004, 0x4439: 0x0004, 0x443a: 0x0004, 0x443b: 0x0004,
	0x443c: 0x0004, 0x443d: 0x0004, 0x443e: 0x0004, 0x443f: 0x0004,
	// Block 0x111, offset 0x4440
	0x4440: 0x0004, 0x4441: 0x0004, 0x4442: 0x0004,
	0x4450: 0x0004, 0x4451: 0x0004,
	0x4452: 0x0004, 0x4453: 0x0004, 0x4454: 0x0004, 0x4455: 0x0004, 0x4456: 0x0004, 0x4457: 0x0004,
	0x4458: 0x0004, 0x4459: 0x0004, 0x445a: 0x0004, 0x445b: 0x0004, 0x445c: 0x0004, 0x445d: 0x0004,
	0x445e: 0x0004, 0x445f: 0x0004, 0x4460: 0x0004, 0x4461: 0x0004, 0x4462: 0x0004, 0x4463: 0x0004,
	0x4464: 0x0004, 0x4465: 0x0004, 0x4466: 0x0004, 0x4467: 0x0004, 0x4468: 0x0004, 0x4469: 0x0004,
	0x446a: 0x0004, 0x446b: 0x0004, 0x446c: 0x0004, 0x446d: 0x0004, 0x446e: 0x0004, 0x446f: 0x0004,
	0x4470: 0x0004, 0x4471: 0x0004, 0x4472: 0x0004, 0x4473: 0x0004, 0x4474: 0x0004, 0x4475: 0x0004,
	0x4476: 0x0004, 0x4477: 0x0004, 0x4478: 0x0004, 0x4479: 0x0004, 0x447a: 0x0004,
	// Block 0x112, offset 0x4480
	0x4480: 0x0004, 0x4481: 0x0004, 0x4482: 0x0004, 0x4483: 0x0004, 0x4484: 0x0004, 0x4485: 0x0004,
	0x4486: 0x0004, 0x4487: 0x0004, 0x4488: 0x0004,
	0x4490: 0x0004, 0x4491: 0x0004,
	// Block 0x113, offset 0x44c0
	0x44c0: 0x0004, 0x44c1: 0x0004, 0x44c2: 0x0004, 0x44c3: 0x0004, 0x44c4: 0x0004, 0x44c5: 0x0004,
	0x44c6: 0x0004, 0x44c7: 0x0004, 0x44c8: 0x0004, 0x44c9: 0x0004, 0x44ca: 0x0004, 0x44cb: 0x0004,
	0x44cc: 0x0004, 0x44cd: 0x0004, 0x44ce: 0x0004, 0x44cf: 0x0004, 0x44d0: 0x0004, 0x44d1: 0x0004,
	0x44d2: 0x0004, 0x44d3: 0x0004, 0x44d4: 0x0004, 0x44d5: 0x0004, 0x44d6: 0x0004, 0x44d7: 0x0004,
	0x44d8: 0x0004, 0x44d9: 0x0004, 0x44da: 0x0004, 0x44db: 0x0004, 0x44dc: 0x0004, 0x44dd: 0x0004,
	0x44de: 0x0004, 0x44df: 0x0004, 0x44e0: 0x0004, 0x44e1: 0x0004, 0x44e2: 0x0004, 0x44e3: 0x0004,
	0x44e4: 0x0004, 0x44e5: 0x0004, 0x44e6: 0x0004, 0x44e7: 0x0004, 0x44e8: 0x0004, 0x44e9: 0x0004,
	0x44ea: 0x0004, 0x44eb: 0x0004, 0x44ec: 0x0004, 0x44ed: 0x0004, 0x44ee: 0x0004, 0x44ef: 0x0004,
	0x44f0: 0x0004, 0x44f1: 0x0004, 0x44f2: 0x0004, 0x44f3: 0x0004, 0x44f4: 0x0004, 0x44f5: 0x0004,
	0x44f6: 0x0004, 0x44f7: 0x0004, 0x44f8: 0x0004, 0x44f9: 0x0004, 0x44fb: 0x0004,
	0x44fc: 0x0004, 0x44fd: 0x0004, 0x44fe: 0x0004, 0x44ff: 0x0004,
	// Block 0x114, offset 0x4500
	0x4500: 0x0004, 0x4501: 0x0004, 0x4502: 0x0004, 0x4503: 0x0004, 0x4504: 0x0004, 0x4505: 0x0004,
	0x4506: 0x0004, 0x4507: 0x0004, 0x4508: 0x0004, 0x4509: 0x0004, 0x450a: 0x0004, 0x450b: 0x0004,
	0x450c: 0x0004, 0x450d: 0x0004, 0x450e: 0x0004, 0x450f: 0x0004, 0x4510: 0x0004, 0x4511: 0x0004,
	0x4512: 0x0004, 0x4513: 0x0004, 0x4514: 0x0004, 0x4515: 0x0004, 0x4516: 0x0004, 0x4517: 0x0004,
	0x4518: 0x0004, 0x4519: 0x0004, 0x451a: 0x0004, 0x451b: 0x0004, 0x451c: 0x0004, 0x451d: 0x0004,
	0x451e: 0x0004, 0x451f: 0x0004, 0x4520: 0x0004, 0x4521: 0x0004, 0x4522: 0x0004, 0x4523: 0x0004,
	0x4525: 0x0004, 0x4526: 0x0004, 0x4527: 0x0004, 0x4528: 0x0004, 0x4529: 0x0004,
	0x452a: 0x0004, 0x452b: 0x0004, 0x452c: 0x0004, 0x452d: 0x0004, 0x452e: 0x0004, 0x452f: 0x0004,
	0x4530: 0x0004, 0x4531: 0x0004, 0x4532: 0x0004, 0x4533: 0x0004, 0x4534: 0x0004, 0x4535: 0x0004,
	0x4536: 0x0004, 0x4537: 0x0004, 0x4538: 0x0004, 0x4539: 0x0004, 0x453a: 0x0004, 0x453b: 0x0004,
	0x453c: 0x0004, 0x453d: 0x0004, 0x453e: 0x0004, 0x453f: 0x0004,
	// Block 0x115, offset 0x4540
	0x4540: 0x0004, 0x4541: 0x0004, 0x4542: 0x0004, 0x4543: 0x0004, 0x4544: 0x0004, 0x4545: 0x0004,
	0x4546: 0x0004, 0x4547: 0x0004, 0x4548: 0x0004, 0x4549: 0x0004, 0x454a: 0x0004, 0x454b: 0x0004,
	0x454c: 0x0004, 0x454d: 0x0004, 0x454e: 0x0004, 0x454f: 0x0004, 0x4550: 0x0004,
	0x4560: 0x0004, 0x4561: 0x0004, 0x4562: 0x0004, 0x4563: 0x0004,
	0x4564: 0x0004, 0x4565: 0x0004, 0x4566: 0x0004, 0x4567: 0x0004, 0x4568: 0x0004, 0x4569: 0x0004,
	0x456a: 0x0004, 0x456b: 0x0004, 0x456c: 0x0004,
	0x4570: 0x0004, 0x4571: 0x0004, 0x4572: 0x0004, 0x4573: 0x0004,
	// Block 0x116, offset 0x4580
	0x4580: 0x0004, 0x4581: 0x0004, 0x4582: 0x0004, 0x4583: 0x0004, 0x4584: 0x0004, 0x4585: 0x0004,
	0x4586: 0x0004, 0x4587: 0x0004, 0x4588: 0x0004, 0x4589: 0x0004, 0x458a: 0x0004, 0x458b: 0x0004,
	0x458c: 0x0004, 0x458d: 0x0004, 0x458e: 0x0004, 0x458f: 0x0004, 0x4590: 0x0004, 0x4591: 0x0004,
	0x4592: 0x0004, 0x4593: 0x0004, 0x4594: 0x0004,
	// Block 0x117, offset 0x45c0
	0x45c0: 0x0004, 0x45c1: 0x0004, 0x45c2: 0x0004, 0x45c3: 0x0004, 0x45c4: 0x0004, 0x45c5: 0x0004,
	0x45c6: 0x0004, 0x45c7: 0x0004, 0x45c8: 0x0004, 0x45c9: 0x0004, 0x45ca: 0x0004, 0x45cb: 0x0004,
	0x45d0: 0x0004, 0x45d1: 0x0004,
	0x45d2: 0x0004, 0x45d3: 0x0004, 0x45d4: 0x0004, 0x45d5: 0x0004, 0x45d6: 0x0004, 0x45d7: 0x0004,
	0x45d8: 0x0004, 0x45d9: 0x0004, 0x45da: 0x0004, 0x45db: 0x0004, 0x45dc: 0x0004, 0x45dd: 0x0004,
	0x45de: 0x0004, 0x45df: 0x0004, 0x45e0: 0x0004, 0x45e1: 0x0004, 0x45e2: 0x0004, 0x45e3: 0x0004,
	0x45e4: 0x0004, 0x45e5: 0x0004, 0x45e6: 0x0004, 0x45e7: 0x0004, 0x45e8: 0x0004, 0x45e9: 0x0004,
	0x45ea: 0x0004, 0x45eb: 0x0004, 0x45ec: 0x0004, 0x45ed: 0x0004, 0x45ee: 0x0004, 0x45ef: 0x0004,
	0x45f0: 0x0004, 0x45f1: 0x0004, 0x45f2: 0x0004, 0x45f3: 0x0004, 0x45f4: 0x0004, 0x45f5: 0x0004,
	0x45f6: 0x0004, 0x45f7: 0x0004, 0x45f8: 0x0004, 0x45f9: 0x0004, 0x45fa: 0x0004, 0x45fb: 0x0004,
	0x45fc: 0x0004, 0x45fd: 0x0004, 0x45fe: 0x0004, 0x45ff: 0x0004,
	// Block 0x118, offset 0x4600
	0x4600: 0x0004, 0x4601: 0x0004, 0x4602: 0x0004, 0x4603: 0x0004, 0x4604: 0x0004, 0x4605: 0x0004,
	0x4606: 0x0004, 0x4607: 0x0004,
	0x4610: 0x0004, 0x4611: 0x0004,
	0x4612: 0x0004, 0x4613: 0x0004, 0x4614: 0x0004, 0x4615: 0x0004, 0x4616: 0x0004, 0x4617: 0x0004,
	0x4618: 0x0004, 0x4619: 0x0004,
	0x4620: 0x0004, 0x4621: 0x0004, 0x4622: 0x0004, 0x4623: 0x0004,
	0x4624: 0x0004, 0x4625: 0x0004, 0x4626: 0x0004, 0x4627: 0x0004, 0x4628: 0x0004, 0x4629: 0x0004,
	0x462a: 0x0004, 0x462b: 0x0004, 0x462c: 0x0004, 0x462d: 0x0004, 0x462e: 0x0004, 0x462f: 0x0004,
	0x4630: 0x0004, 0x4631: 0x0004, 0x4632: 0x0004, 0x4633: 0x0004, 0x4634: 0x0004, 0x4635: 0x0004,
	0x4636: 0x0004, 0x4637: 0x0004, 0x4638: 0x0004, 0x4639: 0x0004, 0x463a: 0x0004, 0x463b: 0x0004,
	0x463c: 0x0004, 0x463d: 0x0004, 0x463e: 0x0004, 0x463f: 0x0004,
	// Block 0x119, offset 0x4640
	0x4640: 0x0004, 0x4641: 0x0004, 0x4642: 0x0004, 0x4643: 0x0004, 0x4644: 0x0004, 0x4645: 0x0004,
	0x4646: 0x0004, 0x4647: 0x0004,
	0x4650: 0x0004, 0x4651: 0x0004,
	0x4652: 0x0004, 0x4653: 0x0004, 0x4654: 0x0004, 0x4655: 0x0004, 0x4656: 0x0004, 0x4657: 0x0004,
	0x4658: 0x0004, 0x4659: 0x0004, 0x465a: 0x0004, 0x465b: 0x0004, 0x465c: 0x0004, 0x465d: 0x0004,
	0x465e: 0x0004, 0x465f: 0x0004, 0x4660: 0x0004, 0x4661: 0x0004, 0x4662: 0x0004, 0x4663: 0x0004,
	0x4664: 0x0004, 0x4665: 0x0004, 0x4666: 0x0004, 0x4667: 0x0004, 0x4668: 0x0004, 0x4669: 0x0004,
	0x466a: 0x0004, 0x466b: 0x0004, 0x466c: 0x0004, 0x466d: 0x0004,
	// Block 0x11a, offset 0x4680
	0x4690: 0x0004, 0x4691: 0x0004,
	0x4692: 0x0004, 0x4693: 0x0004, 0x4694: 0x0004, 0x4695: 0x0004, 0x4696: 0x0004, 0x4697: 0x0004,
	0x4698: 0x0004,
	// Block 0x11b, offset 0x46c0
	0x46c0: 0x0004, 0x46c1: 0x0004, 0x46c2: 0x0004, 0x46c3: 0x0004, 0x46c4: 0x0004,
	// Block 0x11c, offset 0x4700
	0x4700: 0x0004,
	// Block 0x11d, offset 0x4740
	0x4740: 0x0005, 0x4741: 0x0005, 0x4742: 0x0005, 0x4743: 0x0005, 0x4744: 0x0005, 0x4745: 0x0005,
	0x4746: 0x0005, 0x4747: 0x0005, 0x4748: 0x0005, 0x4749: 0x0005, 0x474a: 0x0005, 0x474b: 0x0005,
	0x474c: 0x0005, 0x474d: 0x0005, 0x474e: 0x0005, 0x474f: 0x0005, 0x4750: 0x0005, 0x4751: 0x0005,
	0x4752: 0x0005, 0x4753: 0x0005, 0x4754: 0x0005, 0x4755: 0x0005, 0x4756: 0x0005,
	// Block 0x11e, offset 0x4780
	0x4780: 0x0005, 0x4781: 0x0005, 0x4782: 0x0005, 0x4783: 0x0005, 0x4784: 0x0005, 0x4785: 0x0005,
	0x4786: 0x0005, 0x4787: 0x0005, 0x4788: 0x0005, 0x4789: 0x0005, 0x478a: 0x0005, 0x478b: 0x0005,
	0x478c: 0x0005, 0x478d: 0x0005, 0x478e: 0x0005, 0x478f: 0x0005, 0x4790: 0x0005, 0x4791: 0x0005,
	0x4792: 0x0005, 0x4793: 0x0005, 0x4794: 0x0005, 0x4795: 0x0005, 0x4796: 0x0005, 0x4797: 0x0005,
	0x4798: 0x0005, 0x4799: 0x0005, 0x479a: 0x0005, 0x479b: 0x0005, 0x479c: 0x0005, 0x479d: 0x0005,
	0x479e: 0x0005, 0x479f: 0x0005, 0x47a0: 0x0005, 0x47a1: 0x0005, 0x47a2: 0x0005, 0x47a3: 0x0005,
	0x47a4: 0x0005, 0x47a5: 0x0005, 0x47a6: 0x0005, 0x47a7: 0x0005, 0x47a8: 0x0005, 0x47a9: 0x0005,
	0x47aa: 0x0005, 0x47ab: 0x0005, 0x47ac: 0x0005, 0x47ad: 0x0005, 0x47ae: 0x0005, 0x47af: 0x0005,
	0x47b0: 0x0005, 0x47b1: 0x0005, 0x47b2: 0x0005, 0x47b3: 0x0005, 0x47b4: 0x0005,
	// Block 0x11f, offset 0x47c0
	0x47c0: 0x0005, 0x47c1: 0x0005, 0x47c2: 0x0005, 0x47c3: 0x0005, 0x47c4: 0x0005, 0x47c5: 0x0005,
	0x47c6: 0x0005, 0x47c7: 0x0005, 0x47c8: 0x0005, 0x47c9: 0x0005, 0x47ca: 0x0005, 0x47cb: 0x0005,
	0x47cc: 0x0005, 0x47cd: 0x0005, 0x47ce: 0x0005, 0x47cf: 0x0005, 0x47d0: 0x0005, 0x47d1: 0x0005,
	0x47d2: 0x0005, 0x47d3: 0x0005, 0x47d4: 0x0005, 0x47d5: 0x0005, 0x47d6: 0x0005, 0x47d7: 0x0005,
	0x47d8: 0x0005, 0x47d9: 0x0005, 0x47da: 0x0005, 0x47db: 0x0005, 0x47dc: 0x0005, 0x47dd: 0x0005,
	0x47e0: 0x0005, 0x47e1: 0x0005, 0x47e2: 0x0005, 0x47e3: 0x0005,
	0x47e4: 0x0005, 0x47e5: 0x0005, 0x47e6: 0x0005, 0x47e7: 0x0005, 0x47e8: 0x0005, 0x47e9: 0x0005,
	0x47ea: 0x0005, 0x47eb: 0x0005, 0x47ec: 0x0005, 0x47ed: 0x0005, 0x47ee: 0x0005, 0x47ef: 0x0005,
	0x47f0: 0x0005, 0x47f1: 0x0005, 0x47f2: 0x0005, 0x47f3: 0x0005, 0x47f4: 0x0005, 0x47f5: 0x0005,
	0x47f6: 0x0005, 0x47f7: 0x0005, 0x47f8: 0x0005, 0x47f9: 0x0005, 0x47fa: 0x0005, 0x47fb: 0x0005,
	0x47fc: 0x0005, 0x47fd: 0x0005, 0x47fe: 0x0005, 0x47ff: 0x0005,
	// Block 0x120, offset 0x4800
	0x4800: 0x0005, 0x4801: 0x0005, 0x4802: 0x0005, 0x4803: 0x0005, 0x4804: 0x0005, 0x4805: 0x0005,
	0x4806: 0x0005, 0x4807: 0x0005, 0x4808: 0x0005, 0x4809: 0x0005, 0x480a: 0x0005, 0x480b: 0x0005,
	0x480c: 0x0005, 0x480d: 0x0005, 0x480e: 0x0005, 0x480f: 0x0005, 0x4810: 0x0005, 0x4811: 0x0005,
	0x4812: 0x0005, 0x4813: 0x0005, 0x4814: 0x0005, 0x4815: 0x0005, 0x4816: 0x0005, 0x4817: 0x0005,
	0x4818: 0x0005, 0x4819: 0x0005, 0x481a: 0x0005, 0x481b: 0x0005, 0x481c: 0x0005, 0x481d: 0x0005,
	0x481e: 0x0005, 0x481f: 0x0005, 0x4820: 0x0005, 0x4821: 0x0005,
	// Block 0x121, offset 0x4840
	0x4840: 0x0004, 0x4841: 0x0004, 0x4842: 0x0004, 0x4843: 0x0004, 0x4844: 0x0004, 0x4845: 0x0004,
	0x4846: 0x0004, 0x4847: 0x0004, 0x4848: 0x0004, 0x4849: 0x0004, 0x484a: 0x0004, 0x484b: 0x0004,
	0x484c: 0x0004, 0x484d: 0x0004, 0x484e: 0x0004, 0x484f: 0x0004, 0x4850: 0x0004, 0x4851: 0x0004,
	0x4852: 0x0004, 0x4853: 0x0004, 0x4854: 0x0004, 0x4855: 0x0004, 0x4856: 0x0004, 0x4857: 0x0004,
	0x4858: 0x0004, 0x4859: 0x0004, 0x485a: 0x0004, 0x485b: 0x0004, 0x485c: 0x0004, 0x485d: 0x0004,
	// Block 0x122, offset 0x4880
	0x4881: 0x0001,
	0x48a0: 0x0001, 0x48a1: 0x0001, 0x48a2: 0x0001, 0x48a3: 0x0001,
	0x48a4: 0x0001, 0x48a5: 0x0001, 0x48a6: 0x0001, 0x48a7: 0x0001, 0x48a8: 0x0001, 0x48a9: 0x0001,
	0x48aa: 0x0001, 0x48ab: 0x0001, 0x48ac: 0x0001, 0x48ad: 0x0001, 0x48ae: 0x0001, 0x48af: 0x0001,
	0x48b0: 0x0001, 0x48b1: 0x0001, 0x48b2: 0x0001, 0x48b3: 0x0001, 0x48b4: 0x0001, 0x48b5: 0x0001,
	0x48b6: 0x0001, 0x48b7: 0x0001, 0x48b8: 0x0001, 0x48b9: 0x0001, 0x48ba: 0x0001, 0x48bb: 0x0001,
	0x48bc: 0x0001, 0x48bd: 0x0001, 0x48be: 0x0001, 0x48bf: 0x0001,
	// Block 0x123, offset 0x48c0
	0x48c0: 0x0001, 0x48c1: 0x0001, 0x48c2: 0x0001, 0x48c3: 0x0001, 0x48c4: 0x0001, 0x48c5: 0x0001,
	0x48c6: 0x0001, 0x48c7: 0x0001, 0x48c8: 0x0001, 0x48c9: 0x0001, 0x48ca: 0x0001, 0x48cb: 0x0001,
	0x48cc: 0x0001, 0x48cd: 0x0001, 0x48ce: 0x0001, 0x48cf: 0x0001, 0x48d0: 0x0001, 0x48d1: 0x0001,
	0x48d2: 0x0001, 0x48d3: 0x0001, 0x48d4: 0x0001, 0x48d5: 0x0001, 0x48d6: 0x0001, 0x48d7: 0x0001,
	0x48d8: 0x0001, 0x48d9: 0x0001, 0x48da: 0x0001, 0x48db: 0x0001, 0x48dc: 0x0001, 0x48dd: 0x0001,
	0x48de: 0x0001, 0x48df: 0x0001, 0x48e0: 0x0001, 0x48e1: 0x0001, 0x48e2: 0x0001, 0x48e3: 0x0001,
	0x48e4: 0x0001, 0x48e5: 0x0001, 0x48e6: 0x0001, 0x48e7: 0x0001, 0x48e8: 0x0001, 0x48e9: 0x0001,
	0x48ea: 0x0001, 0x48eb: 0x0001, 0x48ec: 0x0001, 0x48ed: 0x0001, 0x48ee: 0x0001, 0x48ef: 0x0001,
	// Block 0x124, offset 0x4900
	0x4900: 0x0001, 0x4901: 0x0001, 0x4902: 0x0001, 0x4903: 0x0001, 0x4904: 0x0001, 0x4905: 0x0001,
	0x4906: 0x0001, 0x4907: 0x0001, 0x4908: 0x0001, 0x4909: 0x0001, 0x490a: 0x0001, 0x490b: 0x0001,
	0x490c: 0x0001, 0x490d: 0x0001, 0x490e: 0x0001, 0x490f: 0x0001, 0x4910: 0x0001, 0x4911: 0x0001,
	0x4912: 0x0001, 0x4913: 0x0001, 0x4914: 0x0001, 0x4915: 0x0001, 0x4916: 0x0001, 0x4917: 0x0001,
	0x4918: 0x0001, 0x4919: 0x0001, 0x491a: 0x0001, 0x491b: 0x0001, 0x491c: 0x0001, 0x491d: 0x0001,
	0x491e: 0x0001, 0x491f: 0x0001, 0x4920: 0x0001, 0x4921: 0x0001, 0x4922: 0x0001, 0x4923: 0x0001,
	0x4924: 0x0001, 0x4925: 0x0001, 0x4926: 0x0001, 0x4927: 0x0001, 0x4928: 0x0001, 0x4929: 0x0001,
	0x492a: 0x0001, 0x492b: 0x0001, 0x492c: 0x0001, 0x492d: 0x0001, 0x492e: 0x0001, 0x492f: 0x0001,
	0x4930: 0x0001, 0x4931: 0x0001, 0x4932: 0x0001, 0x4933: 0x0001, 0x4934: 0x0001, 0x4935: 0x0001,
	0x4936: 0x0001, 0x4937: 0x0001, 0x4938: 0x0001, 0x4939: 0x0001, 0x493a: 0x0001, 0x493b: 0x0001,
	0x493c: 0x0001, 0x493d: 0x0001,
}

// derivedPropertiesIndex: 34 blocks, 2176 entries, 4352 bytes
// Block 0 is the zero block.
var derivedPropertiesIndex = [2176]uint16{
	// Block 0x0, offset 0x0
	// Block 0x1, offset 0x40
	// Block 0x2, offset 0x80
	// Block 0x3, offset 0xc0
	0xc2: 0x01, 0xc3: 0x02, 0xc4: 0x03, 0xc5: 0x04, 0xc6: 0x05, 0xc7: 0x06,
	0xc8: 0x05, 0xc9: 0x05, 0xca: 0x07, 0xcb: 0x08, 0xcc: 0x05, 0xcd: 0x09, 0xce: 0x0a, 0xcf: 0x0b,
	0xd0: 0x05, 0xd1: 0x05, 0xd2: 0x0c, 0xd3: 0x05, 0xd4: 0x0d, 0xd5: 0x0e, 0xd6: 0x0f, 0xd7: 0x10,
	0xd8: 0x11, 0xd9: 0x12, 0xda: 0x05, 0xdb: 0x13, 0xdc: 0x14, 0xdd: 0x15, 0xde: 0x16, 0xdf: 0x17,
	0xe0: 0x02, 0xe1: 0x03, 0xe2: 0x04, 0xe3: 0x05, 0xe4: 0x06, 0xe5: 0x07, 0xe6: 0x07, 0xe7: 0x07,
	0xe8: 0x07, 0xe9: 0x08, 0xea: 0x09, 0xeb: 0x07, 0xec: 0x07, 0xed: 0x0a, 0xee: 0x0b, 0xef: 0x0c,
	0xf0: 0x1b, 0xf3: 0x1e, 0xf4: 0x1f,
	// Block 0x4, offset 0x100
	0x120: 0x18, 0x121: 0x19, 0x122: 0x1a, 0x123: 0x1b, 0x124: 0x05, 0x125: 0x1c, 0x126: 0x1d, 0x127: 0x1e,
	0x128: 0x1f, 0x129: 0x20, 0x12a: 0x21, 0x12b: 0x22, 0x12c: 0x23, 0x12d: 0x24, 0x12e: 0x25, 0x12f: 0x26,
	0x130: 0x27, 0x131: 0x28, 0x132: 0x29, 0x133: 0x2a, 0x134: 0x2b, 0x135: 0x2c, 0x136: 0x2d, 0x137: 0x2e,
	0x138: 0x2f, 0x139: 0x30, 0x13a: 0x31, 0x13b: 0x32, 0x13c: 0x33, 0x13d: 0x34, 0x13e: 0x35, 0x13f: 0x36,
	// Block 0x5, offset 0x140
	0x140: 0x05, 0x141: 0x37, 0x142: 0x38, 0x143: 0x39, 0x144: 0x3a, 0x145: 0x3a, 0x146: 0x3a, 0x147: 0x3a,
	0x148: 0x05, 0x149: 0x3b, 0x14a: 0x3c, 0x14b: 0x3d, 0x14c: 0x3e, 0x14d: 0x3f, 0x14e: 0x40, 0x14f: 0x41,
	0x150: 0x42, 0x151: 0x05, 0x152: 0x05, 0x153: 0x05, 0x154: 0x05, 0x155: 0x05, 0x156: 0x05, 0x157: 0x05,
	0x158: 0x05, 0x159: 0x43, 0x15a: 0x44, 0x15b: 0x45, 0x15c: 0x46, 0x15d: 0x47, 0x15e: 0x48, 0x15f: 0x49,
	0x160: 0x4a, 0x161: 0x4b, 0x162: 0x4c, 0x163: 0x4d, 0x164: 0x4e, 0x165: 0x4f, 0x166: 0x50, 0x167: 0x51,
	0x168: 0x52, 0x169: 0x53, 0x16a: 0x54, 0x16c: 0x05, 0x16d: 0x55, 0x16e: 0x05, 0x16f: 0x56,
	0x170: 0x57, 0x171: 0x58, 0x173: 0x59, 0x174: 0x5a, 0x175: 0x5b, 0x176: 0x5c, 0x177: 0x5d,
	0x178: 0x05, 0x179: 0x05, 0x17a: 0x5e, 0x17b: 0x05, 0x17c: 0x5f, 0x17d: 0x60, 0x17e: 0x61, 0x17f: 0x62,
	// Block 0x6, offset 0x180
	0x180: 0x63, 0x181: 0x64, 0x182: 0x65, 0x183: 0x66, 0x184: 0x67, 0x185: 0x68, 0x186: 0x69, 0x187: 0x6a,
	0x188: 0x6a, 0x189: 0x6a, 0x18a: 0x6a, 0x18b: 0x6a, 0x18c: 0x6a, 0x18d: 0x6a, 0x18e: 0x6a, 0x18f: 0x6b,
	0x190: 0x6c, 0x191: 0x6d, 0x192: 0x6a, 0x193: 0x6a, 0x194: 0x6a, 0x195: 0x6a, 0x196: 0x6a, 0x197: 0x6a,
	0x198: 0x6a, 0x199: 0x6a, 0x19a: 0x6a, 0x19b: 0x6a, 0x19c: 0x6a, 0x19d: 0x6a, 0x19e: 0x6a, 0x19f: 0x6a,
	0x1a0: 0x6a, 0x1a1: 0x6a, 0x1a2: 0x6a, 0x1a3: 0x6a, 0x1a4: 0x6a, 0x1a5: 0x6a, 0x1a6: 0x6a, 0x1a7: 0x6a,
	0x1a8: 0x6a, 0x1a9: 0x6a, 0x1aa: 0x6a, 0x1ab: 0x6a, 0x1ac: 0x6a, 0x1ad: 0x6e, 0x1ae: 0x6f, 0x1af: 0x70,
	0x1b0: 0x71, 0x1b1: 0x72, 0x1b2: 0x05, 0x1b3: 0x73, 0x1b4: 0x74, 0x1b5: 0x75, 0x1b6: 0x76, 0x1b7: 0x77,
	0x1b8: 0x78, 0x1b9: 0x79, 0x1ba: 0x7a, 0x1bb: 0x7b, 0x1bc: 0x6a, 0x1bd: 0x6a, 0x1be: 0x6a, 0x1bf: 0x7c,
	// Block 0x7, offset 0x1c0
	0x1c0: 0x7d, 0x1c1: 0x7e, 0x1c2: 0x7f, 0x1c3: 0x80, 0x1c4: 0x81, 0x1c5: 0x82, 0x1c6: 0x83, 0x1c7: 0x84,
	0x1c8: 0x85, 0x1c9: 0x6a, 0x1ca: 0x6a, 0x1cb: 0x86, 0x1cc: 0x6a, 0x1cd: 0x6a, 0x1ce: 0x6a, 0x1cf: 0x6a,
	0x1d0: 0x05, 0x1d1: 0x05, 0x1d2: 0x05, 0x1d3: 0x05, 0x1d4: 0x05, 0x1d5: 0x05, 0x1d6: 0x05, 0x1d7: 0x05,
	0x1d8: 0x05, 0x1d9: 0x05, 0x1da: 0x05, 0x1db: 0x05, 0x1dc: 0x05, 0x1dd: 0x05, 0x1de: 0x05, 0x1df: 0x05,
	0x1e0: 0x05, 0x1e1: 0x05, 0x1e2: 0x05, 0x1e3: 0x05, 0x1e4: 0x05, 0x1e5: 0x05, 0x1e6: 0x05, 0x1e7: 0x05,
	0x1e8: 0x05, 0x1e9: 0x05, 0x1ea: 0x05, 0x1eb: 0x05, 0x1ec: 0x05, 0x1ed: 0x05, 0x1ee: 0x05, 0x1ef: 0x05,
	0x1f0: 0x05, 0x1f1: 0x05, 0x1f2: 0x05, 0x1f3: 0x05, 0x1f4: 0x05, 0x1f5: 0x05, 0x1f6: 0x05, 0x1f7: 0x05,
	0x1f8: 0x05, 0x1f9: 0x05, 0x1fa: 0x05, 0x1fb: 0x05, 0x1fc: 0x05, 0x1fd: 0x05, 0x1fe: 0x05, 0x1ff: 0x05,
	// Block 0x8, offset 0x200
	0x200: 0x05, 0x201: 0x05, 0x202: 0x05, 0x203: 0x05, 0x204: 0x05, 0x205: 0x05, 0x206: 0x05, 0x207: 0x05,
	0x208: 0x05, 0x209: 0x05, 0x20a: 0x05, 0x20b: 0x05, 0x20c: 0x05, 0x20d: 0x05, 0x20e: 0x05, 0x20f: 0x05,
	0x210: 0x05, 0x211: 0x05, 0x212: 0x05, 0x213: 0x05, 0x214: 0x05, 0x215: 0x05, 0x216: 0x05, 0x217: 0x05,
	0x218: 0x05, 0x219: 0x05, 0x21a: 0x05, 0x21b: 0x05, 0x21c: 0x05, 0x21d: 0x05, 0x21e: 0x05, 0x21f: 0x05,
	0x220: 0x05, 0x221: 0x05, 0x222: 0x05, 0x223: 0x05, 0x224: 0x05, 0x225: 0x05, 0x226: 0x05, 0x227: 0x05,
	0x228: 0x05, 0x229: 0x05, 0x22a: 0x05, 0x22b: 0x05, 0x22c: 0x05, 0x22d: 0x05, 0x22e: 0x05, 0x22f: 0x05,
	0x230: 0x05, 0x231: 0x05, 0x232: 0x05, 0x233: 0x05, 0x234: 0x05, 0x235: 0x05, 0x236: 0x4d, 0x237: 0x6a,
	0x238: 0x05, 0x239: 0x05, 0x23a: 0x05, 0x23b: 0x05, 0x23c: 0x05, 0x23d: 0x05, 0x23e: 0x05, 0x23f: 0x05,
	// Block 0x9, offset 0x240
	0x240: 0x05, 0x241: 0x05, 0x242: 0x05, 0x243: 0x05, 0x244: 0x05, 0x245: 0x05, 0x246: 0x05, 0x247: 0x05,
	0x248: 0x05, 0x249: 0x05, 0x24a: 0x05, 0x24b: 0x05, 0x24c: 0x05, 0x24d: 0x05, 0x24e: 0x05, 0x24f: 0x05,
	0x250: 0x05, 0x251: 0x05, 0x252: 0x05, 0x253: 0x05, 0x254: 0x05, 0x255: 0x05, 0x256: 0x05, 0x257: 0x05,
	0x258: 0x05, 0x259: 0x05, 0x25a: 0x05, 0x25b: 0x05, 0x25c: 0x05, 0x25d: 0x05, 0x25e: 0x05, 0x25f: 0x05,
	0x260: 0x05, 0x261: 0x05, 0x262: 0x05, 0x263: 0x05, 0x264: 0x05, 0x265: 0x05, 0x266: 0x05, 0x267: 0x05,
	0x268: 0x05, 0x269: 0x05, 0x26a: 0x05, 0x26b: 0x05, 0x26c: 0x05, 0x26d: 0x05, 0x26e: 0x05, 0x26f: 0x05,
	0x270: 0x05, 0x271: 0x05, 0x272: 0x05, 0x273: 0x05, 0x274: 0x05, 0x275: 0x05, 0x276: 0x05, 0x277: 0x05,
	0x278: 0x05, 0x279: 0x05, 0x27a: 0x05, 0x27b: 0x05, 0x27c: 0x05, 0x27d: 0x05, 0x27e: 0x05, 0x27f: 0x05,
	// Block 0xa, offset 0x280
	0x280: 0x05, 0x281: 0x05, 0x282: 0x05, 0x283: 0x05, 0x284: 0x05, 0x285: 0x05, 0x286: 0x05, 0x287: 0x05,
	0x288: 0x05, 0x289: 0x05, 0x28a: 0x05, 0x28b: 0x05, 0x28c: 0x05, 0x28d: 0x05, 0x28e: 0x05, 0x28f: 0x05,
	0x290: 0x05, 0x291: 0x05, 0x292: 0x05, 0x293: 0x05, 0x294: 0x05, 0x295: 0x05, 0x296: 0x05, 0x297: 0x05,
	0x298: 0x05, 0x299: 0x05, 0x29a: 0x05, 0x29b: 0x05, 0x29c: 0x05, 0x29d: 0x05, 0x29e: 0x05, 0x29f: 0x05,
	0x2a0: 0x05, 0x2a1: 0x05, 0x2a2: 0x05, 0x2a3: 0x05, 0x2a4: 0x05, 0x2a5: 0x05, 0x2a6: 0x05, 0x2a7: 0x05,
	0x2a8: 0x05, 0x2a9: 0x05, 0x2aa: 0x05, 0x2ab: 0x05, 0x2ac: 0x05, 0x2ad: 0x05, 0x2ae: 0x05, 0x2af: 0x05,
	0x2b0: 0x05, 0x2b1: 0x05, 0x2b2: 0x05, 0x2b3: 0x05, 0x2b4: 0x05, 0x2b5: 0x05, 0x2b6: 0x05, 0x2b7: 0x05,
	0x2b8: 0x05, 0x2b9: 0x05, 0x2ba: 0x05, 0x2bb: 0x05, 0x2bc: 0x05, 0x2bd: 0x05, 0x2be: 0x05, 0x2bf: 0x87,
	// Block 0xb, offset 0x2c0
	0x2c0: 0x05, 0x2c1: 0x05, 0x2c2: 0x05, 0x2c3: 0x05, 0x2c4: 0x05, 0x2c5: 0x05, 0x2c6: 0x05, 0x2c7: 0x05,
	0x2c8: 0x05, 0x2c9: 0x05, 0x2ca: 0x05, 0x2cb: 0x05, 0x2cc: 0x05, 0x2cd: 0x05, 0x2ce: 0x05, 0x2cf: 0x05,
	0x2d0: 0x05, 0x2d1: 0x05, 0x2d2: 0x88, 0x2d3: 0x89, 0x2d4: 0x05, 0x2d5: 0x05, 0x2d6: 0x05, 0x2d7: 0x05,
	0x2d8: 0x8a, 0x2d9: 0x8b, 0x2da: 0x8c, 0x2db: 0x8d, 0x2dc: 0x8e, 0x2dd: 0x8f, 0x2de: 0x90, 0x2df: 0x91,
	0x2e0: 0x92, 0x2e1: 0x93, 0x2e2: 0x05, 0x2e3: 0x94, 0x2e4: 0x95, 0x2e5: 0x96, 0x2e6: 0x05, 0x2e7: 0x97,
	0x2e8: 0x98, 0x2e9: 0x99, 0x2ea: 0x05, 0x2eb: 0x9a, 0x2ec: 0x9b, 0x2ed: 0x9c, 0x2ee: 0x05, 0x2ef: 0x9d,
	0x2f0: 0x05, 0x2f1: 0x05, 0x2f2: 0x05, 0x2f3: 0x05, 0x2f4: 0x05, 0x2f5: 0x05, 0x2f6: 0x05, 0x2f7: 0x05,
	0x2f8: 0x05, 0x2f9: 0x05, 0x2fa: 0x05, 0x2fb: 0x05, 0x2fc: 0x05, 0x2fd: 0x05, 0x2fe: 0x05, 0x2ff: 0x05,
	// Block 0xc, offset 0x300
	0x300: 0x05, 0x301: 0x05, 0x302: 0x05, 0x303: 0x05, 0x304: 0x05, 0x305: 0x05, 0x306: 0x05, 0x307: 0x05,
	0x308: 0x05, 0x309: 0x05, 0x30a: 0x05, 0x30b: 0x05, 0x30c: 0x05, 0x30d: 0x05, 0x30e: 0x05, 0x30f: 0x05,
	0x310: 0x05, 0x311: 0x05, 0x312: 0x05, 0x313: 0x05, 0x314: 0x05, 0x315: 0x05, 0x316: 0x05, 0x317: 0x05,
	0x318: 0x05, 0x319: 0x05, 0x31a: 0x05, 0x31b: 0x05, 0x31c: 0x05, 0x31d: 0x05, 0x31e: 0x9e, 0x31f: 0x9f,
	// Block 0xd, offset 0x340
	0x340: 0x3a, 0x341: 0x3a, 0x342: 0x3a, 0x343: 0x3a, 0x344: 0x3a, 0x345: 0x3a, 0x346: 0x3a, 0x347: 0x3a,
	0x348: 0x3a, 0x349: 0x3a, 0x34a: 0x3a, 0x34b: 0x3a, 0x34c: 0x3a, 0x34d: 0x3a, 0x34e: 0x3a, 0x34f: 0x3a,
	0x350: 0x3a, 0x351: 0x3a, 0x352: 0x3a, 0x353: 0x3a, 0x354: 0x3a, 0x355: 0x3a, 0x356: 0x3a, 0x357: 0x3a,
	0x358: 0x3a, 0x359: 0x3a, 0x35a: 0x3a, 0x35b: 0x3a, 0x35c: 0x3a, 0x35d: 0x3a, 0x35e: 0x3a, 0x35f: 0x3a,
	0x360: 0x3a, 0x361: 0x3a, 0x362: 0x3a, 0x363: 0x3a, 0x364: 0x3a, 0x365: 0x3a, 0x366: 0x3a, 0x367: 0x3a,
	0x368: 0x3a, 0x369: 0x3a, 0x36a: 0x3a, 0x36b: 0x3a, 0x36c: 0x3a, 0x36d: 0x3a, 0x36e: 0x3a, 0x36f: 0x3a,
	0x370: 0x3a, 0x371: 0x3a, 0x372: 0x3a, 0x373: 0x3a, 0x374: 0x3a, 0x375: 0x3a, 0x376: 0x3a, 0x377: 0x3a,
	0x378: 0x3a, 0x379: 0x3a, 0x37a: 0x3a, 0x37b: 0x3a, 0x37c: 0x3a, 0x37d: 0x3a, 0x37e: 0x3a, 0x37f: 0x3a,
	// Block 0xe, offset 0x380
	0x380: 0x3a, 0x381: 0x3a, 0x382: 0x3a, 0x383: 0x3a, 0x384: 0x3a, 0x385: 0x3a, 0x386: 0x3a, 0x387: 0x3a,
	0x388: 0x3a, 0x389: 0x3a, 0x38a: 0x3a, 0x38b: 0x3a, 0x38c: 0x3a, 0x38d: 0x3a, 0x38e: 0x3a, 0x38f: 0x3a,
	0x390: 0x3a, 0x391: 0x3a, 0x392: 0x3a, 0x393: 0x3a, 0x394: 0x3a, 0x395: 0x3a, 0x396: 0x3a, 0x397: 0x3a,
	0x398: 0x3a, 0x399: 0x3a, 0x39a: 0x3a, 0x39b: 0x3a, 0x39c: 0x3a, 0x39d: 0x3a, 0x39e: 0x3a, 0x39f: 0x3a,
	0x3a0: 0x3a, 0x3a1: 0x3a, 0x3a2: 0x3a, 0x3a3: 0x3a, 0x3a4: 0x6a, 0x3a5: 0x6a, 0x3a6: 0x6a, 0x3a7: 0x6a,
	0x3a8: 0xa0, 0x3a9: 0xa1, 0x3aa: 0x6a, 0x3ab: 0xa2, 0x3ac: 0xa3, 0x3ad: 0xa4, 0x3ae: 0x6a, 0x3af: 0xa5,
	0x3b0: 0x6a, 0x3b1: 0x6a, 0x3b2: 0x6a, 0x3b3: 0x6a, 0x3b4: 0x6a, 0x3b5: 0xa6, 0x3b6: 0xa7, 0x3b7: 0xa8,
	0x3b8: 0xa9, 0x3b9: 0xaa, 0x3ba: 0x6a, 0x3bb: 0xab, 0x3bc: 0xac, 0x3bd: 0x6a, 0x3be: 0xad, 0x3bf: 0xae,
	// Block 0xf, offset 0x3c0
	0x3c0: 0xaf, 0x3c1: 0xb0, 0x3c2: 0x05, 0x3c3: 0xb1, 0x3c4: 0xb2, 0x3c5: 0x6a, 0x3c6: 0xb3, 0x3c7: 0xb4,
	0x3ca: 0xb5, 0x3cb: 0xb6, 0x3cc: 0xb7, 0x3cd: 0xb8, 0x3ce: 0xb9, 0x3cf: 0xba,
	0x3d0: 0x05, 0x3d1: 0x05, 0x3d2: 0xbb, 0x3d4: 0xbc, 0x3d5: 0xbd,
	0x3d8: 0x05, 0x3d9: 0x05, 0x3da: 0x05, 0x3db: 0x05, 0x3dc: 0x98, 0x3dd: 0xbe,
	0x3e0: 0xbf, 0x3e1: 0xc0, 0x3e2: 0xc1, 0x3e3: 0xc2, 0x3e4: 0xc3, 0x3e6: 0xc4, 0x3e7: 0xa7,
	0x3e8: 0xc5, 0x3e9: 0xc6, 0x3ea: 0xc7, 0x3eb: 0xc8, 0x3ec: 0xc9, 0x3ed: 0xca, 0x3ee: 0xcb,
	0x3f0: 0x05, 0x3f1: 0xcc, 0x3f2: 0xcd, 0x3f3: 0xce,
	0x3f9: 0xcf,
	// Block 0x10, offset 0x400
	0x400: 0x05, 0x401: 0xd0, 0x402: 0xd1, 0x403: 0xd2, 0x404: 0xd3, 0x405: 0xd4, 0x406: 0x05, 0x407: 0xd5,
	0x408: 0xd6, 0x40a: 0xd7, 0x40b: 0xd8, 0x40c: 0xd9, 0x40d: 0xda,
	0x412: 0x05, 0x413: 0xdb, 0x416: 0xdc, 0x417: 0xdd,
	0x418: 0x05, 0x419: 0xde, 0x41a: 0x4b, 0x41b: 0xdf, 0x41c: 0xe0,
	0x422: 0xe1, 0x423: 0xe2,
	0x42b: 0xe3,
	// Block 0x11, offset 0x440
	0x440: 0x05, 0x441: 0x05, 0x442: 0x05, 0x443: 0x05, 0x444: 0x05, 0x445: 0x05, 0x446: 0x05, 0x447: 0x05,
	0x448: 0x05, 0x449: 0x05, 0x44a: 0x05, 0x44b: 0x05, 0x44c: 0x05, 0x44d: 0x05, 0x44e: 0xe4,
	0x450: 0x6a, 0x451: 0xe5, 0x452: 0x05, 0x453: 0x05, 0x454: 0x05, 0x455: 0xe6,
	// Block 0x12, offset 0x480
	0x480: 0x05, 0x481: 0x05, 0x482: 0x05, 0x483: 0x05, 0x484: 0x05, 0x485: 0x05, 0x486: 0x05, 0x487: 0x05,
	0x488: 0x05, 0x489: 0x05, 0x48a: 0x05, 0x48b: 0x05, 0x48c: 0x05, 0x48d: 0x05, 0x48e: 0x05, 0x48f: 0x05,
	0x490: 0xe7,
	// Block 0x13, offset 0x4c0
	0x4d0: 0x05, 0x4d1: 0x05, 0x4d2: 0x05, 0x4d3: 0x05, 0x4d4: 0x05, 0x4d5: 0x05, 0x4d6: 0x05, 0x4d7: 0x05,
	0x4d8: 0x05, 0x4d9: 0xe8,
	// Block 0x14, offset 0x500
	0x520: 0x05, 0x521: 0x05, 0x522: 0x05, 0x523: 0x05, 0x524: 0x05, 0x525: 0x05, 0x526: 0x05, 0x527: 0x05,
	0x528: 0xe3, 0x529: 0xe9, 0x52b: 0xea, 0x52c: 0xeb, 0x52d: 0xec, 0x52e: 0xed,
	0x53c: 0x05, 0x53d: 0xee, 0x53e: 0xef,
	// Block 0x15, offset 0x540
	0x540: 0xf0,
	0x570: 0x05, 0x571: 0xf1, 0x572: 0xf2,
	// Block 0x16, offset 0x580
	0x580: 0x6a, 0x581: 0x6a, 0x582: 0x6a, 0x583: 0xf3, 0x584: 0xf4, 0x585: 0xf5, 0x586: 0xf6, 0x587: 0xf7,
	0x588: 0x6a, 0x589: 0xf8, 0x58c: 0x6a, 0x58d: 0xf9,
	0x590: 0x6a, 0x591: 0xfa, 0x592: 0xfb, 0x593: 0xfc, 0x594: 0xfd, 0x595: 0xfe, 0x596: 0x6a, 0x597: 0x6a,
	0x598: 0x6a, 0x599: 0x6a, 0x59a: 0xff, 0x59b: 0x6a, 0x59c: 0x6a, 0x59d: 0x6a, 0x59e: 0x6a, 0x59f: 0x100,
	0x5a0: 0x6a, 0x5a1: 0x6a, 0x5a2: 0x6a, 0x5a3: 0x6a, 0x5a4: 0x6a, 0x5a5: 0x6a, 0x5a6: 0x6a, 0x5a7: 0x6a,
	0x5a8: 0x101, 0x5a9: 0x102, 0x5aa: 0x103,
	// Block 0x17, offset 0x5c0
	0x5e0: 0x05, 0x5e1: 0x05, 0x5e2: 0x05, 0x5e3: 0x104,
	0x5f8: 0x105, 0x5f9: 0x106, 0x5fa: 0x107, 0x5fb: 0x108,
	// Block 0x18, offset 0x600
	0x600: 0x109, 0x601: 0x6a, 0x602: 0x10a, 0x603: 0x10b, 0x604: 0x10c, 0x605: 0x109, 0x606: 0x10d, 0x607: 0x10e,
	0x608: 0x10f, 0x609: 0x110, 0x60c: 0x6a, 0x60d: 0x6a, 0x60e: 0x6a, 0x60f: 0x6a,
	0x610: 0x6a, 0x611: 0x6a, 0x612: 0x6a, 0x613: 0x6a, 0x614: 0x6a, 0x615: 0x111, 0x616: 0x112, 0x617: 0x6a,
	0x618: 0x6a, 0x619: 0x6a, 0x61a: 0x6a, 0x61b: 0x113, 0x61c: 0x6a, 0x61d: 0x7b, 0x61e: 0x6a, 0x61f: 0x114,
	0x620: 0x115, 0x621: 0x116, 0x622: 0x117, 0x624: 0x118, 0x626: 0x119, 0x627: 0x11a,
	// Block 0x19, offset 0x640
	0x640: 0x05, 0x641: 0x05, 0x642: 0x05, 0x643: 0x05, 0x644: 0x05, 0x645: 0x05, 0x646: 0x05, 0x647: 0x05,
	0x648: 0x05, 0x649: 0x05, 0x64a: 0x05, 0x64b: 0x05, 0x64c: 0x05, 0x64d: 0x05, 0x64e: 0x05, 0x64f: 0x05,
	0x650: 0x05, 0x651: 0x05, 0x652: 0x05, 0x653: 0x05, 0x654: 0x05, 0x655: 0x05, 0x656: 0x05, 0x657: 0x05,
	0x658: 0x05, 0x659: 0x05, 0x65a: 0x05, 0x65b: 0x11b, 0x65c: 0x05, 0x65d: 0x05, 0x65e: 0x05, 0x65f: 0x05,
	0x660: 0x05, 0x661: 0x05, 0x662: 0x05, 0x663: 0x05, 0x664: 0x05, 0x665: 0x05, 0x666: 0x05, 0x667: 0x05,
	0x668: 0x05, 0x669: 0x05, 0x66a: 0x05, 0x66b: 0x05, 0x66c: 0x05, 0x66d: 0x05, 0x66e: 0x05, 0x66f: 0x05,
	0x670: 0x05, 0x671: 0x05, 0x672: 0x05, 0x673: 0x05, 0x674: 0x05, 0x675: 0x05, 0x676: 0x05, 0x677: 0x05,
	0x678: 0x05, 0x679: 0x05, 0x67a: 0x05, 0x67b: 0x05, 0x67c: 0x05, 0x67d: 0x05, 0x67e: 0x05, 0x67f: 0x05,
	// Block 0x1a, offset 0x680
	0x680: 0x05, 0x681: 0x05, 0x682: 0x05, 0x683: 0x05, 0x684: 0x05, 0x685: 0x05, 0x686: 0x05, 0x687: 0x05,
	0x688: 0x05, 0x689: 0x05, 0x68a: 0x05, 0x68b: 0x05, 0x68c: 0x05, 0x68d: 0x05, 0x68e: 0x05, 0x68f: 0x05,
	0x690: 0x05, 0x691: 0x05, 0x692: 0x05, 0x693: 0x05, 0x694: 0x05, 0x695: 0x05, 0x696: 0x05, 0x697: 0x05,
	0x698: 0x05, 0x699: 0x05, 0x69a: 0x05, 0x69b: 0x05, 0x69c: 0x11c, 0x69d: 0x05, 0x69e: 0x05, 0x69f: 0x05,
	0x6a0: 0x11d, 0x6a1: 0x05, 0x6a2: 0x05, 0x6a3: 0x05, 0x6a4: 0x05, 0x6a5: 0x05, 0x6a6: 0x05, 0x6a7: 0x05,
	0x6a8: 0x05, 0x6a9: 0x05, 0x6aa: 0x05, 0x6ab: 0x05, 0x6ac: 0x05, 0x6ad: 0x05, 0x6ae: 0x05, 0x6af: 0x05,
	0x6b0: 0x05, 0x6b1: 0x05, 0x6b2: 0x05, 0x6b3: 0x05, 0x6b4: 0x05, 0x6b5: 0x05, 0x6b6: 0x05, 0x6b7: 0x05,
	0x6b8: 0x05, 0x6b9: 0x05, 0x6ba: 0x05, 0x6bb: 0x05, 0x6bc: 0x05, 0x6bd: 0x05, 0x6be: 0x05, 0x6bf: 0x05,
	// Block 0x1b, offset 0x6c0
	0x6c0: 0x05, 0x6c1: 0x05, 0x6c2: 0x05, 0x6c3: 0x05, 0x6c4: 0x05, 0x6c5: 0x05, 0x6c6: 0x05, 0x6c7: 0x05,
	0x6c8: 0x05, 0x6c9: 0x05, 0x6ca: 0x05, 0x6cb: 0x05, 0x6cc: 0x05, 0x6cd: 0x05, 0x6ce: 0x05, 0x6cf: 0x05,
	0x6d0: 0x05, 0x6d1: 0x05, 0x6d2: 0x05, 0x6d3: 0x05, 0x6d4: 0x05, 0x6d5: 0x05, 0x6d6: 0x05, 0x6d7: 0x05,
	0x6d8: 0x05, 0x6d9: 0x05, 0x6da: 0x05, 0x6db: 0x05, 0x6dc: 0x05, 0x6dd: 0x05, 0x6de: 0x05, 0x6df: 0x05,
	0x6e0: 0x05, 0x6e1: 0x05, 0x6e2: 0x05, 0x6e3: 0x05, 0x6e4: 0x05, 0x6e5: 0x05, 0x6e6: 0x05, 0x6e7: 0x05,
	0x6e8: 0x05, 0x6e9: 0x05, 0x6ea: 0x05, 0x6eb: 0x05, 0x6ec: 0x05, 0x6ed: 0x05, 0x6ee: 0x05, 0x6ef: 0x05,
	0x6f0: 0x05, 0x6f1: 0x05, 0x6f2: 0x05, 0x6f3: 0x05, 0x6f4: 0x05, 0x6f5: 0x05, 0x6f6: 0x05, 0x6f7: 0x05,
	0x6f8: 0x05, 0x6f9: 0x05, 0x6fa: 0x11e,
	// Block 0x1c, offset 0x700
	0x720: 0x6a, 0x721: 0x6a, 0x722: 0x6a, 0x723: 0x6a, 0x724: 0x6a, 0x725: 0x6a, 0x726: 0x6a, 0x727: 0x6a,
	0x728: 0x11f,
	// Block 0x1d, offset 0x740
	0x750: 0x0d, 0x751: 0x0e, 0x752: 0x0f, 0x753: 0x10, 0x754: 0x11, 0x756: 0x12,
	0x75b: 0x13, 0x75d: 0x14, 0x75e: 0x15, 0x75f: 0x16,
	0x760: 0x07, 0x761: 0x07, 0x762: 0x07, 0x763: 0x07, 0x764: 0x07, 0x765: 0x07, 0x766: 0x07, 0x767: 0x07,
	0x768: 0x07, 0x769: 0x07, 0x76a: 0x17, 0x76b: 0x18, 0x76c: 0x19, 0x76f: 0x1a,
	// Block 0x1e, offset 0x780
	0x780: 0x120, 0x781: 0x3a, 0x784: 0x3a, 0x785: 0x3a, 0x786: 0x3a, 0x787: 0x121,
	// Block 0x1f, offset 0x7c0
	0x7c0: 0x3a, 0x7c1: 0x3a, 0x7c2: 0x3a, 0x7c3: 0x3a, 0x7c4: 0x3a, 0x7c5: 0x3a, 0x7c6: 0x3a, 0x7c7: 0x3a,
	0x7c8: 0x3a, 0x7c9: 0x3a, 0x7ca: 0x3a, 0x7cb: 0x3a, 0x7cc: 0x3a, 0x7cd: 0x3a, 0x7ce: 0x3a, 0x7cf: 0x3a,
	0x7d0: 0x3a, 0x7d1: 0x3a, 0x7d2: 0x3a, 0x7d3: 0x3a, 0x7d4: 0x3a, 0x7d5: 0x3a, 0x7d6: 0x3a, 0x7d7: 0x3a,
	0x7d8: 0x3a, 0x7d9: 0x3a, 0x7da: 0x3a, 0x7db: 0x3a, 0x7dc: 0x3a, 0x7dd: 0x3a, 0x7de: 0x3a, 0x7df: 0x3a,
	0x7e0: 0x3a, 0x7e1: 0x3a, 0x7e2: 0x3a, 0x7e3: 0x3a, 0x7e4: 0x3a, 0x7e5: 0x3a, 0x7e6: 0x3a, 0x7e7: 0x3a,
	0x7e8: 0x3a, 0x7e9: 0x3a, 0x7ea: 0x3a, 0x7eb: 0x3a, 0x7ec: 0x3a, 0x7ed: 0x3a, 0x7ee: 0x3a, 0x7ef: 0x3a,
	0x7f0: 0x3a, 0x7f1: 0x3a, 0x7f2: 0x3a, 0x7f3: 0x3a, 0x7f4: 0x3a, 0x7f5: 0x3a, 0x7f6: 0x3a, 0x7f7: 0x3a,
	0x7f8: 0x3a, 0x7f9: 0x3a, 0x7fa: 0x3a, 0x7fb: 0x3a, 0x7fc: 0x3a, 0x7fd: 0x3a, 0x7fe: 0x3a, 0x7ff: 0x122,
	// Block 0x20, offset 0x800
	0x820: 0x1c,
	0x830: 0x0b, 0x831: 0x0b, 0x832: 0x0b, 0x833: 0x0b, 0x834: 0x0b, 0x835: 0x0b, 0x836: 0x0b, 0x837: 0x0b,
	0x838: 0x0b, 0x839: 0x0b, 0x83a: 0x0b, 0x83b: 0x0b, 0x83c: 0x0b, 0x83d: 0x0b, 0x83e: 0x0b, 0x83f: 0x1d,
	// Block 0x21, offset 0x840
	0x840: 0x0b, 0x841: 0x0b, 0x842: 0x0b, 0x843: 0x0b, 0x844: 0x0b, 0x845: 0x0b, 0x846: 0x0b, 0x847: 0x0b,
	0x848: 0x0b, 0x849: 0x0b, 0x84a: 0x0b, 0x84b: 0x0b, 0x84c: 0x0b, 0x84d: 0x0b, 0x84e: 0x0b, 0x84f: 0x1d,
}

// Total table size 23104 bytes (22KiB); checksum: 811C9DC5
