static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright Nigel Wetten                                                     \n"
" * Copyright 2000 Tim Copperfield <timecop@japan.co.jp>                       \n"
" * Copyright 2011 Hans Lo <hansshulo@gmail.com>                               \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (threshold, _(\"Threshold\"), 10.0)                           \n"
"    description(_(\"Higher values restrict the effect to fewer areas of the image\"))\n"
"    value_range (0, 100)                                                      \n"
"                                                                              \n"
"property_int (strength, _(\"Strength\"), 40)                                  \n"
"    description(_(\"Higher values increase the magnitude of the effect\"))    \n"
"    value_range(1,1000)                                                       \n"
"                                                                              \n"
"property_seed (seed, _(\"Random seed\"), rand)                                \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_C_SOURCE wind.c                                               \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gint x;                                                                     \n"
"  gint y;                                                                     \n"
"} pair;                                                                       \n"
"                                                                              \n"
"static guint     tuple_hash  (gconstpointer v);                               \n"
"static gboolean  tuple_equal (gconstpointer v1,                               \n"
"                              gconstpointer v2);                              \n"
"static guint                                                                  \n"
"tuple_hash (gconstpointer v)                                                  \n"
"{                                                                             \n"
"  const pair *data = v;                                                       \n"
"  return (g_int_hash (&data->x) ^ g_int_hash (&data->y));                     \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"tuple_equal (gconstpointer v1,                                                \n"
"             gconstpointer v2)                                                \n"
"{                                                                             \n"
"  const pair *data1 = v1;                                                     \n"
"  const pair *data2 = v2;                                                     \n"
"  return (g_int_equal (&data1->x, &data2->x) &&                               \n"
"          g_int_equal (&data1->y, &data2->y));                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"get_derivative (gfloat   *pixel1,                                             \n"
"                gfloat   *pixel2,                                             \n"
"                gfloat   *derivative)                                         \n"
"{                                                                             \n"
"  gint i;                                                                     \n"
"  for (i = 0; i < 4; i++)                                                     \n"
"    derivative[i] = pixel1[i] - pixel2[i];                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"threshold_exceeded (gfloat  *pixel1,                                          \n"
"                    gfloat  *pixel2,                                          \n"
"                    gfloat   threshold)                                       \n"
"{                                                                             \n"
"  gfloat derivative[4];                                                       \n"
"  gint i;                                                                     \n"
"  gfloat sum;                                                                 \n"
"                                                                              \n"
"  get_derivative (pixel1, pixel2, derivative);                                \n"
"                                                                              \n"
"  sum = 0.0;                                                                  \n"
"  for (i = 0; i < 4; i++)                                                     \n"
"    sum += derivative[i];                                                     \n"
"  return ((sum / 4.0) > (threshold/100.0));                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"calculate_bleed (GeglOperation *operation,                                    \n"
"                 GeglBuffer    *input)                                        \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle rectA, rectB;                                                 \n"
"  GeglBufferIterator *iter;                                                   \n"
"  gfloat max_length = (gfloat) o->strength;                                   \n"
"  gfloat threshold  = o->threshold;                                           \n"
"  GHashTable *bleed_table = o->user_data;                                     \n"
"                                                                              \n"
"  rectA = *gegl_operation_source_get_bounding_box (operation, \"input\");     \n"
"  rectA.width -= 3;                                                           \n"
"  rectB = rectA;                                                              \n"
"  rectB.x += 3;                                                               \n"
"                                                                              \n"
"  if (rectA.width <= 0)                                                       \n"
"    return;                                                                   \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (input,                                     \n"
"                                   &rectA,                                    \n"
"                                   0,                                         \n"
"                                   babl_format (\"RGBA float\"),              \n"
"                                   GEGL_ACCESS_READ,                          \n"
"                                   GEGL_ABYSS_NONE);                          \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (iter,                                             \n"
"                            input,                                            \n"
"                            &rectB,                                           \n"
"                            0,                                                \n"
"                            babl_format (\"RGBA float\"),                     \n"
"                            GEGL_ACCESS_READ,                                 \n"
"                            GEGL_ABYSS_NONE);                                 \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    {                                                                         \n"
"      gint ix, iy;                                                            \n"
"      gfloat *pixelsA = (gfloat *)iter->data[0];                              \n"
"      gfloat *pixelsB = (gfloat *)iter->data[1];                              \n"
"                                                                              \n"
"      for (ix = 0; ix < iter->roi[0].width; ix++)                             \n"
"        for (iy = 0; iy < iter->roi[0].height; iy++)                          \n"
"          {                                                                   \n"
"            gint idx = iy * iter->roi[0].width + ix * 4;                      \n"
"            if (threshold_exceeded (&pixelsA[idx], &pixelsB[idx], threshold)) \n"
"              {                                                               \n"
"                gint x = ix + iter->roi[0].x;                                 \n"
"                gint y = iy + iter->roi[0].y;                                 \n"
"                pair *k = g_new (pair, 1);                                    \n"
"                gint *v = g_new (gint, 1);                                    \n"
"                gint bleed_length = 1 + gegl_random_int_range (o->rand, x, y, 0, 0, 0, max_length);\n"
"                                                                              \n"
"                k->x = x;                                                     \n"
"                k->y = y;                                                     \n"
"                                                                              \n"
"                *v = bleed_length;                                            \n"
"                g_hash_table_insert (bleed_table, k, v);                      \n"
"              }                                                               \n"
"          }                                                                   \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties          *o;                                                 \n"
"  GeglOperationAreaFilter *op_area;                                           \n"
"                                                                              \n"
"  op_area = GEGL_OPERATION_AREA_FILTER (operation);                           \n"
"  o       = GEGL_PROPERTIES (operation);                                      \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      g_hash_table_destroy (o->user_data);                                    \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  op_area->left   = o->strength;                                              \n"
"  op_area->right  = o->strength;                                              \n"
"  op_area->top    = o->strength;                                              \n"
"  op_area->bottom = o->strength;                                              \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",                            \n"
"                             babl_format (\"RGBA float\"));                   \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                             babl_format (\"RGBA float\"));                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties          *o       = GEGL_PROPERTIES (operation);             \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"                                                                              \n"
"  gfloat *src_buf;                                                            \n"
"  gfloat *dst_buf;                                                            \n"
"                                                                              \n"
"  gint n_pixels = result->width * result->height;                             \n"
"  GeglRectangle src_rect;                                                     \n"
"                                                                              \n"
"  gfloat *current_pix;                                                        \n"
"  gfloat *target_pix;                                                         \n"
"  gfloat *dst_pix;                                                            \n"
"                                                                              \n"
"  gint x, y;                                                                  \n"
"  gint total_src_pixels;                                                      \n"
"  gint total_dst_pixels;                                                      \n"
"                                                                              \n"
"  gint bleed_max;                                                             \n"
"  gint bleed_index;                                                           \n"
"  gfloat blend_coefficient;                                                   \n"
"                                                                              \n"
"  GHashTable *bleed_table;                                                    \n"
"                                                                              \n"
"  static GMutex mutex = { 0, };                                               \n"
"                                                                              \n"
"  g_mutex_lock (&mutex);                                                      \n"
"  if (!o->user_data)                                                          \n"
"    {                                                                         \n"
"      o->user_data = g_hash_table_new_full (tuple_hash, tuple_equal, g_free, g_free);\n"
"      calculate_bleed (operation, input);                                     \n"
"    }                                                                         \n"
"  g_mutex_unlock (&mutex);                                                    \n"
"                                                                              \n"
"  bleed_table = (GHashTable*) o->user_data;                                   \n"
"                                                                              \n"
"  src_rect.x      = result->x - op_area->left;                                \n"
"  src_rect.width  = result->width + op_area->left + op_area->right;           \n"
"  src_rect.y      = result->y - op_area->top;                                 \n"
"  src_rect.height = result->height + op_area->top + op_area->bottom;          \n"
"                                                                              \n"
"  total_src_pixels = src_rect.width * src_rect.height;                        \n"
"  total_dst_pixels = result->width * result->height;                          \n"
"                                                                              \n"
"  src_buf = gegl_malloc (4 * total_src_pixels * sizeof (gfloat));             \n"
"  dst_buf = gegl_malloc (4 * total_dst_pixels * sizeof (gfloat));             \n"
"                                                                              \n"
"  gegl_buffer_get (input,                                                     \n"
"                   &src_rect,                                                 \n"
"                   1.0,                                                       \n"
"                   babl_format (\"RGBA float\"),                              \n"
"                   src_buf,                                                   \n"
"                   GEGL_AUTO_ROWSTRIDE,                                       \n"
"                   GEGL_ABYSS_NONE);                                          \n"
"                                                                              \n"
"  current_pix = src_buf + 4*(o->strength + src_rect.width * o->strength);     \n"
"  dst_pix = dst_buf;                                                          \n"
"  x = 0;                                                                      \n"
"  y = 0;                                                                      \n"
"  bleed_max = 0;                                                              \n"
"  bleed_index = 0;                                                            \n"
"  while (n_pixels--)                                                          \n"
"    {                                                                         \n"
"      gint i;                                                                 \n"
"      pair key = {x + result->x, y + result->y};                              \n"
"      gint *bleed = g_hash_table_lookup (bleed_table, &key);                  \n"
"                                                                              \n"
"      if (x == 0) {                                                           \n"
"        for (i = 0; i < o->strength; i++)                                     \n"
"          {                                                                   \n"
"            pair key = {result->x - i, y + result->y};                        \n"
"            gint *bleed = g_hash_table_lookup (bleed_table, &key);            \n"
"            if (bleed) {                                                      \n"
"              bleed_max = *bleed;                                             \n"
"              bleed_index = *bleed - i;                                       \n"
"              break;                                                          \n"
"            }                                                                 \n"
"          }                                                                   \n"
"      }                                                                       \n"
"                                                                              \n"
"      for (i = 0; i < 4; i++)                                                 \n"
"        dst_pix[i] = current_pix[i];                                          \n"
"                                                                              \n"
"      if (bleed)                                                              \n"
"        {                                                                     \n"
"          gfloat blend_color[4];                                              \n"
"          gfloat blend_amount[4];                                             \n"
"          gfloat *blend_pix;                                                  \n"
"                                                                              \n"
"          bleed_max = *bleed;                                                 \n"
"          bleed_index = *bleed;                                               \n"
"          target_pix = current_pix;                                           \n"
"          blend_pix = current_pix - 12;                                       \n"
"          for (i = 0; i < 4; i++)                                             \n"
"            {                                                                 \n"
"              blend_amount[i] = target_pix[i] - blend_pix[i];                 \n"
"              blend_color[i] = blend_pix[i] + blend_amount[i];                \n"
"              dst_pix[i] = (2.0 * blend_color[i] + dst_pix[i])/3.0;           \n"
"            }                                                                 \n"
"        }                                                                     \n"
"      else if (bleed_index > 0)                                               \n"
"        {                                                                     \n"
"          gfloat blend_color[4];                                              \n"
"          gfloat blend_amount[4];                                             \n"
"          gfloat *blend_pix;                                                  \n"
"          bleed_index--;                                                      \n"
"          blend_coefficient = 1.0 - ((gfloat) bleed_index)/(gfloat) bleed_max;\n"
"          blend_pix = current_pix - 4 * (bleed_max - bleed_index) - 12;       \n"
"          target_pix = current_pix;                                           \n"
"          for (i = 0; i < 4; i++)                                             \n"
"            {                                                                 \n"
"              blend_amount[i] = target_pix[i] - blend_pix[i];                 \n"
"              blend_color[i] = blend_pix[i] + blend_amount[i] * blend_coefficient;\n"
"              dst_pix[i] = (2.0 * blend_color[i] + dst_pix[i])/3.0;           \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      x++;                                                                    \n"
"      current_pix += 4;                                                       \n"
"      dst_pix += 4;                                                           \n"
"      if (x >= result->width)                                                 \n"
"        {                                                                     \n"
"          bleed_max = 0;                                                      \n"
"          bleed_index = 0;                                                    \n"
"          x = 0;                                                              \n"
"          y++;                                                                \n"
"          current_pix += 8 * o->strength;                                     \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  gegl_buffer_set (output,                                                    \n"
"                   result,                                                    \n"
"                   1,                                                         \n"
"                   babl_format (\"RGBA float\"),                              \n"
"                   dst_buf,                                                   \n"
"                   GEGL_AUTO_ROWSTRIDE);                                      \n"
"                                                                              \n"
"  gegl_free (src_buf);                                                        \n"
"  gegl_free (dst_buf);                                                        \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      g_hash_table_destroy (o->user_data);                                    \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass             *object_class;                                     \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  object_class    = G_OBJECT_CLASS (klass);                                   \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  object_class->finalize   = finalize;                                        \n"
"  filter_class->process    = process;                                         \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"                                 \"categories\", \"distort\",                 \n"
"                                 \"name\",       \"gegl:wind\",               \n"
"                                 \"title\",      _(\"Wind\"),                 \n"
"                                 \"license\",    \"GPL3+\",                   \n"
"                                 \"description\", _(\"Wind-like bleed effect\"),\n"
"                                 NULL);                                       \n"
"}                                                                             \n"
"#endif                                                                        \n"
;
