static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2011 Audrey Mandet <mandet.audrey@gmail.com>                     \n"
" * Copyright (c) 1997 Eric L. Hernes (erich@rrnet.com), Stephen Norris        \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (x, _(\"Center X\"), 0.5)                                     \n"
"    ui_range   (0.0, 1.0)                                                     \n"
"    ui_meta    (\"unit\", \"relative-coordinate\")                            \n"
"    ui_meta    (\"axis\", \"x\")                                              \n"
"                                                                              \n"
"property_double (y, _(\"Center Y\"), 0.5)                                     \n"
"    ui_range   (0.0, 1.0)                                                     \n"
"    ui_meta    (\"unit\", \"relative-coordinate\")                            \n"
"    ui_meta    (\"axis\", \"y\")                                              \n"
"                                                                              \n"
"property_double (amplitude, _(\"Amplitude\"), 25.0)                           \n"
"    description(_(\"Amplitude of the ripple\"))                               \n"
"    value_range (0.0, 1000.0)                                                 \n"
"                                                                              \n"
"property_double (period, _(\"Period\"), 200)                                  \n"
"    description(_(\"Period (wavelength) of the ripple\"))                     \n"
"    value_range (0, 1000)                                                     \n"
"                                                                              \n"
"property_double (phi, _(\"Phase shift\"), 0)                                  \n"
"    value_range (-1, 1)                                                       \n"
"                                                                              \n"
"property_double (aspect, _(\"Aspect ratio\"), 1.0)                            \n"
"    value_range (0.1, 10.0)  /* XXX: needs better ui type */                  \n"
"                                                                              \n"
"property_enum (sampler_type, _(\"Resampling method\"),                        \n"
"    GeglSamplerType, gegl_sampler_type, GEGL_SAMPLER_CUBIC)                   \n"
"    description(_(\"Mathematical method for reconstructing pixel values\"))   \n"
"                                                                              \n"
"property_boolean (clamp, _(\"Clamp deformation\"), FALSE)                     \n"
"    description(_(\"Limit deformation in the image area.\"))                  \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_C_SOURCE waves.c                                              \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  GeglProperties          *o       = GEGL_PROPERTIES (operation);             \n"
"                                                                              \n"
"  op_area->left   = o->amplitude;                                             \n"
"  op_area->right  = o->amplitude;                                             \n"
"  op_area->top    = o->amplitude;                                             \n"
"  op_area->bottom = o->amplitude;                                             \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties     *o       = GEGL_PROPERTIES (operation);                  \n"
"  GeglSampler        *sampler = gegl_buffer_sampler_new_at_level (input,      \n"
"                                                         babl_format (\"RGBA float\"),\n"
"                                                         o->sampler_type,     \n"
"                                                         level);              \n"
"  GeglRectangle      *in_extent = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"  GeglBufferIterator *iter;                                                   \n"
"                                                                              \n"
"  GeglAbyssPolicy abyss = o->clamp ? GEGL_ABYSS_CLAMP : GEGL_ABYSS_NONE;      \n"
"                                                                              \n"
"  gdouble px_x = gegl_coordinate_relative_to_pixel (o->x, in_extent->width);  \n"
"  gdouble px_y = gegl_coordinate_relative_to_pixel (o->y, in_extent->height); \n"
"                                                                              \n"
"  gdouble scalex;                                                             \n"
"  gdouble scaley;                                                             \n"
"                                                                              \n"
"  if (o->aspect > 1.0)                                                        \n"
"    {                                                                         \n"
"      scalex = 1.0;                                                           \n"
"      scaley = o->aspect;                                                     \n"
"    }                                                                         \n"
"  else if (o->aspect < 1.0)                                                   \n"
"    {                                                                         \n"
"      scalex = 1.0 / o->aspect;                                               \n"
"      scaley = 1.0;                                                           \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      scalex = 1.0;                                                           \n"
"      scaley = 1.0;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (output, result, 0, babl_format (\"RGBA float\"),\n"
"                                   GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);       \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    {                                                                         \n"
"      gint x = result->x;                                                     \n"
"      gint y = result->y;                                                     \n"
"      gfloat *out_pixel = iter->data[0];                                      \n"
"                                                                              \n"
"      for (y = iter->roi[0].y; y < iter->roi[0].y + iter->roi[0].height; ++y) \n"
"        for (x = iter->roi[0].x; x < iter->roi[0].x + iter->roi[0].width; ++x)\n"
"          {                                                                   \n"
"            gdouble radius;                                                   \n"
"            gdouble shift;                                                    \n"
"            gdouble dx;                                                       \n"
"            gdouble dy;                                                       \n"
"            gdouble ux;                                                       \n"
"            gdouble uy;                                                       \n"
"                                                                              \n"
"            dx = (x - px_x) * scalex;                                         \n"
"            dy = (y - px_y) * scaley;                                         \n"
"                                                                              \n"
"            radius = sqrt (dx * dx + dy * dy);                                \n"
"                                                                              \n"
"            shift = o->amplitude * sin (2.0 * G_PI * radius / o->period +     \n"
"                                        2.0 * G_PI * o->phi);                 \n"
"                                                                              \n"
"            ux = dx / radius;                                                 \n"
"            uy = dy / radius;                                                 \n"
"                                                                              \n"
"            gegl_sampler_get (sampler,                                        \n"
"                              x + (shift + ux) / scalex,                      \n"
"                              y + (shift + uy) / scaley,                      \n"
"                              NULL,                                           \n"
"                              out_pixel,                                      \n"
"                              abyss);                                         \n"
"                                                                              \n"
"            out_pixel += 4;                                                   \n"
"          }                                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_object_unref (sampler);                                                   \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  filter_class->process    = process;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:waves\",                                   \n"
"    \"title\",              _(\"Waves\"),                                     \n"
"    \"categories\",         \"distort\",                                      \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"license\",            \"GPL3+\",                                        \n"
"    \"description\", _(\"Distort the image with waves\"),                     \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
