;;- Machine description for GNU compiler -- S/390 / zSeries version.
;;  Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006
;;  Free Software Foundation, Inc.
;;  Contributed by Hartmut Penner (hpenner@de.ibm.com) and
;;                 Ulrich Weigand (uweigand@de.ibm.com).

;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it under
;; the terms of the GNU General Public License as published by the Free
;; Software Foundation; either version 2, or (at your option) any later
;; version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT ANY
;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING.  If not, write to the Free
;; Software Foundation, 51 Franklin Street, Fifth Floor, Boston, MA
;; 02110-1301, USA.

;;
;; See constraints.md for a description of constraints specific to s390.
;;

;; Special formats used for outputting 390 instructions.
;;
;;     %C: print opcode suffix for branch condition.
;;     %D: print opcode suffix for inverse branch condition.
;;     %J: print tls_load/tls_gdcall/tls_ldcall suffix
;;     %G: print the size of the operand in bytes.
;;     %O: print only the displacement of a memory reference.
;;     %R: print only the base register of a memory reference.
;;     %S: print S-type memory reference (base+displacement).
;;     %N: print the second word of a DImode operand.
;;     %M: print the second word of a TImode operand.
;;     %Y: print shift count operand.
;;  
;;     %b: print integer X as if it's an unsigned byte.
;;     %x: print integer X as if it's an unsigned halfword.
;;     %h: print integer X as if it's a signed halfword.
;;     %i: print the first nonzero HImode part of X.
;;     %j: print the first HImode part unequal to -1 of X.
;;     %k: print the first nonzero SImode part of X.
;;     %m: print the first SImode part unequal to -1 of X.
;;     %o: print integer X as if it's an unsigned 32bit word.
;;
;; We have a special constraint for pattern matching.
;;
;;   s_operand -- Matches a valid S operand in a RS, SI or SS type instruction.
;;

;;
;; UNSPEC usage
;;

(define_constants
  [; Miscellaneous
   (UNSPEC_ROUND                1)
   (UNSPEC_CMPINT                2)
   (UNSPEC_ICM                        10)

   ; GOT/PLT and lt-relative accesses
   (UNSPEC_LTREL_OFFSET                100)
   (UNSPEC_LTREL_BASE                101)
   (UNSPEC_GOTENT                110)
   (UNSPEC_GOT                        111)
   (UNSPEC_GOTOFF                112)
   (UNSPEC_PLT                        113)
   (UNSPEC_PLTOFF                114)

   ; Literal pool
   (UNSPEC_RELOAD_BASE                210)
   (UNSPEC_MAIN_BASE                211)
   (UNSPEC_LTREF                212)
   (UNSPEC_INSN                        213)
   (UNSPEC_EXECUTE                214)

   ; TLS relocation specifiers
   (UNSPEC_TLSGD                500)
   (UNSPEC_TLSLDM                501)
   (UNSPEC_NTPOFF               502)
   (UNSPEC_DTPOFF               503)
   (UNSPEC_GOTNTPOFF            504)
   (UNSPEC_INDNTPOFF            505)

   ; TLS support
   (UNSPEC_TLSLDM_NTPOFF        511)
   (UNSPEC_TLS_LOAD                512)

   ; String Functions
   (UNSPEC_SRST                        600)
   (UNSPEC_MVST                        601)
   
   ; Stack Smashing Protector
   (UNSPEC_SP_SET                 700)
   (UNSPEC_SP_TEST                701)
 ])

;;
;; UNSPEC_VOLATILE usage
;;

(define_constants
  [; Blockage
   (UNSPECV_BLOCKAGE                0)

   ; TPF Support
   (UNSPECV_TPF_PROLOGUE        20)
   (UNSPECV_TPF_EPILOGUE        21)

   ; Literal pool
   (UNSPECV_POOL                200)
   (UNSPECV_POOL_SECTION        201)
   (UNSPECV_POOL_ALIGN                202)
   (UNSPECV_POOL_ENTRY                203)
   (UNSPECV_MAIN_POOL                300)

   ; TLS support
   (UNSPECV_SET_TP                500)

   ; Atomic Support
   (UNSPECV_MB                        700)
   (UNSPECV_CAS                        701)
  ])

;;
;; Registers
;;

(define_constants
  [
   ; Sibling call register.
   (SIBCALL_REGNUM                 1)
   ; Literal pool base register.
   (BASE_REGNUM                        13)
   ; Return address register.
   (RETURN_REGNUM                14)
   ; Condition code register.
   (CC_REGNUM                        33)
   ; Thread local storage pointer register. 
   (TP_REGNUM                        36)
  ])


;; Instruction operand type as used in the Principles of Operation.
;; Used to determine defaults for length and other attribute values.

(define_attr "op_type"
  "NN,E,RR,RRE,RX,RS,RSI,RI,SI,S,SS,SSE,RXE,RSE,RIL,RIE,RXY,RSY,SIY"
  (const_string "NN"))

;; Instruction type attribute used for scheduling.

(define_attr "type" "none,integer,load,lr,la,larl,lm,stm,
                     cs,vs,store,sem,idiv,
                     imulhi,imulsi,imuldi,
                     branch,jsr,fsimptf,fsimpdf,fsimpsf,
                     floadtf,floaddf,floadsf,fstoredf,fstoresf,
                     fmultf,fmuldf,fmulsf,fdivtf,fdivdf,fdivsf,
                     ftoi,itof,fsqrttf,fsqrtdf,fsqrtsf,
                     ftrunctf,ftruncdf,other"
  (cond [(eq_attr "op_type" "NN")  (const_string "other")
         (eq_attr "op_type" "SS")  (const_string "cs")]
    (const_string "integer")))

;; Another attribute used for scheduling purposes:
;;   agen: Instruction uses the address generation unit
;;   reg: Instruction does not use the agen unit

(define_attr "atype" "agen,reg"
  (if_then_else (eq_attr "op_type" "E,RR,RI,RRE")  
                (const_string "reg")
                (const_string "agen")))

;; Length in bytes.

(define_attr "length" ""
  (cond [(eq_attr "op_type" "E,RR")                      (const_int 2)
         (eq_attr "op_type" "RX,RI,RRE,RS,RSI,S,SI")  (const_int 4)]
    (const_int 6)))


;; Processor type.  This attribute must exactly match the processor_type
;; enumeration in s390.h.  The current machine description does not
;; distinguish between g5 and g6, but there are differences between the two
;; CPUs could in theory be modeled.

(define_attr "cpu" "g5,g6,z900,z990,z9_109"
  (const (symbol_ref "s390_tune")))

;; Pipeline description for z900.  For lack of anything better,
;; this description is also used for the g5 and g6.
(include "2064.md")

;; Pipeline description for z990. 
(include "2084.md")

;; Predicates
(include "predicates.md")

;; Constraint definitions
(include "constraints.md")

;; Other includes
(include "tpf.md")

;; Macros

;; This mode macro allows floating point patterns to be generated from the
;; same template.
(define_mode_macro FPR [TF DF SF])
(define_mode_macro DSF [DF SF])

;; These mode macros allow 31-bit and 64-bit TDSI patterns to be generated
;; from the same template.
(define_mode_macro TDSI [(TI "TARGET_64BIT") DI SI])

;; These mode macros allow 31-bit and 64-bit GPR patterns to be generated
;; from the same template.
(define_mode_macro GPR [(DI "TARGET_64BIT") SI])
(define_mode_macro DSI [DI SI])

;; This mode macro allows :P to be used for patterns that operate on
;; pointer-sized quantities.  Exactly one of the two alternatives will match.
(define_mode_macro DP  [(TI "TARGET_64BIT") (DI "!TARGET_64BIT")])
(define_mode_macro P [(DI "TARGET_64BIT") (SI "!TARGET_64BIT")])

;; This mode macro allows the QI and HI patterns to be defined from
;; the same template.
(define_mode_macro HQI [HI QI])

;; This mode macro allows the integer patterns to be defined from the
;; same template.
(define_mode_macro INT [(DI "TARGET_64BIT") SI HI QI])

;; This macro allows to unify all 'bCOND' expander patterns.
(define_code_macro COMPARE [eq ne gt gtu lt ltu ge geu le leu unordered 
                            ordered uneq unlt ungt unle unge ltgt])

;; This macro allows to unify all 'sCOND' patterns.
(define_code_macro SCOND [ltu gtu leu geu])

;; This macro allows some 'ashift' and 'lshiftrt' pattern to be defined from
;; the same template.
(define_code_macro SHIFT [ashift lshiftrt])

;; These macros allow to combine most atomic operations.
(define_code_macro ATOMIC [and ior xor plus minus mult])
(define_code_attr atomic [(and "and") (ior "ior") (xor "xor") 
                          (plus "add") (minus "sub") (mult "nand")])


;; In FPR templates, a string like "lt<de>br" will expand to "ltxbr" in TFmode,
;; "ltdbr" in DFmode, and "ltebr" in SFmode.
(define_mode_attr xde [(TF "x") (DF "d") (SF "e")])

;; In FPR templates, a string like "m<dee>br" will expand to "mxbr" in TFmode,
;; "mdbr" in DFmode, and "meebr" in SFmode.
(define_mode_attr xdee [(TF "x") (DF "d") (SF "ee")])

;; In FPR templates, "<RRe>" will expand to "RRE" in TFmode and "RR" otherwise.
;; Likewise for "<RXe>".
(define_mode_attr RRe [(TF "RRE") (DF "RR") (SF "RR")])
(define_mode_attr RXe [(TF "RXE") (DF "RX") (SF "RX")])

;; In FPR templates, "<Rf>" will expand to "f" in TFmode and "R" otherwise.
;; This is used to disable the memory alternative in TFmode patterns.
(define_mode_attr Rf [(TF "f") (DF "R") (SF "R")])

;; In GPR and P templates, a constraint like "<d0>" will expand to "d" in DImode
;; and "0" in SImode. This allows to combine instructions of which the 31bit
;; version only operates on one register.
(define_mode_attr d0 [(DI "d") (SI "0")])

;; In combination with d0 this allows to combine instructions of which the 31bit
;; version only operates on one register. The DImode version needs an additional
;; register for the assembler output.
(define_mode_attr 1 [(DI "%1,") (SI "")])
  
;; In SHIFT templates, a string like "s<lr>dl" will expand to "sldl" in 
;; 'ashift' and "srdl" in 'lshiftrt'.
(define_code_attr lr [(ashift "l") (lshiftrt "r")])

;; In SHIFT templates, this attribute holds the correct standard name for the
;; pattern itself and the corresponding function calls. 
(define_code_attr shift [(ashift "ashl") (lshiftrt "lshr")])

;; This attribute handles differences in the instruction 'type' and will result
;; in "RRE" for DImode and "RR" for SImode.
(define_mode_attr E [(DI "E") (SI "")])

;; This attribute handles differences in the instruction 'type' and makes RX<Y>
;; to result in "RXY" for DImode and "RX" for SImode.
(define_mode_attr Y [(DI "Y") (SI "")])

;; This attribute handles differences in the instruction 'type' and will result
;; in "RSE" for TImode and "RS" for DImode.
(define_mode_attr TE [(TI "E") (DI "")])

;; In GPR templates, a string like "lc<g>r" will expand to "lcgr" in DImode
;; and "lcr" in SImode.
(define_mode_attr g [(DI "g") (SI "")])

;; In GPR templates, a string like "sl<y>" will expand to "slg" in DImode
;; and "sly" in SImode. This is useful because on 64bit the ..g instructions
;; were enhanced with long displacements whereas 31bit instructions got a ..y
;; variant for long displacements.
(define_mode_attr y [(DI "g") (SI "y")])

;; In DP templates, a string like "cds<g>" will expand to "cdsg" in TImode
;; and "cds" in DImode.
(define_mode_attr tg [(TI "g") (DI "")])

;; In GPR templates, a string like "c<gf>dbr" will expand to "cgdbr" in DImode
;; and "cfdbr" in SImode.
(define_mode_attr gf [(DI "g") (SI "f")])

;; ICM mask required to load MODE value into the lowest subreg
;; of a SImode register.
(define_mode_attr icm_lo [(HI "3") (QI "1")])

;; In HQI templates, a string like "llg<hc>" will expand to "llgh" in
;; HImode and "llgc" in QImode.
(define_mode_attr hc [(HI "h") (QI "c")])

;; In P templates, the mode <DBL> will expand to "TI" in DImode and "DI"
;; in SImode.
(define_mode_attr DBL [(DI "TI") (SI "DI")])

;; Maximum unsigned integer that fits in MODE.
(define_mode_attr max_uint [(HI "65535") (QI "255")])


;;
;;- Compare instructions.
;;

(define_expand "cmp<mode>"
  [(set (reg:CC CC_REGNUM)
        (compare:CC (match_operand:GPR 0 "register_operand" "")
                    (match_operand:GPR 1 "general_operand" "")))]
  ""
{
  s390_compare_op0 = operands[0];
  s390_compare_op1 = operands[1];
  DONE;
})

(define_expand "cmp<mode>"
  [(set (reg:CC CC_REGNUM)
        (compare:CC (match_operand:FPR 0 "register_operand" "")
                    (match_operand:FPR 1 "general_operand" "")))]
  "TARGET_HARD_FLOAT"
{
  s390_compare_op0 = operands[0];
  s390_compare_op1 = operands[1];
  DONE;
})


; Test-under-Mask instructions

(define_insn "*tmqi_mem"
  [(set (reg CC_REGNUM)
        (compare (and:QI (match_operand:QI 0 "memory_operand" "Q,S")
                         (match_operand:QI 1 "immediate_operand" "n,n"))
                 (match_operand:QI 2 "immediate_operand" "n,n")))]
  "s390_match_ccmode (insn, s390_tm_ccmode (operands[1], operands[2], false))"
  "@
   tm\t%S0,%b1
   tmy\t%S0,%b1"
  [(set_attr "op_type" "SI,SIY")])

(define_insn "*tmdi_reg"
  [(set (reg CC_REGNUM)
        (compare (and:DI (match_operand:DI 0 "nonimmediate_operand" "d,d,d,d")
                         (match_operand:DI 1 "immediate_operand"
                                             "N0HD0,N1HD0,N2HD0,N3HD0"))
                 (match_operand:DI 2 "immediate_operand" "n,n,n,n")))]
  "TARGET_64BIT
   && s390_match_ccmode (insn, s390_tm_ccmode (operands[1], operands[2], true))
   && s390_single_part (operands[1], DImode, HImode, 0) >= 0"
  "@
   tmhh\t%0,%i1
   tmhl\t%0,%i1
   tmlh\t%0,%i1
   tmll\t%0,%i1"
  [(set_attr "op_type" "RI")])

(define_insn "*tmsi_reg"
  [(set (reg CC_REGNUM)
        (compare (and:SI (match_operand:SI 0 "nonimmediate_operand" "d,d")
                         (match_operand:SI 1 "immediate_operand" "N0HS0,N1HS0"))
                 (match_operand:SI 2 "immediate_operand" "n,n")))]
  "s390_match_ccmode (insn, s390_tm_ccmode (operands[1], operands[2], true))
   && s390_single_part (operands[1], SImode, HImode, 0) >= 0"
  "@
   tmh\t%0,%i1
   tml\t%0,%i1"
  [(set_attr "op_type" "RI")])

(define_insn "*tm<mode>_full"
  [(set (reg CC_REGNUM)
        (compare (match_operand:HQI 0 "register_operand" "d")
                 (match_operand:HQI 1 "immediate_operand" "n")))]
  "s390_match_ccmode (insn, s390_tm_ccmode (constm1_rtx, operands[1], true))"
  "tml\t%0,<max_uint>"
  [(set_attr "op_type" "RI")])


;
; Load-and-Test instructions
;

; tst(di|si) instruction pattern(s).

(define_insn "*tstdi_sign"
  [(set (reg CC_REGNUM)
        (compare (ashiftrt:DI (ashift:DI (subreg:DI (match_operand:SI 0 "register_operand" "d") 0)
                                         (const_int 32)) (const_int 32))
                 (match_operand:DI 1 "const0_operand" "")))
   (set (match_operand:DI 2 "register_operand" "=d")
        (sign_extend:DI (match_dup 0)))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_64BIT"
  "ltgfr\t%2,%0"
  [(set_attr "op_type" "RRE")])

; ltr, lt, ltgr, ltg
(define_insn "*tst<mode>_extimm"
  [(set (reg CC_REGNUM)
        (compare (match_operand:GPR 0 "nonimmediate_operand" "d,m")
                 (match_operand:GPR 1 "const0_operand" "")))
   (set (match_operand:GPR 2 "register_operand" "=d,d")
        (match_dup 0))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_EXTIMM"
  "@
   lt<g>r\t%2,%0
   lt<g>\t%2,%0"
  [(set_attr "op_type" "RR<E>,RXY")])

; ltr, lt, ltgr, ltg
(define_insn "*tst<mode>_cconly_extimm"
  [(set (reg CC_REGNUM)
        (compare (match_operand:GPR 0 "nonimmediate_operand" "d,m")
                 (match_operand:GPR 1 "const0_operand" "")))
   (clobber (match_scratch:GPR 2 "=X,d"))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_EXTIMM"
  "@
   lt<g>r\t%0,%0
   lt<g>\t%2,%0"
  [(set_attr "op_type" "RR<E>,RXY")])

(define_insn "*tstdi"
  [(set (reg CC_REGNUM)
        (compare (match_operand:DI 0 "register_operand" "d")
                 (match_operand:DI 1 "const0_operand" "")))
   (set (match_operand:DI 2 "register_operand" "=d")
        (match_dup 0))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_64BIT && !TARGET_EXTIMM"
  "ltgr\t%2,%0"
  [(set_attr "op_type" "RRE")])

(define_insn "*tstsi"
  [(set (reg CC_REGNUM)
        (compare (match_operand:SI 0 "nonimmediate_operand" "d,Q,S")
                 (match_operand:SI 1 "const0_operand" "")))
   (set (match_operand:SI 2 "register_operand" "=d,d,d")
        (match_dup 0))]
  "s390_match_ccmode(insn, CCSmode) && !TARGET_EXTIMM"
  "@
   ltr\t%2,%0
   icm\t%2,15,%S0
   icmy\t%2,15,%S0"
  [(set_attr "op_type" "RR,RS,RSY")])

(define_insn "*tstsi_cconly"
  [(set (reg CC_REGNUM)
        (compare (match_operand:SI 0 "nonimmediate_operand" "d,Q,S")
                 (match_operand:SI 1 "const0_operand" "")))
   (clobber (match_scratch:SI 2 "=X,d,d"))]
  "s390_match_ccmode(insn, CCSmode)"
  "@
   ltr\t%0,%0
   icm\t%2,15,%S0
   icmy\t%2,15,%S0"
  [(set_attr "op_type" "RR,RS,RSY")])

(define_insn "*tstdi_cconly_31"
  [(set (reg CC_REGNUM)
        (compare (match_operand:DI 0 "register_operand" "d")
                 (match_operand:DI 1 "const0_operand" "")))]
  "s390_match_ccmode(insn, CCSmode) && !TARGET_64BIT"
  "srda\t%0,0"
  [(set_attr "op_type" "RS")
   (set_attr "atype"   "reg")])

; ltr, ltgr
(define_insn "*tst<mode>_cconly2"
  [(set (reg CC_REGNUM)
        (compare (match_operand:GPR 0 "register_operand" "d")
                 (match_operand:GPR 1 "const0_operand" "")))]
  "s390_match_ccmode(insn, CCSmode)"
  "lt<g>r\t%0,%0"
  [(set_attr "op_type" "RR<E>")])

; tst(hi|qi) instruction pattern(s).

(define_insn "*tst<mode>CCT"
  [(set (reg CC_REGNUM)
        (compare (match_operand:HQI 0 "nonimmediate_operand" "?Q,?S,d")
                 (match_operand:HQI 1 "const0_operand" "")))
   (set (match_operand:HQI 2 "register_operand" "=d,d,0")
        (match_dup 0))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   icm\t%2,<icm_lo>,%S0
   icmy\t%2,<icm_lo>,%S0
   tml\t%0,<max_uint>"
  [(set_attr "op_type" "RS,RSY,RI")])

(define_insn "*tsthiCCT_cconly"
  [(set (reg CC_REGNUM)
        (compare (match_operand:HI 0 "nonimmediate_operand" "Q,S,d")
                 (match_operand:HI 1 "const0_operand" "")))
   (clobber (match_scratch:HI 2 "=d,d,X"))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   icm\t%2,3,%S0
   icmy\t%2,3,%S0
   tml\t%0,65535"
  [(set_attr "op_type" "RS,RSY,RI")])

(define_insn "*tstqiCCT_cconly"
  [(set (reg CC_REGNUM)
        (compare (match_operand:QI 0 "nonimmediate_operand" "?Q,?S,d")
                 (match_operand:QI 1 "const0_operand" "")))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   cli\t%S0,0
   cliy\t%S0,0
   tml\t%0,255"
  [(set_attr "op_type" "SI,SIY,RI")])

(define_insn "*tst<mode>"
  [(set (reg CC_REGNUM)
        (compare (match_operand:HQI 0 "s_operand" "Q,S")
                 (match_operand:HQI 1 "const0_operand" "")))
   (set (match_operand:HQI 2 "register_operand" "=d,d")
        (match_dup 0))]
  "s390_match_ccmode(insn, CCSmode)"
  "@
   icm\t%2,<icm_lo>,%S0
   icmy\t%2,<icm_lo>,%S0"
  [(set_attr "op_type" "RS,RSY")])

(define_insn "*tst<mode>_cconly"
  [(set (reg CC_REGNUM)
        (compare (match_operand:HQI 0 "s_operand" "Q,S")
                 (match_operand:HQI 1 "const0_operand" "")))
   (clobber (match_scratch:HQI 2 "=d,d"))]
  "s390_match_ccmode(insn, CCSmode)"
  "@
   icm\t%2,<icm_lo>,%S0
   icmy\t%2,<icm_lo>,%S0"
  [(set_attr "op_type" "RS,RSY")])


; Compare (equality) instructions

(define_insn "*cmpdi_cct"
  [(set (reg CC_REGNUM)
        (compare (match_operand:DI 0 "nonimmediate_operand" "%d,d,d,d,Q")
                 (match_operand:DI 1 "general_operand" "d,K,Os,m,BQ")))]
  "s390_match_ccmode (insn, CCTmode) && TARGET_64BIT"
  "@
   cgr\t%0,%1
   cghi\t%0,%h1
   cgfi\t%0,%1
   cg\t%0,%1
   #"
  [(set_attr "op_type" "RRE,RI,RIL,RXY,SS")])

(define_insn "*cmpsi_cct"
  [(set (reg CC_REGNUM)
        (compare (match_operand:SI 0 "nonimmediate_operand" "%d,d,d,d,d,Q")
                 (match_operand:SI 1 "general_operand" "d,K,Os,R,T,BQ")))]
  "s390_match_ccmode (insn, CCTmode)"
  "@
   cr\t%0,%1
   chi\t%0,%h1
   cfi\t%0,%1
   c\t%0,%1
   cy\t%0,%1
   #"
  [(set_attr "op_type" "RR,RI,RIL,RX,RXY,SS")])


; Compare (signed) instructions

(define_insn "*cmpdi_ccs_sign"
  [(set (reg CC_REGNUM)
        (compare (sign_extend:DI (match_operand:SI 1 "nonimmediate_operand" "d,m"))
                 (match_operand:DI 0 "register_operand" "d,d")))]
  "s390_match_ccmode(insn, CCSRmode) && TARGET_64BIT"
  "@
   cgfr\t%0,%1
   cgf\t%0,%1"
  [(set_attr "op_type" "RRE,RXY")])

(define_insn "*cmpsi_ccs_sign"
  [(set (reg CC_REGNUM)
        (compare (sign_extend:SI (match_operand:HI 1 "memory_operand" "R,T"))
                 (match_operand:SI 0 "register_operand" "d,d")))]
  "s390_match_ccmode(insn, CCSRmode)"
  "@
   ch\t%0,%1
   chy\t%0,%1"
  [(set_attr "op_type" "RX,RXY")])

; cr, chi, cfi, c, cy, cgr, cghi, cgfi, cg
(define_insn "*cmp<mode>_ccs"
  [(set (reg CC_REGNUM)
        (compare (match_operand:GPR 0 "register_operand" "d,d,d,d,d")
                 (match_operand:GPR 1 "general_operand" "d,K,Os,R,T")))]
  "s390_match_ccmode(insn, CCSmode)"
  "@
   c<g>r\t%0,%1
   c<g>hi\t%0,%h1
   c<g>fi\t%0,%1
   c<g>\t%0,%1
   c<y>\t%0,%1"
  [(set_attr "op_type" "RR<E>,RI,RIL,RX<Y>,RXY")])


; Compare (unsigned) instructions

(define_insn "*cmpdi_ccu_zero"
  [(set (reg CC_REGNUM)
        (compare (zero_extend:DI (match_operand:SI 1 "nonimmediate_operand" "d,m"))
                 (match_operand:DI 0 "register_operand" "d,d")))]
  "s390_match_ccmode (insn, CCURmode) && TARGET_64BIT"
  "@
   clgfr\t%0,%1
   clgf\t%0,%1"
  [(set_attr "op_type" "RRE,RXY")])

(define_insn "*cmpdi_ccu"
  [(set (reg CC_REGNUM)
        (compare (match_operand:DI 0 "nonimmediate_operand" "d,d,d,Q,BQ")
                 (match_operand:DI 1 "general_operand" "d,Op,m,BQ,Q")))]
  "s390_match_ccmode (insn, CCUmode) && TARGET_64BIT"
  "@
   clgr\t%0,%1
   clgfi\t%0,%1
   clg\t%0,%1
   #
   #"
  [(set_attr "op_type" "RRE,RIL,RXY,SS,SS")])

(define_insn "*cmpsi_ccu"
  [(set (reg CC_REGNUM)
        (compare (match_operand:SI 0 "nonimmediate_operand" "d,d,d,d,Q,BQ")
                 (match_operand:SI 1 "general_operand" "d,Os,R,T,BQ,Q")))]
  "s390_match_ccmode (insn, CCUmode)"
  "@
   clr\t%0,%1
   clfi\t%0,%o1
   cl\t%0,%1
   cly\t%0,%1
   #
   #"
  [(set_attr "op_type" "RR,RIL,RX,RXY,SS,SS")])

(define_insn "*cmphi_ccu"
  [(set (reg CC_REGNUM)
        (compare (match_operand:HI 0 "nonimmediate_operand" "d,d,Q,BQ")
                 (match_operand:HI 1 "general_operand" "Q,S,BQ,Q")))]
  "s390_match_ccmode (insn, CCUmode)
   && !register_operand (operands[1], HImode)"
  "@
   clm\t%0,3,%S1
   clmy\t%0,3,%S1
   #
   #"
  [(set_attr "op_type" "RS,RSY,SS,SS")])

(define_insn "*cmpqi_ccu"
  [(set (reg CC_REGNUM)
        (compare (match_operand:QI 0 "nonimmediate_operand" "d,d,Q,S,Q,BQ")
                 (match_operand:QI 1 "general_operand" "Q,S,n,n,BQ,Q")))]
  "s390_match_ccmode (insn, CCUmode)
   && !register_operand (operands[1], QImode)"
  "@
   clm\t%0,1,%S1
   clmy\t%0,1,%S1
   cli\t%S0,%b1
   cliy\t%S0,%b1
   #
   #"
  [(set_attr "op_type" "RS,RSY,SI,SIY,SS,SS")])


; Block compare (CLC) instruction patterns.

(define_insn "*clc"
  [(set (reg CC_REGNUM)
        (compare (match_operand:BLK 0 "memory_operand" "Q")
                 (match_operand:BLK 1 "memory_operand" "Q")))
   (use (match_operand 2 "const_int_operand" "n"))]
  "s390_match_ccmode (insn, CCUmode)
   && INTVAL (operands[2]) >= 1 && INTVAL (operands[2]) <= 256"
  "clc\t%O0(%2,%R0),%S1"
  [(set_attr "op_type" "SS")])

(define_split
  [(set (reg CC_REGNUM)
        (compare (match_operand 0 "memory_operand" "")
                 (match_operand 1 "memory_operand" "")))]
  "reload_completed
   && s390_match_ccmode (insn, CCUmode)
   && GET_MODE (operands[0]) == GET_MODE (operands[1])
   && GET_MODE_SIZE (GET_MODE (operands[0])) > 0"
  [(parallel
    [(set (match_dup 0) (match_dup 1))
     (use (match_dup 2))])]
{
  operands[2] = GEN_INT (GET_MODE_SIZE (GET_MODE (operands[0])));
  operands[0] = adjust_address (operands[0], BLKmode, 0);
  operands[1] = adjust_address (operands[1], BLKmode, 0);

  operands[1] = gen_rtx_COMPARE (GET_MODE (SET_DEST (PATTERN (curr_insn))),
                                 operands[0], operands[1]);
  operands[0] = SET_DEST (PATTERN (curr_insn));
})


; (DF|SF) instructions

; ltxbr, ltdbr, ltebr
(define_insn "*cmp<mode>_ccs_0"
  [(set (reg CC_REGNUM)
        (compare (match_operand:FPR 0 "register_operand" "f")
                 (match_operand:FPR 1 "const0_operand" "")))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "lt<xde>br\t%0,%0"
   [(set_attr "op_type" "RRE")
    (set_attr "type"  "fsimp<mode>")])

; ltxr, ltdr, lter
(define_insn "*cmp<mode>_ccs_0_ibm"
  [(set (reg CC_REGNUM)
        (compare (match_operand:FPR 0 "register_operand" "f")
                 (match_operand:FPR 1 "const0_operand" "")))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "lt<xde>r\t%0,%0"
   [(set_attr "op_type" "<RRe>")
    (set_attr "type"  "fsimp<mode>")])

; cxbr, cdbr, cebr, cxb, cdb, ceb
(define_insn "*cmp<mode>_ccs"
  [(set (reg CC_REGNUM)
        (compare (match_operand:FPR 0 "register_operand" "f,f")
                 (match_operand:FPR 1 "general_operand" "f,<Rf>")))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   c<xde>br\t%0,%1
   c<xde>b\t%0,%1"
   [(set_attr "op_type" "RRE,RXE")
    (set_attr "type"  "fsimp<mode>")])

; cxr, cdr, cer, cx, cd, ce
(define_insn "*cmp<mode>_ccs_ibm"
  [(set (reg CC_REGNUM)
        (compare (match_operand:FPR 0 "register_operand" "f,f")
                 (match_operand:FPR 1 "general_operand" "f,<Rf>")))]
  "s390_match_ccmode(insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   c<xde>r\t%0,%1
   c<xde>\t%0,%1"
   [(set_attr "op_type" "<RRe>,<RXe>")
    (set_attr "type"  "fsimp<mode>")])


;;
;;- Move instructions.
;;

;
; movti instruction pattern(s).
;

(define_insn "movti"
  [(set (match_operand:TI 0 "nonimmediate_operand" "=d,QS,d,o,Q")
        (match_operand:TI 1 "general_operand" "QS,d,dPm,d,Q"))]
  "TARGET_64BIT"
  "@
   lmg\t%0,%N0,%S1
   stmg\t%1,%N1,%S0
   #
   #
   #"
  [(set_attr "op_type" "RSY,RSY,*,*,SS")
   (set_attr "type" "lm,stm,*,*,*")])

(define_split
  [(set (match_operand:TI 0 "nonimmediate_operand" "")
        (match_operand:TI 1 "general_operand" ""))]
  "TARGET_64BIT && reload_completed
   && s390_split_ok_p (operands[0], operands[1], TImode, 0)"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
{
  operands[2] = operand_subword (operands[0], 0, 0, TImode);
  operands[3] = operand_subword (operands[0], 1, 0, TImode);
  operands[4] = operand_subword (operands[1], 0, 0, TImode);
  operands[5] = operand_subword (operands[1], 1, 0, TImode);
})

(define_split
  [(set (match_operand:TI 0 "nonimmediate_operand" "")
        (match_operand:TI 1 "general_operand" ""))]
  "TARGET_64BIT && reload_completed
   && s390_split_ok_p (operands[0], operands[1], TImode, 1)"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
{
  operands[2] = operand_subword (operands[0], 1, 0, TImode);
  operands[3] = operand_subword (operands[0], 0, 0, TImode);
  operands[4] = operand_subword (operands[1], 1, 0, TImode);
  operands[5] = operand_subword (operands[1], 0, 0, TImode);
})

(define_split
  [(set (match_operand:TI 0 "register_operand" "")
        (match_operand:TI 1 "memory_operand" ""))]
  "TARGET_64BIT && reload_completed
   && !s_operand (operands[1], VOIDmode)"
  [(set (match_dup 0) (match_dup 1))]
{
  rtx addr = operand_subword (operands[0], 1, 0, TImode);
  s390_load_address (addr, XEXP (operands[1], 0));
  operands[1] = replace_equiv_address (operands[1], addr);
})

(define_expand "reload_outti"
  [(parallel [(match_operand:TI 0 "" "")
              (match_operand:TI 1 "register_operand" "d")
              (match_operand:DI 2 "register_operand" "=&a")])]
  "TARGET_64BIT"
{
  gcc_assert (MEM_P (operands[0]));
  s390_load_address (operands[2], find_replacement (&XEXP (operands[0], 0)));
  operands[0] = replace_equiv_address (operands[0], operands[2]);
  emit_move_insn (operands[0], operands[1]);
  DONE;
})

;
; movdi instruction pattern(s).
;

(define_expand "movdi"
  [(set (match_operand:DI 0 "general_operand" "")
        (match_operand:DI 1 "general_operand" ""))]
  ""
{
  /* Handle symbolic constants.  */
  if (TARGET_64BIT
      && (SYMBOLIC_CONST (operands[1])
          || (GET_CODE (operands[1]) == PLUS
              && XEXP (operands[1], 0) == pic_offset_table_rtx
              && SYMBOLIC_CONST (XEXP (operands[1], 1)))))
    emit_symbolic_move (operands);
})

(define_insn "*movdi_larl"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (match_operand:DI 1 "larl_operand" "X"))]
  "TARGET_64BIT
   && !FP_REG_P (operands[0])"
  "larl\t%0,%1"
   [(set_attr "op_type" "RIL")
    (set_attr "type"    "larl")])

(define_insn "*movdi_64extimm"
  [(set (match_operand:DI 0 "nonimmediate_operand"
                            "=d,d,d,d,d,d,d,d,d,d,d,m,!*f,!*f,!*f,!R,!T,d,t,Q,t,?Q")
        (match_operand:DI 1 "general_operand"
                            "K,N0HD0,N1HD0,N2HD0,N3HD0,Os,N0SD0,N1SD0,L,d,m,d,*f,R,T,*f,*f,t,d,t,Q,?Q"))]
  "TARGET_64BIT && TARGET_EXTIMM"
  "@
   lghi\t%0,%h1
   llihh\t%0,%i1
   llihl\t%0,%i1
   llilh\t%0,%i1
   llill\t%0,%i1
   lgfi\t%0,%1
   llihf\t%0,%k1
   llilf\t%0,%k1
   lay\t%0,%a1
   lgr\t%0,%1
   lg\t%0,%1
   stg\t%1,%0
   ldr\t%0,%1
   ld\t%0,%1
   ldy\t%0,%1
   std\t%1,%0
   stdy\t%1,%0
   #
   #
   stam\t%1,%N1,%S0
   lam\t%0,%N0,%S1
   #"
  [(set_attr "op_type" "RI,RI,RI,RI,RI,RIL,RIL,RIL,RXY,RRE,RXY,RXY,
                        RR,RX,RXY,RX,RXY,*,*,RS,RS,SS")
   (set_attr "type" "*,*,*,*,*,*,*,*,la,lr,load,store,
                     floaddf,floaddf,floaddf,fstoredf,fstoredf,*,*,*,*,*")])

(define_insn "*movdi_64"
  [(set (match_operand:DI 0 "nonimmediate_operand"
                            "=d,d,d,d,d,d,d,d,m,!*f,!*f,!*f,!R,!T,d,t,Q,t,?Q")
        (match_operand:DI 1 "general_operand"
                            "K,N0HD0,N1HD0,N2HD0,N3HD0,L,d,m,d,*f,R,T,*f,*f,t,d,t,Q,?Q"))]
  "TARGET_64BIT && !TARGET_EXTIMM"
  "@
   lghi\t%0,%h1
   llihh\t%0,%i1
   llihl\t%0,%i1
   llilh\t%0,%i1
   llill\t%0,%i1
   lay\t%0,%a1
   lgr\t%0,%1
   lg\t%0,%1
   stg\t%1,%0
   ldr\t%0,%1
   ld\t%0,%1
   ldy\t%0,%1
   std\t%1,%0
   stdy\t%1,%0
   #
   #
   stam\t%1,%N1,%S0
   lam\t%0,%N0,%S1
   #"
  [(set_attr "op_type" "RI,RI,RI,RI,RI,RXY,RRE,RXY,RXY,
                        RR,RX,RXY,RX,RXY,*,*,RS,RS,SS")
   (set_attr "type" "*,*,*,*,*,la,lr,load,store,
                     floaddf,floaddf,floaddf,fstoredf,fstoredf,*,*,*,*,*")])

(define_split
  [(set (match_operand:DI 0 "register_operand" "")
        (match_operand:DI 1 "register_operand" ""))]
  "TARGET_64BIT && ACCESS_REG_P (operands[1])"
  [(set (match_dup 2) (match_dup 3))
   (set (match_dup 0) (ashift:DI (match_dup 0) (const_int 32)))
   (set (strict_low_part (match_dup 2)) (match_dup 4))]
  "operands[2] = gen_lowpart (SImode, operands[0]);
   s390_split_access_reg (operands[1], &operands[4], &operands[3]);")

(define_split
  [(set (match_operand:DI 0 "register_operand" "")
        (match_operand:DI 1 "register_operand" ""))]
  "TARGET_64BIT && ACCESS_REG_P (operands[0])
   && dead_or_set_p (insn, operands[1])"
  [(set (match_dup 3) (match_dup 2))
   (set (match_dup 1) (lshiftrt:DI (match_dup 1) (const_int 32)))
   (set (match_dup 4) (match_dup 2))]
  "operands[2] = gen_lowpart (SImode, operands[1]);
   s390_split_access_reg (operands[0], &operands[3], &operands[4]);")

(define_split
  [(set (match_operand:DI 0 "register_operand" "")
        (match_operand:DI 1 "register_operand" ""))]
  "TARGET_64BIT && ACCESS_REG_P (operands[0])
   && !dead_or_set_p (insn, operands[1])"
  [(set (match_dup 3) (match_dup 2))
   (set (match_dup 1) (rotate:DI (match_dup 1) (const_int 32)))
   (set (match_dup 4) (match_dup 2))
   (set (match_dup 1) (rotate:DI (match_dup 1) (const_int 32)))]
  "operands[2] = gen_lowpart (SImode, operands[1]);
   s390_split_access_reg (operands[0], &operands[3], &operands[4]);")

(define_insn "*movdi_31"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=d,d,Q,S,d,o,!*f,!*f,!*f,!R,!T,Q")
        (match_operand:DI 1 "general_operand" "Q,S,d,d,dPm,d,*f,R,T,*f,*f,Q"))]
  "!TARGET_64BIT"
  "@
   lm\t%0,%N0,%S1
   lmy\t%0,%N0,%S1
   stm\t%1,%N1,%S0
   stmy\t%1,%N1,%S0
   #
   #
   ldr\t%0,%1
   ld\t%0,%1
   ldy\t%0,%1
   std\t%1,%0
   stdy\t%1,%0
   #"
  [(set_attr "op_type" "RS,RSY,RS,RSY,*,*,RR,RX,RXY,RX,RXY,SS")
   (set_attr "type" "lm,lm,stm,stm,*,*,floaddf,floaddf,floaddf,fstoredf,fstoredf,*")])

(define_split
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
        (match_operand:DI 1 "general_operand" ""))]
  "!TARGET_64BIT && reload_completed
   && s390_split_ok_p (operands[0], operands[1], DImode, 0)"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
{
  operands[2] = operand_subword (operands[0], 0, 0, DImode);
  operands[3] = operand_subword (operands[0], 1, 0, DImode);
  operands[4] = operand_subword (operands[1], 0, 0, DImode);
  operands[5] = operand_subword (operands[1], 1, 0, DImode);
})

(define_split
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
        (match_operand:DI 1 "general_operand" ""))]
  "!TARGET_64BIT && reload_completed
   && s390_split_ok_p (operands[0], operands[1], DImode, 1)"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
{
  operands[2] = operand_subword (operands[0], 1, 0, DImode);
  operands[3] = operand_subword (operands[0], 0, 0, DImode);
  operands[4] = operand_subword (operands[1], 1, 0, DImode);
  operands[5] = operand_subword (operands[1], 0, 0, DImode);
})

(define_split
  [(set (match_operand:DI 0 "register_operand" "")
        (match_operand:DI 1 "memory_operand" ""))]
  "!TARGET_64BIT && reload_completed
   && !FP_REG_P (operands[0])
   && !s_operand (operands[1], VOIDmode)"
  [(set (match_dup 0) (match_dup 1))]
{
  rtx addr = operand_subword (operands[0], 1, 0, DImode);
  s390_load_address (addr, XEXP (operands[1], 0));
  operands[1] = replace_equiv_address (operands[1], addr);
})

(define_expand "reload_outdi"
  [(parallel [(match_operand:DI 0 "" "")
              (match_operand:DI 1 "register_operand" "d")
              (match_operand:SI 2 "register_operand" "=&a")])]
  "!TARGET_64BIT"
{
  gcc_assert (MEM_P (operands[0]));
  s390_load_address (operands[2], find_replacement (&XEXP (operands[0], 0)));
  operands[0] = replace_equiv_address (operands[0], operands[2]);
  emit_move_insn (operands[0], operands[1]);
  DONE;
})

(define_peephole2
  [(set (match_operand:DI 0 "register_operand" "")
        (mem:DI (match_operand 1 "address_operand" "")))]
  "TARGET_64BIT
   && !FP_REG_P (operands[0])
   && GET_CODE (operands[1]) == SYMBOL_REF
   && CONSTANT_POOL_ADDRESS_P (operands[1])
   && get_pool_mode (operands[1]) == DImode
   && legitimate_reload_constant_p (get_pool_constant (operands[1]))"
  [(set (match_dup 0) (match_dup 2))]
  "operands[2] = get_pool_constant (operands[1]);")

(define_insn "*la_64"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (match_operand:QI 1 "address_operand" "U,W"))]
  "TARGET_64BIT"
  "@
   la\t%0,%a1
   lay\t%0,%a1"
  [(set_attr "op_type" "RX,RXY")
   (set_attr "type"    "la")])

(define_peephole2
  [(parallel
    [(set (match_operand:DI 0 "register_operand" "")
          (match_operand:QI 1 "address_operand" ""))
     (clobber (reg:CC CC_REGNUM))])]
  "TARGET_64BIT
   && preferred_la_operand_p (operands[1], const0_rtx)"
  [(set (match_dup 0) (match_dup 1))]
  "")

(define_peephole2
  [(set (match_operand:DI 0 "register_operand" "")
        (match_operand:DI 1 "register_operand" ""))
   (parallel
    [(set (match_dup 0)
          (plus:DI (match_dup 0)
                   (match_operand:DI 2 "nonmemory_operand" "")))
     (clobber (reg:CC CC_REGNUM))])]
  "TARGET_64BIT
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && preferred_la_operand_p (operands[1], operands[2])"
  [(set (match_dup 0) (plus:DI (match_dup 1) (match_dup 2)))]
  "")

(define_expand "reload_indi"
  [(parallel [(match_operand:DI 0 "register_operand" "=a")
              (match_operand:DI 1 "s390_plus_operand" "")
              (match_operand:DI 2 "register_operand" "=&a")])]
  "TARGET_64BIT"
{
  s390_expand_plus_operand (operands[0], operands[1], operands[2]);
  DONE;
})

;
; movsi instruction pattern(s).
;

(define_expand "movsi"
  [(set (match_operand:SI 0 "general_operand" "")
        (match_operand:SI 1 "general_operand" ""))]
  ""
{
  /* Handle symbolic constants.  */
  if (!TARGET_64BIT
      && (SYMBOLIC_CONST (operands[1])
          || (GET_CODE (operands[1]) == PLUS
              && XEXP (operands[1], 0) == pic_offset_table_rtx
              && SYMBOLIC_CONST (XEXP(operands[1], 1)))))
    emit_symbolic_move (operands);
})

(define_insn "*movsi_larl"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (match_operand:SI 1 "larl_operand" "X"))]
  "!TARGET_64BIT && TARGET_CPU_ZARCH
   && !FP_REG_P (operands[0])"
  "larl\t%0,%1"
   [(set_attr "op_type" "RIL")
    (set_attr "type"    "larl")])

(define_insn "*movsi_zarch"
  [(set (match_operand:SI 0 "nonimmediate_operand"
                            "=d,d,d,d,d,d,d,d,R,T,!*f,!*f,!*f,!R,!T,d,t,Q,t,?Q")
        (match_operand:SI 1 "general_operand"
                            "K,N0HS0,N1HS0,Os,L,d,R,T,d,d,*f,R,T,*f,*f,t,d,t,Q,?Q"))]
  "TARGET_ZARCH"
  "@
   lhi\t%0,%h1
   llilh\t%0,%i1
   llill\t%0,%i1
   iilf\t%0,%o1
   lay\t%0,%a1
   lr\t%0,%1
   l\t%0,%1
   ly\t%0,%1
   st\t%1,%0
   sty\t%1,%0
   ler\t%0,%1
   le\t%0,%1
   ley\t%0,%1
   ste\t%1,%0
   stey\t%1,%0
   ear\t%0,%1
   sar\t%0,%1
   stam\t%1,%1,%S0
   lam\t%0,%0,%S1
   #"
  [(set_attr "op_type" "RI,RI,RI,RIL,RXY,RR,RX,RXY,RX,RXY,
                        RR,RX,RXY,RX,RXY,RRE,RRE,RS,RS,SS")
   (set_attr "type" "*,*,*,*,la,lr,load,load,store,store,
                     floadsf,floadsf,floadsf,fstoresf,fstoresf,*,*,*,*,*")])

(define_insn "*movsi_esa"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=d,d,d,R,!*f,!*f,!R,d,t,Q,t,?Q")
        (match_operand:SI 1 "general_operand" "K,d,R,d,*f,R,*f,t,d,t,Q,?Q"))]
  "!TARGET_ZARCH"
  "@
   lhi\t%0,%h1
   lr\t%0,%1
   l\t%0,%1
   st\t%1,%0
   ler\t%0,%1
   le\t%0,%1
   ste\t%1,%0
   ear\t%0,%1
   sar\t%0,%1
   stam\t%1,%1,%S0
   lam\t%0,%0,%S1
   #"
  [(set_attr "op_type" "RI,RR,RX,RX,RR,RX,RX,RRE,RRE,RS,RS,SS")
   (set_attr "type" "*,lr,load,store,floadsf,floadsf,fstoresf,*,*,*,*,*")])

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "")
        (mem:SI (match_operand 1 "address_operand" "")))]
  "!FP_REG_P (operands[0])
   && GET_CODE (operands[1]) == SYMBOL_REF
   && CONSTANT_POOL_ADDRESS_P (operands[1])
   && get_pool_mode (operands[1]) == SImode
   && legitimate_reload_constant_p (get_pool_constant (operands[1]))"
  [(set (match_dup 0) (match_dup 2))]
  "operands[2] = get_pool_constant (operands[1]);")

(define_insn "*la_31"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (match_operand:QI 1 "address_operand" "U,W"))]
  "!TARGET_64BIT && legitimate_la_operand_p (operands[1])"
  "@
   la\t%0,%a1
   lay\t%0,%a1"
  [(set_attr "op_type"  "RX,RXY")
   (set_attr "type"     "la")])

(define_peephole2
  [(parallel
    [(set (match_operand:SI 0 "register_operand" "")
          (match_operand:QI 1 "address_operand" ""))
     (clobber (reg:CC CC_REGNUM))])]
  "!TARGET_64BIT
   && preferred_la_operand_p (operands[1], const0_rtx)"
  [(set (match_dup 0) (match_dup 1))]
  "")

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "")
        (match_operand:SI 1 "register_operand" ""))
   (parallel
    [(set (match_dup 0)
          (plus:SI (match_dup 0)
                   (match_operand:SI 2 "nonmemory_operand" "")))
     (clobber (reg:CC CC_REGNUM))])]
  "!TARGET_64BIT
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && preferred_la_operand_p (operands[1], operands[2])"
  [(set (match_dup 0) (plus:SI (match_dup 1) (match_dup 2)))]
  "")

(define_insn "*la_31_and"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (and:SI (match_operand:QI 1 "address_operand" "U,W")
                (const_int 2147483647)))]
  "!TARGET_64BIT"
  "@
   la\t%0,%a1
   lay\t%0,%a1"
  [(set_attr "op_type"  "RX,RXY")
   (set_attr "type"     "la")])

(define_insn_and_split "*la_31_and_cc"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (and:SI (match_operand:QI 1 "address_operand" "p")
                (const_int 2147483647)))
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_64BIT"
  "#"
  "&& reload_completed"
  [(set (match_dup 0)
        (and:SI (match_dup 1) (const_int 2147483647)))]
  ""
  [(set_attr "op_type"  "RX")
   (set_attr "type"     "la")])

(define_insn "force_la_31"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (match_operand:QI 1 "address_operand" "U,W"))
   (use (const_int 0))]
  "!TARGET_64BIT"
  "@
   la\t%0,%a1
   lay\t%0,%a1"
  [(set_attr "op_type"  "RX")
   (set_attr "type"     "la")])

(define_expand "reload_insi"
  [(parallel [(match_operand:SI 0 "register_operand" "=a")
              (match_operand:SI 1 "s390_plus_operand" "")
              (match_operand:SI 2 "register_operand" "=&a")])]
  "!TARGET_64BIT"
{
  s390_expand_plus_operand (operands[0], operands[1], operands[2]);
  DONE;
})

;
; movhi instruction pattern(s).
;

(define_expand "movhi"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
        (match_operand:HI 1 "general_operand" ""))]
  ""
{
  /* Make it explicit that loading a register from memory
     always sign-extends (at least) to SImode.  */
  if (optimize && !no_new_pseudos
      && register_operand (operands[0], VOIDmode)
      && GET_CODE (operands[1]) == MEM)
    {
      rtx tmp = gen_reg_rtx (SImode);
      rtx ext = gen_rtx_SIGN_EXTEND (SImode, operands[1]);
      emit_insn (gen_rtx_SET (VOIDmode, tmp, ext));
      operands[1] = gen_lowpart (HImode, tmp);
    }
})

(define_insn "*movhi"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=d,d,d,d,R,T,?Q")
        (match_operand:HI 1 "general_operand" "d,n,R,T,d,d,?Q"))]
  ""
  "@
   lr\t%0,%1
   lhi\t%0,%h1
   lh\t%0,%1
   lhy\t%0,%1
   sth\t%1,%0
   sthy\t%1,%0
   #"
  [(set_attr "op_type" "RR,RI,RX,RXY,RX,RXY,SS")
   (set_attr "type" "lr,*,*,*,store,store,*")])

(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "")
        (mem:HI (match_operand 1 "address_operand" "")))]
  "GET_CODE (operands[1]) == SYMBOL_REF
   && CONSTANT_POOL_ADDRESS_P (operands[1])
   && get_pool_mode (operands[1]) == HImode
   && GET_CODE (get_pool_constant (operands[1])) == CONST_INT"
  [(set (match_dup 0) (match_dup 2))]
  "operands[2] = get_pool_constant (operands[1]);")

;
; movqi instruction pattern(s).
;

(define_expand "movqi"
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
        (match_operand:QI 1 "general_operand" ""))]
  ""
{
  /* On z/Architecture, zero-extending from memory to register
     is just as fast as a QImode load.  */
  if (TARGET_ZARCH && optimize && !no_new_pseudos
      && register_operand (operands[0], VOIDmode)
      && GET_CODE (operands[1]) == MEM)
    {
      rtx tmp = gen_reg_rtx (word_mode);
      rtx ext = gen_rtx_ZERO_EXTEND (word_mode, operands[1]);
      emit_insn (gen_rtx_SET (VOIDmode, tmp, ext));
      operands[1] = gen_lowpart (QImode, tmp);
    }
})

(define_insn "*movqi"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=d,d,d,d,R,T,Q,S,?Q")
        (match_operand:QI 1 "general_operand" "d,n,R,T,d,d,n,n,?Q"))]
  ""
  "@
   lr\t%0,%1
   lhi\t%0,%b1
   ic\t%0,%1
   icy\t%0,%1
   stc\t%1,%0
   stcy\t%1,%0
   mvi\t%S0,%b1
   mviy\t%S0,%b1
   #"
  [(set_attr "op_type" "RR,RI,RX,RXY,RX,RXY,SI,SIY,SS")
   (set_attr "type" "lr,*,*,*,store,store,store,store,*")])

(define_peephole2
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
        (mem:QI (match_operand 1 "address_operand" "")))]
  "GET_CODE (operands[1]) == SYMBOL_REF
   && CONSTANT_POOL_ADDRESS_P (operands[1])
   && get_pool_mode (operands[1]) == QImode
   && GET_CODE (get_pool_constant (operands[1])) == CONST_INT"
  [(set (match_dup 0) (match_dup 2))]
  "operands[2] = get_pool_constant (operands[1]);")

;
; movstrictqi instruction pattern(s).
;

(define_insn "*movstrictqi"
  [(set (strict_low_part (match_operand:QI 0 "register_operand" "+d,d"))
                         (match_operand:QI 1 "memory_operand" "R,T"))]
  ""
  "@
   ic\t%0,%1
   icy\t%0,%1"
  [(set_attr "op_type"  "RX,RXY")])

;
; movstricthi instruction pattern(s).
;

(define_insn "*movstricthi"
  [(set (strict_low_part (match_operand:HI 0 "register_operand" "+d,d"))
                         (match_operand:HI 1 "memory_operand" "Q,S"))
   (clobber (reg:CC CC_REGNUM))]
  ""
  "@
   icm\t%0,3,%S1
   icmy\t%0,3,%S1"
  [(set_attr "op_type" "RS,RSY")])

;
; movstrictsi instruction pattern(s).
;

(define_insn "movstrictsi"
  [(set (strict_low_part (match_operand:SI 0 "register_operand" "+d,d,d,d"))
                         (match_operand:SI 1 "general_operand" "d,R,T,t"))]
  "TARGET_64BIT"
  "@
   lr\t%0,%1
   l\t%0,%1
   ly\t%0,%1
   ear\t%0,%1"
  [(set_attr "op_type" "RR,RX,RXY,RRE")
   (set_attr "type" "lr,load,load,*")])

;
; movtf instruction pattern(s).
;

(define_expand "movtf"
  [(set (match_operand:TF 0 "nonimmediate_operand" "")
        (match_operand:TF 1 "general_operand"       ""))]
  ""
  "")

(define_insn "*movtf_64"
  [(set (match_operand:TF 0 "nonimmediate_operand" "=f,f,f,o,d,QS,d,o,Q")
        (match_operand:TF 1 "general_operand"       "G,f,o,f,QS,d,dm,d,Q"))]
  "TARGET_64BIT"
  "@
   lzxr\t%0
   lxr\t%0,%1
   #
   #
   lmg\t%0,%N0,%S1
   stmg\t%1,%N1,%S0
   #
   #
   #"
  [(set_attr "op_type" "RRE,RRE,*,*,RSY,RSY,*,*,*")
   (set_attr "type"    "fsimptf,fsimptf,*,*,lm,stm,*,*,*")])

(define_insn "*movtf_31"
  [(set (match_operand:TF 0 "nonimmediate_operand" "=f,f,f,o,Q")
        (match_operand:TF 1 "general_operand"       "G,f,o,f,Q"))]
  "!TARGET_64BIT"
  "@
   lzxr\t%0
   lxr\t%0,%1
   #
   #
   #"
  [(set_attr "op_type" "RRE,RRE,*,*,*")
   (set_attr "type"    "fsimptf,fsimptf,*,*,*")])

; TFmode in GPRs splitters

(define_split
  [(set (match_operand:TF 0 "nonimmediate_operand" "")
        (match_operand:TF 1 "general_operand" ""))]
  "TARGET_64BIT && reload_completed
   && s390_split_ok_p (operands[0], operands[1], TFmode, 0)"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
{
  operands[2] = operand_subword (operands[0], 0, 0, TFmode);
  operands[3] = operand_subword (operands[0], 1, 0, TFmode);
  operands[4] = operand_subword (operands[1], 0, 0, TFmode);
  operands[5] = operand_subword (operands[1], 1, 0, TFmode);
})

(define_split
  [(set (match_operand:TF 0 "nonimmediate_operand" "")
        (match_operand:TF 1 "general_operand" ""))]
  "TARGET_64BIT && reload_completed
   && s390_split_ok_p (operands[0], operands[1], TFmode, 1)"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
{
  operands[2] = operand_subword (operands[0], 1, 0, TFmode);
  operands[3] = operand_subword (operands[0], 0, 0, TFmode);
  operands[4] = operand_subword (operands[1], 1, 0, TFmode);
  operands[5] = operand_subword (operands[1], 0, 0, TFmode);
})

(define_split
  [(set (match_operand:TF 0 "register_operand" "")
        (match_operand:TF 1 "memory_operand" ""))]
  "TARGET_64BIT && reload_completed
   && !FP_REG_P (operands[0])
   && !s_operand (operands[1], VOIDmode)"
  [(set (match_dup 0) (match_dup 1))]
{
  rtx addr = operand_subword (operands[0], 1, 0, DFmode);
  s390_load_address (addr, XEXP (operands[1], 0));
  operands[1] = replace_equiv_address (operands[1], addr);
})

; TFmode in FPRs splitters

(define_split
  [(set (match_operand:TF 0 "register_operand" "")
        (match_operand:TF 1 "memory_operand" ""))]
  "reload_completed && offsettable_memref_p (operands[1]) 
   && FP_REG_P (operands[0])"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
{
  operands[2] = simplify_gen_subreg (DFmode, operands[0], TFmode, 0);
  operands[3] = simplify_gen_subreg (DFmode, operands[0], TFmode, 8);
  operands[4] = adjust_address_nv (operands[1], DFmode, 0);
  operands[5] = adjust_address_nv (operands[1], DFmode, 8);
})

(define_split
  [(set (match_operand:TF 0 "memory_operand" "")
        (match_operand:TF 1 "register_operand" ""))]
  "reload_completed && offsettable_memref_p (operands[0])
   && FP_REG_P (operands[1])"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
{
  operands[2] = adjust_address_nv (operands[0], DFmode, 0);
  operands[3] = adjust_address_nv (operands[0], DFmode, 8);
  operands[4] = simplify_gen_subreg (DFmode, operands[1], TFmode, 0);
  operands[5] = simplify_gen_subreg (DFmode, operands[1], TFmode, 8);
})

(define_expand "reload_outtf"
  [(parallel [(match_operand:TF 0 "" "")
              (match_operand:TF 1 "register_operand" "f")
              (match_operand:SI 2 "register_operand" "=&a")])]
  ""
{
  rtx addr = gen_lowpart (Pmode, operands[2]);

  gcc_assert (MEM_P (operands[0]));
  s390_load_address (addr, find_replacement (&XEXP (operands[0], 0)));
  operands[0] = replace_equiv_address (operands[0], addr);
  emit_move_insn (operands[0], operands[1]);
  DONE;
})

(define_expand "reload_intf"
  [(parallel [(match_operand:TF 0 "register_operand" "=f")
              (match_operand:TF 1 "" "")
              (match_operand:SI 2 "register_operand" "=&a")])]
  ""
{
  rtx addr = gen_lowpart (Pmode, operands[2]);
 
  gcc_assert (MEM_P (operands[1]));
  s390_load_address (addr, find_replacement (&XEXP (operands[1], 0)));
  operands[1] = replace_equiv_address (operands[1], addr);
  emit_move_insn (operands[0], operands[1]);
  DONE;
})

;
; movdf instruction pattern(s).
;

(define_expand "movdf"
  [(set (match_operand:DF 0 "nonimmediate_operand" "")
        (match_operand:DF 1 "general_operand"  ""))]
  ""
  "")

(define_insn "*movdf_64"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=f,f,f,f,R,T,d,d,m,?Q")
        (match_operand:DF 1 "general_operand" "G,f,R,T,f,f,d,m,d,?Q"))]
  "TARGET_64BIT"
  "@
   lzdr\t%0
   ldr\t%0,%1
   ld\t%0,%1
   ldy\t%0,%1
   std\t%1,%0
   stdy\t%1,%0
   lgr\t%0,%1
   lg\t%0,%1
   stg\t%1,%0
   #"
  [(set_attr "op_type" "RRE,RR,RX,RXY,RX,RXY,RRE,RXY,RXY,SS")
   (set_attr "type" "fsimpdf,floaddf,floaddf,floaddf,fstoredf,fstoredf,lr,load,store,*")])

(define_insn "*movdf_31"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=f,f,f,f,R,T,d,d,Q,S,d,o,Q")
        (match_operand:DF 1 "general_operand" "G,f,R,T,f,f,Q,S,d,d,dPm,d,Q"))]
  "!TARGET_64BIT"
  "@
   lzdr\t%0
   ldr\t%0,%1
   ld\t%0,%1
   ldy\t%0,%1
   std\t%1,%0
   stdy\t%1,%0
   lm\t%0,%N0,%S1
   lmy\t%0,%N0,%S1
   stm\t%1,%N1,%S0
   stmy\t%1,%N1,%S0
   #
   #
   #"
  [(set_attr "op_type" "RRE,RR,RX,RXY,RX,RXY,RS,RSY,RS,RSY,*,*,SS")
   (set_attr "type" "fsimpdf,floaddf,floaddf,floaddf,fstoredf,fstoredf,\
                     lm,lm,stm,stm,*,*,*")])

(define_split
  [(set (match_operand:DF 0 "nonimmediate_operand" "")
        (match_operand:DF 1 "general_operand" ""))]
  "!TARGET_64BIT && reload_completed
   && s390_split_ok_p (operands[0], operands[1], DFmode, 0)"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
{
  operands[2] = operand_subword (operands[0], 0, 0, DFmode);
  operands[3] = operand_subword (operands[0], 1, 0, DFmode);
  operands[4] = operand_subword (operands[1], 0, 0, DFmode);
  operands[5] = operand_subword (operands[1], 1, 0, DFmode);
})

(define_split
  [(set (match_operand:DF 0 "nonimmediate_operand" "")
        (match_operand:DF 1 "general_operand" ""))]
  "!TARGET_64BIT && reload_completed
   && s390_split_ok_p (operands[0], operands[1], DFmode, 1)"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
{
  operands[2] = operand_subword (operands[0], 1, 0, DFmode);
  operands[3] = operand_subword (operands[0], 0, 0, DFmode);
  operands[4] = operand_subword (operands[1], 1, 0, DFmode);
  operands[5] = operand_subword (operands[1], 0, 0, DFmode);
})

(define_split
  [(set (match_operand:DF 0 "register_operand" "")
        (match_operand:DF 1 "memory_operand" ""))]
  "!TARGET_64BIT && reload_completed
   && !FP_REG_P (operands[0])
   && !s_operand (operands[1], VOIDmode)"
  [(set (match_dup 0) (match_dup 1))]
{
  rtx addr = operand_subword (operands[0], 1, 0, DFmode);
  s390_load_address (addr, XEXP (operands[1], 0));
  operands[1] = replace_equiv_address (operands[1], addr);
})

(define_expand "reload_outdf"
  [(parallel [(match_operand:DF 0 "" "")
              (match_operand:DF 1 "register_operand" "d")
              (match_operand:SI 2 "register_operand" "=&a")])]
  "!TARGET_64BIT"
{
  gcc_assert (MEM_P (operands[0]));
  s390_load_address (operands[2], find_replacement (&XEXP (operands[0], 0)));
  operands[0] = replace_equiv_address (operands[0], operands[2]);
  emit_move_insn (operands[0], operands[1]);
  DONE;
})

;
; movsf instruction pattern(s).
;

(define_insn "movsf"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=f,f,f,f,R,T,d,d,d,R,T,?Q")
        (match_operand:SF 1 "general_operand" "G,f,R,T,f,f,d,R,T,d,d,?Q"))]
  ""
  "@
   lzer\t%0
   ler\t%0,%1
   le\t%0,%1
   ley\t%0,%1
   ste\t%1,%0
   stey\t%1,%0
   lr\t%0,%1
   l\t%0,%1
   ly\t%0,%1
   st\t%1,%0
   sty\t%1,%0
   #"
  [(set_attr "op_type" "RRE,RR,RX,RXY,RX,RXY,RR,RX,RXY,RX,RXY,SS")
   (set_attr "type" "fsimpsf,floadsf,floadsf,floadsf,fstoresf,fstoresf,
                     lr,load,load,store,store,*")])

;
; movcc instruction pattern
;

(define_insn "movcc"
  [(set (match_operand:CC 0 "nonimmediate_operand" "=d,c,d,d,d,R,T")
        (match_operand:CC 1 "nonimmediate_operand" "d,d,c,R,T,d,d"))]
  ""
  "@
   lr\t%0,%1
   tmh\t%1,12288
   ipm\t%0
   st\t%0,%1
   sty\t%0,%1
   l\t%1,%0
   ly\t%1,%0"
  [(set_attr "op_type" "RR,RI,RRE,RX,RXY,RX,RXY")
   (set_attr "type" "lr,*,*,store,store,load,load")])

;
; Block move (MVC) patterns.
;

(define_insn "*mvc"
  [(set (match_operand:BLK 0 "memory_operand" "=Q")
        (match_operand:BLK 1 "memory_operand" "Q"))
   (use (match_operand 2 "const_int_operand" "n"))]
  "INTVAL (operands[2]) >= 1 && INTVAL (operands[2]) <= 256"
  "mvc\t%O0(%2,%R0),%S1"
  [(set_attr "op_type" "SS")])

(define_split
  [(set (match_operand 0 "memory_operand" "")
        (match_operand 1 "memory_operand" ""))]
  "reload_completed
   && GET_MODE (operands[0]) == GET_MODE (operands[1])
   && GET_MODE_SIZE (GET_MODE (operands[0])) > 0"
  [(parallel
    [(set (match_dup 0) (match_dup 1))
     (use (match_dup 2))])]
{
  operands[2] = GEN_INT (GET_MODE_SIZE (GET_MODE (operands[0])));
  operands[0] = adjust_address (operands[0], BLKmode, 0);
  operands[1] = adjust_address (operands[1], BLKmode, 0);
})

(define_peephole2
  [(parallel
    [(set (match_operand:BLK 0 "memory_operand" "")
          (match_operand:BLK 1 "memory_operand" ""))
     (use (match_operand 2 "const_int_operand" ""))])
   (parallel
    [(set (match_operand:BLK 3 "memory_operand" "")
          (match_operand:BLK 4 "memory_operand" ""))
     (use (match_operand 5 "const_int_operand" ""))])]
  "s390_offset_p (operands[0], operands[3], operands[2])
   && s390_offset_p (operands[1], operands[4], operands[2])
   && !s390_overlap_p (operands[0], operands[1], 
                       INTVAL (operands[2]) + INTVAL (operands[5]))
   && INTVAL (operands[2]) + INTVAL (operands[5]) <= 256"
  [(parallel
    [(set (match_dup 6) (match_dup 7))
     (use (match_dup 8))])]
  "operands[6] = gen_rtx_MEM (BLKmode, XEXP (operands[0], 0));
   operands[7] = gen_rtx_MEM (BLKmode, XEXP (operands[1], 0));
   operands[8] = GEN_INT (INTVAL (operands[2]) + INTVAL (operands[5]));")


;
; load_multiple pattern(s).
;
; ??? Due to reload problems with replacing registers inside match_parallel
; we currently support load_multiple/store_multiple only after reload.
;

(define_expand "load_multiple"
  [(match_par_dup 3 [(set (match_operand 0 "" "")
                          (match_operand 1 "" ""))
                     (use (match_operand 2 "" ""))])]
  "reload_completed"
{
  enum machine_mode mode;
  int regno;
  int count;
  rtx from;
  int i, off;

  /* Support only loading a constant number of fixed-point registers from
     memory and only bother with this if more than two */
  if (GET_CODE (operands[2]) != CONST_INT
      || INTVAL (operands[2]) < 2
      || INTVAL (operands[2]) > 16
      || GET_CODE (operands[1]) != MEM
      || GET_CODE (operands[0]) != REG
      || REGNO (operands[0]) >= 16)
    FAIL;

  count = INTVAL (operands[2]);
  regno = REGNO (operands[0]);
  mode = GET_MODE (operands[0]);
  if (mode != SImode && mode != word_mode)
    FAIL;

  operands[3] = gen_rtx_PARALLEL (VOIDmode, rtvec_alloc (count));
  if (no_new_pseudos)
    {
      if (GET_CODE (XEXP (operands[1], 0)) == REG)
        {
          from = XEXP (operands[1], 0);
          off = 0;
        }
      else if (GET_CODE (XEXP (operands[1], 0)) == PLUS
               && GET_CODE (XEXP (XEXP (operands[1], 0), 0)) == REG
               && GET_CODE (XEXP (XEXP (operands[1], 0), 1)) == CONST_INT)
        {
          from = XEXP (XEXP (operands[1], 0), 0);
          off = INTVAL (XEXP (XEXP (operands[1], 0), 1));
        }
      else
        FAIL;
    }
  else
    {
      from = force_reg (Pmode, XEXP (operands[1], 0));
      off = 0;
    }

  for (i = 0; i < count; i++)
    XVECEXP (operands[3], 0, i)
      = gen_rtx_SET (VOIDmode, gen_rtx_REG (mode, regno + i),
                     change_address (operands[1], mode,
                       plus_constant (from, off + i * GET_MODE_SIZE (mode))));
})

(define_insn "*load_multiple_di"
  [(match_parallel 0 "load_multiple_operation"
                   [(set (match_operand:DI 1 "register_operand" "=r")
                         (match_operand:DI 2 "s_operand" "QS"))])]
  "reload_completed && word_mode == DImode"
{
  int words = XVECLEN (operands[0], 0);
  operands[0] = gen_rtx_REG (DImode, REGNO (operands[1]) + words - 1);
  return "lmg\t%1,%0,%S2";
}
   [(set_attr "op_type" "RSY")
    (set_attr "type"    "lm")])

(define_insn "*load_multiple_si"
  [(match_parallel 0 "load_multiple_operation"
                   [(set (match_operand:SI 1 "register_operand" "=r,r")
                         (match_operand:SI 2 "s_operand" "Q,S"))])]
  "reload_completed"
{
  int words = XVECLEN (operands[0], 0);
  operands[0] = gen_rtx_REG (SImode, REGNO (operands[1]) + words - 1);
  return which_alternative == 0 ? "lm\t%1,%0,%S2" : "lmy\t%1,%0,%S2";
}
   [(set_attr "op_type" "RS,RSY")
    (set_attr "type"    "lm")])

;
; store multiple pattern(s).
;

(define_expand "store_multiple"
  [(match_par_dup 3 [(set (match_operand 0 "" "")
                          (match_operand 1 "" ""))
                     (use (match_operand 2 "" ""))])]
  "reload_completed"
{
  enum machine_mode mode;
  int regno;
  int count;
  rtx to;
  int i, off;

  /* Support only storing a constant number of fixed-point registers to
     memory and only bother with this if more than two.  */
  if (GET_CODE (operands[2]) != CONST_INT
      || INTVAL (operands[2]) < 2
      || INTVAL (operands[2]) > 16
      || GET_CODE (operands[0]) != MEM
      || GET_CODE (operands[1]) != REG
      || REGNO (operands[1]) >= 16)
    FAIL;

  count = INTVAL (operands[2]);
  regno = REGNO (operands[1]);
  mode = GET_MODE (operands[1]);
  if (mode != SImode && mode != word_mode)
    FAIL;

  operands[3] = gen_rtx_PARALLEL (VOIDmode, rtvec_alloc (count));

  if (no_new_pseudos)
    {
      if (GET_CODE (XEXP (operands[0], 0)) == REG)
        {
          to = XEXP (operands[0], 0);
          off = 0;
        }
      else if (GET_CODE (XEXP (operands[0], 0)) == PLUS
               && GET_CODE (XEXP (XEXP (operands[0], 0), 0)) == REG
               && GET_CODE (XEXP (XEXP (operands[0], 0), 1)) == CONST_INT)
        {
          to = XEXP (XEXP (operands[0], 0), 0);
          off = INTVAL (XEXP (XEXP (operands[0], 0), 1));
        }
      else
        FAIL;
    }
  else
    {
      to = force_reg (Pmode, XEXP (operands[0], 0));
      off = 0;
    }

  for (i = 0; i < count; i++)
    XVECEXP (operands[3], 0, i)
      = gen_rtx_SET (VOIDmode,
                     change_address (operands[0], mode,
                       plus_constant (to, off + i * GET_MODE_SIZE (mode))),
                     gen_rtx_REG (mode, regno + i));
})

(define_insn "*store_multiple_di"
  [(match_parallel 0 "store_multiple_operation"
                   [(set (match_operand:DI 1 "s_operand" "=QS")
                         (match_operand:DI 2 "register_operand" "r"))])]
  "reload_completed && word_mode == DImode"
{
  int words = XVECLEN (operands[0], 0);
  operands[0] = gen_rtx_REG (DImode, REGNO (operands[2]) + words - 1);
  return "stmg\t%2,%0,%S1";
}
   [(set_attr "op_type" "RSY")
    (set_attr "type"    "stm")])


(define_insn "*store_multiple_si"
  [(match_parallel 0 "store_multiple_operation"
                   [(set (match_operand:SI 1 "s_operand" "=Q,S")
                         (match_operand:SI 2 "register_operand" "r,r"))])]
  "reload_completed"
{
  int words = XVECLEN (operands[0], 0);
  operands[0] = gen_rtx_REG (SImode, REGNO (operands[2]) + words - 1);
  return which_alternative == 0 ? "stm\t%2,%0,%S1" : "stmy\t%2,%0,%S1";
}
   [(set_attr "op_type" "RS,RSY")
    (set_attr "type"    "stm")])

;;
;; String instructions.
;;

(define_insn "*execute"
  [(match_parallel 0 ""
    [(unspec [(match_operand 1 "register_operand" "a")
              (match_operand:BLK 2 "memory_operand" "R")
              (match_operand 3 "" "")] UNSPEC_EXECUTE)])]
  "GET_MODE_CLASS (GET_MODE (operands[1])) == MODE_INT
   && GET_MODE_SIZE (GET_MODE (operands[1])) <= UNITS_PER_WORD"
  "ex\t%1,%2"
  [(set_attr "op_type" "RX")
   (set_attr "type" "cs")])


;
; strlenM instruction pattern(s).
;

(define_expand "strlen<mode>"
  [(set (reg:SI 0) (match_operand:SI 2 "immediate_operand" ""))
   (parallel
    [(set (match_dup 4)
          (unspec:P [(const_int 0)
                      (match_operand:BLK 1 "memory_operand" "")
                      (reg:SI 0)
                      (match_operand 3 "immediate_operand" "")] UNSPEC_SRST))
     (clobber (scratch:P))
     (clobber (reg:CC CC_REGNUM))])
   (parallel
    [(set (match_operand:P 0 "register_operand" "")
          (minus:P (match_dup 4) (match_dup 5)))
     (clobber (reg:CC CC_REGNUM))])]
  ""
{
  operands[4] = gen_reg_rtx (Pmode);
  operands[5] = gen_reg_rtx (Pmode);
  emit_move_insn (operands[5], force_operand (XEXP (operands[1], 0), NULL_RTX));
  operands[1] = replace_equiv_address (operands[1], operands[5]);
})

(define_insn "*strlen<mode>"
  [(set (match_operand:P 0 "register_operand" "=a")
        (unspec:P [(match_operand:P 2 "general_operand" "0")
                    (mem:BLK (match_operand:P 3 "register_operand" "1"))
                    (reg:SI 0)
                    (match_operand 4 "immediate_operand" "")] UNSPEC_SRST))
   (clobber (match_scratch:P 1 "=a"))
   (clobber (reg:CC CC_REGNUM))]
  ""
  "srst\t%0,%1\;jo\t.-4"
  [(set_attr "length" "8")
   (set_attr "type" "vs")])

;
; cmpstrM instruction pattern(s).
;

(define_expand "cmpstrsi"
  [(set (reg:SI 0) (const_int 0))
   (parallel
    [(clobber (match_operand 3 "" ""))
     (clobber (match_dup 4))
     (set (reg:CCU CC_REGNUM)
          (compare:CCU (match_operand:BLK 1 "memory_operand" "")
                        (match_operand:BLK 2 "memory_operand" "")))
     (use (reg:SI 0))])
   (parallel
    [(set (match_operand:SI 0 "register_operand" "=d")
          (unspec:SI [(reg:CCU CC_REGNUM)] UNSPEC_CMPINT))
     (clobber (reg:CC CC_REGNUM))])]
  ""
{
  /* As the result of CMPINT is inverted compared to what we need,
     we have to swap the operands.  */
  rtx op1 = operands[2];
  rtx op2 = operands[1];
  rtx addr1 = gen_reg_rtx (Pmode);
  rtx addr2 = gen_reg_rtx (Pmode);

  emit_move_insn (addr1, force_operand (XEXP (op1, 0), NULL_RTX));
  emit_move_insn (addr2, force_operand (XEXP (op2, 0), NULL_RTX));
  operands[1] = replace_equiv_address_nv (op1, addr1);
  operands[2] = replace_equiv_address_nv (op2, addr2);
  operands[3] = addr1;
  operands[4] = addr2;
})

(define_insn "*cmpstr<mode>"
  [(clobber (match_operand:P 0 "register_operand" "=d"))
   (clobber (match_operand:P 1 "register_operand" "=d"))
   (set (reg:CCU CC_REGNUM)
        (compare:CCU (mem:BLK (match_operand:P 2 "register_operand" "0"))
                     (mem:BLK (match_operand:P 3 "register_operand" "1"))))
   (use (reg:SI 0))]
  ""
  "clst\t%0,%1\;jo\t.-4"
  [(set_attr "length" "8")
   (set_attr "type" "vs")])
 
;
; movstr instruction pattern.
;

(define_expand "movstr"
  [(set (reg:SI 0) (const_int 0))
   (parallel 
    [(clobber (match_dup 3))
     (set (match_operand:BLK 1 "memory_operand" "")
          (match_operand:BLK 2 "memory_operand" ""))
     (set (match_operand 0 "register_operand" "")
          (unspec [(match_dup 1) 
                   (match_dup 2)
                   (reg:SI 0)] UNSPEC_MVST))
     (clobber (reg:CC CC_REGNUM))])]
  ""
{
  rtx addr1 = gen_reg_rtx (Pmode);
  rtx addr2 = gen_reg_rtx (Pmode);

  emit_move_insn (addr1, force_operand (XEXP (operands[1], 0), NULL_RTX));
  emit_move_insn (addr2, force_operand (XEXP (operands[2], 0), NULL_RTX));
  operands[1] = replace_equiv_address_nv (operands[1], addr1);
  operands[2] = replace_equiv_address_nv (operands[2], addr2);
  operands[3] = addr2;
})

(define_insn "*movstr"
  [(clobber (match_operand:P 2 "register_operand" "=d"))
   (set (mem:BLK (match_operand:P 1 "register_operand" "0"))
        (mem:BLK (match_operand:P 3 "register_operand" "2")))
   (set (match_operand:P 0 "register_operand" "=d")
        (unspec [(mem:BLK (match_dup 1)) 
                 (mem:BLK (match_dup 3))
                 (reg:SI 0)] UNSPEC_MVST))
   (clobber (reg:CC CC_REGNUM))]
  ""
  "mvst\t%1,%2\;jo\t.-4"
  [(set_attr "length" "8")
   (set_attr "type" "vs")])
  

;
; movmemM instruction pattern(s).
;

(define_expand "movmem<mode>"
  [(set (match_operand:BLK 0 "memory_operand" "")
        (match_operand:BLK 1 "memory_operand" ""))
   (use (match_operand:GPR 2 "general_operand" ""))
   (match_operand 3 "" "")]
  ""
  "s390_expand_movmem (operands[0], operands[1], operands[2]); DONE;")

; Move a block that is up to 256 bytes in length.
; The block length is taken as (operands[2] % 256) + 1.

(define_expand "movmem_short"
  [(parallel
    [(set (match_operand:BLK 0 "memory_operand" "")
          (match_operand:BLK 1 "memory_operand" ""))
     (use (match_operand 2 "nonmemory_operand" ""))
     (use (const:BLK (unspec:BLK [(const_int 0)] UNSPEC_INSN)))
     (clobber (match_dup 3))])]
  ""
  "operands[3] = gen_rtx_SCRATCH (Pmode);")

(define_insn "*movmem_short"
  [(set (match_operand:BLK 0 "memory_operand" "=Q,Q,Q")
        (match_operand:BLK 1 "memory_operand" "Q,Q,Q"))
   (use (match_operand 2 "nonmemory_operand" "n,a,a"))
   (use (match_operand 3 "immediate_operand" "X,R,X"))
   (clobber (match_scratch 4 "=X,X,&a"))]
  "(GET_MODE (operands[2]) == Pmode || GET_MODE (operands[2]) == VOIDmode)
   && GET_MODE (operands[4]) == Pmode"
  "#"
  [(set_attr "type" "cs")])

(define_split
  [(set (match_operand:BLK 0 "memory_operand" "")
        (match_operand:BLK 1 "memory_operand" ""))
   (use (match_operand 2 "const_int_operand" ""))
   (use (match_operand 3 "immediate_operand" ""))
   (clobber (scratch))]
  "reload_completed"
  [(parallel
    [(set (match_dup 0) (match_dup 1))
     (use (match_dup 2))])]
  "operands[2] = GEN_INT ((INTVAL (operands[2]) & 0xff) + 1);")

(define_split
  [(set (match_operand:BLK 0 "memory_operand" "")
        (match_operand:BLK 1 "memory_operand" ""))
   (use (match_operand 2 "register_operand" ""))
   (use (match_operand 3 "memory_operand" ""))
   (clobber (scratch))]
  "reload_completed"
  [(parallel
    [(unspec [(match_dup 2) (match_dup 3)
              (const_int 0)] UNSPEC_EXECUTE)
     (set (match_dup 0) (match_dup 1))
     (use (const_int 1))])]
  "")

(define_split
  [(set (match_operand:BLK 0 "memory_operand" "")
        (match_operand:BLK 1 "memory_operand" ""))
   (use (match_operand 2 "register_operand" ""))
   (use (const:BLK (unspec:BLK [(const_int 0)] UNSPEC_INSN)))
   (clobber (match_operand 3 "register_operand" ""))]
  "reload_completed && TARGET_CPU_ZARCH"
  [(set (match_dup 3) (label_ref (match_dup 4)))
   (parallel
    [(unspec [(match_dup 2) (mem:BLK (match_dup 3)) 
              (label_ref (match_dup 4))] UNSPEC_EXECUTE)
     (set (match_dup 0) (match_dup 1))
     (use (const_int 1))])]
  "operands[4] = gen_label_rtx ();")

; Move a block of arbitrary length.

(define_expand "movmem_long"
  [(parallel
    [(clobber (match_dup 2))
     (clobber (match_dup 3))
     (set (match_operand:BLK 0 "memory_operand" "")
          (match_operand:BLK 1 "memory_operand" ""))
     (use (match_operand 2 "general_operand" ""))
     (use (match_dup 3))
     (clobber (reg:CC CC_REGNUM))])]
  ""
{
  enum machine_mode dword_mode = word_mode == DImode ? TImode : DImode;
  rtx reg0 = gen_reg_rtx (dword_mode);
  rtx reg1 = gen_reg_rtx (dword_mode);
  rtx addr0 = gen_lowpart (Pmode, gen_highpart (word_mode, reg0));
  rtx addr1 = gen_lowpart (Pmode, gen_highpart (word_mode, reg1));
  rtx len0 = gen_lowpart (Pmode, reg0);
  rtx len1 = gen_lowpart (Pmode, reg1);

  emit_insn (gen_rtx_CLOBBER (VOIDmode, reg0));
  emit_move_insn (addr0, force_operand (XEXP (operands[0], 0), NULL_RTX));
  emit_move_insn (len0, operands[2]);

  emit_insn (gen_rtx_CLOBBER (VOIDmode, reg1));
  emit_move_insn (addr1, force_operand (XEXP (operands[1], 0), NULL_RTX));
  emit_move_insn (len1, operands[2]);

  operands[0] = replace_equiv_address_nv (operands[0], addr0);
  operands[1] = replace_equiv_address_nv (operands[1], addr1);
  operands[2] = reg0;
  operands[3] = reg1;
})

(define_insn "*movmem_long"
  [(clobber (match_operand:<DBL> 0 "register_operand" "=d"))
   (clobber (match_operand:<DBL> 1 "register_operand" "=d"))
   (set (mem:BLK (subreg:P (match_operand:<DBL> 2 "register_operand" "0") 0))
        (mem:BLK (subreg:P (match_operand:<DBL> 3 "register_operand" "1") 0)))
   (use (match_dup 2))
   (use (match_dup 3))
   (clobber (reg:CC CC_REGNUM))]
  ""
  "mvcle\t%0,%1,0\;jo\t.-4"
  [(set_attr "length" "8")
   (set_attr "type" "vs")])

;
; setmemM instruction pattern(s).
;

(define_expand "setmem<mode>"
  [(set (match_operand:BLK 0 "memory_operand" "")
        (match_operand:QI 2 "general_operand" ""))
   (use (match_operand:GPR 1 "general_operand" ""))
   (match_operand 3 "" "")]
  ""
  "s390_expand_setmem (operands[0], operands[1], operands[2]); DONE;")

; Clear a block that is up to 256 bytes in length.
; The block length is taken as (operands[1] % 256) + 1.

(define_expand "clrmem_short"
  [(parallel
    [(set (match_operand:BLK 0 "memory_operand" "")
          (const_int 0))
     (use (match_operand 1 "nonmemory_operand" ""))
     (use (const:BLK (unspec:BLK [(const_int 0)] UNSPEC_INSN)))
     (clobber (match_dup 2))
     (clobber (reg:CC CC_REGNUM))])]
  ""
  "operands[2] = gen_rtx_SCRATCH (Pmode);")

(define_insn "*clrmem_short"
  [(set (match_operand:BLK 0 "memory_operand" "=Q,Q,Q")
        (const_int 0))
   (use (match_operand 1 "nonmemory_operand" "n,a,a"))
   (use (match_operand 2 "immediate_operand" "X,R,X"))
   (clobber (match_scratch 3 "=X,X,&a"))
   (clobber (reg:CC CC_REGNUM))]
  "(GET_MODE (operands[1]) == Pmode || GET_MODE (operands[1]) == VOIDmode)
   && GET_MODE (operands[3]) == Pmode"
  "#"
  [(set_attr "type" "cs")])

(define_split
  [(set (match_operand:BLK 0 "memory_operand" "")
        (const_int 0))
   (use (match_operand 1 "const_int_operand" ""))
   (use (match_operand 2 "immediate_operand" ""))
   (clobber (scratch))
   (clobber (reg:CC CC_REGNUM))]
  "reload_completed"
  [(parallel
    [(set (match_dup 0) (const_int 0))
     (use (match_dup 1))
     (clobber (reg:CC CC_REGNUM))])]
  "operands[1] = GEN_INT ((INTVAL (operands[1]) & 0xff) + 1);")

(define_split
  [(set (match_operand:BLK 0 "memory_operand" "")
        (const_int 0))
   (use (match_operand 1 "register_operand" ""))
   (use (match_operand 2 "memory_operand" ""))
   (clobber (scratch))
   (clobber (reg:CC CC_REGNUM))]
  "reload_completed"
  [(parallel
    [(unspec [(match_dup 1) (match_dup 2)
              (const_int 0)] UNSPEC_EXECUTE)
     (set (match_dup 0) (const_int 0))
     (use (const_int 1))
     (clobber (reg:CC CC_REGNUM))])]
  "")

(define_split
  [(set (match_operand:BLK 0 "memory_operand" "")
        (const_int 0))
   (use (match_operand 1 "register_operand" ""))
   (use (const:BLK (unspec:BLK [(const_int 0)] UNSPEC_INSN)))
   (clobber (match_operand 2 "register_operand" ""))
   (clobber (reg:CC CC_REGNUM))]
  "reload_completed && TARGET_CPU_ZARCH"
  [(set (match_dup 2) (label_ref (match_dup 3)))
   (parallel
    [(unspec [(match_dup 1) (mem:BLK (match_dup 2)) 
              (label_ref (match_dup 3))] UNSPEC_EXECUTE)
     (set (match_dup 0) (const_int 0))
     (use (const_int 1))
     (clobber (reg:CC CC_REGNUM))])]
  "operands[3] = gen_label_rtx ();")

; Initialize a block of arbitrary length with (operands[2] % 256). 

(define_expand "setmem_long"
  [(parallel
    [(clobber (match_dup 1))
     (set (match_operand:BLK 0 "memory_operand" "")
          (match_operand 2 "shift_count_or_setmem_operand" ""))
     (use (match_operand 1 "general_operand" ""))
     (use (match_dup 3))
     (clobber (reg:CC CC_REGNUM))])]
  ""
{
  enum machine_mode dword_mode = word_mode == DImode ? TImode : DImode;
  rtx reg0 = gen_reg_rtx (dword_mode);
  rtx reg1 = gen_reg_rtx (dword_mode);
  rtx addr0 = gen_lowpart (Pmode, gen_highpart (word_mode, reg0));
  rtx len0 = gen_lowpart (Pmode, reg0);

  emit_insn (gen_rtx_CLOBBER (VOIDmode, reg0));
  emit_move_insn (addr0, force_operand (XEXP (operands[0], 0), NULL_RTX));
  emit_move_insn (len0, operands[1]);

  emit_move_insn (reg1, const0_rtx);

  operands[0] = replace_equiv_address_nv (operands[0], addr0);
  operands[1] = reg0;
  operands[3] = reg1;
})

(define_insn "*setmem_long"
  [(clobber (match_operand:<DBL> 0 "register_operand" "=d"))
   (set (mem:BLK (subreg:P (match_operand:<DBL> 3 "register_operand" "0") 0))
        (match_operand 2 "shift_count_or_setmem_operand" "Y"))
   (use (match_dup 3))
   (use (match_operand:<DBL> 1 "register_operand" "d"))
   (clobber (reg:CC CC_REGNUM))]
  ""
  "mvcle\t%0,%1,%Y2\;jo\t.-4"
  [(set_attr "length" "8")
   (set_attr "type" "vs")])

(define_insn "*setmem_long_and"
  [(clobber (match_operand:<DBL> 0 "register_operand" "=d"))
   (set (mem:BLK (subreg:P (match_operand:<DBL> 3 "register_operand" "0") 0))
        (and (match_operand 2 "shift_count_or_setmem_operand" "Y")
             (match_operand 4 "const_int_operand"             "n")))
   (use (match_dup 3))
   (use (match_operand:<DBL> 1 "register_operand" "d"))
   (clobber (reg:CC CC_REGNUM))]
  "(INTVAL (operands[4]) & 255) == 255"
  "mvcle\t%0,%1,%Y2\;jo\t.-4"
  [(set_attr "length" "8")
   (set_attr "type" "vs")])
;
; cmpmemM instruction pattern(s).
;

(define_expand "cmpmemsi"
  [(set (match_operand:SI 0 "register_operand" "")
        (compare:SI (match_operand:BLK 1 "memory_operand" "")
                    (match_operand:BLK 2 "memory_operand" "") ) )
   (use (match_operand:SI 3 "general_operand" ""))
   (use (match_operand:SI 4 "" ""))]
  ""
  "s390_expand_cmpmem (operands[0], operands[1],
                       operands[2], operands[3]); DONE;")

; Compare a block that is up to 256 bytes in length.
; The block length is taken as (operands[2] % 256) + 1.

(define_expand "cmpmem_short"
  [(parallel
    [(set (reg:CCU CC_REGNUM)
          (compare:CCU (match_operand:BLK 0 "memory_operand" "")
                       (match_operand:BLK 1 "memory_operand" "")))
     (use (match_operand 2 "nonmemory_operand" ""))
     (use (const:BLK (unspec:BLK [(const_int 0)] UNSPEC_INSN)))
     (clobber (match_dup 3))])]
  ""
  "operands[3] = gen_rtx_SCRATCH (Pmode);")

(define_insn "*cmpmem_short"
  [(set (reg:CCU CC_REGNUM)
        (compare:CCU (match_operand:BLK 0 "memory_operand" "Q,Q,Q")
                     (match_operand:BLK 1 "memory_operand" "Q,Q,Q")))
   (use (match_operand 2 "nonmemory_operand" "n,a,a"))
   (use (match_operand 3 "immediate_operand" "X,R,X"))
   (clobber (match_scratch 4 "=X,X,&a"))]
  "(GET_MODE (operands[2]) == Pmode || GET_MODE (operands[2]) == VOIDmode)
   && GET_MODE (operands[4]) == Pmode"
  "#"
  [(set_attr "type" "cs")])

(define_split
  [(set (reg:CCU CC_REGNUM)
        (compare:CCU (match_operand:BLK 0 "memory_operand" "")
                     (match_operand:BLK 1 "memory_operand" "")))
   (use (match_operand 2 "const_int_operand" ""))
   (use (match_operand 3 "immediate_operand" ""))
   (clobber (scratch))]
  "reload_completed"
  [(parallel
    [(set (reg:CCU CC_REGNUM) (compare:CCU (match_dup 0) (match_dup 1)))
     (use (match_dup 2))])]
  "operands[2] = GEN_INT ((INTVAL (operands[2]) & 0xff) + 1);")

(define_split
  [(set (reg:CCU CC_REGNUM)
        (compare:CCU (match_operand:BLK 0 "memory_operand" "")
                     (match_operand:BLK 1 "memory_operand" "")))
   (use (match_operand 2 "register_operand" ""))
   (use (match_operand 3 "memory_operand" ""))
   (clobber (scratch))]
  "reload_completed"
  [(parallel
    [(unspec [(match_dup 2) (match_dup 3)
              (const_int 0)] UNSPEC_EXECUTE)
     (set (reg:CCU CC_REGNUM) (compare:CCU (match_dup 0) (match_dup 1)))
     (use (const_int 1))])]
  "")

(define_split
  [(set (reg:CCU CC_REGNUM)
        (compare:CCU (match_operand:BLK 0 "memory_operand" "")
                     (match_operand:BLK 1 "memory_operand" "")))
   (use (match_operand 2 "register_operand" ""))
   (use (const:BLK (unspec:BLK [(const_int 0)] UNSPEC_INSN)))
   (clobber (match_operand 3 "register_operand" ""))]
  "reload_completed && TARGET_CPU_ZARCH"
  [(set (match_dup 3) (label_ref (match_dup 4)))
   (parallel
    [(unspec [(match_dup 2) (mem:BLK (match_dup 3)) 
              (label_ref (match_dup 4))] UNSPEC_EXECUTE)
     (set (reg:CCU CC_REGNUM) (compare:CCU (match_dup 0) (match_dup 1)))
     (use (const_int 1))])]
  "operands[4] = gen_label_rtx ();")

; Compare a block of arbitrary length.

(define_expand "cmpmem_long"
  [(parallel
    [(clobber (match_dup 2))
     (clobber (match_dup 3))
     (set (reg:CCU CC_REGNUM)
          (compare:CCU (match_operand:BLK 0 "memory_operand" "")
                       (match_operand:BLK 1 "memory_operand" "")))
     (use (match_operand 2 "general_operand" ""))
     (use (match_dup 3))])]
  ""
{
  enum machine_mode dword_mode = word_mode == DImode ? TImode : DImode;
  rtx reg0 = gen_reg_rtx (dword_mode);
  rtx reg1 = gen_reg_rtx (dword_mode);
  rtx addr0 = gen_lowpart (Pmode, gen_highpart (word_mode, reg0));
  rtx addr1 = gen_lowpart (Pmode, gen_highpart (word_mode, reg1));
  rtx len0 = gen_lowpart (Pmode, reg0);
  rtx len1 = gen_lowpart (Pmode, reg1);

  emit_insn (gen_rtx_CLOBBER (VOIDmode, reg0));
  emit_move_insn (addr0, force_operand (XEXP (operands[0], 0), NULL_RTX));
  emit_move_insn (len0, operands[2]);

  emit_insn (gen_rtx_CLOBBER (VOIDmode, reg1));
  emit_move_insn (addr1, force_operand (XEXP (operands[1], 0), NULL_RTX));
  emit_move_insn (len1, operands[2]);

  operands[0] = replace_equiv_address_nv (operands[0], addr0);
  operands[1] = replace_equiv_address_nv (operands[1], addr1);
  operands[2] = reg0;
  operands[3] = reg1;
})

(define_insn "*cmpmem_long"
  [(clobber (match_operand:<DBL> 0 "register_operand" "=d"))
   (clobber (match_operand:<DBL> 1 "register_operand" "=d"))
   (set (reg:CCU CC_REGNUM)
        (compare:CCU (mem:BLK (subreg:P (match_operand:<DBL> 2 "register_operand" "0") 0))
                     (mem:BLK (subreg:P (match_operand:<DBL> 3 "register_operand" "1") 0))))
   (use (match_dup 2))
   (use (match_dup 3))]
  ""
  "clcle\t%0,%1,0\;jo\t.-4"
  [(set_attr "length" "8")
   (set_attr "type" "vs")])

; Convert CCUmode condition code to integer.
; Result is zero if EQ, positive if LTU, negative if GTU.

(define_insn_and_split "cmpint"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (unspec:SI [(match_operand:CCU 1 "register_operand" "0")]
                   UNSPEC_CMPINT))
   (clobber (reg:CC CC_REGNUM))]
  ""
  "#"
  "reload_completed"
  [(set (match_dup 0) (ashift:SI (match_dup 0) (const_int 2)))
   (parallel
    [(set (match_dup 0) (ashiftrt:SI (match_dup 0) (const_int 30)))
     (clobber (reg:CC CC_REGNUM))])])

(define_insn_and_split "*cmpint_cc"
  [(set (reg CC_REGNUM)
        (compare (unspec:SI [(match_operand:CCU 1 "register_operand" "0")]
                            UNSPEC_CMPINT)
                 (const_int 0)))
   (set (match_operand:SI 0 "register_operand" "=d")
        (unspec:SI [(match_dup 1)] UNSPEC_CMPINT))]
  "s390_match_ccmode (insn, CCSmode)"
  "#"
  "&& reload_completed"
  [(set (match_dup 0) (ashift:SI (match_dup 0) (const_int 2)))
   (parallel
    [(set (match_dup 2) (match_dup 3))
     (set (match_dup 0) (ashiftrt:SI (match_dup 0) (const_int 30)))])]
{
  rtx result = gen_rtx_ASHIFTRT (SImode, operands[0], GEN_INT (30));
  operands[2] = SET_DEST (XVECEXP (PATTERN (curr_insn), 0, 0));
  operands[3] = gen_rtx_COMPARE (GET_MODE (operands[2]), result, const0_rtx);
})

(define_insn_and_split "*cmpint_sign"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (sign_extend:DI (unspec:SI [(match_operand:CCU 1 "register_operand" "0")]
                                   UNSPEC_CMPINT)))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT"
  "#"
  "&& reload_completed"
  [(set (match_dup 0) (ashift:DI (match_dup 0) (const_int 34)))
   (parallel
    [(set (match_dup 0) (ashiftrt:DI (match_dup 0) (const_int 62)))
     (clobber (reg:CC CC_REGNUM))])])

(define_insn_and_split "*cmpint_sign_cc"
  [(set (reg CC_REGNUM)
        (compare (ashiftrt:DI (ashift:DI (subreg:DI 
                   (unspec:SI [(match_operand:CCU 1 "register_operand" "0")]
                              UNSPEC_CMPINT) 0)
                   (const_int 32)) (const_int 32))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d")
        (sign_extend:DI (unspec:SI [(match_dup 1)] UNSPEC_CMPINT)))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_64BIT"
  "#"
  "&& reload_completed"
  [(set (match_dup 0) (ashift:DI (match_dup 0) (const_int 34)))
   (parallel
    [(set (match_dup 2) (match_dup 3))
     (set (match_dup 0) (ashiftrt:DI (match_dup 0) (const_int 62)))])]
{
  rtx result = gen_rtx_ASHIFTRT (DImode, operands[0], GEN_INT (62));
  operands[2] = SET_DEST (XVECEXP (PATTERN (curr_insn), 0, 0));
  operands[3] = gen_rtx_COMPARE (GET_MODE (operands[2]), result, const0_rtx);
})


;;
;;- Conversion instructions.
;;

(define_insn "*sethighpartsi"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (unspec:SI [(match_operand:BLK 1 "s_operand" "Q,S")
                    (match_operand 2 "const_int_operand" "n,n")] UNSPEC_ICM))
   (clobber (reg:CC CC_REGNUM))]
  ""
  "@
   icm\t%0,%2,%S1
   icmy\t%0,%2,%S1"
  [(set_attr "op_type" "RS,RSY")])

(define_insn "*sethighpartdi_64"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (unspec:DI [(match_operand:BLK 1 "s_operand" "QS")
                    (match_operand 2 "const_int_operand" "n")] UNSPEC_ICM))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT"
  "icmh\t%0,%2,%S1"
  [(set_attr "op_type" "RSY")])

(define_insn "*sethighpartdi_31"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (unspec:DI [(match_operand:BLK 1 "s_operand" "Q,S")
                    (match_operand 2 "const_int_operand" "n,n")] UNSPEC_ICM))
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_64BIT"
  "@
   icm\t%0,%2,%S1
   icmy\t%0,%2,%S1"
  [(set_attr "op_type" "RS,RSY")])

(define_insn_and_split "*extzv<mode>"
  [(set (match_operand:GPR 0 "register_operand" "=d")
        (zero_extract:GPR (match_operand:QI 1 "s_operand" "QS")
                          (match_operand 2 "const_int_operand" "n")
                          (const_int 0)))
   (clobber (reg:CC CC_REGNUM))]
  "INTVAL (operands[2]) > 0
   && INTVAL (operands[2]) <= GET_MODE_BITSIZE (SImode)"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (match_dup 0) (unspec:GPR [(match_dup 1) (match_dup 3)] UNSPEC_ICM))
     (clobber (reg:CC CC_REGNUM))])
   (set (match_dup 0) (lshiftrt:GPR (match_dup 0) (match_dup 2)))]
{
  int bitsize = INTVAL (operands[2]);
  int size = (bitsize - 1) / BITS_PER_UNIT + 1; /* round up */
  int mask = ((1ul << size) - 1) << (GET_MODE_SIZE (SImode) - size);

  operands[1] = adjust_address (operands[1], BLKmode, 0);
  set_mem_size (operands[1], GEN_INT (size));
  operands[2] = GEN_INT (GET_MODE_BITSIZE (<MODE>mode) - bitsize);
  operands[3] = GEN_INT (mask);
})

(define_insn_and_split "*extv<mode>"
  [(set (match_operand:GPR 0 "register_operand" "=d")
        (sign_extract:GPR (match_operand:QI 1 "s_operand" "QS")
                          (match_operand 2 "const_int_operand" "n")
                          (const_int 0)))
   (clobber (reg:CC CC_REGNUM))]
  "INTVAL (operands[2]) > 0
   && INTVAL (operands[2]) <= GET_MODE_BITSIZE (SImode)"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (match_dup 0) (unspec:GPR [(match_dup 1) (match_dup 3)] UNSPEC_ICM))
     (clobber (reg:CC CC_REGNUM))])
   (parallel
    [(set (match_dup 0) (ashiftrt:GPR (match_dup 0) (match_dup 2)))
     (clobber (reg:CC CC_REGNUM))])]
{
  int bitsize = INTVAL (operands[2]);
  int size = (bitsize - 1) / BITS_PER_UNIT + 1; /* round up */
  int mask = ((1ul << size) - 1) << (GET_MODE_SIZE (SImode) - size);

  operands[1] = adjust_address (operands[1], BLKmode, 0);
  set_mem_size (operands[1], GEN_INT (size));
  operands[2] = GEN_INT (GET_MODE_BITSIZE (<MODE>mode) - bitsize);
  operands[3] = GEN_INT (mask);
})

;
; insv instruction patterns
;

(define_expand "insv"
  [(set (zero_extract (match_operand 0 "nonimmediate_operand" "")
                      (match_operand 1 "const_int_operand" "")
                      (match_operand 2 "const_int_operand" ""))
        (match_operand 3 "general_operand" ""))]
  ""
{
  if (s390_expand_insv (operands[0], operands[1], operands[2], operands[3]))
    DONE;
  FAIL;
})

(define_insn "*insv<mode>_mem_reg"
  [(set (zero_extract:P (match_operand:QI 0 "memory_operand" "+Q,S")
                        (match_operand 1 "const_int_operand" "n,n")
                        (const_int 0))
        (match_operand:P 2 "register_operand" "d,d"))]
  "INTVAL (operands[1]) > 0
   && INTVAL (operands[1]) <= GET_MODE_BITSIZE (SImode)
   && INTVAL (operands[1]) % BITS_PER_UNIT == 0"
{
    int size = INTVAL (operands[1]) / BITS_PER_UNIT;

    operands[1] = GEN_INT ((1ul << size) - 1);
    return (which_alternative == 0) ? "stcm\t%2,%1,%S0" 
                                    : "stcmy\t%2,%1,%S0";
}
  [(set_attr "op_type" "RS,RSY")])

(define_insn "*insvdi_mem_reghigh"
  [(set (zero_extract:DI (match_operand:QI 0 "memory_operand" "+QS")
                         (match_operand 1 "const_int_operand" "n")
                         (const_int 0))
        (lshiftrt:DI (match_operand:DI 2 "register_operand" "d")
                     (const_int 32)))]
  "TARGET_64BIT
   && INTVAL (operands[1]) > 0
   && INTVAL (operands[1]) <= GET_MODE_BITSIZE (SImode)
   && INTVAL (operands[1]) % BITS_PER_UNIT == 0"
{
    int size = INTVAL (operands[1]) / BITS_PER_UNIT;

    operands[1] = GEN_INT ((1ul << size) - 1);
    return "stcmh\t%2,%1,%S0";
}
[(set_attr "op_type" "RSY")])

(define_insn "*insv<mode>_reg_imm"
  [(set (zero_extract:P (match_operand:P 0 "register_operand" "+d")
                        (const_int 16)
                        (match_operand 1 "const_int_operand" "n"))
        (match_operand:P 2 "const_int_operand" "n"))]
  "TARGET_ZARCH
   && INTVAL (operands[1]) >= 0
   && INTVAL (operands[1]) < BITS_PER_WORD
   && INTVAL (operands[1]) % 16 == 0"
{
  switch (BITS_PER_WORD - INTVAL (operands[1]))
    {
      case 64: return "iihh\t%0,%x2"; break;
      case 48: return "iihl\t%0,%x2"; break;
      case 32: return "iilh\t%0,%x2"; break;
      case 16: return "iill\t%0,%x2"; break;
      default: gcc_unreachable();
    }
}
  [(set_attr "op_type" "RI")])

(define_insn "*insv<mode>_reg_extimm"
  [(set (zero_extract:P (match_operand:P 0 "register_operand" "+d")
                        (const_int 32)
                        (match_operand 1 "const_int_operand" "n"))
        (match_operand:P 2 "const_int_operand" "n"))]
  "TARGET_EXTIMM
   && INTVAL (operands[1]) >= 0
   && INTVAL (operands[1]) < BITS_PER_WORD
   && INTVAL (operands[1]) % 32 == 0"
{
  switch (BITS_PER_WORD - INTVAL (operands[1]))
    {
      case 64: return "iihf\t%0,%o2"; break;
      case 32: return "iilf\t%0,%o2"; break;
      default: gcc_unreachable();
    }
}
  [(set_attr "op_type" "RIL")])

;
; extendsidi2 instruction pattern(s).
;

(define_expand "extendsidi2"
  [(set (match_operand:DI 0 "register_operand" "")
        (sign_extend:DI (match_operand:SI 1 "nonimmediate_operand" "")))]
  ""
{
  if (!TARGET_64BIT)
    {
      emit_insn (gen_rtx_CLOBBER (VOIDmode, operands[0]));
      emit_move_insn (gen_highpart (SImode, operands[0]), operands[1]);
      emit_move_insn (gen_lowpart (SImode, operands[0]), const0_rtx);
      emit_insn (gen_ashrdi3 (operands[0], operands[0], GEN_INT (32)));
      DONE;
    }
})

(define_insn "*extendsidi2"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (sign_extend:DI (match_operand:SI 1 "nonimmediate_operand" "d,m")))]
  "TARGET_64BIT"
  "@
   lgfr\t%0,%1
   lgf\t%0,%1"
  [(set_attr "op_type" "RRE,RXY")])

;
; extend(hi|qi)(si|di)2 instruction pattern(s).
;

(define_expand "extend<HQI:mode><DSI:mode>2"
  [(set (match_operand:DSI 0 "register_operand" "")
        (sign_extend:DSI (match_operand:HQI 1 "nonimmediate_operand" "")))]
  ""
{
  if (<DSI:MODE>mode == DImode && !TARGET_64BIT)
    {
      rtx tmp = gen_reg_rtx (SImode);
      emit_insn (gen_extend<HQI:mode>si2 (tmp, operands[1]));
      emit_insn (gen_extendsidi2 (operands[0], tmp));
      DONE;
    }
  else if (!TARGET_EXTIMM)
    {
      rtx bitcount = GEN_INT (GET_MODE_BITSIZE (<DSI:MODE>mode) -
                              GET_MODE_BITSIZE (<HQI:MODE>mode));

      operands[1] = gen_lowpart (<DSI:MODE>mode, operands[1]);
      emit_insn (gen_ashl<DSI:mode>3 (operands[0], operands[1], bitcount));
      emit_insn (gen_ashr<DSI:mode>3 (operands[0], operands[0], bitcount));
      DONE;
    }
})

;
; extendhidi2 instruction pattern(s).
;

(define_insn "*extendhidi2_extimm"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (sign_extend:DI (match_operand:HI 1 "nonimmediate_operand" "d,m")))]
  "TARGET_64BIT && TARGET_EXTIMM"
  "@
   lghr\t%0,%1
   lgh\t%0,%1"
  [(set_attr "op_type" "RRE,RXY")])

(define_insn "*extendhidi2"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (sign_extend:DI (match_operand:HI 1 "memory_operand" "m")))]
  "TARGET_64BIT"
  "lgh\t%0,%1"
  [(set_attr "op_type" "RXY")])

;
; extendhisi2 instruction pattern(s).
;

(define_insn "*extendhisi2_extimm"
  [(set (match_operand:SI 0 "register_operand" "=d,d,d")
        (sign_extend:SI (match_operand:HI 1 "nonimmediate_operand" "d,R,T")))]
  "TARGET_EXTIMM"
  "@
   lhr\t%0,%1
   lh\t%0,%1
   lhy\t%0,%1"
  [(set_attr "op_type" "RRE,RX,RXY")])

(define_insn "*extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (sign_extend:SI (match_operand:HI 1 "memory_operand" "R,T")))]
  "!TARGET_EXTIMM"
  "@
   lh\t%0,%1
   lhy\t%0,%1"
  [(set_attr "op_type" "RX,RXY")])

;
; extendqi(si|di)2 instruction pattern(s).
;

; lbr, lgbr, lb, lgb
(define_insn "*extendqi<mode>2_extimm"
  [(set (match_operand:GPR 0 "register_operand" "=d,d")
        (sign_extend:GPR (match_operand:QI 1 "nonimmediate_operand" "d,m")))]
  "TARGET_EXTIMM"
  "@
   l<g>br\t%0,%1
   l<g>b\t%0,%1"
  [(set_attr "op_type" "RRE,RXY")])

; lb, lgb
(define_insn "*extendqi<mode>2"
  [(set (match_operand:GPR 0 "register_operand" "=d")
        (sign_extend:GPR (match_operand:QI 1 "memory_operand" "m")))]
  "!TARGET_EXTIMM && TARGET_LONG_DISPLACEMENT"
  "l<g>b\t%0,%1"
  [(set_attr "op_type" "RXY")])

(define_insn_and_split "*extendqi<mode>2_short_displ"
  [(set (match_operand:GPR 0 "register_operand" "=d")
        (sign_extend:GPR (match_operand:QI 1 "s_operand" "Q")))
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_EXTIMM && !TARGET_LONG_DISPLACEMENT"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (match_dup 0) (unspec:GPR [(match_dup 1) (const_int 8)] UNSPEC_ICM))
     (clobber (reg:CC CC_REGNUM))])
   (parallel
    [(set (match_dup 0) (ashiftrt:GPR (match_dup 0) (match_dup 2)))
     (clobber (reg:CC CC_REGNUM))])]
{
  operands[1] = adjust_address (operands[1], BLKmode, 0);
  set_mem_size (operands[1], GEN_INT (GET_MODE_SIZE (QImode)));
  operands[2] = GEN_INT (GET_MODE_BITSIZE (<MODE>mode)
                         - GET_MODE_BITSIZE (QImode));
})

;
; zero_extendsidi2 instruction pattern(s).
;

(define_expand "zero_extendsidi2"
  [(set (match_operand:DI 0 "register_operand" "")
        (zero_extend:DI (match_operand:SI 1 "nonimmediate_operand" "")))]
  ""
{
  if (!TARGET_64BIT)
    {
      emit_insn (gen_rtx_CLOBBER (VOIDmode, operands[0]));
      emit_move_insn (gen_lowpart (SImode, operands[0]), operands[1]);
      emit_move_insn (gen_highpart (SImode, operands[0]), const0_rtx);
      DONE;
    }
})

(define_insn "*zero_extendsidi2"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (zero_extend:DI (match_operand:SI 1 "nonimmediate_operand" "d,m")))]
  "TARGET_64BIT"
  "@
   llgfr\t%0,%1
   llgf\t%0,%1"
  [(set_attr "op_type" "RRE,RXY")])

;
; LLGT-type instructions (zero-extend from 31 bit to 64 bit).
;

(define_insn "*llgt_sidi"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (and:DI (subreg:DI (match_operand:SI 1 "memory_operand" "m") 0)
                (const_int 2147483647)))]
  "TARGET_64BIT"
  "llgt\t%0,%1"
  [(set_attr "op_type"  "RXE")])

(define_insn_and_split "*llgt_sidi_split"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (and:DI (subreg:DI (match_operand:SI 1 "memory_operand" "m") 0)
                (const_int 2147483647)))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT"
  "#"
  "&& reload_completed"
  [(set (match_dup 0)
        (and:DI (subreg:DI (match_dup 1) 0)
                (const_int 2147483647)))]
  "")

(define_insn "*llgt_sisi"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (and:SI (match_operand:SI 1 "nonimmediate_operand" "d,m")
                (const_int 2147483647)))]
  "TARGET_ZARCH"
  "@
   llgtr\t%0,%1
   llgt\t%0,%1"
  [(set_attr "op_type"  "RRE,RXE")])

(define_insn "*llgt_didi"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (and:DI (match_operand:DI 1 "nonimmediate_operand" "d,o")
                (const_int 2147483647)))]
  "TARGET_64BIT"
  "@
   llgtr\t%0,%1
   llgt\t%0,%N1"
  [(set_attr "op_type"  "RRE,RXE")])

(define_split
  [(set (match_operand:GPR 0 "register_operand" "")
        (and:GPR (match_operand:GPR 1 "nonimmediate_operand" "")
                 (const_int 2147483647)))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_ZARCH && reload_completed"
  [(set (match_dup 0)
        (and:GPR (match_dup 1)
                 (const_int 2147483647)))]
  "")

;
; zero_extend(hi|qi)(si|di)2 instruction pattern(s).
;

(define_expand "zero_extend<mode>di2"
  [(set (match_operand:DI 0 "register_operand" "")
        (zero_extend:DI (match_operand:HQI 1 "nonimmediate_operand" "")))]
  ""
{
  if (!TARGET_64BIT)
    {
      rtx tmp = gen_reg_rtx (SImode);
      emit_insn (gen_zero_extend<mode>si2 (tmp, operands[1]));
      emit_insn (gen_zero_extendsidi2 (operands[0], tmp));
      DONE;
    }
  else if (!TARGET_EXTIMM)
    {
      rtx bitcount = GEN_INT (GET_MODE_BITSIZE(DImode) - 
                              GET_MODE_BITSIZE(<MODE>mode));
      operands[1] = gen_lowpart (DImode, operands[1]);
      emit_insn (gen_ashldi3 (operands[0], operands[1], bitcount));
      emit_insn (gen_lshrdi3 (operands[0], operands[0], bitcount));
      DONE;
    }
})

(define_expand "zero_extend<mode>si2"
  [(set (match_operand:SI 0 "register_operand" "")
        (zero_extend:SI (match_operand:HQI 1 "nonimmediate_operand" "")))]
  ""
{
  if (!TARGET_EXTIMM)
    {
      operands[1] = gen_lowpart (SImode, operands[1]);
      emit_insn (gen_andsi3 (operands[0], operands[1], 
                   GEN_INT ((1 << GET_MODE_BITSIZE(<MODE>mode)) - 1)));
      DONE;
    }
})

; llhr, llcr, llghr, llgcr, llh, llc, llgh, llgc
(define_insn "*zero_extend<HQI:mode><GPR:mode>2_extimm"
  [(set (match_operand:GPR 0 "register_operand" "=d,d")
        (zero_extend:GPR (match_operand:HQI 1 "nonimmediate_operand" "d,m")))]
  "TARGET_EXTIMM"
  "@
   ll<g><hc>r\t%0,%1
   ll<g><hc>\t%0,%1"
  [(set_attr "op_type" "RRE,RXY")])

; llgh, llgc
(define_insn "*zero_extend<HQI:mode><GPR:mode>2"
  [(set (match_operand:GPR 0 "register_operand" "=d")
        (zero_extend:GPR (match_operand:HQI 1 "memory_operand" "m")))]
  "TARGET_ZARCH && !TARGET_EXTIMM"
  "llg<hc>\t%0,%1"
  [(set_attr "op_type" "RXY")])

(define_insn_and_split "*zero_extendhisi2_31"
  [(set (match_operand:SI 0 "register_operand" "=&d")
        (zero_extend:SI (match_operand:HI 1 "s_operand" "QS")))
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_ZARCH"
  "#"
  "&& reload_completed"
  [(set (match_dup 0) (const_int 0))
   (parallel
    [(set (strict_low_part (match_dup 2)) (match_dup 1))
     (clobber (reg:CC CC_REGNUM))])]
  "operands[2] = gen_lowpart (HImode, operands[0]);")

(define_insn_and_split "*zero_extendqisi2_31"
  [(set (match_operand:SI 0 "register_operand" "=&d")
        (zero_extend:SI (match_operand:QI 1 "memory_operand" "m")))]
  "!TARGET_ZARCH"
  "#"
  "&& reload_completed"
  [(set (match_dup 0) (const_int 0))
   (set (strict_low_part (match_dup 2)) (match_dup 1))]
  "operands[2] = gen_lowpart (QImode, operands[0]);")

;
; zero_extendqihi2 instruction pattern(s).
;

(define_expand "zero_extendqihi2"
  [(set (match_operand:HI 0 "register_operand" "")
        (zero_extend:HI (match_operand:QI 1 "register_operand" "")))]
  "TARGET_ZARCH && !TARGET_EXTIMM"
{
  operands[1] = gen_lowpart (HImode, operands[1]);
  emit_insn (gen_andhi3 (operands[0], operands[1], GEN_INT (0xff)));
  DONE;
})

(define_insn "*zero_extendqihi2_64"
  [(set (match_operand:HI 0 "register_operand" "=d")
        (zero_extend:HI (match_operand:QI 1 "memory_operand" "m")))]
  "TARGET_ZARCH && !TARGET_EXTIMM"
  "llgc\t%0,%1"
  [(set_attr "op_type" "RXY")])

(define_insn_and_split "*zero_extendqihi2_31"
  [(set (match_operand:HI 0 "register_operand" "=&d")
        (zero_extend:HI (match_operand:QI 1 "memory_operand" "m")))]
  "!TARGET_ZARCH"
  "#"
  "&& reload_completed"
  [(set (match_dup 0) (const_int 0))
   (set (strict_low_part (match_dup 2)) (match_dup 1))]
  "operands[2] = gen_lowpart (QImode, operands[0]);")


;
; fixuns_trunc(sf|df)(si|di)2 and fix_trunc(sf|df)(si|di)2 instruction pattern(s).
;

(define_expand "fixuns_trunc<FPR:mode><GPR:mode>2"
  [(set (match_operand:GPR 0 "register_operand" "")
        (unsigned_fix:GPR (match_operand:FPR 1 "register_operand" "")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
{
  rtx label1 = gen_label_rtx ();
  rtx label2 = gen_label_rtx ();
  rtx temp = gen_reg_rtx (<FPR:MODE>mode);
  REAL_VALUE_TYPE cmp, sub;
  
  operands[1] = force_reg (<FPR:MODE>mode, operands[1]);
  real_2expN (&cmp, GET_MODE_BITSIZE(<GPR:MODE>mode) - 1);
  real_2expN (&sub, GET_MODE_BITSIZE(<GPR:MODE>mode));
  
  emit_insn (gen_cmp<FPR:mode> (operands[1],
        CONST_DOUBLE_FROM_REAL_VALUE (cmp, <FPR:MODE>mode)));
  emit_jump_insn (gen_blt (label1));
  emit_insn (gen_sub<FPR:mode>3 (temp, operands[1],
        CONST_DOUBLE_FROM_REAL_VALUE (sub, <FPR:MODE>mode)));
  emit_insn (gen_fix_trunc<FPR:mode><GPR:mode>2_ieee (operands[0], temp,
        GEN_INT(7)));
  emit_jump (label2);

  emit_label (label1);
  emit_insn (gen_fix_trunc<FPR:mode><GPR:mode>2_ieee (operands[0],
        operands[1], GEN_INT(5)));
  emit_label (label2);
  DONE;
})

(define_expand "fix_trunc<mode>di2"
  [(set (match_operand:DI 0 "register_operand" "")
        (fix:DI (match_operand:DSF 1 "nonimmediate_operand" "")))]
  "TARGET_64BIT && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
{
  operands[1] = force_reg (<MODE>mode, operands[1]);
  emit_insn (gen_fix_trunc<mode>di2_ieee (operands[0], operands[1],
      GEN_INT(5)));
  DONE;
})

; cgxbr, cgdbr, cgebr, cfxbr, cfdbr, cfebr
(define_insn "fix_trunc<FPR:mode><GPR:mode>2_ieee"
  [(set (match_operand:GPR 0 "register_operand" "=d")
        (fix:GPR (match_operand:FPR 1 "register_operand" "f")))
   (unspec:GPR [(match_operand:GPR 2 "immediate_operand" "K")] UNSPEC_ROUND)
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "c<GPR:gf><FPR:xde>br\t%0,%h2,%1"
  [(set_attr "op_type" "RRE")
   (set_attr "type"    "ftoi")])

;
; fix_trunctf(si|di)2 instruction pattern(s).
;

(define_expand "fix_trunctf<mode>2"
  [(parallel [(set (match_operand:GPR 0 "register_operand" "")
                   (fix:GPR (match_operand:TF 1 "register_operand" "")))
              (unspec:GPR [(const_int 5)] UNSPEC_ROUND)
              (clobber (reg:CC CC_REGNUM))])]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "")

;
; fix_truncdfsi2 instruction pattern(s).
;

(define_expand "fix_truncdfsi2"
  [(set (match_operand:SI 0 "register_operand" "")
        (fix:SI (match_operand:DF 1 "nonimmediate_operand" "")))]
  "TARGET_HARD_FLOAT"
{
  if (TARGET_IBM_FLOAT)
    {
      /* This is the algorithm from POP chapter A.5.7.2.  */

      rtx temp   = assign_stack_local (BLKmode, 8, BITS_PER_WORD);
      rtx two31r = s390_gen_rtx_const_DI (0x4f000000, 0x08000000);
      rtx two32  = s390_gen_rtx_const_DI (0x4e000001, 0x00000000);

      operands[1] = force_reg (DFmode, operands[1]);
      emit_insn (gen_fix_truncdfsi2_ibm (operands[0], operands[1],
                                         two31r, two32, temp));
    }
  else
    {
      operands[1] = force_reg (DFmode, operands[1]);
      emit_insn (gen_fix_truncdfsi2_ieee (operands[0], operands[1], GEN_INT (5)));
    }

  DONE;
})

(define_insn "fix_truncdfsi2_ibm"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (fix:SI (match_operand:DF 1 "nonimmediate_operand" "+f")))
   (use (match_operand:DI 2 "immediate_operand" "m"))
   (use (match_operand:DI 3 "immediate_operand" "m"))
   (use (match_operand:BLK 4 "memory_operand" "m"))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
{
   output_asm_insn ("sd\t%1,%2", operands);
   output_asm_insn ("aw\t%1,%3", operands);
   output_asm_insn ("std\t%1,%4", operands);
   output_asm_insn ("xi\t%N4,128", operands);
   return "l\t%0,%N4";
}
  [(set_attr "length" "20")])

;
; fix_truncsfsi2 instruction pattern(s).
;

(define_expand "fix_truncsfsi2"
  [(set (match_operand:SI 0 "register_operand" "")
        (fix:SI (match_operand:SF 1 "nonimmediate_operand" "")))]
  "TARGET_HARD_FLOAT"
{
  if (TARGET_IBM_FLOAT)
    {
      /* Convert to DFmode and then use the POP algorithm.  */
      rtx temp = gen_reg_rtx (DFmode);
      emit_insn (gen_extendsfdf2 (temp, operands[1]));
      emit_insn (gen_fix_truncdfsi2 (operands[0], temp));
    }
  else
    {
      operands[1] = force_reg (SFmode, operands[1]);
      emit_insn (gen_fix_truncsfsi2_ieee (operands[0], operands[1], GEN_INT (5)));
    }

  DONE;
})

;
; float(si|di)(tf|df|sf)2 instruction pattern(s).
;

; cxgbr, cdgbr, cegbr
(define_insn "floatdi<mode>2"
  [(set (match_operand:FPR 0 "register_operand" "=f")
        (float:FPR (match_operand:DI 1 "register_operand" "d")))]
  "TARGET_64BIT && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "c<xde>gbr\t%0,%1"
  [(set_attr "op_type" "RRE")
   (set_attr "type"    "itof" )])

; cxfbr, cdfbr, cefbr
(define_insn "floatsi<mode>2_ieee"
  [(set (match_operand:FPR 0 "register_operand" "=f")
        (float:FPR (match_operand:SI 1 "register_operand" "d")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "c<xde>fbr\t%0,%1"
  [(set_attr "op_type" "RRE")
   (set_attr "type"   "itof" )])


;
; floatsi(tf|df)2 instruction pattern(s).
;

(define_expand "floatsitf2"
  [(set (match_operand:TF 0 "register_operand" "")
        (float:TF (match_operand:SI 1 "register_operand" "")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "")

(define_expand "floatsidf2"
  [(set (match_operand:DF 0 "register_operand" "")
        (float:DF (match_operand:SI 1 "register_operand" "")))]
  "TARGET_HARD_FLOAT"
{
  if (TARGET_IBM_FLOAT)
    {
      /* This is the algorithm from POP chapter A.5.7.1.  */

      rtx temp  = assign_stack_local (BLKmode, 8, BITS_PER_WORD);
      rtx two31 = s390_gen_rtx_const_DI (0x4e000000, 0x80000000);

      emit_insn (gen_floatsidf2_ibm (operands[0], operands[1], two31, temp));
      DONE;
    }
})

(define_insn "floatsidf2_ibm"
  [(set (match_operand:DF 0 "register_operand" "=f")
        (float:DF (match_operand:SI 1 "register_operand" "d")))
   (use (match_operand:DI 2 "immediate_operand" "m"))
   (use (match_operand:BLK 3 "memory_operand" "m"))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
{
   output_asm_insn ("st\t%1,%N3", operands);
   output_asm_insn ("xi\t%N3,128", operands);
   output_asm_insn ("mvc\t%O3(4,%R3),%2", operands);
   output_asm_insn ("ld\t%0,%3", operands);
   return "sd\t%0,%2";
}
  [(set_attr "length" "20")])

;
; floatsisf2 instruction pattern(s).
;

(define_expand "floatsisf2"
  [(set (match_operand:SF 0 "register_operand" "")
        (float:SF (match_operand:SI 1 "register_operand" "")))]
  "TARGET_HARD_FLOAT"
{
  if (TARGET_IBM_FLOAT)
    {
      /* Use the POP algorithm to convert to DFmode and then truncate.  */
      rtx temp = gen_reg_rtx (DFmode);
      emit_insn (gen_floatsidf2 (temp, operands[1]));
      emit_insn (gen_truncdfsf2 (operands[0], temp));
      DONE;
    }
})

;
; truncdfsf2 instruction pattern(s).
;

(define_expand "truncdfsf2"
  [(set (match_operand:SF 0 "register_operand" "")
        (float_truncate:SF (match_operand:DF 1 "register_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "truncdfsf2_ieee"
  [(set (match_operand:SF 0 "register_operand" "=f")
        (float_truncate:SF (match_operand:DF 1 "register_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "ledbr\t%0,%1"
  [(set_attr "op_type"  "RRE")
   (set_attr "type"   "ftruncdf")])

(define_insn "truncdfsf2_ibm"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
        (float_truncate:SF (match_operand:DF 1 "nonimmediate_operand" "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   ler\t%0,%1
   le\t%0,%1"
  [(set_attr "op_type"  "RR,RX")
   (set_attr "type"   "floadsf")])

;
; trunctfdf2 instruction pattern(s).
;

(define_expand "trunctfdf2"
  [(parallel 
    [(set (match_operand:DF 0 "register_operand" "")
          (float_truncate:DF (match_operand:TF 1 "register_operand" "")))
     (clobber (match_scratch:TF 2 "=f"))])]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*trunctfdf2_ieee"
  [(set (match_operand:DF 0 "register_operand" "=f")
        (float_truncate:DF (match_operand:TF 1 "register_operand" "f")))
   (clobber (match_scratch:TF 2 "=f"))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "ldxbr\t%2,%1\;ldr\t%0,%2"
  [(set_attr "length" "6")
   (set_attr "type"   "ftrunctf")])   

(define_insn "*trunctfdf2_ibm"
  [(set (match_operand:DF 0 "register_operand" "=f")
        (float_truncate:DF (match_operand:TF 1 "register_operand" "f")))
   (clobber (match_scratch:TF 2 "=f"))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "ldxr\t%2,%1\;ldr\t%0,%2"
  [(set_attr "length"  "4")
   (set_attr "type"   "ftrunctf")])

;
; trunctfsf2 instruction pattern(s).
;

(define_expand "trunctfsf2"
  [(parallel 
    [(set (match_operand:SF 0 "register_operand" "=f")
          (float_truncate:SF (match_operand:TF 1 "register_operand" "f")))
     (clobber (match_scratch:TF 2 "=f"))])]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*trunctfsf2_ieee"
  [(set (match_operand:SF 0 "register_operand" "=f")
        (float_truncate:SF (match_operand:TF 1 "register_operand" "f")))
   (clobber (match_scratch:TF 2 "=f"))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "lexbr\t%2,%1\;ler\t%0,%2"
  [(set_attr "length"  "6")
   (set_attr "type"   "ftrunctf")])

(define_insn "*trunctfsf2_ibm"
  [(set (match_operand:SF 0 "register_operand" "=f")
        (float_truncate:SF (match_operand:TF 1 "register_operand" "f")))
   (clobber (match_scratch:TF 2 "=f"))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "lexr\t%2,%1\;ler\t%0,%2"
  [(set_attr "length"  "6")
   (set_attr "type"   "ftrunctf")])

;
; extendsfdf2 instruction pattern(s).
;

(define_expand "extendsfdf2"
  [(set (match_operand:DF 0 "register_operand" "")
        (float_extend:DF (match_operand:SF 1 "nonimmediate_operand" "")))]
  "TARGET_HARD_FLOAT"
{
  if (TARGET_IBM_FLOAT)
    {
      emit_insn (gen_extendsfdf2_ibm (operands[0], operands[1]));
      DONE;
    }
})

(define_insn "extendsfdf2_ieee"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
        (float_extend:DF (match_operand:SF 1 "nonimmediate_operand"  "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   ldebr\t%0,%1
   ldeb\t%0,%1"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"   "fsimpsf, floadsf")])

(define_insn "extendsfdf2_ibm"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
        (float_extend:DF (match_operand:SF 1 "nonimmediate_operand" "f,R")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   sdr\t%0,%0\;ler\t%0,%1
   sdr\t%0,%0\;le\t%0,%1"
  [(set_attr "length"   "4,6")
   (set_attr "type"     "floadsf")])

;
; extenddftf2 instruction pattern(s).
;

(define_expand "extenddftf2"
  [(set (match_operand:TF 0 "register_operand" "")
        (float_extend:TF (match_operand:DF 1 "nonimmediate_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*extenddftf2_ieee"
  [(set (match_operand:TF 0 "register_operand" "=f,f")
        (float_extend:TF (match_operand:DF 1 "nonimmediate_operand" "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   lxdbr\t%0,%1
   lxdb\t%0,%1"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"   "fsimptf, floadtf")])

(define_insn "*extenddftf2_ibm"
  [(set (match_operand:TF 0 "register_operand" "=f,f")
        (float_extend:TF (match_operand:DF 1 "nonimmediate_operand" "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   lxdr\t%0,%1
   lxd\t%0,%1"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"   "fsimptf, floadtf")])

;
; extendsftf2 instruction pattern(s).
;

(define_expand "extendsftf2"
  [(set (match_operand:TF 0 "register_operand" "")
        (float_extend:TF (match_operand:SF 1 "nonimmediate_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*extendsftf2_ieee"
  [(set (match_operand:TF 0 "register_operand" "=f,f")
        (float_extend:TF (match_operand:SF 1 "nonimmediate_operand" "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   lxebr\t%0,%1
   lxeb\t%0,%1"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"   "fsimptf, floadtf")])

(define_insn "*extendsftf2_ibm"
  [(set (match_operand:TF 0 "register_operand" "=f,f")
        (float_extend:TF (match_operand:SF 1 "nonimmediate_operand" "f,R")))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   lxer\t%0,%1
   lxe\t%0,%1"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"   "fsimptf, floadtf")])


;;
;; ARITHMETIC OPERATIONS
;;
;  arithmetic operations set the ConditionCode,
;  because of unpredictable Bits in Register for Halfword and Byte
;  the ConditionCode can be set wrong in operations for Halfword and Byte

;;
;;- Add instructions.
;;

;
; addti3 instruction pattern(s).
;

(define_insn_and_split "addti3"
  [(set (match_operand:TI 0 "register_operand" "=&d")
        (plus:TI (match_operand:TI 1 "nonimmediate_operand" "%0")
                 (match_operand:TI 2 "general_operand" "do") ) )
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (reg:CCL1 CC_REGNUM)
          (compare:CCL1 (plus:DI (match_dup 7) (match_dup 8))
                        (match_dup 7)))
     (set (match_dup 6) (plus:DI (match_dup 7) (match_dup 8)))])
   (parallel
    [(set (match_dup 3) (plus:DI (plus:DI (match_dup 4) (match_dup 5))
                                 (ltu:DI (reg:CCL1 CC_REGNUM) (const_int 0))))
     (clobber (reg:CC CC_REGNUM))])]
  "operands[3] = operand_subword (operands[0], 0, 0, TImode);
   operands[4] = operand_subword (operands[1], 0, 0, TImode);
   operands[5] = operand_subword (operands[2], 0, 0, TImode);
   operands[6] = operand_subword (operands[0], 1, 0, TImode);
   operands[7] = operand_subword (operands[1], 1, 0, TImode);
   operands[8] = operand_subword (operands[2], 1, 0, TImode);")

;
; adddi3 instruction pattern(s).
;

(define_expand "adddi3"
  [(parallel
    [(set (match_operand:DI 0 "register_operand" "")
          (plus:DI (match_operand:DI 1 "nonimmediate_operand" "")
                   (match_operand:DI 2 "general_operand" "")))
     (clobber (reg:CC CC_REGNUM))])]
  ""
  "")

(define_insn "*adddi3_sign"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (plus:DI (sign_extend:DI (match_operand:SI 2 "general_operand" "d,m"))
                 (match_operand:DI 1 "register_operand" "0,0")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT"
  "@
   agfr\t%0,%2
   agf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*adddi3_zero_cc"
  [(set (reg CC_REGNUM)
        (compare (plus:DI (zero_extend:DI (match_operand:SI 2 "general_operand" "d,m"))
                          (match_operand:DI 1 "register_operand" "0,0"))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d,d")
        (plus:DI (zero_extend:DI (match_dup 2)) (match_dup 1)))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_64BIT"
  "@
   algfr\t%0,%2
   algf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*adddi3_zero_cconly"
  [(set (reg CC_REGNUM)
        (compare (plus:DI (zero_extend:DI (match_operand:SI 2 "general_operand" "d,m"))
                          (match_operand:DI 1 "register_operand" "0,0"))
                 (const_int 0)))
   (clobber (match_scratch:DI 0 "=d,d"))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_64BIT"
  "@
   algfr\t%0,%2
   algf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*adddi3_zero"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (plus:DI (zero_extend:DI (match_operand:SI 2 "general_operand" "d,m"))
                 (match_operand:DI 1 "register_operand" "0,0")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT"
  "@
   algfr\t%0,%2
   algf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn_and_split "*adddi3_31z"
  [(set (match_operand:DI 0 "register_operand" "=&d")
        (plus:DI (match_operand:DI 1 "nonimmediate_operand" "%0")
                 (match_operand:DI 2 "general_operand" "do") ) )
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_64BIT && TARGET_CPU_ZARCH"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (reg:CCL1 CC_REGNUM)
          (compare:CCL1 (plus:SI (match_dup 7) (match_dup 8))
                        (match_dup 7)))
     (set (match_dup 6) (plus:SI (match_dup 7) (match_dup 8)))])
   (parallel
    [(set (match_dup 3) (plus:SI (plus:SI (match_dup 4) (match_dup 5))
                                 (ltu:SI (reg:CCL1 CC_REGNUM) (const_int 0))))
     (clobber (reg:CC CC_REGNUM))])]
  "operands[3] = operand_subword (operands[0], 0, 0, DImode);
   operands[4] = operand_subword (operands[1], 0, 0, DImode);
   operands[5] = operand_subword (operands[2], 0, 0, DImode);
   operands[6] = operand_subword (operands[0], 1, 0, DImode);
   operands[7] = operand_subword (operands[1], 1, 0, DImode);
   operands[8] = operand_subword (operands[2], 1, 0, DImode);")

(define_insn_and_split "*adddi3_31"
  [(set (match_operand:DI 0 "register_operand" "=&d")
        (plus:DI (match_operand:DI 1 "nonimmediate_operand" "%0")
                 (match_operand:DI 2 "general_operand" "do") ) )
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_CPU_ZARCH"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (match_dup 3) (plus:SI (match_dup 4) (match_dup 5)))
     (clobber (reg:CC CC_REGNUM))])
   (parallel
    [(set (reg:CCL1 CC_REGNUM)
          (compare:CCL1 (plus:SI (match_dup 7) (match_dup 8))
                        (match_dup 7)))
     (set (match_dup 6) (plus:SI (match_dup 7) (match_dup 8)))])
   (set (pc)
        (if_then_else (ltu (reg:CCL1 CC_REGNUM) (const_int 0))
                      (pc)
                      (label_ref (match_dup 9))))
   (parallel
    [(set (match_dup 3) (plus:SI (match_dup 3) (const_int 1)))
     (clobber (reg:CC CC_REGNUM))])
   (match_dup 9)]
  "operands[3] = operand_subword (operands[0], 0, 0, DImode);
   operands[4] = operand_subword (operands[1], 0, 0, DImode);
   operands[5] = operand_subword (operands[2], 0, 0, DImode);
   operands[6] = operand_subword (operands[0], 1, 0, DImode);
   operands[7] = operand_subword (operands[1], 1, 0, DImode);
   operands[8] = operand_subword (operands[2], 1, 0, DImode);
   operands[9] = gen_label_rtx ();")

;
; addsi3 instruction pattern(s).
;

(define_expand "addsi3"
  [(parallel
    [(set (match_operand:SI 0 "register_operand" "")
          (plus:SI (match_operand:SI 1 "nonimmediate_operand" "")
                   (match_operand:SI 2 "general_operand" "")))
     (clobber (reg:CC CC_REGNUM))])]
  ""
  "")

(define_insn "*addsi3_sign"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (plus:SI (sign_extend:SI (match_operand:HI 2 "memory_operand" "R,T"))
                 (match_operand:SI 1 "register_operand" "0,0")))
   (clobber (reg:CC CC_REGNUM))]
  ""
  "@
   ah\t%0,%2
   ahy\t%0,%2"
  [(set_attr "op_type"  "RX,RXY")])

;
; add(di|si)3 instruction pattern(s).
;

; ar, ahi, alfi, slfi, a, ay, agr, aghi, algfi, slgfi, ag
(define_insn "*add<mode>3"
  [(set (match_operand:GPR 0 "register_operand" "=d,d,d,d,d,d")
        (plus:GPR (match_operand:GPR 1 "nonimmediate_operand" "%0,0,0,0,0,0")
                  (match_operand:GPR 2 "general_operand" "d,K,Op,On,R,T") ) )
   (clobber (reg:CC CC_REGNUM))]
  ""
  "@
   a<g>r\t%0,%2
   a<g>hi\t%0,%h2
   al<g>fi\t%0,%2
   sl<g>fi\t%0,%n2
   a<g>\t%0,%2
   a<y>\t%0,%2"
  [(set_attr "op_type"  "RR<E>,RI,RIL,RIL,RX<Y>,RXY")])

; alr, alfi, slfi, al, aly, algr, algfi, slgfi, alg
(define_insn "*add<mode>3_carry1_cc"
  [(set (reg CC_REGNUM)
        (compare (plus:GPR (match_operand:GPR 1 "nonimmediate_operand" "%0,0,0,0,0")
                           (match_operand:GPR 2 "general_operand" "d,Op,On,R,T"))
                 (match_dup 1)))
   (set (match_operand:GPR 0 "register_operand" "=d,d,d,d,d")
        (plus:GPR (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCL1mode)"
  "@
   al<g>r\t%0,%2
   al<g>fi\t%0,%2
   sl<g>fi\t%0,%n2
   al<g>\t%0,%2
   al<y>\t%0,%2"
  [(set_attr "op_type"  "RR<E>,RIL,RIL,RX<Y>,RXY")])

; alr, al, aly, algr, alg
(define_insn "*add<mode>3_carry1_cconly"
  [(set (reg CC_REGNUM)
        (compare (plus:GPR (match_operand:GPR 1 "nonimmediate_operand" "%0,0,0")
                           (match_operand:GPR 2 "general_operand" "d,R,T"))
                 (match_dup 1)))
   (clobber (match_scratch:GPR 0 "=d,d,d"))]
  "s390_match_ccmode (insn, CCL1mode)"
  "@
   al<g>r\t%0,%2
   al<g>\t%0,%2
   al<y>\t%0,%2"
  [(set_attr "op_type"  "RR<E>,RX<Y>,RXY")])

; alr, alfi, slfi, al, aly, algr, algfi, slgfi, alg
(define_insn "*add<mode>3_carry2_cc"
  [(set (reg CC_REGNUM)
        (compare (plus:GPR (match_operand:GPR 1 "nonimmediate_operand" "%0,0,0,0,0")
                           (match_operand:GPR 2 "general_operand" "d,Op,On,R,T"))
                 (match_dup 2)))
   (set (match_operand:GPR 0 "register_operand" "=d,d,d,d,d")
        (plus:GPR (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCL1mode)"
  "@
   al<g>r\t%0,%2
   al<g>fi\t%0,%2
   sl<g>fi\t%0,%n2
   al<g>\t%0,%2
   al<y>\t%0,%2"
  [(set_attr "op_type"  "RR<E>,RIL,RIL,RX<Y>,RXY")])

; alr, al, aly, algr, alg
(define_insn "*add<mode>3_carry2_cconly"
  [(set (reg CC_REGNUM)
        (compare (plus:GPR (match_operand:GPR 1 "nonimmediate_operand" "%0,0,0")
                           (match_operand:GPR 2 "general_operand" "d,R,T"))
                 (match_dup 2)))
   (clobber (match_scratch:GPR 0 "=d,d,d"))]
  "s390_match_ccmode (insn, CCL1mode)"
  "@
   al<g>r\t%0,%2
   al<g>\t%0,%2
   al<y>\t%0,%2"
  [(set_attr "op_type"  "RR<E>,RX<Y>,RXY")])

; alr, alfi, slfi, al, aly, algr, algfi, slgfi, alg
(define_insn "*add<mode>3_cc"
  [(set (reg CC_REGNUM)
        (compare (plus:GPR (match_operand:GPR 1 "nonimmediate_operand" "%0,0,0,0,0")
                           (match_operand:GPR 2 "general_operand" "d,Op,On,R,T"))
                 (const_int 0)))
   (set (match_operand:GPR 0 "register_operand" "=d,d,d,d,d")
        (plus:GPR (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCLmode)"
  "@
   al<g>r\t%0,%2
   al<g>fi\t%0,%2
   sl<g>fi\t%0,%n2
   al<g>\t%0,%2
   al<y>\t%0,%2"
  [(set_attr "op_type"  "RR<E>,RIL,RIL,RX<Y>,RXY")])

; alr, al, aly, algr, alg
(define_insn "*add<mode>3_cconly"
  [(set (reg CC_REGNUM)
        (compare (plus:GPR (match_operand:GPR 1 "nonimmediate_operand" "%0,0,0")
                           (match_operand:GPR 2 "general_operand" "d,R,T"))
                 (const_int 0)))
   (clobber (match_scratch:GPR 0 "=d,d,d"))]
  "s390_match_ccmode (insn, CCLmode)"
  "@
   al<g>r\t%0,%2
   al<g>\t%0,%2
   al<y>\t%0,%2"
  [(set_attr "op_type"  "RR<E>,RX<Y>,RXY")])

; alr, al, aly, algr, alg
(define_insn "*add<mode>3_cconly2"
  [(set (reg CC_REGNUM)
        (compare (match_operand:GPR 1 "nonimmediate_operand" "%0,0,0")
                 (neg:GPR (match_operand:GPR 2 "general_operand" "d,R,T"))))
   (clobber (match_scratch:GPR 0 "=d,d,d"))]
  "s390_match_ccmode(insn, CCLmode)"
  "@
   al<g>r\t%0,%2
   al<g>\t%0,%2
   al<y>\t%0,%2"
  [(set_attr "op_type"  "RR<E>,RX<Y>,RXY")])

; ahi, afi, aghi, agfi
(define_insn "*add<mode>3_imm_cc"
  [(set (reg CC_REGNUM)
        (compare (plus:GPR (match_operand:GPR 1 "nonimmediate_operand" "0,0")
                           (match_operand:GPR 2 "const_int_operand" "K,Os"))
                 (const_int 0)))
   (set (match_operand:GPR 0 "register_operand" "=d,d")
        (plus:GPR (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCAmode)
   && (CONST_OK_FOR_CONSTRAINT_P (INTVAL (operands[2]), 'K', \"K\")
       || CONST_OK_FOR_CONSTRAINT_P (INTVAL (operands[2]), 'O', \"Os\"))
   && INTVAL (operands[2]) != -((HOST_WIDE_INT)1 << (GET_MODE_BITSIZE(<MODE>mode) - 1))"
  "@
   a<g>hi\t%0,%h2
   a<g>fi\t%0,%2"
  [(set_attr "op_type"  "RI,RIL")])

;
; add(df|sf)3 instruction pattern(s).
;

(define_expand "add<mode>3"
  [(parallel
    [(set (match_operand:FPR 0 "register_operand" "=f,f")
          (plus:FPR (match_operand:FPR 1 "nonimmediate_operand" "%0,0")
                    (match_operand:FPR 2 "general_operand" "f,<Rf>")))
     (clobber (reg:CC CC_REGNUM))])]
  "TARGET_HARD_FLOAT"
  "")

; axbr, adbr, aebr, axb, adb, aeb
(define_insn "*add<mode>3"
  [(set (match_operand:FPR 0 "register_operand" "=f,f")
        (plus:FPR (match_operand:FPR 1 "nonimmediate_operand" "%0,0")
                  (match_operand:FPR 2 "general_operand" "f,<Rf>")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   a<xde>br\t%0,%2
   a<xde>b\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimp<mode>")])

; axbr, adbr, aebr, axb, adb, aeb
(define_insn "*add<mode>3_cc"
  [(set (reg CC_REGNUM)
        (compare (plus:FPR (match_operand:FPR 1 "nonimmediate_operand" "%0,0")
                           (match_operand:FPR 2 "general_operand" "f,<Rf>"))
                 (match_operand:FPR 3 "const0_operand" "")))
   (set (match_operand:FPR 0 "register_operand" "=f,f")
        (plus:FPR (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   a<xde>br\t%0,%2
   a<xde>b\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimp<mode>")])

; axbr, adbr, aebr, axb, adb, aeb
(define_insn "*add<mode>3_cconly"
  [(set (reg CC_REGNUM)
        (compare (plus:FPR (match_operand:FPR 1 "nonimmediate_operand" "%0,0")
                           (match_operand:FPR 2 "general_operand" "f,<Rf>"))
                 (match_operand:FPR 3 "const0_operand" "")))
   (clobber (match_scratch:FPR 0 "=f,f"))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   a<xde>br\t%0,%2
   a<xde>b\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimp<mode>")])

; axr, adr, aer, ax, ad, ae
(define_insn "*add<mode>3_ibm"
  [(set (match_operand:FPR 0 "register_operand" "=f,f")
        (plus:FPR (match_operand:FPR 1 "nonimmediate_operand" "%0,0")
                  (match_operand:FPR 2 "general_operand" "f,<Rf>")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   a<xde>r\t%0,%2
   a<xde>\t%0,%2"
  [(set_attr "op_type"  "<RRe>,<RXe>")
   (set_attr "type"     "fsimp<mode>")])


;;
;;- Subtract instructions.
;;

;
; subti3 instruction pattern(s).
;

(define_insn_and_split "subti3"
  [(set (match_operand:TI 0 "register_operand" "=&d")
        (minus:TI (match_operand:TI 1 "register_operand" "0")
                  (match_operand:TI 2 "general_operand" "do") ) )
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (reg:CCL2 CC_REGNUM)
          (compare:CCL2 (minus:DI (match_dup 7) (match_dup 8))
                        (match_dup 7)))
     (set (match_dup 6) (minus:DI (match_dup 7) (match_dup 8)))])
   (parallel
    [(set (match_dup 3) (minus:DI (minus:DI (match_dup 4) (match_dup 5))
                                  (gtu:DI (reg:CCL2 CC_REGNUM) (const_int 0))))
     (clobber (reg:CC CC_REGNUM))])]
  "operands[3] = operand_subword (operands[0], 0, 0, TImode);
   operands[4] = operand_subword (operands[1], 0, 0, TImode);
   operands[5] = operand_subword (operands[2], 0, 0, TImode);
   operands[6] = operand_subword (operands[0], 1, 0, TImode);
   operands[7] = operand_subword (operands[1], 1, 0, TImode);
   operands[8] = operand_subword (operands[2], 1, 0, TImode);")

;
; subdi3 instruction pattern(s).
;

(define_expand "subdi3"
  [(parallel
    [(set (match_operand:DI 0 "register_operand" "")
          (minus:DI (match_operand:DI 1 "register_operand" "")
                    (match_operand:DI 2 "general_operand" "")))
     (clobber (reg:CC CC_REGNUM))])]
  ""
  "")

(define_insn "*subdi3_sign"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (minus:DI (match_operand:DI 1 "register_operand" "0,0")
                  (sign_extend:DI (match_operand:SI 2 "general_operand" "d,m"))))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT"
  "@
   sgfr\t%0,%2
   sgf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*subdi3_zero_cc"
  [(set (reg CC_REGNUM)
        (compare (minus:DI (match_operand:DI 1 "register_operand" "0,0")
                           (zero_extend:DI (match_operand:SI 2 "general_operand" "d,m")))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d,d")
        (minus:DI (match_dup 1) (zero_extend:DI (match_dup 2))))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_64BIT"
  "@
   slgfr\t%0,%2
   slgf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*subdi3_zero_cconly"
  [(set (reg CC_REGNUM)
        (compare (minus:DI (match_operand:DI 1 "register_operand" "0,0")
                           (zero_extend:DI (match_operand:SI 2 "general_operand" "d,m")))
                 (const_int 0)))
   (clobber (match_scratch:DI 0 "=d,d"))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_64BIT"
  "@
   slgfr\t%0,%2
   slgf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*subdi3_zero"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (minus:DI (match_operand:DI 1 "register_operand" "0,0")
                  (zero_extend:DI (match_operand:SI 2 "general_operand" "d,m"))))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT"
  "@
   slgfr\t%0,%2
   slgf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn_and_split "*subdi3_31z"
  [(set (match_operand:DI 0 "register_operand" "=&d")
        (minus:DI (match_operand:DI 1 "register_operand" "0")
                  (match_operand:DI 2 "general_operand" "do") ) )
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_64BIT && TARGET_CPU_ZARCH"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (reg:CCL2 CC_REGNUM)
          (compare:CCL2 (minus:SI (match_dup 7) (match_dup 8))
                        (match_dup 7)))
     (set (match_dup 6) (minus:SI (match_dup 7) (match_dup 8)))])
   (parallel
    [(set (match_dup 3) (minus:SI (minus:SI (match_dup 4) (match_dup 5))
                                  (gtu:SI (reg:CCL2 CC_REGNUM) (const_int 0))))
     (clobber (reg:CC CC_REGNUM))])]
  "operands[3] = operand_subword (operands[0], 0, 0, DImode);
   operands[4] = operand_subword (operands[1], 0, 0, DImode);
   operands[5] = operand_subword (operands[2], 0, 0, DImode);
   operands[6] = operand_subword (operands[0], 1, 0, DImode);
   operands[7] = operand_subword (operands[1], 1, 0, DImode);
   operands[8] = operand_subword (operands[2], 1, 0, DImode);")

(define_insn_and_split "*subdi3_31"
  [(set (match_operand:DI 0 "register_operand" "=&d")
        (minus:DI (match_operand:DI 1 "register_operand" "0")
                  (match_operand:DI 2 "general_operand" "do") ) )
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_CPU_ZARCH"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (match_dup 3) (minus:SI (match_dup 4) (match_dup 5)))
     (clobber (reg:CC CC_REGNUM))])
   (parallel
    [(set (reg:CCL2 CC_REGNUM)
          (compare:CCL2 (minus:SI (match_dup 7) (match_dup 8))
                        (match_dup 7)))
     (set (match_dup 6) (minus:SI (match_dup 7) (match_dup 8)))])
   (set (pc)
        (if_then_else (gtu (reg:CCL2 CC_REGNUM) (const_int 0))
                      (pc)
                      (label_ref (match_dup 9))))
   (parallel
    [(set (match_dup 3) (plus:SI (match_dup 3) (const_int -1)))
     (clobber (reg:CC CC_REGNUM))])
   (match_dup 9)]
  "operands[3] = operand_subword (operands[0], 0, 0, DImode);
   operands[4] = operand_subword (operands[1], 0, 0, DImode);
   operands[5] = operand_subword (operands[2], 0, 0, DImode);
   operands[6] = operand_subword (operands[0], 1, 0, DImode);
   operands[7] = operand_subword (operands[1], 1, 0, DImode);
   operands[8] = operand_subword (operands[2], 1, 0, DImode);
   operands[9] = gen_label_rtx ();")

;
; subsi3 instruction pattern(s).
;

(define_expand "subsi3"
  [(parallel
    [(set (match_operand:SI 0 "register_operand" "")
          (minus:SI (match_operand:SI 1 "register_operand" "")
                    (match_operand:SI 2 "general_operand" "")))
     (clobber (reg:CC CC_REGNUM))])]
  ""
  "")

(define_insn "*subsi3_sign"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (minus:SI (match_operand:SI 1 "register_operand" "0,0")
                  (sign_extend:SI (match_operand:HI 2 "memory_operand" "R,T"))))
   (clobber (reg:CC CC_REGNUM))]
  ""
  "@
   sh\t%0,%2
   shy\t%0,%2"
  [(set_attr "op_type"  "RX,RXY")])

;
; sub(di|si)3 instruction pattern(s).
;

; sr, s, sy, sgr, sg
(define_insn "*sub<mode>3"
  [(set (match_operand:GPR 0 "register_operand" "=d,d,d")
        (minus:GPR (match_operand:GPR 1 "register_operand" "0,0,0")
                   (match_operand:GPR 2 "general_operand" "d,R,T") ) )
   (clobber (reg:CC CC_REGNUM))]
  ""
  "@
   s<g>r\t%0,%2
   s<g>\t%0,%2
   s<y>\t%0,%2"
  [(set_attr "op_type"  "RR<E>,RX<Y>,RXY")])

; slr, sl, sly, slgr, slg
(define_insn "*sub<mode>3_borrow_cc"
  [(set (reg CC_REGNUM)
        (compare (minus:GPR (match_operand:GPR 1 "register_operand" "0,0,0")
                            (match_operand:GPR 2 "general_operand" "d,R,T"))
                 (match_dup 1)))
   (set (match_operand:GPR 0 "register_operand" "=d,d,d")
        (minus:GPR (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCL2mode)"
  "@
   sl<g>r\t%0,%2
   sl<g>\t%0,%2
   sl<y>\t%0,%2"
  [(set_attr "op_type"  "RR<E>,RX<Y>,RXY")])

; slr, sl, sly, slgr, slg
(define_insn "*sub<mode>3_borrow_cconly"
  [(set (reg CC_REGNUM)
        (compare (minus:GPR (match_operand:GPR 1 "register_operand" "0,0,0")
                            (match_operand:GPR 2 "general_operand" "d,R,T"))
                 (match_dup 1)))
   (clobber (match_scratch:GPR 0 "=d,d,d"))]
  "s390_match_ccmode (insn, CCL2mode)"
  "@
   sl<g>r\t%0,%2
   sl<g>\t%0,%2
   sl<y>\t%0,%2"
  [(set_attr "op_type"  "RR<E>,RX<Y>,RXY")])

; slr, sl, sly, slgr, slg
(define_insn "*sub<mode>3_cc"
  [(set (reg CC_REGNUM)
        (compare (minus:GPR (match_operand:GPR 1 "register_operand" "0,0,0")
                            (match_operand:GPR 2 "general_operand" "d,R,T"))
                 (const_int 0)))
   (set (match_operand:GPR 0 "register_operand" "=d,d,d")
        (minus:GPR (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCLmode)"
  "@
   sl<g>r\t%0,%2
   sl<g>\t%0,%2
   sl<y>\t%0,%2"
  [(set_attr "op_type"  "RR<E>,RX<Y>,RXY")])

; slr, sl, sly, slgr, slg
(define_insn "*sub<mode>3_cc2"
  [(set (reg CC_REGNUM)
        (compare (match_operand:GPR 1 "register_operand" "0,0,0")
                 (match_operand:GPR 2 "general_operand" "d,R,T")))
   (set (match_operand:GPR 0 "register_operand" "=d,d,d")
        (minus:GPR (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCL3mode)"
  "@
   sl<g>r\t%0,%2
   sl<g>\t%0,%2
   sl<y>\t%0,%2"
  [(set_attr "op_type"  "RR<E>,RX<Y>,RXY")])

; slr, sl, sly, slgr, slg
(define_insn "*sub<mode>3_cconly"
  [(set (reg CC_REGNUM)
        (compare (minus:GPR (match_operand:GPR 1 "register_operand" "0,0,0")
                            (match_operand:GPR 2 "general_operand" "d,R,T"))
                 (const_int 0)))
   (clobber (match_scratch:GPR 0 "=d,d,d"))]
  "s390_match_ccmode (insn, CCLmode)"
  "@
   sl<g>r\t%0,%2
   sl<g>\t%0,%2
   sl<y>\t%0,%2"
  [(set_attr "op_type"  "RR<E>,RX<Y>,RXY")])

; slr, sl, sly, slgr, slg
(define_insn "*sub<mode>3_cconly2"
  [(set (reg CC_REGNUM)
        (compare (match_operand:GPR 1 "register_operand" "0,0,0")
                 (match_operand:GPR 2 "general_operand" "d,R,T")))
   (clobber (match_scratch:GPR 0 "=d,d,d"))]
  "s390_match_ccmode (insn, CCL3mode)"
  "@
   sl<g>r\t%0,%2
   sl<g>\t%0,%2
   sl<y>\t%0,%2"
  [(set_attr "op_type"  "RR<E>,RX<Y>,RXY")])

;
; sub(df|sf)3 instruction pattern(s).
;

(define_expand "sub<mode>3"
  [(parallel
    [(set (match_operand:FPR 0 "register_operand" "=f,f")
          (minus:FPR (match_operand:FPR 1 "register_operand" "0,0")
                     (match_operand:FPR 2 "general_operand" "f,R")))
     (clobber (reg:CC CC_REGNUM))])]
  "TARGET_HARD_FLOAT"
  "")

; sxbr, sdbr, sebr, sxb, sdb, seb
(define_insn "*sub<mode>3"
  [(set (match_operand:FPR 0 "register_operand" "=f,f")
        (minus:FPR (match_operand:FPR 1 "register_operand" "0,0")
                   (match_operand:FPR 2 "general_operand" "f,<Rf>")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   s<xde>br\t%0,%2
   s<xde>b\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimp<mode>")])

; sxbr, sdbr, sebr, sxb, sdb, seb
(define_insn "*sub<mode>3_cc"
  [(set (reg CC_REGNUM)
        (compare (minus:FPR (match_operand:FPR 1 "nonimmediate_operand" "0,0")
                            (match_operand:FPR 2 "general_operand" "f,<Rf>"))
                 (match_operand:FPR 3 "const0_operand" "")))
   (set (match_operand:FPR 0 "register_operand" "=f,f")
        (minus:FPR (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   s<xde>br\t%0,%2
   s<xde>b\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimp<mode>")])

; sxbr, sdbr, sebr, sxb, sdb, seb
(define_insn "*sub<mode>3_cconly"
  [(set (reg CC_REGNUM)
        (compare (minus:FPR (match_operand:FPR 1 "nonimmediate_operand" "0,0")
                            (match_operand:FPR 2 "general_operand" "f,<Rf>"))
                 (match_operand:FPR 3 "const0_operand" "")))
   (clobber (match_scratch:FPR 0 "=f,f"))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   s<xde>br\t%0,%2
   s<xde>b\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fsimp<mode>")])

; sxr, sdr, ser, sx, sd, se
(define_insn "*sub<mode>3_ibm"
  [(set (match_operand:FPR 0 "register_operand" "=f,f")
        (minus:FPR (match_operand:FPR 1 "register_operand" "0,0")
                   (match_operand:FPR 2 "general_operand" "f,<Rf>")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   s<xde>r\t%0,%2
   s<xde>\t%0,%2"
  [(set_attr "op_type"  "<RRe>,<RXe>")
   (set_attr "type"     "fsimp<mode>")])


;;
;;- Conditional add/subtract instructions.
;;

;
; add(di|si)cc instruction pattern(s).
;

; alcr, alc, alcgr, alcg
(define_insn "*add<mode>3_alc_cc"
  [(set (reg CC_REGNUM)
        (compare
          (plus:GPR (plus:GPR (match_operand:GPR 1 "nonimmediate_operand" "%0,0")
                              (match_operand:GPR 2 "general_operand" "d,m"))
                    (match_operand:GPR 3 "s390_alc_comparison" ""))
          (const_int 0)))
   (set (match_operand:GPR 0 "register_operand" "=d,d")
        (plus:GPR (plus:GPR (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_CPU_ZARCH"
  "@
   alc<g>r\t%0,%2
   alc<g>\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

; alcr, alc, alcgr, alcg
(define_insn "*add<mode>3_alc"
  [(set (match_operand:GPR 0 "register_operand" "=d,d")
        (plus:GPR (plus:GPR (match_operand:GPR 1 "nonimmediate_operand" "%0,0")
                            (match_operand:GPR 2 "general_operand" "d,m"))
                  (match_operand:GPR 3 "s390_alc_comparison" "")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_CPU_ZARCH"
  "@
   alc<g>r\t%0,%2
   alc<g>\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

; slbr, slb, slbgr, slbg
(define_insn "*sub<mode>3_slb_cc"
  [(set (reg CC_REGNUM)
        (compare
          (minus:GPR (minus:GPR (match_operand:GPR 1 "nonimmediate_operand" "0,0")
                                (match_operand:GPR 2 "general_operand" "d,m"))
                     (match_operand:GPR 3 "s390_slb_comparison" ""))
          (const_int 0)))
   (set (match_operand:GPR 0 "register_operand" "=d,d")
        (minus:GPR (minus:GPR (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "s390_match_ccmode (insn, CCLmode) && TARGET_CPU_ZARCH"
  "@
   slb<g>r\t%0,%2
   slb<g>\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

; slbr, slb, slbgr, slbg
(define_insn "*sub<mode>3_slb"
  [(set (match_operand:GPR 0 "register_operand" "=d,d")
        (minus:GPR (minus:GPR (match_operand:GPR 1 "nonimmediate_operand" "0,0")
                              (match_operand:GPR 2 "general_operand" "d,m"))
                   (match_operand:GPR 3 "s390_slb_comparison" "")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_CPU_ZARCH"
  "@
   slb<g>r\t%0,%2
   slb<g>\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_expand "add<mode>cc"
  [(match_operand:GPR 0 "register_operand" "")
   (match_operand 1 "comparison_operator" "")
   (match_operand:GPR 2 "register_operand" "")
   (match_operand:GPR 3 "const_int_operand" "")]
  "TARGET_CPU_ZARCH"
  "if (!s390_expand_addcc (GET_CODE (operands[1]), 
                           s390_compare_op0, s390_compare_op1, 
                           operands[0], operands[2], 
                           operands[3])) FAIL; DONE;")

;
; scond instruction pattern(s).
;

(define_insn_and_split "*scond<mode>"
  [(set (match_operand:GPR 0 "register_operand" "=&d")
        (match_operand:GPR 1 "s390_alc_comparison" ""))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_CPU_ZARCH"
  "#"
  "&& reload_completed"
  [(set (match_dup 0) (const_int 0))
   (parallel
    [(set (match_dup 0) (plus:GPR (plus:GPR (match_dup 0) (match_dup 0))
                                  (match_dup 1)))
     (clobber (reg:CC CC_REGNUM))])]
  "")

(define_insn_and_split "*scond<mode>_neg"
  [(set (match_operand:GPR 0 "register_operand" "=&d")
        (match_operand:GPR 1 "s390_slb_comparison" ""))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_CPU_ZARCH"
  "#"
  "&& reload_completed"
  [(set (match_dup 0) (const_int 0))
   (parallel
    [(set (match_dup 0) (minus:GPR (minus:GPR (match_dup 0) (match_dup 0))
                                   (match_dup 1)))
     (clobber (reg:CC CC_REGNUM))])
   (parallel
    [(set (match_dup 0) (neg:GPR (match_dup 0)))
     (clobber (reg:CC CC_REGNUM))])]
  "")


(define_expand "s<code>"
  [(set (match_operand:SI 0 "register_operand" "")
        (SCOND (match_dup 0)
               (match_dup 0)))]
  "TARGET_CPU_ZARCH"
  "if (!s390_expand_addcc (<CODE>, s390_compare_op0, s390_compare_op1,
                           operands[0], const0_rtx, const1_rtx)) FAIL; DONE;")

(define_expand "seq"
  [(parallel
    [(set (match_operand:SI 0 "register_operand" "=d")
          (match_dup 1))
     (clobber (reg:CC CC_REGNUM))])
   (parallel
    [(set (match_dup 0) (xor:SI (match_dup 0) (const_int 1)))
     (clobber (reg:CC CC_REGNUM))])]
  ""
{ 
  if (!s390_compare_emitted || GET_MODE (s390_compare_emitted) != CCZ1mode)
    FAIL;
  operands[1] = s390_emit_compare (NE, s390_compare_op0, s390_compare_op1);
  PUT_MODE (operands[1], SImode);
})

(define_insn_and_split "*sne"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (ne:SI (match_operand:CCZ1 1 "register_operand" "0") 
               (const_int 0)))
   (clobber (reg:CC CC_REGNUM))]
  ""
  "#"
  "reload_completed"
  [(parallel
    [(set (match_dup 0) (ashiftrt:SI (match_dup 0) (const_int 28)))
     (clobber (reg:CC CC_REGNUM))])])


;;
;;- Multiply instructions.
;;

;
; muldi3 instruction pattern(s).
;

(define_insn "*muldi3_sign"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (mult:DI (sign_extend:DI (match_operand:SI 2 "nonimmediate_operand" "d,m"))
                 (match_operand:DI 1 "register_operand" "0,0")))]
  "TARGET_64BIT"
  "@
   msgfr\t%0,%2
   msgf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")
   (set_attr "type"     "imuldi")])

(define_insn "muldi3"
  [(set (match_operand:DI 0 "register_operand" "=d,d,d")
        (mult:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0,0")
                 (match_operand:DI 2 "general_operand" "d,K,m")))]
  "TARGET_64BIT"
  "@
   msgr\t%0,%2
   mghi\t%0,%h2
   msg\t%0,%2"
  [(set_attr "op_type"  "RRE,RI,RXY")
   (set_attr "type"     "imuldi")])

;
; mulsi3 instruction pattern(s).
;

(define_insn "*mulsi3_sign"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (mult:SI (sign_extend:SI (match_operand:HI 2 "memory_operand" "R"))
                 (match_operand:SI 1 "register_operand" "0")))]
  ""
  "mh\t%0,%2"
  [(set_attr "op_type"  "RX")
   (set_attr "type"     "imulhi")])

(define_insn "mulsi3"
  [(set (match_operand:SI 0 "register_operand" "=d,d,d,d")
        (mult:SI  (match_operand:SI 1 "nonimmediate_operand" "%0,0,0,0")
                  (match_operand:SI 2 "general_operand" "d,K,R,T")))]
  ""
  "@
   msr\t%0,%2
   mhi\t%0,%h2
   ms\t%0,%2
   msy\t%0,%2"
  [(set_attr "op_type"  "RRE,RI,RX,RXY")
   (set_attr "type"     "imulsi,imulhi,imulsi,imulsi")])

;
; mulsidi3 instruction pattern(s).
;

(define_insn "mulsidi3"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (mult:DI (sign_extend:DI
                   (match_operand:SI 1 "register_operand" "%0,0"))
                 (sign_extend:DI
                   (match_operand:SI 2 "nonimmediate_operand" "d,R"))))]
  "!TARGET_64BIT"
  "@
   mr\t%0,%2
   m\t%0,%2"
  [(set_attr "op_type"  "RR,RX")
   (set_attr "type"     "imulsi")])

;
; umulsidi3 instruction pattern(s).
;

(define_insn "umulsidi3"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (mult:DI (zero_extend:DI
                   (match_operand:SI 1 "register_operand" "%0,0"))
                 (zero_extend:DI
                   (match_operand:SI 2 "nonimmediate_operand" "d,m"))))]
  "!TARGET_64BIT && TARGET_CPU_ZARCH"
  "@
   mlr\t%0,%2
   ml\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")
   (set_attr "type"     "imulsi")])

;
; mul(df|sf)3 instruction pattern(s).
;

(define_expand "mul<mode>3"
  [(set (match_operand:FPR 0 "register_operand" "=f,f")
        (mult:FPR (match_operand:FPR 1 "nonimmediate_operand" "%0,0")
                  (match_operand:FPR 2 "general_operand" "f,<Rf>")))]
  "TARGET_HARD_FLOAT"
  "")

; mxbr mdbr, meebr, mxb, mxb, meeb
(define_insn "*mul<mode>3"
  [(set (match_operand:FPR 0 "register_operand" "=f,f")
        (mult:FPR (match_operand:FPR 1 "nonimmediate_operand" "%0,0")
                  (match_operand:FPR 2 "general_operand" "f,<Rf>")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   m<xdee>br\t%0,%2
   m<xdee>b\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fmul<mode>")])

; mxr, mdr, mer, mx, md, me
(define_insn "*mul<mode>3_ibm"
  [(set (match_operand:FPR 0 "register_operand" "=f,f")
        (mult:FPR (match_operand:FPR 1 "nonimmediate_operand" "%0,0")
                  (match_operand:FPR 2 "general_operand" "f,<Rf>")))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   m<xde>r\t%0,%2
   m<xde>\t%0,%2"
  [(set_attr "op_type"  "<RRe>,<RXe>")
   (set_attr "type"     "fmul<mode>")])

; maxbr, madbr, maebr, maxb, madb, maeb
(define_insn "*fmadd<mode>"
  [(set (match_operand:DSF 0 "register_operand" "=f,f")
        (plus:DSF (mult:DSF (match_operand:DSF 1 "register_operand" "%f,f")
                            (match_operand:DSF 2 "nonimmediate_operand"  "f,R"))
                 (match_operand:DSF 3 "register_operand" "0,0")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT && TARGET_FUSED_MADD"
  "@
   ma<xde>br\t%0,%1,%2
   ma<xde>b\t%0,%1,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fmul<mode>")])

; msxbr, msdbr, msebr, msxb, msdb, mseb
(define_insn "*fmsub<mode>"
  [(set (match_operand:DSF 0 "register_operand" "=f,f")
        (minus:DSF (mult:DSF (match_operand:DSF 1 "register_operand" "f,f")
                             (match_operand:DSF 2 "nonimmediate_operand"  "f,R"))
                 (match_operand:DSF 3 "register_operand" "0,0")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT && TARGET_FUSED_MADD"
  "@
   ms<xde>br\t%0,%1,%2
   ms<xde>b\t%0,%1,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fmul<mode>")])

;;
;;- Divide and modulo instructions.
;;

;
; divmoddi4 instruction pattern(s).
;

(define_expand "divmoddi4"
  [(parallel [(set (match_operand:DI 0 "general_operand" "")
                   (div:DI (match_operand:DI 1 "register_operand" "")
                           (match_operand:DI 2 "general_operand" "")))
              (set (match_operand:DI 3 "general_operand" "")
                   (mod:DI (match_dup 1) (match_dup 2)))])
   (clobber (match_dup 4))]
  "TARGET_64BIT"
{
  rtx insn, div_equal, mod_equal;

  div_equal = gen_rtx_DIV (DImode, operands[1], operands[2]);
  mod_equal = gen_rtx_MOD (DImode, operands[1], operands[2]);

  operands[4] = gen_reg_rtx(TImode);
  emit_insn (gen_divmodtidi3 (operands[4], operands[1], operands[2]));

  insn = emit_move_insn (operands[0], gen_lowpart (DImode, operands[4]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, div_equal, REG_NOTES (insn));

  insn = emit_move_insn (operands[3], gen_highpart (DImode, operands[4]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, mod_equal, REG_NOTES (insn));

  DONE;
})

(define_insn "divmodtidi3"
  [(set (match_operand:TI 0 "register_operand" "=d,d")
        (ior:TI
          (ashift:TI
            (zero_extend:TI
              (mod:DI (match_operand:DI 1 "register_operand" "0,0")
                      (match_operand:DI 2 "general_operand" "d,m")))
            (const_int 64))
          (zero_extend:TI (div:DI (match_dup 1) (match_dup 2)))))]
  "TARGET_64BIT"
  "@
   dsgr\t%0,%2
   dsg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")
   (set_attr "type"     "idiv")])

(define_insn "divmodtisi3"
  [(set (match_operand:TI 0 "register_operand" "=d,d")
        (ior:TI
          (ashift:TI
            (zero_extend:TI
              (mod:DI (match_operand:DI 1 "register_operand" "0,0")
                      (sign_extend:DI
                        (match_operand:SI 2 "nonimmediate_operand" "d,m"))))
            (const_int 64))
          (zero_extend:TI
            (div:DI (match_dup 1) (sign_extend:DI (match_dup 2))))))]
  "TARGET_64BIT"
  "@
   dsgfr\t%0,%2
   dsgf\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")
   (set_attr "type"     "idiv")])

;
; udivmoddi4 instruction pattern(s).
;

(define_expand "udivmoddi4"
  [(parallel [(set (match_operand:DI 0 "general_operand" "")
                   (udiv:DI (match_operand:DI 1 "general_operand" "")
                            (match_operand:DI 2 "nonimmediate_operand" "")))
              (set (match_operand:DI 3 "general_operand" "")
                   (umod:DI (match_dup 1) (match_dup 2)))])
   (clobber (match_dup 4))]
  "TARGET_64BIT"
{
  rtx insn, div_equal, mod_equal, equal;

  div_equal = gen_rtx_UDIV (DImode, operands[1], operands[2]);
  mod_equal = gen_rtx_UMOD (DImode, operands[1], operands[2]);
  equal = gen_rtx_IOR (TImode,
                       gen_rtx_ASHIFT (TImode,
                                       gen_rtx_ZERO_EXTEND (TImode, mod_equal),
                                       GEN_INT (64)),
                       gen_rtx_ZERO_EXTEND (TImode, div_equal));

  operands[4] = gen_reg_rtx(TImode);
  emit_insn (gen_rtx_CLOBBER (VOIDmode, operands[4]));
  emit_move_insn (gen_lowpart (DImode, operands[4]), operands[1]);
  emit_move_insn (gen_highpart (DImode, operands[4]), const0_rtx);
  insn = emit_insn (gen_udivmodtidi3 (operands[4], operands[4], operands[2]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, equal, REG_NOTES (insn));

  insn = emit_move_insn (operands[0], gen_lowpart (DImode, operands[4]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, div_equal, REG_NOTES (insn));

  insn = emit_move_insn (operands[3], gen_highpart (DImode, operands[4]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, mod_equal, REG_NOTES (insn));

  DONE;
})

(define_insn "udivmodtidi3"
  [(set (match_operand:TI 0 "register_operand" "=d,d")
        (ior:TI
          (ashift:TI
            (zero_extend:TI
              (truncate:DI
                (umod:TI (match_operand:TI 1 "register_operand" "0,0")
                         (zero_extend:TI
                           (match_operand:DI 2 "nonimmediate_operand" "d,m")))))
            (const_int 64))
          (zero_extend:TI
            (truncate:DI
              (udiv:TI (match_dup 1) (zero_extend:TI (match_dup 2)))))))]
  "TARGET_64BIT"
  "@
   dlgr\t%0,%2
   dlg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")
   (set_attr "type"     "idiv")])

;
; divmodsi4 instruction pattern(s).
;

(define_expand "divmodsi4"
  [(parallel [(set (match_operand:SI 0 "general_operand" "")
                   (div:SI (match_operand:SI 1 "general_operand" "")
                           (match_operand:SI 2 "nonimmediate_operand" "")))
              (set (match_operand:SI 3 "general_operand" "")
                   (mod:SI (match_dup 1) (match_dup 2)))])
   (clobber (match_dup 4))]
  "!TARGET_64BIT"
{
  rtx insn, div_equal, mod_equal, equal;

  div_equal = gen_rtx_DIV (SImode, operands[1], operands[2]);
  mod_equal = gen_rtx_MOD (SImode, operands[1], operands[2]);
  equal = gen_rtx_IOR (DImode,
                       gen_rtx_ASHIFT (DImode,
                                       gen_rtx_ZERO_EXTEND (DImode, mod_equal),
                                       GEN_INT (32)),
                       gen_rtx_ZERO_EXTEND (DImode, div_equal));

  operands[4] = gen_reg_rtx(DImode);
  emit_insn (gen_extendsidi2 (operands[4], operands[1]));
  insn = emit_insn (gen_divmoddisi3 (operands[4], operands[4], operands[2]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, equal, REG_NOTES (insn));

  insn = emit_move_insn (operands[0], gen_lowpart (SImode, operands[4]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, div_equal, REG_NOTES (insn));

  insn = emit_move_insn (operands[3], gen_highpart (SImode, operands[4]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, mod_equal, REG_NOTES (insn));

  DONE;
})

(define_insn "divmoddisi3"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (ior:DI
          (ashift:DI
            (zero_extend:DI
              (truncate:SI
                (mod:DI (match_operand:DI 1 "register_operand" "0,0")
                        (sign_extend:DI
                          (match_operand:SI 2 "nonimmediate_operand" "d,R")))))
            (const_int 32))
          (zero_extend:DI
            (truncate:SI
              (div:DI (match_dup 1) (sign_extend:DI (match_dup 2)))))))]
  "!TARGET_64BIT"
  "@
   dr\t%0,%2
   d\t%0,%2"
  [(set_attr "op_type"  "RR,RX")
   (set_attr "type"     "idiv")])

;
; udivsi3 and umodsi3 instruction pattern(s).
;

(define_expand "udivmodsi4"
  [(parallel [(set (match_operand:SI 0 "general_operand" "")
                   (udiv:SI (match_operand:SI 1 "general_operand" "")
                            (match_operand:SI 2 "nonimmediate_operand" "")))
              (set (match_operand:SI 3 "general_operand" "")
                   (umod:SI (match_dup 1) (match_dup 2)))])
   (clobber (match_dup 4))]
  "!TARGET_64BIT && TARGET_CPU_ZARCH"
{
  rtx insn, div_equal, mod_equal, equal;

  div_equal = gen_rtx_UDIV (SImode, operands[1], operands[2]);
  mod_equal = gen_rtx_UMOD (SImode, operands[1], operands[2]);
  equal = gen_rtx_IOR (DImode,
                       gen_rtx_ASHIFT (DImode,
                                       gen_rtx_ZERO_EXTEND (DImode, mod_equal),
                                       GEN_INT (32)),
                       gen_rtx_ZERO_EXTEND (DImode, div_equal));

  operands[4] = gen_reg_rtx(DImode);
  emit_insn (gen_rtx_CLOBBER (VOIDmode, operands[4]));
  emit_move_insn (gen_lowpart (SImode, operands[4]), operands[1]);
  emit_move_insn (gen_highpart (SImode, operands[4]), const0_rtx);
  insn = emit_insn (gen_udivmoddisi3 (operands[4], operands[4], operands[2]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, equal, REG_NOTES (insn));

  insn = emit_move_insn (operands[0], gen_lowpart (SImode, operands[4]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, div_equal, REG_NOTES (insn));

  insn = emit_move_insn (operands[3], gen_highpart (SImode, operands[4]));
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, mod_equal, REG_NOTES (insn));

  DONE;
})

(define_insn "udivmoddisi3"
  [(set (match_operand:DI 0 "register_operand" "=d,d")
        (ior:DI
          (ashift:DI
            (zero_extend:DI
              (truncate:SI
                (umod:DI (match_operand:DI 1 "register_operand" "0,0")
                         (zero_extend:DI
                           (match_operand:SI 2 "nonimmediate_operand" "d,m")))))
            (const_int 32))
          (zero_extend:DI
            (truncate:SI
              (udiv:DI (match_dup 1) (zero_extend:DI (match_dup 2)))))))]
  "!TARGET_64BIT && TARGET_CPU_ZARCH"
  "@
   dlr\t%0,%2
   dl\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")
   (set_attr "type"     "idiv")])

(define_expand "udivsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (udiv:SI (match_operand:SI 1 "general_operand" "")
                 (match_operand:SI 2 "general_operand" "")))
   (clobber (match_dup 3))]
  "!TARGET_64BIT && !TARGET_CPU_ZARCH"
{
  rtx insn, udiv_equal, umod_equal, equal;

  udiv_equal = gen_rtx_UDIV (SImode, operands[1], operands[2]);
  umod_equal = gen_rtx_UMOD (SImode, operands[1], operands[2]);
  equal = gen_rtx_IOR (DImode,
                       gen_rtx_ASHIFT (DImode,
                                       gen_rtx_ZERO_EXTEND (DImode, umod_equal),
                                       GEN_INT (32)),
                       gen_rtx_ZERO_EXTEND (DImode, udiv_equal));

  operands[3] = gen_reg_rtx (DImode);

  if (CONSTANT_P (operands[2]))
    {
      if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) < 0)
        {
          rtx label1 = gen_label_rtx ();

          operands[1] = make_safe_from (operands[1], operands[0]);
          emit_move_insn (operands[0], const0_rtx);
          emit_insn (gen_cmpsi (operands[1], operands[2]));
          emit_jump_insn (gen_bltu (label1));
          emit_move_insn (operands[0], const1_rtx);
          emit_label (label1);
        }
      else
        {
          operands[2] = force_reg (SImode, operands[2]);
          operands[2] = make_safe_from (operands[2], operands[0]);

          emit_insn (gen_zero_extendsidi2 (operands[3], operands[1]));
          insn = emit_insn (gen_divmoddisi3 (operands[3], operands[3],
                                             operands[2]));
          REG_NOTES (insn) =
            gen_rtx_EXPR_LIST (REG_EQUAL, equal, REG_NOTES (insn));

          insn = emit_move_insn (operands[0],
                                 gen_lowpart (SImode, operands[3]));
          REG_NOTES (insn) =
            gen_rtx_EXPR_LIST (REG_EQUAL,
                               udiv_equal, REG_NOTES (insn));
        }
    }
  else
    {
      rtx label1 = gen_label_rtx ();
      rtx label2 = gen_label_rtx ();
      rtx label3 = gen_label_rtx ();

      operands[1] = force_reg (SImode, operands[1]);
      operands[1] = make_safe_from (operands[1], operands[0]);
      operands[2] = force_reg (SImode, operands[2]);
      operands[2] = make_safe_from (operands[2], operands[0]);

      emit_move_insn (operands[0], const0_rtx);
      emit_insn (gen_cmpsi (operands[2], operands[1]));
      emit_jump_insn (gen_bgtu (label3));
      emit_insn (gen_cmpsi (operands[2], const0_rtx));
      emit_jump_insn (gen_blt (label2));
      emit_insn (gen_cmpsi (operands[2], const1_rtx));
      emit_jump_insn (gen_beq (label1));
      emit_insn (gen_zero_extendsidi2 (operands[3], operands[1]));
      insn = emit_insn (gen_divmoddisi3 (operands[3], operands[3],
                                         operands[2]));
      REG_NOTES (insn) =
      gen_rtx_EXPR_LIST (REG_EQUAL, equal, REG_NOTES (insn));

      insn = emit_move_insn (operands[0],
                             gen_lowpart (SImode, operands[3]));
      REG_NOTES (insn) =
      gen_rtx_EXPR_LIST (REG_EQUAL,
                               udiv_equal, REG_NOTES (insn));
      emit_jump (label3);
      emit_label (label1);
      emit_move_insn (operands[0], operands[1]);
      emit_jump (label3);
      emit_label (label2);
      emit_move_insn (operands[0], const1_rtx);
      emit_label (label3);
    }
  emit_move_insn (operands[0], operands[0]);
  DONE;
})

(define_expand "umodsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (umod:SI (match_operand:SI 1 "nonimmediate_operand" "")
                 (match_operand:SI 2 "nonimmediate_operand" "")))
   (clobber (match_dup 3))]
  "!TARGET_64BIT && !TARGET_CPU_ZARCH"
{
  rtx insn, udiv_equal, umod_equal, equal;

  udiv_equal = gen_rtx_UDIV (SImode, operands[1], operands[2]);
  umod_equal = gen_rtx_UMOD (SImode, operands[1], operands[2]);
  equal = gen_rtx_IOR (DImode,
                       gen_rtx_ASHIFT (DImode,
                                       gen_rtx_ZERO_EXTEND (DImode, umod_equal),
                                       GEN_INT (32)),
                       gen_rtx_ZERO_EXTEND (DImode, udiv_equal));

  operands[3] = gen_reg_rtx (DImode);

  if (CONSTANT_P (operands[2]))
    {
      if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) <= 0)
        {
          rtx label1 = gen_label_rtx ();

          operands[1] = make_safe_from (operands[1], operands[0]);
          emit_move_insn (operands[0], operands[1]);
          emit_insn (gen_cmpsi (operands[0], operands[2]));
          emit_jump_insn (gen_bltu (label1));
          emit_insn (gen_abssi2 (operands[0], operands[2]));
          emit_insn (gen_addsi3 (operands[0], operands[0], operands[1]));
          emit_label (label1);
        }
      else
        {
          operands[2] = force_reg (SImode, operands[2]);
          operands[2] = make_safe_from (operands[2], operands[0]);

          emit_insn (gen_zero_extendsidi2 (operands[3], operands[1]));
          insn = emit_insn (gen_divmoddisi3 (operands[3], operands[3],
                                             operands[2]));
          REG_NOTES (insn) =
            gen_rtx_EXPR_LIST (REG_EQUAL, equal, REG_NOTES (insn));

          insn = emit_move_insn (operands[0],
                                 gen_highpart (SImode, operands[3]));
          REG_NOTES (insn) =
            gen_rtx_EXPR_LIST (REG_EQUAL,
                               umod_equal, REG_NOTES (insn));
        }
    }
  else
    {
      rtx label1 = gen_label_rtx ();
      rtx label2 = gen_label_rtx ();
      rtx label3 = gen_label_rtx ();

      operands[1] = force_reg (SImode, operands[1]);
      operands[1] = make_safe_from (operands[1], operands[0]);
      operands[2] = force_reg (SImode, operands[2]);
      operands[2] = make_safe_from (operands[2], operands[0]);

      emit_move_insn(operands[0], operands[1]);
      emit_insn (gen_cmpsi (operands[2], operands[1]));
      emit_jump_insn (gen_bgtu (label3));
      emit_insn (gen_cmpsi (operands[2], const0_rtx));
      emit_jump_insn (gen_blt (label2));
      emit_insn (gen_cmpsi (operands[2], const1_rtx));
      emit_jump_insn (gen_beq (label1));
      emit_insn (gen_zero_extendsidi2 (operands[3], operands[1]));
      insn = emit_insn (gen_divmoddisi3 (operands[3], operands[3],
                                         operands[2]));
      REG_NOTES (insn) =
      gen_rtx_EXPR_LIST (REG_EQUAL, equal, REG_NOTES (insn));

      insn = emit_move_insn (operands[0],
                             gen_highpart (SImode, operands[3]));
      REG_NOTES (insn) =
      gen_rtx_EXPR_LIST (REG_EQUAL,
                         umod_equal, REG_NOTES (insn));
      emit_jump (label3);
      emit_label (label1);
      emit_move_insn (operands[0], const0_rtx);
      emit_jump (label3);
      emit_label (label2);
      emit_insn (gen_subsi3 (operands[0], operands[0], operands[2]));
      emit_label (label3);
    }
  DONE;
})

;
; div(df|sf)3 instruction pattern(s).
;

(define_expand "div<mode>3"
  [(set (match_operand:FPR 0 "register_operand" "=f,f")
        (div:FPR (match_operand:FPR 1 "register_operand" "0,0")
                 (match_operand:FPR 2 "general_operand" "f,<Rf>")))]
  "TARGET_HARD_FLOAT"
  "")

; dxbr, ddbr, debr, dxb, ddb, deb
(define_insn "*div<mode>3"
  [(set (match_operand:FPR 0 "register_operand" "=f,f")
        (div:FPR (match_operand:FPR 1 "register_operand" "0,0")
                 (match_operand:FPR 2 "general_operand" "f,<Rf>")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   d<xde>br\t%0,%2
   d<xde>b\t%0,%2"
  [(set_attr "op_type"  "RRE,RXE")
   (set_attr "type"     "fdiv<mode>")])

; dxr, ddr, der, dx, dd, de
(define_insn "*div<mode>3_ibm"
  [(set (match_operand:FPR 0 "register_operand" "=f,f")
        (div:FPR (match_operand:FPR 1 "register_operand" "0,0")
                 (match_operand:FPR 2 "general_operand" "f,<Rf>")))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "@
   d<xde>r\t%0,%2
   d<xde>\t%0,%2"
  [(set_attr "op_type"  "<RRe>,<RXe>")
   (set_attr "type"     "fdiv<mode>")])


;;
;;- And instructions.
;;

(define_expand "and<mode>3"
  [(set (match_operand:INT 0 "nonimmediate_operand" "")
        (and:INT (match_operand:INT 1 "nonimmediate_operand" "")
                 (match_operand:INT 2 "general_operand" "")))
   (clobber (reg:CC CC_REGNUM))]
  ""
  "s390_expand_logical_operator (AND, <MODE>mode, operands); DONE;")

;
; anddi3 instruction pattern(s).
;

(define_insn "*anddi3_cc"
  [(set (reg CC_REGNUM)
        (compare (and:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                         (match_operand:DI 2 "general_operand" "d,m"))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d,d")
        (and:DI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode(insn, CCTmode) && TARGET_64BIT"
  "@
   ngr\t%0,%2
   ng\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*anddi3_cconly"
  [(set (reg CC_REGNUM)
        (compare (and:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                         (match_operand:DI 2 "general_operand" "d,m"))
                 (const_int 0)))
   (clobber (match_scratch:DI 0 "=d,d"))]
  "s390_match_ccmode(insn, CCTmode) && TARGET_64BIT
   /* Do not steal TM patterns.  */
   && s390_single_part (operands[2], DImode, HImode, 0) < 0"
  "@
   ngr\t%0,%2
   ng\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*anddi3_extimm"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=d,d,d,d,d,d,d,d,d,d,AQ,Q")
        (and:DI (match_operand:DI 1 "nonimmediate_operand"
                                    "%d,o,0,0,0,0,0,0,0,0,0,0")
                (match_operand:DI 2 "general_operand"
                                    "M,M,N0HDF,N1HDF,N2HDF,N3HDF,N0SDF,N1SDF,d,m,NxQDF,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT && TARGET_EXTIMM && s390_logical_operator_ok_p (operands)"
  "@
   #
   #
   nihh\t%0,%j2
   nihl\t%0,%j2
   nilh\t%0,%j2
   nill\t%0,%j2
   nihf\t%0,%m2
   nilf\t%0,%m2
   ngr\t%0,%2
   ng\t%0,%2
   #
   #"
  [(set_attr "op_type" "RRE,RXE,RI,RI,RI,RI,RIL,RIL,RRE,RXY,SI,SS")])

(define_insn "*anddi3"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=d,d,d,d,d,d,d,d,AQ,Q")
        (and:DI (match_operand:DI 1 "nonimmediate_operand"
                                    "%d,o,0,0,0,0,0,0,0,0")
                (match_operand:DI 2 "general_operand"
                                    "M,M,N0HDF,N1HDF,N2HDF,N3HDF,d,m,NxQDF,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT && !TARGET_EXTIMM && s390_logical_operator_ok_p (operands)"
  "@
   #
   #
   nihh\t%0,%j2
   nihl\t%0,%j2
   nilh\t%0,%j2
   nill\t%0,%j2
   ngr\t%0,%2
   ng\t%0,%2
   #
   #"
  [(set_attr "op_type" "RRE,RXE,RI,RI,RI,RI,RRE,RXY,SI,SS")])

(define_split
  [(set (match_operand:DI 0 "s_operand" "")
        (and:DI (match_dup 0) (match_operand:DI 1 "immediate_operand" "")))
   (clobber (reg:CC CC_REGNUM))]
  "reload_completed"
  [(parallel
    [(set (match_dup 0) (and:QI (match_dup 0) (match_dup 1)))
     (clobber (reg:CC CC_REGNUM))])]
  "s390_narrow_logical_operator (AND, &operands[0], &operands[1]);")


;
; andsi3 instruction pattern(s).
;

(define_insn "*andsi3_cc"
  [(set (reg CC_REGNUM)
        (compare (and:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0,0")
                         (match_operand:SI 2 "general_operand" "Os,d,R,T"))
                 (const_int 0)))
   (set (match_operand:SI 0 "register_operand" "=d,d,d,d")
        (and:SI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   nilf\t%0,%o2
   nr\t%0,%2
   n\t%0,%2
   ny\t%0,%2"
  [(set_attr "op_type"  "RIL,RR,RX,RXY")])

(define_insn "*andsi3_cconly"
  [(set (reg CC_REGNUM)
        (compare (and:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0,0")
                         (match_operand:SI 2 "general_operand" "Os,d,R,T"))
                 (const_int 0)))
   (clobber (match_scratch:SI 0 "=d,d,d,d"))]
  "s390_match_ccmode(insn, CCTmode)
   /* Do not steal TM patterns.  */
   && s390_single_part (operands[2], SImode, HImode, 0) < 0"
  "@
   nilf\t%0,%o2
   nr\t%0,%2
   n\t%0,%2
   ny\t%0,%2"
  [(set_attr "op_type"  "RIL,RR,RX,RXY")])

(define_insn "*andsi3_zarch"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=d,d,d,d,d,d,d,d,AQ,Q")
        (and:SI (match_operand:SI 1 "nonimmediate_operand"
                                    "%d,o,0,0,0,0,0,0,0,0")
                (match_operand:SI 2 "general_operand"
                                    "M,M,N0HSF,N1HSF,Os,d,R,T,NxQSF,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_ZARCH && s390_logical_operator_ok_p (operands)"
  "@
   #
   #
   nilh\t%0,%j2
   nill\t%0,%j2
   nilf\t%0,%o2
   nr\t%0,%2
   n\t%0,%2
   ny\t%0,%2
   #
   #"
  [(set_attr "op_type"  "RRE,RXE,RI,RI,RIL,RR,RX,RXY,SI,SS")])

(define_insn "*andsi3_esa"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=d,d,AQ,Q")
        (and:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0,0")
                (match_operand:SI 2 "general_operand" "d,R,NxQSF,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_ZARCH && s390_logical_operator_ok_p (operands)"
  "@
   nr\t%0,%2
   n\t%0,%2
   #
   #"
  [(set_attr "op_type"  "RR,RX,SI,SS")])

(define_split
  [(set (match_operand:SI 0 "s_operand" "")
        (and:SI (match_dup 0) (match_operand:SI 1 "immediate_operand" "")))
   (clobber (reg:CC CC_REGNUM))]
  "reload_completed"
  [(parallel
    [(set (match_dup 0) (and:QI (match_dup 0) (match_dup 1)))
     (clobber (reg:CC CC_REGNUM))])]
  "s390_narrow_logical_operator (AND, &operands[0], &operands[1]);")

;
; andhi3 instruction pattern(s).
;

(define_insn "*andhi3_zarch"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=d,d,AQ,Q")
        (and:HI (match_operand:HI 1 "nonimmediate_operand" "%0,0,0,0")
                (match_operand:HI 2 "general_operand" "d,n,NxQHF,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_ZARCH && s390_logical_operator_ok_p (operands)"
  "@
   nr\t%0,%2
   nill\t%0,%x2
   #
   #"
  [(set_attr "op_type"  "RR,RI,SI,SS")])

(define_insn "*andhi3_esa"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=d,AQ,Q")
        (and:HI (match_operand:HI 1 "nonimmediate_operand" "%0,0,0")
                (match_operand:HI 2 "general_operand" "d,NxQHF,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_ZARCH && s390_logical_operator_ok_p (operands)"
  "@
   nr\t%0,%2
   #
   #"
  [(set_attr "op_type"  "RR,SI,SS")])

(define_split
  [(set (match_operand:HI 0 "s_operand" "")
        (and:HI (match_dup 0) (match_operand:HI 1 "immediate_operand" "")))
   (clobber (reg:CC CC_REGNUM))]
  "reload_completed"
  [(parallel
    [(set (match_dup 0) (and:QI (match_dup 0) (match_dup 1)))
     (clobber (reg:CC CC_REGNUM))])]
  "s390_narrow_logical_operator (AND, &operands[0], &operands[1]);")

;
; andqi3 instruction pattern(s).
;

(define_insn "*andqi3_zarch"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=d,d,Q,S,Q")
        (and:QI (match_operand:QI 1 "nonimmediate_operand" "%0,0,0,0,0")
                (match_operand:QI 2 "general_operand" "d,n,n,n,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_ZARCH && s390_logical_operator_ok_p (operands)"
  "@
   nr\t%0,%2
   nill\t%0,%b2
   ni\t%S0,%b2
   niy\t%S0,%b2
   #"
  [(set_attr "op_type"  "RR,RI,SI,SIY,SS")])

(define_insn "*andqi3_esa"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=d,Q,Q")
        (and:QI (match_operand:QI 1 "nonimmediate_operand" "%0,0,0")
                (match_operand:QI 2 "general_operand" "d,n,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_ZARCH && s390_logical_operator_ok_p (operands)"
  "@
   nr\t%0,%2
   ni\t%S0,%b2
   #"
  [(set_attr "op_type"  "RR,SI,SS")])

;
; Block and (NC) patterns.
;

(define_insn "*nc"
  [(set (match_operand:BLK 0 "memory_operand" "=Q")
        (and:BLK (match_dup 0)
                 (match_operand:BLK 1 "memory_operand" "Q")))
   (use (match_operand 2 "const_int_operand" "n"))
   (clobber (reg:CC CC_REGNUM))]
  "INTVAL (operands[2]) >= 1 && INTVAL (operands[2]) <= 256"
  "nc\t%O0(%2,%R0),%S1"
  [(set_attr "op_type" "SS")])

(define_split
  [(set (match_operand 0 "memory_operand" "")
        (and (match_dup 0)
             (match_operand 1 "memory_operand" "")))
   (clobber (reg:CC CC_REGNUM))]
  "reload_completed
   && GET_MODE (operands[0]) == GET_MODE (operands[1])
   && GET_MODE_SIZE (GET_MODE (operands[0])) > 0"
  [(parallel
    [(set (match_dup 0) (and:BLK (match_dup 0) (match_dup 1)))
     (use (match_dup 2))
     (clobber (reg:CC CC_REGNUM))])]
{
  operands[2] = GEN_INT (GET_MODE_SIZE (GET_MODE (operands[0])));
  operands[0] = adjust_address (operands[0], BLKmode, 0);
  operands[1] = adjust_address (operands[1], BLKmode, 0);
})

(define_peephole2
  [(parallel
    [(set (match_operand:BLK 0 "memory_operand" "")
          (and:BLK (match_dup 0)
                   (match_operand:BLK 1 "memory_operand" "")))
     (use (match_operand 2 "const_int_operand" ""))
     (clobber (reg:CC CC_REGNUM))])
   (parallel
    [(set (match_operand:BLK 3 "memory_operand" "")
          (and:BLK (match_dup 3)
                   (match_operand:BLK 4 "memory_operand" "")))
     (use (match_operand 5 "const_int_operand" ""))
     (clobber (reg:CC CC_REGNUM))])]
  "s390_offset_p (operands[0], operands[3], operands[2])
   && s390_offset_p (operands[1], operands[4], operands[2])
   && !s390_overlap_p (operands[0], operands[1], 
                       INTVAL (operands[2]) + INTVAL (operands[5]))
   && INTVAL (operands[2]) + INTVAL (operands[5]) <= 256"
  [(parallel
    [(set (match_dup 6) (and:BLK (match_dup 6) (match_dup 7)))
     (use (match_dup 8))
     (clobber (reg:CC CC_REGNUM))])]
  "operands[6] = gen_rtx_MEM (BLKmode, XEXP (operands[0], 0));
   operands[7] = gen_rtx_MEM (BLKmode, XEXP (operands[1], 0));
   operands[8] = GEN_INT (INTVAL (operands[2]) + INTVAL (operands[5]));")


;;
;;- Bit set (inclusive or) instructions.
;;

(define_expand "ior<mode>3"
  [(set (match_operand:INT 0 "nonimmediate_operand" "")
        (ior:INT (match_operand:INT 1 "nonimmediate_operand" "")
                 (match_operand:INT 2 "general_operand" "")))
   (clobber (reg:CC CC_REGNUM))]
  ""
  "s390_expand_logical_operator (IOR, <MODE>mode, operands); DONE;")

;
; iordi3 instruction pattern(s).
;

(define_insn "*iordi3_cc"
  [(set (reg CC_REGNUM)
        (compare (ior:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                         (match_operand:DI 2 "general_operand" "d,m"))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d,d")
        (ior:DI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode(insn, CCTmode) && TARGET_64BIT"
  "@
   ogr\t%0,%2
   og\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*iordi3_cconly"
  [(set (reg CC_REGNUM)
        (compare (ior:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                         (match_operand:DI 2 "general_operand" "d,m"))
                 (const_int 0)))
   (clobber (match_scratch:DI 0 "=d,d"))]
  "s390_match_ccmode(insn, CCTmode) && TARGET_64BIT"
  "@
   ogr\t%0,%2
   og\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*iordi3_extimm"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=d,d,d,d,d,d,d,d,AQ,Q")
        (ior:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0,0,0,0,0,0,0,0,0")
                (match_operand:DI 2 "general_operand"
                                    "N0HD0,N1HD0,N2HD0,N3HD0,N0SD0,N1SD0,d,m,NxQD0,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT && TARGET_EXTIMM && s390_logical_operator_ok_p (operands)"
  "@
   oihh\t%0,%i2
   oihl\t%0,%i2
   oilh\t%0,%i2
   oill\t%0,%i2
   oihf\t%0,%k2
   oilf\t%0,%k2
   ogr\t%0,%2
   og\t%0,%2
   #
   #"
  [(set_attr "op_type"  "RI,RI,RI,RI,RIL,RIL,RRE,RXY,SI,SS")])

(define_insn "*iordi3"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=d,d,d,d,d,d,AQ,Q")
        (ior:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0,0,0,0,0,0,0")
                (match_operand:DI 2 "general_operand"
                                    "N0HD0,N1HD0,N2HD0,N3HD0,d,m,NxQD0,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT && !TARGET_EXTIMM && s390_logical_operator_ok_p (operands)"
  "@
   oihh\t%0,%i2
   oihl\t%0,%i2
   oilh\t%0,%i2
   oill\t%0,%i2
   ogr\t%0,%2
   og\t%0,%2
   #
   #"
  [(set_attr "op_type"  "RI,RI,RI,RI,RRE,RXY,SI,SS")])

(define_split
  [(set (match_operand:DI 0 "s_operand" "")
        (ior:DI (match_dup 0) (match_operand:DI 1 "immediate_operand" "")))
   (clobber (reg:CC CC_REGNUM))]
  "reload_completed"
  [(parallel
    [(set (match_dup 0) (ior:QI (match_dup 0) (match_dup 1)))
     (clobber (reg:CC CC_REGNUM))])]
  "s390_narrow_logical_operator (IOR, &operands[0], &operands[1]);")

;
; iorsi3 instruction pattern(s).
;

(define_insn "*iorsi3_cc"
  [(set (reg CC_REGNUM)
        (compare (ior:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0,0")
                         (match_operand:SI 2 "general_operand" "Os,d,R,T"))
                 (const_int 0)))
   (set (match_operand:SI 0 "register_operand" "=d,d,d,d")
        (ior:SI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   oilf\t%0,%o2
   or\t%0,%2
   o\t%0,%2
   oy\t%0,%2"
  [(set_attr "op_type"  "RIL,RR,RX,RXY")])

(define_insn "*iorsi3_cconly"
  [(set (reg CC_REGNUM)
        (compare (ior:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0,0")
                         (match_operand:SI 2 "general_operand" "Os,d,R,T"))
                 (const_int 0)))
   (clobber (match_scratch:SI 0 "=d,d,d,d"))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   oilf\t%0,%o2
   or\t%0,%2
   o\t%0,%2
   oy\t%0,%2"
  [(set_attr "op_type"  "RIL,RR,RX,RXY")])

(define_insn "*iorsi3_zarch"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=d,d,d,d,d,d,AQ,Q")
        (ior:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0,0,0,0,0,0")
                (match_operand:SI 2 "general_operand" "N0HS0,N1HS0,Os,d,R,T,NxQS0,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_ZARCH && s390_logical_operator_ok_p (operands)"
  "@
   oilh\t%0,%i2
   oill\t%0,%i2
   oilf\t%0,%o2
   or\t%0,%2
   o\t%0,%2
   oy\t%0,%2
   #
   #"
  [(set_attr "op_type"  "RI,RI,RIL,RR,RX,RXY,SI,SS")])

(define_insn "*iorsi3_esa"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=d,d,AQ,Q")
        (ior:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0,0")
                (match_operand:SI 2 "general_operand" "d,R,NxQS0,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_ZARCH && s390_logical_operator_ok_p (operands)"
  "@
   or\t%0,%2
   o\t%0,%2
   #
   #"
  [(set_attr "op_type"  "RR,RX,SI,SS")])

(define_split
  [(set (match_operand:SI 0 "s_operand" "")
        (ior:SI (match_dup 0) (match_operand:SI 1 "immediate_operand" "")))
   (clobber (reg:CC CC_REGNUM))]
  "reload_completed"
  [(parallel
    [(set (match_dup 0) (ior:QI (match_dup 0) (match_dup 1)))
     (clobber (reg:CC CC_REGNUM))])]
  "s390_narrow_logical_operator (IOR, &operands[0], &operands[1]);")

;
; iorhi3 instruction pattern(s).
;

(define_insn "*iorhi3_zarch"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=d,d,AQ,Q")
        (ior:HI (match_operand:HI 1 "nonimmediate_operand" "%0,0,0,0")
                (match_operand:HI 2 "general_operand" "d,n,NxQH0,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_ZARCH && s390_logical_operator_ok_p (operands)"
  "@
   or\t%0,%2
   oill\t%0,%x2
   #
   #"
  [(set_attr "op_type"  "RR,RI,SI,SS")])

(define_insn "*iorhi3_esa"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=d,AQ,Q")
        (ior:HI (match_operand:HI 1 "nonimmediate_operand" "%0,0,0")
                (match_operand:HI 2 "general_operand" "d,NxQH0,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_ZARCH && s390_logical_operator_ok_p (operands)"
  "@
   or\t%0,%2
   #
   #"
  [(set_attr "op_type"  "RR,SI,SS")])

(define_split
  [(set (match_operand:HI 0 "s_operand" "")
        (ior:HI (match_dup 0) (match_operand:HI 1 "immediate_operand" "")))
   (clobber (reg:CC CC_REGNUM))]
  "reload_completed"
  [(parallel
    [(set (match_dup 0) (ior:QI (match_dup 0) (match_dup 1)))
     (clobber (reg:CC CC_REGNUM))])]
  "s390_narrow_logical_operator (IOR, &operands[0], &operands[1]);")

;
; iorqi3 instruction pattern(s).
;

(define_insn "*iorqi3_zarch"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=d,d,Q,S,Q")
        (ior:QI (match_operand:QI 1 "nonimmediate_operand" "%0,0,0,0,0")
                (match_operand:QI 2 "general_operand" "d,n,n,n,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_ZARCH && s390_logical_operator_ok_p (operands)"
  "@
   or\t%0,%2
   oill\t%0,%b2
   oi\t%S0,%b2
   oiy\t%S0,%b2
   #"
  [(set_attr "op_type"  "RR,RI,SI,SIY,SS")])

(define_insn "*iorqi3_esa"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=d,Q,Q")
        (ior:QI (match_operand:QI 1 "nonimmediate_operand" "%0,0,0")
                (match_operand:QI 2 "general_operand" "d,n,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_ZARCH && s390_logical_operator_ok_p (operands)"
  "@
   or\t%0,%2
   oi\t%S0,%b2
   #"
  [(set_attr "op_type"  "RR,SI,SS")])

;
; Block inclusive or (OC) patterns.
;

(define_insn "*oc"
  [(set (match_operand:BLK 0 "memory_operand" "=Q")
        (ior:BLK (match_dup 0)
                 (match_operand:BLK 1 "memory_operand" "Q")))
   (use (match_operand 2 "const_int_operand" "n"))
   (clobber (reg:CC CC_REGNUM))]
  "INTVAL (operands[2]) >= 1 && INTVAL (operands[2]) <= 256"
  "oc\t%O0(%2,%R0),%S1"
  [(set_attr "op_type" "SS")])

(define_split
  [(set (match_operand 0 "memory_operand" "")
        (ior (match_dup 0)
             (match_operand 1 "memory_operand" "")))
   (clobber (reg:CC CC_REGNUM))]
  "reload_completed
   && GET_MODE (operands[0]) == GET_MODE (operands[1])
   && GET_MODE_SIZE (GET_MODE (operands[0])) > 0"
  [(parallel
    [(set (match_dup 0) (ior:BLK (match_dup 0) (match_dup 1)))
     (use (match_dup 2))
     (clobber (reg:CC CC_REGNUM))])]
{
  operands[2] = GEN_INT (GET_MODE_SIZE (GET_MODE (operands[0])));
  operands[0] = adjust_address (operands[0], BLKmode, 0);
  operands[1] = adjust_address (operands[1], BLKmode, 0);
})

(define_peephole2
  [(parallel
    [(set (match_operand:BLK 0 "memory_operand" "")
          (ior:BLK (match_dup 0)
                   (match_operand:BLK 1 "memory_operand" "")))
     (use (match_operand 2 "const_int_operand" ""))
     (clobber (reg:CC CC_REGNUM))])
   (parallel
    [(set (match_operand:BLK 3 "memory_operand" "")
          (ior:BLK (match_dup 3)
                   (match_operand:BLK 4 "memory_operand" "")))
     (use (match_operand 5 "const_int_operand" ""))
     (clobber (reg:CC CC_REGNUM))])]
  "s390_offset_p (operands[0], operands[3], operands[2])
   && s390_offset_p (operands[1], operands[4], operands[2])
   && !s390_overlap_p (operands[0], operands[1], 
                       INTVAL (operands[2]) + INTVAL (operands[5]))
   && INTVAL (operands[2]) + INTVAL (operands[5]) <= 256"
  [(parallel
    [(set (match_dup 6) (ior:BLK (match_dup 6) (match_dup 7)))
     (use (match_dup 8))
     (clobber (reg:CC CC_REGNUM))])]
  "operands[6] = gen_rtx_MEM (BLKmode, XEXP (operands[0], 0));
   operands[7] = gen_rtx_MEM (BLKmode, XEXP (operands[1], 0));
   operands[8] = GEN_INT (INTVAL (operands[2]) + INTVAL (operands[5]));")


;;
;;- Xor instructions.
;;

(define_expand "xor<mode>3"
  [(set (match_operand:INT 0 "nonimmediate_operand" "")
        (xor:INT (match_operand:INT 1 "nonimmediate_operand" "")
                 (match_operand:INT 2 "general_operand" "")))
   (clobber (reg:CC CC_REGNUM))]
  ""
  "s390_expand_logical_operator (XOR, <MODE>mode, operands); DONE;")

;
; xordi3 instruction pattern(s).
;

(define_insn "*xordi3_cc"
  [(set (reg CC_REGNUM)
        (compare (xor:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                         (match_operand:DI 2 "general_operand" "d,m"))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d,d")
        (xor:DI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode(insn, CCTmode) && TARGET_64BIT"
  "@
   xgr\t%0,%2
   xg\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*xordi3_cconly"
  [(set (reg CC_REGNUM)
        (compare (xor:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
                         (match_operand:DI 2 "general_operand" "d,m"))
                 (const_int 0)))
   (clobber (match_scratch:DI 0 "=d,d"))]
  "s390_match_ccmode(insn, CCTmode) && TARGET_64BIT"
  "@
   xgr\t%0,%2
   xr\t%0,%2"
  [(set_attr "op_type"  "RRE,RXY")])

(define_insn "*xordi3_extimm"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=d,d,d,d,AQ,Q")
        (xor:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0,0,0,0,0")
                (match_operand:DI 2 "general_operand" "N0SD0,N1SD0,d,m,NxQD0,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT && TARGET_EXTIMM && s390_logical_operator_ok_p (operands)"
  "@
   xihf\t%0,%k2
   xilf\t%0,%k2
   xgr\t%0,%2
   xg\t%0,%2
   #
   #"
  [(set_attr "op_type"  "RIL,RIL,RRE,RXY,SI,SS")])

(define_insn "*xordi3"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=d,d,AQ,Q")
        (xor:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0,0,0")
                (match_operand:DI 2 "general_operand" "d,m,NxQD0,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT && !TARGET_EXTIMM && s390_logical_operator_ok_p (operands)"
  "@
   xgr\t%0,%2
   xg\t%0,%2
   #
   #"
  [(set_attr "op_type"  "RRE,RXY,SI,SS")])

(define_split
  [(set (match_operand:DI 0 "s_operand" "")
        (xor:DI (match_dup 0) (match_operand:DI 1 "immediate_operand" "")))
   (clobber (reg:CC CC_REGNUM))]
  "reload_completed"
  [(parallel
    [(set (match_dup 0) (xor:QI (match_dup 0) (match_dup 1)))
     (clobber (reg:CC CC_REGNUM))])]
  "s390_narrow_logical_operator (XOR, &operands[0], &operands[1]);")

;
; xorsi3 instruction pattern(s).
;

(define_insn "*xorsi3_cc"
  [(set (reg CC_REGNUM)
        (compare (xor:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0,0")
                         (match_operand:SI 2 "general_operand" "Os,d,R,T"))
                 (const_int 0)))
   (set (match_operand:SI 0 "register_operand" "=d,d,d,d")
        (xor:SI (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   xilf\t%0,%o2
   xr\t%0,%2
   x\t%0,%2
   xy\t%0,%2"
  [(set_attr "op_type"  "RIL,RR,RX,RXY")])

(define_insn "*xorsi3_cconly"
  [(set (reg CC_REGNUM)
        (compare (xor:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0,0")
                         (match_operand:SI 2 "general_operand" "Os,d,R,T"))
                 (const_int 0)))
   (clobber (match_scratch:SI 0 "=d,d,d,d"))]
  "s390_match_ccmode(insn, CCTmode)"
  "@
   xilf\t%0,%o2
   xr\t%0,%2
   x\t%0,%2
   xy\t%0,%2"
  [(set_attr "op_type"  "RIL,RR,RX,RXY")])

(define_insn "*xorsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=d,d,d,d,AQ,Q")
        (xor:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,0,0,0,0")
                (match_operand:SI 2 "general_operand" "Os,d,R,T,NxQS0,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "s390_logical_operator_ok_p (operands)"
  "@
   xilf\t%0,%o2
   xr\t%0,%2
   x\t%0,%2
   xy\t%0,%2
   #
   #"
  [(set_attr "op_type"  "RIL,RR,RX,RXY,SI,SS")])

(define_split
  [(set (match_operand:SI 0 "s_operand" "")
        (xor:SI (match_dup 0) (match_operand:SI 1 "immediate_operand" "")))
   (clobber (reg:CC CC_REGNUM))]
  "reload_completed"
  [(parallel
    [(set (match_dup 0) (xor:QI (match_dup 0) (match_dup 1)))
     (clobber (reg:CC CC_REGNUM))])]
  "s390_narrow_logical_operator (XOR, &operands[0], &operands[1]);")

;
; xorhi3 instruction pattern(s).
;

(define_insn "*xorhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=d,d,AQ,Q")
        (xor:HI (match_operand:HI 1 "nonimmediate_operand" "%0,0,0,0")
                (match_operand:HI 2 "general_operand" "Os,d,NxQH0,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "s390_logical_operator_ok_p (operands)"
  "@
   xilf\t%0,%x2
   xr\t%0,%2
   #
   #"
  [(set_attr "op_type"  "RIL,RR,SI,SS")])

(define_split
  [(set (match_operand:HI 0 "s_operand" "")
        (xor:HI (match_dup 0) (match_operand:HI 1 "immediate_operand" "")))
   (clobber (reg:CC CC_REGNUM))]
  "reload_completed"
  [(parallel
    [(set (match_dup 0) (xor:QI (match_dup 0) (match_dup 1)))
     (clobber (reg:CC CC_REGNUM))])]
  "s390_narrow_logical_operator (XOR, &operands[0], &operands[1]);")

;
; xorqi3 instruction pattern(s).
;

(define_insn "*xorqi3"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=d,d,Q,S,Q")
        (xor:QI (match_operand:QI 1 "nonimmediate_operand" "%0,0,0,0,0")
                (match_operand:QI 2 "general_operand" "Os,d,n,n,Q")))
   (clobber (reg:CC CC_REGNUM))]
  "s390_logical_operator_ok_p (operands)"
  "@
   xilf\t%0,%b2
   xr\t%0,%2
   xi\t%S0,%b2
   xiy\t%S0,%b2
   #"
  [(set_attr "op_type"  "RIL,RR,SI,SIY,SS")])

;
; Block exclusive or (XC) patterns.
;

(define_insn "*xc"
  [(set (match_operand:BLK 0 "memory_operand" "=Q")
        (xor:BLK (match_dup 0)
                 (match_operand:BLK 1 "memory_operand" "Q")))
   (use (match_operand 2 "const_int_operand" "n"))
   (clobber (reg:CC CC_REGNUM))]
  "INTVAL (operands[2]) >= 1 && INTVAL (operands[2]) <= 256"
  "xc\t%O0(%2,%R0),%S1"
  [(set_attr "op_type" "SS")])

(define_split
  [(set (match_operand 0 "memory_operand" "")
        (xor (match_dup 0)
             (match_operand 1 "memory_operand" "")))
   (clobber (reg:CC CC_REGNUM))]
  "reload_completed
   && GET_MODE (operands[0]) == GET_MODE (operands[1])
   && GET_MODE_SIZE (GET_MODE (operands[0])) > 0"
  [(parallel
    [(set (match_dup 0) (xor:BLK (match_dup 0) (match_dup 1)))
     (use (match_dup 2))
     (clobber (reg:CC CC_REGNUM))])]
{
  operands[2] = GEN_INT (GET_MODE_SIZE (GET_MODE (operands[0])));
  operands[0] = adjust_address (operands[0], BLKmode, 0);
  operands[1] = adjust_address (operands[1], BLKmode, 0);
})

(define_peephole2
  [(parallel
    [(set (match_operand:BLK 0 "memory_operand" "")
          (xor:BLK (match_dup 0)
                   (match_operand:BLK 1 "memory_operand" "")))
     (use (match_operand 2 "const_int_operand" ""))
     (clobber (reg:CC CC_REGNUM))])
   (parallel
    [(set (match_operand:BLK 3 "memory_operand" "")
          (xor:BLK (match_dup 3)
                   (match_operand:BLK 4 "memory_operand" "")))
     (use (match_operand 5 "const_int_operand" ""))
     (clobber (reg:CC CC_REGNUM))])]
  "s390_offset_p (operands[0], operands[3], operands[2])
   && s390_offset_p (operands[1], operands[4], operands[2])
   && !s390_overlap_p (operands[0], operands[1], 
                       INTVAL (operands[2]) + INTVAL (operands[5]))
   && INTVAL (operands[2]) + INTVAL (operands[5]) <= 256"
  [(parallel
    [(set (match_dup 6) (xor:BLK (match_dup 6) (match_dup 7)))
     (use (match_dup 8))
     (clobber (reg:CC CC_REGNUM))])]
  "operands[6] = gen_rtx_MEM (BLKmode, XEXP (operands[0], 0));
   operands[7] = gen_rtx_MEM (BLKmode, XEXP (operands[1], 0));
   operands[8] = GEN_INT (INTVAL (operands[2]) + INTVAL (operands[5]));")

;
; Block xor (XC) patterns with src == dest.
;

(define_insn "*xc_zero"
  [(set (match_operand:BLK 0 "memory_operand" "=Q")
        (const_int 0))
   (use (match_operand 1 "const_int_operand" "n"))
   (clobber (reg:CC CC_REGNUM))]
  "INTVAL (operands[1]) >= 1 && INTVAL (operands[1]) <= 256"
  "xc\t%O0(%1,%R0),%S0"
  [(set_attr "op_type" "SS")])

(define_peephole2
  [(parallel
    [(set (match_operand:BLK 0 "memory_operand" "")
          (const_int 0))
     (use (match_operand 1 "const_int_operand" ""))
     (clobber (reg:CC CC_REGNUM))])
   (parallel
    [(set (match_operand:BLK 2 "memory_operand" "")
          (const_int 0))
     (use (match_operand 3 "const_int_operand" ""))
     (clobber (reg:CC CC_REGNUM))])]
  "s390_offset_p (operands[0], operands[2], operands[1])
   && INTVAL (operands[1]) + INTVAL (operands[3]) <= 256"
  [(parallel
    [(set (match_dup 4) (const_int 0))
     (use (match_dup 5))
     (clobber (reg:CC CC_REGNUM))])]
  "operands[4] = gen_rtx_MEM (BLKmode, XEXP (operands[0], 0));
   operands[5] = GEN_INT (INTVAL (operands[1]) + INTVAL (operands[3]));")


;;
;;- Negate instructions.
;;

;
; neg(di|si)2 instruction pattern(s).
;

(define_expand "neg<mode>2"
  [(parallel
    [(set (match_operand:DSI 0 "register_operand" "=d")
          (neg:DSI (match_operand:DSI 1 "register_operand" "d")))
     (clobber (reg:CC CC_REGNUM))])]
  ""
  "")

(define_insn "*negdi2_sign_cc"
  [(set (reg CC_REGNUM)
        (compare (neg:DI (ashiftrt:DI (ashift:DI (subreg:DI
                           (match_operand:SI 1 "register_operand" "d") 0)
                           (const_int 32)) (const_int 32)))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d")
        (neg:DI (sign_extend:DI (match_dup 1))))]
  "TARGET_64BIT && s390_match_ccmode (insn, CCAmode)"
  "lcgfr\t%0,%1"
  [(set_attr "op_type"  "RRE")])
  
(define_insn "*negdi2_sign"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (neg:DI (sign_extend:DI (match_operand:SI 1 "register_operand" "d"))))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT"
  "lcgfr\t%0,%1"
  [(set_attr "op_type"  "RRE")])

; lcr, lcgr
(define_insn "*neg<mode>2_cc"
  [(set (reg CC_REGNUM)
        (compare (neg:GPR (match_operand:GPR 1 "register_operand" "d"))
                 (const_int 0)))
   (set (match_operand:GPR 0 "register_operand" "=d")
        (neg:GPR (match_dup 1)))]
  "s390_match_ccmode (insn, CCAmode)"
  "lc<g>r\t%0,%1"
  [(set_attr "op_type"  "RR<E>")])

; lcr, lcgr
(define_insn "*neg<mode>2_cconly"
  [(set (reg CC_REGNUM)
        (compare (neg:GPR (match_operand:GPR 1 "register_operand" "d"))
                 (const_int 0)))
   (clobber (match_scratch:GPR 0 "=d"))]
  "s390_match_ccmode (insn, CCAmode)"
  "lc<g>r\t%0,%1"
  [(set_attr "op_type"  "RR<E>")])

; lcr, lcgr
(define_insn "*neg<mode>2"
  [(set (match_operand:GPR 0 "register_operand" "=d")
        (neg:GPR (match_operand:GPR 1 "register_operand" "d")))
   (clobber (reg:CC CC_REGNUM))]
  ""
  "lc<g>r\t%0,%1"
  [(set_attr "op_type"  "RR<E>")])

(define_insn_and_split "*negdi2_31"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (neg:DI (match_operand:DI 1 "register_operand" "d")))
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_64BIT"
  "#"
  "&& reload_completed"
  [(parallel
    [(set (match_dup 2) (neg:SI (match_dup 3)))
     (clobber (reg:CC CC_REGNUM))])
   (parallel
    [(set (reg:CCAP CC_REGNUM)
          (compare:CCAP (neg:SI (match_dup 5)) (const_int 0)))
     (set (match_dup 4) (neg:SI (match_dup 5)))])
   (set (pc)
        (if_then_else (ne (reg:CCAP CC_REGNUM) (const_int 0))
                      (pc)
                      (label_ref (match_dup 6))))
   (parallel
    [(set (match_dup 2) (plus:SI (match_dup 2) (const_int -1)))
     (clobber (reg:CC CC_REGNUM))])
   (match_dup 6)]
  "operands[2] = operand_subword (operands[0], 0, 0, DImode);
   operands[3] = operand_subword (operands[1], 0, 0, DImode);
   operands[4] = operand_subword (operands[0], 1, 0, DImode);
   operands[5] = operand_subword (operands[1], 1, 0, DImode);
   operands[6] = gen_label_rtx ();")

;
; neg(df|sf)2 instruction pattern(s).
;

(define_expand "neg<mode>2"
  [(parallel
    [(set (match_operand:FPR 0 "register_operand" "=f")
          (neg:FPR (match_operand:FPR 1 "register_operand" "f")))
     (clobber (reg:CC CC_REGNUM))])]
  "TARGET_HARD_FLOAT"
  "")

; lcxbr, lcdbr, lcebr
(define_insn "*neg<mode>2_cc"
  [(set (reg CC_REGNUM)
        (compare (neg:FPR (match_operand:FPR 1 "register_operand" "f"))
                 (match_operand:FPR 2 "const0_operand" "")))
   (set (match_operand:FPR 0 "register_operand" "=f")
        (neg:FPR (match_dup 1)))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "lc<xde>br\t%0,%1"
  [(set_attr "op_type"  "RRE")
   (set_attr "type"     "fsimp<mode>")])

; lcxbr, lcdbr, lcebr
(define_insn "*neg<mode>2_cconly"
  [(set (reg CC_REGNUM)
        (compare (neg:FPR (match_operand:FPR 1 "register_operand" "f"))
                 (match_operand:FPR 2 "const0_operand" "")))
   (clobber (match_scratch:FPR 0 "=f"))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "lc<xde>br\t%0,%1"
  [(set_attr "op_type"  "RRE")
   (set_attr "type"     "fsimp<mode>")])

; lcxbr, lcdbr, lcebr
(define_insn "*neg<mode>2"
  [(set (match_operand:FPR 0 "register_operand" "=f")
        (neg:FPR (match_operand:FPR 1 "register_operand" "f")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "lc<xde>br\t%0,%1"
  [(set_attr "op_type"  "RRE")
   (set_attr "type"     "fsimp<mode>")])

; lcxr, lcdr, lcer
(define_insn "*neg<mode>2_ibm"
  [(set (match_operand:FPR 0 "register_operand" "=f")
        (neg:FPR (match_operand:FPR 1 "register_operand" "f")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "lc<xde>r\t%0,%1"
  [(set_attr "op_type"  "<RRe>")
   (set_attr "type"     "fsimp<mode>")])


;;
;;- Absolute value instructions.
;;

;
; abs(di|si)2 instruction pattern(s).
;

(define_insn "*absdi2_sign_cc"
  [(set (reg CC_REGNUM)
        (compare (abs:DI (ashiftrt:DI (ashift:DI (subreg:DI
                           (match_operand:SI 1 "register_operand" "d") 0)
                           (const_int 32)) (const_int 32)))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d")
        (abs:DI (sign_extend:DI (match_dup 1))))]
  "TARGET_64BIT && s390_match_ccmode (insn, CCAmode)"
  "lpgfr\t%0,%1"
  [(set_attr "op_type"  "RRE")])

(define_insn "*absdi2_sign"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (abs:DI (sign_extend:DI (match_operand:SI 1 "register_operand" "d"))))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT"
  "lpgfr\t%0,%1"
  [(set_attr "op_type"  "RRE")])

; lpr, lpgr
(define_insn "*abs<mode>2_cc"
  [(set (reg CC_REGNUM)
        (compare (abs:GPR (match_operand:DI 1 "register_operand" "d"))
                 (const_int 0)))
   (set (match_operand:GPR 0 "register_operand" "=d")
        (abs:GPR (match_dup 1)))]
  "s390_match_ccmode (insn, CCAmode)"
  "lp<g>r\t%0,%1"
  [(set_attr "op_type"  "RR<E>")])

; lpr, lpgr  
(define_insn "*abs<mode>2_cconly"
  [(set (reg CC_REGNUM)
        (compare (abs:GPR (match_operand:GPR 1 "register_operand" "d"))
                 (const_int 0)))
   (clobber (match_scratch:GPR 0 "=d"))]
  "s390_match_ccmode (insn, CCAmode)"
  "lp<g>r\t%0,%1"
  [(set_attr "op_type"  "RR<E>")])

; lpr, lpgr
(define_insn "abs<mode>2"
  [(set (match_operand:GPR 0 "register_operand" "=d")
        (abs:GPR (match_operand:GPR 1 "register_operand" "d")))
   (clobber (reg:CC CC_REGNUM))]
  ""
  "lp<g>r\t%0,%1"
  [(set_attr "op_type"  "RR<E>")])

;
; abs(df|sf)2 instruction pattern(s).
;

(define_expand "abs<mode>2"
  [(parallel
    [(set (match_operand:FPR 0 "register_operand" "=f")
          (abs:FPR (match_operand:FPR 1 "register_operand" "f")))
     (clobber (reg:CC CC_REGNUM))])]
  "TARGET_HARD_FLOAT"
  "")

; lpxbr, lpdbr, lpebr
(define_insn "*abs<mode>2_cc"
  [(set (reg CC_REGNUM)
        (compare (abs:FPR (match_operand:FPR 1 "register_operand" "f"))
                 (match_operand:FPR 2 "const0_operand" "")))
   (set (match_operand:FPR 0 "register_operand" "=f")
        (abs:FPR (match_dup 1)))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "lp<xde>br\t%0,%1"
  [(set_attr "op_type"  "RRE")
   (set_attr "type"     "fsimp<mode>")])

; lpxbr, lpdbr, lpebr
(define_insn "*abs<mode>2_cconly"
  [(set (reg CC_REGNUM)
        (compare (abs:FPR (match_operand:FPR 1 "register_operand" "f"))
                 (match_operand:FPR 2 "const0_operand" "")))
   (clobber (match_scratch:FPR 0 "=f"))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "lp<xde>br\t%0,%1"
  [(set_attr "op_type"  "RRE")
   (set_attr "type"     "fsimp<mode>")])

; lpxbr, lpdbr, lpebr
(define_insn "*abs<mode>2"
  [(set (match_operand:FPR 0 "register_operand" "=f")
        (abs:FPR (match_operand:FPR 1 "register_operand" "f")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "lp<xde>br\t%0,%1"
  [(set_attr "op_type"  "RRE")
   (set_attr "type"     "fsimp<mode>")])

; lpxr, lpdr, lper
(define_insn "*abs<mode>2_ibm"
  [(set (match_operand:FPR 0 "register_operand" "=f")
        (abs:FPR (match_operand:FPR 1 "register_operand" "f")))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_HARD_FLOAT && TARGET_IBM_FLOAT"
  "lp<xde>r\t%0,%1"
  [(set_attr "op_type"  "<RRe>")
   (set_attr "type"     "fsimp<mode>")])

;;
;;- Negated absolute value instructions
;;

;
; Integer
;

(define_insn "*negabsdi2_sign_cc"
  [(set (reg CC_REGNUM)
        (compare (neg:DI (abs:DI (ashiftrt:DI (ashift:DI (subreg:DI
                           (match_operand:SI 1 "register_operand" "d") 0)
                           (const_int 32)) (const_int 32))))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d")
        (neg:DI (abs:DI (sign_extend:DI (match_dup 1)))))]
  "TARGET_64BIT && s390_match_ccmode (insn, CCAmode)"
  "lngfr\t%0,%1"
  [(set_attr "op_type"  "RRE")])
 
(define_insn "*negabsdi2_sign"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (neg:DI (abs:DI (sign_extend:DI
                          (match_operand:SI 1 "register_operand" "d")))))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT"
  "lngfr\t%0,%1"
  [(set_attr "op_type" "RRE")])

; lnr, lngr
(define_insn "*negabs<mode>2_cc"
  [(set (reg CC_REGNUM)
        (compare (neg:GPR (abs:GPR (match_operand:GPR 1 "register_operand" "d")))
                 (const_int 0)))
   (set (match_operand:GPR 0 "register_operand" "=d")
        (neg:GPR (abs:GPR (match_dup 1))))]
  "s390_match_ccmode (insn, CCAmode)"
  "ln<g>r\t%0,%1"
  [(set_attr "op_type"  "RR<E>")])

; lnr, lngr
(define_insn "*negabs<mode>2_cconly"
  [(set (reg CC_REGNUM)
        (compare (neg:GPR (abs:GPR (match_operand:GPR 1 "register_operand" "d")))
                 (const_int 0)))
   (clobber (match_scratch:GPR 0 "=d"))]
  "s390_match_ccmode (insn, CCAmode)"
  "ln<g>r\t%0,%1"
  [(set_attr "op_type"  "RR<E>")])

; lnr, lngr
(define_insn "*negabs<mode>2"
  [(set (match_operand:GPR 0 "register_operand" "=d")
        (neg:GPR (abs:GPR (match_operand:GPR 1 "register_operand" "d"))))
   (clobber (reg:CC CC_REGNUM))]
  ""
  "ln<g>r\t%0,%1"
  [(set_attr "op_type" "RR<E>")])

;
; Floating point
;

; lnxbr, lndbr, lnebr
(define_insn "*negabs<mode>2_cc"
  [(set (reg CC_REGNUM)
        (compare (neg:FPR (abs:FPR (match_operand:FPR 1 "register_operand" "f")))
                 (match_operand:FPR 2 "const0_operand" "")))
   (set (match_operand:FPR 0 "register_operand" "=f")
        (neg:FPR (abs:FPR (match_dup 1))))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "ln<xde>br\t%0,%1"
  [(set_attr "op_type"  "RRE")
   (set_attr "type"     "fsimp<mode>")])

; lnxbr, lndbr, lnebr
(define_insn "*negabs<mode>2_cconly"
  [(set (reg CC_REGNUM)
        (compare (neg:FPR (abs:FPR (match_operand:FPR 1 "register_operand" "f")))
                 (match_operand:FPR 2 "const0_operand" "")))
   (clobber (match_scratch:FPR 0 "=f"))]
  "s390_match_ccmode (insn, CCSmode) && TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "ln<xde>br\t%0,%1"
  [(set_attr "op_type"  "RRE")
   (set_attr "type"     "fsimp<mode>")])

; lnxbr, lndbr, lnebr
(define_insn "*negabs<mode>2"
  [(set (match_operand:FPR 0 "register_operand" "=f")
        (neg:FPR (abs:FPR (match_operand:FPR 1 "register_operand" "f"))))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "ln<xde>br\t%0,%1"
  [(set_attr "op_type"  "RRE")
   (set_attr "type"     "fsimp<mode>")])

;;
;;- Square root instructions.
;;

;
; sqrt(df|sf)2 instruction pattern(s).
;

; sqxbr, sqdbr, sqebr, sqxb, sqdb, sqeb
(define_insn "sqrt<mode>2"
  [(set (match_operand:FPR 0 "register_operand" "=f,f")
        (sqrt:FPR (match_operand:FPR 1 "general_operand" "f,<Rf>")))]
  "TARGET_HARD_FLOAT && TARGET_IEEE_FLOAT"
  "@
   sq<xde>br\t%0,%1
   sq<xde>b\t%0,%1"
  [(set_attr "op_type" "RRE,RXE")
   (set_attr "type" "fsqrt<mode>")])


;;
;;- One complement instructions.
;;

;
; one_cmpl(di|si|hi|qi)2 instruction pattern(s).
;

(define_expand "one_cmpl<mode>2"
  [(parallel
    [(set (match_operand:INT 0 "register_operand" "")
          (xor:INT (match_operand:INT 1 "register_operand" "")
                   (const_int -1)))
     (clobber (reg:CC CC_REGNUM))])]
  ""
  "")


;;
;; Find leftmost bit instructions.
;;

(define_expand "clzdi2"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (clz:DI (match_operand:DI 1 "register_operand" "d")))]
  "TARGET_EXTIMM && TARGET_64BIT"
{
  rtx insn, clz_equal;
  rtx wide_reg = gen_reg_rtx (TImode);
  rtx msb = gen_rtx_CONST_INT (DImode, (unsigned HOST_WIDE_INT) 1 << 63);

  clz_equal = gen_rtx_CLZ (DImode, operands[1]);

  emit_insn (gen_clztidi2 (wide_reg, operands[1], msb));

  insn = emit_move_insn (operands[0], gen_highpart (DImode, wide_reg));  
  REG_NOTES (insn) =
        gen_rtx_EXPR_LIST (REG_EQUAL, clz_equal, REG_NOTES (insn));

  DONE;
})

(define_insn "clztidi2"
  [(set (match_operand:TI 0 "register_operand" "=d")
        (ior:TI
          (ashift:TI 
            (zero_extend:TI 
                 (xor:DI (match_operand:DI 1 "register_operand" "d")
                      (lshiftrt (match_operand:DI 2 "const_int_operand" "")
                                (subreg:SI (clz:DI (match_dup 1)) 4))))
            
            (const_int 64))
          (zero_extend:TI (clz:DI (match_dup 1)))))
   (clobber (reg:CC CC_REGNUM))]
  "(unsigned HOST_WIDE_INT) INTVAL (operands[2]) 
   == (unsigned HOST_WIDE_INT) 1 << 63
   && TARGET_EXTIMM && TARGET_64BIT"
  "flogr\t%0,%1"
  [(set_attr "op_type"  "RRE")])


;;
;;- Rotate instructions.
;;

;
; rotl(di|si)3 instruction pattern(s).
;

; rll, rllg
(define_insn "rotl<mode>3"
  [(set (match_operand:GPR 0 "register_operand" "=d")
        (rotate:GPR (match_operand:GPR 1 "register_operand" "d")
                    (match_operand:SI 2 "shift_count_or_setmem_operand" "Y")))]
  "TARGET_CPU_ZARCH"
  "rll<g>\t%0,%1,%Y2"
  [(set_attr "op_type"  "RSE")
   (set_attr "atype"    "reg")])

; rll, rllg
(define_insn "*rotl<mode>3_and"
  [(set (match_operand:GPR 0 "register_operand" "=d")
        (rotate:GPR (match_operand:GPR 1 "register_operand" "d")
                    (and:SI (match_operand:SI 2 "shift_count_or_setmem_operand" "Y")
                            (match_operand:SI 3 "const_int_operand"   "n"))))]
  "TARGET_CPU_ZARCH && (INTVAL (operands[3]) & 63) == 63"
  "rll<g>\t%0,%1,%Y2"
  [(set_attr "op_type"  "RSE")
   (set_attr "atype"    "reg")])


;;
;;- Shift instructions.
;;

;
; (ashl|lshr)(di|si)3 instruction pattern(s).
;

(define_expand "<shift><mode>3"
  [(set (match_operand:DSI 0 "register_operand" "")
        (SHIFT:DSI (match_operand:DSI 1 "register_operand" "")
                   (match_operand:SI 2 "shift_count_or_setmem_operand" "")))]
  ""
  "")

; sldl, srdl
(define_insn "*<shift>di3_31"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (SHIFT:DI (match_operand:DI 1 "register_operand" "0")
                  (match_operand:SI 2 "shift_count_or_setmem_operand" "Y")))]
  "!TARGET_64BIT"
  "s<lr>dl\t%0,%Y2"
  [(set_attr "op_type"  "RS")
   (set_attr "atype"    "reg")])

; sll, srl, sllg, srlg
(define_insn "*<shift><mode>3"
  [(set (match_operand:GPR 0 "register_operand" "=d")
        (SHIFT:GPR (match_operand:GPR 1 "register_operand" "<d0>")
                   (match_operand:SI 2 "shift_count_or_setmem_operand" "Y")))]
  ""
  "s<lr>l<g>\t%0,<1>%Y2"
  [(set_attr "op_type"  "RS<E>")
   (set_attr "atype"    "reg")])

; sldl, srdl
(define_insn "*<shift>di3_31_and"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (SHIFT:DI (match_operand:DI 1 "register_operand" "0")
                  (and:SI (match_operand:SI 2 "shift_count_or_setmem_operand" "Y")
                          (match_operand:SI 3 "const_int_operand"   "n"))))]
  "!TARGET_64BIT && (INTVAL (operands[3]) & 63) == 63"
  "s<lr>dl\t%0,%Y2"
  [(set_attr "op_type"  "RS")
   (set_attr "atype"    "reg")])

; sll, srl, sllg, srlg
(define_insn "*<shift><mode>3_and"
  [(set (match_operand:GPR 0 "register_operand" "=d")
        (SHIFT:GPR (match_operand:GPR 1 "register_operand" "<d0>")
                   (and:SI (match_operand:SI 2 "shift_count_or_setmem_operand" "Y")
                           (match_operand:SI 3 "const_int_operand"   "n"))))]
  "(INTVAL (operands[3]) & 63) == 63"
  "s<lr>l<g>\t%0,<1>%Y2"
  [(set_attr "op_type"  "RS<E>")
   (set_attr "atype"    "reg")])

;
; ashr(di|si)3 instruction pattern(s).
;

(define_expand "ashr<mode>3"
  [(parallel
    [(set (match_operand:DSI 0 "register_operand" "")
          (ashiftrt:DSI (match_operand:DSI 1 "register_operand" "")
                        (match_operand:SI 2 "shift_count_or_setmem_operand" "")))
     (clobber (reg:CC CC_REGNUM))])]
  ""
  "")

(define_insn "*ashrdi3_cc_31"
  [(set (reg CC_REGNUM)
        (compare (ashiftrt:DI (match_operand:DI 1 "register_operand" "0")
                              (match_operand:SI 2 "shift_count_or_setmem_operand" "Y"))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d")
        (ashiftrt:DI (match_dup 1) (match_dup 2)))]
  "!TARGET_64BIT && s390_match_ccmode(insn, CCSmode)"
  "srda\t%0,%Y2"
  [(set_attr "op_type"  "RS")
   (set_attr "atype"    "reg")])

(define_insn "*ashrdi3_cconly_31"
  [(set (reg CC_REGNUM)
        (compare (ashiftrt:DI (match_operand:DI 1 "register_operand" "0")
                              (match_operand:SI 2 "shift_count_or_setmem_operand" "Y"))
                 (const_int 0)))
   (clobber (match_scratch:DI 0 "=d"))]
  "!TARGET_64BIT && s390_match_ccmode(insn, CCSmode)"
  "srda\t%0,%Y2"
  [(set_attr "op_type"  "RS")
   (set_attr "atype"    "reg")])

(define_insn "*ashrdi3_31"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (ashiftrt:DI (match_operand:DI 1 "register_operand" "0")
                     (match_operand:SI 2 "shift_count_or_setmem_operand" "Y")))
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_64BIT"
  "srda\t%0,%Y2"
  [(set_attr "op_type"  "RS")
   (set_attr "atype"    "reg")])

; sra, srag
(define_insn "*ashr<mode>3_cc"
  [(set (reg CC_REGNUM)
        (compare (ashiftrt:GPR (match_operand:GPR 1 "register_operand" "<d0>")
                               (match_operand:SI 2 "shift_count_or_setmem_operand" "Y"))
                 (const_int 0)))
   (set (match_operand:GPR 0 "register_operand" "=d")
        (ashiftrt:GPR (match_dup 1) (match_dup 2)))]
  "s390_match_ccmode(insn, CCSmode)"
  "sra<g>\t%0,<1>%Y2"
  [(set_attr "op_type"  "RS<E>")
   (set_attr "atype"    "reg")])

; sra, srag
(define_insn "*ashr<mode>3_cconly"
  [(set (reg CC_REGNUM)
        (compare (ashiftrt:GPR (match_operand:GPR 1 "register_operand" "<d0>")
                               (match_operand:SI 2 "shift_count_or_setmem_operand" "Y"))
                 (const_int 0)))
   (clobber (match_scratch:GPR 0 "=d"))]
  "s390_match_ccmode(insn, CCSmode)"
  "sra<g>\t%0,<1>%Y2"
  [(set_attr "op_type"  "RS<E>")
   (set_attr "atype"    "reg")])

; sra, srag
(define_insn "*ashr<mode>3"
  [(set (match_operand:GPR 0 "register_operand" "=d")
        (ashiftrt:GPR (match_operand:GPR 1 "register_operand" "<d0>")
                      (match_operand:SI 2 "shift_count_or_setmem_operand" "Y")))
   (clobber (reg:CC CC_REGNUM))]
  ""
  "sra<g>\t%0,<1>%Y2"
  [(set_attr "op_type"  "RS<E>")
   (set_attr "atype"    "reg")])


; shift pattern with implicit ANDs

(define_insn "*ashrdi3_cc_31_and"
  [(set (reg CC_REGNUM)
        (compare (ashiftrt:DI (match_operand:DI 1 "register_operand" "0")
                              (and:SI (match_operand:SI 2 "shift_count_or_setmem_operand" "Y")
                                      (match_operand:SI 3 "const_int_operand"   "n")))
                 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=d")
        (ashiftrt:DI (match_dup 1) (and:SI (match_dup 2) (match_dup 3))))]
  "!TARGET_64BIT && s390_match_ccmode(insn, CCSmode)
   && (INTVAL (operands[3]) & 63) == 63"
  "srda\t%0,%Y2"
  [(set_attr "op_type"  "RS")
   (set_attr "atype"    "reg")])

(define_insn "*ashrdi3_cconly_31_and"
  [(set (reg CC_REGNUM)
        (compare (ashiftrt:DI (match_operand:DI 1 "register_operand" "0")
                              (and:SI (match_operand:SI 2 "shift_count_or_setmem_operand" "Y")
                                      (match_operand:SI 3 "const_int_operand"   "n")))
                 (const_int 0)))
   (clobber (match_scratch:DI 0 "=d"))]
  "!TARGET_64BIT && s390_match_ccmode(insn, CCSmode)
   && (INTVAL (operands[3]) & 63) == 63"
  "srda\t%0,%Y2"
  [(set_attr "op_type"  "RS")
   (set_attr "atype"    "reg")])

(define_insn "*ashrdi3_31_and"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (ashiftrt:DI (match_operand:DI 1 "register_operand" "0")
                     (and:SI (match_operand:SI 2 "shift_count_or_setmem_operand" "Y")
                             (match_operand:SI 3 "const_int_operand"   "n"))))
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_64BIT && (INTVAL (operands[3]) & 63) == 63"
  "srda\t%0,%Y2"
  [(set_attr "op_type"  "RS")
   (set_attr "atype"    "reg")])

; sra, srag
(define_insn "*ashr<mode>3_cc_and"
  [(set (reg CC_REGNUM)
        (compare (ashiftrt:GPR (match_operand:GPR 1 "register_operand" "<d0>")
                               (and:SI (match_operand:SI 2 "shift_count_or_setmem_operand" "Y")
                                       (match_operand:SI 3 "const_int_operand"   "n")))
                 (const_int 0)))
   (set (match_operand:GPR 0 "register_operand" "=d")
        (ashiftrt:GPR (match_dup 1) (and:SI (match_dup 2) (match_dup 3))))]
  "s390_match_ccmode(insn, CCSmode) && (INTVAL (operands[3]) & 63) == 63"
  "sra<g>\t%0,<1>%Y2"
  [(set_attr "op_type"  "RS<E>")
   (set_attr "atype"    "reg")])

; sra, srag
(define_insn "*ashr<mode>3_cconly_and"
  [(set (reg CC_REGNUM)
        (compare (ashiftrt:GPR (match_operand:GPR 1 "register_operand" "<d0>")
                               (and:SI (match_operand:SI 2 "shift_count_or_setmem_operand" "Y")
                                       (match_operand:SI 3 "const_int_operand"   "n")))
                 (const_int 0)))
   (clobber (match_scratch:GPR 0 "=d"))]
  "s390_match_ccmode(insn, CCSmode) && (INTVAL (operands[3]) & 63) == 63"
  "sra<g>\t%0,<1>%Y2"
  [(set_attr "op_type"  "RS<E>")
   (set_attr "atype"    "reg")])

; sra, srag
(define_insn "*ashr<mode>3_and"
  [(set (match_operand:GPR 0 "register_operand" "=d")
        (ashiftrt:GPR (match_operand:GPR 1 "register_operand" "<d0>")
                      (and:SI (match_operand:SI 2 "shift_count_or_setmem_operand" "Y")
                              (match_operand:SI 3 "const_int_operand"   "n"))))
   (clobber (reg:CC CC_REGNUM))]
  "(INTVAL (operands[3]) & 63) == 63"
  "sra<g>\t%0,<1>%Y2"
  [(set_attr "op_type"  "RS<E>")
   (set_attr "atype"    "reg")])


;;
;; Branch instruction patterns.
;;

(define_expand "b<code>"
  [(set (pc)
        (if_then_else (COMPARE (match_operand 0 "" "")
                               (const_int 0))
                      (match_dup 0)
                      (pc)))]
  ""
  "s390_emit_jump (operands[0],
    s390_emit_compare (<CODE>, s390_compare_op0, s390_compare_op1)); DONE;")


;;
;;- Conditional jump instructions.
;;

(define_insn "*cjump_64"
  [(set (pc)
        (if_then_else
          (match_operator 1 "s390_comparison" [(reg CC_REGNUM) (const_int 0)])
          (label_ref (match_operand 0 "" ""))
          (pc)))]
  "TARGET_CPU_ZARCH"
{
  if (get_attr_length (insn) == 4)
    return "j%C1\t%l0";
  else
    return "jg%C1\t%l0";
}
  [(set_attr "op_type" "RI")
   (set_attr "type"    "branch")
   (set (attr "length")
        (if_then_else (lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                      (const_int 4) (const_int 6)))])

(define_insn "*cjump_31"
  [(set (pc)
        (if_then_else
          (match_operator 1 "s390_comparison" [(reg CC_REGNUM) (const_int 0)])
          (label_ref (match_operand 0 "" ""))
          (pc)))]
  "!TARGET_CPU_ZARCH"
{
  gcc_assert (get_attr_length (insn) == 4);
  return "j%C1\t%l0";
}
  [(set_attr "op_type" "RI")
   (set_attr "type"    "branch")
   (set (attr "length")
        (if_then_else (eq (symbol_ref "flag_pic") (const_int 0))
          (if_then_else (lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                        (const_int 4) (const_int 6))
          (if_then_else (lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                        (const_int 4) (const_int 8))))])

(define_insn "*cjump_long"
  [(set (pc)
        (if_then_else
          (match_operator 1 "s390_comparison" [(reg CC_REGNUM) (const_int 0)])
          (match_operand 0 "address_operand" "U")
          (pc)))]
  ""
{
  if (get_attr_op_type (insn) == OP_TYPE_RR)
    return "b%C1r\t%0";
  else
    return "b%C1\t%a0";
}
  [(set (attr "op_type")
        (if_then_else (match_operand 0 "register_operand" "")
                      (const_string "RR") (const_string "RX")))
   (set_attr "type"  "branch")
   (set_attr "atype" "agen")])


;;
;;- Negated conditional jump instructions.
;;

(define_insn "*icjump_64"
  [(set (pc)
        (if_then_else
          (match_operator 1 "s390_comparison" [(reg CC_REGNUM) (const_int 0)])
          (pc)
          (label_ref (match_operand 0 "" ""))))]
  "TARGET_CPU_ZARCH"
{
  if (get_attr_length (insn) == 4)
    return "j%D1\t%l0";
  else
    return "jg%D1\t%l0";
}
  [(set_attr "op_type" "RI")
   (set_attr "type"    "branch")
   (set (attr "length")
        (if_then_else (lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                      (const_int 4) (const_int 6)))])

(define_insn "*icjump_31"
  [(set (pc)
        (if_then_else
          (match_operator 1 "s390_comparison" [(reg CC_REGNUM) (const_int 0)])
          (pc)
          (label_ref (match_operand 0 "" ""))))]
  "!TARGET_CPU_ZARCH"
{
  gcc_assert (get_attr_length (insn) == 4);
  return "j%D1\t%l0";
}
  [(set_attr "op_type" "RI")
   (set_attr "type"    "branch")
   (set (attr "length")
        (if_then_else (eq (symbol_ref "flag_pic") (const_int 0))
          (if_then_else (lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                        (const_int 4) (const_int 6))
          (if_then_else (lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                        (const_int 4) (const_int 8))))])

(define_insn "*icjump_long"
  [(set (pc)
        (if_then_else
          (match_operator 1 "s390_comparison" [(reg CC_REGNUM) (const_int 0)])
          (pc)
          (match_operand 0 "address_operand" "U")))]
  ""
{
  if (get_attr_op_type (insn) == OP_TYPE_RR)
    return "b%D1r\t%0";
  else
    return "b%D1\t%a0";
}
  [(set (attr "op_type")
        (if_then_else (match_operand 0 "register_operand" "")
                      (const_string "RR") (const_string "RX")))
   (set_attr "type"  "branch")
   (set_attr "atype" "agen")])

;;
;;- Trap instructions.
;;

(define_insn "trap"
  [(trap_if (const_int 1) (const_int 0))]
  ""
  "j\t.+2"
  [(set_attr "op_type" "RI")
   (set_attr "type"  "branch")])

(define_expand "conditional_trap"
  [(trap_if (match_operand 0 "comparison_operator" "")
            (match_operand 1 "general_operand" ""))]
  ""
{
  if (operands[1] != const0_rtx) FAIL;
  operands[0] = s390_emit_compare (GET_CODE (operands[0]), 
                                   s390_compare_op0, s390_compare_op1);
})

(define_insn "*trap"
  [(trap_if (match_operator 0 "s390_comparison" [(reg CC_REGNUM) (const_int 0)])
            (const_int 0))]
  ""
  "j%C0\t.+2";
  [(set_attr "op_type" "RI")
   (set_attr "type"  "branch")])

;;
;;- Loop instructions.
;;
;;  This is all complicated by the fact that since this is a jump insn
;;  we must handle our own output reloads.

(define_expand "doloop_end"
  [(use (match_operand 0 "" ""))        ; loop pseudo
   (use (match_operand 1 "" ""))        ; iterations; zero if unknown
   (use (match_operand 2 "" ""))        ; max iterations
   (use (match_operand 3 "" ""))        ; loop level
   (use (match_operand 4 "" ""))]       ; label
  ""
{
  if (GET_MODE (operands[0]) == SImode && !TARGET_CPU_ZARCH)
    emit_jump_insn (gen_doloop_si31 (operands[4], operands[0], operands[0]));
  else if (GET_MODE (operands[0]) == SImode && TARGET_CPU_ZARCH)
    emit_jump_insn (gen_doloop_si64 (operands[4], operands[0], operands[0]));
  else if (GET_MODE (operands[0]) == DImode && TARGET_64BIT)
    emit_jump_insn (gen_doloop_di (operands[4], operands[0], operands[0]));
  else
    FAIL;

  DONE;
})

(define_insn_and_split "doloop_si64"
  [(set (pc)
        (if_then_else
          (ne (match_operand:SI 1 "register_operand" "d,d,d")
              (const_int 1))
          (label_ref (match_operand 0 "" ""))
          (pc)))
   (set (match_operand:SI 2 "nonimmediate_operand" "=1,?X,?X")
        (plus:SI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:SI 3 "=X,&1,&?d"))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_CPU_ZARCH"
{
  if (which_alternative != 0)
    return "#";
  else if (get_attr_length (insn) == 4)
    return "brct\t%1,%l0";
  else
    return "ahi\t%1,-1\;jgne\t%l0";
}
  "&& reload_completed
   && (! REG_P (operands[2])
       || ! rtx_equal_p (operands[1], operands[2]))"
  [(set (match_dup 3) (match_dup 1))
   (parallel [(set (reg:CCAN CC_REGNUM)
                   (compare:CCAN (plus:SI (match_dup 3) (const_int -1))
                                 (const_int 0)))
              (set (match_dup 3) (plus:SI (match_dup 3) (const_int -1)))])
   (set (match_dup 2) (match_dup 3))
   (set (pc) (if_then_else (ne (reg:CCAN CC_REGNUM) (const_int 0))
                           (label_ref (match_dup 0))
                           (pc)))]
  ""
  [(set_attr "op_type"  "RI")
   (set_attr "type"  "branch")
   (set (attr "length")
        (if_then_else (lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                      (const_int 4) (const_int 10)))])

(define_insn_and_split "doloop_si31"
  [(set (pc)
        (if_then_else
          (ne (match_operand:SI 1 "register_operand" "d,d,d")
              (const_int 1))
          (label_ref (match_operand 0 "" ""))
          (pc)))
   (set (match_operand:SI 2 "nonimmediate_operand" "=1,?X,?X")
        (plus:SI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:SI 3 "=X,&1,&?d"))
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_CPU_ZARCH"
{
  if (which_alternative != 0)
    return "#";
  else if (get_attr_length (insn) == 4)
    return "brct\t%1,%l0";
  else
    gcc_unreachable ();
}
  "&& reload_completed
   && (! REG_P (operands[2])
       || ! rtx_equal_p (operands[1], operands[2]))"
  [(set (match_dup 3) (match_dup 1))
   (parallel [(set (reg:CCAN CC_REGNUM)
                   (compare:CCAN (plus:SI (match_dup 3) (const_int -1))
                                 (const_int 0)))
              (set (match_dup 3) (plus:SI (match_dup 3) (const_int -1)))])
   (set (match_dup 2) (match_dup 3))
   (set (pc) (if_then_else (ne (reg:CCAN CC_REGNUM) (const_int 0))
                           (label_ref (match_dup 0))
                           (pc)))]
  ""
  [(set_attr "op_type"  "RI")
   (set_attr "type"  "branch")
   (set (attr "length")
        (if_then_else (eq (symbol_ref "flag_pic") (const_int 0))
          (if_then_else (lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                        (const_int 4) (const_int 6))
          (if_then_else (lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                        (const_int 4) (const_int 8))))])

(define_insn "*doloop_si_long"
  [(set (pc)
        (if_then_else
          (ne (match_operand:SI 1 "register_operand" "d")
              (const_int 1))
          (match_operand 0 "address_operand" "U")
          (pc)))
   (set (match_operand:SI 2 "register_operand" "=1")
        (plus:SI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:SI 3 "=X"))
   (clobber (reg:CC CC_REGNUM))]
  "!TARGET_CPU_ZARCH"
{
  if (get_attr_op_type (insn) == OP_TYPE_RR)
    return "bctr\t%1,%0";
  else
    return "bct\t%1,%a0";
}
  [(set (attr "op_type")
        (if_then_else (match_operand 0 "register_operand" "")
                      (const_string "RR") (const_string "RX")))
   (set_attr "type"  "branch")
   (set_attr "atype" "agen")])

(define_insn_and_split "doloop_di"
  [(set (pc)
        (if_then_else
          (ne (match_operand:DI 1 "register_operand" "d,d,d")
              (const_int 1))
          (label_ref (match_operand 0 "" ""))
          (pc)))
   (set (match_operand:DI 2 "nonimmediate_operand" "=1,?X,?X")
        (plus:DI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:DI 3 "=X,&1,&?d"))
   (clobber (reg:CC CC_REGNUM))]
  "TARGET_64BIT"
{
  if (which_alternative != 0)
    return "#";
  else if (get_attr_length (insn) == 4)
    return "brctg\t%1,%l0";
  else
    return "aghi\t%1,-1\;jgne\t%l0";
}
  "&& reload_completed
   && (! REG_P (operands[2])
       || ! rtx_equal_p (operands[1], operands[2]))"
  [(set (match_dup 3) (match_dup 1))
   (parallel [(set (reg:CCAN CC_REGNUM)
                   (compare:CCAN (plus:DI (match_dup 3) (const_int -1))
                                 (const_int 0)))
              (set (match_dup 3) (plus:DI (match_dup 3) (const_int -1)))])
   (set (match_dup 2) (match_dup 3))
   (set (pc) (if_then_else (ne (reg:CCAN CC_REGNUM) (const_int 0))
                           (label_ref (match_dup 0))
                           (pc)))]
  ""
  [(set_attr "op_type"  "RI")
   (set_attr "type"  "branch")
   (set (attr "length")
        (if_then_else (lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                      (const_int 4) (const_int 10)))])

;;
;;- Unconditional jump instructions.
;;

;
; jump instruction pattern(s).
;

(define_expand "jump"
  [(match_operand 0 "" "")]
  ""
  "s390_emit_jump (operands[0], NULL_RTX); DONE;")

(define_insn "*jump64"
  [(set (pc) (label_ref (match_operand 0 "" "")))]
  "TARGET_CPU_ZARCH"
{
  if (get_attr_length (insn) == 4)
    return "j\t%l0";
  else
    return "jg\t%l0";
}
  [(set_attr "op_type" "RI")
   (set_attr "type"  "branch")
   (set (attr "length")
        (if_then_else (lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                      (const_int 4) (const_int 6)))])

(define_insn "*jump31"
  [(set (pc) (label_ref (match_operand 0 "" "")))]
  "!TARGET_CPU_ZARCH"
{
  gcc_assert (get_attr_length (insn) == 4);
  return "j\t%l0";
}
  [(set_attr "op_type" "RI")
   (set_attr "type"  "branch")
   (set (attr "length")
        (if_then_else (eq (symbol_ref "flag_pic") (const_int 0))
          (if_then_else (lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                        (const_int 4) (const_int 6))
          (if_then_else (lt (abs (minus (pc) (match_dup 0))) (const_int 60000))
                        (const_int 4) (const_int 8))))])

;
; indirect-jump instruction pattern(s).
;

(define_insn "indirect_jump"
 [(set (pc) (match_operand 0 "address_operand" "U"))]
  ""
{
  if (get_attr_op_type (insn) == OP_TYPE_RR)
    return "br\t%0";
  else
    return "b\t%a0";
}
  [(set (attr "op_type")
        (if_then_else (match_operand 0 "register_operand" "")
                      (const_string "RR") (const_string "RX")))
   (set_attr "type"  "branch")
   (set_attr "atype" "agen")])

;
; casesi instruction pattern(s).
;

(define_insn "casesi_jump"
 [(set (pc) (match_operand 0 "address_operand" "U"))
   (use (label_ref (match_operand 1 "" "")))]
  ""
{
  if (get_attr_op_type (insn) == OP_TYPE_RR)
    return "br\t%0";
  else
    return "b\t%a0";
}
  [(set (attr "op_type")
        (if_then_else (match_operand 0 "register_operand" "")
                      (const_string "RR") (const_string "RX")))
   (set_attr "type"  "branch")
   (set_attr "atype" "agen")])

(define_expand "casesi"
  [(match_operand:SI 0 "general_operand" "")
   (match_operand:SI 1 "general_operand" "")
   (match_operand:SI 2 "general_operand" "")
   (label_ref (match_operand 3 "" ""))
   (label_ref (match_operand 4 "" ""))]
  ""
{
   rtx index  = gen_reg_rtx (SImode);
   rtx base   = gen_reg_rtx (Pmode);
   rtx target = gen_reg_rtx (Pmode);

   emit_move_insn (index, operands[0]);
   emit_insn (gen_subsi3 (index, index, operands[1]));
   emit_cmp_and_jump_insns (index, operands[2], GTU, NULL_RTX, SImode, 1,
                            operands[4]);

   if (Pmode != SImode)
     index = convert_to_mode (Pmode, index, 1);
   if (GET_CODE (index) != REG)
     index = copy_to_mode_reg (Pmode, index);

   if (TARGET_64BIT)
       emit_insn (gen_ashldi3 (index, index, GEN_INT (3)));
   else
       emit_insn (gen_ashlsi3 (index, index, const2_rtx));

   emit_move_insn (base, gen_rtx_LABEL_REF (Pmode, operands[3]));

   index = gen_const_mem (Pmode, gen_rtx_PLUS (Pmode, base, index));
   emit_move_insn (target, index);

   if (flag_pic)
     target = gen_rtx_PLUS (Pmode, base, target);
   emit_jump_insn (gen_casesi_jump (target, operands[3]));

   DONE;
})


;;
;;- Jump to subroutine.
;;
;;

;
; untyped call instruction pattern(s).
;

;; Call subroutine returning any type.
(define_expand "untyped_call"
  [(parallel [(call (match_operand 0 "" "")
                    (const_int 0))
              (match_operand 1 "" "")
              (match_operand 2 "" "")])]
  ""
{
  int i;

  emit_call_insn (gen_call (operands[0], const0_rtx, const0_rtx));

  for (i = 0; i < XVECLEN (operands[2], 0); i++)
    {
      rtx set = XVECEXP (operands[2], 0, i);
      emit_move_insn (SET_DEST (set), SET_SRC (set));
    }

  /* The optimizer does not know that the call sets the function value
     registers we stored in the result block.  We avoid problems by
     claiming that all hard registers are used and clobbered at this
     point.  */
  emit_insn (gen_blockage ());

  DONE;
})

;; UNSPEC_VOLATILE is considered to use and clobber all hard registers and
;; all of memory.  This blocks insns from being moved across this point.

(define_insn "blockage"
  [(unspec_volatile [(const_int 0)] UNSPECV_BLOCKAGE)]
  ""
  ""
  [(set_attr "type"    "none")
   (set_attr "length"  "0")])

;
; sibcall patterns
;

(define_expand "sibcall"
  [(call (match_operand 0 "" "")
         (match_operand 1 "" ""))]
  ""
{
  s390_emit_call (XEXP (operands[0], 0), NULL_RTX, NULL_RTX, NULL_RTX);
  DONE;
})

(define_insn "*sibcall_br"
  [(call (mem:QI (reg SIBCALL_REGNUM))
         (match_operand 0 "const_int_operand" "n"))]
  "SIBLING_CALL_P (insn)
   && GET_MODE (XEXP (XEXP (PATTERN (insn), 0), 0)) == Pmode"
  "br\t%%r1"
  [(set_attr "op_type" "RR")
   (set_attr "type"  "branch")
   (set_attr "atype" "agen")])

(define_insn "*sibcall_brc"
  [(call (mem:QI (match_operand 0 "bras_sym_operand" "X"))
         (match_operand 1 "const_int_operand" "n"))]
  "SIBLING_CALL_P (insn) && TARGET_SMALL_EXEC"
  "j\t%0"
  [(set_attr "op_type" "RI")
   (set_attr "type"    "branch")])

(define_insn "*sibcall_brcl"
  [(call (mem:QI (match_operand 0 "bras_sym_operand" "X"))
         (match_operand 1 "const_int_operand" "n"))]
  "SIBLING_CALL_P (insn) && TARGET_CPU_ZARCH"
  "jg\t%0"
  [(set_attr "op_type" "RIL")
   (set_attr "type"    "branch")])

;
; sibcall_value patterns
;

(define_expand "sibcall_value"
  [(set (match_operand 0 "" "")
        (call (match_operand 1 "" "")
              (match_operand 2 "" "")))]
  ""
{
  s390_emit_call (XEXP (operands[1], 0), NULL_RTX, operands[0], NULL_RTX);
  DONE;
})

(define_insn "*sibcall_value_br"
  [(set (match_operand 0 "" "")
        (call (mem:QI (reg SIBCALL_REGNUM))
              (match_operand 1 "const_int_operand" "n")))]
  "SIBLING_CALL_P (insn)
   && GET_MODE (XEXP (XEXP (XEXP (PATTERN (insn), 1), 0), 0)) == Pmode"
  "br\t%%r1"
  [(set_attr "op_type" "RR")
   (set_attr "type"  "branch")
   (set_attr "atype" "agen")])

(define_insn "*sibcall_value_brc"
  [(set (match_operand 0 "" "")
        (call (mem:QI (match_operand 1 "bras_sym_operand" "X"))
              (match_operand 2 "const_int_operand" "n")))]
  "SIBLING_CALL_P (insn) && TARGET_SMALL_EXEC"
  "j\t%1"
  [(set_attr "op_type" "RI")
   (set_attr "type"    "branch")])

(define_insn "*sibcall_value_brcl"
  [(set (match_operand 0 "" "")
        (call (mem:QI (match_operand 1 "bras_sym_operand" "X"))
              (match_operand 2 "const_int_operand" "n")))]
  "SIBLING_CALL_P (insn) && TARGET_CPU_ZARCH"
  "jg\t%1"
  [(set_attr "op_type" "RIL")
   (set_attr "type"    "branch")])


;
; call instruction pattern(s).
;

(define_expand "call"
  [(call (match_operand 0 "" "")
         (match_operand 1 "" ""))
   (use (match_operand 2 "" ""))]
  ""
{
  s390_emit_call (XEXP (operands[0], 0), NULL_RTX, NULL_RTX,
                  gen_rtx_REG (Pmode, RETURN_REGNUM));
  DONE;
})

(define_insn "*bras"
  [(call (mem:QI (match_operand 0 "bras_sym_operand" "X"))
         (match_operand 1 "const_int_operand" "n"))
   (clobber (match_operand 2 "register_operand" "=r"))]
  "!SIBLING_CALL_P (insn)
   && TARGET_SMALL_EXEC
   && GET_MODE (operands[2]) == Pmode"
  "bras\t%2,%0"
  [(set_attr "op_type" "RI")
   (set_attr "type"    "jsr")])

(define_insn "*brasl"
  [(call (mem:QI (match_operand 0 "bras_sym_operand" "X"))
         (match_operand 1 "const_int_operand" "n"))
   (clobber (match_operand 2 "register_operand" "=r"))]
  "!SIBLING_CALL_P (insn)
   && TARGET_CPU_ZARCH
   && GET_MODE (operands[2]) == Pmode"
  "brasl\t%2,%0"
  [(set_attr "op_type" "RIL")
   (set_attr "type"    "jsr")])

(define_insn "*basr"
  [(call (mem:QI (match_operand 0 "address_operand" "U"))
         (match_operand 1 "const_int_operand" "n"))
   (clobber (match_operand 2 "register_operand" "=r"))]
  "!SIBLING_CALL_P (insn) && GET_MODE (operands[2]) == Pmode"
{
  if (get_attr_op_type (insn) == OP_TYPE_RR)
    return "basr\t%2,%0";
  else
    return "bas\t%2,%a0";
}
  [(set (attr "op_type")
        (if_then_else (match_operand 0 "register_operand" "")
                      (const_string "RR") (const_string "RX")))
   (set_attr "type"  "jsr")
   (set_attr "atype" "agen")])

;
; call_value instruction pattern(s).
;

(define_expand "call_value"
  [(set (match_operand 0 "" "")
        (call (match_operand 1 "" "")
              (match_operand 2 "" "")))
   (use (match_operand 3 "" ""))]
  ""
{
  s390_emit_call (XEXP (operands[1], 0), NULL_RTX, operands[0],
                  gen_rtx_REG (Pmode, RETURN_REGNUM));
  DONE;
})

(define_insn "*bras_r"
  [(set (match_operand 0 "" "")
        (call (mem:QI (match_operand 1 "bras_sym_operand" "X"))
              (match_operand:SI 2 "const_int_operand" "n")))
   (clobber (match_operand 3 "register_operand" "=r"))]
  "!SIBLING_CALL_P (insn)
   && TARGET_SMALL_EXEC
   && GET_MODE (operands[3]) == Pmode"
  "bras\t%3,%1"
  [(set_attr "op_type" "RI")
   (set_attr "type"    "jsr")])

(define_insn "*brasl_r"
  [(set (match_operand 0 "" "")
        (call (mem:QI (match_operand 1 "bras_sym_operand" "X"))
              (match_operand 2 "const_int_operand" "n")))
   (clobber (match_operand 3 "register_operand" "=r"))]
  "!SIBLING_CALL_P (insn)
   && TARGET_CPU_ZARCH
   && GET_MODE (operands[3]) == Pmode"
  "brasl\t%3,%1"
  [(set_attr "op_type" "RIL")
   (set_attr "type"    "jsr")])

(define_insn "*basr_r"
  [(set (match_operand 0 "" "")
        (call (mem:QI (match_operand 1 "address_operand" "U"))
              (match_operand 2 "const_int_operand" "n")))
   (clobber (match_operand 3 "register_operand" "=r"))]
  "!SIBLING_CALL_P (insn) && GET_MODE (operands[3]) == Pmode"
{
  if (get_attr_op_type (insn) == OP_TYPE_RR)
    return "basr\t%3,%1";
  else
    return "bas\t%3,%a1";
}
  [(set (attr "op_type")
        (if_then_else (match_operand 1 "register_operand" "")
                      (const_string "RR") (const_string "RX")))
   (set_attr "type"  "jsr")
   (set_attr "atype" "agen")])

;;
;;- Thread-local storage support.
;;

(define_expand "get_tp_64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "") (reg:DI TP_REGNUM))]
  "TARGET_64BIT"
  "")

(define_expand "get_tp_31"
  [(set (match_operand:SI 0 "nonimmediate_operand" "") (reg:SI TP_REGNUM))]
  "!TARGET_64BIT"
  "")

(define_expand "set_tp_64"
  [(set (reg:DI TP_REGNUM) (match_operand:DI 0 "nonimmediate_operand" ""))
   (set (reg:DI TP_REGNUM) (unspec_volatile:DI [(reg:DI TP_REGNUM)] UNSPECV_SET_TP))]
  "TARGET_64BIT"
  "")

(define_expand "set_tp_31"
  [(set (reg:SI TP_REGNUM) (match_operand:SI 0 "nonimmediate_operand" ""))
   (set (reg:SI TP_REGNUM) (unspec_volatile:SI [(reg:SI TP_REGNUM)] UNSPECV_SET_TP))]
  "!TARGET_64BIT"
  "")

(define_insn "*set_tp"
  [(set (reg TP_REGNUM) (unspec_volatile [(reg TP_REGNUM)] UNSPECV_SET_TP))]
  ""
  ""
  [(set_attr "type" "none")
   (set_attr "length" "0")])

(define_insn "*tls_load_64"
  [(set (match_operand:DI 0 "register_operand" "=d")
        (unspec:DI [(match_operand:DI 1 "memory_operand" "m")
                    (match_operand:DI 2 "" "")]
                   UNSPEC_TLS_LOAD))]
  "TARGET_64BIT"
  "lg\t%0,%1%J2"
  [(set_attr "op_type" "RXE")])

(define_insn "*tls_load_31"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
        (unspec:SI [(match_operand:SI 1 "memory_operand" "R,T")
                    (match_operand:SI 2 "" "")]
                   UNSPEC_TLS_LOAD))]
  "!TARGET_64BIT"
  "@
   l\t%0,%1%J2
   ly\t%0,%1%J2"
  [(set_attr "op_type" "RX,RXY")])

(define_insn "*bras_tls"
  [(set (match_operand 0 "" "")
        (call (mem:QI (match_operand 1 "bras_sym_operand" "X"))
              (match_operand 2 "const_int_operand" "n")))
   (clobber (match_operand 3 "register_operand" "=r"))
   (use (match_operand 4 "" ""))]
  "!SIBLING_CALL_P (insn)
   && TARGET_SMALL_EXEC
   && GET_MODE (operands[3]) == Pmode"
  "bras\t%3,%1%J4"
  [(set_attr "op_type" "RI")
   (set_attr "type"    "jsr")])

(define_insn "*brasl_tls"
  [(set (match_operand 0 "" "")
        (call (mem:QI (match_operand 1 "bras_sym_operand" "X"))
              (match_operand 2 "const_int_operand" "n")))
   (clobber (match_operand 3 "register_operand" "=r"))
   (use (match_operand 4 "" ""))]
  "!SIBLING_CALL_P (insn)
   && TARGET_CPU_ZARCH
   && GET_MODE (operands[3]) == Pmode"
  "brasl\t%3,%1%J4"
  [(set_attr "op_type" "RIL")
   (set_attr "type"    "jsr")])

(define_insn "*basr_tls"
  [(set (match_operand 0 "" "")
        (call (mem:QI (match_operand 1 "address_operand" "U"))
              (match_operand 2 "const_int_operand" "n")))
   (clobber (match_operand 3 "register_operand" "=r"))
   (use (match_operand 4 "" ""))]
  "!SIBLING_CALL_P (insn) && GET_MODE (operands[3]) == Pmode"
{
  if (get_attr_op_type (insn) == OP_TYPE_RR)
    return "basr\t%3,%1%J4";
  else
    return "bas\t%3,%a1%J4";
}
  [(set (attr "op_type")
        (if_then_else (match_operand 1 "register_operand" "")
                      (const_string "RR") (const_string "RX")))
   (set_attr "type"  "jsr")
   (set_attr "atype" "agen")])

;;
;;- Atomic operations
;;

;
; memory barrier pattern.
;

(define_expand "memory_barrier"
  [(set (mem:BLK (match_dup 0))
        (unspec_volatile:BLK [(mem:BLK (match_dup 0))] UNSPECV_MB))]
  ""
{
  operands[0] = gen_rtx_MEM (BLKmode, gen_rtx_SCRATCH (DImode));
  MEM_VOLATILE_P (operands[0]) = 1;
})

(define_insn "*memory_barrier"
  [(set (match_operand:BLK 0 "" "")
        (unspec_volatile:BLK [(match_operand:BLK 1 "" "")] UNSPECV_MB))]
  ""
  "bcr\t15,0"
  [(set_attr "op_type" "RR")])

;
; compare and swap patterns.
;

(define_expand "sync_compare_and_swap<mode>"
  [(parallel
    [(set (match_operand:TDSI 0 "register_operand" "")
          (match_operand:TDSI 1 "memory_operand" ""))
     (set (match_dup 1)
          (unspec_volatile:TDSI
            [(match_dup 1)
             (match_operand:TDSI 2 "register_operand" "")
             (match_operand:TDSI 3 "register_operand" "")]
            UNSPECV_CAS))
     (set (reg:CCZ1 CC_REGNUM)
          (compare:CCZ1 (match_dup 1) (match_dup 2)))])]
  "")

(define_expand "sync_compare_and_swap<mode>"
  [(parallel
    [(set (match_operand:HQI 0 "register_operand" "")
          (match_operand:HQI 1 "memory_operand" ""))
     (set (match_dup 1)
          (unspec_volatile:HQI
            [(match_dup 1)
             (match_operand:HQI 2 "general_operand" "")
             (match_operand:HQI 3 "general_operand" "")]
            UNSPECV_CAS))
     (set (reg:CCZ1 CC_REGNUM)
          (compare:CCZ1 (match_dup 1) (match_dup 2)))])]
  ""
  "s390_expand_cs_hqi (<MODE>mode, operands[0], operands[1], 
                       operands[2], operands[3]); DONE;")

(define_expand "sync_compare_and_swap_cc<mode>"
  [(parallel
    [(set (match_operand:TDSI 0 "register_operand" "")
          (match_operand:TDSI 1 "memory_operand" ""))
     (set (match_dup 1)
          (unspec_volatile:TDSI
            [(match_dup 1)
             (match_operand:TDSI 2 "register_operand" "")
             (match_operand:TDSI 3 "register_operand" "")]
            UNSPECV_CAS))
     (set (match_dup 4)
          (compare:CCZ1 (match_dup 1) (match_dup 2)))])]
  ""
{
  /* Emulate compare.  */
  operands[4] = gen_rtx_REG (CCZ1mode, CC_REGNUM);
  s390_compare_op0 = operands[1];
  s390_compare_op1 = operands[2];
  s390_compare_emitted = operands[4];
})

; cds, cdsg
(define_insn "*sync_compare_and_swap<mode>"
  [(set (match_operand:DP 0 "register_operand" "=r")
        (match_operand:DP 1 "memory_operand" "+Q"))
   (set (match_dup 1)
        (unspec_volatile:DP
          [(match_dup 1)
           (match_operand:DP 2 "register_operand" "0")
           (match_operand:DP 3 "register_operand" "r")]
          UNSPECV_CAS))
   (set (reg:CCZ1 CC_REGNUM)
        (compare:CCZ1 (match_dup 1) (match_dup 2)))]
  ""
  "cds<tg>\t%0,%3,%S1"
  [(set_attr "op_type" "RS<TE>")
   (set_attr "type"   "sem")])

; cs, csg
(define_insn "*sync_compare_and_swap<mode>"
  [(set (match_operand:GPR 0 "register_operand" "=r")
        (match_operand:GPR 1 "memory_operand" "+Q"))
   (set (match_dup 1)
        (unspec_volatile:GPR
          [(match_dup 1)
           (match_operand:GPR 2 "register_operand" "0")
           (match_operand:GPR 3 "register_operand" "r")]
          UNSPECV_CAS))
   (set (reg:CCZ1 CC_REGNUM)
        (compare:CCZ1 (match_dup 1) (match_dup 2)))]
  "" 
  "cs<g>\t%0,%3,%S1"
  [(set_attr "op_type" "RS<E>")
   (set_attr "type"   "sem")])


;
; Other atomic instruction patterns.
;

(define_expand "sync_lock_test_and_set<mode>"
  [(match_operand:HQI 0 "register_operand")
   (match_operand:HQI 1 "memory_operand")
   (match_operand:HQI 2 "general_operand")]
  ""
  "s390_expand_atomic (<MODE>mode, SET, operands[0], operands[1], 
                       operands[2], false); DONE;")

(define_expand "sync_<atomic><mode>"
  [(set (match_operand:HQI 0 "memory_operand")
        (ATOMIC:HQI (match_dup 0)
                    (match_operand:HQI 1 "general_operand")))]
  ""
  "s390_expand_atomic (<MODE>mode, <CODE>, NULL_RTX, operands[0], 
                       operands[1], false); DONE;")

(define_expand "sync_old_<atomic><mode>"
  [(set (match_operand:HQI 0 "register_operand")
        (match_operand:HQI 1 "memory_operand"))
   (set (match_dup 1)
        (ATOMIC:HQI (match_dup 1)
                    (match_operand:HQI 2 "general_operand")))]
  ""
  "s390_expand_atomic (<MODE>mode, <CODE>, operands[0], operands[1], 
                       operands[2], false); DONE;")

(define_expand "sync_new_<atomic><mode>"
  [(set (match_operand:HQI 0 "register_operand")
        (ATOMIC:HQI (match_operand:HQI 1 "memory_operand")
                    (match_operand:HQI 2 "general_operand"))) 
   (set (match_dup 1) (ATOMIC:HQI (match_dup 1) (match_dup 2)))]
  ""
  "s390_expand_atomic (<MODE>mode, <CODE>, operands[0], operands[1], 
                       operands[2], true); DONE;")

;;
;;- Miscellaneous instructions.
;;

;
; allocate stack instruction pattern(s).
;

(define_expand "allocate_stack"
  [(match_operand 0 "general_operand" "")
   (match_operand 1 "general_operand" "")]
 "TARGET_BACKCHAIN"
{
  rtx temp = gen_reg_rtx (Pmode);

  emit_move_insn (temp, s390_back_chain_rtx ());
  anti_adjust_stack (operands[1]);
  emit_move_insn (s390_back_chain_rtx (), temp);

  emit_move_insn (operands[0], virtual_stack_dynamic_rtx);
  DONE;
})


;
; setjmp instruction pattern.
;

(define_expand "builtin_setjmp_receiver"
  [(match_operand 0 "" "")]
  "flag_pic"
{
  emit_insn (s390_load_got ());
  emit_insn (gen_rtx_USE (VOIDmode, pic_offset_table_rtx));
  DONE;
})

;; These patterns say how to save and restore the stack pointer.  We need not
;; save the stack pointer at function level since we are careful to
;; preserve the backchain.  At block level, we have to restore the backchain
;; when we restore the stack pointer.
;;
;; For nonlocal gotos, we must save both the stack pointer and its
;; backchain and restore both.  Note that in the nonlocal case, the
;; save area is a memory location.

(define_expand "save_stack_function"
  [(match_operand 0 "general_operand" "")
   (match_operand 1 "general_operand" "")]
  ""
  "DONE;")

(define_expand "restore_stack_function"
  [(match_operand 0 "general_operand" "")
   (match_operand 1 "general_operand" "")]
  ""
  "DONE;")

(define_expand "restore_stack_block"
  [(match_operand 0 "register_operand" "")
   (match_operand 1 "register_operand" "")]
  "TARGET_BACKCHAIN"
{
  rtx temp = gen_reg_rtx (Pmode);

  emit_move_insn (temp, s390_back_chain_rtx ());
  emit_move_insn (operands[0], operands[1]);
  emit_move_insn (s390_back_chain_rtx (), temp);

  DONE;
})

(define_expand "save_stack_nonlocal"
  [(match_operand 0 "memory_operand" "")
   (match_operand 1 "register_operand" "")]
  ""
{
  enum machine_mode mode = TARGET_64BIT ? OImode : TImode;
  rtx base = gen_rtx_REG (Pmode, BASE_REGNUM);

  /* Copy the backchain to the first word, sp to the second and the
     literal pool base to the third.  */

  if (TARGET_BACKCHAIN)
    {
      rtx temp = force_reg (Pmode, s390_back_chain_rtx ());
      emit_move_insn (operand_subword (operands[0], 0, 0, mode), temp);
    }

  emit_move_insn (operand_subword (operands[0], 1, 0, mode), operands[1]);
  emit_move_insn (operand_subword (operands[0], 2, 0, mode), base);

  DONE;
})

(define_expand "restore_stack_nonlocal"
  [(match_operand 0 "register_operand" "")
   (match_operand 1 "memory_operand" "")]
  ""
{
  enum machine_mode mode = TARGET_64BIT ? OImode : TImode;
  rtx base = gen_rtx_REG (Pmode, BASE_REGNUM);
  rtx temp = NULL_RTX;

  /* Restore the backchain from the first word, sp from the second and the
     literal pool base from the third.  */

  if (TARGET_BACKCHAIN)
    temp = force_reg (Pmode, operand_subword (operands[1], 0, 0, mode));
    
  emit_move_insn (base, operand_subword (operands[1], 2, 0, mode));
  emit_move_insn (operands[0], operand_subword (operands[1], 1, 0, mode));

  if (temp)
    emit_move_insn (s390_back_chain_rtx (), temp);

  emit_insn (gen_rtx_USE (VOIDmode, base));
  DONE;
})

(define_expand "exception_receiver"
  [(const_int 0)]
  ""
{
  s390_set_has_landing_pad_p (true);
  DONE;
})

;
; nop instruction pattern(s).
;

(define_insn "nop"
  [(const_int 0)]
  ""
  "lr\t0,0"
  [(set_attr "op_type" "RR")])


;
; Special literal pool access instruction pattern(s).
;

(define_insn "*pool_entry"
  [(unspec_volatile [(match_operand 0 "consttable_operand" "X")]
                    UNSPECV_POOL_ENTRY)]
  ""
{
  enum machine_mode mode = GET_MODE (PATTERN (insn));
  unsigned int align = GET_MODE_BITSIZE (mode);
  s390_output_pool_entry (operands[0], mode, align);
  return "";
}
  [(set (attr "length")
        (symbol_ref "GET_MODE_SIZE (GET_MODE (PATTERN (insn)))"))])

(define_insn "pool_align"
  [(unspec_volatile [(match_operand 0 "const_int_operand" "n")]
                    UNSPECV_POOL_ALIGN)]
  ""
  ".align\t%0"
  [(set (attr "length") (symbol_ref "INTVAL (operands[0])"))])

(define_insn "pool_section_start"
  [(unspec_volatile [(const_int 1)] UNSPECV_POOL_SECTION)]
  ""
  ".section\t.rodata"
  [(set_attr "length" "0")])

(define_insn "pool_section_end"
  [(unspec_volatile [(const_int 0)] UNSPECV_POOL_SECTION)]
  ""
  ".previous"
  [(set_attr "length" "0")])

(define_insn "main_base_31_small"
  [(set (match_operand 0 "register_operand" "=a")
        (unspec [(label_ref (match_operand 1 "" ""))] UNSPEC_MAIN_BASE))]
  "!TARGET_CPU_ZARCH && GET_MODE (operands[0]) == Pmode"
  "basr\t%0,0"
  [(set_attr "op_type" "RR")
   (set_attr "type"    "la")])

(define_insn "main_base_31_large"
  [(set (match_operand 0 "register_operand" "=a")
        (unspec [(label_ref (match_operand 1 "" ""))] UNSPEC_MAIN_BASE))
   (set (pc) (label_ref (match_operand 2 "" "")))]
  "!TARGET_CPU_ZARCH && GET_MODE (operands[0]) == Pmode"
  "bras\t%0,%2"
  [(set_attr "op_type" "RI")])

(define_insn "main_base_64"
  [(set (match_operand 0 "register_operand" "=a")
        (unspec [(label_ref (match_operand 1 "" ""))] UNSPEC_MAIN_BASE))]
  "TARGET_CPU_ZARCH && GET_MODE (operands[0]) == Pmode"
  "larl\t%0,%1"
  [(set_attr "op_type" "RIL")
   (set_attr "type"    "larl")])

(define_insn "main_pool"
  [(set (match_operand 0 "register_operand" "=a")
        (unspec_volatile [(const_int 0)] UNSPECV_MAIN_POOL))]
  "GET_MODE (operands[0]) == Pmode"
{
  gcc_unreachable ();
}
  [(set (attr "type") 
        (if_then_else (ne (symbol_ref "TARGET_CPU_ZARCH") (const_int 0))
                      (const_string "larl") (const_string "la")))])

(define_insn "reload_base_31"
  [(set (match_operand 0 "register_operand" "=a")
        (unspec [(label_ref (match_operand 1 "" ""))] UNSPEC_RELOAD_BASE))]
  "!TARGET_CPU_ZARCH && GET_MODE (operands[0]) == Pmode"
  "basr\t%0,0\;la\t%0,%1-.(%0)"
  [(set_attr "length" "6")
   (set_attr "type" "la")])

(define_insn "reload_base_64"
  [(set (match_operand 0 "register_operand" "=a")
        (unspec [(label_ref (match_operand 1 "" ""))] UNSPEC_RELOAD_BASE))]
  "TARGET_CPU_ZARCH && GET_MODE (operands[0]) == Pmode"
  "larl\t%0,%1"
  [(set_attr "op_type" "RIL")
   (set_attr "type"    "larl")])

(define_insn "pool"
  [(unspec_volatile [(match_operand 0 "const_int_operand" "n")] UNSPECV_POOL)]
  ""
{
  gcc_unreachable ();
}
  [(set (attr "length") (symbol_ref "INTVAL (operands[0])"))])

;;
;; Insns related to generating the function prologue and epilogue.
;;


(define_expand "prologue"
  [(use (const_int 0))]
  ""
  "s390_emit_prologue (); DONE;")

(define_expand "epilogue"
  [(use (const_int 1))]
  ""
  "s390_emit_epilogue (false); DONE;")

(define_expand "sibcall_epilogue"
  [(use (const_int 0))]
  ""
  "s390_emit_epilogue (true); DONE;")

(define_insn "*return"
  [(return)
   (use (match_operand 0 "register_operand" "a"))]
  "GET_MODE (operands[0]) == Pmode"
  "br\t%0"
  [(set_attr "op_type" "RR")
   (set_attr "type"    "jsr")
   (set_attr "atype"   "agen")])


;; Instruction definition to extend a 31-bit pointer into a 64-bit
;; pointer. This is used for compatibility.

(define_expand "ptr_extend"
  [(set (match_operand:DI 0 "register_operand" "=r")
        (match_operand:SI 1 "register_operand" "r"))]
  "TARGET_64BIT"
{
  emit_insn (gen_anddi3 (operands[0],
                         gen_lowpart (DImode, operands[1]),
                         GEN_INT (0x7fffffff)));
  DONE;
})

;; Instruction definition to expand eh_return macro to support
;; swapping in special linkage return addresses.

(define_expand "eh_return"
  [(use (match_operand 0 "register_operand" ""))]
  "TARGET_TPF"
{
  s390_emit_tpf_eh_return (operands[0]);
  DONE;
})

;
; Stack Protector Patterns
;

(define_expand "stack_protect_set"
  [(set (match_operand 0 "memory_operand" "")
        (match_operand 1 "memory_operand" ""))]
  ""
{
#ifdef TARGET_THREAD_SSP_OFFSET
  operands[1]
    = gen_rtx_MEM (Pmode, gen_rtx_PLUS (Pmode, s390_get_thread_pointer (),
                                        GEN_INT (TARGET_THREAD_SSP_OFFSET)));
#endif
  if (TARGET_64BIT)
    emit_insn (gen_stack_protect_setdi (operands[0], operands[1]));
  else
    emit_insn (gen_stack_protect_setsi (operands[0], operands[1]));

  DONE;
})

(define_insn "stack_protect_set<mode>"
  [(set (match_operand:DSI 0 "memory_operand" "=Q")
        (unspec:DSI [(match_operand:DSI 1 "memory_operand" "Q")] UNSPEC_SP_SET))]
  ""
  "mvc\t%O0(%G0,%R0),%S1"
  [(set_attr "op_type" "SS")])

(define_expand "stack_protect_test"
  [(set (reg:CC CC_REGNUM)
        (compare (match_operand 0 "memory_operand" "")
                 (match_operand 1 "memory_operand" "")))
   (match_operand 2 "" "")]
  ""
{
#ifdef TARGET_THREAD_SSP_OFFSET
  operands[1]
    = gen_rtx_MEM (Pmode, gen_rtx_PLUS (Pmode, s390_get_thread_pointer (),
                                        GEN_INT (TARGET_THREAD_SSP_OFFSET)));
#endif
  s390_compare_op0 = operands[0];
  s390_compare_op1 = operands[1];
  s390_compare_emitted = gen_rtx_REG (CCZmode, CC_REGNUM);

  if (TARGET_64BIT)
    emit_insn (gen_stack_protect_testdi (operands[0], operands[1]));
  else
    emit_insn (gen_stack_protect_testsi (operands[0], operands[1]));

  emit_jump_insn (gen_beq (operands[2]));

  DONE;
})

(define_insn "stack_protect_test<mode>"
  [(set (reg:CCZ CC_REGNUM)
        (unspec:CCZ [(match_operand:DSI 0 "memory_operand" "Q")
                     (match_operand:DSI 1 "memory_operand" "Q")] UNSPEC_SP_TEST))]
  ""
  "clc\t%O0(%G0,%R0),%S1"
  [(set_attr "op_type" "SS")])
