/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.content.Context;
import android.os.SystemClock;
import android.view.ContextThemeWrapper;
import android.view.View;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.ViewFetcher;

class DialogUtils {
    private final ActivityUtils activityUtils;
    private final ViewFetcher viewFetcher;
    private final Sleeper sleeper;
    private final int MINISLEEP = 50;

    public DialogUtils(ActivityUtils activityUtils, ViewFetcher viewFetcher, Sleeper sleeper) {
        this.activityUtils = activityUtils;
        this.viewFetcher = viewFetcher;
        this.sleeper = sleeper;
    }

    public boolean waitForDialogToClose(long timeout) {
        this.waitForDialogToOpen(timeout);
        long endTime = SystemClock.uptimeMillis() + timeout;
        while (SystemClock.uptimeMillis() < endTime) {
            if (!this.isDialogOpen()) {
                return true;
            }
            this.sleeper.sleep(50);
        }
        return false;
    }

    public boolean waitForDialogToOpen(long timeout) {
        long endTime = SystemClock.uptimeMillis() + timeout;
        while (SystemClock.uptimeMillis() < endTime) {
            if (this.isDialogOpen()) {
                return true;
            }
            this.sleeper.sleep(50);
        }
        return false;
    }

    private boolean isDialogOpen() {
        Activity activity = this.activityUtils.getCurrentActivity(false);
        View view = this.viewFetcher.getRecentDecorView(this.viewFetcher.getWindowDecorViews());
        Context viewContext = null;
        if (view != null) {
            viewContext = view.getContext();
        }
        if (viewContext instanceof ContextThemeWrapper) {
            ContextThemeWrapper ctw = (ContextThemeWrapper)viewContext;
            viewContext = ctw.getBaseContext();
        }
        Activity activityContext = activity;
        Context activityBaseContext = activity.getBaseContext();
        return (activityContext.equals(viewContext) || activityBaseContext.equals(viewContext)) && view != activity.getWindow().getDecorView();
    }
}

