/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: task.h
 */

#define MAX_RO_COLUMNS   4
#define RO_ICON_COLUMN   0
#define RO_SIZE_COLUMN   1
#define RO_TYPE_COLUMN   2
#define RO_NAME_COLUMN   3

#define MAX_DO_COLUMNS   3
#define DO_ICON_COLUMN   0
#define DO_NAME_COLUMN   1
#define DO_REASON_COLUMN 2

typedef enum {
	TASK_REQUIREMENTS_UNKNOWN = 0,
	TASK_REQUIRES_OBJECTS_ONLY,
	TASK_REQUIRES_OPTIONS_ONLY,
	TASK_REQUIRES_NO_ADDITIONAL_ARGS,
	TASK_REQUIRES_OBJECTS_AND_OPTIONS
} task_requirements_t;

gboolean exit_from_event_loop(gpointer not_used);

gchar *get_task_action_string(task_handle_t task);

void options_window_callout(option_widget_info_t * info, value_t value,
			    task_effect_t set_side_effect);

void on_task_window_destroy(GtkWidget * widget, gpointer user_data);

void on_acceptable_objects_button_clicked(GtkButton * button, gpointer user_data);

void on_acceptable_objects_clist_realize(GtkWidget * widget, gpointer user_data);

void on_acceptable_objects_clist_select_row(GtkCList * clist, gint row, gint column,
					    GdkEventButton * event, gpointer user_data);

void on_acceptable_objects_clist_unselect_row(GtkCList * clist, gint row, gint column,
					      GdkEventButton * event, gpointer user_data);

void create_option_widget_list(task_handle_t handle, gint count, GSList ** options,
			       GSList ** widgets, gboolean show_inactive);

GtkWidget *create_standard_task_window(gchar * window_title, char *next_button_text,
				       GtkSignalFunc next_button_sighandler,
				       GtkSignalFunc prev_button_sighandler,
				       GtkSignalFunc cancel_button_sighandler,
				       task_handle_t handle);

inline void bind_option_list_to_toplevel_widget(GtkWidget * widget, GSList * options);
inline GSList *retrieve_option_list_from_toplevel_widget(GtkWidget * widget);

inline void bind_task_handle_to_toplevel_widget(GtkWidget * widget, task_handle_t task);
inline task_handle_t retrieve_task_handle_from_toplevel_widget(GtkWidget * widget);

inline void display_task_window(GtkWidget * currwin, GtkWidget * newwin, task_handle_t task);

GtkWidget *create_task_confirmation_window(task_handle_t task, gchar * title, gchar * verb,
					   gchar * help);

gint create_task(engine_handle_t handle, task_action_t action,
		 task_requirements_t * requirements, task_handle_t * task);

gint initiate_task(GtkWidget * currwin, engine_handle_t handle, task_action_t action,
		   gchar * title, gchar * verb, gchar * help);

gboolean can_plugin_do_action(plugin_handle_t plugin, task_action_t action);

gint set_selected_object(task_handle_t task, object_handle_t handle);
