/*
 *   (C) Copyright IBM Corp. 2004
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: Multipath Plugin - LVM PV detection.
 * File: evms2/engine/plugins/multipath/mp_lvm.h
 *
 * Metadata structures and other information needed for detecting LVM
 * multipath-PVs.
 */

#define	NAME_LEN		128
#define	LVM_PV_DISK_BASE	0L	// Base of PV structure on disk.
#define	LVM_PV_DISK_SIZE	1024L	// Size reserved for PV structure on disk.

/**
 * struct lvm_disk_data_t
 *
 * Disk stored PV, VG, LV and PE size and offset information.
 **/
typedef struct lvm_disk_data {
	uint32_t base;
	uint32_t size;
} lvm_disk_data_t;

/**
 * struct pv_disk_v2
 *
 * PV disk structure.
 **/
typedef struct pv_disk_v2 {
	uint8_t id[2];			/* Identifier == HM */
	uint16_t version;		/* LVM version */
	lvm_disk_data_t pv_on_disk;
	lvm_disk_data_t vg_on_disk;
	lvm_disk_data_t pv_uuidlist_on_disk;
	lvm_disk_data_t lv_on_disk;
	lvm_disk_data_t pe_on_disk;
	uint8_t pv_uuid[NAME_LEN];
	uint8_t vg_name[NAME_LEN];
	uint8_t system_id[NAME_LEN];	/* for vgexport/vgimport */
	uint32_t pv_major;
	uint32_t pv_number;
	uint32_t pv_status;
	uint32_t pv_allocatable;
	uint32_t pv_size;
	uint32_t lv_cur;
	uint32_t pe_size;
	uint32_t pe_total;
	uint32_t pe_allocated;
	
	/* New in struct version 2 */
	uint32_t pe_start;	        /* in sectors */

} pv_disk_t;

/* Multipath sub-module APIs for LVM. */
extern int mp_lvm_setup(void);
extern void mp_lvm_cleanup(void);
extern int mp_lvm_probe(storage_object_t *child);
extern int mp_lvm_process(list_anchor_t output_list);
extern int mp_lvm_allocate(storage_object_t *object);
extern int mp_lvm_discard(storage_object_t *object);
extern int mp_lvm_delete(storage_object_t *object);
extern int mp_lvm_map(storage_object_t **object,
		      lsn_t *lsn, sector_count_t *count);
extern int mp_lvm_build_targets(storage_object_t *object,
				dm_target_t **targets);

