/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: commit.h
 *
 */


typedef struct changes_pending_parms_s {
	boolean                 result;
	change_record_array_t * changes;
} changes_pending_parms_t;


/*
 * Global data exported by commit.h
 */

extern boolean commit_in_progress;
extern anchor_t commit_node_order;
extern evms_feature_header_t stop_data;

/*
 * Global functions exported by commit.c
 */

/* External APIs provided by commit.c */

extern int evms_commit_changes(void);

/* Internal functions to share with other Engine source modules */

extern void status_message(char * fmt, ...);

extern int deactivate_volumes_on_list(list_anchor_t vol_list);

extern int deactivate_objects_on_list(list_anchor_t obj_list);

extern void delete_volumes(void);

extern void delete_objects(void);

extern void mark_feature_headers_dirty(storage_object_t * obj);

extern boolean is_volume_change_pending(logical_volume_t        * vol,
					changes_pending_parms_t * parms);

extern boolean is_container_change_pending(storage_container_t     * con,
					   changes_pending_parms_t * parms);

extern boolean is_object_change_pending(storage_object_t        * obj,
					changes_pending_parms_t * parms);

extern boolean are_changes_pending(change_record_array_t * * changes);

extern int activate(void);

