/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */ 

#define STD_COLOR	1
#define MENU_COLOR	2
#define ACCEL_COLOR	3
#define MENUSEL_COLOR	4
#define FOCUS_COLOR	5
#define LISTSEL_COLOR	6
#define SELECTED_ACCEL_COLOR 7

#define BLUE_BKGD	COLOR_PAIR(STD_COLOR)
#define WHITE_BKGD	COLOR_PAIR(MENU_COLOR)
#define ACCEL_FGND	COLOR_PAIR(ACCEL_COLOR)
#define MENUSEL_FGND	COLOR_PAIR(MENUSEL_COLOR)

#define KEY_TAB		0x9
#undef KEY_ENTER
#define KEY_ENTER	0xd
#define KEY_ESCAPE	0x1b
#define KEY_SPACEBAR	0x20
#define KEY_PAGEDOWN	0x152
#define KEY_PAGEUP	0x153

inline void get_center_coordinates(int height, int width, int *starty, int *startx);
void print_centered(WINDOW *win, int starty, char *string);
int read_string(WINDOW *win, int starty, int startx, char *string, int max);
int panel_getch(PANEL *panel);
WINDOW *create_window(int height, int width, int starty, int startx, int drawbox, int color);
void delete_window(WINDOW *win);
WINDOW *create_centered_window(int height, int width, int drawbox, int color);
PANEL *create_popup_window(int height, int width, int starty, int startx, int color);
void show_popup_window(PANEL *panel);
void hide_popup_window(PANEL *panel);
void delete_popup_window(PANEL *panel);
PANEL *create_centered_popup_window(int height, int width, int color);
PANEL *create_panel_window(int height, int width, int starty, int startx, int drawbox, int color);
PANEL *create_centered_panel_window(int height, int width, int drawbox, int color);
void show_panel_window(PANEL *panel, int maketop);
void hide_panel_window(PANEL *panel);
void delete_panel_window(PANEL *panel);
void init_window_system(void);
void shutdown_window_system(void);

