/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *
 */

#include <semaphore.h>
#include "lists.h"

/* Global data exported by engine.c */

extern evms_version_t engine_version;
extern evms_version_t engine_api_version;
extern evms_version_t engine_services_api_version;
extern evms_version_t engine_plugin_api_version;
extern evms_version_t engine_fsim_api_version;
extern evms_version_t engine_cluster_api_version;
extern evms_version_t engine_container_api_version;
extern evms_version_t engine_cluster_api_version;
extern evms_version_t engine_daemon_msg_version;

extern ece_nodeid_t   no_nodeid;
extern ece_nodeid_t * current_nodeid;
extern char         * current_node_name;
extern boolean        local_focus;

extern anchor_t plugins_list;
extern anchor_t disks_list;
extern anchor_t segments_list;
extern anchor_t containers_list;
extern anchor_t regions_list;
extern anchor_t EVMS_objects_list;
extern anchor_t volumes_list;
extern anchor_t kill_sectors_list;
extern anchor_t volume_delete_list;
extern anchor_t deactivate_list;
extern anchor_t rename_volume_list;

extern plugin_record_t * local_disk_manager;
extern plugin_record_t * replace_plugin;
extern plugin_record_t * cluster_manager;
extern cluster_functions_t * ece_funcs;
extern plugin_record_t * cluster_segment_manager;

extern int dm_control_fd;

extern engine_mode_t    engine_mode;
extern debug_level_t    debug_level;

extern char           * log_file_name;
extern int              log_file_fd;
extern boolean          log_usec;
extern boolean          log_pid;
extern u_char           log_buf[];
extern pthread_mutex_t  log_mutex;
#define LOG_BUF_SIZE    (MAX_USER_MESSAGE_LEN + 1024)

extern int           lock_file_fd;
extern size_t        lock_file_size;
extern lock_file_t * lock_file;

extern sem_t   shutdown_sem;

extern boolean is_2_4_kernel;

extern pthread_attr_t pthread_attr_detached;

/*
 * Global functions exported by engine.c
 */

/* External APIs provided by engine.c */

extern int evms_get_api_version(evms_version_t * version);

extern int evms_open_engine(char           * node_name,
			    engine_mode_t    mode,
                            ui_callbacks_t * callbacks,
                            debug_level_t    level,
                            char           * log_name);

extern int evms_changes_pending(boolean                 * result,
				change_record_array_t * * changes);

extern int evms_get_debug_level(debug_level_t * level);

extern int evms_set_debug_level(debug_level_t level);

extern int evms_get_kernel_info_level(debug_level_t * level);

extern int evms_set_kernel_info_level(debug_level_t level);

extern int evms_write_log_entry(debug_level_t level,
                                char        * module_name,
                                char        * fmt,
                                ...) __PRINTF_ATTRIBUTE__(3,4);

extern int evms_get_plugin_list(evms_plugin_code_t    type,
                                plugin_search_flags_t flags,
                                handle_array_t    * * plugin_list);

extern int evms_get_plugin_by_ID(plugin_id_t       plugin_ID,
                                 object_handle_t * plugin_handle);

extern int evms_get_plugin_by_name(char            * plugin_name,
                                   object_handle_t * plugin_handle);

extern int evms_update_evms_dev_tree(void);

extern const char * evms_strerror(int err_num);

/* Internal functions to share with other Engine source modules */

extern void timestamp(char        * buf,
                      size_t        len,
		      debug_level_t level);

extern int engine_write_log_entry(debug_level_t level,
                                  char        * fmt,
                                  ...) __PRINTF_ATTRIBUTE__(2,3);

extern int unlock_engine(engine_mode_t mode);

extern void send_shutdown(pid_t pid);

#define MAX_LOCK_MESSAGE_LEN 512
extern int lock_engine(engine_mode_t  mode,
		       const char * * msg);

extern int check_engine_read_access(void);

extern int check_engine_write_access(void);

extern void free_changes_pending_record_array_contents(void * thing);

extern int ensure_app_handle(void * thing);

extern int make_handle_entry(void            * thing,
			     handle_array_t  * ha);

extern int make_user_handle_array(list_anchor_t      list,
				  handle_array_t * * ha);

extern int make_directory(char * dir_name,
			  mode_t mode);

extern boolean is_devfs_installed(void);
