/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: dm-ioctl.h
 *
 * Functions exported from dm-ioctl3.c and dm-ioctl4.c to dm.c. Only dm.c
 * should include this header file.
 */

#ifndef _DM_IOCTL_H_INCLUDED_
#define _DM_IOCTL_H_INCLUDED_ 1

/* Version 3 APIs */
extern int run_command_v3(void *dmi, unsigned long command);
extern int dm_get_version_v3(int *major, int *minor, int *patch);
extern int dm_suspend_v3(char *name, int suspend);
extern int dm_activate_v3(char *name, dm_target_t *target_list, int reactivate, int read_only, u_int32_t *dev_major, u_int32_t *dev_minor);
extern int dm_deactivate_v3(char *name);
extern int dm_rename_v3(char *old_name, char *new_name);
extern int dm_update_status_v3(char *name, int *active, int *read_only, u_int32_t *dev_major, u_int32_t *dev_minor);
extern int dm_get_targets_v3(char *name, dm_target_t **target_list);
extern int dm_get_info_v3(char *name, char **info);

/* Version 4 APIs */
extern int run_command_v4(void *dmi, unsigned long command);
extern int dm_get_version_v4(int *major, int *minor, int *patch);
extern int dm_suspend_v4(char *name, int suspend);
extern int dm_activate_v4(char *name, dm_target_t *target_list, int reactivate, int read_only, u_int32_t *dev_major, u_int32_t *dev_minor);
extern int dm_deactivate_v4(char *name);
extern int dm_rename_v4(char *old_name, char *new_name);
extern int dm_create_v4(char *name, u_int32_t *dev_major, u_int32_t *dev_minor);
extern int dm_update_status_v4(char *name, int *active, int *read_only, u_int32_t *dev_major, u_int32_t *dev_minor);
extern int dm_get_targets_v4(char *name, dm_target_t **target_list);
extern int dm_load_targets_v4(char *name, dm_target_t *target_list, int read_only);
extern int dm_clear_targets_v4(char *name);
extern int dm_get_info_v4(char *name, char **info);
extern int dm_get_devices_v4(dm_device_list_t **device_list);
extern int dm_wait_v4(char *name, unsigned int *event_nr, char **info);

#endif

