/* -*- C++ -*- libept/packageinfo.h
	written by Peter Rockai <me@mornfall.net> */

#include <apt-front/cache/entity/package.h>
#include <apt-front/cache/cache.h>
#include <libept/packageinfoui.h>

#ifndef EPT_PACKAGEINFO_H
#define EPT_PACKAGEINFO_H

namespace ept {

using namespace aptFront;

class PackageInfo : public PackageInfoUi, public cache::Observer
{
    Q_OBJECT
public:
    PackageInfo( QWidget *p, const char *n = 0 );
public slots:
    void setVersion( cache::entity::Version v, bool = true );
    void setPackage( cache::entity::Package v );
    void adjustFontSize( int );
public:
    void notifyPostChange( cache::component::Base * );
    void notifyPostRebuild( cache::component::Base * );
    void hideStatus();
protected:
    cache::entity::StableVersion m_version;
    bool m_specificVersion;
};

inline QString labelFormat( const QString &what,
                       const QString &txt, bool nobr = true )
{
    QString ret = "<b><nobr>" + what + "</nobr></b>&nbsp;" + (nobr ? "<nobr>" : "")
                  + txt + (nobr ? "</nobr>" : "");
    return ret;
}

QColor actionColor( cache::entity::Package p );
QColor statusColor( cache::entity::Package p );

QString formatLongDescription( QString in );
QString colorify( QColor c, QString s );

}

#endif
