# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from twisted.trial import unittest
from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core.utils import network
import os, platform

class TestNetwork(ElisaTestCase):

    def test_host_address(self):
        
        if platform.system() == 'Windows':
            raise unittest.SkipTest("Does not works under windows, need investigation")

        # FIXME: linux/windows specific tests are not trivial here
        host_address = network.get_host_address()
        self.failUnless(host_address)
        
    def test_ip_address(self):
        
        if platform.system() == 'Windows':
            raise unittest.SkipTest("Does not works under windows, need investigation")

        # FIXME: linux/windows specific tests are not trivial here
        ip_address = network.get_ip_address()
        print ip_address
        self.failUnless(ip_address)
