# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'

from elisa.base_components.action import Action
from elisa.core import player
from elisa.core import plugin_registry


class PlayAction(Action):
    """
    Play mediafile
    """
    def __init__(self):
        Action.__init__(self)
        self.player_model = None
        self.media_type = 'audio'
        #WEAK-Reference!
        self.model = None

    def __call__(self, controller, origin):
        model = self.model()
        if not model:
            return

        if hasattr(model, 'uri') and model.uri != None:
            if self.player_model.state == player.STATES.PLAYING and \
                                    self.player_model.media_type == 'audio':
                if model in self.player_model.playlist:
                    # Already in the list, we should play it
                    self.player_model.uri = model.uri
                    self.player_model.state = player.STATES.PLAYING
                else:
                    self.player_model.playlist.append(model)
            else:
                self.player_model.playlist.append(model)
                self.player_model.uri = model.uri
                self.player_model.media_type = self.media_type
                self.player_model.state = player.STATES.PLAYING

