# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'

from elisa.base_components.action import Action
from elisa.core.media_uri import MediaUri
from elisa.core import media_uri, player
from elisa.core import plugin_registry


class ClearplaylistAction(Action):
    """
    Play mediafile
    """
    def __init__(self):
        Action.__init__(self)
        self.player_model = None
        self.action_model = None

    def __call__(self, controller, origin):
        #clear it
        self.player_model.playlist[1:] = []
        self.player_model.state = player.STATES.STOPPED
        self.player_model.uri = None

