# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.base_components.input_provider import PushInputProvider
from elisa.core.input_event import *

from twisted.internet import reactor


class AutomatedInput(PushInputProvider):
    """
    DOCME
    """

    def __init__(self):
        PushInputProvider.__init__(self)
        self.orders1 = "RDDD"
        self.orders2 = "" \
        "RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR" \
        "LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL" \
        "RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR" \
        "LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL" \
        "RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR" \
        "LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL" \
        "RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR" \
        "LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL" \
        "RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR" \
        "LLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLL"

        self.delay = None
        self.tempo = 0.05

    def bind(self):
        reactor.callLater(5.0, self._execute_orders, self.orders1)
        reactor.callLater(15.0, self._execute_orders, self.orders2)

    def unbind(self):
        if self.delay != None and self.delay.active():
            self.delay.cancel()

    def _translate_to_action(self, letter):
        if letter == 'D':
            return EventAction.GO_DOWN
        if letter == 'U':
            return EventAction.GO_UP
        if letter == 'L':
            return EventAction.GO_LEFT
        if letter == 'R':
            return EventAction.GO_RIGHT

    def _execute_orders(self, orders):
        time = 0
        for order in orders:
            action = self._translate_to_action(order)
            reactor.callLater(time, self._execute_action, action)
            time += self.tempo

    def _execute_action(self, action):
        self.debug("executing action %s" % action)
        event = self._generate_keyboard_event(action)
        self.input_manager.process_event(event, self.path)

    def _generate_keyboard_event(self, action):
        event = InputEvent(EventSource.KEYBOARD, EventType.KEY_DOWN, action)
        return event
