/* Test fixtures for dbus-python, based on _dbus_glib_bindings. */

#include <Python.h>
#include "dbus-python.h"

#if defined(__GNUC__)
#   if __GNUC__ >= 3
#       define UNUSED __attribute__((__unused__))
#   else
#       define UNUSED /*nothing*/
#   endif
#else
#   define UNUSED /*nothing*/
#endif

static dbus_bool_t
dbus_py_test_set_up_conn(DBusConnection *conn UNUSED, void *data UNUSED)
{
    PyErr_SetString(PyExc_ValueError, "Dummy error from UnusableMainLoop");
    return 0;
}

static dbus_bool_t
dbus_py_test_set_up_srv(DBusServer *srv UNUSED, void *data UNUSED)
{
    PyErr_SetString(PyExc_ValueError, "Dummy error from UnusableMainLoop");
    return 0;
}

static void
dbus_py_test_free(void *data UNUSED)
{
}

static PyObject *
dbus_test_native_mainloop(void)
{
    PyObject *loop = DBusPyNativeMainLoop_New4(dbus_py_test_set_up_conn,
                                               dbus_py_test_set_up_srv,
                                               dbus_py_test_free,
                                               NULL);
    return loop;
}

static PyObject *
UnusableMainLoop (PyObject *always_null UNUSED, PyObject *args, PyObject *kwargs)
{
    PyObject *mainloop, *function, *result;
    int set_as_default = 0;
    static char *argnames[] = {"set_as_default", NULL};

    if (PyTuple_Size(args) != 0) {
        PyErr_SetString(PyExc_TypeError, "UnusableMainLoop() takes no "
                                         "positional arguments");
        return NULL;
    }
    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|i", argnames,
                                     &set_as_default)) {
        return NULL;
    }

    mainloop = dbus_test_native_mainloop();
    if (mainloop && set_as_default) {
        if (!_dbus_bindings_module) {
            PyErr_SetString(PyExc_ImportError, "_dbus_bindings not imported");
            Py_DECREF(mainloop);
            return NULL;
        }
        function = PyObject_GetAttrString(_dbus_bindings_module,
                                          "set_default_main_loop");
        if (!function) {
            Py_DECREF(mainloop);
            return NULL;
        }
        result = PyObject_CallFunctionObjArgs(function, mainloop, NULL);
        Py_DECREF(function);
        if (!result) {
            Py_DECREF(mainloop);
            return NULL;
        }
    }
    return mainloop;
}

static PyMethodDef module_functions[] = {
    {"UnusableMainLoop", (PyCFunction)UnusableMainLoop,
     METH_VARARGS|METH_KEYWORDS, "Return a main loop that fails to attach"},
    {NULL, NULL, 0, NULL}
};

PyMODINIT_FUNC
initdbus_py_test(void)
{
    PyObject *this_module;

    if (import_dbus_bindings("dbus_py_test") < 0) return;
    this_module = Py_InitModule3 ("dbus_py_test", module_functions, "");
    if (!this_module) return;
}

/* vim:set ft=c cino< sw=4 sts=4 et: */
