.\"
.\" "$Id: cupstestppd.man,v 1.5 2003/08/01 19:42:43 mike Exp $"
.\"
.\"   cupstestppd man page for the Common UNIX Printing System (CUPS).
.\"
.\"   Copyright 1997-2003 by Easy Software Products.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Easy Software Products and are protected by Federal
.\"   copyright law.  Distribution and use rights are outlined in the file
.\"   "LICENSE.txt" which should have been included with this file.  If this
.\"   file is missing or damaged please contact Easy Software Products
.\"   at:
.\"
.\"       Attn: CUPS Licensing Information
.\"       Easy Software Products
.\"       44141 Airport View Drive, Suite 204
.\"       Hollywood, Maryland 20636-3111 USA
.\"
.\"       Voice: (301) 373-9603
.\"       EMail: cups-info@cups.org
.\"         WWW: http://www.cups.org
.\"
.TH cupstestppd 1 "Common UNIX Printing System" "1 August 2003" "Easy Software Products"
.SH NAME
cupstestppd \- test conformance of ppd files
.SH SYNOPSIS
.B cupstestppd
[ -q ] [-r] [ -v[v] ] filename.ppd[.gz] [ ... filenameN.ppd[.gz] ]
.br
.B cupstestppd
[ -q ] [-r] [ -v[v] ] -
.SH DESCRIPTION
\fIcupstestppd\fR tests the conformance of PPD files to the
Adobe PostScript Printer Description file format specification
version 4.3. It can also be used to list the supported options
and available fonts in a PPD file. The results of testing and
any other output are sent to the standard output.
.LP
The first form of \fIcupstestppd\fR tests one or more PPD files
on the command-line. The second form tests the PPD file provided
on the standard input.
.LP
The \fI-q\fR option specifies that no information should be displayed.
.LP
The \fI-r\fR option relaxes the PPD conformance requirements so
that common whitespace, control character, and formatting
problems are not treated as hard errors.
.LP
The \fI-v\fR option specifies that detailed conformance testing
results should be displayed rather than the concise PASS/FAIL/ERROR
status.
.LP
The \fI-vv\fR option specifies that all information in the PPD
file should be displayed in addition to the detailed conformance
testing results.
.LP
The \fI-q\fR, \fI-v\fR, and \fI-vv\fR options are mutually exclusive.
.SH EXIT STATUS
\fIcupstestppd\fR returns zero on success and non-zero on error. The
error codes are as follows:
.TP 5
1
.br
Bad command-line arguments or missing PPD filename.
.TP 5
2
.br
Unable to open or read PPD file.
.TP 5
3
.br
The PPD file contains format errors that cannot be skipped.
.TP 5
4
.br
The PPD file does not conform to the Adobe PPD specification.
.SH EXAMPLES
The following command will test all PPD files under the current
directory and print the names of each file that does not
conform:
.nf

    find . -name \\*.ppd \\! -exec cupstestppd -q '{}' \\; -print

.fi
The next command tests all PPD files under the current directory
and print detailed conformance testing results for the files
that do not conform:
.nf

    find . -name \\*.ppd \\! -exec cupstestppd -q '{}' \\; \\
        -exec cupstestppd -v '{}' \\;

.fi
.SH SEE ALSO
CUPS Software Administrators Manual,
CUPS Software Programmers Manual,
http://localhost:631/documentation.html,
Adobe PostScript Printer Description File Format Specification, Version 4.3.
.SH COPYRIGHT
Copyright 1993-2003 by Easy Software Products, All Rights Reserved.
.\"
.\" End of "$Id: cupstestppd.man,v 1.5 2003/08/01 19:42:43 mike Exp $".
.\"
