.\"
.\" "$Id: lpinfo.man 11923 2014-06-12 12:55:34Z msweet $"
.\"
.\" lpinfo man page for CUPS.
.\"
.\" Copyright 2007-2014 by Apple Inc.
.\" Copyright 1997-2006 by Easy Software Products.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH lpinfo 8 "CUPS" "12 June 2014" "Apple Inc."
.SH NAME
lpinfo \- show available devices or drivers
.SH SYNOPSIS
.B lpinfo
[
.B \-E
] [
.B \-U
.I username
] [
\fB\-h \fIserver\fR[\fB:\fIport\fR]
] [
.B \-l
] [
.B \-\-device\-id
.I device-id-string
] [
.B \-\-exclude\-schemes
.I scheme-list
] [
.B \-\-include\-schemes
.I scheme-list
] [
.B \-\-language
.I locale
] [
.B \-\-make\-and\-model
.I name
] [
.B \-\-product
.I name
]
.B \-m
.br
.B lpinfo
[
.B \-E
] [
.B \-U
.I username
] [
\fB\-h \fIserver\fR[\fB:\fIport\fR]
] [
.B \-l
] [
.B \-\-exclude\-schemes
.I scheme-list
] [
.B \-\-include\-schemes
.I scheme-list
] [
.B \-\-timeout
.I seconds
]
.B \-v
.SH DESCRIPTION
\fBlpinfo\fR lists the available devices or drivers known to the CUPS server.
The first form (\fI-m\fR) lists the available drivers, while the second form (\fI-v\fR) lists the available devices.
.SH OPTIONS
\fBlpinfo\fR accepts the following options:
.TP 5
.B \-E
Forces encryption when connecting to the server.
.TP 5
\fB\-U \fIusername\fR
Sets the username to use when connecting to the server.
.TP 5
\fB\-h \fIserver\fR[\fB:\fIport\fR]
Selects an alternate server.
.TP 5
.B \-l
Shows a "long" listing of devices or drivers.
.TP 5
\fB\-\-device\-id \fIdevice-id-string\fR
Specifies the IEEE-1284 device ID to match when listing drivers with the \fI\-m\fR option.
.TP 5
\fB\-\-exclude\-schemes \fIscheme-list\fR
Specifies a comma-delimited list of device or PPD schemes that should be excluded from the results.
Static PPD files use the "file" scheme.
.TP 5
\fB\-\-include\-schemes \fIscheme-list\fR
Specifies a comma-delimited list of device or PPD schemes that should be included in the results.
Static PPD files use the "file" scheme.
.TP 5
\fB\-\-language \fIlocale\fR
Specifies the language to match when listing drivers with the \fI\-m\fR option.
.TP 5
\fB\-\-make\-and\-model \fIname\fR
Specifies the make and model to match when listing drivers with the \fI\-m\fR option.
.TP 5
\fB\-\-product \fIname\fR
Specifies the product to match when listing drivers with the \fI\-m\fR option.
.TP 5
\fB\-\-timeout \fIseconds\fR
Specifies the timeout when listing devices with the \fI\-v\fR option.
.SH CONFORMING TO
The \fIlpinfo\fR command is unique to CUPS.
.SH EXAMPLES
List all devices:
.nf

    lpinfo \-v

.fi
List all drivers:
.nf

    lpinfo \-m

.fi
List drivers matching "HP LaserJet":
.nf

    lpinfo \-\-make\-and\-model "HP LaserJet" \-m
.fi
.SH SEE ALSO
.BR lpadmin (8),
CUPS Online Help (http://localhost:631/help)
.SH COPYRIGHT
Copyright \[co] 2007-2014 by Apple Inc.
.\"
.\" End of "$Id: lpinfo.man 11923 2014-06-12 12:55:34Z msweet $".
.\"
